<?php if( ! defined('BASEPATH')) exit ('No direct script access allowed');

class Purchase_requests extends MY_Controller{
	
	#===============================================
	var $companyID;
	var $branchID;
	var $createdBY;
	var $fiscal_start_date;
	var $fiscal_end_date;
	var $statusArray = array();
	
	public function __construct(){
		parent::__construct();

		$this->check_access_right();
		
		#---------------- Checking Financial year is enabled / closed-----------------#
		$method_array = array('add','edit','delete','remove_so_item','update');
		fiscal_status($this->uri->segment(2),$method_array,"purchase_requests/report");
		#---------------- Checking Financial year is enabled / closed-----------------#

		$this->companyID = $this->session->userdata('company_id');
		$this->branchID = $this->session->userdata('under_id');
		$this->createdBY = $this->session->userdata('id');

		$fiscals = $this->dms->get_fiscal_year();
		$this->fiscal_start_date = $fiscals['start_date'];
		$this->fiscal_end_date = $fiscals['end_date'];

		$this->statusArray[0] = '<span class="pending">'.$this->lang->line('pending').'</span>';
		$this->statusArray[1] = '<span class="pending">'.$this->lang->line('pending').'</span>';
		$this->statusArray[2] = '<span class="rejected">'.$this->lang->line('rejected').'</span>';
		$this->statusArray[3] = '<span class="approved">'.$this->lang->line('approved').'</span>';
		$this->statusArray[4] = '<span class="approved">'.$this->lang->line('approved').'</span>';
		$this->statusArray[5] = '<span class="approved">'.$this->lang->line('approved').'</span>';
		$this->statusArray[6] = '<span class="approved">'.$this->lang->line('approved').'</span>';
	}
	
	#===============================================
	
	public function add(){
		
		$this->template->title($this->lang->line('purchase-request'));
		$this->template->main_heading($this->lang->line('purchase-request'));
		$this->template->breadcrumb(array($this->lang->line('purchase-request') => 'no_link',$this->lang->line('my-request') => 'purchase_requests/my_requests'));	
		$units=array();
		
		$this->load->library('Stock');
		$this->load->model('purchase/Purchase_request_model','purchase_request');
		$this->load->model('customers/Customer_master_model','customer_master');
		#----get all stock items--------------------------------
		$customers = array();
		
		$customers = $this->customer_master->listing(array('conditions'=>array('branch_id'=>$this->branchID,'status !='=>0)));
		$args = array();
		$args['select'] = array('id','item_code','item_name');
		$items = $this->stock->get_stock_items($args);		

		$items[''] = 'Select';ksort($items);
		$units[''] = 'Select';
		ksort($units);
		$customers[''] = 'Select';
		ksort($customers);		
		$toDay = date('Y-m-d');

		$args = array();
		$args['conditions'] = array('dpr.requested_by'=>$this->createdBY);
		$args['order_by'] = 'dpr.request_date';
		$args['order'] = 'desc';
		$args['num_rows'] = 1;
		$total_requests = $this->purchase_request->get_purchase_request($args);
		
		$myRequestNo = $total_requests+1;

		$customerEnabled=0;
		$args = array();
		$args['columns'] = array('id','branch_id','designation_id','department_id');
		$args['conditions'] = array('id'=>$this->createdBY);
		$userDetails = $this->dms->get_users($args)[$this->createdBY];
		$RequestedTo=0;
		if(!empty($userDetails)){
			
			$departmentID = $userDetails['department_id'];
			$designationID = $userDetails['designation_id'];
			$userBranch = $userDetails['branch_id'];
			$RequestedTo = $this->dms->get_main_branch();
			if(($departmentID == 0 && ($designationID > 3 && $designationID <= 6))){
				$RequestedTo = $userBranch;
			}
			#if(($departmentID == 0 && $designationID == 3) || ($departmentID != 0 )){#&&$designationID== 1
				#$RequestedTo = $this->dms->get_main_branch();# get main branch id
			#}else{
			#	$RequestedTo = $userBranch;
			#}
		}
		
		$requestNumber = $this->purchase_request->get_request_number(array('requested_to'=>$RequestedTo));
		$tempRequests = $this->purchase_request->get_temp_data(array('requested_by'=>$this->createdBY));
				
		if(isset($_POST['add_item'])){

			$this->form_validation->set_rules('item_id','lang:item-name','required|xss_clean');
			$this->form_validation->set_rules('qty','lang:quantity','required|xss_clean');
			$this->form_validation->set_rules('unit_id','lang:unit','required|xss_clean');

			if($this->input->post('item_id')){
				$units = $this->stock->get_units($this->input->post('item_id'));
			}
			if($this->form_validation->run('add_item') === true){
				$postedValues = $this->input->post(NULL,true);
				$tempCheck = $this->purchase_request->get_temp_data(array('requested_by'=>$this->createdBY,'item_id'=>$postedValues['item_id']));
				if(empty($tempCheck)){
					if($this->purchase_request->save_temp_data(array('requested_by'=>$this->createdBY,'item_id'=>$postedValues['item_id'],'qty'=>$postedValues['qty'],'unit_id'=>$postedValues['unit_id']))){
						redirect(base_url('purchase_requests/add'));
					}
				}
			}
		}
		
		if(isset($_POST['post_request'])){
			if(($departmentID == 0 && ($designationID > 3 && $designationID <= 6))){
				$this->form_validation->set_rules('customer_id','lang:customer','required|xss_clean');
			}else{
				$this->form_validation->set_rules('customer_id','lang:customer','xss_clean');
			}
			
			$this->form_validation->set_rules('request_no','lang:item-name','required|xss_clean');
			$this->form_validation->set_rules('request_date','lang:requested-on','xss_clean|required|is_date|valid_date');
			$this->form_validation->set_rules('delivery_date','lang:delivery-on','xss_clean|is_date');
			$this->form_validation->set_rules('remarks','lang:remarks','xss_clean');
			
			if($this->form_validation->run('post_request') === true){
				
				$requestDate = date('Y-m-d');
				$deliveryDate = '0000-00-00';
				$remarks = $this->input->post('remarks');
				if(($departmentID == 0 && ($designationID > 3 && $designationID <= 6))){
					$customer_id = $this->input->post('customer_id');
				}else{
					$customer_id = 0;
				}
				$continue=1;
				if(!empty($this->input->post('delivery_date'))){
					if(strtotime($this->input->post('delivery_date')) >= strtotime($requestDate)){
						$deliveryDate = date('Y-m-d',strtotime($this->input->post('delivery_date')));
						$continue=1;
					}else{
						$this->message->set($this->lang->line('select-valid-delivery-date'),'e');
						$continue=0;
					}
				}
				if(empty($RequestedTo)){
					$this->message->set($this->lang->line('purchase-request-not-send'),'e');
					$continue=0;					
				}
				if($continue==1){
				if($this->purchase_request->save_request(array('company_id'=>$this->companyID,'customer_id'=>$customer_id,'requested_by'=>$this->createdBY,'requested_to'=>$RequestedTo,'request_no'=>$requestNumber,'my_req_no'=>$myRequestNo,'request_date'=>$requestDate,'delivery_date'=>$deliveryDate,'remarks'=>$remarks,'req_status'=>0))){
					
					$requestID = $this->db->insert_id();
					foreach($tempRequests as $key=>$temp){
						if($this->purchase_request->save_request_items(array('pr_id'=>$requestID,'item_id'=>$temp['item_id'],'qty'=>$temp['qty'],'unit_id'=>$temp['unit_id']))){
							$this->purchase_request->delete_temp_data($temp['id']);
						}
					}
					$this->message->set($this->lang->line('purchase-request-posted'));
					redirect(base_url('purchase_requests/add'));
				}else{
					
					$this->message->set($this->lang->line('purchase-request-not-send'),'e');
				}
				}
			}
		}
		
		# view starts here--------------------------------
		$this->template->slice('dms/message');
		$this->template->slice('purchase/requests/new_request',array('request_no'=>$myRequestNo,'items'=>$items,'units'=>$units,'temp_requests'=>$tempRequests,'request_by'=>$this->createdBY,'designation_id'=>$designationID,'customers'=>$customers));
		$this->template->other_script('purchase/purchase_request');
		$this->template->render();
	}
	
	#===============================================
	
	public function remove_temp_item(){
		
		if(!$this->uri->segment(3)){ 
			redirect('users/logout');
		}
		$tempItemID = $this->uri->segment(3);
		
		if($this->if_exists('dms_purchase_request_temps',array('id'=>$tempItemID,'created_by'=>$this->createdBY)) === false){
			redirect('purchase_requests/add');
		}
		$this->load->model('purchase/Purchase_request_model','purchase_request');
		if($this->purchase_request->delete_temp_data($tempItemID)){
		}
		redirect('purchase_requests/add');
	}
	
	#===============================================
	
	public function my_requests(){
		
		$this->template->title($this->lang->line('purchase-request'));
		$this->template->main_heading($this->lang->line('purchase-request'));
		$this->template->breadcrumb(array($this->lang->line('purchase-request') => 'purchase_requests/add',$this->lang->line('my-request') => 'no_link'));
		$this->load->model('purchase/Purchase_request_model','purchase_request');
		$offset =0;$links=NULL;$conditions = array();$fromDate=NULL;$toDate=NULL;
		$config['uri_segment'] = 3;
		$offset = ($this->uri->segment(3))?$this->uri->segment(3):0;
		$config['base_url'] = base_url('purchase_requests/my_requests');
		$statusArray = $this->statusArray;
		$this->form_validation->set_rules('from_date','lang:from-date','xss_clean|required|valid_date');
		$this->form_validation->set_rules('to_date','lang:to-date','xss_clean|required|valid_date');
		if($this->form_validation->run() === true){
			
			$fromDate = date('Y-m-d',strtotime($this->input->post('from_date')));
			$toDate = date('Y-m-d',strtotime($this->input->post('to_date')));
			$conditions['dpr.request_date >='] = $fromDate;
			$conditions['dpr.request_date <='] = $toDate; 
			$config['uri_segment'] = 5;
			$config['base_url'] = base_url('purchase_requests/my_requests/'.$fromDate.'/'.$toDate);
			
		}else{
			if($this->uri->segment(3) && $this->uri->segment(4)){
				
				$fromDate = date('Y-m-d',strtotime($this->uri->segment(3)));
				$toDate = date('Y-m-d',strtotime($this->uri->segment(4)));
				$conditions['dpr.request_date >='] = $fromDate;
				$conditions['dpr.request_date <='] = $toDate;
				$config['uri_segment'] = 5;
				$offset = ($this->uri->segment(5))?$this->uri->segment(5):0;		
				$config['base_url'] = base_url('purchase_requests/my_requests/'.$fromDate.'/'.$toDate);	

			}
		}
		$conditions['dpr.requested_by'] = $this->createdBY;
		
		#--pagination-----------------------
		$this->load->library('Pagination');
		$config['per_page'] = $this->per_page();
		# Pagination Config Customizations
        $config['full_tag_open'] = '<ul class="pagination">';
        $config['full_tag_close'] = '</ul>';
        $config['first_link'] = 'First';
        $config['last_link'] = 'Last';
        $config['next_link'] = '&raquo;';
        $config['prev_link'] = '&laquo;';
        $config['cur_tag_open'] = '<li class="active"><a href="#">';
        $config['cur_tag_close'] = '</a></li>';
        $config['num_tag_open'] = '<li>';
        $config['num_tag_close'] = '</li>';
		$args = array();
		$args['conditions'] = $conditions;
		$args['order_by'] = 'dpr.request_date';
		$args['order'] = 'desc';
		$args['num_rows'] = 1;
		$config['total_rows'] = $this->purchase_request->get_purchase_request($args);
		$this->pagination->initialize($config);
		$links = $this->pagination->create_links();
		#--pagination-------------------------

		$args = array();
		$args['select'] = $args['select'] = array('dpr.id','dpr.requested_by','dpr.my_req_no as request_no','dpr.request_date','dpr.delivery_date','dpr.remarks','dpr.req_status','dpr.seen_status');
		$args['conditions'] = $conditions;
		$args['order_by'] = 'dpr.request_date';
		$args['order'] = 'desc';
		$args['limit'] = $config['per_page'];
		$args['offset'] = $offset;
		$purchase_requests = $this->purchase_request->get_purchase_request($args);

		if(empty($purchase_requests)){
			$this->message->set($this->lang->line('no-result-found'),'e');
		}else{
			foreach($purchase_requests as $key => $purchase_request){
				$requestID = $purchase_request['id'];
				if(empty($purchase_request['seen_status'])){
					if($this->purchase_request->update_request(array('seen_status'=>1),array('id'=>$requestID,'req_status >'=>1))){
						$purchase_requests[$key]['new'] = 1;
					}else{
						$purchase_requests[$key]['new'] = 0;
					}
				}
			}
		}
		
	
		# view starts here--------------------------------
		$this->template->slice('dms/message');
		$this->template->slice('date/between_date_search',array('from_date'=>$fromDate,'to_date'=>$toDate));
		$this->template->slice('purchase/requests/view_my_request',array('my_requests'=>$purchase_requests,'statusArray'=>$statusArray,'count'=>$offset+1,'links'=>$links,'from_date'=>$fromDate,'to_date'=>$toDate));
		$this->template->render();		
	}
	
	#===============================================
	
	public function edit(){
		
		if(!$this->uri->segment(3)){ 
			redirect('users/logout');
		}
		$requestID = $this->uri->segment(3);
		if($this->if_exists('dms_purchase_requests',array('id'=>$requestID,'status'=>1)) === false){
			redirect('purchase_requests/my_requests');
		}
		$uriArray = $this->uri->uri_to_assoc(4);
		$uriString = $this->uri->assoc_to_uri($uriArray);
			
		$this->template->title($this->lang->line('purchase-request'));
		$this->template->main_heading($this->lang->line('purchase-request'));
		$this->template->breadcrumb(array($this->lang->line('purchase-request') => 'purchase_requests/add',$this->lang->line('my-request') => 'purchase_requests/my_requests',$this->lang->line('edit')=>'no_link',$this->lang->line('go-back')=>'purchase_requests/my_requests/'.$uriString));
				
		$this->load->model('purchase/Purchase_request_model','purchase_request');
		$this->load->model('customers/Customer_master_model','customer_master');
		$this->load->library('Stock');
		$units=array();
		$args = array();
		$args['select'] = array('id','item_code','item_name');
		$items = $this->stock->get_stock_items($args);	
				
		$items[''] = 'Select';ksort($items);
		$units[''] = 'Select';
		ksort($units);
		$toDay = date('Y-m-d');
		$statusArray = $this->statusArray;
		$customers = $this->customer_master->listing(array('conditions'=>array('branch_id'=>$this->branchID,'status !='=>0)));		
		$args = array();
		$args['columns'] = array('id','branch_id','designation_id','department_id');
		$args['conditions'] = array('id'=>$this->createdBY);
		$userDetails = $this->dms->get_users($args)[$this->createdBY];
		$RequestedTo=0;
		if(!empty($userDetails)){
			
			$departmentID = $userDetails['department_id'];
			$designationID = $userDetails['designation_id'];
			$userBranch = $userDetails['branch_id'];
		}
		#=====================================================
		
		if(isset($_POST['add_item'])){
			
			$this->form_validation->set_rules('item_id','lang:item-name','required|xss_clean');
			$this->form_validation->set_rules('qty','lang:quantity','required|xss_clean');
			$this->form_validation->set_rules('unit_id','lang:unit','required|xss_clean');
			if($this->input->post('item_id')){
				$units = $this->stock->get_units($this->input->post('item_id'));
			}
			if($this->form_validation->run('add_item') === true){
				
				$postedValues = $this->input->post(NULL,true);
				$args = array();
				$args['select'] = array('dpri.id');
				$args['conditions'] = array('dpr.id'=>$requestID,'dpri.item_id'=>$postedValues['item_id'],'dpri.status'=>1);
				$args['join'] = array('dms_purchase_request_items as dpri'=>'dpr.id=dpri.pr_id');
				$CheckExists = $this->purchase_request->get_purchase_request($args);
				
				if(empty($CheckExists)){
					if($this->purchase_request->save_request_items(array('pr_id'=>$requestID,'item_id'=>$postedValues['item_id'],'qty'=>$postedValues['qty'],'unit_id'=>$postedValues['unit_id']))){
						$this->message->set($this->lang->line('purchase-request-updated'));
						redirect(base_url('purchase_requests/edit/'.$requestID));
					}
				}else{
					$this->message->set($this->lang->line('same-request-exists'),'e');
				}
			}
		}
		
		#=====================================================
		
		$args = array();
		$args['select'] = array('dpr.requested_by','dpr.my_req_no as request_no','dpr.customer_id','dpr.request_date','dpr.delivery_date','dpr.remarks','dpr.req_status','dpri.id as dpri_id','dpri.item_id','dpri.qty','dpri.unit_id','im.item_code','im.item_name','um.formal_name','um.symbol');
		$args['conditions'] = array('dpr.id'=>$requestID,'dpri.status'=>1);
		$args['join'] = array('dms_purchase_request_items as dpri'=>'dpr.id=dpri.pr_id','item_master as im'=>'dpri.item_id=im.id','unit_master as um'=>'dpri.unit_id=um.id');
		$purchase_request = $this->purchase_request->get_purchase_request($args);
				
		
		if(isset($_POST['post_request'])){
			
			$this->form_validation->set_rules('delivery_date','lang:delivery-on','xss_clean');
			$this->form_validation->set_rules('remarks','lang:remarks','xss_clean');
			if(($departmentID == 0 && ($designationID > 3 && $designationID <= 6))){
				$this->form_validation->set_rules('customer_id','lang:customer','required|xss_clean');
			}else{
				$this->form_validation->set_rules('customer_id','lang:customer','xss_clean');
			}			
			if($this->form_validation->run('post_request') === true){

				$continue=1;
				$deliveryDate = '0000-00-00';
				$remarks = $this->input->post('remarks');
				if(($departmentID == 0 && ($designationID > 3 && $designationID <= 6))){
					$customer_id = $this->input->post('customer_id');
				}else{
					$customer_id = NULL;
				}			
				if(!empty($purchase_request)){
					
					$requestDate = $purchase_request[0]['request_date'];
					$reqStatus = $purchase_request[0]['req_status'];
				
					if(!empty($this->input->post('delivery_date'))){
						
						if(strtotime($this->input->post('delivery_date')) >= strtotime($requestDate)){
							$deliveryDate = date('Y-m-d',strtotime($this->input->post('delivery_date')));
							$continue=1;
						}else{
							$continue=0;
						}
					}
					if($continue == 1){
						
						if($this->purchase_request->update_request(array('delivery_date'=>$deliveryDate,'remarks'=>$remarks,'customer_id'=>$customer_id),array('id'=>$requestID))){
							$this->message->set($this->lang->line('purchase-request-updated'));
							redirect(base_url('purchase_requests/edit/'.$requestID));
						}
						
					}else{
						$this->message->set($this->lang->line('select-valid-delivery-date'),'e');
					}
				}else{
					$this->message->set($this->lang->line('purchase-request-not-updated'),'e');
				}
			}
		}
		
		#=====================================================
		
		# view starts here--------------------------------
		$this->template->slice('dms/message');
		$this->template->slice('purchase/requests/edit_request',array('items'=>$items,'units'=>$units,'purchase_requests'=>$purchase_request,'request_by'=>$this->createdBY,'designation_id'=>$designationID,'customers'=>$customers));
		$this->template->other_script('purchase/purchase_request');
		$this->template->render();				
	}
	
	#===============================================
	
	public function view(){
		
		
		if(!$this->uri->segment(3)){ 
			redirect('users/logout');
		}
		$requestID = $this->uri->segment(3);
		if($this->if_exists('dms_purchase_requests',array('id'=>$requestID,'status'=>1)) === false){
			redirect('purchase_requests/my_requests');
		}
		$uriArray = $this->uri->uri_to_assoc(4);
		$uriString = $this->uri->assoc_to_uri($uriArray);
				
		$this->template->title($this->lang->line('purchase-request'));
		$this->template->main_heading($this->lang->line('purchase-request'));
		$this->template->breadcrumb(array($this->lang->line('purchase-request') => 'purchase_requests/add',$this->lang->line('my-request') => 'purchase_requests/my_requests',$this->lang->line('view')=>'no_link',$this->lang->line('go-back')=>'purchase_requests/my_requests/'.$uriString));
		$this->load->model('purchase/Purchase_request_model','purchase_request');
		$this->load->library('Stock');
		$statusArray = $this->statusArray;
		$units=array();
		$args = array();
		$args['select'] = array('id','item_code','item_name');
		$items = $this->stock->get_stock_items($args);	
				
		$items[''] = 'Select';ksort($items);
		$units[''] = 'Select';
		ksort($units);
		$toDay = date('Y-m-d');
		
		
		$args = array();
		$args['select'] = array('dpr.id','dpr.requested_by','dpr.my_req_no as request_no','dpr.customer_id','dpr.request_date','dpr.delivery_date','dpr.remarks','dpr.req_status','dpr.update_remarks','dpr.updated_on','concat(u.fname," ",u.lname) as requested_user','u.branch_id','u.designation_id','u.department_id','dm.designation_name','dpri.item_id','dpri.unit_id','dpri.qty','im.item_code','im.item_name','um.symbol','um.formal_name','concat(up.fname," ",up.lname) as updated_user');
		
		$args['conditions'] = array('dpr.id'=>$requestID);
		$args['join'] = array('dms_purchase_request_items as dpri'=>'dpr.id=dpri.pr_id','users as u'=>'dpr.requested_by=u.id','designation_master as dm'=>'u.designation_id=dm.id','item_master as im'=>'dpri.item_id=im.id','unit_master as um'=>'dpri.unit_id=um.id','users as up'=>'dpr.updated_by=up.id');
		$purchase_request = $this->purchase_request->get_purchase_request($args);
			
		#=====================================================
		
		# view starts here--------------------------------
		$this->template->slice('dms/message');
		$this->template->slice('purchase/requests/view_request',array('items'=>$items,'units'=>$units,'purchase_requests'=>$purchase_request,'statusArray'=>$statusArray));
		$this->template->other_script('purchase/purchase_request');
		$this->template->render();			
	}
	
	#================================================
	
	public function remove_item(){
		
		if(!$this->uri->segment(3)){ 
			redirect('users/logout');
		}
		$reqItemID = $this->uri->segment(3);
		if($this->if_exists('dms_purchase_request_items',array('id'=>$reqItemID)) === false){
			redirect('purchase_requests/my_requests');
		}
		$this->load->model('purchase/Purchase_request_model','purchase_request');
		
		$args = array();
		$args['select'] = array('dpr.id','dpr.req_status');
		$args['conditions'] = array('dpri.id'=>$reqItemID);
		$args['join'] = array('dms_purchase_request_items as dpri'=>'dpr.id=dpri.pr_id');
		$purchaseRequest = $this->purchase_request->get_purchase_request($args);
		
		$requestStatus = $purchaseRequest[0]['req_status'];
		$requestID = $purchaseRequest[0]['id'];
		
		if($requestStatus == 3){
			$requestSts ='request-approved';
		}else if($requestStatus == 2){
			$requestSts ='request-rejected';
		}else{
			$requestSts ='request-approved';
		}
		if($requestStatus <= 1){
			if($this->purchase_request->delete_request_items($reqItemID	)){
				$this->message->set($this->lang->line('item-removed'));
			}
		}else{
			$this->message->set($this->lang->line($requestSts));
		}
		redirect(base_url('purchase_requests/edit/'.$requestID));
				
	}
		
	#===============================================
	
	public function delete(){
		
		if(!$this->uri->segment(3)){ 
			redirect('users/logout');
		}
		$requestID = $this->uri->segment(3);
		if($this->if_exists('dms_purchase_requests',array('id'=>$requestID,'status'=>1)) === false){
			redirect('purchase_requests/my_requests');
		}
		$this->load->model('purchase/Purchase_request_model','purchase_request');
		
		$args = array();
		$args['select'] = array('dpr.req_status');
		$args['conditions'] = array('dpr.id'=>$requestID,'dpr.status'=>1);
		$purchase_request = $this->purchase_request->get_purchase_request($args);
		
		if(!empty($purchase_request)){
			$requestStatus = $purchase_request[0]['req_status'];
			if($requestStatus == 3){
				$requestSts ='already-approved-request';
			}else if($requestStatus == 2){
				$requestSts ='already-rejected-request';
			}else{
				$requestSts ='already-approved-request';
			}			
			if($requestStatus == 0){
				
				if($this->purchase_request->update_request(array('status'=>0),array('id'=>$requestID))){
					$this->message->set($this->lang->line('purchase-request-deleted'));
				}
				
			}else{
				$this->message->set($this->lang->line($requestSts),'i');
			}
		}
		redirect(base_url('purchase_requests/my_requests'));		
	}
	
	#===============================================
	
	public function pending_requests(){
		
		$this->template->title($this->lang->line('pending-purchase-requests'));
		$this->template->main_heading($this->lang->line('pending-purchase-requests'));
		$this->template->breadcrumb(array($this->lang->line('purchase-request') => 'no_link',$this->lang->line('pending-purchase-requests') =>'no_link'));	
				
		$this->load->model('purchase/Purchase_request_model','purchase_request');
		$this->load->library('Stock');
		$this->load->library('Pagination');
		
		$offset=0;$links=NULL;
		
		$config['per_page'] = $this->per_page();
		# Pagination Config Customizations
        $config['full_tag_open'] = '<ul class="pagination">';
        $config['full_tag_close'] = '</ul>';
        $config['first_link'] = 'First';
        $config['last_link'] = 'Last';
        $config['next_link'] = '&raquo;';
        $config['prev_link'] = '&laquo;';
        $config['cur_tag_open'] = '<li class="active"><a href="#">';
        $config['cur_tag_close'] = '</a></li>';
        $config['num_tag_open'] = '<li>';
        $config['num_tag_close'] = '</li>';
		$config['base_url'] = base_url('purchase_requests/pending_requests');
		$offset = ($this->uri->segment(3))?$this->uri->segment(3):0;
		
		$args = array();
		$args['select'] = array('dpr.id');
		$args['conditions'] = array('dpr.requested_to'=>$this->branchID,'dpr.req_status <='=>1);
		$args['num_rows'] = 1;
		$config['total_rows'] = $this->purchase_request->get_purchase_request($args);
		
		$this->pagination->initialize($config);
		$links = $this->pagination->create_links();
		
		$statusArray = $this->statusArray;

		$args = array();
		$args['select'] = array('dpr.id','dpr.requested_by','dpr.request_no','dpr.request_date','dpr.delivery_date','dpr.remarks','dpr.req_status','concat(u.fname," ",u.lname) as requested_user','u.branch_id','u.designation_id','u.department_id','dm.designation_name');
		$args['conditions'] = array('dpr.requested_to'=>$this->branchID,'dpr.req_status <='=>1);
		$args['join'] = array('users as u'=>'dpr.requested_by=u.id','designation_master as dm'=>'u.designation_id=dm.id');
		$args['limit'] = $config['per_page'];
		$args['offset'] = $offset;
		$pending_requests = $this->purchase_request->get_purchase_request($args);
		$this->purchase_request->update_request(array('req_status'=>1),array('req_status'=>0));
		
		if(empty($pending_requests)){
			$this->message->set($this->lang->line('empty-pending-list'),'i');
		}
		
		# view starts here--------------------------------
		$this->template->slice('dms/message');
		$this->template->slice('purchase/requests/pending_requests',array('links'=>$links,'statusArray'=>$statusArray,'count'=>$offset+1,'pending_requests'=>$pending_requests));
		$this->template->other_script('purchase/purchase_request');
		$this->template->slice('dms/modals/more_details');
		$this->template->render();					
	}
	
	#==============================================
	
	public function update(){
		
		if(!$this->uri->segment(3)){ 
			redirect('users/logout');
		}
		$requestID = $this->uri->segment(3);
		if($this->if_exists('dms_purchase_requests',array('id'=>$requestID,'status'=>1)) === false){
			redirect('purchase_requests/pending_requests');
		}
		$offset = ($this->uri->segment(5))?$this->uri->segment(5):NULL;
		$prevLink = 'no_link';
		if($this->uri->segment(4)){
			if($this->uri->segment(4) == 'pr'){
				$prevLink ='purchase_requests/pending_requests';
			}else if($this->uri->segment(4) == 'ar'){
				$prevLink = 'purchase_requests/approved_requests';
			}else if($this->uri->segment(4) == 'rr'){
				$prevLink = 'purchase_requests/rejected_requests';
			}
		}
		$this->template->title($this->lang->line('pending-purchase-requests'));
		$this->template->main_heading($this->lang->line('pending-purchase-requests'));
		$this->template->breadcrumb(array($this->lang->line('purchase-request') => 'no_link',$this->lang->line('pending-purchase-requests')=>$prevLink,$this->lang->line('update') =>'no_link'));	

		$this->load->model('purchase/Purchase_request_model','purchase_request');
		$this->load->library('Stock');
		
		$statusArray = $this->statusArray;

		$updateStatus = array(''=>'select','2'=>'Rejected','3'=>'Approved');ksort($updateStatus);
		$args = array();
		$args['select'] = array('dpr.id','dpr.requested_by','dpr.request_no','dpr.customer_id','dpr.request_date','dpr.delivery_date','dpr.remarks','dpr.req_status','dpr.update_remarks','concat(u.fname," ",u.lname) as requested_user','u.branch_id','u.designation_id','u.department_id','dm.designation_name','dpri.item_id','dpri.unit_id','dpri.qty','im.item_code','im.item_name','um.symbol','um.formal_name');
		$args['conditions'] = array('dpr.id'=>$requestID);
		$args['join'] = array('dms_purchase_request_items as dpri'=>'dpr.id=dpri.pr_id','users as u'=>'dpr.requested_by=u.id','designation_master as dm'=>'u.designation_id=dm.id','item_master as im'=>'dpri.item_id=im.id','unit_master as um'=>'dpri.unit_id=um.id');

		$pending_requests = $this->purchase_request->get_purchase_request($args);
		$requestStatus = $pending_requests[0]['req_status'];
		$this->form_validation->set_rules('update_status','lang:update-request','required');
		$this->form_validation->set_rules('update_remarks','lang:remarks','xss_clean');
		
		if($this->form_validation->run() === true){
			$postedStatus = $this->input->post('update_status');
			$postedRemarks = $this->input->post('update_remarks');
			if($postedStatus == 3){
				$redirectTo = 'purchase_requests/approved_requests/';
				$success_msg = 'request-approved';
			}else{
				$redirectTo = 'purchase_requests/rejected_requests/';
				$success_msg = 'request-rejected';
			}
			if(($requestStatus<=3)){
				$updateArray=array('update_remarks'=>$postedRemarks);
				if($requestStatus != $postedStatus){
					$updateArray['req_status'] =$postedStatus;
					$updateArray['updated_on'] = date('Y-m-d');
					$updateArray['updated_by'] = $this->createdBY;
				}
				if($this->purchase_request->update_request($updateArray,array('id'=>$requestID))){
					
					#-------------------------------------------------------------------
					$pending_request = $pending_requests[0];
					$customerID = $pending_request['customer_id'];
					if(!empty($customerID) && $postedStatus == 3){
						
						$cust_details = $this->stock->get_customer(2,$customerID,1);
						$this->purchase_request->my_update('customer_master',array('status'=>1),array('id'=>$customerID));
						$this->purchase_request->my_update('dms_ledgers',array('status'=>1),array('id'=>$cust_details['ledger_id']));

					}
					#-------------------------------------------------------------------
					
					$this->message->set($this->lang->line($success_msg));
					redirect($redirectTo);
				}else{
					$this->message->set($this->lang->line('purchase-request-not-updated'));
				}
			}
		}
		
		# view starts here--------------------------------
		$this->template->slice('dms/message');
		$this->template->slice('purchase/requests/update_request',array('statusArray'=>$statusArray,'purchase_requests'=>$pending_requests,'updateStatus'=>$updateStatus));
		$this->template->other_script('purchase/purchase_request');
		#$this->template->slice('dms/modals/more_details');
		$this->template->render();			
		
		#redirect('purchase_requests/pending_requests/'.$offset);
	}
	
	#==============================================
	
	public function approved_requests(){
		
		$this->template->title($this->lang->line('approved-purchase-requests'));
		$this->template->main_heading($this->lang->line('approved-purchase-requests'));
		$this->template->breadcrumb(array($this->lang->line('purchase-request') => 'no_link',$this->lang->line('approved-purchase-requests') =>'no_link'));	
				
		$this->load->model('purchase/Purchase_request_model','purchase_request');
		$this->load->library('Stock');
		$this->load->library('Pagination');
		
		$offset=0;$links=NULL;
		
		$config['per_page'] = $this->per_page();
		# Pagination Config Customizations
        $config['full_tag_open'] = '<ul class="pagination">';
        $config['full_tag_close'] = '</ul>';
        $config['first_link'] = 'First';
        $config['last_link'] = 'Last';
        $config['next_link'] = '&raquo;';
        $config['prev_link'] = '&laquo;';
        $config['cur_tag_open'] = '<li class="active"><a href="#">';
        $config['cur_tag_close'] = '</a></li>';
        $config['num_tag_open'] = '<li>';
        $config['num_tag_close'] = '</li>';
		$config['base_url'] = base_url('purchase_requests/approved_requests');
		$offset = ($this->uri->segment(3))?$this->uri->segment(3):0;
		
		$args = array();
		$args['select'] = array('dpr.id');
		$args['conditions'] = array('dpr.requested_to'=>$this->branchID,'dpr.req_status'=>3);
		$args['num_rows'] = 1;
		$config['total_rows'] = $this->purchase_request->get_purchase_request($args);
		
		$this->pagination->initialize($config);
		$links = $this->pagination->create_links();
		
		$statusArray = $this->statusArray;
				
		$args = array();
		$args['select'] = array('dpr.id','dpr.requested_by','dpr.request_no','dpr.request_date','dpr.delivery_date','dpr.remarks','dpr.req_status','concat(u.fname," ",u.lname) as requested_user','u.branch_id','u.designation_id','u.department_id','dm.designation_name');
		$args['conditions'] = array('dpr.requested_to'=>$this->branchID,'dpr.req_status >='=>3);
		$args['join'] = array('users as u'=>'dpr.requested_by=u.id','designation_master as dm'=>'u.designation_id=dm.id');
		$args['limit'] = $config['per_page'];
		$args['offset'] = $offset;
		$pending_requests = $this->purchase_request->get_purchase_request($args);
		
		if(empty($pending_requests)){
			$this->message->set($this->lang->line('empty-approved-list'),'i');
		}
				
		# view starts here--------------------------------
		$this->template->slice('dms/message');
		$this->template->slice('purchase/requests/approved_requests',array('links'=>$links,'statusArray'=>$statusArray,'count'=>$offset+1,'pending_requests'=>$pending_requests));
		$this->template->other_script('purchase/purchase_request');
		$this->template->slice('dms/modals/more_details');
		$this->template->render();			
	}
	
	#==============================================
	
	public function rejected_requests(){
		
		$this->template->title($this->lang->line('rejected-purchase-requests'));
		$this->template->main_heading($this->lang->line('rejected-purchase-requests'));
		$this->template->breadcrumb(array($this->lang->line('purchase-request') => 'no_link',$this->lang->line('rejected-purchase-requests') =>'no_link'));	

		$this->load->model('purchase/Purchase_request_model','purchase_request');
		$this->load->library('Stock');
		$this->load->library('Pagination');

		$offset=0;$links=NULL;

		$config['per_page'] = $this->per_page();
		# Pagination Config Customizations
        $config['full_tag_open'] = '<ul class="pagination">';
        $config['full_tag_close'] = '</ul>';
        $config['first_link'] = 'First';
        $config['last_link'] = 'Last';
        $config['next_link'] = '&raquo;';
        $config['prev_link'] = '&laquo;';
        $config['cur_tag_open'] = '<li class="active"><a href="#">';
        $config['cur_tag_close'] = '</a></li>';
        $config['num_tag_open'] = '<li>';
        $config['num_tag_close'] = '</li>';
		$config['base_url'] = base_url('purchase_requests/rejected_requests');
		$offset = ($this->uri->segment(3))?$this->uri->segment(3):0;

		$args = array();
		$args['select'] = array('dpr.id');
		$args['conditions'] = array('dpr.requested_to'=>$this->branchID,'dpr.req_status'=>2);
		$args['num_rows'] = 1;
		$config['total_rows'] = $this->purchase_request->get_purchase_request($args);

		$this->pagination->initialize($config);
		$links = $this->pagination->create_links();
		$statusArray = $this->statusArray;

		$args = array();
		$args['select'] = array('dpr.id','dpr.requested_by','dpr.request_no','dpr.request_date','dpr.delivery_date','dpr.remarks','dpr.req_status','concat(u.fname," ",u.lname) as requested_user','u.branch_id','u.designation_id','u.department_id','dm.designation_name');
		$args['conditions'] = array('dpr.requested_to'=>$this->branchID,'dpr.req_status'=>2);
		$args['join'] = array('users as u'=>'dpr.requested_by=u.id','designation_master as dm'=>'u.designation_id=dm.id');
		$args['limit'] = $config['per_page'];
		$args['offset'] = $offset;
		$pending_requests = $this->purchase_request->get_purchase_request($args);

		if(empty($pending_requests)){
			$this->message->set($this->lang->line('empty-rejected-list'),'i');
		}

		# view starts here--------------------------------
		$this->template->slice('dms/message');
		$this->template->slice('purchase/requests/rejected_requests',array('links'=>$links,'statusArray'=>$statusArray,'count'=>$offset+1,'pending_requests'=>$pending_requests));
		$this->template->other_script('purchase/purchase_request');
		$this->template->slice('dms/modals/more_details');
		$this->template->render();			
	}

	#==============================================	

	public function approved_list(){

		if(!$this->uri->segment(3)){
			redirect('users/logout');
		}
		$requestID = $this->uri->segment(3);
		if($this->if_exists('dms_purchase_requests',array('id'=>$requestID,'status'=>1)) === false){
			redirect('purchase_requests/approved_requests');
		}
		$this->load->model('purchase/Purchase_request_model','purchase_request');
		$this->load->model('sales/Sales_model','sales');
		$this->load->model('vouchers/Voucher_model','vouchers');
		$this->load->library('Stock');
		
		$offset = ($this->uri->segment(5))?$this->uri->segment(5):NULL;
		
		$args = array();
		$args['columns'] = array('id');
		$args['conditions'] = array('status'=>-1,'created_by'=>$this->createdBY);
		$args['numrows'] = 1;
		$salesEntry = $this->sales->get_bills($args);
		
		if(empty($salesEntry)){
			$args = array();
			$args['select'] = array('dpr.id','dpr.company_id','dpr.request_no','dpr.requested_by','dpr.requested_to','dpr.request_date','dpr.delivery_date','dpr.remarks','dpr.req_status','dpr.update_remarks','dpr.updated_on','dpr.updated_by','dpr.status','dpri.id as dpri_id','dpri.item_id','dpri.qty','dpri.unit_id','dpri.status');

			$args['conditions'] = array('dpr.id'=>$requestID,'dpr.status'=>1,'dpri.status'=>1);
			$args['join'] = array('dms_purchase_request_items as dpri'=>'dpr.id=dpri.pr_id');
			$requestDtls = $this->purchase_request->get_purchase_request($args);
			$group_id = $this->stock->get_group_id('dms_sales_items');
			
			$args = array();
			$args['select'] = array('id');
			$args['conditions'] = array('group_id'=>$group_id);
			$checkSales = $this->sales->get_bills($args);
			$requestedBy = $requestDtls[0]['requested_by'];
			$requestUser = $this->dms->get_users(array('columns'=>array('id','designation_id','branch_id'),'conditions'=>array('id'=>$requestedBy)));
			$customerType=2;$userID = 0;$customerID=0;
			$designationID = $requestUser[$requestedBy]['designation_id'];
			if(in_array($designationID,array(1,3))){
				$customerType = $designationID;
				$customerID = $requestUser[$requestedBy]['branch_id'];
			}else{
				$userID = $requestedBy;
			}

				if(empty($checkSales)){
					$newBillNum = $this->sales->next_bill_no(6)['bill_no'];

					if($this->sales->insert('dms_sales',array('vtype_id'=>6,'branch_id'=>$this->branchID,'bill_no'=>$newBillNum,'group_id'=>$group_id,'bill_date'=>date('Y-m-d'),'sid'=>$requestID,'s_status'=>1,'customer_type_id'=>$customerType,'customer_id'=>$customerID,'user_id'=>$userID,'status'=>-1))){
						
						foreach($requestDtls as $pKey=>$request){
							if($this->sales->insert('dms_sales_items',array('group_id'=>$group_id,'item_id'=>$request['item_id'],'qty'=>$request['qty'],'unit_id'=>$request['unit_id'],'status'=>-1,'item_status'=>2))){
							}
										
						}
						redirect('sales/add');
					}else{
						$this->message->set($this->lang->line('sales-bill-pending'));
					}
				}else{
					$this->message->set($this->lang->line('sales-bill-pending'));
				}
			
		}else{
			$this->message->set($this->lang->line('sales-bill-pending'));
		}
		redirect('purchase_requests/approved_requests/'.$offset);
	}
	
	#==============================================			
}
?>