<?php if( !defined('BASEPATH'))exit('No direct script access allowed');

class Purchase_upload_excel extends MY_Controller{

	public function __construct()
	{
		parent ::__construct();
		$this->check_access_right();
		$this->load->library('My_excel');
		$this->load->model('purchase/Purchase_model','purchase');
		$this->load->model('purchase/Purchase_upload_model','purchaseupload');
	}

	public function upload_bill()
	{
		$this->load->library('Stock');
		$continue = 1;
		$error_bill_no =array();

		if($this->uri->segment(3) !='')
		{
			$error_bill_no = $this->uri->uri_to_assoc(3);
			$this->uri->rsegment(3);
		}
		
		if($this->input->post('upload',TRUE))
		{
			$this->form_validation->set_rules('purcahse_file','lang:purchase-bill','callback_file_empty');
			if($this->form_validation->run() == TRUE)
			{
				if($_FILES['purcahse_file']['name'] != '')
				{
					$this->load->library('Image');
					$file_name = $this->image->random_name($_FILES['purcahse_file']['name']);
					$fpart1 ="bill_".date('YmdHis');
					$ext = pathinfo($_FILES['purcahse_file']['name'], PATHINFO_EXTENSION);
					$file_name = $fpart1.".".$ext;
					if($ext != 'xlsx' && $ext != 'xls')
					{
						$this->message->set($this->lang->line('purchase-invalid-filetype'),'e');
					}
					else
					{
						#file uploading
						$config['upload_path'] =  FCPATH.'assets/files/purchase/';
						$config['allowed_types'] = 'xlsx|xls';
						$config['max_size']	= '2048';
						$config['file_name'] = $file_name;
						$this->load->library('Upload');
						$this->upload->initialize($config);

						if($this->upload->do_upload('purcahse_file'))
						{
							$data['purcahse_file'] = $file_name;
							$file = FCPATH."assets/files/purchase/".$file_name;
							if (!empty($file) && file_exists($file))
							{
								$this->my_excel->excelObj = $this->my_excel->excelRdr->load($file);
								$last_row = $this->my_excel->excelObj->getActiveSheet()->getHighestDataRow();
								$i=2;
								$bill_no_temp = "";
								$invalid_dates = array('','0000-00-00','1970-01-01','0',' ');

								#----------cess %
								$cess = $this->stock->get_cess();

								#----------godown id
								$godown_id = $this->purchaseupload->get_main_godown_id();

								#------------presumptive tax checking
								$presumptive_tax = $this->stock->get_tax_type();
								$voucher_amount = $vat_amount = $cess_amount = $freight_amount = $other_expense_amount = $cst_amount = 0;

								for($i=2;$i<=$last_row;$i++)
								{
									$error_rows = array();

									#-----------------read from excel
									$bill_no = Trim($this->my_excel->excelObj->getActiveSheet()->getCell('A'.$i)->getValue());//bill no

									#-------------bill date
									$d_date = $this->my_excel->excelObj->getActiveSheet()->getCell('B'.$i)->getValue();
									$d_date = PHPExcel_Style_NumberFormat::toFormattedString($d_date, 'YYYY-MM-DD');
									if (!preg_match("/^[0-9]{4}-(0[1-9]|1[0-2])-(0[1-9]|[1-2][0-9]|3[0-1])$/",$d_date)){
									   $d_date='';
									}
									$d_date = date('Y-m-d',strtotime($d_date));

									$invoice_no = Trim($this->my_excel->excelObj->getActiveSheet()->getCell('C'.$i)->getValue());//invoice no

									#--------------invoice date
									$in_date = $this->my_excel->excelObj->getActiveSheet()->getCell('D'.$i)->getValue();
									$in_date = PHPExcel_Style_NumberFormat::toFormattedString($in_date, 'YYYY-MM-DD');
									if (!preg_match("/^[0-9]{4}-(0[1-9]|1[0-2])-(0[1-9]|[1-2][0-9]|3[0-1])$/",$in_date))
									{
									   $in_date='';
									}
									$in_date = date('Y-m-d',strtotime($in_date));

									$vendor = Trim($this->my_excel->excelObj->getActiveSheet()->getCell('E'.$i)->getValue());//vendor

									$item_code = Trim($this->my_excel->excelObj->getActiveSheet()->getCell('F'.$i)->getValue());//item code

									$item_name = Trim($this->my_excel->excelObj->getActiveSheet()->getCell('G'.$i)->getValue());//item name

									$item_qty = Trim($this->my_excel->excelObj->getActiveSheet()->getCell('H'.$i)->getValue());//qty

									$item_unit = Trim($this->my_excel->excelObj->getActiveSheet()->getCell('I'.$i)->getValue());//unit

									$item_rate = Trim($this->my_excel->excelObj->getActiveSheet()->getCell('J'.$i)->getValue());//rate

									$item_amount = Trim($this->my_excel->excelObj->getActiveSheet()->getCell('K'.$i)->getValue());//amount

									$item_discount_amount = Trim($this->my_excel->excelObj->getActiveSheet()->getCell('L'.$i)->getValue());//discount amount

									$cgst_amt = Trim($this->my_excel->excelObj->getActiveSheet()->getCell('M'.$i)->getValue());//cgst amount

									$sgst_amt = Trim($this->my_excel->excelObj->getActiveSheet()->getCell('N'.$i)->getValue());//sgst amount

									$freight = Trim($this->my_excel->excelObj->getActiveSheet()->getCell('O'.$i)->getValue());//bill freight

									$other_expense = Trim($this->my_excel->excelObj->getActiveSheet()->getCell('P'.$i)->getValue());//other expense

									$bill_discount_amt = Trim($this->my_excel->excelObj->getActiveSheet()->getCell('Q'.$i)->getValue());//bill discount amount

									$payment_type = Trim($this->my_excel->excelObj->getActiveSheet()->getCell('R'.$i)->getValue());// C => cash, Cr => credit, B => bank

									$pymnt_mod = Trim($this->my_excel->excelObj->getActiveSheet()->getCell('S'.$i)->getValue());//ledger_id

									$credit_period = getTrim($this->my_excel->excelObj->getActiveSheet()->getCell('T'.$i)->getValue());//credit period

									if(empty($bill_no) || in_array($d_date,$invalid_dates) || empty($invoice_no) || in_array($in_date,$invalid_dates) || empty($vendor) || empty($item_code) || empty($item_name) || empty($item_qty) || empty($item_unit))
									{
										if(empty($bill_no)){
											$error_rows['bill_no'] = $this->lang->line('invalid-bill-no');
										}
										if(in_array($d_date,$invalid_dates)){
											$error_rows['bill_date'] = $this->lang->line('invalid-bill-date');
										}
										if(empty($invoice_no)){
											$error_rows['invoice_no'] = $this->lang->line('invalid-invoice-no');
										}
										if(in_array($in_date,$invalid_dates)){
											$error_rows['invoice_date'] = $this->lang->line('invalid-invoice-date');
										}
										if(empty($vendor)){
											$error_rows['vendor'] = $this->lang->line('invalid-vendor');
										}
										if(empty($item_code)){
											$error_rows['item_code'] = $this->lang->line('invalid-item-code');
										}
										if(empty($item_name)){
											$error_rows['item_name'] = $this->lang->line('invalid-item-name');
										}
										if(empty($item_qty)){
											$error_rows['item_qty'] = $this->lang->line('invalid-item-qty');
										}
										if(empty($item_unit)){
											$error_rows['item_unit'] = $this->lang->line('invalid-item-unit');
										}
									}
									else
									{
										#----------------checking bill date is currnt finacual year/and closed financial year
										$bill_check = $this->purchaseupload->check_bill_date($d_date);
										$check_date = $this->form_validation->valid_date($d_date);

										$item_id = $this->purchaseupload->get_item_id($item_code,$item_name);//item id
										$unit_id = $this->purchaseupload->get_unit_id($item_unit);// unit id
										$vendor_id = $this->purchaseupload->get_vendor_id($vendor);//vendor id

										if((!empty($bill_check) || empty($check_date)) || empty($vendor_id) || empty($item_id) || empty($unit_id))
										{
											if(!empty($bill_check) || empty($check_date))
											{
												$error_rows['bill_date'] = $this->lang->line("bill-date-not-between-fiscal-year");
											}
											if(empty($vendor_id))
											{
												$error_rows['vendor_id'] = $this->lang->line("vendor-not-exist");
											}
											if(empty($item_id))
											{
												$error_rows['item_id'] = $this->lang->line("item-not-exist");
											}
											if(empty($unit_id))
											{
												$error_rows['unit_id'] = $this->lang->line("unit-not-exist");
											}
										}
										else
										{
											$purchase_item['item_id'] = $item_id;
											$purchase_item['godown_id'] = $godown_id;
											$purchase_item['qty'] = $item_qty;
											$purchase_item['unit_id'] = $unit_id;
											$purchase_item['rate'] = $item_rate;
											$iamount = $item_qty*$item_rate;
											$purchase_item['amount'] = $iamount;
											$purchase_item['cgst']=$this->stock->get_item_cgst($item_id);
                                            $purchase_item['sgst']=$this->stock->get_item_sgst($item_id);
                                            $purchase_item['cgst_amt'] = ($purchase_item['amount']*$purchase_item['cgst'])/100;
                                            $purchase_item['sgst_amt'] = ($purchase_item['amount']*$purchase_item['sgst'])/100;
                                                
                                            $vat_amount = $purchase_item['cgst_amt']+$purchase_item['sgst_amt'];
											$purchase_item['discount_per'] = round_this(($item_discount_amount * 100) / $item_amount);
											$purchase_item['discount_amt'] = $item_discount_amount;
										//	$purchase_item['cst'] = $cst;
											$purchase_item['item_status'] = 2;
											$payment_mode = $this->purchaseupload->get_payment_mode_id($payment_type,$pymnt_mod);

											//transaction started
											$this->db->trans_start();
											
											if(!$this->if_exists('dms_purchases',array('vtype_id' => 5,'branch_id' => $this->session->userdata('under_id'),'bill_no' => $bill_no,'bill_date' => $d_date)))
											{
                                                $purchase['vtype_id'] = 5;
												$purchase['branch_id'] = $this->session->userdata('under_id');
												$purchase['bill_no'] = $bill_no;
												$purchase['bill_date']= $d_date;
												$purchase['invoice_no'] = $invoice_no;
												$purchase['invoice_date'] = $in_date;
												$purchase['group_id'] = $purchase_item['group_id'] = $this->stock->get_group_id('dms_purchases');
												$purchase['p_status'] = -1;
												$purchase['vendor_id'] = $vendor_id;
												$purchase['bill_discount_amt'] = $bill_discount_amt;
												$purchase['bill_freight'] = $freight;
												$purchase['other_expense'] = $other_expense;
												$purchase['cess'] = $cess;
												$purchase['payment_mode'] = $payment_mode;
												$purchase['cr_period'] = $credit_period;
												$this->purchaseupload->f_save('dms_purchases',$purchase);
											}

											#----------total calculation
											$voucher_amount += ($iamount - $item_discount_amount + $vat_amount);
											$freight_amount += $freight;
											$other_expense_amount += $other_expense;

											if(isset($purchase_item['group_id']) && !empty($purchase_item['group_id']))
											{
												#------------checking same item,godown,unit with same group_id exists
												$purchase_temp_item_result = $this->purchase->get_purchases(array('columns' => array('b.id'),'conditions' => array('b.group_id' => $purchase_item['group_id'],'item_id' => $item_id,'godown_id' => $purchase_item['godown_id'],'unit_id' => $unit_id,'a.status !=' => 0,'b.status !=' => 0,'b.item_status >' => 0),'numrows' => true));
												if($purchase_temp_item_result == 0)
												{
													$purchase_items_id = $this->purchaseupload->f_save('dms_purchase_items1',$purchase_item);
													if($purchase_items_id)
													{
														#--------------adding stock balance in dms_stocks
														$stock_bal_temp = $this->stock->unit_conversion($item_id,$unit_id,$item_qty,$purchase_item['rate'],$purchase_item['amount']);
														if($stock_bal_temp)
														{
															$this->purchase->insert('dms_stocks',array('company_id' => $this->session->userdata('company_id'),'branch_id' => $this->session->userdata('under_id'),'godown_id' => $purchase_item['godown_id'],'item_id' => $item_id,'qty' => $stock_bal_temp['qty'],'unit_id' => $stock_bal_temp['primary_unit'],'rate' => $stock_bal_temp['rate'],'amount' => $stock_bal_temp['amount'],'stock_date' => $d_date,'stock_status' => 2,'table_group_id' => $purchase_item['group_id'],'table_id' => $purchase_items_id));
														}

														if($payment_mode == 2){
															if($this->dms->branch_type())
															{
																$vendor_ledger_id = $this->dms->get_data(array('table' =>'item_manufacturer_master','columns' => 'ledger_id','conditions' => array('id' => $vendor_id)));
																$purchase['payment_mode'] = $vendor_ledger_id[0]['ledger_id'];
															}
															else
															{
																$vendor_ledger_id = $this->dms->get_data(array('table' =>'branch_master','columns' => 'ledger_id','conditions' => array('id' => $vendor_id)));
																$purchase['payment_mode'] = $vendor_ledger_id[0]['ledger_id'];
															}
														}

														$voucher_data = $this->dms->get_data(array('table' => 'dms_vouchers','columns' => array('id','group_id','dr_ledger'),'conditions' => array('table_name' => 'dms_purchases','table_group_id' => $purchase_item['group_id']),'order_by' => 'dr_ledger','order' => 'asc'));

														$voucher_array = array();
														if(!$voucher_data && $bill_no_temp != $bill_no)
														{
															$voucher_group_id = $this->stock->get_group_id('dms_vouchers');
															$voucher_array[] = array('company_id' => $this->session->userdata('company_id'),'branch_id' => $this->session->userdata('under_id'),'group_id' => $voucher_group_id,'vtype_id' => 5,'vno' => $bill_no,'vorder_no' => 1,'vdate' => $d_date,'dr_ledger' => 3,'cr_ledger' => $purchase['payment_mode'],'vamount' => $voucher_amount,'table_name' => 'dms_purchases','table_group_id' => $purchase['group_id'],'status' => 1);

															#-----------VAT
															$voucher_array[] = array('company_id' => $this->session->userdata('company_id'),'branch_id' => $this->session->userdata('under_id'),'group_id' => $voucher_group_id,'vtype_id' => 5,'vno' => $bill_no,'vorder_no' => 2,'vdate' => $d_date,'dr_ledger' => 11,'cr_ledger' => $purchase['payment_mode'],'vamount' => 0,'table_name' => 'dms_purchases','table_group_id' => $purchase['group_id'],'status' => 1);

															#-----------CESS
															$voucher_array[] = array('company_id' => $this->session->userdata('company_id'),'branch_id' => $this->session->userdata('under_id'),'group_id' => $voucher_group_id,'vtype_id' => 5,'vno' => $bill_no,'vorder_no' => 3,'vdate' => $d_date,'dr_ledger' => 15,'cr_ledger' => $purchase['payment_mode'],'vamount' => 0,'table_name' => 'dms_purchases','table_group_id' => $purchase['group_id'],'status' => 1);

															#-----------Freight
															$voucher_array[] = array('company_id' => $this->session->userdata('company_id'),'branch_id' => $this->session->userdata('under_id'),'group_id' => $voucher_group_id,'vtype_id' => 5,'vno' => $bill_no,'vorder_no' => 4,'vdate' => $d_date,'dr_ledger' => 13,'cr_ledger' => $purchase['payment_mode'],'vamount' => 0,'table_name' => 'dms_purchases','table_group_id' => $purchase['group_id'],'status' => 1);

															#-----------Other Expense
															$voucher_array[] = array('company_id' => $this->session->userdata('company_id'),'branch_id' => $this->session->userdata('under_id'),'group_id' => $voucher_group_id,'vtype_id' => 5,'vno' => $bill_no,'vorder_no' => 5,'vdate' => $d_date,'dr_ledger' => 14,'cr_ledger' => $purchase['payment_mode'],'vamount' => 0,'table_name' => 'dms_purchases','table_group_id' => $purchase['group_id'],'status' => 1);

															#-----------inserting to voucher
                                                            $this->purchase->save_batch('dms_vouchers',$voucher_array);
														}
														else
														{
															if($bill_no_temp == $bill_no && count($voucher_data) == 5)
															{
																$voucher_array[] = array('id' => $voucher_data[0]['id'],'vamount' => $voucher_amount);

																#-----------VAT
																$voucher_array[] = array('id' => $voucher_data[1]['id'],'vamount' => 0); //$vat_amount

																#-----------Freight
																$voucher_array[] = array('id' => $voucher_data[2]['id'],'vamount' => 0); //$freight_amount

																#-----------Other Expense
														    	$voucher_array[] = array('id' => $voucher_data[3]['id'],'vamount' => 0); //$other_expense_amount

																#-----------CESS
																$voucher_array[] = array('id' => $voucher_data[4]['id'],'vamount' => 0); //$cess_amount

																#-----------inserting to voucher
																$this->purchase->update_batch('dms_vouchers',$voucher_array,'id');
															}
														}
													}
												}
											}

											#----------transaction completed
											$this->db->trans_complete();
											$bill_no_temp = $bill_no;
										}
									}
									if(!empty($error_rows))
									{
										if(empty($error_string)){
											$error_string = "Row $i [ ".implode(" ,",$error_rows)." ]<br>";
										}
										else{
											$error_string .= "Row $i [ ".implode(" ,",$error_rows)." ]<br>";
										}
									}
								}
								if(!empty($error_string))
								{
									?>
									<script>localStorage.setItem('perrors',"<?php echo $error_string;?>");</script>
									<?php
								}
							}
							else{
								$continue = 0;
								$this->message->set($this->lang->line('invalid-filetype'),'e');
							}
						}
						else{
							$continue=0;
							$this->message->set($this->lang->line('invalid-filetype'),'e');
						}
						if($continue ==1){
							$this->message->set($this->lang->line('purchase-bill-uploaded','s'));
							//redirect('Purchase_upload_excel/upload_bill');
						}
					}
				}
			}
		}

		#--------------------template
		$this->template->title($this->lang->line('purchase-bill').' '.$this->lang->line('upload'));
		$this->template->main_heading($this->lang->line('purchase-bill').' '.$this->lang->line('upload'));
		$this->template->breadcrumb(array($this->lang->line("inventory-voucher") => 'no_link',$this->lang->line('purchase') => 'purchase/add',$this->lang->line('report') => 'purchase/report',$this->lang->line('upload')=>'no_link'));
		$this->template->slice('dms/message');
		$this->template->slice('purchase/upload_bill/upload');
		$this->template->render();
	}

	public function file_empty()
	{
		if(isset($_FILES['purcahse_file']) && !empty($_FILES['purcahse_file']['name'])){
			return true;
		}else{
			return false;
		}
	}
}
?>