<?php if( ! defined('BASEPATH')) exit ('No direct script access allowed');

class Purchase_vehicles extends MY_Controller{
	
	var $companyID;
	var $branchID;
	var $createdBY;
	var $fiscal_start_date;
	var $fiscal_end_date;
	
	#------------------------------------
	
	public function __construct(){
		
		parent::__construct();
		$this->check_access_right();
		
		#---------------- Checking Financial year is enabled / closed-----------------#
		$method_array = array('assign','delete','edit');
		fiscal_status($this->uri->segment(2),$method_array,"purchase_vehicles/assigned_vehicles");
		#---------------- Checking Financial year is enabled / closed-----------------#
		$this->load->library('Stock');
		$this->companyID = $this->session->userdata('company_id');
		$this->branchID = $this->session->userdata('under_id');
		$this->createdBY = $this->session->userdata('id');
		$fiscals = $this->dms->get_fiscal_year();
		$this->fiscal_start_date = $fiscals['start_date'];
		$this->fiscal_end_date = $fiscals['end_date'];		
	}
	
	public function assign(){
		
		$uriArray = $this->uri->uri_to_assoc(5);
		$urlString = $this->uri->assoc_to_uri($uriArray);
		if(!$this->uri->segment(4) || !is_numeric($this->uri->segment(4))){
			redirect('purchase/report');
		}
		$purchaseID = $this->uri->segment(4);
		$this->load->model('purchase/Purchase_model','purchase');
		$this->template->title($this->lang->line('assign-vehicles'));
		$this->template->main_heading($this->lang->line('assign-vehicles'));
		$this->template->breadcrumb(array($this->lang->line("inventory-voucher") => 'no_link',$this->lang->line("purchase") => 'purchase/add',$this->lang->line('report') => 'purchase/report',$this->lang->line('assign-vehicles')=>'no_link',$this->lang->line('assigned-vehicles')=>'purchase_vehicles/assigned_vehicles/id/'.$purchaseID.'/'.$urlString));
		$inputSelects = array('vehicles','drivers','routes');
		$vehicles =$drivers = $routes= $purchase_vehicles = array();
		
		$args = array();
		$args['columns'] = array('a.vtype_id','a.bill_no','a.bill_date','a.group_id');
		$args['conditions'] = array('a.id'=>$purchaseID,'a.status'=>1);
		$args['limit'] = 1;$args['offset'] =0;
		$purchase = $this->purchase->get_purchases($args);
		if(empty($purchase)){
			redirect('purchase/report');
		}
		$purchase_group_id = $purchase[0]['group_id'];
		$vtype_id = $purchase[0]['vtype_id'];
		$bill_prefix = $this->stock->get_voucher_prefix($vtype_id);
		$this->load->library('Transport_lib');
		$vehicles = $this->transport_lib->vehicles();
		$drivers = $this->transport_lib->drivers();
		$routes = $this->transport_lib->routes();
		
		if($this->input->post('vehicle_type')){
			$this->form_validation->set_rules('vehicle_id','lang:vehicle','xss_clean|required');
			$this->form_validation->set_rules('driver_id','lang:driver','xss_clean|required');
		}else{
			$this->form_validation->set_rules('vehicle_no','lang:vehicle','xss_clean|required');
			$this->form_validation->set_rules('driver_name','lang:driver','xss_clean');
		}		
		$this->form_validation->set_rules('route_id','lang:route','xss_clean|required');
		$this->form_validation->set_rules('km','lang:km','xss_clean|is_numeric|greater_or_equal[0]');
		$this->form_validation->set_rules('vehicle_rent','lang:vehicle-rent','xss_clean|is_numeric|greater_or_equal[0]');

		if($this->form_validation->run() === true){
			
			$this->load->model('purchase/Purchase_vehicle_model','purchase_vehicle');
			$postedValues = $this->input->post();
			$postedValues['group_id'] = $purchase_group_id;
			
			$vehicle_type = 1;

			if($this->input->post('vehicle_type')){

				$postedValues['vehicle_type'] = 0;
				$args = array();
				$args['select'] = array('dpv.id');
				$args['conditions'] = array('dpv.group_id'=>$purchase_group_id,'dpv.vehicle_id'=>$postedValues['vehicle_id']);
				$purchase_vehicles = $this->purchase_vehicle->get($args);
			
				$args = array();
				$args['select'] = array('dpv.id');
				$args['conditions'] = array('dpv.group_id'=>$purchase_group_id,'dpv.driver_id'=>$postedValues['driver_id']);
				$purchase_driver = $this->purchase_vehicle->get($args);
			}else{
				$postedValues['vehicle_type'] = 1;
				$postedValues['vehicle_id'] = '';
				$postedValues['driver_id'] = '';				
			}
			if(empty($purchase_vehicles) && empty($purchase_driver)){
				
				if($this->purchase_vehicle->save($postedValues)){
					$this->message->set($this->lang->line('vehicle-assigned'));
					redirect('purchase_vehicles/assign/avid/'.$purchaseID.'/'.$urlString);
				}else{
					$this->message->set($this->lang->line('vehicle-not-assigned'),'e');
				}
			}else{
				$this->message->set($this->lang->line('same-vehicle-exists'),'e');
			}

		}
		foreach($inputSelects as $key=>$selectBox){
			$arrayName = $$selectBox;
			$arrayName[''] = 'Select';
			$$selectBox = $arrayName;
			ksort($$selectBox);
		}		
		# view starts here--------------------------------
		$this->template->slice('dms/message');
		$this->template->slice('purchase/purchase_entry/assign_vehicles',array('vehicles'=>$vehicles,'drivers'=>$drivers,'routes'=>$routes,'sales'=>$purchase[0],'bill_prefix'=>$bill_prefix));
		$this->template->other_script('vehicles/assign_vehicle');
		$this->template->render();		
	}	
	
	#-----------------------------------------------------------------------------------------------
	
	public function assigned_vehicles(){
		
		#----------purchase primary key
		$uri_array = $this->uri->uri_to_assoc(3);
		if(isset($uri_array['id']))
		{
			$purchaseID = $uri_array['id'];			
			unset($uri_array['id']);

			#----------redirect uri
			$redirect_uri = "purchase/report/".$this->uri->assoc_to_uri($uri_array);

			$this->load->model('purchase/Purchase_model','purchase');
			$this->load->model('purchase/Purchase_vehicle_model','purchase_vehicle');
			$this->template->title($this->lang->line('assigned-vehicles'));
			$this->template->main_heading($this->lang->line('assigned-vehicles'));
			$this->template->breadcrumb(array($this->lang->line("inventory-voucher") => 'no_link',$this->lang->line("purchase") => 'purchase/add',$this->lang->line('report') =>'purchase/report',$this->lang->line('assigned-vehicles')=>'no_link',$this->lang->line('assign-vehicles')=>'purchase_vehicles/assign/avid/'.$purchaseID.'/'.$this->uri->assoc_to_uri($uri_array),$this->lang->line("go-back") => $redirect_uri));
			$inputSelects = array('vehicles','drivers','routes');
			$vehicles =$drivers = $routes= $purchase_vehicles = array();

			$args = array();
			$args['columns'] = array('a.bill_no','a.bill_date','a.group_id');
			$args['conditions'] = array('a.id'=>$purchaseID,'a.status'=>1);
			$args['limit'] = 1;$args['offset'] =0;
			$purchase = $this->purchase->get_purchases($args);
			if(empty($purchase)){
				redirect('purchase/report');
			}
			$purchase_group_id = $purchase[0]['group_id'];	

			$args = array();
			$args['select'] = array('dpv.id','rm.route_name','vm.vehicle_no','concat(u.fname," ",u.lname) as driver','u.mobile','dpv.km','dpv.remarks','dpv.vehicle_type','dpv.vehicle_no as vehicle_number','dpv.driver_name','dpv.vehicle_rent');
			$args['conditions'] = array('dpv.group_id'=>$purchase_group_id);
			$args['join'] = array('route_master as rm'=>'dpv.route_id=rm.id','vehicle_master as vm'=>'dpv.vehicle_id=vm.id','users as u'=>'dpv.driver_id=u.id');
			$purchase_vehicles = $this->purchase_vehicle->get($args);
	
			if(empty($purchase_vehicles)){
				$this->message->set($this->lang->line('no-vehicle-assigned'),'e');
			}
			
			# view starts here--------------------------------
			$this->template->slice('dms/message');
			$this->template->slice('purchase/purchase_entry/assigned_vehicles',array('purchase_vehicles'=>$purchase_vehicles));
			$this->template->render();
		}
		else
		{
			redirect('users/logout');
		}
	}

	#-----------------------------------------------------------------------------------------------

	public function delete(){

		$uriArray = $this->uri->uri_to_assoc(5);
		$urlString = $this->uri->assoc_to_uri($uriArray);
		if(!$this->uri->segment(4) || !is_numeric($this->uri->segment(4))){
			redirect('purchase/report');
		}
		$purchase_vehicleID = $this->uri->segment(4);
		$purchase_vehicleID = $this->uri->segment(4);
		if($this->if_exists('dms_purchase_vehicles',array('id'=>$purchase_vehicleID,'status'=>1)) === false){
				redirect('purchase/report');
			}
		$this->load->model('purchase/Purchase_vehicle_model','purchase_vehicle');
		
		if($this->purchase_vehicle->update(array('status'=>0),array('id'=>$purchase_vehicleID))){
			$this->message->set($this->lang->line('purchase-vehicle-removed'));
		}else{
			$this->message->set($this->lang->line('purchase-vehicle-not-removed'));
		}
		redirect('purchase_vehicles/assigned_vehicles/'.$urlString);
	}

	#-----------------------------------------------------------------------------------------------

	public function edit(){
		
		$uriArray = $this->uri->uri_to_assoc(5);
		$urlString = $this->uri->assoc_to_uri($uriArray);
		if(!$this->uri->segment(4) || !is_numeric($this->uri->segment(4))){
			redirect('purchase/report');
		}
		
		$purchase_vehicleID = $this->uri->segment(4);
		if($this->if_exists('dms_purchase_vehicles',array('id'=>$purchase_vehicleID,'status'=>1)) === false){
				redirect('purchase/report');
			}
		$this->load->model('purchase/Purchase_vehicle_model','purchase_vehicle');
		$this->template->title($this->lang->line('assign-vehicles'));
		$this->template->main_heading($this->lang->line('assign-vehicles'));
		$this->template->breadcrumb(array($this->lang->line("inventory-voucher") => 'no_link',$this->lang->line("purchase") => 'purchase/add',$this->lang->line('report') =>'purchase/report',$this->lang->line('assigned-vehicles')=>'purchase_vehicles/assigned_vehicles/'.$urlString,$this->lang->line('update')=>'no_link'));
		$inputSelects = array('vehicles','drivers','routes');
		$vehicles =$drivers = $routes= $purchase_vehicles = array();		
		
		$this->load->library('Transport_lib');
		$vehicles = $this->transport_lib->vehicles();
		$drivers = $this->transport_lib->drivers();
		$routes = $this->transport_lib->routes();
				
		$args = array();
		$args['select'] = array('dpv.id','dpv.group_id','dpv.route_id','dpv.vehicle_id','dpv.driver_id','dpv.km','dpv.remarks','dpv.vehicle_type','dpv.vehicle_no','dpv.driver_name','dpv.vehicle_rent','dp.vtype_id','dp.bill_no','dp.bill_date');
		$args['conditions'] = array('dpv.id'=>$purchase_vehicleID);
		$args['join'] = array('dms_purchases as dp'=>'dpv.group_id=dp.group_id','route_master as rm'=>'dpv.route_id=rm.id','vehicle_master as vm'=>'dpv.vehicle_id=vm.id','users as u'=>'dpv.driver_id=u.id');
		$purchase_vehicles = $this->purchase_vehicle->get($args);


		if($this->input->post('vehicle_type')){
			$this->form_validation->set_rules('vehicle_id','lang:vehicle','xss_clean|required');
			$this->form_validation->set_rules('driver_id','lang:driver','xss_clean|required');
		}else{
			$this->form_validation->set_rules('vehicle_no','lang:vehicle','xss_clean|required');
			$this->form_validation->set_rules('driver_name','lang:driver','xss_clean');
		}

		$this->form_validation->set_rules('route_id','lang:from','xss_clean|required');
		$this->form_validation->set_rules('km','lang:km','xss_clean|is_numeric|greater_or_equal[0]');
		$this->form_validation->set_rules('vehicle_rent','lang:vehicle-rent','xss_clean|is_numeric|greater_or_equal[0]');
		
		if($this->form_validation->run() === true){
			
			$purchase_group_id = $purchase_vehicles[0]['group_id'];
			$postedValues = $this->input->post();
			$vehicle_type = 1;
			if($this->input->post('vehicle_type')){
				
				$postedValues['vehicle_type'] = 0;
				$postedValues['vehicle_no'] = '';
				$postedValues['driver_name'] = '';					
				$args = array();
				$args['select'] = array('dpv.id');
				$args['conditions'] = array('dpv.id !='=>$purchase_vehicleID,'dpv.group_id'=>$purchase_group_id,'vehicle_id'=>$postedValues['vehicle_id']);
				$purchase_vehicle = $this->purchase_vehicle->get($args);
			
				$args = array();
				$args['select'] = array('dpv.id');
				$args['conditions'] = array('dpv.id !='=>$purchase_vehicleID,'dpv.group_id'=>$purchase_group_id,'driver_id'=>$postedValues['driver_id']);
				$purchase_driver = $this->purchase_vehicle->get($args);
			}else{
				$postedValues['vehicle_type'] = 1;
				$postedValues['vehicle_id'] = '';
				$postedValues['driver_id'] = '';				
			}

			if(empty($purchase_vehicle) && empty($purchase_driver)){
				
				if($this->purchase_vehicle->update($postedValues,array('id'=>$purchase_vehicleID))){
					$this->message->set($this->lang->line('vehicle-assigned-edit-success'));
					redirect('purchase_vehicles/assigned_vehicles/'.$urlString);
				}else{
					$this->message->set($this->lang->line('vehicle-not-assigned'),'e');
				}
			}else{
				$this->message->set($this->lang->line('same-vehicle-exists'),'e');
			}			
		}
		
		foreach($inputSelects as $key=>$selectBox){
			$arrayName = $$selectBox;
			$arrayName[''] = 'Select';
			$$selectBox = $arrayName;
			ksort($$selectBox);
		}	
				
		# view starts here--------------------------------
		$this->template->slice('dms/message');
		$this->template->slice('purchase/purchase_entry/edit_assigned_vehicles',array('vehicles'=>$vehicles,'drivers'=>$drivers,'routes'=>$routes,'purchase_vehicle'=>$purchase_vehicles));
		$this->template->other_script('vehicles/assign_vehicle');
		$this->template->render();					
	}
	
	#-----------------------------------------------------------------------------------------------	
}