<?php if( ! defined('BASEPATH')) exit ('No direct script access allowed');

class Quotations extends MY_Controller{

	var $companyID;
	var $branchID;
	var $createdBY;
	var $fiscal_start_date;
	var $fiscal_end_date;

	#------------------------------------

	public function __construct(){

		parent::__construct();
		$this->check_access_right();

		#---------------- Checking Financial year is enabled / closed-----------------#
		$method_array = array('add','edit','delete');
		fiscal_status($this->uri->segment(2),$method_array,"quotations/report");
		#---------------- Checking Financial year is enabled / closed-----------------#
		$this->load->library(array('Stock'));
		$this->companyID = $this->session->userdata('company_id');
		$this->branchID = $this->session->userdata('under_id');
		$this->createdBY = $this->session->userdata('id');

		$fiscals = $this->dms->get_fiscal_year();
		$this->fiscal_start_date = $fiscals['start_date'];
		$this->fiscal_end_date = $fiscals['end_date'];
	}

	#---------------------------------------------------------------------------------------------

	public function add(){

		$this->template->title($this->lang->line('quotations'));
		$this->template->main_heading($this->lang->line('quotations'));
		$this->template->breadcrumb(array($this->lang->line('quotations') => 'no_link',$this->lang->line('report') => 'quotations/report'));
		$this->load->model('sales/Quotation_model','quotation');
		$this->load->model('areas/Area_model','area');

		$bill_num = $bill_date = NULL;
		$areas = $items = $go_downs = $units = $quotation_types = $quotations = array();
		$quotation_types = array(''=>'Select','0'=>'Individual','1'=>'Institutional');
		ksort($quotation_types);


		$inputSelects = array('areas','items','go_downs','units');
		$bill_num = $this->quotation->get_bill_number();
		$bill_date = date('Y-m-d');$cstEnabled=0;
		$items = $this->stock->get_stock_items();
		$areas = $this->area->listing();
		$cess = $this->stock->get_cess();

	/*	$args = array();
		$args['select'] = array('dq.id','dq.qt_no','dq.qt_date','dq.customer_id','dq.qt_type','dq.cess','cm.fname as customer_fname','cm.lname as customer_lname','cm.address','cm.mobile_no','cm.phone_no','dqi.id as dqi_id','dqi.item_id','dqi.qty','dqi.unit_id','dqi.rate','dqi.amount','dqi.discount_per','dqi.discount_amt','dqi.vat_percent','dqi.vat_amt','dqi.cst','dqi.godown_id','im.item_code','im.item_name','um.symbol');
		$args['conditions'] = array('dq.status'=>-1,'dqi.status'=>-1,'dq.created_by'=>$this->createdBY);
		$args['join'] = array('dms_quotations_items as dqi'=>'dq.id=dqi.qt_id','customer_master as cm'=>'cm.id=dq.customer_id','item_master as im'=>'dqi.item_id=im.id','unit_master as um'=>'dqi.unit_id=um.id');
		$quotations = $this->quotation->get($args); */


               $args = array();
		$args['select'] = array('dq.id','dq.qt_no','dq.qt_date','dq.customer_id','dq.qt_type','dq.cess','cm.fname as customer_fname','cm.lname as customer_lname','cm.address','cm.mobile_no','cm.phone_no','dqi.id as dqi_id','dqi.item_id','dqi.qty','dqi.unit_id','dqi.rate','dqi.amount','dqi.discount_per','dqi.discount_amt','dqi.vat','dqi.vat_amt','dqi.godown_id','im.item_code','im.item_name','um.symbol');
		$args['conditions'] = array('dq.status'=>-1,'dqi.status'=>-1,'dq.created_by'=>$this->createdBY);
		$args['join'] = array('dms_quotations_items1 as dqi'=>'dq.id=dqi.qt_id','customer_master as cm'=>'cm.id=dq.customer_id','item_master as im'=>'dqi.item_id=im.id','unit_master as um'=>'dqi.unit_id=um.id');
		$quotations = $this->quotation->get($args); 







		if(empty($quotations)){


			$this->form_validation->set_rules('bill_no','lang:bill-no','xss_clean|required|is_natural|greater_than[0]|callback_bill_num_check');
			$this->form_validation->set_rules('bill_date','lang:bill-date','xss_clean|required|valid_date|is_date|check_date['.date('Y-m-d').'.<=]');

		}else{
			$quotationID = $quotations[0]['id'];
			$bill_num = $quotations[0]['qt_no'];
			$bill_date = date('Y-m-d',strtotime($quotations[0]['qt_date']));

			$args=array();
			$args['select'] = array('dqi.id');
			$args['conditions'] = array('dq.id'=>$quotationID,'dqi.cst >'=>0);
			$args['join'] = array('dms_quotations_items as dqi'=>'dq.id=dqi.qt_id');
			$cstEnabled = $this->quotation->get($args);
			$cstEnabled = count($cstEnabled);
		}

		#------------presumptive tax
		$presumtiveTax = $this->stock->get_tax_type();

		#=====================================================

		if(isset($_POST['add_to_bill'])){

			$this->form_validation->set_rules('customer_fname','lang:first-name','xss_clean|required');
			$this->form_validation->set_rules('customer_lname','lang:last-name','xss_clean');
			$this->form_validation->set_rules('address','lang:address','xss_clean|required');
			$this->form_validation->set_rules('phone_no','lang:phone','xss_clean');
			$this->form_validation->set_rules('mobile_no','lang:mobile','xss_clean|required|is_natural|exact_length[10]');
			$this->form_validation->set_rules('quotation_type','lang:quotation-type','xss_clean|required');
			$this->form_validation->set_rules('item_id','lang:item-name','xss_clean|required');
			$this->form_validation->set_rules('godown_id','lang:godown','xss_clean|required');
			$this->form_validation->set_rules('cst','lang:cst','xss_clean|greater_or_equal[0]|less_or_equal[100]');
			$this->form_validation->set_rules('unit_id','lang:unit','xss_clean|required');
			$this->form_validation->set_rules('qty','lang:qty','xss_clean|required|greater_or_equal[0]');
			$this->form_validation->set_rules('rate','lang:rate','required|xss_clean|greater_or_equal[0]|less_than[100000000]');
			$this->form_validation->set_rules('amount','lang:amount','xss_clean|required|greater_or_equal[0]|less_than[100000000]');
			$this->form_validation->set_rules('discount_per','lang:discount %','xss_clean|greater_than[0]|less_or_equal[100]');
			$this->form_validation->set_rules('discount_amt','lang:discount','xss_clean|greater_or_equal[0]|less_than[100000000]');
			if($this->input->post('item_id')){
				$itemID = $this->input->post('item_id');
				$go_downs = $this->stock->get_item_godowns(array('item_id'=>$itemID,'listing'=>1));
				$units = $this->stock->get_units($itemID);
			}

			if($this->form_validation->run('add_to_bill') === true){

				$postedItems = $this->input->post(NULL,true);
                                $b_date =$postedItems['bill_date'];
                                $l_date = '2017-07-01';


				if(empty($quotations)){
                                     
					$bill_num = $postedItems['bill_no'];
					$bill_date = date('Y-m-d',strtotime($postedItems['bill_date']));
				}
				$this->db->trans_start();
				if(empty($quotations)){

					$customerID = $this->quotation->save_customer(array('fname'=>$postedItems['customer_fname'],'lname'=>$postedItems['customer_lname'],'address'=>$postedItems['address'],'mobile_no'=>$postedItems['mobile_no'],'phone_no'=>$postedItems['phone_no'],'status'=>-1));

					if($this->quotation->save(array('qt_no'=>$bill_num,'qt_date'=>$bill_date,'customer_id'=>$customerID,'qt_type'=>$postedItems['quotation_type'],'cess'=>$cess,'qt_status'=>0,'status'=>-1))){
						$quotationID = $this->db->insert_id();
					}
				}else{
					$this->quotation->update('dms_quotations',array('qt_type'=>$postedItems['quotation_type'],'cess'=>$cess),array('id'=>$quotationID));
				}

				if(!empty($quotationID))
                                {
                                   $b_date =$postedItems['bill_date'];
                               /*    if($b_date < $l_date)
                                   {
					$args = array();
					$args['select'] = array('dqi.id');
					$args['conditions'] = array('dq.id'=>$quotationID,'item_id'=>$postedItems['item_id'],'unit_id'=>$postedItems['unit_id'],'godown_id'=>$postedItems['godown_id']);
					$args['join'] = array('dms_quotations_items as dqi'=>'dq.id=dqi.qt_id');
					$check_temp_item = $this->quotation->get($args);
 
                                   
					#----------VAT calculation
					$cst = $vat_amt = $vat_percent = 0;
					if($this->input->post('cst'))
                                        {
						$cst = $this->input->post('cst');
					}
					if(empty($presumtiveTax))
                                        {
						if($cst == 0)
                                                {
							$vat_percent = $this->stock->get_item_vat($itemID);
							$vat_amt = round_this((($postedItems['amount']-$postedItems['discount_amt']) * $vat_percent) / 100);
						}
					}

					if(empty($check_temp_item))
                                        {

						$postedItems['rate']=0;
						if($postedItems['qty'] >0)
                                                {
							$postedItems['rate'] = $postedItems['amount']/$postedItems['qty'];
						}
						if($this->quotation->save_items(array('qt_id'=>$quotationID,'item_id'=>$postedItems['item_id'],'qty'=>$postedItems['qty'],'unit_id'=>$postedItems['unit_id'],'rate'=>$postedItems['rate'],'amount'=>$postedItems['amount'],'discount_per'=>$postedItems['discount_per'],'discount_amt'=>$postedItems['discount_amt'],'vat_percent'=>$vat_percent,'vat_amt'=>$vat_amt,'cst'=>$cst,'godown_id'=>$postedItems['godown_id'],'status'=>-1)))

                                                {
							$this->message->set($this->lang->line('quotation-item-added'));
							$this->db->trans_complete();
							redirect('quotations/add');
						}
					}
                                        else
                                        {
						$this->message->set($this->lang->line('quotation-item-exist'),'e');
					}
                                    }
                                    else
                                    {  */
                                        $args = array();
					$args['select'] = array('dqi.id');
					$args['conditions'] = array('dq.id'=>$quotationID,'item_id'=>$postedItems['item_id'],'unit_id'=>$postedItems['unit_id'],'godown_id'=>$postedItems['godown_id']);
					$args['join'] = array('dms_quotations_items1 as dqi'=>'dq.id=dqi.qt_id');
					$check_temp_item = $this->quotation->get($args);
 
                                   
					#----------GST calculation
					$cgst_amt = $sgst_amt = $sgst = $cgst = 0;
					
					$cgst = $this->stock->get_item_cgst($itemID);
                                        $sgst = $this->stock->get_item_sgst($itemID);
					$cgst_amt = round_this((((float)$postedItems['amount']-(float)$postedItems['discount_amt']) * (float)$cgst) / 100);
					$sgst_amt = round_this((((float)$postedItems['amount']-(float)$postedItems['discount_amt']) * (float)$sgst) / 100);

					if(empty($check_temp_item))
                                        {

						$postedItems['rate']=0;
						if($postedItems['qty'] >0)
                                                {
							$postedItems['rate'] = (float)$postedItems['amount']/(float)$postedItems['qty'];
						}
						if($this->quotation->save_itemss(array('qt_id'=>$quotationID,'item_id'=>$postedItems['item_id'],'qty'=>$postedItems['qty'],'unit_id'=>$postedItems['unit_id'],'rate'=>$postedItems['rate'],'amount'=>$postedItems['amount'],'discount_per'=>$postedItems['discount_per'],'discount_amt'=>$postedItems['discount_amt'],'cgst'=>$cgst,'sgst'=>$sgst,'cgst_amt'=>$cgst_amt,'sgst_amt'=>$sgst_amt,'godown_id'=>$postedItems['godown_id'],'status'=>-1)))

                                                {
							$this->message->set($this->lang->line('quotation-item-added'));
							$this->db->trans_complete();
							redirect('quotations/add');
						}
					}
                                        else
                                        {
						$this->message->set($this->lang->line('quotation-item-exist'),'e');
					}

                                  //  }
				}
			}
		}

		#=====================================================

		if(isset($_POST['save_bill'])){

			$this->form_validation->set_rules('area_id','lang:area','xss_clean|required');
			$this->form_validation->set_rules('bill_discount_per','lang:discount','xclean');
			$this->form_validation->set_rules('bill_discount_amt','lang:discount','xclean');
			$this->form_validation->set_rules('remarks','lang:remarks','xclean');
			if($this->form_validation->run() === true){

				$area_id = $this->input->post('area_id');
				$bill_discount_per = $this->input->post('bill_discount_per');
				$bill_discount_amt = $this->input->post('bill_discount_amt');
				$remarks = $this->input->post('remarks');
				if(!empty($quotations)){
					if($this->quotation->check_bill_number($bill_num,array('id !='=>$quotationID)) == true){
						$this->db->trans_start();
						$this->quotation->update('dms_quotations',array('area_id'=>$area_id,'remarks'=>$remarks,'qt_discount_per'=>$bill_discount_per,'qt_discount_amt'=>$bill_discount_amt,'qt_type'=>$postedItems['quotation_type'],'cess'=>$cess,'status'=>1),array('id'=>$quotationID));
						$this->quotation->update('dms_quotations_items1',array('status'=>1),array('qt_id'=>$quotationID));
						$this->db->trans_complete();
						$this->message->set($this->lang->line('quotation-saved'));
						redirect('quotations/add');
					}else{
						$this->message->set($this->lang->line('quotation-number-exist'),'e');
					}
				}
			}
		}

		#=====================================================

		foreach($inputSelects as $key=>$selectBox){

			$arrayName = $$selectBox;
			$arrayName[''] = 'Select';
			$$selectBox = $arrayName;
			ksort($$selectBox);
		}

		$this->template->slice('dms/message');
		$this->template->slice('sales/quotations/add_quotation',array('bill_num'=>$bill_num,'bill_date'=>$bill_date,'areas'=>$areas,'items'=>$items,'goDowns'=>$go_downs,'units'=>$units,'quotation_types'=>$quotation_types,'quotations'=>$quotations,'cst_enabled'=>$cstEnabled,'presumtiveTax' => $presumtiveTax));
		$this->template->other_script(array('sales/quotations'));
		$this->template->render();
	}

	#---------------------------------------------------------------------------------------------

	public function bill_num_check($str){
		if($this->quotation->check_bill_number($str) === true){
			return TRUE;
		}
		return FALSE;
	}

	#---------------------------------------------------------------------------------------------

	public function remove_temp_item(){

		if(!$this->uri->segment(3)){
			redirect('users/logout');
		}
		$tempItemID = $this->uri->segment(3);
		if($this->if_exists('dms_quotations_items',array('id'=>$tempItemID,'created_by'=>$this->createdBY,'status'=>-1)) === false){
			echo $this->db->last_query();die;
			redirect('quotations/add');
		}
		$this->load->model('sales/Quotation_model','quotation');

		if($this->quotation->delete_temp_item($tempItemID)){
			$this->message->set($this->lang->line('item-deleted-from-bill'));
		}

		redirect('quotations/add');
	}
        


        public function remove_temp_items(){

		if(!$this->uri->segment(3)){
			redirect('users/logout');
		}
		$tempItemID = $this->uri->segment(3);
	/*	if($this->if_exists('dms_quotations_items1',array('id'=>$tempItemID,'created_by'=>$this->createdBY,'status'=>-1)) === false){
			echo $this->db->last_query();
			redirect('quotations/add');
		} */
		$this->load->model('sales/Quotation_model','quotation');

		if($this->quotation->delete_temp_items($tempItemID)){
			$this->message->set($this->lang->line('item-deleted-from-bill'));
		}

		redirect('quotations/add');
	}






	#---------------------------------------------------------------------------------------------

	public function report(){

		$this->template->title($this->lang->line('quotation-report'));
		$this->template->main_heading($this->lang->line('quotation-report'));
		$this->template->breadcrumb(array($this->lang->line('quotations') => 'quotations/add',$this->lang->line('report') => 'no_link',$this->lang->line('all')=>'quotations/report'));

		$this->load->model('sales/Quotation_model','quotation');
		$this->load->library('Pagination');
		$quotation_types = array(0=>'Individual',1=>'Institutional');
		$quotation_items = $quotations = array();
		$links = $from_date = $to_date = NULL;$offset=0;
		$config['per_page'] = $this->per_page();
		$config['uri_segment'] = 3;
		$offset = ($this->uri->segment(3))?$this->uri->segment(3):0;
		$config['base_url'] = base_url('quotations/report');

		if(isset($_POST['get'])){
			$this->form_validation->set_rules('from_date','lang:from-date','xss_clean|required|is_date|valid_date');
			$this->form_validation->set_rules('to_date','lang:to-date','xss_clean|required|is_date|valid_date');
			if($this->form_validation->run() === true){
				$from_date = date('Y-m-d',strtotime($this->input->post('from_date')));
				$to_date = date('Y-m-d',strtotime($this->input->post('to_date')));
				$config['base_url'] = base_url('quotations/report/'.$from_date.'/'.$to_date);
			}
		}else if($this->uri->segment(3) && $this->uri->segment(4)){

			$from_date = date('Y-m-d',strtotime($this->uri->segment(3)));
			$to_date = date('Y-m-d',strtotime($this->uri->segment(4)));
			$config['uri_segment'] = 5;
			$offset = ($this->uri->segment(5))?$this->uri->segment(5):0;
			$config['base_url'] = base_url('quotations/report/'.$from_date.'/'.$to_date);

		}else{
			$from_date = date('Y-m-d');#$this->fiscal_start_date;
			$to_date = date('Y-m-d');#$this->fiscal_end_date;
			$config['uri_segment'] = 5;
			$offset = ($this->uri->segment(5))?$this->uri->segment(5):0;
			$config['base_url'] = base_url('quotations/report/'.$from_date.'/'.$to_date);
		}
		$purchase_orders = array();$purchase_order_items= $poStatusArray = array();
		if(!empty($from_date) && !empty($to_date)){

			$args = array();
			$args['select'] = array('dq.id');
			$args['from_date'] = $from_date;
			$args['to_date'] = $to_date;
			$args['num_rows'] = 1;
			$args['conditions'] = array('dq.status'=>1);
			$config['total_rows'] = $this->quotation->get($args);
			$this->pagination->initialize($config);
			$links = $this->pagination->create_links();

			$args = array();
			$args['select'] = array('dq.id','dq.qt_no','dq.qt_date','dq.customer_id','dq.qt_type','dq.qt_status','dq.area_id','dq.remarks','dq.qt_discount_amt','dq.cess','concat(cm.fname," ",cm.lname) as customer_name','cm.address','cm.mobile_no','cm.phone_no');
			$args['from_date'] = $from_date;
			$args['to_date'] = $to_date;
			$args['limit'] = $config['per_page']; 
			$args['offset'] = $offset;
		//	$args['conditions'] = array('dq.status'=>1); 
			$args['join'] = array('customer_master as cm'=>'cm.id=dq.customer_id');
			$args['order_by'] = array('dq.qt_date'=>'desc','dq.qt_no'=>'desc'); 
			$quotations = $this->quotation->get($args);
			if(empty($quotations)){
				$this->message->set($this->lang->line('no-result-found'),'i');
			}else{
                                $l_date = '2017-07-01';
				foreach($quotations as $key=>$quotation){

					$quotationID = $quotation['id'];
                                        $q_date = $quotation['qt_date'];

					
                                        if($q_date < $l_date)
                                        {
                                              $args = array();
					      $args['select'] = array('dqi.id as dqi_id','dqi.item_id','dqi.qty','dqi.unit_id','dqi.rate','dqi.amount','dqi.discount_per','dqi.discount_amt','dqi.vat_amt','dqi.cst','dqi.godown_id','im.item_code','im.item_name','um.symbol');
					      $args['conditions'] = array('dqi.qt_id'=>$quotationID,'dq.status'=>1,'dqi.status'=>1);
					      $args['join'] = array('dms_quotations_items as dqi'=>'dq.id=dqi.qt_id','item_master as im'=>'dqi.item_id=im.id','unit_master as um'=>'dqi.unit_id=um.id');
					      $quotation_items[$quotationID] = $this->quotation->get($args);
                                        }
                                        else
                                        { 
                                               $args = array();
                                               $args['select'] = array('dqi.id as dqi_id','dqi.item_id','dqi.qty','dqi.unit_id','dqi.rate','dqi.amount','dqi.discount_per','dqi.discount_amt','dqi.vat_amt','dqi.godown_id','im.item_code','im.item_name','um.symbol'); 
                                               $args['conditions'] = array('dqi.qt_id'=>$quotationID,'dq.status'=>1,'dqi.status'=>1);
					       $args['join'] = array('dms_quotations_items1 as dqi'=>'dq.id=dqi.qt_id','item_master as im'=>'dqi.item_id=im.id','unit_master as um'=>'dqi.unit_id=um.id');
					       $quotation_items[$quotationID] = $this->quotation->get($args);
                                        }
				}
			}
		}
		$this->template->slice('dms/message');
		$this->template->slice('date/between_date_search',array('from_date'=>$from_date,'to_date'=>$to_date));
		$this->template->slice('sales/quotations/quotation_report',array('quotations'=>$quotations,'quotation_items'=>$quotation_items,'quotation_types'=>$quotation_types,'links'=>$links,'count'=>$offset+1,'offset'=>$offset,'from_date'=>$from_date,'to_date'=>$to_date));
		$this->template->other_script(array('sales/quotations'));
		$this->template->render();
	}

	#---------------------------------------------------------------------------------------------

	public function view(){

		if(!$this->uri->segment(3)){
			redirect('quotations/report');
		}
		$quotationID = $this->uri->segment(3);
		if($this->if_exists('dms_quotations',array('id'=>$quotationID,'status'=>1)) === false){
			redirect('quotations/report');
		}
		$uriArray = $this->uri->uri_to_assoc(4);
		$urlString = $this->uri->assoc_to_uri($uriArray);
		$quotations = array();$quotation_items = array();
		$this->template->title($this->lang->line('view-quotation'));
		$this->template->main_heading($this->lang->line('view-quotation'));
		$this->template->breadcrumb(array($this->lang->line('quotations') => 'quotations/add',$this->lang->line('report') => 'quotations/report',$this->lang->line('view')=>'no_link',$this->lang->line('go-back')=>array('quotations/report/'.$urlString)));
		$quotation_types = array(0=>'Individual',1=>'Institutional');
		$this->load->model('sales/Quotation_model','quotation');

		$args = array();
		$args['select'] = array('dq.id','dq.qt_no','dq.qt_status','dq.qt_date','dq.customer_id','dq.qt_type','dq.qt_discount_amt','dq.qt_discount_per','dq.cess','dq.remarks','dq.created_by','dq.created_on','cm.fname as customer_fname','cm.lname as customer_lname','cm.address','cm.mobile_no','cm.phone_no','am.area','dqi.id as dqi_id','dqi.item_id','dqi.qty','dqi.unit_id','dqi.rate','dqi.amount','dqi.discount_per','dqi.discount_amt','dqi.vat_amt','dqi.cst','dqi.godown_id','im.item_code','im.item_name','um.symbol');
		$args['conditions'] = array('dq.status'=>1,'dqi.status'=>1,'dq.id'=>$quotationID);
		$args['join'] = array('dms_quotations_items as dqi'=>'dq.id=dqi.qt_id','customer_master as cm'=>'cm.id=dq.customer_id','area_master as am'=>'dq.area_id=am.id','item_master as im'=>'dqi.item_id=im.id','unit_master as um'=>'dqi.unit_id=um.id');
		$args['order_by'] = array('dqi.id'=>'asc');
		$quotations = $this->quotation->get($args);

if(empty($quotations))
{
$args = array();
		$args['select'] = array('dq.id','dq.qt_no','dq.qt_status','dq.qt_date','dq.customer_id','dq.qt_type','dq.qt_discount_amt','dq.qt_discount_per','dq.cess','dq.remarks','dq.created_by','dq.created_on','cm.fname as customer_fname','cm.lname as customer_lname','cm.address','cm.mobile_no','cm.phone_no','am.area','dqi.id as dqi_id','dqi.item_id','dqi.qty','dqi.unit_id','dqi.rate','dqi.amount','dqi.discount_per','dqi.discount_amt','dqi.vat_amt','dqi.godown_id','im.item_code','im.item_name','um.symbol');
		$args['conditions'] = array('dq.status'=>1,'dqi.status'=>1,'dq.id'=>$quotationID);
		$args['join'] = array('dms_quotations_items1 as dqi'=>'dq.id=dqi.qt_id','customer_master as cm'=>'cm.id=dq.customer_id','area_master as am'=>'dq.area_id=am.id','item_master as im'=>'dqi.item_id=im.id','unit_master as um'=>'dqi.unit_id=um.id');
		$args['order_by'] = array('dqi.id'=>'asc');
		$quotations = $this->quotation->get($args);



}

		$cstEnabled=0;
		if(!empty($quotations)){
			$quotationID = $quotations[0]['id'];
			$args=array();
			$args['select'] = array('dqi.id');
			$args['conditions'] = array('dq.id'=>$quotationID,'dqi.cst >'=>0);
			$args['join'] = array('dms_quotations_items as dqi'=>'dq.id=dqi.qt_id');
			$cstEnabled = $this->quotation->get($args);
			$cstEnabled = count($cstEnabled);
		}

		# view starts here--------------------------------
		$this->template->slice('dms/message');
		$this->template->slice('sales/quotations/view_quotation',array('quotations'=>$quotations,'quotation_types'=>$quotation_types,'cst_enabled'=>$cstEnabled));
		$this->template->other_script(array('sales/quotations'));
		$this->template->render();
	}

	#----------------------------------------------------------------------------------------------

	public function edit(){

		if(!$this->uri->segment(3)){
			redirect('quotations/report');
		}
		$quotationID = $this->uri->segment(3);
		if($this->if_exists('dms_quotations',array('id'=>$quotationID,'status'=>1)) === false){
			redirect('quotations/report');
		}
		$uriArray = $this->uri->uri_to_assoc(4);
		$urlString = $this->uri->assoc_to_uri($uriArray);
		$quotations = array();$quotation_items = array();
		$this->template->title($this->lang->line('edit-quotation'));
		$this->template->main_heading($this->lang->line('edit-quotation'));
		$this->template->breadcrumb(array($this->lang->line('quotations') => 'quotations/add',$this->lang->line('report') => 'quotations/report',$this->lang->line('edit')=>'no_link',$this->lang->line('go-back')=>array('quotations/report/'.$urlString)));

		$this->load->model('sales/Quotation_model','quotation');
		$this->load->model('areas/Area_model','area');

		$areas = $items = $go_downs = $units = $quotation_types = $quotations = array();
		$inputSelects = array('areas','items','go_downs','units');
		$quotation_types = array(''=>'Select','0'=>'Individual','1'=>'Institutional');
		$items = $this->stock->get_stock_items();
		$areas = $this->area->listing();

		$args = array();
		$args['select'] = array('dq.id','dq.qt_no','dq.qt_date','dq.customer_id','dq.qt_type','dq.qt_discount_amt','dq.qt_discount_per','dq.cess','dq.area_id','dq.qt_status','dq.remarks','cm.fname as customer_fname','cm.lname as customer_lname','cm.address','cm.mobile_no','cm.phone_no','dqi.id as dqi_id','dqi.item_id','dqi.qty','dqi.unit_id','dqi.rate','dqi.amount','dqi.discount_per','dqi.discount_amt','dqi.vat_percent','dqi.vat_amt','dqi.cst','dqi.godown_id','im.item_code','im.item_name','um.symbol');
		$args['conditions'] = array('dq.status'=>1,'dqi.status'=>1,'dq.id'=>$quotationID);
		$args['join'] = array('dms_quotations_items as dqi'=>'dq.id=dqi.qt_id','customer_master as cm'=>'cm.id=dq.customer_id','area_master as am'=>'dq.area_id=am.id','item_master as im'=>'dqi.item_id=im.id','unit_master as um'=>'dqi.unit_id=um.id');
		$args['order_by'] = array('dqi.id'=>'asc');
		$quotations = $this->quotation->get($args);

if(empty($quotations))
{
                $args = array();
		$args['select'] = array('dq.id','dq.qt_no','dq.qt_date','dq.customer_id','dq.qt_type','dq.qt_discount_amt','dq.qt_discount_per','dq.cess','dq.area_id','dq.qt_status','dq.remarks','cm.fname as customer_fname','cm.lname as customer_lname','cm.address','cm.mobile_no','cm.phone_no','dqi.id as dqi_id','dqi.item_id','dqi.qty','dqi.unit_id','dqi.rate','dqi.amount','dqi.discount_per','dqi.discount_amt','dqi.vat','dqi.vat_amt','dqi.godown_id','im.item_code','im.item_name','um.symbol');
		$args['conditions'] = array('dq.status'=>1,'dqi.status'=>1,'dq.id'=>$quotationID);
		$args['join'] = array('dms_quotations_items1 as dqi'=>'dq.id=dqi.qt_id','customer_master as cm'=>'cm.id=dq.customer_id','area_master as am'=>'dq.area_id=am.id','item_master as im'=>'dqi.item_id=im.id','unit_master as um'=>'dqi.unit_id=um.id');
		$args['order_by'] = array('dqi.id'=>'asc');
		$quotations = $this->quotation->get($args);



}

		$cstEnabled=0;
		if(!empty($quotations)){

			$quotation_status = $quotations[0]['qt_status'];
			$quotationID = $quotations[0]['id'];
			$args=array();
			$args['select'] = array('dqi.id');
			$args['conditions'] = array('dq.id'=>$quotationID,'dqi.cst >'=>0);
			$args['join'] = array('dms_quotations_items as dqi'=>'dq.id=dqi.qt_id');
			$cstEnabled = $this->quotation->get($args);
			$cstEnabled = count($cstEnabled);
		}

		#----------presumptive tax
		$presumtiveTax = $this->stock->get_tax_type();

		if(isset($_POST['add_to_bill'])){

			$this->form_validation->set_rules('item_id','lang:item-name','required|xss_clean|is_natural_no_zero');
			$this->form_validation->set_rules('godown_id','lang:godown','required|xss_clean');
			$this->form_validation->set_rules('cst','lang:cst','xss_clean|greater_or_equal[0]|less_or_equal[100]');
			$this->form_validation->set_rules('qty','lang:quantity','required|xss_clean|greater_than[0]|less_than[100000000]');
			$this->form_validation->set_rules('unit_id','lang:unit','required|xss_clean');
			$this->form_validation->set_rules('rate','lang:rate','required|xss_clean|greater_or_equal[0]|less_than[100000000]');
			$this->form_validation->set_rules('amount','lang:amount','xss_clean|required|greater_or_equal[0]|less_than[100000000]');
			$this->form_validation->set_rules('discount_per','lang:discount %','xss_clean|greater_or_equal[0]|less_or_equal[100]');
			$this->form_validation->set_rules('discount_amt','lang:discount','xss_clean|greater_or_equal[0]|less_than[100000000]');

			if($this->input->post('item_id')){
				$itemID = $this->input->post('item_id');
				$go_downs = $this->stock->get_item_godowns(array('item_id'=>$itemID,'listing'=>1));
				$units = $this->stock->get_units($itemID);
			}

			if($this->form_validation->run() === true){
				if($quotation_status == 0){

					$postedItems = $this->input->post(NULL,true);

				/*	#----------VAT calculation
					$cst = $vat_amt = $vat_percent = 0;
					if($this->input->post('cst')){$cst = $this->input->post('cst');}
					if(empty($presumtiveTax)){
						if(!$cst){
							$vat_percent = $this->stock->get_item_vat($postedItems['item_id']);
							$vat_amt = ((($postedItems['amount']-$postedItems['discount_amt']) * $vat_percent) / 100);#round_this;
						}
					}     */

                                        $cgst = $this->stock->get_item_cgst($postedItems['item_id']);
                                        $sgst = $this->stock->get_item_sgst($postedItems['item_id']);
                                        $cgst_amt = ((($postedItems['amount']-$postedItems['discount_amt']) * $cgst) / 100);
                                        $sgst_amt = ((($postedItems['amount']-$postedItems['discount_amt']) * $sgst) / 100);

				/*	$args = array();
					$args['select'] = array('dqi.id');
					$args['conditions'] = array('dq.id'=>$quotationID,'item_id'=>$postedItems['item_id'],'unit_id'=>$postedItems['unit_id'],'godown_id'=>$postedItems['godown_id']);
					$args['join'] = array('dms_quotations_items as dqi'=>'dq.id=dqi.qt_id');
					$check_temp_item = $this->quotation->get($args);

					if(empty($check_temp_item)){

						if($this->quotation->save_items(array('qt_id'=>$quotationID,'item_id'=>$postedItems['item_id'],'qty'=>$postedItems['qty'],'unit_id'=>$postedItems['unit_id'],'rate'=>$postedItems['rate'],'amount'=>$postedItems['amount'],'discount_per'=>$postedItems['discount_per'],'discount_amt'=>$postedItems['discount_amt'],'vat_percent' => $vat_percent,'vat_amt' => $vat_amt,'cst'=>$postedItems['cst'],'godown_id'=>$postedItems['godown_id'],'status'=>1))){
							$this->message->set($this->lang->line('quotation-item-added'));
							redirect('quotations/edit/'.$quotationID.'/'.$urlString);
						}
					}else{
						$this->message->set($this->lang->line('quotation-item-exist'),'e');
					} */

                                        $args = array();
					$args['select'] = array('dqi.id');
					$args['conditions'] = array('dq.id'=>$quotationID,'item_id'=>$postedItems['item_id'],'unit_id'=>$postedItems['unit_id'],'godown_id'=>$postedItems['godown_id']);
					$args['join'] = array('dms_quotations_items1 as dqi'=>'dq.id=dqi.qt_id');
					$check_temp_item = $this->quotation->get($args);

					if(empty($check_temp_item)){

						if($this->quotation->save_itemss(array('qt_id'=>$quotationID,'item_id'=>$postedItems['item_id'],'qty'=>$postedItems['qty'],'unit_id'=>$postedItems['unit_id'],'rate'=>$postedItems['rate'],'amount'=>$postedItems['amount'],'discount_per'=>$postedItems['discount_per'],'discount_amt'=>$postedItems['discount_amt'],'cgst' => $cgst,'sgst' => $sgst,'cgst_amt' => $cgst_amt,'sgst_amt'=>$sgst_amt,'godown_id'=>$postedItems['godown_id'],'status'=>1))){
							$this->message->set($this->lang->line('quotation-item-added'));
							redirect('quotations/edit/'.$quotationID.'/'.$urlString);
						}
					}else{
						$this->message->set($this->lang->line('quotation-item-exist'),'e');
					}
               


				}else{
					$this->message->set($this->lang->line('edit-so-gen-quotation'),'e');
				}
			}

		}

		if(isset($_POST['save_bill'])){

			$this->form_validation->set_rules('bill_no','lang:bill-no','xss_clean|required|is_natural|greater_than[0]');
			$this->form_validation->set_rules('bill_date','lang:bill-date','xss_clean|required|valid_date|is_date|check_date['.date('Y-m-d').'.<=]');
			$this->form_validation->set_rules('customer_fname','lang:first-name','xss_clean|required');
			$this->form_validation->set_rules('customer_lname','lang:last-name','xss_clean');
			$this->form_validation->set_rules('address','lang:address','xss_clean|required');
			$this->form_validation->set_rules('phone_no','lang:phone','xss_clean');
			$this->form_validation->set_rules('mobile_no','lang:mobile','xss_clean|required');
			$this->form_validation->set_rules('quotation_type','lang:quotation-type','xss_clean|required');
			$this->form_validation->set_rules('area_id','lang:area','xss_clean|required');
			$this->form_validation->set_rules('bill_discount_per','lang:discount','xclean');
			$this->form_validation->set_rules('bill_discount_amt','lang:discount','xclean');
			$this->form_validation->set_rules('remarks','lang:remarks','xclean');

			if($this->form_validation->run() === true){

				if($quotation_status == 0){
					$postedValues = $this->input->post();
					$bill_date = date('Y-m-d',strtotime($postedValues['bill_date']));
					if($this->quotation->check_bill_number($postedValues['bill_no'],array('id !='=>$quotationID)) == true){

						$this->quotation->update('dms_quotations',array('qt_no'=>$postedValues['bill_no'],'qt_date'=>$bill_date,'area_id'=>$postedValues['area_id'],'remarks'=>$postedValues['remarks'],'qt_discount_per'=>$postedValues['bill_discount_per'],'qt_discount_amt'=>$postedValues['bill_discount_amt'],'qt_type'=>$postedValues['quotation_type']),array('id'=>$quotationID));

						$this->message->set($this->lang->line('quotation-updated'));
						redirect('quotations/edit/'.$quotationID.'/'.$urlString);
					}else{
						$this->message->set($this->lang->line('quotation-number-exist'),'e');
					}

				}else{
					$this->message->set($this->lang->line('edit-so-gen-quotation'),'e');
				}
			}

		}

		foreach($inputSelects as $key=>$selectBox){
			$arrayName = $$selectBox;
			$arrayName[''] = 'Select';
			$$selectBox = $arrayName;
			ksort($$selectBox);
		}
		# view starts here--------------------------------
		$this->template->slice('dms/message');
		$this->template->slice('sales/quotations/edit_quotation',array('quotations'=>$quotations,'quotation_types'=>$quotation_types,'areas'=>$areas,'items'=>$items,'goDowns'=>$go_downs,'units'=>$units,'cst_enabled'=>$cstEnabled,'presumtiveTax' => $presumtiveTax));
		$this->template->other_script(array('sales/quotations'));
		$this->template->render();
	}

	#----------------------------------------------------------------------------------------------

	public function edit_item(){

		if(!$this->uri->segment(3)){
			redirect('quotations/report');
		}

		$qtnItemID = $this->uri->segment(3);
		if($this->if_exists('dms_quotations_items1',array('id'=>$qtnItemID,'status'=>1)) === false){
			redirect('quotations/report');
		}
		$uriArray = $this->uri->uri_to_assoc(4);
		$urlString = $this->uri->assoc_to_uri($uriArray);
		$quotations = array();$quotation_items = array();
		$this->template->title($this->lang->line('edit-quotation'));
		$this->template->main_heading($this->lang->line('edit-quotation'));
		$this->template->breadcrumb(array($this->lang->line('quotations') => 'quotations/add',$this->lang->line('report') => 'quotations/report',$this->lang->line('edit')=>'no_link',$this->lang->line('go-back')=>array('quotations/edit/'.$urlString)));

		$this->load->model('sales/Quotation_model','quotation');
		$args = array();
		$args['select'] = array('dq.id','dq.qt_no','dq.qt_date','dq.customer_id','dq.qt_type','dq.qt_discount_amt','dq.qt_discount_per','dq.cess','dq.area_id','dq.qt_status','dq.remarks','cm.fname as customer_fname','cm.lname as customer_lname','cm.address','cm.mobile_no','cm.phone_no','dqi.id as dqi_id','dqi.item_id','dqi.qty','dqi.unit_id','dqi.rate','dqi.amount','dqi.discount_per','dqi.discount_amt','dqi.vat','dqi.vat_amt','dqi.godown_id','im.item_code','im.item_name','um.symbol');
		$args['conditions'] = array('dq.status'=>1,'dqi.status'=>1,'dqi.id'=>$qtnItemID);
		$args['join'] = array('dms_quotations_items1 as dqi'=>'dq.id=dqi.qt_id','customer_master as cm'=>'cm.id=dq.customer_id','area_master as am'=>'dq.area_id=am.id','item_master as im'=>'dqi.item_id=im.id','unit_master as um'=>'dqi.unit_id=um.id');
		$quotations = $this->quotation->get($args);

		if(!empty($quotations)){

			$quotation_status = $quotations[0]['qt_status'];
			$quotationID = $quotations[0]['id'];
			$itemID = $quotations[0]['item_id'];
			$go_downs = $this->stock->get_item_godowns(array('item_id'=>$itemID,'listing'=>1));
			$units = $this->stock->get_units($itemID);
		}else{
			redirect('quotations/report');
		}
		$this->form_validation->set_rules('godown_id','lang:godown','required|xss_clean');
		$this->form_validation->set_rules('cst','lang:cst','xss_clean|greater_or_equal[0]|less_or_equal[100]');
		$this->form_validation->set_rules('qty','lang:quantity','required|xss_clean|greater_than[0]|less_than[100000000]');
		$this->form_validation->set_rules('unit_id','lang:unit','required|xss_clean');
		$this->form_validation->set_rules('rate','lang:rate','required|xss_clean|greater_or_equal[0]|less_than[100000000]');
		$this->form_validation->set_rules('amount','lang:amount','xss_clean|required|greater_or_equal[0]|less_than[100000000]');
		$this->form_validation->set_rules('discount_per','lang:discount %','xss_clean|greater_or_equal[0]|less_or_equal[100]');
		$this->form_validation->set_rules('discount_amt','lang:discount','xss_clean|greater_or_equal[0]|less_than[100000000]');
		$this->form_validation->set_rules('vat_amt','lang:vat-amt','xss_clean|greater_or_equal[0]|less_than[100000000]');
		if($this->form_validation->run() === true){

			if($quotation_status == 0){
				$postedValues = $this->input->post(NULL,true);
				$postedValues['rate'] =0;
				if($postedValues['qty'] > 0){
					$postedValues['rate'] = $postedValues['amount']/$postedValues['qty'];
				}
				if($this->quotation->update('dms_quotations_items1',array('qty'=>$postedValues['qty'],'unit_id'=>$postedValues['unit_id'],'rate'=>$postedValues['rate'],'amount'=>$postedValues['amount'],'discount_per'=>$postedValues['discount_per'],'discount_amt'=>$postedValues['discount_amt'],'cgst_amt'=>$postedValues['cgst_amt'],'sgst_amt'=>$postedValues['sgst_amt'],'godown_id'=>$postedValues['godown_id']),array('id'=>$qtnItemID))){
						$this->message->set($this->lang->line('quotation-updated'));
						redirect('quotations/edit/'.$urlString);
				}

			}else{
				$this->message->set($this->lang->line('edit-so-gen-quotation'),'e');
			}
		}

		# view starts here--------------------------------
		$this->template->slice('dms/message');
		$this->template->slice('sales/quotations/edit_quotation_item',array('quotations'=>$quotations,'goDowns'=>$go_downs,'units'=>$units));
		$this->template->other_script(array('sales/quotations'));
		$this->template->render();
	}

	#----------------------------------------------------------------------------------------------

	public function remove_item(){

		if(!$this->uri->segment(3)){
			redirect('quotations/report');
		}

		$qtnItemID = $this->uri->segment(3);
		if($this->if_exists('dms_quotations_items1',array('id'=>$qtnItemID,'status'=>1)) === false){
			redirect('quotations/report');
		}
		$uriArray = $this->uri->uri_to_assoc(4);
		$urlString = $this->uri->assoc_to_uri($uriArray);
		$quotations = array();$quotation_items = array();

		$this->load->model('sales/Quotation_model','quotation');
		$args = array();
		$args['select'] = array('dq.id','dq.qt_no','dq.qt_date','dq.customer_id','dq.qt_type','dq.qt_discount_amt','dq.qt_discount_per','dq.cess','dq.area_id','dq.qt_status','dq.remarks','cm.fname as customer_fname','cm.lname as customer_lname','cm.address','cm.mobile_no','cm.phone_no','dqi.id as dqi_id','dqi.item_id','dqi.qty','dqi.unit_id','dqi.rate','dqi.amount','dqi.discount_per','dqi.discount_amt','dqi.vat','dqi.vat_amt','dqi.godown_id','im.item_code','im.item_name','um.symbol');
		$args['conditions'] = array('dq.status'=>1,'dqi.status'=>1,'dqi.id'=>$qtnItemID);
		$args['join'] = array('dms_quotations_items1 as dqi'=>'dq.id=dqi.qt_id','customer_master as cm'=>'cm.id=dq.customer_id','area_master as am'=>'dq.area_id=am.id','item_master as im'=>'dqi.item_id=im.id','unit_master as um'=>'dqi.unit_id=um.id');
		$quotations = $this->quotation->get($args);

		if(!empty($quotations)){

			$quotation_status = $quotations[0]['qt_status'];
			$quotationID = $quotations[0]['id'];
			$itemID = $quotations[0]['item_id'];
			$go_downs = $this->stock->get_item_godowns(array('item_id'=>$itemID,'listing'=>1));
			$units = $this->stock->get_units($itemID);
		}else{
			redirect('quotations/report');
		}

		if($quotation_status == 0){
			if($this->quotation->delete_temp_items($qtnItemID)){
				$this->message->set($this->lang->line('item-deleted-from-bill'));
			}
		}else{
			$this->message->set($this->lang->line('edit-so-gen-quotation'),'e');
		}

		redirect('quotations/edit/'.$urlString);
	}

	#----------------------------------------------------------------------------------------------

	public function sales_order(){

		if($this->have_access(265) === false){
			$this->message->set($this->lang->line('no-sales-order-privileges'),'e');
			redirect('quotations/report');
		}
		if(!$this->uri->segment(3)){
			redirect('quotations/report');
		}
		$quotationID = $this->uri->segment(3);
		if($this->if_exists('dms_quotations',array('id'=>$quotationID,'status'=>1)) === false){
			redirect('quotations/report');
		}
		$uriArray = $this->uri->uri_to_assoc(4);
		$urlString = $this->uri->assoc_to_uri($uriArray);
		$quotations = array();$quotation_items = array();
		$insertCount=0;
		$this->template->title($this->lang->line('sales-order'));
		$this->template->main_heading($this->lang->line('sales-order'));
		$this->template->breadcrumb(array($this->lang->line('quotations') => 'quotations/add',$this->lang->line('report') => 'quotations/report',$this->lang->line('sales-order')=>'no_link',$this->lang->line('go-back')=>array('quotations/report/'.$urlString)));

		$this->load->model('sales/Quotation_model','quotation');
		$this->load->model('sales/Sales_order_temp_model','sales_order_temp');
		$this->load->model('accounts/Ledger_model','ledger');

		$args = array();
		$args['select'] = array('id','branch_id','so_no','so_date','customer_type_id','customer_id','user_id','pricelist_id');
		$args['conditions'] = array('branch_id'=>$this->branchID,'created_by'=>$this->createdBY);
		$SOTemps = $this->sales_order_temp->get_temp_order($args);

		if(!empty($SOTemps)){

			$this->message->set($this->lang->line('sales-order-exists'),'e');
			redirect('quotations/report');

		}else{

			$args = array();
			$args['select'] = array('dq.id','dq.branch_id','dq.qt_no','dq.qt_date','dq.customer_id','dq.qt_type','dq.qt_status','dq.area_id','dq.qt_discount_per','dq.qt_discount_amt','dq.cess','concat(cm.fname," ",cm.lname) as customer_name','cm.mobile_no');
			$args['conditions'] = array('dq.status'=>1,'dq.id'=>$quotationID);
			$args['join'] = array('customer_master as cm'=>'dq.customer_id=cm.id');
			$quotations = $this->quotation->get($args);
			$bill_num = $this->sales_order_temp->get_sales_order_number();

			foreach($quotations as $qKey=>$quotation){

				$quotation_id = $quotation['id'];
				$bill_date = date('Y-m-d',strtotime($quotation['qt_date']));
				$customerID = $quotation['customer_id'];
				$customerName = $quotation['customer_name'];
				$customerMobile = $quotation['mobile_no'];

				$args = array();
				$args['select'] = array('dqi.id as dqi_id','dqi.item_id','dqi.qty','dqi.unit_id','dqi.rate','dqi.amount','dqi.discount_per','dqi.discount_amt','dqi.vat_percent','dqi.vat_amt','dqi.cst','dqi.godown_id');
				$args['conditions'] = array('dq.status'=>1,'dqi.qt_id'=>$quotation_id);
				$args['join'] = array('dms_quotations_items as dqi'=>'dq.id=dqi.qt_id');
				$args['order_by'] = array('dqi.id'=>'asc');
				$quotation_items = $this->quotation->get($args);

				if(!empty($quotation_items)){

					$this->db->trans_start();
					$saveSoTempArray = array('branch_id'=>$this->branchID,'so_no'=>$bill_num,'so_date'=>$bill_date,'customer_type_id'=>2,'customer_id'=>$customerID,'area_id'=>$quotation['area_id'],'discount_per'=>$quotation['qt_discount_per'],'discount_amt'=>$quotation['qt_discount_amt'],'order_status'=>1,'order_id'=>$quotation_id,'created_by'=>$this->createdBY);

					if($this->sales_order_temp->save_temp_order($saveSoTempArray)){
						$salesOrderID = $this->db->insert_id();
					}

					$ledger['company_id'] = $this->companyID;
					$ledger['ledger_name'] = $customerName.'-'.$customerMobile;
					$ledger['branch_id'] = $this->branchID;
					$ledger['sgroup_id'] = 15;
					$ledger['dc'] = $this->ledger->get_dc(15);
					$ledgerID = $this->ledger->insert('dms_ledgers',$ledger);
					$this->quotation->update('customer_master',array('ledger_id'=>$ledgerID,'status'=>1),array('id'=>$customerID));

					foreach($quotation_items as $qiKey=>$quotation_item){

							$saveSoItemsArray = array('so_temp_id'=>$salesOrderID,'item_id'=>$quotation_item['item_id'],'godown_id'=>$quotation_item['godown_id'],'qty'=>$quotation_item['qty'],'unit_id'=>$quotation_item['unit_id'],'rate'=>$quotation_item['rate'],'amount'=>$quotation_item['amount'],'so_discount_per'=>$quotation_item['discount_per'],'so_discount_amt'=>$quotation_item['discount_amt'],'vat_percent'=>$quotation_item['vat_percent'],'vat_amt'=>$quotation_item['vat_amt'],'cst'=>$quotation_item['cst'],'created_by'=>$this->createdBY);

						if($this->sales_order_temp->save_temp_order_items($saveSoItemsArray)){
							$insertCount++;
						}
					}
					$this->db->trans_complete();
				}

			}

			if(!empty($insertCount)){

				redirect('sales_order/add');
				$this->message->set($this->lang->line('quotation-to-sales-oreder-redirecting'),'i');
			}


		}
		# view starts here--------------------------------
		$this->template->slice('dms/message');
		$this->template->slice('sales/quotations/quotation_to_sales_order',array());
		$this->template->other_script(array('sales/quotations'));
		$this->template->render();

	}

	#----------------------------------------------------------------------------------------------

	public function delete(){

		if(!$this->uri->segment(3)){
			redirect('quotations/report');
		}
		$quotationID = $this->uri->segment(3);
		if($this->if_exists('dms_quotations',array('id'=>$quotationID,'status'=>1)) === false){
			redirect('quotations/report');
		}
		$uriArray = $this->uri->uri_to_assoc(4);
		$urlString = $this->uri->assoc_to_uri($uriArray);
		$quotations = array();$quotation_items = array();
		$this->load->model('sales/Quotation_model','quotation');

		$args = array();
		$args['select'] = array('dq.id','dq.qt_no','dq.qt_date','dq.qt_status');
		$args['conditions'] = array('dq.id'=>$quotationID);
		$quotations = $this->quotation->get($args);
		if(!empty($quotations)){
			$quotation_status = $quotations[0]['qt_status'];
			if($quotation_status == 0){

				if($this->quotation->update('dms_quotations',array('status'=>0),array('id'=>$quotationID))){
					$this->quotation->update('dms_quotations_items1',array('status'=>0),array('qt_id'=>$quotationID));
					$this->message->set($this->lang->line('quotation-deleted'));
				}else{
				}

			}else{
				$this->message->set($this->lang->line('delete-so-gen-quotation'),'e');

			}
		}
		redirect('quotations/report/'.$urlString);

	}

	#----------------------------------------------------------------------------------------------

	public function pdf(){

		if(!$this->uri->segment(3)){
			echo "<script>alert('".$this->lang->line('invalid-quotation')."');window.close();</script>";
		}
		$quotationID = $this->uri->segment(3);
		if($this->if_exists('dms_quotations',array('id'=>$quotationID,'status'=>1)) === false){
			echo "<script>alert('".$this->lang->line('invalid-quotation')."');window.close();</script>";
		}
		$this->load->model('sales/Quotation_model','quotation');
		$this->load->library('My_pdf');
		$this->load->library('To_words');

		$quotations = array();$quotation_items = array();
		$quotation_types = array(0=>'Individual',1=>'Institutional');

		$this->my_pdf->set_tin();
		$this->my_pdf->set_header();
		$sales_orders = array();

		$args = array();
		$args['select'] = array('dq.id','dq.qt_no','dq.qt_date','dq.customer_id','dq.qt_type','dq.qt_discount_amt','dq.qt_discount_per','dq.cess','dq.remarks','cm.fname as customer_fname','cm.lname as customer_lname','cm.address','cm.mobile_no','cm.phone_no','am.area','dqi.id as dqi_id','dqi.item_id','dqi.qty','dqi.unit_id','dqi.rate','dqi.amount','dqi.discount_per','dqi.discount_amt','dqi.vat_amt','dqi.cst','dqi.godown_id','im.item_code','im.item_name','um.symbol');
		$args['conditions'] = array('dq.status'=>1,'dqi.status'=>1,'dq.id'=>$quotationID);
		$args['join'] = array('dms_quotations_items as dqi'=>'dq.id=dqi.qt_id','customer_master as cm'=>'cm.id=dq.customer_id','area_master as am'=>'dq.area_id=am.id','item_master as im'=>'dqi.item_id=im.id','unit_master as um'=>'dqi.unit_id=um.id');
		$args['order_by'] = array('dqi.id'=>'asc');
		$quotations = $this->quotation->get($args);

                if(empty($quotations))
                { 
                    $args = array();
		$args['select'] = array('dq.id','dq.qt_no','dq.qt_date','dq.customer_id','dq.qt_type','dq.qt_discount_amt','dq.qt_discount_per','dq.cess','dq.remarks','cm.fname as customer_fname','cm.lname as customer_lname','cm.address','cm.mobile_no','cm.phone_no','am.area','dqi.id as dqi_id','dqi.item_id','dqi.qty','dqi.unit_id','dqi.rate','dqi.amount','dqi.discount_per','dqi.discount_amt','dqi.vat_amt','dqi.godown_id','im.item_code','im.item_name','um.symbol');
		$args['conditions'] = array('dq.status'=>1,'dqi.status'=>1,'dq.id'=>$quotationID);
		$args['join'] = array('dms_quotations_items1 as dqi'=>'dq.id=dqi.qt_id','customer_master as cm'=>'cm.id=dq.customer_id','area_master as am'=>'dq.area_id=am.id','item_master as im'=>'dqi.item_id=im.id','unit_master as um'=>'dqi.unit_id=um.id');
		$args['order_by'] = array('dqi.id'=>'asc');
		$quotations = $this->quotation->get($args);

                }
		$cstEnabled=0;
		if(empty($quotations)){
			echo "<script>alert('".$this->lang->line('invalid-quotation')."');window.close();</script>";
		}else{
			$quotationID = $quotations[0]['id'];
			$args=array();
			$args['select'] = array('dqi.id');
			$args['conditions'] = array('dq.id'=>$quotationID,'dqi.cst >'=>0);
			$args['join'] = array('dms_quotations_items as dqi'=>'dq.id=dqi.qt_id');
			$cstEnabled = $this->quotation->get($args);
			$cstEnabled = count($cstEnabled);
		}
		$pdf_contents = $this->load->view('sales/quotations/quotations_pdf',array('quotations'=>$quotations,'quotation_types'=>$quotation_types,'cst_enabled'=>$cstEnabled),true);
		$this->my_pdf->output('sales_order',$pdf_contents);
	}

	#----------------------------------------------------------------------------------------------

}
?>