<?php if( ! defined('BASEPATH')) exit ('No direct script access allowed');

class Receipt_against_bill extends MY_Controller{

	var $companyID;
	var $branchID;
	var $createdBY;
	var $fiscal_start_date;
	var $fiscal_end_date;

	#------------------------------------

	public function __construct(){

		parent::__construct();
		$this->check_access_right();

		#---------------- Checking Financial year is enabled / closed-----------------#
		$method_array = array('add','edit','delete');
		fiscal_status($this->uri->segment(2),$method_array,"receipt_against_bill/report");
		#---------------- Checking Financial year is enabled / closed-----------------#

		$this->companyID = $this->session->userdata('company_id');
		$this->branchID = $this->session->userdata('under_id');
		$this->createdBY = $this->session->userdata('id');

		$fiscals = $this->dms->get_fiscal_year();
		$this->fiscal_start_date = $fiscals['start_date'];
		$this->fiscal_end_date = $fiscals['end_date'];
	}

	#----------------------------------------------------------------------

	public function add(){

		$this->template->title($this->lang->line('receipt-against-bill'));
		$this->template->main_heading($this->lang->line('receipt-against-bill'));
		$this->template->breadcrumb(array($this->lang->line('receipt-against-bill') => 'no_link',$this->lang->line('report') => 'receipt_against_bill/report'));

		$this->load->library('Stock');
		$this->load->model('designations/Designation_master_model','designations');
		$this->load->model('receipts/Receipt_against_bill_model','receipt_against_bill');
		$this->load->model('vouchers/Voucher_model','voucher');
		$this->load->library('Receipt_ab_lib');

		$customers = $customerBalanceBills = $bank_accounts = array();
		$inputSelects = array('customers','customerBalanceBills','bank_accounts');

		$receiptNo = $this->voucher->get_voucher_number(2);
		if($this->dms->get_main_branch($this->branchID) === true){
			$customerTypes = $this->designations->listing(array('department_id'=>0,'utype_status >'=>1));
		}else{
			$customerTypes = $this->designations->listing(array('department_id'=>0,'utype_status'=>4));
		}

		$CustTypeID=2;	$customer_id = NULL;$customer_bill=$bank = NULL;

		if($this->input->post('customer_type')){
			$CustTypeID = $this->input->post('customer_type');
			if($this->input->post('customer_id')){
				$customerID = $this->input->post('customer_id');
				$customerBalanceBills = $this->receipt_ab_lib->get_customer_bill($CustTypeID,$customerID);
			}
		}
		$existsRAB = array();
		$args = array();
		$args['select'] = array('dvab.id','dvab.bill_no','dvab.bill_date','dvab.customer_type_id','dvab.customer_id','dvabi.id as dvabi_id','dvabi.ps_id','dvabi.received_amount','dvabi.discount','ds.bill_no as sales_bill_no','ds.bill_date as sales_bill_date');
		$args['conditions'] = array('dvab.branch_id'=>$this->branchID,'dvab.bill_type'=>0,'dvab.status'=>-1,'dvab.created_by'=>$this->createdBY);
		$args['join'] = array('dms_voucher_against_bill_items as dvabi'=>'dvab.id=dvabi.vid','dms_sales as ds'=>'dvabi.ps_id=ds.id');
		$existsRAB = $this->receipt_against_bill->get($args);

		if(!empty($existsRAB)){

			$receipt_date = date('Y-m-d',strtotime($existsRAB[0]['bill_date']));
			$tempReceiptID = $existsRAB[0]['id'];
			$customer_type_id = $existsRAB[0]['customer_type_id'];
			$CustTypeID = $customer_type_id;
			$customer_id = $existsRAB[0]['customer_id'];
			$customerBalanceBills = $this->receipt_ab_lib->get_customer_bill($customer_type_id,$customer_id);
			$bank_accounts = $this->stock->payment_modes(array('sub_groups'=>array(14)));

		}
		$customers = $this->stock->get_customers($CustTypeID);
		if(isset($_POST['add_to_bill'])){

			if(empty($existsRAB)){

				$this->form_validation->set_rules('bill_date','lang:bill-date','xss_clean|required|valid_date|is_date|check_date['.date('Y-m-d').'.<=]');
				$this->form_validation->set_rules('customer_type','lang:customer-type','xss_clean');
				$this->form_validation->set_rules('customer_id','lang:customer-name','xss_clean|required');
			}
			$this->form_validation->set_rules('bill_no','lang:bill-no','xss_clean|required|is_natural|greater_than[0]');
			$this->form_validation->set_rules('customer_bill','lang:sales-bill','xss_clean|required');
			$this->form_validation->set_rules('received_amount','lang:received-amount','xss_clean|required|greater_than[0]');
			$this->form_validation->set_rules('discount_amount','lang:discount','xss_clean|numeric');
			$this->form_validation->set_rules('amount','lang:amount','xss_clean');
			$this->form_validation->set_rules('cbill_date','lang:bill-date','xss_clean');
			$this->form_validation->set_rules('cbill_amt','lang:bill-amount','xss_clean');
			$this->form_validation->set_rules('cpr_amt','lang:previous-receipts','xss_clean');
			if($this->form_validation->run() === true){

				$tempReceiptID = NULL;
				$postedItems = $this->input->post();
				$bill_num = $postedItems['bill_no'];
				if(empty($existsRAB)){
					$receipt_date = date('Y-m-d',strtotime($postedItems['bill_date']));
				}

				$args = array();
				$args['columns'] = array('id');
				$args['table'] = 'dms_vouchers';
				$args['conditions'] = array('vno'=>$bill_num,'vtype_id'=>2,'status !='=>0);
				$vouchers = $this->voucher->get_vouchers($args);

				$args = array();
				$args['columns'] = array('id');
				$args['table'] = 'dms_voucher_temps';
				$args['conditions'] = array('vno'=>$bill_num,'vtype_id'=>2);
				$vouchersTemps = $this->voucher->get_vouchers($args);

				if(empty($vouchers) && empty($vouchersTemps)){

					$sales_bill = $this->receipt_ab_lib->get_sales_bill($postedItems['customer_bill']);
					$bill_date = date('Y-m-d',strtotime($sales_bill['bill_date']));
					$bill_amount = round_this($sales_bill['bill_amount']);
					$total_paid_amount = $this->receipt_ab_lib->get_bill_payment($postedItems['customer_bill']);
					$balance_bill_amount = ($bill_amount-$total_paid_amount);

					if(strtotime($receipt_date) >= strtotime($bill_date)){

						if($postedItems['received_amount'] <= $balance_bill_amount){
							$this->db->trans_start();
							if(empty($existsRAB)){
								#---save temp data
								if($this->receipt_against_bill->save_bill(array('branch_id'=>$this->branchID,'bill_no'=>$bill_num,'bill_date'=>$receipt_date,'customer_type_id'=>$postedItems['customer_type'],'customer_id'=>$postedItems['customer_id'],'bill_type'=>0,'status'=>-1,'created_by'=>$this->createdBY))){
									$tempReceiptID = $this->db->insert_id();
								}
							}else{
								$tempReceiptID = $existsRAB[0]['id'];
								$this->receipt_against_bill->update(array('bill_no'=>$bill_num),array('id'=>$tempReceiptID));
							}

							if(!empty($tempReceiptID)){
								#dms_voucher_against_bill_items
								$args = array();
								$args['select'] = array('dvab.id');
								$args['conditions'] = array('dvab.id'=>$tempReceiptID,'dvabi.ps_id'=>$postedItems['customer_bill'],'dvabi.status'=>1);
								$args['join'] = array('dms_voucher_against_bill_items as dvabi'=>'dvab.id=dvabi.vid');
								$checkRcptBill = $this->receipt_against_bill->get($args);

								if(empty($checkRcptBill)){
									if($this->receipt_against_bill->save_bill_items(array('vid'=>$tempReceiptID,'ps_id'=>$postedItems['customer_bill'],'received_amount'=>$postedItems['received_amount'],'discount'=>$postedItems['discount_amount'],'status'=>1))){
										$this->message->set($this->lang->line('bill-added-to-rab'));
										$this->db->trans_complete();
										redirect('receipt_against_bill/add');
									}
								}else{
									$this->message->set($this->lang->line('same-bill-exists'),'e');
								}
							}
						}else{
							$this->message->set($this->lang->line('greater-balance-amount'),'e');
						}
					}else{
						$this->message->set($this->lang->line('enter-valid-receipt-date'),'e');
					}
				}else{
					$this->message->set($this->lang->line('enter-valid-rvoucher-number'),'e');
				}
			}
		}
		if(isset($_POST['save'])){

			$this->form_validation->set_rules('receipt_mode','lang:payment-mode','xss_clean|required');
			$this->form_validation->set_rules('bill_no','lang:bill-no','xss_clean|required|is_natural|greater_than[0]');
			$chequeNoRule = $chequeDateRule = $colBankRule = 'xss_clean';
			if($this->input->post('receipt_mode') && $this->input->post('receipt_mode') != 0){
				$chequeNoRule .= '|required';
				$chequeDateRule .= '|required|is_date';
				$colBankRule .= '|required';
				$this->form_validation->set_rules('ccd','lang:transaction-type','xss_clean|required');
			}
			$this->form_validation->set_rules('cheque_no','lang:cd-no',$chequeNoRule);
			$this->form_validation->set_rules('cheque_date','lang:cheque-date',$chequeDateRule);
			$this->form_validation->set_rules('payment_mode','lang:collection-bank',$colBankRule);
			$this->form_validation->set_rules('narration','lang:narration','xss_clean');
			if($this->form_validation->run('save') === true){

				$chequeDd = $this->input->post('receipt_mode');
				$bill_num = $this->input->post('bill_no');

				$args = array();
				$args['columns'] = array('id');
				$args['table'] = 'dms_vouchers';
				$args['conditions'] = array('vno'=>$bill_num,'vtype_id'=>2,'status !='=>0);
				$vouchers = $this->voucher->get_vouchers($args);

				$args = array();
				$args['columns'] = array('id');
				$args['table'] = 'dms_voucher_temps';
				$args['conditions'] = array('vno'=>$bill_num,'vtype_id'=>2);
				$vouchersTemps = $this->voucher->get_vouchers($args);

				if(empty($vouchers) && empty($vouchersTemps)){

					if($this->input->post('receipt_mode') != 0){
						$ccd = $this->input->post('ccd',true);
						$payment_mode = $this->input->post('payment_mode');
						$cheque_no = $this->input->post('cheque_no');
						$chequeDate = date('Y-m-d',strtotime($this->input->post('cheque_date')));
					}else{
						$ccd = 0;
						$payment_mode = 0;
						$cheque_no = NULL;
						$chequeDate = '0000-00-00';
					}

					$narration = $this->input->post('narration');
					$customerDetails = $this->stock->get_customer($customer_type_id,$customer_id,1);
					$cust_ledgerID = $customerDetails['ledger_id'];
					$cust_mobile = $customerDetails['mobile_no'];
					$cust_phone = $customerDetails['phone_no'];
					$cust_name = $customerDetails['name'];

					$drLedgerID = 1;# ledger id of CASH
					if($chequeDd > 0){
						$drLedgerID = $payment_mode;# ledger id of bank accounts
					}
					$this->db->trans_start();
					$updateArray = array('cash_type'=>$ccd,'payment_mode'=>$drLedgerID,'narration'=>$narration,'cheque_no'=>$cheque_no,'cheque_date'=>$chequeDate,'status'=>1);
					if($this->receipt_against_bill->update($updateArray,array('id'=>$tempReceiptID))){

						#-------voucher starts here---------------------------------------------------------------------
						$receiptAmounts = $this->receipt_against_bill->get_receipt_amount($tempReceiptID);
						$receiptAmount = $receiptAmounts['amount'];
						$receiptDiscount = $receiptAmounts['discount'];
						$receiptAmount = $receiptAmount-$receiptDiscount;
						$groupID = $this->stock->get_group_id('dms_vouchers');
						$voucherStatus = 1;
						if(strtotime($chequeDate) > strtotime($receipt_date) && $chequeDd >0){
							$voucherStatus = 3;
						}
						if($chequeDd > 0){
							if($this->voucher->insert('dms_voucher_banks',array('group_id'=>$groupID,'cash_type'=>$ccd,'cd_no'=>$cheque_no,'pdc'=>$chequeDate,'vdate'=>$receipt_date,'cq_status'=>0))){
							}
						}
						$this->voucher->insert("dms_vouchers",array('group_id'=>$groupID,'vtype_id'=>2,'vno'=>$bill_num,'vorder_no'=>1,'vdate'=>$receipt_date,'dr_ledger'=>$drLedgerID,'cr_ledger'=>$cust_ledgerID,'vamount'=>$receiptAmount,'table_name'=>'dms_voucher_against_bills','table_group_id'=>$tempReceiptID,'status'=>$voucherStatus));
						if(!empty($receiptDiscount) and $receiptDiscount>0){
							$this->voucher->insert("dms_vouchers",array('group_id'=>$groupID,'vtype_id'=>2,'vno'=>$bill_num,'vorder_no'=>2,'vdate'=>$receipt_date,'cr_ledger'=>$cust_ledgerID,'dr_ledger'=>10,'vamount'=>$receiptDiscount,'table_name'=>'dms_voucher_against_bills','table_group_id'=>$tempReceiptID,'status'=>$voucherStatus));
						}
						#----------------------------------------------------------------------------------------------------
						$this->message->set($this->lang->line('rab-saved'));
						$this->db->trans_complete();
						redirect('receipt_against_bill/add');
					}
				}else{
					$this->message->set($this->lang->line('enter-valid-rvoucher-number'),'e');
				}
			}
		}

		foreach($inputSelects as $key=>$selectBox){
			$arrayName = $$selectBox;
			$arrayName[''] = 'Select';
			$$selectBox = $arrayName;
			ksort($$selectBox);
		}
		# view starts here--------------------------------
		$this->template->slice('dms/message');
		$this->template->slice('receipt_against_bill/add_receipt_against_bill',array('bill_num'=>$receiptNo,'customer_types'=>$customerTypes,'cust_type'=>$CustTypeID,'customers'=>$customers,'customer_id'=>$customer_id,'customer_bills'=>$customerBalanceBills,'customer_bill'=>$customer_bill,'receipt_bill_items'=>$existsRAB,'bank_accounts'=>$bank_accounts,'bank'=>$bank));
		$this->template->other_script(array('receipts/receipt_against_bill'));
		$this->template->render();
	}

	#-----------------------------------------------------------------------

	public function remove_temp_item(){

		if(!$this->uri->segment(3)){
			redirect('users/logout');
		}
		$tempItemID = $this->uri->segment(3);

		if($this->if_exists('dms_voucher_against_bill_items',array('id'=>$tempItemID,'created_by'=>$this->createdBY)) === false){
			redirect('receipt_against_bill/add');
		}
		$this->load->model('receipts/Receipt_against_bill_model','receipt_against_bill');

		if($this->receipt_against_bill->delete_item($tempItemID)){
			$this->message->set($this->lang->line('item-deleted-from-bill'));
		}

		redirect('receipt_against_bill/add');
	}

	#-----------------------------------------------------------------------

	public function report(){

		$this->template->title($this->lang->line('receipt-against-bill-report'));
		$this->template->main_heading($this->lang->line('receipt-against-bill-report'));
		$this->template->breadcrumb(array($this->lang->line('receipt-against-bill') => 'receipt_against_bill/add',$this->lang->line('report') => 'no_link'));

		$this->load->library('Stock');
		$this->load->model('receipts/Receipt_against_bill_model','receipt_against_bill');
		$offset =0;$links=NULL;

		$this->load->library('Pagination');
		$config['per_page'] = $this->per_page();
		# Pagination Config Customizations
        $config['full_tag_open'] = '<ul class="pagination">';
        $config['full_tag_close'] = '</ul>';
        $config['first_link'] = 'First';
        $config['last_link'] = 'Last';
        $config['next_link'] = '&raquo;';
        $config['prev_link'] = '&laquo;';
        $config['cur_tag_open'] = '<li class="active"><a href="#">';
        $config['cur_tag_close'] = '</a></li>';
        $config['num_tag_open'] = '<li>';
        $config['num_tag_close'] = '</li>';
		$config['uri_segment'] = 3;
		$config['base_url'] = base_url('receipt_against_bill/report');
		$offset = ($this->uri->segment(3))?$this->uri->segment(3):0;

		$from_date = $this->fiscal_start_date;
		$to_date = $this->fiscal_end_date;
		if(isset($_POST['get'])){

			$this->form_validation->set_rules('from_date','lang:from-date','xss_clean|required|is_date|valid_date');
			$this->form_validation->set_rules('to_date','lang:to-date','xss_clean|required|is_date|valid_date');
			if($this->form_validation->run() === true){
				$from_date = date('Y-m-d',strtotime($this->input->post('from_date')));
				$to_date = date('Y-m-d',strtotime($this->input->post('to_date')));
				$config['base_url'] = base_url('receipt_against_bill/report/'.$from_date.'/'.$to_date);
			}
		}else if($this->uri->segment(3) && $this->uri->segment(4)){

			$from_date = date('Y-m-d',strtotime($this->uri->segment(3)));
			$to_date = date('Y-m-d',strtotime($this->uri->segment(4)));
			$config['uri_segment'] = 5;
			$offset = ($this->uri->segment(5))?$this->uri->segment(5):0;
			$config['base_url'] = base_url('receipt_against_bill/report/'.$from_date.'/'.$to_date);

		}else{
			$from_date = date('Y-m-d');#$this->fiscal_start_date;
			$to_date = date('Y-m-d');#$this->fiscal_end_date;
		}

		$args = array();
		$args['select'] = array('dvab.id');
		$args['num_rows'] = 1;
		$args['between'] = array($from_date,$to_date);
		$args['conditions'] = array('dvab.branch_id'=>$this->branchID,'dvab.bill_type'=>0,'dvab.status'=>1);
		$config['total_rows'] = $this->receipt_against_bill->get($args);
		$this->pagination->initialize($config);
		$links = $this->pagination->create_links();

		$args = array();
		$args['select'] = array('dvab.id','dvab.bill_no','dvab.bill_date','dvab.customer_type_id','dvab.customer_id','dvab.payment_mode','dvab.narration','dvab.cheque_no','dvab.cheque_date');
		$args['between'] = array($from_date,$to_date);
		$args['conditions'] = array('dvab.branch_id'=>$this->branchID,'dvab.bill_type'=>0,'dvab.status'=>1);
		$args['limit'] = $config['per_page'];
		$args['offset'] = $offset;
		$receipts = $this->receipt_against_bill->get($args);
		if(empty($receipts)){
			$this->message->set($this->lang->line('no-result-found'),'i');
		}
		foreach($receipts as $key=>$receipt){

			$args = array();$receiptAmount=0;
			$args['select'] = array('sum(received_amount) as receipt_amount');
			$args['conditions'] = array('dvab.id'=>$receipt['id'],'dvabi.status'=>1);
			$args['join'] = array('dms_voucher_against_bill_items as dvabi'=>'dvab.id=dvabi.vid');
			$receiptsDtls = $this->receipt_against_bill->get($args);

			$receiptsDtls = $this->receipt_against_bill->get_receipt_amount($receipt['id']);
			if(!empty($receiptsDtls)){
				$receiptAmount = $receiptsDtls['amount']-$receiptsDtls['discount'];
			}
			$receipts[$key]['amount'] = $receiptAmount;
		}


		# view starts here--------------------------------
		$this->template->slice('dms/message');
		$this->template->slice('date/between_date_search',array('from_date'=>$from_date,'to_date'=>$to_date));
		$this->template->slice('receipt_against_bill/receipt_against_bill_report',array('receipts'=>$receipts,'count'=>$offset+1,'links'=>$links));
		$this->template->other_script(array('receipts/receipt_against_bill'));
		$this->template->render();
	}

	#------------------------------------------------------------------------

	public function view(){

		if(!$this->uri->segment(3)){
			redirect('receipt_against_bill/report');
		}

		$receiptID = $this->uri->segment(3);
		if($this->if_exists('dms_voucher_against_bills',array('id'=>$receiptID,'status'=>1,'bill_type'=>0)) === false){
			redirect('receipt_against_bill/report');
		}
		$uriArray = $this->uri->uri_to_assoc(4);
		$urlString = $this->uri->assoc_to_uri($uriArray);
		$this->load->library('Stock');
		$this->load->model('receipts/Receipt_against_bill_model','receipt_against_bill');
		$this->load->library('Receipt_ab_lib');

		$this->template->title($this->lang->line('view-receipt-against-bill'));
		$this->template->main_heading($this->lang->line('view-receipt-against-bill'));
		$this->template->breadcrumb(array($this->lang->line('receipt-against-bill') => 'receipt_against_bill/add',$this->lang->line('report') => 'receipt_against_bill/report',$this->lang->line('view')=>'no_link',$this->lang->line('go-back')=>array('receipt_against_bill/report/'.$urlString)));

		$args = array();
		$args['select'] = array('dvab.id','dvab.bill_no','dvab.bill_date','dvab.customer_type_id','dvab.customer_id','dvab.cash_type','dvab.payment_mode','dvab.narration','dvab.cheque_no','dvab.cheque_date','dvabi.id as dvabi_id','dvabi.ps_id','dvabi.received_amount','dvabi.discount','ds.bill_no as sales_bill_no','ds.bill_date as sales_bill_date','dl.ledger_name');
		$args['conditions'] = array('dvab.id'=>$receiptID,'dvabi.status'=>1);
		$args['join'] = array('dms_voucher_against_bill_items as dvabi'=>'dvab.id=dvabi.vid','dms_sales as ds'=>'dvabi.ps_id=ds.id','dms_ledgers as dl'=>'dvab.payment_mode=dl.id');
		$receipts = $this->receipt_against_bill->get($args);

		# view starts here--------------------------------
		$this->template->slice('dms/message');
		$this->template->slice('receipt_against_bill/view_receipt_against_bill',array('receipts'=>$receipts));
		$this->template->other_script(array('receipts/receipt_against_bill'));
		$this->template->render();
	}

	#------------------------------------------------------------------------

	public function edit(){

		if(!$this->uri->segment(3)){
			redirect('receipt_against_bill/report');
		}

		$receiptID = $this->uri->segment(3);
		if($this->if_exists('dms_voucher_against_bills',array('id'=>$receiptID,'status'=>1,'bill_type'=>0)) === false){
			redirect('receipt_against_bill/report');
		}
		$uriArray = $this->uri->uri_to_assoc(4);
		$urlString = $this->uri->assoc_to_uri($uriArray);

		$this->load->library('Stock');
		$this->load->model('designations/Designation_master_model','designations');
		$this->load->model('receipts/Receipt_against_bill_model','receipt_against_bill');
		$this->load->library('Receipt_ab_lib');

		$this->template->title($this->lang->line('edit-receipt-against-bill'));
		$this->template->main_heading($this->lang->line('edit-receipt-against-bill'));
		$this->template->breadcrumb(array($this->lang->line('receipt-against-bill') => 'receipt_against_bill/add',$this->lang->line('report') => 'receipt_against_bill/report',$this->lang->line('edit')=>'no_link',$this->lang->line('go-back')=>array('receipt_against_bill/report/'.$urlString)));

		$customers = $customerBalanceBills = $bank_accounts = array();
		$inputSelects = array('customers','customerBalanceBills','bank_accounts');

		$customerTypes = $this->designations->listing(array('department_id'=>0,'utype_status >'=>1));
		$CustTypeID=2;	$customer_id = NULL;$customer_bill=$bank = NULL;
		$customers = $this->stock->get_customers($CustTypeID);
		$bank_accounts = $this->stock->payment_modes(array('sub_groups'=>array(14)));

		$args = array();
		$args['select'] = array('dvab.id','dvab.bill_no','dvab.bill_date','dvab.customer_type_id','dvab.customer_id','dvab.cash_type','dvab.payment_mode','dvab.narration','dvab.cheque_no','dvab.cheque_date','dvabi.id as dvabi_id','dvabi.ps_id','dvabi.received_amount','dvabi.discount','ds.bill_no as sales_bill_no','ds.bill_date as sales_bill_date','dl.ledger_name');
		$args['conditions'] = array('dvab.id'=>$receiptID,'dvabi.status'=>1);
		$args['join'] = array('dms_voucher_against_bill_items as dvabi'=>'dvab.id=dvabi.vid','dms_sales as ds'=>'dvabi.ps_id=ds.id','dms_ledgers as dl'=>'dvab.payment_mode=dl.id');
		$receipts = $this->receipt_against_bill->get($args);

		$args = array();
		$args['select'] = array('dv.*','dv.status as voucher_status','dv.group_id as voucher_group');
		$args['conditions'] = array('dvab.id'=>$receiptID,'dv.table_name'=>'dms_voucher_against_bills','dv.status !='=>0);
		$args['join'] = array('dms_vouchers as dv'=>'dvab.id=dv.table_group_id');
		$voucher_details = $this->receipt_against_bill->get($args);

		$preVoucherStatus=0;$voucherGroupID=$voucherDrLedger=0;
		if(!empty($receipts)){

			$customerTypeID = $receipts[0]['customer_type_id'];
			$customerID = $receipts[0]['customer_id'];
			$preCashType = $receipts[0]['cash_type'];
			$receipt_date = $receipts[0]['bill_date'];

			$customerDetails = $this->stock->get_customer($customerTypeID,$customerID,1);
			$cust_ledgerID = $customerDetails['ledger_id'];
			$cust_mobile = $customerDetails['mobile_no'];
			$cust_phone = $customerDetails['phone_no'];
			$cust_name = $customerDetails['name'];

			$args = array();
			if(!empty($voucher_details)){
				$preVoucherStatus = $voucher_details[0]['voucher_status'];
				$voucherGroupID = $voucher_details[0]['voucher_group'];
				$voucherDrLedger = $voucher_details[0]['dr_ledger'];
			}
			$preCashType = $receipts[0]['cash_type'];
			$receipt_date = $receipts[0]['bill_date'];
			$receipt_number = $receipts[0]['bill_no'];
			$vendorBalanceBills = $this->receipt_ab_lib->get_customer_bill($customerTypeID,$customerID);
		}

		if(isset($_POST['add_to_bill'])){

			$this->form_validation->set_rules('bill_no','lang:bill-no','xss_clean|required|is_natural|greater_than[0]');
			$this->form_validation->set_rules('bill_date','lang:bill-date','xss_clean|required|valid_date|is_date|check_date['.date('Y-m-d').'.<=]');
			$this->form_validation->set_rules('customer_bill','lang:sales-bill','xss_clean|required');
			$this->form_validation->set_rules('received_amount','lang:received-amount','xss_clean|required|greater_than[0]');
			$this->form_validation->set_rules('discount_amount','lang:discount','xss_clean|numeric');
			$this->form_validation->set_rules('amount','lang:amount','xss_clean');
			$this->form_validation->set_rules('cbill_date','lang:bill-date','xss_clean');
			$this->form_validation->set_rules('cbill_amt','lang:bill-amount','xss_clean');
			$this->form_validation->set_rules('cpr_amt','lang:previous-receipts','xss_clean');

			if($this->form_validation->run('add_to_bill') === true){

				$cust_bill = $this->input->post('customer_bill');
				$received_amount = $this->input->post('received_amount');
				$args = array();
				$args['select'] = array('dvab.id');
				$args['conditions'] = array('dvab.id'=>$receiptID,'dvabi.ps_id'=>$cust_bill,'dvabi.status'=>1);
				$args['join'] = array('dms_voucher_against_bill_items as dvabi'=>'dvab.id=dvabi.vid');
				$checkRcptBill = $this->receipt_against_bill->get($args);
				if(empty($checkRcptBill)){

					if($this->receipt_against_bill->save_bill_items(array('vid'=>$receiptID,'ps_id'=>$cust_bill,'received_amount'=>$received_amount,'status'=>1))){

						#====================================
						#---update voucher----------------------------------------------
						$receiptAmounts = $this->receipt_against_bill->get_receipt_amount($receiptID);
						$receiptDiscount = $receiptAmounts['discount'];
						$receiptAmount = $receiptAmounts['amount']-$receiptDiscount;

						$this->load->model('vouchers/Voucher_model','voucher');
						$args = array();
						$args['table'] = 'dms_vouchers';
						$args['columns'] = array('id');
						$args['conditions'] = array('table_name'=>'dms_voucher_against_bills','table_group_id'=>$receiptID,'dr_ledger'=>10);
						$dicount_voucher = $this->dms->get_data($args);

						$this->voucher->update(array('table'=>'dms_vouchers','data'=>array('vamount'=>$receiptAmount),'conditions'=>array('table_name'=>'dms_voucher_against_bills','table_group_id'=>$receiptID,'vorder_no'=>1)));
						if(empty($dicount_voucher)){
							if(!empty($receiptDiscount)){

								$this->voucher->insert("dms_vouchers",array('group_id'=>$voucherGroupID,'vtype_id'=>2,'vno'=>$receipt_number,'vorder_no'=>2,'vdate'=>$receipt_date,'cr_ledger'=>$cust_ledgerID,'dr_ledger'=>10,'vamount'=>$receiptDiscount,'table_name'=>'dms_voucher_against_bills','table_group_id'=>$receiptID,'status'=>$voucherStatus));

							}
						}else{
							if(!empty($receiptDiscount)){
								$this->voucher->update(array('table'=>'dms_vouchers','data'=>array('vamount'=>$receiptDiscount,'status'=>1),'conditions'=>array('table_name'=>'dms_voucher_against_bills','table_group_id'=>$receiptID,'dr_ledger'=>10)));
							}else{
								$this->voucher->update(array('table'=>'dms_vouchers','data'=>array('vamount'=>$receiptDiscount,'status'=>0),'conditions'=>array('table_name'=>'dms_voucher_against_bills','table_group_id'=>$receiptID,'dr_ledger'=>10)));
							}
						}
						#====================================
						$this->db->trans_complete();
						$this->message->set($this->lang->line('bill-added-to-rab'));
						redirect('receipt_against_bill/edit/'.$receiptID);
					}

				}else{
					$this->message->set($this->lang->line('same-bill-exists'),'e');
				}
			}

		}



		if(isset($_POST['save'])){

			$this->form_validation->set_rules('bill_no','lang:bill-no','xss_clean|required|is_natural|greater_than[0]');
			$this->form_validation->set_rules('bill_date','lang:bill-date','xss_clean|required|valid_date|is_date|check_date['.date('Y-m-d').'.<=]');
			$this->form_validation->set_rules('receipt_mode','lang:payment-mode','xss_clean|required');
			$chequeNoRule = $chequeDateRule = $colBankRule = 'xss_clean';
			if($this->input->post('receipt_mode') && $this->input->post('receipt_mode') != 0){
				$chequeNoRule .= '|required';
				$chequeDateRule .= '|required|is_date';
				$colBankRule .= '|required';
				$this->form_validation->set_rules('ccd','lang:transaction-type','xss_clean|required');
			}
			$this->form_validation->set_rules('cheque_no','lang:cd-no',$chequeNoRule);
			$this->form_validation->set_rules('cheque_date','lang:cheque-date',$chequeDateRule);
			$this->form_validation->set_rules('payment_mode','lang:collection-bank',$colBankRule);
			$this->form_validation->set_rules('narration','lang:narration','xss_clean');

			if($this->form_validation->run('save') === true){

				$chequeDd = $this->input->post('receipt_mode');
				$bill_no = $this->input->post('bill_no');
				$receipt_date = date('Y-m-d',strtotime($this->input->post('bill_date')));
				$narration = $this->input->post('narration');

				$args = array();
				$args['select'] = array('dvab.id');
				$args['conditions'] = array('dvab.id !='=>$receiptID,'bill_no'=>$bill_no,'bill_type'=>0);
				$checkPmnt = $this->receipt_against_bill->get($args);

				if(empty($checkPmnt)){

					if($this->input->post('receipt_mode') != 0){
						$ccd = $this->input->post('ccd',true);
						$payment_mode = $this->input->post('payment_mode');
						$cheque_no = $this->input->post('cheque_no');
						$chequeDate = date('Y-m-d',strtotime($this->input->post('cheque_date')));
					}else{
						$ccd = 0;
						$payment_mode = 0;
						$cheque_no = NULL;
						$chequeDate = '0000-00-00';
					}

					$drLedgerID = 1;# ledger id of CASH
					if($chequeDd > 0){
						$drLedgerID = $payment_mode;# ledger id of bank accounts
					}

					$this->db->trans_start();
					$updateArray = array('bill_no'=>$bill_no,'bill_date'=>$receipt_date,'cash_type'=>$ccd,'payment_mode'=>$drLedgerID,'narration'=>$narration,'cheque_no'=>$cheque_no,'cheque_date'=>$chequeDate,'status'=>1);
					if($this->receipt_against_bill->update($updateArray,array('id'=>$receiptID))){

						#------Voucher Updates------------------------------
						$this->load->model('vouchers/Voucher_model','voucher');
						$voucherStatus = 1;

						if(strtotime($chequeDate) > strtotime($receipt_date) && $chequeDd >0){
							$voucherStatus = 3;
						}
						if($chequeDd > 0)
						{
							if($this->if_exists('dms_voucher_banks',array('group_id'=>$voucherGroupID)) === true){

								$upVbnks = array('cash_type'=>$ccd,'cd_no'=>$cheque_no,'pdc'=>$chequeDate,'vdate'=>$receipt_date,'status'=>1);
								$this->voucher->update(array('table'=>'dms_voucher_banks','data'=>$upVbnks,'conditions'=>array('group_id'=>$voucherGroupID)));

							}else{

								$this->voucher->insert('dms_voucher_banks',array('group_id'=>$voucherGroupID,'cash_type'=>$ccd,'cd_no'=>$cheque_no,'pdc'=>$chequeDate,'vdate'=>$receipt_date,'cq_status'=>0));
							}

						}else{
							$this->voucher->update(array('table'=>'dms_voucher_banks','data'=>array('status'=>0),'conditions'=>array('group_id'=>$voucherGroupID)));
						}
						if($preCashType >0 && $preVoucherStatus ==1){
							$voucherStatus=1;
						}
						$this->voucher->update(array('table'=>'dms_vouchers','data'=>array('vdate'=>$receipt_date,'dr_ledger'=>$drLedgerID,'narration' => $narration,'status'=>$voucherStatus),'conditions'=>array('group_id'=>$voucherGroupID,'table_name'=>'dms_voucher_against_bills','table_group_id'=>$receiptID)));

						$this->db->trans_complete();
						$this->message->set($this->lang->line('rab-saved'));
						redirect('receipt_against_bill/edit/'.$receiptID.'/'.$urlString);
						#--------------------------------------------------------
					}else{
						$this->message->set($this->lang->line('rab-bill-already-exists'),'e');
					}
				}
			}
		}
		foreach($inputSelects as $key=>$selectBox){
			$arrayName = $$selectBox;
			$arrayName[''] = 'Select';
			$$selectBox = $arrayName;
			ksort($$selectBox);
		}

		# view starts here--------------------------------
		$this->template->slice('dms/message');
		$this->template->slice('receipt_against_bill/edit_receipt_against_bill',array('receipts'=>$receipts,'customer_types'=>$customerTypes,'customers'=>$customers,'customer_bills'=>$customerBalanceBills,'customer_bill'=>$customer_bill,'bank_accounts'=>$bank_accounts,'bank'=>$bank));
		$this->template->other_script(array('receipts/receipt_against_bill'));
		$this->template->render();
	}

	#-------------------------------------------------------------------------

	public function edit_item(){

		if(!$this->uri->segment(3)){
			redirect('receipt_against_bill/report');
		}

		$receiptItemID = $this->uri->segment(3);
		if($this->if_exists('dms_voucher_against_bill_items',array('id'=>$receiptItemID,'status'=>1)) === false){
			redirect('receipt_against_bill/report');
		}
		$uriArray = $this->uri->uri_to_assoc(4);
		$urlString = $this->uri->assoc_to_uri($uriArray);
		$this->load->library('Stock');
		$this->load->model('receipts/Receipt_against_bill_model','receipt_against_bill');
		$this->load->library('Receipt_ab_lib');

		$this->template->title($this->lang->line('edit-receipt-against-bill'));
		$this->template->main_heading($this->lang->line('edit-receipt-against-bill'));
		$this->template->breadcrumb(array($this->lang->line('receipt-against-bill') => 'receipt_against_bill/add',$this->lang->line('report') => 'receipt_against_bill/report',$this->lang->line('edit')=>'no_link',$this->lang->line('go-back')=>array('receipt_against_bill/edit/'.$urlString)));

		$args = array();
		$args['select'] = array('dvab.id','dvab.bill_no','dvab.bill_date','dvab.customer_type_id','dvab.customer_id','dvab.cash_type','dvab.payment_mode','dvab.narration','dvab.cheque_no','dvab.cheque_date','dvabi.id as dvabi_id','dvabi.ps_id','dvabi.received_amount','dvabi.discount','ds.bill_no as sales_bill_no','ds.bill_date as sales_bill_date');
		$args['conditions'] = array('dvabi.id'=>$receiptItemID,'dvabi.status'=>1);
		$args['join'] = array('dms_voucher_against_bill_items as dvabi'=>'dvab.id=dvabi.vid','dms_sales as ds'=>'dvabi.ps_id=ds.id');
		$receipts = $this->receipt_against_bill->get($args);
		$customerBalanceBills = array(''=>'Select');

		if(!empty($receipts)){

			$args = array();
			$receiptID = $receipts[0]['id'];
			$receipt_date = $receipts[0]['bill_date'];
			$receipt_number = $receipts[0]['bill_no'];

			$args = array();
			$args['select'] = array('dv.*','dv.status as voucher_status','dv.group_id as voucher_group');
			$args['conditions'] = array('dvab.id'=>$receiptID,'dv.table_name'=>'dms_voucher_against_bills','dv.status !='=>0);
			$args['join'] = array('dms_vouchers as dv'=>'dvab.id=dv.table_group_id');
			$voucher_details = $this->receipt_against_bill->get($args);
			$preVoucherStatus=0;$voucherGroupID=$voucherDrLedger=0;
			if(!empty($voucher_details)){
				$preVoucherStatus = $voucher_details[0]['voucher_status'];
				$voucherGroupID = $voucher_details[0]['voucher_group'];
				$voucherDrLedger = $voucher_details[0]['dr_ledger'];
			}

			$customerBalanceBills = $this->receipt_against_bill->get_customer_bill(array('customer_type_id'=>$receipts[0]['customer_type_id'],'customer_id'=>$receipts[0]['customer_id']));
			$previous_receipts=$bill_amount=$received_amount=0;
			$disabled = 'disabled';
			$sales_bill = $this->receipt_ab_lib->get_sales_bill($receipts[0]['ps_id']);
			$bill_amount = round_this($sales_bill['bill_amount']);
			$received_amount = $receipts[0]['received_amount'];
			$discount_amount = $receipts[0]['discount'];
			$amount = $received_amount-$discount_amount;
			#$condition = array('dvab.bill_date <='=>$receipts[0]['bill_date'],'dvab.bill_no <='=>$receipts[0]['bill_no']);
			$paid_amount = $this->receipt_ab_lib->get_bill_payment($receipts[0]['ps_id']);
			$total_paid_amount = $this->receipt_ab_lib->get_bill_payment($receipts[0]['ps_id']);
			$total_paid_amount -= $received_amount;
			if($paid_amount >0){
				$previous_receipts = $paid_amount-$received_amount;
			}
			$balance_amount = $bill_amount-$total_paid_amount;
		}

		$this->form_validation->set_rules('received_amount','lang:received-amount','xss_clean|required|greater_than[0]|less_or_equal['.$balance_amount.']');
		$this->form_validation->set_rules('discount_amount','lang:discount','xss_clean|numeric');
		$this->form_validation->set_rules('amount','lang:amount','xss_clean');
		if($this->form_validation->run() === true){

			$receivedAmount= $this->input->post('received_amount');
			$discount_amt = $this->input->post('discount_amount');
			$this->db->trans_start();
			if($this->receipt_against_bill->update_receipt_item(array('received_amount'=>$receivedAmount,'discount'=>$discount_amt),array('id'=>$receiptItemID))){

				#====================================
				#---update voucher----------------------------------------------
				$receiptAmounts = $this->receipt_against_bill->get_receipt_amount($receiptID);
				$receiptDiscount = $receiptAmounts['discount'];
				$receiptAmount = $receiptAmounts['amount']-$receiptDiscount;

				$args = array();
				$args['table'] = 'dms_vouchers';
				$args['columns'] = array('id');
				$args['conditions'] = array('table_name'=>'dms_voucher_against_bills','table_group_id'=>$receiptID,'dr_ledger'=>10);
				$dicount_voucher = $this->dms->get_data($args);

				$this->load->model('vouchers/Voucher_model','voucher');
				$this->voucher->update(array('table'=>'dms_vouchers','data'=>array('vamount'=>$receiptAmount,'status'=>1),'conditions'=>array('table_name'=>'dms_voucher_against_bills','table_group_id'=>$receiptID,'status !='=>0,'vorder_no'=>1)));

				if(empty($dicount_voucher)){

					if(!empty($receiptDiscount)){

						$this->voucher->insert("dms_vouchers",array('group_id'=>$voucherGroupID,'vtype_id'=>2,'vno'=>$receipt_number,'vorder_no'=>2,'vdate'=>$receipt_date,'cr_ledger'=>$voucherDrLedger,'dr_ledger'=>10,'vamount'=>$receiptDiscount,'table_name'=>'dms_voucher_against_bills','table_group_id'=>$receiptID,'status'=>$preVoucherStatus));

					}
				}else{

					if(!empty($receiptDiscount)){
						$this->voucher->update(array('table'=>'dms_vouchers','data'=>array('vamount'=>$receiptDiscount,'status'=>1),'conditions'=>array('table_name'=>'dms_voucher_against_bills','table_group_id'=>$receiptID,'dr_ledger'=>10)));
					}else{
						$this->voucher->update(array('table'=>'dms_vouchers','data'=>array('vamount'=>$receiptDiscount,'status'=>0),'conditions'=>array('table_name'=>'dms_voucher_against_bills','table_group_id'=>$receiptID,'dr_ledger'=>10)));
					}
				}
				#====================================
				$this->message->set($this->lang->line('rab-saved'));
				$this->db->trans_complete();
				redirect('receipt_against_bill/edit/'.$urlString);
			}
		}

		# view starts here--------------------------------
		$this->template->slice('dms/message');
		$this->template->slice('receipt_against_bill/edit_receipt_against_bill_item',array('receipts'=>$receipts,'customer_bills'=>$customerBalanceBills,'bill_amount'=>$bill_amount,'previous_receipts'=>$previous_receipts,'received_amount'=>$received_amount,'discount'=>$discount_amount,'amount'=>$amount));
		$this->template->other_script(array('receipts/receipt_against_bill'));
		$this->template->render();

	}

	#-------------------------------------------------------------------------

	public function remove_item(){

		if(!$this->uri->segment(3)){
			redirect('receipt_against_bill/report');
		}
		$receiptItemID = $this->uri->segment(3);
		if($this->if_exists('dms_voucher_against_bill_items',array('id'=>$receiptItemID,'status'=>1)) === false){
			redirect('receipt_against_bill/report');
		}
		$uriArray = $this->uri->uri_to_assoc(4);
		$urlString = $this->uri->assoc_to_uri($uriArray);
		$this->load->model('receipts/Receipt_against_bill_model','receipt_against_bill');
		$this->load->library('Receipt_ab_lib');

		$args = array();
		$args['select'] = array('dvab.id');
		$args['conditions'] = array('dvabi.id'=>$receiptItemID,'dvabi.status'=>1);
		$args['join'] = array('dms_voucher_against_bill_items as dvabi'=>'dvab.id=dvabi.vid');
		$receipts = $this->receipt_against_bill->get($args);
		if(!empty($receipts)){
			$receiptID = $receipts[0]['id'];
			$receipt_date = $receipts[0]['bill_date'];
			$receipt_number = $receipts[0]['bill_no'];
			$args = array();
			$args['select'] = array('dv.*','dv.status as voucher_status','dv.group_id as voucher_group');
			$args['conditions'] = array('dvab.id'=>$receiptID,'dv.table_name'=>'dms_voucher_against_bills','dv.status !='=>0);
			$args['join'] = array('dms_vouchers as dv'=>'dvab.id=dv.table_group_id');
			$voucher_details = $this->receipt_against_bill->get($args);
			$preVoucherStatus=0;$voucherGroupID=$voucherDrLedger=0;
			if(!empty($voucher_details)){
				$preVoucherStatus = $voucher_details[0]['voucher_status'];
				$voucherGroupID = $voucher_details[0]['voucher_group'];
				$voucherDrLedger = $voucher_details[0]['dr_ledger'];
			}

			$this->db->trans_start();
			if($this->receipt_against_bill->update_receipt_item(array('status'=>0),array('id'=>$receiptItemID))){
				#====================================

				$args = array();
				$args['select'] = array('dvab.id');
				$args['conditions'] = array('dvab.id'=>$receiptID,'dvabi.status'=>1);
				$args['num_rows'] = 1;
				$args['join'] = array('dms_voucher_against_bill_items as dvabi'=>'dvab.id=dvabi.vid');
				$receiptsItemsCount = $this->receipt_against_bill->get($args);
				if(empty($receiptsItemsCount)){
					$this->receipt_against_bill->update(array('status'=>0),array('id'=>$receiptID));
				}
				#---update voucher----------------------------------------------
				$receiptAmounts = $this->receipt_against_bill->get_receipt_amount($receiptID);
				$receiptDiscount = $receiptAmounts['discount'];
				$receiptAmount = $receiptAmounts['amount']-$receiptDiscount;
				$args = array();
				$args['table'] = 'dms_vouchers';
				$args['columns'] = array('id');
				$args['conditions'] = array('table_name'=>'dms_voucher_against_bills','table_group_id'=>$receiptID,'dr_ledger'=>10);
				$dicount_voucher = $this->dms->get_data($args);

				$this->load->model('vouchers/Voucher_model','voucher');
				$updateArray = array('vamount'=>$receiptAmount);
				if(empty($receiptAmount)){
					$updateArray['status'] = 0;
				}
				$this->voucher->update(array('table'=>'dms_vouchers','data'=>$updateArray,'conditions'=>array('table_name'=>'dms_voucher_against_bills','table_group_id'=>$receiptID,'status !='=>0,'vorder_no'=>1)));
				if(!empty($dicount_voucher)){
					if(!empty($receiptDiscount)){
						$this->voucher->update(array('table'=>'dms_vouchers','data'=>array('vamount'=>$receiptDiscount,'status'=>0),'conditions'=>array('table_name'=>'dms_voucher_against_bills','table_group_id'=>$receiptID,'dr_ledger'=>10)));
					}else{
						$this->voucher->update(array('table'=>'dms_vouchers','data'=>array('vamount'=>$receiptDiscount,'status'=>0),'conditions'=>array('table_name'=>'dms_voucher_against_bills','table_group_id'=>$receiptID,'dr_ledger'=>10)));
					}
				}
				#====================================
				$this->message->set($this->lang->line('bill-added-to-rab'));
			}
			$this->db->trans_complete();
		}
		redirect('receipt_against_bill/edit/'.$urlString);
	}

	#-------------------------------------------------------------------------

	public function delete(){

		if(!$this->uri->segment(3)){
			redirect('receipt_against_bill/report');
		}
		$receiptID = $this->uri->segment(3);
		if($this->if_exists('dms_voucher_against_bills',array('id'=>$receiptID,'status'=>1,'bill_type'=>0)) === false){
			redirect('receipt_against_bill/report');
		}
		$uriArray = $this->uri->uri_to_assoc(4);
		$urlString = $this->uri->assoc_to_uri($uriArray);
		$this->load->model('receipts/Receipt_against_bill_model','receipt_against_bill');
		$this->db->trans_start();
		if($this->receipt_against_bill->update(array('status'=>0),array('id'=>$receiptID))){
			$this->receipt_against_bill->update_receipt_item(array('status'=>0),array('vid'=>$receiptID));
			#---update voucher----------------------------------------------
			$receiptAmounts = $this->receipt_against_bill->get_receipt_amount($receiptID);
			$receiptAmount = $receiptAmounts['amount']-$receiptAmounts['discount'];
			$this->load->model('vouchers/Voucher_model','voucher');
			$updateArray = array('vamount'=>$receiptAmount);
			if(empty($receiptAmount)){
				$updateArray['status'] = 0;
			}
			$args = array();
			$args['columns'] = array('id','group_id');
			$args['table'] = 'dms_vouchers';
			$args['conditions'] = array('table_name'=>'dms_voucher_against_bills','table_group_id'=>$receiptID);
			$voucherDtls = $this->voucher->get_vouchers($args);
			$voucherGroupId = $voucherDtls[0]['group_id'];
			$this->voucher->update(array('table'=>'dms_vouchers','data'=>$updateArray,'conditions'=>array('table_name'=>'dms_voucher_against_bills','table_group_id'=>$receiptID,'status'=>1)));
			$this->voucher->update(array('table'=>'dms_voucher_banks','data'=>array('status'=>0),'conditions'=>array('group_id'=>$voucherGroupId)));
			#====================================
			$this->message->set($this->lang->line('bill-added-to-rab'));
		}
		$this->db->trans_complete();
		redirect('receipt_against_bill/report/'.$urlString);
	}

	#-------------------------------------------------------------------------

	public function pdf(){

		if(!$this->uri->segment(3)){
			echo "<script>alert('".$this->lang->line('invalid-ra-bill')."');window.close();</script>";
		}
		$receiptID = $this->uri->segment(3);
		if($this->if_exists('dms_voucher_against_bills',array('id'=>$receiptID,'status'=>1,'bill_type'=>0)) === false){
			echo "<script>alert('".$this->lang->line('invalid-ra-bill')."');window.close();</script>";
		}
		$pdf_name ='receipt_voucher';
		$this->load->library('Stock');
		$this->load->model('receipts/Receipt_against_bill_model','receipt_against_bill');
		$this->load->library('Receipt_ab_lib');
		$this->load->library('My_pdf');
		$this->load->library('To_words');

		$this->my_pdf->set_tin();
		$this->my_pdf->set_header();
		$receipts = array();
		$args = array();
		$args['select'] = array('dvab.id','dvab.bill_no','dvab.bill_date','dvab.customer_type_id','dvab.customer_id','dvab.cash_type','dvab.payment_mode','dvab.narration','dvab.cheque_no','dvab.cheque_date','dvabi.id as dvabi_id','dvabi.ps_id','dvabi.received_amount','dvabi.discount','ds.bill_no as sales_bill_no','ds.bill_date as sales_bill_date','dl.ledger_name');
		$args['conditions'] = array('dvab.id'=>$receiptID,'dvabi.status'=>1);
		$args['join'] = array('dms_voucher_against_bill_items as dvabi'=>'dvab.id=dvabi.vid','dms_sales as ds'=>'dvabi.ps_id=ds.id','dms_ledgers as dl'=>'dvab.payment_mode=dl.id');
		$receipts = $this->receipt_against_bill->get($args);

		if(empty($receipts)){
			echo "<script>alert('".$this->lang->line('invalid-ra-bill')."');window.close();</script>";
		}else{
			$pdf_name .= '_no_'.$receipts[0]['bill_no'];
		}
		$pdf_contents = $this->load->view('receipt_against_bill/receipt_against_bill_pdf',array('receipts'=>$receipts),true);
		$this->my_pdf->output($pdf_name,$pdf_contents);
	}

	#--------------------------------------------------------------------------

	public function excel(){

		$from_date = $this->uri->segment(3);
		$to_date = $this->uri->segment(4);
		$this->load->model('receipts/Receipt_against_bill_model','receipt_against_bill');
		$args = array();
		$args['select'] = array('dvab.id','dvab.bill_no','dvab.bill_date','dvab.customer_type_id','dvab.customer_id','dvab.cash_type','dvab.payment_mode','dvab.narration','dvab.cheque_no','dvab.cheque_date','dl.ledger_name');
		$args['between'] = array($from_date,$to_date);
		$args['conditions'] = array('dvab.branch_id'=>$this->branchID,'dvab.bill_type'=>0,'dvab.status'=>1);
		$args['join'] = array('dms_ledgers as dl'=>'dvab.payment_mode=dl.id');
		$receipts = $this->receipt_against_bill->get($args);

		$excel_head = 'Receipt Against Bill Report '.date('d/m/Y',strtotime($from_date)).' To '. date('d/m/Y',strtotime($to_date));

		if(empty($receipts)){
			echo "<script>window.close();</script>";
		}

		$this->load->library('My_excel');
		$this->load->library('Stock');
		$this->my_excel->set_title($excel_head);
		$this->my_excel->set_headline($excel_head);
		$line=$startLine=$this->my_excel->report_head_line();

		$headings = array('#','Bill No','Bill Date','Customer','Phone No.','Payment Mode','Bank','Cheque / DD No.','Cheque Date.','Narration','Amount','Discount','Net Amount');
		$head_width = array(NULL,NULL,12,30,15,15,20,18,14,15,25,20,20);
		$this->my_excel->set_report_head($headings,$head_width,$line);
		$i=0;$totalAmount=0;$line++;
		$cashTypes = array(0=>'CASH',1=>'CHEQUE',2=>'DD');
		foreach($receipts as $key=>$receipt){$i++;

				$receiptID= $receipt['id'];
				$custTypeID = $receipt['customer_type_id'];
				$customerID = $receipt['customer_id'];
				$customerDetails = $this->stock->get_customer($custTypeID,$customerID,1);
				$customer_name = $customerDetails['name'];
				if(!empty($customerDetails['mobile_no'])){
					$customer_phone = $customerDetails['mobile_no'];
				}else{
					$customer_phone = $customerDetails['phone_no'];
				}

				$args = array();$receiptAmount=0;$receiptDiscount=0;
				$args['select'] = array('sum(received_amount) as receipt_amount','sum(discount) as discount');
				$args['conditions'] = array('dvab.id'=>$receipt['id'],'dvabi.status'=>1);
				$args['join'] = array('dms_voucher_against_bill_items as dvabi'=>'dvab.id=dvabi.vid');
				$receiptsDtls = $this->receipt_against_bill->get($args);
				if(!empty($receiptsDtls)){
					$receiptAmount = $receiptsDtls[0]['receipt_amount'];
					$receiptDiscount = $receiptsDtls[0]['discount'];
				}
				$ledger_name=NULL;
				if(!empty($receipt['cash_type'])){
					$ledger_name = $receipt['ledger_name'];
				}
				$totalAmount += ($receiptAmount-$receiptDiscount);
				$cheqeNo = $receipt['cheque_no'].' ';
				$this->my_excel->set_data_align('A'.$line,NULL);
				$this->my_excel->set_cell_value('A'.$line,$i);
				$this->my_excel->set_data_align('B'.$line,'L');
				$this->my_excel->set_cell_value('B'.$line,$receipt['bill_no']);
				$this->my_excel->set_cell_value('C'.$line,dateFormat($receipt['bill_date']));
				$this->my_excel->set_data_align('C'.$line,'C');
				$this->my_excel->set_cell_value('D'.$line,$customer_name);
				$this->my_excel->set_data_align('E'.$line,'L');
				$this->my_excel->set_cell_value('E'.$line,$customer_phone);
				$this->my_excel->set_cell_value('F'.$line,$cashTypes[$receipt['cash_type']]);
				$this->my_excel->set_cell_value('G'.$line,$ledger_name);
				$this->my_excel->set_cell_value('H'.$line,$cheqeNo);
				$this->my_excel->set_cell_value('I'.$line,dateFormat($receipt['cheque_date']));
				$this->my_excel->set_data_align('I'.$line,'C');
				$this->my_excel->set_cell_value('J'.$line,$receipt['narration']);
				$this->my_excel->set_cell_value('K'.$line,$receiptAmount);
				$this->my_excel->number_format('K'.$line);
				$this->my_excel->set_cell_value('L'.$line,$receiptDiscount);
				$this->my_excel->number_format('L'.$line);
				$total = $receiptAmount-$receiptDiscount;
				$this->my_excel->set_cell_value('M'.$line,$total);
				$this->my_excel->number_format('M'.$line);
				$line++;
		}

		$this->my_excel->set_bold('A'.$line.':'.'M'.$line);
		$this->my_excel->merge_cell('A'.$line.':L'.$line);
		$this->my_excel->set_data_align('A'.$line,'R');
		$this->my_excel->set_font_size('A'.$line,14);
		$this->my_excel->set_cell_value('A'.$line,'Total');
		$this->my_excel->number_format('M'.$line);
		$this->my_excel->set_cell_value('M'.$line,$totalAmount);
		$this->my_excel->set_border('A'.$startLine.':M'.$line);
		$this->my_excel->output_excel();
	}

	#-------------------------------------------------------------------------------------------------

	public function requests(){
		redirect('users/home');

		$this->template->title($this->lang->line('receipt-against-bill-requests'));
		$this->template->main_heading($this->lang->line('receipt-against-bill-requests'));
		$this->template->breadcrumb(array($this->lang->line('receipt-against-bill-requests') => 'no_link',$this->lang->line('report') => 'receipt_against_bill/report'));
		$this->load->library('Stock');
		$this->load->model('designations/Designation_master_model','designations');
		$this->load->model('receipts/Receipt_against_bill_model','receipt_against_bill');
		$this->load->library('Receipt_ab_lib');
		$offset=0;
		$args = array();
		$args['select'] = array('dvab.id','dvab.bill_no','dvab.bill_date','dvab.customer_type_id','dvab.customer_id','dvab.cash_type','dvab.payment_mode','dvab.narration','dvab.cheque_no','dvab.cheque_date','dvab.bill_status','dvabi.id as dvabi_id','dvabi.ps_id','dvabi.received_amount','ds.bill_no as sales_bill_no','ds.bill_date as sales_bill_date','dl.ledger_name','bm.branch_name');
		$args['conditions'] = array('dvab.customer_type_id'=>0,'dvab.customer_id'=>$this->branchID,'dvab.bill_status <='=>1);
		$args['join'] = array('dms_voucher_against_bill_items as dvabi'=>'dvab.id=dvabi.vid','dms_sales as ds'=>'dvabi.ps_id=ds.id','dms_ledgers as dl'=>'dvab.payment_mode=dl.id','branch_master as bm'=>'dvab.branch_id=bm.id');
		$receipts = $this->receipt_against_bill->get($args);
		if(empty($receipts)){
			$this->message->set($this->lang->line('no-result-found'),'i');
		}
		foreach($receipts as $key=>$receipt){

			$args = array();$receiptAmount=0;
			$args['select'] = array('sum(received_amount) as receipt_amount');
			$args['conditions'] = array('dvab.id'=>$receipt['id'],'dvabi.status'=>1);
			$args['join'] = array('dms_voucher_against_bill_items as dvabi'=>'dvab.id=dvabi.vid');
			$receiptsDtls = $this->receipt_against_bill->get($args);

			$this->receipt_against_bill->update(array('bill_status'=>1),array('id'=>$receipt['id']));
			if(!empty($receiptsDtls)){
				$receiptAmount = $receiptsDtls[0]['receipt_amount'];
			}
			$receipts[$key]['receipt_amount'] = $receiptAmount;
		}


		# view starts here--------------------------------
		$this->template->slice('dms/message');
		$this->template->slice('receipt_against_bill/receipt_against_bill_requests',array('receipts'=>$receipts,'count'=>$offset+1));
		$this->template->other_script(array('receipts/receipt_against_bill'));
		$this->template->render();

	}

	#-------------------------------------------------------------------------

	public function receipt(){

		redirect('users/home');
		$this->template->title($this->lang->line('receipt-against-bill'));
		$this->template->main_heading($this->lang->line('receipt-against-bill'));
		$this->template->breadcrumb(array($this->lang->line('receipt-against-bill') => 'no_link',$this->lang->line('report') => 'receipt_against_bill/report'));

		$this->load->library('Stock');
		$this->load->model('designations/Designation_master_model','designations');
		$this->load->model('receipts/Receipt_against_bill_model','receipt_against_bill');
		$this->load->library('Receipt_ab_lib');

		$args = array();
		$args['select'] = array('dvab.id','dvab.pid','dvab.p_status','dvab.bill_status');
		$args['conditions'] = array('dvab.branch_id'=>$this->branchID,'dvab.bill_type'=>0,'dvab.status'=>-1,'dvab.created_by'=>$this->createdBY);
		$check_receipt = $this->receipt_against_bill->get($args);

		if(!empty($check_receipt)){
			$this->message->set($this->lang->line('pending-rab-exists'),'e');
			if($check_receipt[0]['p_status'] == 0){
				redirect('receipt_against_bill/add');
			}
		}else{
			if(!$this->uri->segment(3)){
				redirect('receipt_against_bill/requests/status/1');
			}
			$pID = $this->uri->segment(3);
			$args = array();
			$args['select'] = array('dvab.id','dvab.bill_no','dvab.bill_date','dvab.customer_type_id','dvab.customer_id','dvab.cash_type','dvab.payment_mode','dvab.narration','dvab.cheque_no','dvab.cheque_date','dvab.bill_status','dvabi.id as dvabi_id','dvabi.ps_id','dvabi.received_amount','ds.bill_no as sales_bill_no','ds.bill_date as sales_bill_date','dl.ledger_name','bm.branch_name');
			$args['conditions'] = array('dvab.id'=>$pID,'dvab.customer_id'=>$this->branchID,'dvab.bill_status <='=>1);
			$args['join'] = array('dms_voucher_against_bill_items as dvabi'=>'dvab.id=dvabi.vid','dms_sales as ds'=>'dvabi.ps_id=ds.id','dms_ledgers as dl'=>'dvab.payment_mode=dl.id','branch_master as bm'=>'dvab.branch_id=bm.id');
			$payments = $this->receipt_against_bill->get($args);
			if(empty($payments)){
				$this->message->set($this->lang->line('invalid-rab-req'),'e');
				redirect('receipt_against_bill/requests/status/1');
			}else{

				$receiptNo = $this->receipt_against_bill->get_receipt_number();
				$paymentCashType = $payments[0]['cash_type'];
				$paymentPayMode = $payments[0]['payment_mode'];
				$paymentChqNo = $payments[0]['cheque_no'];
				$paymentChqDate = $payments[0]['cheque_date'];
				$paymentBillType = $payments[0]['bill_type'];

				foreach($payments as $key=>$payment_bill){

					#$purchaseID =
				}

			}

		}


		$customers = $customerBalanceBills = $bank_accounts = array();
		$inputSelects = array('customers','customerBalanceBills','bank_accounts');

		if($this->dms->get_main_branch($this->branchID) === true){
			$customerTypes = $this->designations->listing(array('department_id'=>0,'utype_status >'=>1));
		}else{
			$customerTypes = $this->designations->listing(array('department_id'=>0,'utype_status'=>4));
		}

		$CustTypeID=2;	$customer_id = NULL;$customer_bill=$bank = NULL;

		if($this->input->post('customer_type')){
			$CustTypeID = $this->input->post('customer_type');
			if($this->input->post('customer_id')){
				$customerID = $this->input->post('customer_id');
				$customerBalanceBills = $this->receipt_ab_lib->get_customer_bill($CustTypeID,$customerID);
			}
		}
		$existsRAB = array();
		$args = array();
		$args['select'] = array('dvab.id','dvab.bill_no','dvab.bill_date','dvab.customer_type_id','dvab.customer_id','dvabi.id as dvabi_id','dvabi.ps_id','dvabi.received_amount','ds.bill_no as sales_bill_no','ds.bill_date as sales_bill_date');
		$args['conditions'] = array('dvab.branch_id'=>$this->branchID,'dvab.bill_type'=>0,'dvab.status'=>-1,'dvab.created_by'=>$this->createdBY);
		$args['join'] = array('dms_voucher_against_bill_items as dvabi'=>'dvab.id=dvabi.vid','dms_sales as ds'=>'dvabi.ps_id=ds.id');
		$existsRAB = $this->receipt_against_bill->get($args);

		if(!empty($existsRAB)){

			$receipt_date = date('Y-m-d',strtotime($existsRAB[0]['bill_date']));
			$tempReceiptID = $existsRAB[0]['id'];
			$customer_type_id = $existsRAB[0]['customer_type_id'];
			$CustTypeID = $customer_type_id;
			$customer_id = $existsRAB[0]['customer_id'];
			$customerBalanceBills = $this->receipt_ab_lib->get_customer_bill($customer_type_id,$customer_id);
			$bank_accounts = $this->stock->payment_modes(array('sub_groups'=>array(14)));

		}


		foreach($inputSelects as $key=>$selectBox){
			$arrayName = $$selectBox;
			$arrayName[''] = 'Select';
			$$selectBox = $arrayName;
			ksort($$selectBox);
		}
		# view starts here--------------------------------
		$this->template->slice('dms/message');
		$this->template->slice('receipt_against_bill/payment_to_receipt_against_bill',array('bill_num'=>$receiptNo,'customer_types'=>$customerTypes,'cust_type'=>$CustTypeID,'customers'=>$customers,'customer_id'=>$customer_id,'customer_bills'=>$customerBalanceBills,'customer_bill'=>$customer_bill,'receipt_bill_items'=>$existsRAB,'bank_accounts'=>$bank_accounts,'bank'=>$bank));
		$this->template->other_script(array('receipts/receipt_against_bill'));
		$this->template->render();
	}

	#--------------------------------------------------------------------------
}
?>