<?php if( ! defined('BASEPATH')) exit ('No direct script access allowed');

class Receipt_note extends MY_Controller{

	public function __construct()
	{
		parent::__construct();

		$this->check_access_right();

		#---------------- Checking Financial year is enabled / closed-----------------#
		$method_array = array('add','delete_temp','update_temp','update','delete');
		fiscal_status($this->uri->segment(2),$method_array,"receipt_note/report");
		#---------------- Checking Financial year is enabled / closed-----------------#

		$this->load->model('purchase/Receipt_note_model','purchase');
		$this->load->model('vouchers/Voucher_model','vouchers');
		$this->load->library(array('Stock'));

		#----------voucher type
		$this->vtype = 9;
	}

	public function add()
	{
		#----------voucher type
		$vtype_id = $this->vtype;

		#----------voucher type array
		$voucher_types = $this->vouchers->voucher_types($this->vtype);
		$bill_prefix = $this->stock->get_voucher_prefix($this->vtype);
		#----------voucher name
		$voucher_name = $this->vouchers->voucher_name($this->vtype);

		#-----------purchase cst checking details
		$purchase_cst = $this->stock->get_constant(array('purchase_cst'));

		#------------presumptive tax checking
		$presumptive_tax = $this->stock->get_tax_type();

		#------------cess %
		$cess = $this->stock->get_cess();

		#-----------receipt date and next bill no
		$rules = "callback_bill_no_exists";
		$disabled = "";
		$result_array = $this->purchase->next_bill_no($this->vtype);
		$vtype_id = $result_array['vtype_id'];
		$voucher_no = $result_array['bill_no'];
		$voucher_date = $result_array['bill_date'];
		if($result_array['vstatus']){

			#-----------redirection if purchase_order / purchase_request conversion is pending
			if($result_array['p_status'] == 2){
				redirect("order_to_purchase/po_purchase/".$result_array['pid']);
			}
			elseif($result_array['p_status'] == 1){
				redirect("request_to_purchase/r_purchase/".$result_array['pid']);
			}else if($result_array['p_status'] == 4){
				$this->message->set($this->lang->line('pending-receipt-exists'),'i');
				redirect("delivery_to_receipt/add");
			}

			$disabled = "readonly";
			$group_id = $result_array['group_id'];
			$rules = "callback_bill_no_exists[$vtype_id.$group_id]";

			#------------checking cst enabled or not
			$cst_status = $this->purchase->get_cst($group_id);
			if($cst_status){
				$purchase_cst = $cst_status;
			}
		}


		#-------------adding data to receipt temp
		if(isset($_POST['btn_add']))
		{
			#-----------validation
			$this->form_validation->set_rules('vtype_id','lang:voucher-types','required|xss_clean');
			$this->form_validation->set_rules('purchase[bill_no]','lang:bill-no',"required|xss_clean|is_natural_no_zero|".$rules);
			$this->form_validation->set_rules('purchase[bill_date]','lang:bill-date','required|xss_clean|valid_date');
			$this->form_validation->set_rules('purchase[invoice_no]','lang:invoice-no','required|xss_clean');
			$this->form_validation->set_rules('purchase[invoice_date]','lang:invoice-date','required|xss_clean|is_date');
			$this->form_validation->set_rules('purchase[vendor_id]','lang:vendor','required|xss_clean');
			$this->form_validation->set_rules('item_id','lang:item-name','required|xss_clean');
			$this->form_validation->set_rules('godown_id','lang:godown','required|xss_clean');
			$this->form_validation->set_rules('cst','lang:cst','xss_clean|greater_or_equal[0]|less_or_equal[100]');
			$this->form_validation->set_rules('qty','lang:quantity','required|xss_clean|greater_than[0]|less_than[100000000]');
			$this->form_validation->set_rules('unit_id','lang:unit','required|xss_clean');
			$this->form_validation->set_rules('rate','lang:rate','required|xss_clean|greater_or_equal[0]|less_than[100000000]');
			$this->form_validation->set_rules('amount','lang:amount','xss_clean|required|greater_or_equal[0]|less_than[100000000]');
			$this->form_validation->set_rules('discount_per','lang:discount %','xss_clean|greater_than[0]|less_or_equal[100]');
			$this->form_validation->set_rules('discount_amt','lang:discount','xss_clean|greater_or_equal[0]|less_than[100000000]');
			//$this->form_validation->set_rules('freight','lang:freight','xss_clean|greater_or_equal[0]');

			#-----------adding temporary data
			if($this->form_validation->run('btn_add') === true)
			{
				$purchase_temp_array = $this->input->post('purchase',true);
				$purchase_temp_array = array_filter($purchase_temp_array);
				$purchase_temp_array['vtype_id'] = $this->input->post('vtype_id',true);
				#-----------bill date and next bill no
				if($result_array['vstatus'] == 0)//data not in dms_receipt_notes
				{
					$purchase_temp_result = $this->purchase->get_purchases(array('columns' => array('a.id'),'conditions' => array('a.created_by' => $this->session->userdata('id'),'vtype_id' => $purchase_temp_array['vtype_id'],'bill_no' => $purchase_temp_array['bill_no'],'a.status' => -1),'numrows' => true));
					if($purchase_temp_result == 0)
					{
						$group_id = $this->stock->get_group_id('dms_purchase_items');
						$purchase_temp_array['branch_id'] = $this->session->userdata('under_id');
						$purchase_temp_array['bill_date'] = date('Y-m-d',strtotime($purchase_temp_array['bill_date']));
						$voucher_date = $purchase_temp_array['bill_date'];
						$purchase_temp_array['invoice_date'] = date('Y-m-d',strtotime($purchase_temp_array['invoice_date']));
						$purchase_temp_array['group_id'] = $group_id;
						$purchase_temp_array['status'] = -1;
						$this->purchase->insert("dms_receipt_notes",$purchase_temp_array);
					}
				}
				$item_array = $this->input->post(NULL,true);
				unset($item_array['purchase']);
				unset($item_array['vtype_id']);
				unset($item_array['btn_add']);
				$item_array['group_id'] = $group_id;

				#----------rate calculation
				$item_array['rate'] = 0;
				if($item_array['qty'] != 0){
					$item_array['rate'] = $item_array['amount'] / $item_array['qty'];
				}

				#----------VAT calculation
				$cst = 0;
				if(isset($item_array['cst'])){
					$cst = $item_array['cst'];
				}
				if(empty($presumptive_tax)){
					if($cst == 0){
						$vat_percent = $this->stock->get_item_vat($item_array['item_id']);
						$item_array['vat_percent'] = $vat_percent;
						$item_array['vat_amt'] = (($item_array['amount']-$item_array['discount_amt']) * $vat_percent) / 100;
					}
				}

				$item_array['status'] = -1;
				$item_array['item_status'] = 2;//purchase only items
				$purchase_temp_item_result = $this->purchase->get_purchases(array('columns' => array('b.id'),'conditions' => array('b.group_id' => $group_id,'item_id' => $item_array['item_id'],'godown_id' => $item_array['godown_id'],'unit_id' => $item_array['unit_id'],'a.status !=' => 0,'b.status !=' => 0),'numrows' => true));
				if($purchase_temp_item_result == 0){
					$purchase_items_id = $this->purchase->insert("dms_purchase_items",$item_array);
					if($purchase_items_id)
					{
						#--------------adding temporary stock balance in dms_stocks
						$stock_bal_temp = $this->stock->unit_conversion($item_array['item_id'],$item_array['unit_id'],$item_array['qty'],$item_array['rate'],$item_array['amount']);
						if($stock_bal_temp)
						{
							$this->purchase->insert('dms_stocks',array('company_id' => $this->session->userdata('company_id'),'branch_id' => $this->session->userdata('under_id'),'godown_id' => $item_array['godown_id'],'item_id' => $item_array['item_id'],'qty' => $stock_bal_temp['qty'],'unit_id' => $stock_bal_temp['primary_unit'],'rate' => $stock_bal_temp['rate'],'amount' => $stock_bal_temp['amount'],'stock_date' => $voucher_date,'stock_status' => 1,'table_group_id' => $group_id,'table_id' => $purchase_items_id,'status' => -1));
						}
						$this->message->set($this->lang->line('receipt-add-success'));
					}
					else
					{
						$this->message->set($this->lang->line('receipt-add-error'),'e');
					}
				}
				else{
					$this->message->set($this->lang->line('receipt-add-error'),'e');
				}
				redirect('receipt_note/add');
			}
		}

		#------------saving receipt_note voucher
		if(isset($_POST['btn_save']))
		{
			#-----------validation
			$this->form_validation->set_rules('remarks','lang:remarks','xss_clean');
			$this->form_validation->set_rules('freight','lang:freight','xss_clean|greater_or_equal[0]|less_than[100000000]');
			$this->form_validation->set_rules('other_expense','lang:other-expense','xss_clean|greater_or_equal[0]|less_than[100000000]');
			$this->form_validation->set_rules('bill_discount_per','lang:discount %','xss_clean|greater_or_equal[0]|less_or_equal[100]');
			$this->form_validation->set_rules('bill_discount_amt','lang:discount','xss_clean|greater_or_equal[0]|less_than[100000000]');

			#-----------saving data
			if($this->form_validation->run('btn_save') === true)
			{
				$purchase_entry_array=array('bill_discount_per' => $this->input->post('bill_discount_per',true),'bill_discount_amt	' => $this->input->post('bill_discount_amt',true),'bill_freight' => $this->input->post('freight',true),'other_expense' => $this->input->post('other_expense',true),'cess' => $cess,'narration' => $this->input->post('remarks',true),'status' => 1);

				$purchase_entry_check = $this->purchase->get_purchases(array('columns' => array('a.bill_date'),'conditions' => array('a.group_id' => $group_id,'a.status !=' => 0)));
				if($purchase_entry_check)
				{
					$bill_date = $purchase_entry_check[0]['bill_date'];
					if($this->purchase->update(array('table' => 'dms_receipt_notes','data' => $purchase_entry_array,'conditions' => array('group_id' => $group_id)))){
						$this->purchase->update(array('table' => 'dms_purchase_items','data' => array('status' => 1),'conditions' => array('group_id' => $group_id)));

						#-------------enabling temporarily added stocks
						$purchase_items_array = $this->purchase->get_purchase_items(array('columns' => array('id'),'conditions' => array('group_id' => $group_id,'status' => 1)));
						foreach($purchase_items_array as $key => $value)
						{
							$this->purchase->update_others(array('table' => 'dms_stocks','data' => array('status' => 1),'conditions' => array('stock_status' => 1,'table_id' => $value['id'])));
						}
						$this->message->set($this->lang->line('receipt-save-success'));
					}
					else{
						$this->message->set($this->lang->line('receipt-save-error'),'e');
					}
				}
				else
				{
					$this->message->set($this->lang->line('receipt-save-error'),'e');
				}
				redirect('receipt_note/add');
			}
		}

		#------------vendor details
		$vendors = $this->stock->get_vendors();
		$vendor_id = "";

		#------------item details / unit details / godown details
		$units = $goDowns = array();
		$units[''] = "Select";
		$args['select'] = array('id','item_code','item_name');
		$items = $this->stock->get_stock_items($args);
		if(empty($items)){
			$this->message->set($this->lang->line('no-items-found'),'i');
		}
		if($this->input->post('item_id',true)){
			$itemID = $this->input->post('item_id',true);
			$goDowns = $this->stock->get_item_godowns(array('item_id'=>$itemID,'listing'=>1));
			$units = $this->stock->get_units($itemID);
		}

		#------------receipt temp data
		$purchase_temp_data = array();
		$stock_count = $primary_unit['symbol'] = $invoice_no = "";
		$invoice_date = date('Y-m-d');
		if($result_array['vstatus'])
		{
			$purchase_temp_data = $this->purchase->get_purchases(array('columns' => array('a.invoice_no','a.invoice_date','a.group_id','a.vendor_id','b.id','b.item_id','b.qty','b.unit_id','b.rate','b.amount','b.discount_per','b.discount_amt','b.godown_id','b.vat_amt','b.cst'),'conditions' => array('a.created_by' => $this->session->userdata('id'),'vtype_id' => $vtype_id,'bill_no' => $voucher_no,'a.status =' => -1,'b.status =' => -1)));
			$vendor_id = $purchase_temp_data[0]['vendor_id'];
			$invoice_no = $purchase_temp_data[0]['invoice_no'];
			$invoice_date = $purchase_temp_data[0]['invoice_date'];
		}
		else
		{
			$purchase_array = $this->input->post('purchase',true);

			#------------stock count of this item
			if($this->input->post('item_id',true) && $this->input->post('godown_id',true) && $purchase_array['bill_date'] != ""){
				$stock_count = $this->stock->get_stock_count($this->input->post('godown_id',true),$this->input->post('item_id',true),$purchase_array['bill_date']);
				$primary_unit = $this->stock->get_primary_unit($this->input->post('item_id',true));
			}
		}
		$items[''] = 'Select';ksort($items);
		$goDowns[''] = 'Select';ksort($goDowns);
		$vendors[''] = 'Select';ksort($vendors);

		#------------template
		$this->template->title("New Receipt Note Voucher");
		$this->template->main_heading($this->lang->line("$voucher_name"));
		$this->template->breadcrumb(array($this->lang->line("inventory-voucher") => 'no_link',$this->lang->line("$voucher_name") => 'no_link',$this->lang->line('report') => 'receipt_note/report'));
		$this->template->slice('dms/message');
		$this->template->slice('purchase/receipt_note/add',array('voucher_types' => $voucher_types,'voucher_type' => $vtype_id,'voucher_name' => $voucher_name,'voucher_no' => $voucher_no,'voucher_date' => $voucher_date,'vendors' => $vendors,'vendor_id' => $vendor_id,'invoice_no' => $invoice_no,'invoice_date' => $invoice_date,'items' => $items,'units' => $units,'goDowns' => $goDowns,'purchase_temp_status' =>$result_array['vstatus'],'purchase_temp_data' => $purchase_temp_data,'purchase_cst' => $purchase_cst,'presumptive_tax' => $presumptive_tax,'cess' => $cess,'disabled' => $disabled,'stock_count' => $stock_count,'primary_unit' => $primary_unit['symbol'],'bill_prefix'=>$bill_prefix));
		$this->template->other_script('purchase/purchase');
		$this->template->render();
	}

	public function delete_temp()
	{
		#----------receipt temp data
		$uri_array = $this->uri->uri_to_assoc(3);
		if(isset($uri_array['idu']) || isset($uri_array['ida']))
		{
			if(isset($uri_array['idu']))
			{
				$id = $uri_array['idu'];
				unset($uri_array['idu']);

				#-----------redirect uri
				$redirect_uri = "receipt_note/update/".$this->uri->assoc_to_uri($uri_array);
			}
			else
			{
				$id = $uri_array['ida'];
				unset($uri_array['ida']);

				#-----------redirect uri
				$redirect_uri = "receipt_note/add/".$this->uri->assoc_to_uri($uri_array);
			}

			$result = $this->purchase->get_purchase_items(array('columns' => array('group_id','status','item_status','created_by'),'conditions' => array('id' => $id)));
			if(!empty($result))
			{
				$row = $result[0];
				if($row['status'] == -1)
				{
					if($row['created_by'] == $this->session->userdata('id'))
					{
						#----------start transaction
						$this->db->trans_start();

						if($this->purchase->delete(array('table' => 'dms_purchase_items','conditions' => array('id' => $id))))
						{
							#-------------deleting stock bal. from dms_stocks
							$this->purchase->delete(array('table' => 'dms_stocks','conditions' => array('table_id' => $id,'stock_status' => 1)));

							$count = $this->purchase->get_purchase_items(array('columns' => array('group_id'),'conditions' => array('group_id' => $row['group_id'],'status !=' => 0),'numrows' => true));
							if($count == 0){
								$this->purchase->delete(array('table' => 'dms_receipt_notes','conditions' => array('group_id' => $row['group_id'])));
							}
							$this->message->set($this->lang->line('receipt-item-delete-success'));
						}
						else
						{
							$this->message->set($this->lang->line('receipt-item-delete-error'),'e');
						}

						#----------end transaction
						$this->db->trans_complete();
					}
					else
					{
						redirect('users/logout');
					}
				}
				else
				{
					#----------start transaction
					$this->db->trans_start();

					#-------------deleting item from dms_purchase_items
					if($row['item_status'] == 2)//receipt note
					{
						$this->purchase->update(array('table' => 'dms_purchase_items','data' => array('status' => 0),'conditions' => array('id' => $id)));
					}
					else//purchase order
					{
						$this->purchase->update(array('table' => 'dms_purchase_items','data' => array('item_status' => -1),'conditions' => array('id' => $id)));
					}

					#-------------deleting stock bal. from dms_stocks
					$this->purchase->update_others(array('table' => 'dms_stocks','data' => array('status' => 0),'conditions' => array('table_id' => $id,'stock_status' => 1)));

					#-------------deleting receipt bill
					$count = $this->purchase->get_purchase_items(array('columns' => array('group_id'),'conditions' => array('group_id' => $row['group_id'],'status !=' => 0,'item_status >' => 0),'numrows' => true));
					if($count == 0)
					{
						$this->purchase->update(array('table' => 'dms_receipt_notes','data' => array('status' => 0),'conditions' => array('group_id' => $row['group_id'])));

						#-----------redirect uri
						$redirect_uri = "receipt_note/report/".$this->uri->assoc_to_uri($uri_array);
					}
					$this->message->set($this->lang->line('receipt-item-delete-success'));

					#----------end transaction
					$this->db->trans_complete();
				}
			}
			redirect($redirect_uri);
		}
		redirect('users/logout');
	}

	public function update_temp()
	{
		#----------receipt temp data
		$uri_array = $this->uri->uri_to_assoc(3);
		if(isset($uri_array['idu']) || isset($uri_array['ida']))
		{
			if(isset($uri_array['idu']))
			{
				$purchase_temp_id = $uri_array['idu'];
				unset($uri_array['idu']);

				#-----------redirect uri
				$redirect_uri = "receipt_note/update/".$this->uri->assoc_to_uri($uri_array);
			}
			else
			{
				$purchase_temp_id = $uri_array['ida'];
				unset($uri_array['ida']);

				#-----------redirect uri
				$redirect_uri = "receipt_note/add/".$this->uri->assoc_to_uri($uri_array);
			}

			$row = $this->purchase->get_purchase_items(array('columns' => array('id','group_id','item_id','qty','unit_id','rate','amount','discount_per','discount_amt','vat_amt','cst','godown_id','status','created_by'),'conditions' => array('id' => $purchase_temp_id,'status !=' => 0)));
			if(!empty($row))
			{
				$purchase_temp_data = $row[0];$continue = 1;
				if($purchase_temp_data['status'] == -1){
					if($purchase_temp_data['created_by'] != $this->session->userdata('id')){
						$continue = 0;
					}
				}
				if($continue == 1)
				{
					#-----------validation
					$this->form_validation->set_rules('godown_id','lang:godown','required|xss_clean');
					$this->form_validation->set_rules('cst','lang:cst','xss_clean|greater_or_equal[0]|less_or_equal[100]');
					$this->form_validation->set_rules('qty','lang:quantity','required|xss_clean|greater_than[0]|less_than[100000000]');
					$this->form_validation->set_rules('unit_id','lang:unit','required|xss_clean');
					$this->form_validation->set_rules('rate','lang:rate','required|xss_clean|greater_or_equal[0]|less_than[100000000]');
					$this->form_validation->set_rules('amount','lang:amount','xss_clean|required|greater_or_equal[0]|less_than[100000000]');
					$this->form_validation->set_rules('discount_per','lang:discount %','xss_clean|greater_or_equal[0]|less_or_equal[100]');
					$this->form_validation->set_rules('discount_amt','lang:discount','xss_clean|greater_or_equal[0]|less_than[100000000]');
					$this->form_validation->set_rules('vat_amt','lang:vat-amt','xss_clean|greater_or_equal[0]|less_than[100000000]');

					#-----------updating temporary data
					if($this->form_validation->run('btn_add') === true)
					{
						$item_temp_array = $this->input->post(NULL,true);

						#----------rate calculation
						$item_temp_array['rate'] = 0;
						if($item_temp_array['qty'] != 0){
							$item_temp_array['rate'] = $item_temp_array['amount'] / $item_temp_array['qty'];
						}

						if($this->purchase->update(array('table' => 'dms_purchase_items','data' => $item_temp_array,'conditions' => array('id' => $purchase_temp_id)))){

							#--------------updating temporary stock balance in dms_stocks
							$stock_bal_temp = $this->stock->unit_conversion($purchase_temp_data['item_id'],$item_temp_array['unit_id'],$item_temp_array['qty'],$item_temp_array['rate'],$item_temp_array['amount']);
							if($stock_bal_temp)
							{
								$this->purchase->update_others(array('table' => 'dms_stocks','data' => array('godown_id' => $item_temp_array['godown_id'],'qty' => $stock_bal_temp['qty'],'unit_id' => $stock_bal_temp['primary_unit'],'rate' => $stock_bal_temp['rate'],'amount' => $stock_bal_temp['amount']),'conditions' => array('stock_status' => 1,'table_id' => $purchase_temp_id)));
							}
							$this->message->set($this->lang->line('receipt-edit-temp-success'));
						}
						else{
							$this->message->set($this->lang->line('receipt-edit-temp-error'),'e');
						}
						redirect($redirect_uri);
					}

					#----------voucher name
					$voucher_name = $this->vouchers->voucher_name($this->vtype);

					#-----------purchase cst checking details
					$purchase_cst = $this->stock->get_constant(array('purchase_cst'));

					#------------presumptive tax checking
					$presumptive_tax = $this->stock->get_tax_type();

					#------------checking cst enabled or not
					$cst_status = $this->purchase->get_cst($purchase_temp_data['group_id']);
					if($cst_status){
						$purchase_cst = $cst_status;
					}

					#------------item details / unit details / godown details
					$units = array();$goDowns = array();
					$item_details = $this->stock->get_item($purchase_temp_data['item_id'],array('item_code','item_name'));
					$items[$purchase_temp_data['item_id']] = $item_details['item_code']." / ".$item_details['item_name'];
					$goDowns = $this->stock->get_item_godowns(array('item_id'=>$purchase_temp_data['item_id'],'listing'=>1));
					$goDowns[''] = 'Select';
					ksort($goDowns);
					$units = $this->stock->get_units($purchase_temp_data['item_id']);

					#------------receipt date
					$purchase_date = $this->purchase->get_purchases(array('columns' => array('bill_date'),'conditions' => array('a.group_id' => $purchase_temp_data['group_id'],'a.status !=' => 0)))[0];

					#------------stock count of this item
					$stock_count = $this->stock->get_stock_count($purchase_temp_data['godown_id'],$purchase_temp_data['item_id'],$purchase_date['bill_date']);

					#------------primary unit details
					$primary_unit = $this->stock->get_primary_unit($purchase_temp_data['item_id']);

					#------------template
					$this->template->title("Update Receipt Note Voucher");
					$this->template->main_heading($this->lang->line("$voucher_name"));
					$this->template->breadcrumb(array($this->lang->line("inventory-voucher") => 'no_link',$this->lang->line("$voucher_name") => 'receipt_note/add',$this->lang->line("update") => 'no_link',$this->lang->line('report') => 'receipt_note/report',$this->lang->line('go-back') => array($redirect_uri)));
					$this->template->slice('dms/message');
					$this->template->slice('purchase/receipt_note/edit_temp',array('voucher_name' => $voucher_name,'items' => $items,'units' => $units,'goDowns' => $goDowns,'purchase_temp_data' => $purchase_temp_data,'purchase_cst' => $purchase_cst,'presumptive_tax' => $presumptive_tax,'stock_count' => $stock_count,'unit_symbol' => $primary_unit['symbol'],'purchase_date' => $purchase_date['bill_date']));
					$this->template->other_script('purchase/purchase');
					$this->template->render();
				}
				else
				{
					redirect('users/logout');
				}
			}
			else
			{
				redirect('users/logout');
			}
		}
		else
		{
			redirect('users/logout');
		}
	}

	public function bill_no_exists($bill_no,$v_details = NULL)
	{
		if($v_details == NULL){
			$where = array('vtype_id' => $this->input->post('vtype_id',true),'bill_no' => $bill_no,'status !=' => 0);
		}
		else{
			$exp = explode('.', $v_details);
			$where = array('vtype_id' => $exp[0],'bill_no' => $bill_no,'group_id !=' => $exp[1],'status !=' => 0);
		}
		$row = $this->purchase->get_bills(array('columns' => array('id'),'conditions' => $where,'numrows' => true));
		if($row == 0){
			return true;
		}
		return false;
	}

	public function report()
	{
		#----------voucher type
		$vtype_id = $this->vtype;
		$conditions = array('vtype_id' => $vtype_id,'status' => 1);
		$like_array = array();$vnos="";

		#----------voucher name
		$voucher_name = $this->vouchers->voucher_name($this->vtype);

		#----------voucher type array
		$voucher_types = $this->vouchers->voucher_types($this->vtype);

		#----------uri array
		$uri_array  = $this->uri->uri_to_assoc(3);

		#----------redirect
		$redirect = "";

		#----------pagination
		$this->load->library('Pagination');
		$config['per_page'] = $this->per_page();
		# Pagination Config Customizations
        $config['full_tag_open'] = '<ul class="pagination">';
        $config['full_tag_close'] = '</ul>';
        $config['first_link'] = 'First';
        $config['last_link'] = 'Last';
        $config['next_link'] = '&raquo;';
        $config['prev_link'] = '&laquo;';
        $config['cur_tag_open'] = '<li class="active"><a href="#">';
        $config['cur_tag_close'] = '</a></li>';
        $config['num_tag_open'] = '<li>';
        $config['num_tag_close'] = '</li>';
		$config['base_url'] = base_url('receipt_note/report');
		$config['uri_segment'] = 3;

		#----------dates within financial year
		$cur_date = date('Y-m-d');
		$from_date = $cur_date;
		$to_date = $cur_date;
		$cur_fiscal_yr = $this->dms->get_fiscal_year();
		if($from_date < $cur_fiscal_yr['start_date'] || $from_date > $cur_fiscal_yr['end_date'] || $to_date < $cur_fiscal_yr['start_date'] || $to_date > $cur_fiscal_yr['end_date'])
		{
			$from_date = $cur_fiscal_yr['end_date'];
			$to_date = $cur_fiscal_yr['end_date'];
		}

		#----------validation
		$this->form_validation->set_rules('vtype_id','voucher-types','required|xss_clean');
		$this->form_validation->set_rules('from_date','From Date','required|xss_clean|valid_date');
		$this->form_validation->set_rules('to_date','To Date','required|xss_clean|valid_date');
		$this->form_validation->set_rules('bill_no','bill-no','xss_clean|trim');
		if($this->form_validation->run() === true)
		{
			$vtype_id = $this->input->post('vtype_id',true);
			$from_date = date('Y-m-d',strtotime($this->input->post('from_date',true)));
			$to_date = date('Y-m-d',strtotime($this->input->post('to_date',true)));
			$conditions['vtype_id'] = $vtype_id;
			$config['base_url'] .= '/vt/'.$vtype_id.'/fdate/'.$from_date.'/tdate/'.$to_date;
			$config['uri_segment'] += 6;
			$redirect .= '/vt/'.$vtype_id.'/fdate/'.$from_date.'/tdate/'.$to_date;
			if(!empty($this->input->post('bill_no',true)))
			{
				$vnos = $this->input->post('bill_no',true);
				$like_array['bill_no'] = $vnos;
				$config['base_url'] .= '/vn/'.$vnos;
				$config['uri_segment'] += 2;
				$redirect .= '/vn/'.$vnos;
			}
		}
		elseif(isset($uri_array['vt']))
		{
			$vtype_id = $uri_array['vt'];
			$conditions['vtype_id'] = $vtype_id;
			$config['base_url'] .= '/vt/'.$conditions['vtype_id'];
			$config['uri_segment'] += 2;
			$redirect .= '/vt/'.$vtype_id;
			if(isset($uri_array['fdate']) && isset($uri_array['tdate']))
			{
				$from_date = date('Y-m-d',strtotime($uri_array['fdate']));
				$to_date = date('Y-m-d',strtotime($uri_array['tdate']));
				$config['base_url'] .= '/fdate/'.$from_date.'/tdate/'.$to_date;
				$config['uri_segment'] += 4;
				$redirect .= '/fdate/'.$from_date.'/tdate/'.$to_date;
			}
			if(isset($uri_array['vn']))
			{
				$vnos = $uri_array['vn'];
				$like_array['bill_no'] = $vnos;
				$config['base_url'] .= '/vn/'.$vnos;
				$config['uri_segment'] += 2;
				$redirect .= '/vn/'.$vnos;
			}
		}

		#----------between condition
		$between = "bill_date between '$from_date' and '$to_date'";

		#----------total rows
		$config['total_rows'] = $this->purchase->get_bills(array('columns' => array('id'),'conditions' => $conditions,'between' => $between,'like' => $like_array,'numrows'=>true));

		if($config['total_rows'] == 0){
			$this->message->set($this->lang->line('no-voucher'),'i');
		}

		#----------pagination
		$offset = $this->uri->segment($config['uri_segment'],0);
		$this->pagination->initialize($config);
		$links = $this->pagination->create_links();
		$redirect .= '/'.$offset;

		#------------presumptive tax checking
		$presumptive_tax = $this->stock->get_tax_type();

		#----------receipt report datas
		$purchase_array=$this->purchase->get_bills(array('conditions' => $conditions,'between' => $between,'like' => $like_array,'order_by'=>'bill_date','order'=>'DESC','limit'=>$config['per_page'],'offset'=>$offset));

		#----------template
		$this->template->title("Receipt Note Report");
		$this->template->main_heading($this->lang->line("$voucher_name")." ".$this->lang->line("report"));
		$this->template->breadcrumb(array($this->lang->line("inventory-voucher") => 'no_link',$this->lang->line("$voucher_name") => 'receipt_note/add',$this->lang->line('report') => 'no_link'));
		$this->template->slice('sales/sales_entry/search',array('voucher_types' => $voucher_types,'vtype_id' => $vtype_id,'vnos' => $vnos,'from_date' => $from_date,'to_date' => $to_date,'rtype' => 'receipt_note'));
		$this->template->slice('dms/message');
		if(!empty($purchase_array))
		{
			$this->template->slice('purchase/receipt_note/report',array('purchase_array' => $purchase_array,'presumptive_tax' => $presumptive_tax,'offset' => $offset,'links' => $links,'redirect' => $redirect));
			$this->template->slice('dms/modals/delete_confirm');
		}
		$this->template->render();
	}

	public function view()
	{
		#----------voucher type
		$vtype_id = $this->vtype;

		#----------receipt primary key
		$uri_array = $this->uri->uri_to_assoc(3);
		if(isset($uri_array['id']) || isset($uri_array['group_id']))
		{
			#----------voucher name
			$voucher_name = $this->vouchers->voucher_name($this->vtype);

			#----------breadcrumb
			$breadcrumb = array($this->lang->line("inventory-voucher") => 'no_link',$this->lang->line("$voucher_name") => 'receipt_note/add',$this->lang->line('report') => 'receipt_note/report',$this->lang->line("view") => 'no_link');

			if(isset($uri_array['group_id']))
			{
				$conditions = array('a.group_id' => $uri_array['group_id'],'a.status !=' => 0,'b.status !=' => 0);
				if(isset($uri_array['id']) || isset($uri_array['mid']) || isset($uri_array['sid']))
				{
					if(isset($uri_array['id'])){
						$breadcrumb_url = "stock_item_register/index/id/".$uri_array['id'];
					}
					elseif(isset($uri_array['mid'])){
						$breadcrumb_url = "stock_item_register/index/mid/".$uri_array['mid'];
					}
					elseif(isset($uri_array['sid'])){
						$breadcrumb_url = "stock_item_register/index/sid/".$uri_array['sid'];
					}
					if(isset($uri_array['rtype'])){
						$breadcrumb_url .= "/rtype/".$uri_array['rtype'];
					}
					$breadcrumb[$this->lang->line("go-back")] = $breadcrumb_url;
				}
			}
			else
			{
				$purchase_id = $uri_array['id'];
				unset($uri_array['id']);
				$conditions = array('a.id' => $purchase_id,'a.status !=' => 0,'b.status !=' => 0);
				$breadcrumb[$this->lang->line("go-back")] = "receipt_note/report/".$this->uri->assoc_to_uri($uri_array);
			}

			#----------receipt data
			$purchase_array = $this->purchase->get_purchases(array('columns' => array('a.id as primary_id','a.vtype_id','a.bill_no','a.bill_date','a.invoice_no','a.invoice_date','a.group_id','a.vendor_id','a.bill_discount_per','a.bill_discount_amt','a.bill_freight','a.other_expense','a.cess','a.narration','a.r_status','a.p_status','a.created_by','a.created_on','b.id','b.item_id','b.qty','b.unit_id','b.rate','b.amount','b.discount_per','b.discount_amt','b.godown_id','b.vat_amt','b.cst'),'conditions' => $conditions));
			if(!empty($purchase_array))
			{
				#------------presumptive tax checking
				$presumptive_tax = $this->stock->get_tax_type();

				#------------checking cst enabled or not
				$purchase_cst = $this->purchase->get_cst($purchase_array[0]['group_id']);

				$vendor_name = $this->stock->vendor_name($purchase_array[0]['vendor_id']);
				$voucher_type = $this->vouchers->voucher_name($purchase_array[0]['vtype_id']);

				#----------template
				$this->template->title("Receipt Note Report");
				$this->template->main_heading($this->lang->line("$voucher_name")." ".$this->lang->line("view"));
				$this->template->breadcrumb($breadcrumb);
				$this->template->slice('dms/message');
				$this->template->slice('purchase/receipt_note/view',array('purchase_array' => $purchase_array,'presumptive_tax' => $presumptive_tax,'purchase_cst' => $purchase_cst,'voucher_type' => $voucher_type,'vendor_name' => $vendor_name));
				$this->template->render();
			}
			else
			{
				redirect('users/logout');
			}
		}
		else
		{
			redirect('users/logout');
		}
	}

	public function update()
	{
		#----------voucher type
		$vtype_id = $this->vtype;

		#----------receipt primary key
		$uri_array = $this->uri->uri_to_assoc(3);
		if(isset($uri_array['id']))
		{
			$purchase_id = $uri_array['id'];
			$redirect = "/".$this->uri->assoc_to_uri($uri_array);
			unset($uri_array['id']);

			#----------redirect uri
			$redirect_uri = "receipt_note/report/".$this->uri->assoc_to_uri($uri_array);

			#----------redirect uri while updating
			$update_uri = $this->uri->assoc_to_uri($this->uri->uri_to_assoc(1));

			#----------voucher name
			$voucher_name = $this->vouchers->voucher_name($this->vtype);

			#-----------purchase cst checking details
			$purchase_cst = $this->stock->get_constant(array('purchase_cst'));

			#------------presumptive tax checking
			$presumptive_tax = $this->stock->get_tax_type();

			#------------cess %
			$cess = $this->stock->get_cess();

			#------------bill group_id and date
			$item_details = $this->purchase->get_group($purchase_id);

			#-------------adding items to receipt bill
			if(isset($_POST['btn_add']))
			{
				#-----------validation
				$this->form_validation->set_rules('item_id','lang:item-name','required|xss_clean|is_natural_no_zero');
				$this->form_validation->set_rules('godown_id','lang:godown','required|xss_clean');
				$this->form_validation->set_rules('cst','lang:cst','xss_clean|greater_or_equal[0]|less_or_equal[100]');
				$this->form_validation->set_rules('qty','lang:quantity','required|xss_clean|greater_than[0]|less_than[100000000]');
				$this->form_validation->set_rules('unit_id','lang:unit','required|xss_clean');
				$this->form_validation->set_rules('rate','lang:rate','required|xss_clean|greater_or_equal[0]|less_than[100000000]');
				$this->form_validation->set_rules('amount','lang:amount','xss_clean|required|greater_or_equal[0]|less_than[100000000]');
				$this->form_validation->set_rules('discount_per','lang:discount %','xss_clean|greater_or_equal[0]|less_or_equal[100]');
				$this->form_validation->set_rules('discount_amt','lang:discount','xss_clean|greater_or_equal[0]|less_than[100000000]');

				#-----------adding items
				if($this->form_validation->run('btn_add') === true)
				{
					$item_array['group_id'] = $item_details['group_id'];
					$item_array['item_id'] = $this->input->post('item_id',true);
					$item_array['qty'] = $this->input->post('qty',true);
					$item_array['unit_id'] = $this->input->post('unit_id',true);
					//$item_array['rate'] = $this->input->post('rate',true);
					$item_array['amount'] = $this->input->post('amount',true);

					#----------rate calculation
					$item_array['rate'] = 0;
					if($item_array['qty'] != 0){
						$item_array['rate'] = $item_array['amount'] / $item_array['qty'];
					}

					$item_array['discount_per'] = $this->input->post('discount_per',true);
					$item_array['discount_amt'] = $this->input->post('discount_amt',true);
					$item_array['godown_id'] = $this->input->post('godown_id',true);
					$item_array['status'] = 1;
					$item_array['item_status'] = 2;//purchase only items

					#----------VAT calculation
					$cst = 0;
					if($this->input->post('cst',true)){
						$cst = $this->input->post('cst',true);
						$item_array['cst'] = $cst;
					}
					if(empty($presumptive_tax)){
						if(!$cst){
							$vat_percent = $this->stock->get_item_vat($item_array['item_id']);
							$item_array['vat_percent'] = $vat_percent;
							$item_array['vat_amt'] = (($item_array['amount']-$item_array['discount_amt']) * $vat_percent) / 100;
						}
					}

					#----------start transaction
					$this->db->trans_start();

					$purchase_temp_item_result = $this->purchase->get_purchases(array('columns' => array('b.id'),'conditions' => array('b.group_id' => $item_array['group_id'],'item_id' => $item_array['item_id'],'godown_id' => $item_array['godown_id'],'unit_id' => $item_array['unit_id'],'a.status !=' => 0,'b.status !=' => 0),'numrows' => true));
					if($purchase_temp_item_result == 0){
						$purchase_items_id = $this->purchase->insert("dms_purchase_items",$item_array);
						if($purchase_items_id)
						{
							#--------------adding stock balance in dms_stocks
							$stock_bal = $this->stock->unit_conversion($item_array['item_id'],$item_array['unit_id'],$item_array['qty'],$item_array['rate'],$item_array['amount']);
							if($stock_bal)
							{
								$this->purchase->insert('dms_stocks',array('company_id' => $this->session->userdata('company_id'),'branch_id' => $this->session->userdata('under_id'),'godown_id' => $item_array['godown_id'],'item_id' => $item_array['item_id'],'qty' => $stock_bal['qty'],'unit_id' => $stock_bal['primary_unit'],'rate' => $stock_bal['rate'],'amount' => $stock_bal['amount'],'stock_date' => $item_details['bill_date'],'stock_status' => 1,'table_group_id' => $item_array['group_id'],'table_id' => $purchase_items_id));
							}
							$this->message->set($this->lang->line('receipt-add-success'));
						}
						else
						{
							$this->message->set($this->lang->line('receipt-add-error'),'e');
						}
					}
					else{
						$this->message->set($this->lang->line('receipt-add-error'),'e');
					}

					#----------end transaction
					$this->db->trans_complete();

					redirect($update_uri);
				}
			}

			#------------saving receipt voucher
			if(isset($_POST['btn_update']))
			{
				#-----------validation
				$this->form_validation->set_rules('bill_no','lang:bill-no',"required|xss_clean|is_natural_no_zero|callback_bill_no_exists[$item_details[vtype_id].$item_details[group_id]]");
				$this->form_validation->set_rules('bill_date','lang:bill-date','required|xss_clean|valid_date');
				$this->form_validation->set_rules('invoice_no','lang:invoice-no',"required|xss_clean");
				$this->form_validation->set_rules('invoice_date','lang:invoice-date','required|xss_clean|is_date');
				$this->form_validation->set_rules('vendor_id','lang:vendor','required|xss_clean');
				$this->form_validation->set_rules('remarks','lang:remarks','xss_clean');
				$this->form_validation->set_rules('freight','lang:freight','xss_clean|greater_or_equal[0]|less_than[100000000]');
				$this->form_validation->set_rules('other_expense','lang:other-expense','xss_clean|greater_or_equal[0]|less_than[100000000]');
				$this->form_validation->set_rules('bill_discount_per','lang:discount %','xss_clean|greater_or_equal[0]|less_or_equal[100]');
				$this->form_validation->set_rules('bill_discount_amt','lang:discount','xss_clean|greater_or_equal[0]|less_than[100000000]');

				#-----------updating data
				if($this->form_validation->run('btn_update') === true)
				{
					$bill_date = date('Y-m-d',strtotime($this->input->post('bill_date',true)));
					$invoice_date = date('Y-m-d',strtotime($this->input->post('invoice_date',true)));

					#----------start transaction
					$this->db->trans_start();

					$purchase_entry_array=array('bill_no' => $this->input->post('bill_no',true),'bill_date' => $bill_date,'invoice_no' => $this->input->post('invoice_no',true),'invoice_date' => $invoice_date,'vendor_id' => $this->input->post('vendor_id',true),'bill_discount_per' => $this->input->post('bill_discount_per',true),'bill_discount_amt	' => $this->input->post('bill_discount_amt',true),'bill_freight' => $this->input->post('freight',true),'other_expense' => $this->input->post('other_expense',true),'cess' => $cess,'narration' => $this->input->post('remarks',true),'status' => 1);
					if($this->purchase->update(array('table' => 'dms_receipt_notes','data' => $purchase_entry_array,'conditions' => array('id' => $purchase_id)))){
						$this->message->set($this->lang->line('receipt-edit-success'));
					}
					else{
						$this->message->set($this->lang->line('receipt-edit-error'),'e');
					}

					#----------end transaction
					$this->db->trans_complete();

					redirect($update_uri);
				}
			}

			#----------receipt data
			$purchase_array = $this->purchase->get_purchases(array('columns' => array('a.vtype_id','a.bill_no','a.bill_date','a.invoice_no','a.invoice_date','a.group_id','a.vendor_id','a.bill_discount_per','a.bill_discount_amt','a.bill_freight','a.other_expense','a.cess','a.narration','a.status','a.created_by','b.id','b.item_id','b.qty','b.unit_id','b.rate','b.amount','b.discount_per','b.discount_amt','b.godown_id','b.vat_amt','b.cst'),'conditions' => array('a.id' => $purchase_id,'a.status !=' => 0,'b.status !=' => 0)));

			#----------template
			if(!empty($purchase_array))
			{
				$continue = 1;
				if($purchase_array[0]['status'] == -1){
					if($purchase_array[0]['created_by'] != $this->session->userdata('id')){
						$continue = 0;
					}
				}
				if($continue == 1)
				{
					$stock_count = $primary_unit['symbol'] = "";

					#------------checking cst enabled or not
					$cst_status = $this->purchase->get_cst($purchase_array[0]['group_id']);
					if($cst_status){
						$purchase_cst = $cst_status;
					}

					#------------vendor details
					$vendors = $this->stock->get_vendors();

					#------------item details / unit details / godown details
					$units = $goDowns = array();
					$units[''] = "Select";
					$args['select'] = array('id','item_code','item_name');
					$items = $this->stock->get_stock_items($args);
					if(empty($items)){
						$this->message->set($this->lang->line('no-items-found'),'i');
					}
					if($this->input->post('item_id',true)){
						$itemID = $this->input->post('item_id',true);
						$goDowns = $this->stock->get_item_godowns(array('item_id'=>$itemID,'listing'=>1));
						$units = $this->stock->get_units($itemID);
					}

					#------------stock count of this item
					if($this->input->post('item_id',true) && $this->input->post('godown_id',true) && $purchase_array[0]['bill_date'] != ""){
						$stock_count = $this->stock->get_stock_count($this->input->post('godown_id',true),$this->input->post('item_id',true),$purchase_array[0]['bill_date']);
						$primary_unit = $this->stock->get_primary_unit($this->input->post('item_id',true));
					}

					$voucher_type = $this->vouchers->voucher_name($purchase_array[0]['vtype_id']);

					$items[''] = 'Select';ksort($items);
					$goDowns[''] = 'Select';ksort($goDowns);

					$this->template->title("Edit Receipt Note");
					$this->template->main_heading($this->lang->line("edit")." ".$this->lang->line("$voucher_name"));
					$this->template->breadcrumb(array($this->lang->line("inventory-voucher") => 'no_link',$this->lang->line("$voucher_name") => 'receipt_note/add',$this->lang->line('report') => 'receipt_note/report',$this->lang->line("update") => 'no_link',$this->lang->line("go-back") => array($redirect_uri)));
					$this->template->slice('dms/message');
					$this->template->slice('purchase/receipt_note/edit',array('purchase_array' => $purchase_array,'presumptive_tax' => $presumptive_tax,'purchase_cst' => $purchase_cst,'voucher_type' => $voucher_type,'vendors' => $vendors,'voucher_name' => $voucher_name,'items' => $items,'goDowns' => $goDowns,'units' => $units,'stock_count' => $stock_count,'primary_unit' => $primary_unit['symbol'],'redirect' => $redirect));
					$this->template->other_script('purchase/purchase');
					$this->template->render();
				}
				else
				{
					redirect('users/logout');
				}
			}
			else
			{
				redirect('users/logout');
			}

		}
		else
		{
			redirect('users/logout');
		}
	}

	public function delete()
	{
		#----------receipt primary key
		$uri_array = $this->uri->uri_to_assoc(3);
		if(isset($uri_array['id']))
		{
			$id = $uri_array['id'];
			unset($uri_array['id']);

			#----------redirect uri
			$redirect_uri = "receipt_note/report/".$this->uri->assoc_to_uri($uri_array);

			$result = $this->purchase->get_purchases(array('columns' => array('a.group_id','a.status','a.created_by','b.id'),'conditions' => array('a.id' => $id)));
			if(!empty($result))
			{
				$row = $result[0];$continue = 1;
				if($row['status'] == -1){
					if($row['created_by'] != $this->session->userdata('id')){
						$continue = 0;
					}
				}
				if($continue == 1)
				{
					#----------start transaction
					$this->db->trans_start();

					if($this->purchase->update_others(array('table' => 'dms_receipt_notes','data' => array('status' => 0),'conditions' => array('id' => $id))))
					{
						#-------------deleting purchase_items
						$this->purchase->update_others(array('table' => 'dms_purchase_items','data' => array('status' => 0),'conditions' => array('group_id' => $row['group_id'])));
						foreach($result as $key => $value)
						{
							#-------------deleting stock bal. from dms_stocks
							$this->purchase->update_others(array('table' => 'dms_stocks','data' => array('status' => 0),'conditions' => array('table_id' => $value['id'],'stock_status' => 1)));
						}

						$this->message->set($this->lang->line('receipt-delete-success'));
					}
					else
					{
						$this->message->set($this->lang->line('receipt-delete-error'),'e');
					}

					#----------end transaction
					$this->db->trans_complete();
				}
				else
				{
					redirect('users/logout');
				}
			}
			redirect($redirect_uri);
		}
		redirect('users/logout');
	}

	#----------------------------------------------------------------------------------------

	public function  pdf(){

		$pdf_name = 'receipt_note';
		$pdf_contents = '';
		if(!$this->uri->segment(4)){
			echo "<script>alert('".$this->lang->line('invalid-receipt-note')."');window.close();</script>";
		}
		$purchase_id = $this->uri->segment(4);
		if($this->if_exists('dms_receipt_notes',array('id'=>$purchase_id,'status'=>1)) === false){
			echo "<script>alert('".$this->lang->line('invalid-receipt-note')."');window.close();</script>";
		}
		#----------voucher type
		$vtype_id = $this->vtype;

		#----------voucher name
		$voucher_name = $this->vouchers->voucher_name($this->vtype);
		$this->load->library('My_pdf');
		$this->load->library('To_words');
		$this->my_pdf->set_tin();
		$this->my_pdf->set_header();

		#----------purchase data
		$purchase_array = $this->purchase->get_purchases(array('columns' => array('a.vtype_id','a.bill_no','a.bill_date','a.invoice_no','a.invoice_date','a.group_id','a.vendor_id','a.bill_discount_per','a.bill_discount_amt','a.bill_freight','a.other_expense','a.cess','a.narration','a.r_status','a.p_status','a.created_by','a.created_on','b.id','b.item_id','b.qty','b.unit_id','b.rate','b.amount','b.discount_per','b.discount_amt','b.godown_id','b.vat_amt','b.cst'),'conditions' => array('a.id' => $purchase_id,'a.status !=' => 0,'b.status !=' => 0)));


		if(empty($purchase_array)){
			echo "<script>alert('".$this->lang->line('invalid-receipt-note')."');window.close();</script>";
		}else{

			#------------presumptive tax checking
			$presumptive_tax = $this->stock->get_tax_type();
			#------------checking cst enabled or not
			$purchase_cst = $this->purchase->get_cst($purchase_array[0]['group_id']);
			$voucher_type = $this->vouchers->voucher_name($purchase_array[0]['vtype_id']);
			#--------------cheque / dd details
			$this->load->model('purchase/Purchase_vehicle_model','purchase_vehicle');
			$args = array();
			$args['select'] = array('dpv.id','rm.route_name','vm.vehicle_no','concat(u.fname," ",u.lname) as driver','u.mobile','dpv.km','dpv.remarks','dpv.vehicle_type','dpv.vehicle_no as vehicle_number','dpv.driver_name');
			$args['conditions'] = array('dpv.group_id'=>$purchase_array[0]['group_id']);
			$args['join'] = array('route_master as rm'=>'dpv.route_id=rm.id','vehicle_master as vm'=>'dpv.vehicle_id=vm.id','users as u'=>'dpv.driver_id=u.id');
			$purchase_vehicles = $this->purchase_vehicle->get($args);

			$cd_status = 1;$ccd = $cd_no = $pdc = "";
			$cheque_dd_array = $this->vouchers->cheque_data(array('columns' => array('b.cash_type','b.cd_no','b.pdc'),'conditions' => array('a.table_name' => 'dms_purchases','a.table_group_id' => $purchase_array[0]['group_id'])));
			if(!empty($cheque_dd_array))
			{
				$cd_status = 0;
				$ccd = $cheque_dd_array[0]['cash_type'];
				$cd_no = $cheque_dd_array[0]['cd_no'];
				$pdc = $cheque_dd_array[0]['pdc'];
			}
			$pdf_contents = $this->load->view('purchase/receipt_note/receipt_note_pdf',array('purchase_array' => $purchase_array,'presumptive_tax' => $presumptive_tax,'purchase_cst' => $purchase_cst,'voucher_type' => $voucher_type,'cd_status' => $cd_status,'ccd' =>$ccd,'cd_no' =>$cd_no,'pdc' => $pdc,'vehicle_details'=>$purchase_vehicles),true);
		}
		$this->my_pdf->output($pdf_name,$pdf_contents);
	}
}
?>