<?php if( ! defined('BASEPATH')) exit ('No direct script access allowed');

class Rejection_in_to_sales_return extends MY_Controller{
	var $companyID,$branchID,$createdBY;
	public function __construct()
	{
		parent::__construct();

		$this->check_access_right();
		$this->companyID = $this->session->userdata('company_id');
		$this->branchID = $this->session->userdata('under_id');
		$this->createdBY = $this->session->userdata('id');
		#---------------- Checking Financial year is enabled / closed-----------------#
		$method_array = array('sales_return');
		fiscal_status($this->uri->segment(2),$method_array,"sales_return/report");
		#---------------- Checking Financial year is enabled / closed-----------------#

		$this->branch_status = 0;
		if($this->dms->branch_type()){
			$this->branch_status = 1;
		}

		$this->load->model('sales/Rejection_in_model','rejection_in');
		$this->load->model('sales/Sales_return_model','sales_return');
		$this->load->model('vouchers/Voucher_model','vouchers');
		$this->load->library(array('Stock'));

		#----------voucher type
		$this->vtype = 8;
	}

	#----------------------------------------------------------------------------------------------------

	public function sales_return(){

		#----------voucher type
		$vtype_id = $this->vtype;

		$uri_array = $this->uri->uri_to_assoc(3);
		if(isset($uri_array['id']))
		{
			#----------rejection in primary key
			$rejectionID = $uri_array['id'];
			unset($uri_array['id']);

			#----------redirect uri
			$redirect_uri = "rejection_in/report/".$this->uri->assoc_to_uri($uri_array);

			$voucher_types = $this->vouchers->voucher_types($this->vtype);
			$bill_prefix = $this->stock->get_voucher_prefix($this->vtype);
			$voucher_name = $this->vouchers->voucher_name($this->vtype);
			$sales_cst = $this->stock->get_constant(array('sales_cst'));
			$presumptive_tax = $this->stock->get_tax_type();
			$payment_mode = $this->stock->payment_modes();
			$cess = $this->stock->get_cess();
			$cd_status = 1;$area_id=NULL;
			$result_array = $this->sales_return->next_bill_no($this->vtype);
			$vtype_id = $result_array['vtype_id'];
			$voucher_no = $result_array['bill_no'];
			$voucher_date = $result_array['bill_date'];

			$this->load->model('designations/Designation_master_model','desig');
			$this->load->model('customers/Customer_type_model','customer_type');
			$sales_returns_temp = $this->sales_return->get_sales_gst(array('columns' => array('a.group_id','a.s_status'),'conditions' => array('a.created_by' => $this->createdBY,'vtype_id' =>7,'a.status =' => -1)));

			if(!empty($sales_returns_temp)){
				$this->message->set($this->lang->line('pending-sreturn-exists'));
				if($purchase_returns_temp[0]['s_status'] == 0){
					redirect('sales_return/add');
				}
			}
			$rejection_ins = $this->rejection_in->get_sales_gst(array('columns' => array('a.id as rj_id','a.vtype_id','a.group_id','a.bill_no','a.bill_date','a.return_bill_no','a.customer_type_id','a.customer_id','a.area_id','a.bill_freight','a.other_expense','a.cess','a.narration','a.r_status','a.created_by','a.created_on','b.id','b.item_id','b.qty','b.unit_id','b.rate','b.amount','b.godown_id','b.cgst_amt','b.sgst_amt'),'conditions' => array('a.id' => $rejectionID,'a.status !=' => 0,'b.status !=' => 0)));

			if(empty($rejection_ins)){
				redirect("users/logout");
			}
			if(!empty($rejection_ins[0]['r_status'])){
				$this->message->set($this->lang->line('rin-already-converted'),'e');
				redirect($redirect_uri);
			}
			if($this->branch_status){
				$customerTypes = $this->desig->listing(array('department_id'=>0,'utype_status >'=>1));
			}else{
				$customerTypes = $this->desig->listing(array('id'=>2));
			}

			$rejection_id = $rejection_ins[0]['rj_id'];
			$rjnin_group_id = $rejection_ins[0]['group_id'];
			$rejection_date = $rejection_ins[0]['bill_date'];
			$custType = $rejection_ins[0]['customer_type_id'];
			$cust_id = $rejection_ins[0]['customer_id'];
			$area_id = $rejection_ins[0]['area_id'];
			$return_bill = NULL;$return_bill_id=0;

			if(!empty($rejection_ins[0]['return_bill_no'])){
				$return_bill_id = $rejection_ins[0]['return_bill_no'];
				$return_bill = $this->sales_return->get_bill_no($rejection_ins[0]['return_bill_no']);
			}
			if($rejection_ins[0]['return_bill_no'] > 0){

				$return_bill = $rejection_ins[0]['return_bill_no'];
				$customerTypes = $this->sales_return->get_customer_type($return_bill);
				$customers = $this->sales_return->get_customer($return_bill);
				$return_bills[$return_bill] = $this->sales_return->get_bill_no($return_bill);
				$items = $this->sales_return->get_bill_itemss($return_bill);

			}else{

				$return_bills = $this->sales_return->get_sales_bills();
				if($this->branch_status){
					$customerTypes = $this->desig->listing(array('department_id'=>0,'utype_status >'=>1));
				}else{
					$customerTypes = $this->desig->listing(array('id'=>2));
				}
				if($custType == 2){
					$this->load->model('customers/Customer_master_model','customer_master');
					$customers = $this->customer_master->listing(array('conditions'=>array('id'=>$cust_id)));
				}else if($custType == 1){
					$this->load->model('branches/Branch_model','branches');
					$customers = $this->branches->listing(array('id ='=>$cust_id));
				}else{
					$this->load->model('retailers/Counter_model','retailer_master');
					$customers = $this->retailer_master->listing(array('id'=>$cust_id));
				}
				$args['select'] = array('id','item_code','item_name');
				$items = $this->stock->get_stock_items($args);
				if(empty($items)){
					$this->message->set($this->lang->line('no-items-found'),'i');
				}
				$customerTypes[''] = 'Select';ksort($customerTypes);
				$customers[''] = 'Select';ksort($customers);
				$return_bills[''] = 'Select';ksort($return_bills);
			}

			$this->load->model('areas/Area_model','area');
			$areas = $this->area->listing();
			$rules = "";
			$this->form_validation->set_rules('bill_no','lang:bill-no',"required|xss_clean|is_natural_no_zero|callback_bill_no_exists[$vtype_id.$rjnin_group_id]");
			$this->form_validation->set_rules('bill_date','lang:bill-date',"required|xss_clean|valid_date|check_date[$rejection_date.>=]");
			#$this->form_validation->set_rules('area_id','lang:area','required|xss_clean');
			$this->form_validation->set_rules('payment_mode','lang:payment-mode','required|xss_clean');
			if($this->input->post('payment_mode',true) > 2){
				$cd_status = 0;
				$this->form_validation->set_rules('ccd','lang:cash-cheque-dd','required|xss_clean');
				$this->form_validation->set_rules('cd_no','lang:cd-no','required|xss_clean|max_length[64]');
				$this->form_validation->set_rules('cheque_date','lang:cheque-date',"required|xss_clean|is_date|check_date[$voucher_date.>=]");
			}
			$this->form_validation->set_rules('remarks','lang:remarks','xss_clean');
			$this->form_validation->set_rules('freight','lang:freight','xss_clean|greater_or_equal[0]|less_than[100000000]');
			$this->form_validation->set_rules('other_expense','lang:other-expense','xss_clean|greater_or_equal[0]|less_than[100000000]');
			if($this->form_validation->run('btn_save') === true){

				$bill_num = $this->input->post('bill_no');
				$bill_date = date('Y-m-d',strtotime($this->input->post('bill_date')));
				$payment_mode = $this->input->post('payment_mode');
				$cash_type=$cd_num=NULL;$cheque_date='0000-00-00';
				if($payment_mode >2){

					$cash_type = $this->input->post('ccd');
					$cd_num = $this->input->post('cd_no');
					$cheque_date = date('Y-m-d',strtotime($this->input->post('cheque_date')));
				}
				$remarks = $this->input->post('remarks');
				$freight = $this->input->post('freight');
				$other_expense = $this->input->post('other_expense');
				$net_amount = $this->input->post('net_amount');
				$round_off_amount = $this->input->post('round_off_amount');
				$vat_amount = $this->input->post('vat_amount');
				$cess_amount = $this->input->post('cess_amount');
				$net_amount += $round_off_amount;

				$sales_return_array = array('vtype_id'=>$vtype_id,'branch_id'=>$this->branchID,'group_id'=>$rjnin_group_id,'bill_no'=>$bill_num,'bill_date'=>$bill_date,'return_bill_no'=>$return_bill_id,'customer_type_id'=>$custType,'customer_id'=>$cust_id,'area_id'=>$area_id,'bill_freight'=>$freight,'other_expense'=>$other_expense,'cess'=>$cess,'payment_mode'=>$payment_mode,'narration'=>$remarks,'sid'=>$rejection_id,'s_status'=>2,'status'=>1);

				if($this->sales_return->insert('dms_sales_returns',$sales_return_array)){

					#voucher starts here...............................
					$voucher_status = 1;
					if(($payment_mode >2) && ($cash_type == 1) && (strtotime($bill_date) < strtotime($cheque_date))){
						$voucher_status = 3;
					}
					if($payment_mode == 2){

						$customerDetails = $this->stock->get_customer($custType,$cust_id,1);
						$cust_ledger_id = $customerDetails['ledger_id'];
						$payment_mode = $cust_ledger_id;
					}
					$voucher_group_id = $this->stock->get_group_id('dms_vouchers');
					$voucher_array = array('company_id'=>$this->companyID,'branch_id'=>$this->branchID,'group_id'=>$voucher_group_id,'vtype_id'=>$vtype_id,'vno'=>$bill_num,'vorder_no'=>1,'vdate'=>$bill_date,'dr_ledger' =>6,'cr_ledger' =>$payment_mode,'vamount' => $net_amount,'narration'=>$remarks,'table_name'=>'dms_sales_returns','table_group_id'=>$rjnin_group_id,'status'=>$voucher_status);

					if($this->sales_return->insert('dms_vouchers',$voucher_array)){

						#save vat amount to voucher.......
						$voucher_array['vorder_no'] = 2;
						$voucher_array['cr_ledger'] = $payment_mode;
						$voucher_array['dr_ledger'] = 12;
						$voucher_array['vamount'] = $vat_amount;
						$this->sales_return->insert('dms_vouchers',$voucher_array);

						#save cess amount to voucher......
						$voucher_array['vorder_no'] = 3;
						$voucher_array['cr_ledger'] = $payment_mode;
						$voucher_array['dr_ledger'] = 15;
						$voucher_array['vamount'] = $cess_amount;
						$this->sales_return->insert('dms_vouchers',$voucher_array);

						#save freight to voucher..............
						$voucher_array['vorder_no'] = 4;
						$voucher_array['dr_ledger'] = 13;
						$voucher_array['cr_ledger'] = $payment_mode;
						$voucher_array['vamount'] = $freight;
						$this->sales_return->insert('dms_vouchers',$voucher_array);

						#save other expense to voucher...
						$voucher_array['vorder_no'] = 5;
						$voucher_array['dr_ledger'] = 14;
						$voucher_array['cr_ledger'] = $payment_mode;
						$voucher_array['vamount'] = $other_expense;
						$this->sales_return->insert('dms_vouchers',$voucher_array);

						if($payment_mode > 2){
							$this->sales_return->insert('dms_voucher_banks',array('group_id' => $rjnin_group_id,'cash_type' => $cash_type,'cd_no' => $cd_num,'pdc' => $cheque_date,'vdate' => $bill_date));
						}
					}
					#voucher end here..................................

					$this->sales_return->update(array('table'=>'dms_rejection_ins','data'=>array('r_status'=>1),'conditions'=>array('id'=>$rejection_id)));

					$this->message->set($this->lang->line('sales_return-save-success'));
					$this->db->trans_complete();
					redirect('sales_return/report');
				}else{
					$this->message->set($this->lang->line('sales_return-save-error'),'e');
				}

			}
			$areas[''] = 'Select';ksort($areas);
			$this->template->title($this->lang->line("$voucher_name"));
			$this->template->main_heading($this->lang->line("$voucher_name"));
			$this->template->breadcrumb(array($this->lang->line("$voucher_name") => 'no_link',$this->lang->line('report') => 'sales_return/report'));
			$this->template->slice('dms/message');

			$this->template->slice('sales/rejection_in/sales_return',array('voucher_types' => $voucher_types,'voucher_type' => $vtype_id,'voucher_name' => $voucher_name,'voucher_no' => $voucher_no,'voucher_date' => $voucher_date,'return_bill' => $return_bill,'custType' => $custType,'customerTypes' => $customerTypes,'customers' => $customers,'cust_id' => $cust_id,'sales_temp_data' => $rejection_ins,'areas' => $areas,'area_id'=>$area_id,'sales_cst' => $sales_cst,'presumptive_tax' => $presumptive_tax,'cess' => $cess,'payment_mode' => $payment_mode,'cd_status' => $cd_status,'bill_prefix'=>$bill_prefix));
			$this->template->other_script('sales/sales_return');
			$this->template->render();
		}
		else
		{
			redirect('users/logout');
		}
	}
}
?>