<?php if( ! defined('BASEPATH')) exit ('No direct script access allowed');

class Rejection_out_to_purchase_return extends MY_Controller{
	var $companyID,$branchID,$createdBY;
	public function __construct()
	{
		parent::__construct();

		$this->check_access_right();
		$this->companyID = $this->session->userdata('company_id');
		$this->branchID = $this->session->userdata('under_id');
		$this->createdBY = $this->session->userdata('id');
		#---------------- Checking Financial year is enabled / closed-----------------#
		$method_array = array('purchase_return');
		fiscal_status($this->uri->segment(2),$method_array,"purchase_return/report");
		#---------------- Checking Financial year is enabled / closed-----------------#

		$this->branch_status = 0;
		if($this->dms->branch_type()){
			$this->branch_status = 1;
		}

		$this->load->model('purchase/Rejection_out_model','rejection_out');
		$this->load->model('purchase/Purchase_return_model','purchase_return');
		$this->load->model('vouchers/Voucher_model','vouchers');
		$this->load->library(array('Stock'));

		#----------voucher type
		$this->vtype = 7;
	}

	#------------------------------------------------------------------------------------------------------

	public function purchase_return()
	{
		$uri_array = $this->uri->uri_to_assoc(3);
		if(isset($uri_array['id']))
		{
			#----------rejection out primary key
			$rejectionID = $uri_array['id'];
			unset($uri_array['id']);

			#----------redirect uri
			$redirect_uri = "rejection_out/report/".$this->uri->assoc_to_uri($uri_array);

			#----------voucher type array
			$voucher_types = $this->vouchers->voucher_types($this->vtype);
			$bill_prefix = $this->stock->get_voucher_prefix($this->vtype);
			#----------voucher name
			$voucher_name = $this->vouchers->voucher_name($this->vtype);

			#-----------purchase cst checking details
			$purchase_cst = $this->stock->get_constant(array('purchase_cst'));

			#------------presumptive tax checking
			$presumptive_tax = $this->stock->get_tax_type();

			#------------cess %
			$cess = $this->stock->get_cess();
			$cd_status = 1;
			$result_array = $this->purchase_return->next_bill_no($this->vtype);
			$vtype_id = $result_array['vtype_id'];
			$voucher_no = $result_array['bill_no'];
			$voucher_date = $result_array['bill_date'];

			$purchase_returns_temp = $this->purchase_return->get_purchases_gst(array('columns' => array('a.group_id','a.s_status'),'conditions' => array('a.created_by' => $this->createdBY,'vtype_id' =>7,'a.status =' => -1)));
			if(!empty($purchase_returns_temp)){

				$this->message->set($this->lang->line('pending-preturn-exists'));
				if($purchase_returns_temp[0]['s_status'] == 0){
					redirect('purchase_return/add');
				}
			}

			$rejection_outs = $this->rejection_out->get_purchases(array('columns' => array('a.id as rj_id','a.vtype_id','a.bill_no','a.bill_date','a.return_bill_no','a.group_id','a.vendor_id','a.bill_freight','a.other_expense','a.cess','a.narration','b.id','b.item_id','b.qty','b.unit_id','b.rate','b.amount','b.godown_id','b.vat_amt','b.cst'),'conditions' => array('a.id' => $rejectionID,'a.status !=' => 0,'b.status !=' => 0)));
if(empty($rejection_outs))
{
$rejection_outs = $this->rejection_out->get_purchases_gst(array('columns' => array('a.id as rj_id','a.vtype_id','a.bill_no','a.bill_date','a.return_bill_no','a.group_id','a.vendor_id','a.bill_freight','a.other_expense','a.cess','a.narration','b.id','b.item_id','b.qty','b.unit_id','b.rate','b.amount','b.godown_id','b.cgst_amt','b.sgst_amt'),'conditions' => array('a.id' => $rejectionID,'a.status !=' => 0,'b.status !=' => 0)));

}
			if(empty($rejection_outs)){
				redirect("users/logout");
			}
			$rejection_id = $rejection_outs[0]['rj_id'];
			$vendor_id = $rejection_outs[0]['vendor_id'];
			$rjnout_group_id = $rejection_outs[0]['group_id'];
			$rejection_date = $rejection_outs[0]['bill_date'];
			$return_bill = NULL;$return_bill_id=0;
			if(!empty($rejection_outs[0]['return_bill_no'])){
				$return_bill_id = $rejection_outs[0]['return_bill_no'];
				$return_bill = $this->purchase_return->get_bill_no($rejection_outs[0]['return_bill_no']);
			}
			$rules = "callback_bill_no_exists[$vtype_id.$rjnout_group_id]";
			#----------------------------------------------------------------------

			$this->form_validation->set_rules('bill_no','lang:bill-no',"required|xss_clean|is_natural_no_zero|".$rules);
			$this->form_validation->set_rules('bill_date','lang:bill-date',"required|xss_clean|valid_date|check_date[$rejection_date.>=]");
			$this->form_validation->set_rules('payment_mode','lang:payment-mode','required|xss_clean');
			if($this->input->post('payment_mode',true) > 2){
				$cd_status = 0;
				$this->form_validation->set_rules('ccd','lang:cash-cheque-dd','required|xss_clean');
				$this->form_validation->set_rules('cd_no','lang:cd-no','required|xss_clean|max_length[64]');
				$this->form_validation->set_rules('cheque_date','lang:cheque-date',"required|xss_clean|is_date|check_date[$voucher_date.>=]");
			}
			$this->form_validation->set_rules('remarks','lang:remarks','xss_clean');
			$this->form_validation->set_rules('freight','lang:freight','xss_clean|greater_or_equal[0]|less_than[100000000]');
			$this->form_validation->set_rules('other_expense','lang:other-expense','xss_clean|greater_or_equal[0]|less_than[100000000]');

			if($this->form_validation->run() === true){

				$this->db->trans_start();
				$bill_num = $this->input->post('bill_no');
				$bill_date = date('Y-m-d',strtotime($this->input->post('bill_date')));
				$payment_mode = $this->input->post('payment_mode');
				$cash_type=$cd_num=NULL;$cheque_date='0000-00-00';
				if($payment_mode >2){
					$cash_type = $this->input->post('ccd');
					$cd_num = $this->input->post('cd_no');
					$cheque_date = date('Y-m-d',strtotime($this->input->post('cheque_date')));
				}
				$remarks = $this->input->post('remarks');
				$freight = $this->input->post('freight');
				$other_expense = $this->input->post('other_expense');
				$net_amount = $this->input->post('net_amount');
				$vat_amount = $this->input->post('vat_amount');
				$cess_amount = $this->input->post('cess_amount');
				$round_off_amount = $this->input->post('round_off_amount');
				#$net_amount -= $vat_amount;
				$net_amount += $round_off_amount;

				$purchase_return_array = array('vtype_id'=>$vtype_id,'branch_id'=>$this->branchID,'group_id'=>$rjnout_group_id,'bill_no'=>$bill_num,'bill_date'=>$bill_date,'sid'=>$rejection_id,'s_status'=>1,'return_bill_no'=>$return_bill_id,'vendor_id'=>$vendor_id,'bill_freight'=>$freight,'other_expense'=>$other_expense,'cess'=>$cess,'payment_mode'=>$payment_mode,'narration'=>$remarks,'status'=>1,'p_status'=>$this->branch_status);
				if($this->purchase_return->insert("dms_purchase_returns",$purchase_return_array)){

					#voucher starts here...............................
					$voucher_status = 1;
					if(($payment_mode >2) && ($cash_type == 1) && (strtotime($bill_date) < strtotime($cheque_date))){
						$voucher_status = 3;
					}
					if($payment_mode == 2){

						$args = array();
						$args['columns'] = array('ledger_id');
						$args['table'] = 'item_manufacturer_master';
						if($this->branch_status == 0){
							$args['table'] = 'branch_master';
						}
						$args['conditions'] = array('id'=>$vendor_id);
						$vendor_ledger = $this->dms->get_data($args);
						$vendor_ledger_id = $vendor_ledger[0]['ledger_id'];
						$payment_mode = $vendor_ledger_id;

					}
					$voucher_group_id = $this->stock->get_group_id('dms_vouchers');
					$voucher_array = array('company_id'=>$this->companyID,'branch_id'=>$this->branchID,'group_id'=>$voucher_group_id,'vtype_id'=>$vtype_id,'vno'=>$bill_num,'vorder_no'=>1,'vdate'=>$bill_date,'cr_ledger' =>5,'dr_ledger' =>$payment_mode,'vamount' => $net_amount,'narration'=>$remarks,'table_name'=>'dms_purchase_returns','table_group_id'=>$rjnout_group_id,'status'=>$voucher_status);

					if($this->purchase_return->insert('dms_vouchers',$voucher_array)){

						#save vat amount to voucher.......
						$voucher_array['vorder_no'] = 2;
						$voucher_array['dr_ledger'] = $payment_mode;
						$voucher_array['cr_ledger'] = 11;
						$voucher_array['vamount'] = $vat_amount;
						$this->purchase_return->insert('dms_vouchers',$voucher_array);

						#save cess amount to voucher......
						$voucher_array['vorder_no'] = 3;
						$voucher_array['dr_ledger'] = $payment_mode;
						$voucher_array['cr_ledger'] = 15;
						$voucher_array['vamount'] = $cess_amount;
						$this->purchase_return->insert('dms_vouchers',$voucher_array);

						#save freight to voucher..............
						$voucher_array['vorder_no'] = 4;
						$voucher_array['dr_ledger'] = 13;
						$voucher_array['cr_ledger'] = $payment_mode;
						$voucher_array['vamount'] = $freight;
						$this->purchase_return->insert('dms_vouchers',$voucher_array);

						#save other expense to voucher...
						$voucher_array['vorder_no'] = 5;
						$voucher_array['dr_ledger'] = 14;
						$voucher_array['cr_ledger'] = $payment_mode;
						$voucher_array['vamount'] = $other_expense;
						$this->purchase_return->insert('dms_vouchers',$voucher_array);

						if($payment_mode > 2){
							$this->purchase_return->insert('dms_voucher_banks',array('group_id' => $rjnout_group_id,'cash_type' => $cash_type,'cd_no' => $cd_num,'pdc' => $cheque_date,'vdate' => $bill_date));
						}
					}
					#voucher end here..................................

					$this->purchase_return->update(array('table'=>'dms_rejection_outs','data'=>array('p_status'=>1),'conditions'=>array('id'=>$rejection_id)));
					$this->db->trans_complete();
					$this->message->set($this->lang->line('purchase_return-save-success'));

					redirect('purchase_return/report');
				}else{
					$this->message->set($this->lang->line('purchase_return-save-error'),'e');
				}
			}

			#----------------------------------------------------------------------
			$vendors = $this->stock->get_vendors();
			$payment_mode = $this->stock->payment_modes();
			$disabled = '';
			$this->template->title($this->lang->line("$voucher_name"));
			$this->template->main_heading($this->lang->line("$voucher_name"));
			$this->template->breadcrumb(array($this->lang->line("$voucher_name") => 'no_link',$this->lang->line('report') => 'purchase_return/report'));
			$this->template->slice('dms/message');

			$this->template->slice('purchase/rejection_out/purchase_return',array('voucher_types' => $voucher_types,'voucher_type' => $vtype_id,'voucher_name' => $voucher_name,'voucher_no' => $voucher_no,'voucher_date' => $voucher_date,'return_bill' =>$return_bill,'vendors' => $vendors,'purchase_temp_status' =>$result_array['vstatus'],'purchase_temp_data' =>$rejection_outs,'vendor_id' =>$vendor_id,'purchase_cst' =>$purchase_cst,'presumptive_tax' =>$presumptive_tax,'cess' =>$cess,'payment_mode' =>$payment_mode,'disabled' => $disabled,'cd_status' => $cd_status,'bill_prefix'=>$bill_prefix));
			$this->template->other_script('purchase/purchase_return');
			$this->template->render();
		}
		else
		{
			redirect('users/logout');
		}
	}

	#----------------------------------------------------------------------------

	public function bill_no_exists($bill_no,$v_details = NULL)
	{
		if($v_details == NULL){
			$where = array('vtype_id'=>$this->input->post('vtype_id',true),'bill_no'=>$bill_no,'status !=' => 0);
		}else{
			$exp = explode('.', $v_details);
			$where = array('vtype_id' => $exp[0],'bill_no' => $bill_no,'group_id !=' => $exp[1],'status !=' => 0);
		}
		$row = $this->purchase_return->get_bills(array('columns' => array('id'),'conditions' => $where,'numrows' => true));
		if($row == 0){
			return true;
		}
		return false;
	}
}
?>