<?php if( ! defined('BASEPATH')) exit ('No direct script access allowed');

class Rejection_out_to_rejection_in extends MY_Controller{

	var $companyID,$branchID,$createdBY,$fiscal_start_date,$fiscal_end_date;
	public function __construct()
	{
		parent::__construct();

		$this->check_access_right();

		#---------------- Checking Financial year is enabled / closed-----------------#
		$method_array = array('requests');
		fiscal_status($this->uri->segment(2),$method_array,"rejection_out_to_rejection_in/requests");
		#---------------- Checking Financial year is enabled / closed-----------------#
		$this->load->library(array('Stock'));

		$this->companyID = $this->session->userdata('company_id');
		$this->branchID = $this->session->userdata('under_id');
		$this->createdBY = $this->session->userdata('id');
		$fiscals = $this->dms->get_fiscal_year();
		$this->fiscal_start_date = $fiscals['start_date'];
		$this->fiscal_end_date = $fiscals['end_date'];

		$this->branch_status = 0;
		if($this->dms->branch_type()){
			$this->branch_status = 1;
		}

		#----------voucher type
		$this->vtype = 11;
	}

	#-------------------------------------------------------

	public function requests(){

		$this->template->title($this->lang->line('rejection-in-requests'));
		$this->template->main_heading($this->lang->line('rejection-in-requests'));
		$this->template->breadcrumb(array($this->lang->line('rejection-in-requests') => 'no_link'));

		$this->load->model('purchase/Rejection_out_model','rejection_out');
		$this->load->model('vouchers/Voucher_model','vouchers');
		$this->load->library('Stock');
		$this->load->library('Pagination');

		$offset=0;$links = NULL;
		$presumptive_tax = $this->stock->get_tax_type();

		$links = $from_date = $to_date = NULL;$offset=0;
		$config['per_page'] = $this->per_page();
		# Pagination Config Customizations
        $config['full_tag_open'] = '<ul class="pagination">';
        $config['full_tag_close'] = '</ul>';
        $config['first_link'] = 'First';
        $config['last_link'] = 'Last';
        $config['next_link'] = '&raquo;';
        $config['prev_link'] = '&laquo;';
        $config['cur_tag_open'] = '<li class="active"><a href="#">';
        $config['cur_tag_close'] = '</a></li>';
        $config['num_tag_open'] = '<li>';
        $config['num_tag_close'] = '</li>';
		$config['uri_segment'] = 3;
		$offset = ($this->uri->segment(3))?$this->uri->segment(3):0;
		$config['base_url'] = base_url('rejection_out_to_rejection_in/requests');

		$args = array();
		$args['select'] = array('id');
		$args['conditions'] = array('vendor_id'=>$this->branchID,'branch_id !='=>$this->branchID,'p_status'=>0,'status'=>1);
		$args['numrows'] = 1;
		$config['total_rows'] = $this->rejection_out->get_bills($args);

		$this->pagination->initialize($config);
		$links = $this->pagination->create_links();

		$args = array();
		$args['columns'] = array('id','vtype_id','bill_no','bill_date','branch_id','return_bill_no','group_id','vendor_id','bill_freight','other_expense','cess','p_status','bill_status');
		$args['conditions'] = array('vendor_id'=>$this->branchID,'branch_id !='=>$this->branchID,'p_status'=>0,'status'=>1,'bill_status <'=>2);
		$args['limit'] = $config['per_page'];
		$args['offset'] = $offset;
		$rejection_outs = $this->rejection_out->get_bills($args);

		$rejection_in_requests = array();
		if(!empty($rejection_outs)){

			foreach($rejection_outs as $key=>$r_outs){
				$total_amount = 0;$total_tax_amount = 0;$presum_amount = 0;

				if($r_outs['bill_status'] == 0){
					$this->rejection_out->update_others(array('table'=>'dms_rejection_outs','data'=>array('bill_status'=>1),'conditions'=>array('id'=>$r_outs['id'])));
				}

				$requested_branch_id = $r_outs['branch_id'];
				$requested_by = $this->stock->get_customer(1,$requested_branch_id);
				$args = array();
				$args['columns'] = array('item_id','qty','rate','amount','vat_amt','cst');
				$args['conditions'] = array('group_id' => $r_outs['group_id'],'status' => 1);
				$rejection_out_items = $this->rejection_out->get_purchase_items($args);

				foreach($rejection_out_items as $itmKey=>$r_out_item){
					$tax_amount = 0;
					$net_value = $r_out_item['amount'];

					if(empty($presumptive_tax)){
						if($r_out_item['cst'] == 0){
							$vat = $this->stock->get_item_vat($r_out_item['item_id']);
							$tax_amount = $r_out_item['vat_amt'];//($vat*$net_value)/100;
						}else{
							$tax_amount = ($r_out_item['cst']*$net_value)/100;
						}
					}
					$total_tax_amount += $tax_amount;
					$total_amount += $net_value;
				}
				$total_amount += $total_tax_amount;
				if(!empty($presumptive_tax)){
					$presum_amount = ($presumptive_tax[0]*$total_amount)/100;
					$total_amount += $presum_amount;
				}
				$cess_amount = (($total_tax_amount+$presum_amount)*$r_outs['cess'])/100;
				$total_amount += ($cess_amount+$r_outs['bill_freight']+$r_outs['other_expense']);
				$rejection_in_requests[$r_outs['id']] = array('id'=>$r_outs['id'],'vtype_id'=>$r_outs['vtype_id'],'bill_no'=>$r_outs['bill_no'],'bill_date'=>$r_outs['bill_date'],'bill_status'=>$r_outs['bill_status'],'amount'=>$total_amount,'requested_by'=>$requested_by);
			}
		}

		if(empty($rejection_in_requests)){
			$this->message->set($this->lang->line('empty-rejection-in-requests'),'i');
		}

		$this->template->slice('dms/message');
		$this->template->slice('sales/rejection_in/pending_requests',array('rejection_in_requests'=>$rejection_in_requests,'count'=>$offset+1,'links'=>$links));
		$this->template->other_script('sales/sales');
		$this->template->slice('dms/modals/more_details');
		$this->template->render();
	}

	#----------------------------------------------------------------------------

	public function rejection_in(){

		if($this->uri->segment(3)){
			$rejectionoutID = $this->uri->segment(3);
			if($this->if_exists('dms_rejection_outs',array('id'=>$rejectionoutID,'vendor_id'=>$this->branchID,'branch_id !='=>$this->branchID)) === false){
				$this->message->set($this->lang->line('invalid-sr-request'),'e');
				redirect('rejection_out_to_rejection_in/requests');
			}
		}

		$this->load->model('sales/Rejection_in_model','rejection_in');
		$this->load->model('purchase/Rejection_out_model','rejection_out');
		$this->load->model('vouchers/Voucher_model','vouchers');
		$this->load->library('Stock');

		$this->load->model('designations/Designation_master_model','desig');
		$this->load->model('customers/Customer_type_model','customer_type');
		$this->load->model('areas/Area_model','area');
		$areas = $this->area->listing();

		$godowns = $this->stock->get_godowns(array('conditions'=>array('branch_id'=>$this->branchID),'listing'=>1));
		$this->template->title($this->lang->line('rejection-in'));
		$this->template->main_heading($this->lang->line('rejection-in'));
		$this->template->breadcrumb(array($this->lang->line('rejection-in') => 'no_link'));

		$Ckargs = array();
		$Ckargs['columns'] = array('id','s_status');
		$Ckargs['conditions']=array('created_by'=>$this->createdBY,'status'=>-1,'branch_id'=>$this->branchID);
		$rejection_in_temp = $this->rejection_in->get_bills($Ckargs);

		if(!empty($rejection_in_temp)){
			if($rejection_in_temp[0]['s_status'] == 0){
				$this->message->set($this->lang->line('pending-rejection-in-exists'),'e');
				redirect('rejection_in/add');
			}
		}

		$args = array();
		$args['columns'] = array('id');
		$args['conditions']=array('s_status'=>1,'sid'=>$rejectionoutID);
		$rejection_in_check = $this->rejection_in->get_bills($args);
		if(!empty($rejection_in_check)){
			$this->message->set($this->lang->line('rej-out-already-converted'),'e');
			redirect('rejection_out_to_rejection_in/requests');
		}

		$result_array = $this->rejection_in->next_bill_no($this->vtype);
		$vtype_id = $result_array['vtype_id'];
		$voucher_no = $result_array['bill_no'];
		$voucher_date = $result_array['bill_date'];

		$args = array();
		$args['columns'] = array('a.id','a.vtype_id','a.branch_id','a.group_id','a.bill_no','a.bill_date','a.return_bill_no','a.vendor_id','a.bill_freight','a.other_expense','a.cess','a.p_status','b.id as rout_id','b.item_id','b.qty','b.unit_id','b.rate','b.amount','b.vat_percent','b.vat_amt','b.cst','b.godown_id');
		$args['conditions'] = array('a.id'=>$rejectionoutID,'a.vendor_id'=>$this->branchID,'a.branch_id'=>'');
		$rejection_outs = $this->rejection_out->get_purchases($args);

		if(empty($rejection_outs)){
			$this->message->set($this->lang->line('invalid-r-out-request'),'e');
			redirect('rejection_out_to_rejection_in/requests');
		}

		$customerID = $rejection_outs[0]['branch_id'];
		$cust_id = $customerID;
		$custType =1;
		if($this->branch_status){
			$customerTypes = $this->desig->listing(array('department_id'=>0,'utype_status >'=>1));
		}else{
			$customerTypes = $this->desig->listing(array('id'=>2));
		}
		if(!empty($custType)){
			$customers = $this->stock->get_customers($custType);
		}

		$areas[''] = 'Select';ksort($areas);
		$godowns[''] = 'Select';ksort($godowns);
		$voucher_types = $this->vouchers->voucher_types($this->vtype);
		$bill_prefix = $this->stock->get_voucher_prefix($this->vtype);
		$voucher_name = $this->vouchers->voucher_name($this->vtype);
		$sales_cst = $this->stock->get_constant(array('sales_cst'));
		$presumptive_tax = $this->stock->get_tax_type();
		$cess = $this->stock->get_cess();
		$return_bill = NULL;

		$this->form_validation->set_rules('bill_no','lang:bill-no',"required|xss_clean|is_natural_no_zero|callback_bill_no_exists");
		$this->form_validation->set_rules('bill_date','lang:bill-date','required|xss_clean|valid_date');
		$this->form_validation->set_rules('area_id','lang:area','required|xss_clean');
		$this->form_validation->set_rules('remarks','lang:remarks','xss_clean');
		$this->form_validation->set_rules('freight','lang:freight','xss_clean|greater_or_equal[0]');
		foreach($rejection_outs as $key=>$item){
			$this->form_validation->set_rules('godown_id_'.$item['rout_id'],'lang:godown','xss_clean|required');
		}
		$this->form_validation->set_rules('other_expense','lang:other-expense','xss_clean|greater_or_equal[0]');
		if($this->form_validation->run('btn_save') === true){

			$group_id = $this->stock->get_group_id('dms_sales_return_items');
			$bill_num = $this->input->post('bill_no');
			$bill_date = date('Y-m-d',strtotime($this->input->post('bill_date')));
			$area_id = $this->input->post('area_id');
			$remarks = $this->input->post('remarks');
			$freight = $this->input->post('freight');
			$otherExpense = $this->input->post('other_expense');

			$returnBillNo =0;
			if(!empty($purchaseID)){
				$this->db->select(array('pid','p_status'));
				$this->db->from('dms_purchases');
				$this->db->where(array('id'=>$purchaseID));
				$purchases = $this->db->get()->row_array();
				if(!empty($purchases) && $purchases['p_status'] == 4){
					$returnBillNo = $purchases['pid'];
				}
			}

			$saveRejectionIns = array('vtype_id'=>$vtype_id,'branch_id'=>$this->branchID,'group_id'=>$group_id,'bill_no'=>$bill_num,'bill_date'=>$bill_date,'return_bill_no'=>$returnBillNo,'sid'=>$rejectionoutID,'s_status'=>1,'customer_type_id'=>$custType,'customer_id'=>$customerID,'area_id'=>$area_id,'bill_freight'=>$freight,'other_expense'=>$otherExpense,'cess'=>$cess,'narration'=>$remarks,'r_status'=>0);

			if($this->rejection_in->insert("dms_rejection_ins",$saveRejectionIns)){
				$this->db->trans_start();
				foreach($rejection_outs as $key=>$r_out_item){

					$godownID = $this->input->post('godown_id_'.$r_out_item['rout_id']);
					$save_rejection_in_items = array('group_id'=>$group_id,'item_id'=>$r_out_item['item_id'],'godown_id'=>$godownID,'qty'=>$r_out_item['qty'],'unit_id'=>$r_out_item['unit_id'],'rate'=>$r_out_item['rate'],'amount'=>$r_out_item['amount'],'vat_percent'=>$r_out_item['vat_percent'],'vat_amt'=>$r_out_item['vat_amt'],'cst'=>$r_out_item['cst']);
					$this->rejection_in->insert("dms_sales_return_items",$save_rejection_in_items);
					$convertedStock = $this->stock->unit_conversion($r_out_item['item_id'],$r_out_item['unit_id'],$r_out_item['qty'],$r_out_item['rate'],$r_out_item['amount']);
					$this->rejection_in->insert('dms_stocks',array('company_id'=>$this->companyID,'branch_id'=>$this->branchID,'godown_id' =>$godownID,'item_id' =>$r_out_item['item_id'],'qty' => $convertedStock['qty'],'unit_id' => $convertedStock['primary_unit'],'rate' => $convertedStock['rate'],'amount' => $convertedStock['amount'],'stock_date' =>$bill_date,'stock_status' =>7,'table_group_id'=>$group_id,'table_id' => $r_out_item['rout_id'],'status' =>1));
					$this->db->update('dms_stocks',array('status'=>1),array('table_id'=>$r_out_item['rout_id'],'stock_status'=>3));

				}
				$this->db->update('dms_rejection_outs',array('bill_status'=>2),array('id'=>$rejectionoutID));
				$this->db->trans_complete();
				$this->message->set($this->lang->line('rejection-in-save-success'));
				redirect('rejection_out_to_rejection_in/requests');
			}
		}

		$this->template->slice('dms/message');
		$this->template->slice('sales/rejection_in/rejection_out_to_rejection_in',array('voucher_types' => $voucher_types,'voucher_type' => $vtype_id,'voucher_name' => $voucher_name,'voucher_no' => $voucher_no,'voucher_date' => $voucher_date,'return_bill' => $return_bill,'custType' => $custType,'customerTypes' => $customerTypes,'customers' => $customers,'cust_id' => $cust_id,'sales_temp_data' => $rejection_outs,'areas' => $areas,'sales_cst' => $sales_cst,'presumptive_tax' =>$presumptive_tax,'cess' => $cess,'godowns'=>$godowns,'bill_prefix'=>$bill_prefix));
		$this->template->other_script('sales/rejection_in');
		$this->template->render();

	}

	#----------------------------------------------------------------------------

	public function bill_no_exists($bill_no,$v_details = NULL)
	{
		if($v_details == NULL){
			$where = array('vtype_id' =>11,'bill_no' => $bill_no,'status !=' => 0);
		}else{
			$exp = explode('.', $v_details);
			$where = array('vtype_id' => $exp[0],'bill_no' => $bill_no,'group_id !=' => $exp[1],'status !=' => 0);
		}
		$row = $this->rejection_in->get_bills(array('columns' => array('id'),'conditions' => $where,'numrows' => true));
		if($row == 0){
			return true;
		}
		return false;
	}

	#------------------------------------------------------------------------------
}?>