<?php if ( ! defined('BASEPATH')) exit('No direct script access allowed');
	
	class Retailers extends MY_Controller{

		public function __construct(){

			parent :: __construct();
			$this->check_access_right();
			$this->load->model('retailers/Counter_model','retailer');
			
			#---------------- Checking Financial year is enabled / closed-----------------#
			$method_array = array('add','update','delete','unblock','add_vehicles','vehicle_edit','vehicle_delete');
			fiscal_status($this->uri->segment(2),$method_array,"retailers/report");	
			#---------------- Checking Financial year is enabled / closed-----------------#
		}

		#-------------------------------------------------

		public function add(){
			$this->load->model('accounts/Ledger_model','ledger');
			if($this->form_validation->run() === true){

				#get retailer details
				$retailer = $this->input->post(NULL,TRUE);
				#get staff details
				$user = $this->input->post('user');
				$open_amount = $this->input->post('open_amount',TRUE);
				$dc_type =  $this->input->post('dc_type',TRUE);
				unset($retailer['open_amount']);unset($retailer['dc_type']);
				
				#if no short-code, then company name itself
				$retailer['retailer_short_name'] = ($retailer['retailer_short_name'] != '')?$retailer['retailer_short_name']:$retailer['retailer_name'];
				$retailer['company_id'] = $this->session->userdata('company_id');
				$retailer['fiscal_yr_id'] = $this->dms->get_default_fiscal_id();
				$user_password = $retailer['password'];
				if($user_password != ''){
					$user['password'] = password_hash($user_password,PASSWORD_DEFAULT);
				 }

				$user['fname'] = $retailer['fname'];
				$user['lname'] = $retailer['lname'];
				$user['email'] = $retailer['email'];
				$user['username'] = $retailer['username'];
				$user['company_id'] = $retailer['company_id'];
				$user['area_id'] = $retailer['area_id'];
				$user['fiscal_yr_id'] = $this->dms->get_default_fiscal_id();
				unset($retailer['fname']);
				unset($retailer['lname']);
				unset($retailer['email']);
				unset($retailer['username']);
				unset($retailer['password']);
				#save retailer details in retailer master
				if($this->retailer->f_save('retailer_master',$retailer)){
					#get last retailer id
					$retailer_id = $this->db->insert_id();
					#saving ledger in dms ledgers
					$ledger['company_id'] = $this->session->userdata('company_id');
					$ledger['ledger_name'] = $retailer['retailer_name'].'-'.$retailer['retailer_mobile'];
					$ledger['branch_id'] = $this->session->userdata('under_id');
					$ledger['sgroup_id'] = 15;
					$ledger['dc'] = $this->ledger->get_dc($ledger['sgroup_id']);

					$last_insert_id = $this->ledger->insert('dms_ledgers',$ledger);
					#update branch id ;
					$this->retailer->my_update('retailer_master',array('ledger_id'=>$last_insert_id),array('id'=>$retailer_id));
					$open['ledger_id'] = $last_insert_id ;
					//$data['ledger_id'] = $last_insert_id ;

					if(!empty($open_amount)){

						if($dc_type != $ledger['dc']){
						$open['open_amount'] = -$open_amount;
						}else{
							$open['open_amount'] = $open_amount;
						}
						$open['company_id'] = $this->session->userdata('company_id');
						$open['branch_id'] = $this->session->userdata('under_id');
						$open['open_date'] = $this->dms->get_fiscal_year()['start_date'];
						$this->ledger->insert('dms_ledger_open_bals',$open);
					}
					
					//for saving retailer_id as branch_id in users table
					$user['branch_id'] = $retailer_id;
					$user['designation_id'] = 3;
					#save user datas in user table#	
					$this->retailer->f_save('users',$user);

					$this->message->set($this->lang->line('retailer-saved'));
					redirect('retailers/report');
				}else{
					$this->message->set('retailer-not-saved');
				}
				
			}

			#get all areas
			$this->load->model('areas/Area_model','area');
			$areas = $this->area->listing();
			$areas[''] = 'Select';ksort($areas);
			$dc_array = array('dr' => 'Dr','cr' => 'Cr');
			$this->template->title($this->lang->line('retailers'));
			$this->template->main_heading($this->lang->line('retailers'));
			$this->template->breadcrumb(array($this->lang->line('retailers')=>'no_link',$this->lang->line('report')=>'retailers/report'));
			$this->template->slice('dms/message');
			$this->template->slice('preferences/retailers/add',array('areas'=>$areas,'dc_array'=>$dc_array));
			$this->template->render();
		}

	#-------------------------------------------------	

		public function report(){

			$this->template->title($this->lang->line('retailer-settings'));
			$this->template->main_heading($this->lang->line('retailers'));
			$this->template->breadcrumb(array($this->lang->line('retailers')=>'retailers/add',$this->lang->line('report')=>'no_link'));
			
			#get counters
			$this->load->library('Pagination');
			$this->load->model('retailers/Counter_model','retailer');
			$config['base_url'] = base_url('retailers/report');
			$config['total_rows'] = $this->retailer->get_all(array('company_id'=>$this->session->userdata('company_id'),'status'=>1),1);
			$config['per_page'] = $this->per_page();
			# Pagination Config Customizations
			$config['full_tag_open'] = '<ul class="pagination">';
			$config['full_tag_close'] = '</ul>';
			$config['first_link'] = 'First';
			$config['last_link'] = 'Last';
			$config['next_link'] = '&raquo;';
			$config['prev_link'] = '&laquo;';
			$config['cur_tag_open'] = '<li class="active"><a href="#">';
			$config['cur_tag_close'] = '</a></li>';
			$config['num_tag_open'] = '<li>';
			$config['num_tag_close'] = '</li>';
			$config['uri_segment'] = 3;
			$this->pagination->initialize($config);
			$offset = ($this->uri->segment(3))?$this->uri->segment(3):0;
			$counters = $this->retailer->get_all(array('company_id'=>$this->session->userdata('company_id'),'status'=>1),NULL,$offset,$config['per_page']);
			
			if(empty($counters)){
				$this->message->set($this->lang->line('no-results-found'),'i');
			}

			$links = $this->pagination->create_links();
			$this->template->slice('dms/message');
			$this->template->slice('preferences/retailers/report',array('counters'=>$counters,'count'=>$offset,'links'=>$links));
			$this->template->slice('dms/modals/more_details');
			$this->template->other_script('retailers/show_retailer');
			$this->template->render();
		}

	#--------------------------------------------------
		
		public function update($id){

			if(empty($id) && !$this->input->post()){
				redirect('retailers/report');
			}
			$reatiler_id = $this->uri->segment(3);

			#get details of correspondind id
			$counter = $this->db->get_where('retailer_master',array('id'=>$reatiler_id))->row_array();
			if(empty($counter)){
				redirect('retailers/report');
			}
			$this->load->model('accounts/Ledger_model','ledger');

			$open_bal = array();
			if($counter['ledger_id'] !=0){
				$open_bal = $this->retailer->open_balance($counter['ledger_id']);
			}
			$user_exist = $this->db->select(array('id','fname','lname','email','username','password'))->get_where('users',array('branch_id'=>$reatiler_id,'designation_id'=>3))->row_array();

			#validation
			if($this->form_validation->run('retailers/update') === true){

				$data = $this->input->post(NULL,TRUE);
				#$user = $this->input->post('user');
				#unset($data['user']);
				$user['fname'] = $data['fname'];
				$user['lname'] = $data['lname'];
				$user['email'] = $data['email'];
				$user['username'] = $data['username'];
				$user_password = $data['password'];
				unset($data['fname']);
				unset($data['lname']);
				unset($data['email']);
				unset($data['username']);
				unset($data['password']);
								
				#-----------------------------updating ledgers------------------------------------
				$open_amount = $this->input->post('open_amount',TRUE);
				$dc_type =  $this->input->post('dc_type',TRUE);
				unset($data['open_amount']);unset($data['dc_type']);
				if($this->input->post('open_id',TRUE)){

					if($open_amount != 0){

						$ledger['ledger_name'] = $data['retailer_name'].'-'.$data['retailer_mobile'];
						$ledger['sgroup_id'] = 15;
						$ledger['dc'] = $this->ledger->get_dc($ledger['sgroup_id']);
						$this->retailer->my_update('dms_ledgers',$ledger,array('id'=>$data['ledger_id']));
						if($dc_type != $ledger['dc']){
							$open['open_amount'] = -$open_amount;
						}else{
							$open['open_amount'] = $open_amount;
						}
						$this->retailer->my_update('dms_ledger_open_bals',$open,array('id'=>$data['open_id'],'ledger_id'=>$data['ledger_id']));

					}else{
						#checking vat is set to open balence
						if($open_bal['vat'] == 1){

							$ledger['ledger_name'] = $data['retailer_name'].'-'.$data['retailer_mobile'];
							$ledger['sgroup_id'] = 15;
							$ledger['dc'] = $this->ledger->get_dc($ledger['sgroup_id']);
							$this->retailer->my_update('dms_ledgers',$ledger,array('id'=>$data['ledger_id']));
							$open['open_amount'] = 0;
							$this->retailer->my_update('dms_ledger_open_bals',$open,array('id'=>$data['open_id'],'ledger_id'=>$data['ledger_id']));

						}else{
						
							#delete dms_open_balance data 
							$this->retailer->my_update('dms_ledger_open_bals',array('status'=>0),array('id'=>$data['open_id'],'ledger_id'=>$data['ledger_id']));
						}
					}
					unset($data['open_id']);
					unset($data['ledger_id']);
				}else{

						$ledger['ledger_name'] = $data['retailer_name'].'-'.$data['retailer_mobile'];
						$ledger['sgroup_id'] = 15;
						$ledger['dc'] = $this->ledger->get_dc($ledger['sgroup_id']);
						$this->retailer->my_update('dms_ledgers',$ledger,array('id'=>$data['ledger_id']));
						if(!empty($open_amount)){

							if($dc_type != $ledger['dc']){
								$open['open_amount'] = -$open_amount;
							}else{
								$open['open_amount'] = $open_amount;
							}
							$open['ledger_id'] = $data['ledger_id'];
							$open['company_id'] = $this->session->userdata('company_id');
							$open['branch_id'] = $this->session->userdata('under_id');
							$open['open_date'] = $this->dms->get_fiscal_year()['start_date'];
							$this->ledger->insert('dms_ledger_open_bals',$open);
						}
					unset($data['ledger_id']);
				}
				#--------------------------------------------------------------------------------- 
				if($user_password != ''){
					$user['password'] = password_hash($user_password,PASSWORD_DEFAULT);
				}else{
					unset($user['password']);
				}
				if($this->retailer->my_update('retailer_master',$data,array('id'=>$reatiler_id))){
					$this->retailer->my_update('users',$user,array('id'=>$user_exist['id'],'branch_id'=>$reatiler_id));
					$this->message->set($this->lang->line('retailer-updated'),'s');
				}else{
					$this->message->set($this->lang->line('retailer-not-updated'),'e');	
				}
				redirect('retailers/report');
			}

			#get all areas
			$this->load->model('areas/Area_model','area');
			$areas = $this->area->listing();
			$areas[''] = 'Select';ksort($areas);
			$dc_array = array('dr' => 'Dr','cr' => 'Cr');

			$this->template->title($this->lang->line('retailer-settings'));
			$this->template->main_heading($this->lang->line('retailer-settings'));
			$this->template->breadcrumb(array($this->lang->line('retailers')=>'retailers/add',$this->lang->line('update')=>'no_link',$this->lang->line('report')=>'retailers/report'));
			$this->template->slice('dms/message');
			$this->template->slice('preferences/retailers/update',array('counter'=>$counter,'areas'=>$areas,'user'=>$user_exist,'dc_array'=>$dc_array,'open_bal'=>$open_bal));
			$this->template->render();
		}

		#--------------------------------------------------

		public function delete($id){
			if(!$this->uri->segment(3) || empty($id)){
				redirect('retailers/report');
			}

			$id = $this->uri->segment(3);
			if($this->if_exists('retailer_master',array('id'=>$id,'status'=>1)) === false){
				redirect('retailers/report');
			}
			$retailers = $this->db->get_where('retailer_master',array('id'=>$id))->row_array();
			$retailer_ledger_id = $retailers['ledger_id'];
			
			$total_privileges = $this->db->select('id')->get_where('user_privileges',array('owner_id'=>$id))->num_rows();
			$total_sales = $this->db->select('id')->get_where('dms_sales',array('customer_type_id'=>3,'customer_id'=>$id,'status'=>1))->num_rows();
			$total_so = $this->db->select('id')->get_where('dms_sales_orders',array('customer_type_id'=>3,'customer_id'=>$id,'status'=>1))->num_rows();
			$total_so_temps = $this->db->select('id')->get_where('dms_sales_order_temp',array('customer_type_id'=>3,'customer_id'=>$id))->num_rows();
			$total_sales_returns = $this->db->select('id')->get_where('dms_sales_returns',array('customer_type_id'=>3,'customer_id'=>$id,'status'=>1))->num_rows();
			$total_vouchers = $this->db->select('id')->from('dms_vouchers')->where('status',1)->where('dr_ledger',$retailer_ledger_id)->or_where('cr_ledger',$retailer_ledger_id)->get()->num_rows();
			$total_voucher_temps = $this->db->select('id')->from('dms_voucher_temps')->where('dr_ledger',$retailer_ledger_id)->or_where('cr_ledger',$retailer_ledger_id)->get()->num_rows();

			if(empty($total_privileges) && empty($total_sales) && empty($total_so) && empty($total_so_temps) && empty($total_sales_returns) && empty($total_vouchers) && empty($total_voucher_temps)){
				#delete retailer data;
				if($this->retailer->my_update('retailer_master',array('status'=>0),array('id'=>$id))){
					#delete users table from retailer login
					$this->retailer->my_update('users',array('status'=>0),array('branch_id'=>$id,'designation_id'=>3));
					$this->retailer->my_update('dms_ledgers',array('status'=>0),array('id'=>$retailer_ledger_id));
					$this->retailer->my_update('dms_ledger_open_bals',array('status'=>0),array('ledger_id'=>$retailer_ledger_id));
					$this->message->set($this->lang->line('retailer-deleted'),'s');
				}else{
					$this->message->set($this->lang->line('retailer-not-deleted'),'e');
				}
			}else{
				$this->message->set($this->lang->line('can-not-delete-retailer'),'i');
			}
			redirect('retailers/report');
		}
	
		#--------------------------------------------------

		#date : 28-7-2014
		#purpose : unblock AR
		public function unblock($counter_id){
			
			if($this->if_exists('retailer_master',array('id'=>$counter_id,'status'=>1)) === false){
				redirect('retailers/report');
			}
			$data['status'] = 1;
			if($this->db->update('retailer_master',$data,array('id'=>$counter_id)));
			{	
				$this->message->set($this->lang->line('retailers-unblocked'),'s');
			}
			redirect('retailers/report');
		}

		#---------------------------------------------------
		#date:4-8-2014
		#purpose:Ar vehicle
	    public function add_vehicles(){
	    	#validation#

			if($this->form_validation->run('vehicles/add') == true){

				$data = $this->input->post(NULL,TRUE);
				$data['insurance_valid_from'] = date('Y-m-d',strtotime($this->input->post('insurance_valid_from',true)));
				$data['insurance_valid_to'] = date('Y-m-d',strtotime($this->input->post('insurance_valid_to',true)));
				$data['created_by'] = $this->session->userdata('id');
				$data['company_id'] = $this->session->userdata('company_id');
				$data['type']='AR';
			
				  #insert
				if($this->db->insert('vehicle_master',$data)){
					$this->message->set($this->lang->line('vehicle-saved'));
				}else{
						$this->message->set($this->lang->line('vehicle-not-saved'));
				}

			}
            #vehicle type listing
			$this->load->model('vehicle_types/Vehicle_type_model','type');
			$types = $this->type->listing();

			$types[''] = 'Select A Type';
            $this->template->title($this->lang->line('vehicle-setting'));
			$this->template->main_heading($this->lang->line('vehicle-setting'));
			$this->template->breadcrumb(array($this->lang->line('ar')=>'no_link',$this->lang->line('report')=>'retailers/vehicle_report'));
			$this->template->slice('dms/message');
            $this->template->slice('preferences/retailers/vehicles/add/new',array('types'=>$types));
            $this->template->render();

        }	

		#----------------------------------------------------
        #date:06-08-2014
        #purpose:velicle_report

		public function vehicle_report(){

      	    $this->load->model('vehicles/Vehicle_model','vehicle');
            $this->form_validation->set_rules('vehicle_no','Vehicle No','required');
			if($this->form_validation->run() == true || $this->uri->segment(3) == 'vehicle'){

				$vehicle = ($this->input->post('vehicle_no'))?$this->input->post('vehicle_no',true):$this->uri->segment(3);
				if($vehicle != 'all'){
					$conditions['id'] =$vehicle;
				}else{
					$conditions[''] = '';
				}
			}else{
				$vehicle = 'all';
			}

            $conditions['company_id'] =  $this->session->userdata('company_id');
			$conditions['type'] = 'AR';
            $this->load->library('Pagination');
            $config['per_page'] = 1;
			# Pagination Config Customizations
			$config['full_tag_open'] = '<ul class="pagination">';
			$config['full_tag_close'] = '</ul>';
			$config['first_link'] = 'First';
			$config['last_link'] = 'Last';
			$config['next_link'] = '&raquo;';
			$config['prev_link'] = '&laquo;';
			$config['cur_tag_open'] = '<li class="active"><a href="#">';
			$config['cur_tag_close'] = '</a></li>';
			$config['num_tag_open'] = '<li>';
			$config['num_tag_close'] = '</li>';
		   	$config['total_rows'] = $this->vehicle->get_all($conditions,1);
			if($config['total_rows'] == 0){ $this->message->set($this->lang->line('no-items-found'),'i');}

			if($this->uri->segment(3) == 'vehicle' || $this->input->post('vehicle_no')){
				$config['base_url'] = base_url('retailers/vehicle_report/vehicle/'.$vehicle);
				$config['uri_segment'] = 5;
				$offset = ($this->uri->segment(5))?$this->uri->segment(5):0;
			}else{
				$config['base_url'] = base_url('retailers/vehicle_report');
				$config['uri_segment'] = 3;
				$offset = ($this->uri->segment(3))?$this->uri->segment(3):0;
			}
			
			$this->pagination->initialize($config);
			$links = $this->pagination->create_links();
            $vehicles = $this->vehicle->get_all($conditions,0,$offset,$config['per_page']);
			$vehicle_list = $this->vehicle->listing(array('type'=>'AR'));
		    $vehicle_list['all'] = 'All';
		    ksort($vehicle_list);
      	    $this->template->title($this->lang->line('vehicles-report'));
		    $this->template->main_heading($this->lang->line('vehicles-report'));
            $this->template->breadcrumb(array($this->lang->line('ar')=>'no_link',$this->lang->line('report')=>'no_link',$this->lang->line('new')=>'retailers/add_vehicles',$this->lang->line('search')=>'no_link'));
            $this->template->slice('dms/message');
            $this->template->slice('preferences/retailers/vehicles/report',array('vehicles'=>$vehicles,'links'=>$links,'count'=>$offset+1,'vehicle'=>$vehicle,'vehicle_list'=>$vehicle_list));
	        $this->template->render();

        }

		#-------------------------------------------------------
		#date:07-08-2014
		#purpose:update
		public function vehicle_edit($id){

			if(empty($id) && !$this->input->post()){
				redirect('retailers/vehicle_report');
			}
			$id=$this->uri->segment(3);
			if($this->if_exists('vehicle_master',array('id'=>$id,'status'=>1)) === false){
				redirect('retailers/vehicle_report');
			}			
			$vehicle = $this->db->get_where('vehicle_master',array('id'=>$id,'status'=>1))->row_array();
       	    $this->load->model('vehicle_types/Vehicle_type_model','type');
			$types = $this->type->listing();
            #validation

            if($this->form_validation->run('vehicles/update') === true){

				$data = $this->input->post(NULL,TRUE);
				$data['insurance_valid_from'] = date('Y-m-d',strtotime($this->input->post('insurance_valid_from',true)));
				$data['insurance_valid_to'] = date('Y-m-d',strtotime($this->input->post('insurance_valid_to',true)));
				$data['created_by'] = $this->session->userdata('id');
				$data['company_id'] = $this->session->userdata('company_id');
				$data['type']='AR';
                  
				if($this->db->update('vehicle_master',$data,array('id'=>$id))){
                  $this->message->set($this->lang->line('vehicel-updated'),'s');   
				}else{
					$thus->message->set($this->lang->line('vehicel-not-updated'),'e');
				}
				redirect('retailers/vehicle_report');
			}

            $this->template->title('Edit Vehicle Details');
		    $this->template->main_heading($this->lang->line('edit-vehicle'));
            $this->template->breadcrumb(array($this->lang->line('ar')=>'no_link',$this->lang->line('report')=>'retailers/vehicle_report',$this->lang->line('new')=>'retailers/add_vehicles',$this->lang->line('update')=>'no_link',$this->lang->line('search')=>'no_link'));
		    $this->template->slice('preferences/retailers/vehicles/edit/update',array('vehicle'=>$vehicle,'types'=>$types));
		    $this->template->render(); 
            
			}

			#------------------------------------------------------
			#date:07-08-2014
			#paurpose:delete
			public function vehicle_delete($id){
				if(empty($id)){
					redirect('users/home');
				}
				$id = $this->uri->segment(3);
				if($this->if_exists('vehicle_master',array('id'=>$id,'status'=>1)) === false){
					redirect('retailers/vehicle_report');
				}				
				if($this->db->update('vehicle_master',array('status'=>0),array('id'=>$id))){
					$this->message->set($this->lang->line('vehicel-deleted'),'s');
				}
				else{
					$this->message->set($this->lang->line('vehicel-not-deleted'),'e');
				}
			 redirect('retailers/vehicle_report');
			}

 	#------------------------------------------------------
		public function check_user_name($username){
		 	$retailer_id =$this->uri->segment(3);
		 	$row = $this->db->select(array('id','branch_id'))->get_where('users',array('username'=>$username))->result_array();
		 	$count = count($row);

		 	if($count == 0){
		 		return true;
		 	}
		 	elseif($count == 1){
		 		//echo 'hai'; die;
			 	if($row[0]['branch_id'] == $retailer_id){
			 		return true;
			 	}
			 	else{
			 		return false;
			 	}
		 	}else{
		 		return false;
		 	}
		}
	#-------------------------------------------------------
	}
?>