<?php  if( ! defined('BASEPATH')) exit ('No direct script access allowed');

Class Salary extends MY_Controller {

	public function __construct(){

		parent::__construct();
		$fiscals = $this->dms->get_fiscal_year();
		$this->fiscal_start_date = $fiscals['start_date'];
		$this->fiscal_end_date = $fiscals['end_date'];	
		$this->load->model('vouchers/Voucher_model','voucher');	

	}

	public function driver_salary(){

		$this->template->title($this->lang->line('salary'));
		$this->template->main_heading($this->lang->line('driver-salary'));
		$this->template->breadcrumb(array($this->lang->line('salary') => 'no_link',$this->lang->line('driver-salary') =>'no_link',$this->lang->line('driver-salary-report') => 'salary/driver_salary_report'));

		$this->load->library(array('Stock','Transport_lib'));
		$this->load->model('salary/Salary_settings_model','salary_settings');
		$this->load->model('salary/Salary_model','salary');
		$this->load->model('sales/Sales_model','sales_obj');
		$drivers = $salary_percentages = $driver_sales = $driver_bills_details = array();
		$driver_id = $from_date = $to_date = $bank = '';
		$drivers = $this->transport_lib->drivers();
		$bank_accounts = $this->stock->payment_modes(array('sub_groups'=>array(14)));
		$drivers[''] = 'Select';
		ksort($drivers);
		$paid_date = date('Y-m-d');

		$salary_percentages = $this->salary_settings->list_salary_percentage();
		$salary_percentages[''] = 'Select';
		ksort($salary_percentages);

		$bank_accounts[''] = 'Select';
		ksort($bank_accounts);		

		if(isset($_POST['get_details'])) {

			$this->form_validation->set_rules('driver_id','lang:driver','xss_clean|required');
			$this->form_validation->set_rules('from_date','lang:from','xss_clean|required|valid_date|is_date|check_date['.date('Y-m-d').'.<=]');
			$this->form_validation->set_rules('to_date','lang:to','xss_clean|required|valid_date|is_date|check_date['.date('Y-m-d').'.<=]');

			if($this->form_validation->run() === true){
				
				$driver_id = $this->input->post('driver_id');
				$from_date = date('Y-m-d',strtotime($this->input->post('from_date')));
				$to_date = date('Y-m-d',strtotime($this->input->post('to_date')));

			}
		}

		if(isset($_POST['save_bill'])) {
			$driver_id = $this->input->post('driver_id');
			$from_date = date('Y-m-d',strtotime($this->input->post('from_date')));
			$to_date = date('Y-m-d',strtotime($this->input->post('to_date')));		
		}


		if(!empty($driver_id) && !empty($from_date) && !empty($to_date)){

            $args = array();
            $args['select'] = array('id');
        	$args['from'] = 'dms_driver_salary';
            $args['conditions'] = array('driver_id'=>$driver_id,'from_date >='=>$from_date,'from_date <='=>$to_date);
            $driver_salary_check1 = $this->salary->get($args);

            $args = array();
            $args['select'] = array('id');
        	$args['from'] = 'dms_driver_salary';
            $args['conditions'] = array('driver_id'=>$driver_id,"to_date >='".$from_date."' and to_date <= '".$to_date."'");
            $driver_salary_check2 = $this->salary->get($args);

            $args = array();
            $args['select'] = array('id');
        	$args['from'] = 'dms_driver_salary';
            $args['conditions'] = array('driver_id'=>$driver_id,"from_date <='".$from_date."' and to_date >='".$to_date."'");
            $driver_salary_check3 = $this->salary->get($args);

			if(empty($driver_salary_check1) && empty($driver_salary_check2) && empty($driver_salary_check3)){

				$driver_bills = $this->salary->get_driver_bills($driver_id,$from_date,$to_date);
				$sales_bills = $driver_bills['sales'];
				$delivery_notes = $driver_bills['delivery_notes'];
				$purchases = $driver_bills['purchases'];
				$receipt_notes = $driver_bills['receipt_notes'];

				foreach($sales_bills as $sales_key => $sale) {
					$cust_type = $this->dms->desig_name($sale['customer_type_id']);
					$cust_name = $this->stock->get_customer($sale['customer_type_id'],$sale['customer_id']);
					$sale['party_name'] = $cust_type.' '.$cust_name;
					$sale['bill_type'] = 0;
					$driver_bills_details[$sale['bill_date']][] = $sale;
				}

				foreach($delivery_notes as $dnote_key => $dnote) {
					$cust_type = $this->dms->desig_name($dnote['customer_type_id']);
					$cust_name = $this->stock->get_customer($dnote['customer_type_id'],$dnote['customer_id']);
					$dnote['party_name'] = $cust_type.' '.$cust_name;
					$dnote['bill_type'] = 0;
					$driver_bills_details[$dnote['bill_date']][] = $dnote;
				}

				foreach($purchases as $purchase_key => $purchase) {
					$purchase['party_name'] = $this->stock->vendor_name($purchase['vendor_id']);
					$purchase['bill_type'] = 1;
					$driver_bills_details[$purchase['bill_date']][] = $purchase;
				}

				foreach($receipt_notes as $rnote_key => $rnote) {
					$rnote['party_name'] = $this->stock->vendor_name($rnote['vendor_id']);
					$rnote['bill_type'] = 1;
					$driver_bills_details[$rnote['bill_date']][] = $rnote;
				}
			}else{
				$this->message->set($this->lang->line('salary-already-processed'),'e');
			}
		}

		if(isset($_POST['save_bill'])) {

			$this->load->model('vouchers/Voucher_model','voucher');

			$this->form_validation->set_rules('paid_date','lang:payment-date','xss_clean|required|valid_date|is_date|check_date['.date('Y-m-d').'.<=]');
			$this->form_validation->set_rules('receipt_mode','lang:payment-mode','xss_clean|required');
			$this->form_validation->set_rules('remarks','lang:remarks','xss_clean');

			if($this->input->post('receipt_mode') && $this->input->post('receipt_mode') == 1){
				$this->form_validation->set_rules('payment_mode','lang:payment-mode','xss_clean|required');
				$this->form_validation->set_rules('ccd','lang:transaction-type','xss_clean|required');
				$this->form_validation->set_rules('cheque_no','lang:cd-no','xss_clean|required');
				$this->form_validation->set_rules('cheque_date','lang:cheque-date','xss_clean|required|is_date');
			}

			if($this->form_validation->run() === true){

				$additional_salary = 0;

				$paid_date = date('Y-m-d',strtotime($this->input->post('paid_date')));

				$receipt_mode = $this->input->post('receipt_mode');
				$remarks = $this->input->post('remarks');


				if($receipt_mode != 0){
					$payment_mode = $this->input->post('payment_mode');
					$ccd = $this->input->post('ccd');
					$cheque_no = $this->input->post('cheque_no');
					$cheque_date = date('Y-m-d',strtotime($this->input->post('cheque_date')));
				}else{
					$ccd = 0;
					$payment_mode = 0;
					$cheque_no = '';
					$cheque_date = '0000-00-00';					
				}

				$drLedgerID = 1;# ledger id of CASH
				if($receipt_mode > 0){
					$drLedgerID = $payment_mode;# ledger id of bank accounts
				}

                $args = array();
                $args['select'] = array('id');
            	$args['from'] = 'dms_driver_salary';
                $args['conditions'] = array('driver_id'=>$driver_id,'from_date'=>$from_date,'to_date'=>$to_date);
                $driver_salary = $this->salary->get($args);
				$driver_salary_id = 0;
                if(empty($driver_salary)) {
                	$driver_salary_data = array('driver_id'=>$driver_id,'from_date'=>$from_date,'to_date'=>$to_date,'paid_date'=>$paid_date,'additional_salary'=>$additional_salary,'cash_bank'=>$receipt_mode,'payment_mode'=>$payment_mode,'transaction_type'=>$ccd,'transaction_no'=>$cheque_no,'transaction_date'=>$cheque_date,'remarks'=>$remarks);
                	if($this->salary->save('dms_driver_salary',$driver_salary_data)){
                		$driver_salary_id = $this->db->insert_id();
                	}
                }else{

                	$driver_salary_id = $driver_salary[0]['id'];
                }
				

				if(!empty($driver_salary_id)){
					$this->db->trans_start();
					$total_salary_amount = 0;
					foreach($driver_bills_details as $key => $driver_bills){
						foreach($driver_bills as $day_key => $value){

                            $vehicle_rent = $value['vehicle_rent'];
                            $sales_id = $value['id'];
                            #$salary_percent_id = $value['salary_percent_id'];
                            $bill_group_id = $value['group_id'];
                            $voucher_type_id = $value['vtype_id'];
                            $bill_type = $value['bill_type'];
                            $percent = "salary_percent_".$sales_id;
                            $percentage_id = $this->input->post("$percent");
							$salary_percent_dtls = $this->salary_settings->get_salary_percentage(array('conditions'=>array('id'=>$percentage_id)));
							if(!empty($salary_percent_dtls)){
								$post_percentage = $salary_percent_dtls[0]['percentage'];
							}
                            $salary_amount = get_rounded(($vehicle_rent*$post_percentage)/100);
                            $total_salary_amount += $salary_amount;
                            $args = array();
                            $args['select'] = array('id');
                        	$args['from'] = 'dms_driver_salary_bills';
                            $args['conditions'] = array('driver_salary_id'=>$driver_salary_id,'bill_type'=>$bill_type,'group_id'=>$bill_group_id);
                            $driver_salary_bill = $this->salary->get($args);

                            if(empty($driver_salary_bill)){
                            	$this->salary->save('dms_driver_salary_bills',array('driver_salary_id'=>$driver_salary_id,'vtype_id'=>$voucher_type_id,'bill_type'=>$bill_type,'group_id'=>$bill_group_id,'percentage_id'=>$percentage_id,'amount'=>$salary_amount));
                            }else{
                            	$this->salary->update('dms_driver_salary_bills',array('percentage_id'=>$percentage_id,'amount'=>$salary_amount),array('id'=>$driver_salary_bill[0]['id']));
                            }
						}
					}

					$this->salary->update('dms_driver_salary',array('amount'=>$total_salary_amount),array('id'=>$driver_salary_id));

					$voucherNo = $this->voucher->get_voucher_number(1);
					$voucher_group_id = $this->stock->get_group_id('dms_vouchers');
					$voucherStatus = 1;


					if(strtotime($cheque_date) > strtotime($paid_date) && $receipt_mode >0){
						$voucherStatus = 3;
					}
					if($receipt_mode > 0){
						if($this->voucher->insert('dms_voucher_banks',array('group_id'=>$voucher_group_id,'cash_type'=>$ccd,'cd_no'=>$cheque_no,'pdc'=>$cheque_date,'vdate'=>$paid_date,'cq_status'=>0))){
						}
					}	
					$this->voucher->insert("dms_vouchers",array('group_id'=>$voucher_group_id,'vtype_id'=>1,'vno'=>$voucherNo,'vorder_no'=>1,'vdate'=>$paid_date,'cr_ledger'=>$drLedgerID,'dr_ledger'=>18,'vamount'=>$total_salary_amount,'table_name'=>'dms_driver_salary','table_group_id'=>$driver_salary_id,'status'=>$voucherStatus));				
					$this->db->trans_complete();

				}

				redirect('salary/driver_salary_report');
			}
		}




		# view starts here--------------------------------
		$this->template->slice('dms/message');
		$this->template->slice('salary/driver_salary',array('drivers'=>$drivers,'driver_bills'=>$driver_bills_details,'salary_percentages'=>$salary_percentages,'sel_driver_id'=>$driver_id,'sel_from_date'=>$from_date,'sel_to_date'=>$to_date,'bank_accounts'=>$bank_accounts,'bank'=>$bank,'paid_date'=>$paid_date));
		$this->template->other_script(array('salary/salary'));
		$this->template->render();
		#-------------------------------------------------------------

	}


	#_________________________________________________________________________________________________

	public function driver_salary_report(){

		$this->template->title($this->lang->line('salary'));
		$this->template->main_heading($this->lang->line('driver-salary-report'));
		$this->template->breadcrumb(array($this->lang->line('salary')=>'no_link',$this->lang->line('driver-salary') =>'salary/driver_salary',$this->lang->line('driver-salary-report') => 'no_link'));

		$this->load->library(array('Stock','Transport_lib'));
		$this->load->model('salary/Salary_settings_model','salary_settings');
		$this->load->model('salary/Salary_model','salary');

		$drivers = array();
		$sel_driver_id = '';
		$drivers = $this->transport_lib->drivers();
		$drivers[''] = 'All Drivers';
		ksort($drivers);		

		$this->form_validation->set_rules('driver_id','lang:driver','xss_clean');

		if($this->form_validation->run() === true){
			
			$sel_driver_id = $this->input->post('driver_id');

		}


		$args = array();
		$args['select'] = array('dds.id','dds.from_date','dds.to_date','dds.paid_date','dds.amount','dds.cash_bank',"concat(u.fname,' ',u.lname) as name",'u.mobile',"CASE WHEN dds.payment_mode=0 THEN 'cash' ELSE dl.ledger_name END as ledger_name");
		$args['join'] = array('users as u'=>'dds.driver_id=u.id','dms_ledgers as dl'=>'dds.payment_mode=dl.id');
		$args['between'] = array('column'=>'dds.from_date','from_date'=> $this->fiscal_start_date ,'to_date'=>$this->fiscal_end_date);
		if(!empty($sel_driver_id)){
			$args['conditions'] = array('dds.driver_id'=>$sel_driver_id);
		}		
		$args['order_by'] = "dds.from_date";

		$args['order'] = 'desc';
		$driver_salaries = $this->salary->get_driver_salary($args);


		# view starts here--------------------------------
		$this->template->slice('dms/message');
		$this->template->slice('salary/driver_salary_report',array('drivers'=>$drivers,'sel_driver_id'=>$sel_driver_id,'driver_salaries'=>$driver_salaries));
		$this->template->other_script(array('salary/salary'));
		$this->template->render();
		#-------------------------------------------------------------

	}

	#___________________________________________________________________________________

	public function view_driver_salary(){

		$this->template->title($this->lang->line('salary'));
		$this->template->main_heading($this->lang->line('edit-driver-salary'));
		$this->template->breadcrumb(array($this->lang->line('salary')=>'no_link',$this->lang->line('driver-salary') =>'salary/driver_salary',$this->lang->line('driver-salary-report') => 'salary/driver_salary_report',$this->lang->line('edit-driver-salary')=>'no_link'));

		$this->load->library(array('Stock','Transport_lib'));
		$this->load->model('salary/Salary_settings_model','salary_settings');
		$this->load->model('salary/Salary_model','salary');
		$this->load->model('sales/Sales_model','sales_obj');


		$bank_accounts = array();
		$bank = '';
		$bank_accounts = $this->stock->payment_modes(array('sub_groups'=>array(14)));
		$bank_accounts[''] = 'Select';
		ksort($bank_accounts);

		$salary_percentages = $this->salary_settings->list_salary_percentage();
		$salary_percentages[''] = 'Select';
		ksort($salary_percentages);

		if(!$this->uri->segment(3)){

		}
		$salary_id = $this->uri->segment(3);

		$args = array();
		$args['select'] = array('dds.id','dds.from_date','dds.to_date','dds.paid_date','dds.amount','dds.cash_bank',"concat(u.fname,' ',u.lname) as name",'dds.payment_mode','dds.transaction_type','dds.transaction_no','dds.transaction_date','dds.remarks');
		$args['join'] = array('users as u'=>'dds.driver_id=u.id','dms_ledgers as dl'=>'dds.payment_mode=dl.id');
		$args['between'] = array('column'=>'dds.from_date','from_date'=> $this->fiscal_start_date ,'to_date'=>$this->fiscal_end_date);
		$args['conditions'] = array('dds.id'=>$salary_id);
		$driver_salaries = $this->salary->get_driver_salary($args);


		$args = array();
		$args['select'] = array('ddsb.id','ddsb.vtype_id','ddsb.bill_type','ddsb.group_id','ddsb.percentage_id','ddsb.amount','dvt.vtype as voucher_type','case when ds.id IS  NOT NULL then ds.bill_no WHEN ddn.id IS NOT NULL then ddn.bill_no WHEN drn.id IS NOT NULL then drn.bill_no WHEN dp.id IS NOT NULL then dp.bill_no   end as bill_no','case when ds.id IS  NOT NULL then ds.bill_date WHEN ddn.id IS NOT NULL then ddn.bill_date WHEN drn.id IS NOT NULL then drn.bill_date WHEN dp.id IS NOT NULL then dp.bill_date   end as bill_date','case when srm.route_name is NOT NULL then srm.route_name else prm.route_name end as route','case when dsv.vehicle_rent is not null then dsv.vehicle_rent else dpv.vehicle_rent end as vehicle_rent');
		$args['from'] = "dms_driver_salary_bills as ddsb";
		$args['conditions'] = array('ddsb.driver_salary_id'=>$salary_id);
		$args['join'] = array('dms_voucher_types as dvt'=>'ddsb.vtype_id=dvt.id','dms_delivery_notes as ddn'=>'ddn.group_id=ddsb.group_id and ddn.vtype_id=ddsb.vtype_id','dms_sales as ds'=>'ds.group_id=ddsb.group_id and ds.vtype_id=ddsb.vtype_id','dms_receipt_notes as drn'=>'drn.group_id=ddsb.group_id and drn.vtype_id=ddsb.vtype_id','dms_purchases as dp'=>'dp.group_id=ddsb.group_id and dp.vtype_id=ddsb.vtype_id','dms_sales_vehicles as dsv'=>'case when ds.group_id IS NOT NULL THEN ds.group_id=dsv.group_id ELSE ddn.group_id=dsv.group_id end','route_master as srm'=>'dsv.route_id=srm.id','dms_purchase_vehicles as dpv'=>'case when dp.group_id IS NOT NULL then dp.group_id=dpv.group_id else drn.group_id=dpv.group_id end','route_master as prm'=>'dpv.route_id=prm.id');
		$driver_salary_bills = $this->salary->get($args);	

		
		# view starts here--------------------------------
		$this->template->slice('dms/message');
		$this->template->slice('salary/view_driver_salary',array('driver_salaries'=>$driver_salaries,'bank_accounts'=>$bank_accounts,'bank'=>$bank,'driver_salary_bills'=>$driver_salary_bills,'salary_percentages'=>$salary_percentages));
		$this->template->other_script(array('salary/salary'));
		$this->template->render();
		#-------------------------------------------------------------	
	}

	#____________________________________________________________________________________

	public function edit_driver_salary(){

		$this->template->title($this->lang->line('salary'));
		$this->template->main_heading($this->lang->line('edit-driver-salary'));
		$this->template->breadcrumb(array($this->lang->line('salary')=>'no_link',$this->lang->line('driver-salary') =>'salary/driver_salary',$this->lang->line('driver-salary-report') => 'salary/driver_salary_report',$this->lang->line('edit-driver-salary')=>'no_link'));

		$this->load->library(array('Stock','Transport_lib'));
		$this->load->model('salary/Salary_settings_model','salary_settings');
		$this->load->model('salary/Salary_model','salary');
		$this->load->model('sales/Sales_model','sales_obj');

		$bank_accounts = array();
		$bank = '';
		$bank_accounts = $this->stock->payment_modes(array('sub_groups'=>array(14)));
		$bank_accounts[''] = 'Select';
		ksort($bank_accounts);

		$salary_percentages = $this->salary_settings->list_salary_percentage();
		$salary_percentages[''] = 'Select';
		ksort($salary_percentages);

		if(!$this->uri->segment(3)){

		}
		$salary_id = $this->uri->segment(3);

		$args = array();
		$args['select'] = array('dds.id','dds.from_date','dds.to_date','dds.paid_date','dds.amount','dds.cash_bank',"concat(u.fname,' ',u.lname) as name",'dds.payment_mode','dds.transaction_type','dds.transaction_no','dds.transaction_date','dds.remarks');
		$args['join'] = array('users as u'=>'dds.driver_id=u.id','dms_ledgers as dl'=>'dds.payment_mode=dl.id');
		$args['between'] = array('column'=>'dds.from_date','from_date'=> $this->fiscal_start_date ,'to_date'=>$this->fiscal_end_date);
		$args['conditions'] = array('dds.id'=>$salary_id);
		$driver_salaries = $this->salary->get_driver_salary($args);


		$args = array();
		$args['select'] = array('ddsb.id','ddsb.vtype_id','ddsb.bill_type','ddsb.group_id','ddsb.percentage_id','ddsb.amount','dvt.vtype as voucher_type','case when ds.id IS  NOT NULL then ds.bill_no WHEN ddn.id IS NOT NULL then ddn.bill_no WHEN drn.id IS NOT NULL then drn.bill_no WHEN dp.id IS NOT NULL then dp.bill_no   end as bill_no','case when ds.id IS  NOT NULL then ds.bill_date WHEN ddn.id IS NOT NULL then ddn.bill_date WHEN drn.id IS NOT NULL then drn.bill_date WHEN dp.id IS NOT NULL then dp.bill_date   end as bill_date','case when srm.route_name is NOT NULL then srm.route_name else prm.route_name end as route','case when dsv.vehicle_rent is not null then dsv.vehicle_rent else dpv.vehicle_rent end as vehicle_rent');
		$args['from'] = "dms_driver_salary_bills as ddsb";
		$args['conditions'] = array('ddsb.driver_salary_id'=>$salary_id);
		$args['join'] = array('dms_voucher_types as dvt'=>'ddsb.vtype_id=dvt.id','dms_delivery_notes as ddn'=>'ddn.group_id=ddsb.group_id and ddn.vtype_id=ddsb.vtype_id','dms_sales as ds'=>'ds.group_id=ddsb.group_id and ds.vtype_id=ddsb.vtype_id','dms_receipt_notes as drn'=>'drn.group_id=ddsb.group_id and drn.vtype_id=ddsb.vtype_id','dms_purchases as dp'=>'dp.group_id=ddsb.group_id and dp.vtype_id=ddsb.vtype_id','dms_sales_vehicles as dsv'=>'case when ds.group_id IS NOT NULL THEN ds.group_id=dsv.group_id ELSE ddn.group_id=dsv.group_id end','route_master as srm'=>'dsv.route_id=srm.id','dms_purchase_vehicles as dpv'=>'case when dp.group_id IS NOT NULL then dp.group_id=dpv.group_id else drn.group_id=dpv.group_id end','route_master as prm'=>'dpv.route_id=prm.id');
		$driver_salary_bills = $this->salary->get($args);	

		$this->form_validation->set_rules('bills','lang:bill','required');
		$this->form_validation->set_rules('payment_mode','lang:payment-mode','xss_clean');
		$this->form_validation->set_rules('ccd','lang:transaction-type','xss_clean');
		$this->form_validation->set_rules('cheque_no','lang:cd-no','xss_clean');
		$this->form_validation->set_rules('cheque_date','lang:cheque-date','xss_clean|is_date');
		if($this->form_validation->run() === true){


			$bills = $this->input->post('bills');
			$all_bills = $this->input->post('sm');
			$salary_percentages = $this->input->post('salary_percent');
			$vehicles_rents = $this->input->post('vrent');

			$paid_date = date('Y-m-d',strtotime($this->input->post('paid_date')));
			$receipt_mode = $this->input->post('receipt_mode');
			$remarks = $this->input->post('remarks');

			if($receipt_mode != 0){
				$payment_mode = $this->input->post('payment_mode');
				$ccd = $this->input->post('ccd');
				$cheque_no = $this->input->post('cheque_no');
				$cheque_date = date('Y-m-d',strtotime($this->input->post('cheque_date')));
			}else{
				$ccd = 0;
				$payment_mode = 0;
				$cheque_no = '';
				$cheque_date = '0000-00-00';					
			}
			$drLedgerID = 1;# ledger id of CASH
			if($receipt_mode > 0){
				$drLedgerID = $payment_mode;# ledger id of bank accounts
			}

			$total_salary_amount = 0;

			$this->db->trans_start();$c=0;
			foreach($all_bills as $key=>$dr_bill_id){

				if(in_array($dr_bill_id,$bills)){

					$percentage_id = $salary_percentages[$dr_bill_id];
					$vehicle_rent = $vehicles_rents[$dr_bill_id];
					$salary_percent_dtls = $this->salary_settings->get_salary_percentage(array('conditions'=>array('id'=>$percentage_id)));
	                if(!empty($salary_percent_dtls)){
    	                $percentage = $salary_percent_dtls[0]['percentage'];
        			}
                	$salary_amount = get_rounded(($vehicle_rent*$percentage)/100);
                    $total_salary_amount += $salary_amount;				
                    $this->salary->update('dms_driver_salary_bills',array('percentage_id'=>$percentage_id,'amount'=>$salary_amount),array('id'=>$dr_bill_id));
                }else{
                	$this->salary->update('dms_driver_salary_bills',array('amount'=>0),array('id'=>$dr_bill_id));
                }
			}


			$this->salary->update('dms_driver_salary',array('amount'=>$total_salary_amount,'paid_date'=>$paid_date,'cash_bank'=>$receipt_mode,'payment_mode'=>$payment_mode,'transaction_type'=>$ccd,'transaction_no'=>$cheque_no,'transaction_date'=>$cheque_date,'remarks'=>$remarks),array('id'=>$salary_id));
			$voucherStatus = 1;
			if(strtotime($cheque_date) > strtotime($paid_date) && $receipt_mode >0){
				$voucherStatus = 3;
			}

			$args = array();
			$args['select'] = array('group_id','vdate','cr_ledger','status');
			$args['from'] = 'dms_vouchers';
			$args['conditions'] = array('table_name'=>'dms_driver_salary','table_group_id'=>$salary_id);
			$driver_salary_voucher = $this->salary->get($args);

			$old_voucher_status = $driver_salary_voucher[0]['status'];
			$old_voucher_group_id = $driver_salary_voucher[0]['group_id'];
			$old_voucher_date = $driver_salary_voucher[0]['vdate'];

			$args = array();
			$args['select'] = array('id','cash_type','cd_no','pdc','cq_status');
			$args['from'] = 'dms_voucher_banks';
			$args['conditions'] = array('group_id'=>$old_voucher_group_id);
			$driver_salary_voucher_banks = $this->salary->get($args);

			if(empty($driver_salary_voucher_banks) && $receipt_mode > 0){
				$this->voucher->insert('dms_voucher_banks',array('group_id'=>$old_voucher_group_id,'cash_type'=>$ccd,'cd_no'=>$cheque_no,'pdc'=>$cheque_date,'vdate'=>$paid_date,'cq_status'=>0));
			}else{
				$update_array = array('cash_type'=>$ccd,'cd_no'=>$cheque_no,'pdc'=>$cheque_date,'vdate'=>$paid_date);
				if($receipt_mode == 0){
					$update_array['status'] = 0;
				}else{
					$update_array['status'] = 1;
				}
				$voucher_bank_id = $driver_salary_voucher_banks[0]['id'];
				$this->salary->update('dms_voucher_banks',$update_array,array('id'=>$voucher_bank_id));
			}
			$this->salary->update('dms_vouchers',array('vamount'=>$total_salary_amount),array('table_name'=>'dms_driver_salary','table_group_id'=>$salary_id));
			$this->db->trans_complete();			
			redirect('salary/driver_salary_report');
		}
		
		# view starts here--------------------------------
		$this->template->slice('dms/message');
		$this->template->slice('salary/edit_driver_salary',array('driver_salaries'=>$driver_salaries,'bank_accounts'=>$bank_accounts,'bank'=>$bank,'driver_salary_bills'=>$driver_salary_bills,'salary_percentages'=>$salary_percentages));
		$this->template->other_script(array('salary/salary'));
		$this->template->render();
		#-------------------------------------------------------------

	}

	#___________________________________________________________________________________

	public function delete_driver_salary(){

		if(!$this->uri->segment(3)){

		}
		$salary_id = $this->uri->segment(3);		
		redirect('salary/driver_salary_report');
	}
	#___________________________________________________________________________________

	public function driver_salary_pdf(){


		$pdf_name = 'sales';
		$pdf_contents = '';
	
		if(!$this->uri->segment(3)){
			echo "<script>alert('".$this->lang->line('invalid-sales-bill')."');window.close();</script>";
		}
		$salary_id = $this->uri->segment(3);
		if($this->if_exists('dms_driver_salary',array('id'=>$salary_id,'status'=>1)) === false){
			echo "<script>alert('".$this->lang->line('invalid-sales-bill')."');window.close();</script>";
		}

		$this->load->library('My_pdf');
		$this->load->library('To_words');
		$this->load->library('My_pdf');
		$this->load->library('To_words');

		$this->load->library(array('Stock','Transport_lib'));
		$this->load->model('salary/Salary_settings_model','salary_settings');
		$this->load->model('salary/Salary_model','salary');

		$args = array();
		$args['select'] = array('dds.id','dds.from_date','dds.to_date','dds.paid_date','dds.amount','dds.cash_bank',"concat(u.fname,' ',u.lname) as name",'u.mobile','u.address','u.email','dds.payment_mode','dds.transaction_type','dds.transaction_no','dds.transaction_date','dds.remarks');
		$args['join'] = array('users as u'=>'dds.driver_id=u.id','dms_ledgers as dl'=>'dds.payment_mode=dl.id');
		$args['between'] = array('column'=>'dds.from_date','from_date'=> $this->fiscal_start_date ,'to_date'=>$this->fiscal_end_date);
		$args['conditions'] = array('dds.id'=>$salary_id);
		$driver_salaries = $this->salary->get_driver_salary($args);
		
		if(!empty($driver_salaries)){
			$driver_salary = $driver_salaries[0];

			$args = array();
			$args['select'] = array('vno','group_id','vdate','cr_ledger','vamount');
			$args['from'] = 'dms_vouchers';
			$args['conditions'] = array('table_name'=>'dms_driver_salary','table_group_id'=>$salary_id);
			$driver_salary_voucher = $this->salary->get($args);		

			$voucher_no = $driver_salary_voucher[0]['vno'];
			$voucher_date = $driver_salary_voucher[0]['vdate'];
			$name = $driver_salary['name'];
			$address1 = $driver_salary['address'];
			$address2 = $driver_salary['mobile'].' '.$driver_salary['email'];

			$particulars = 'Staff salary';
			$amount = $driver_salary_voucher[0]['vamount'];
			$remarks = $driver_salary['remarks'];

		}



		$this->my_pdf->set_header();
		$pdf_contents = $this->load->view('salary/driver_salary_pdf',array('voucher_no'=>$voucher_no,'voucher_date'=>$voucher_date,'name'=>$name,'address1'=>$address1,'address2'=>$address2,'particulars'=>$particulars,'amount'=>$amount,'remarks'=>$remarks),true);

		$this->my_pdf->output($pdf_name,$pdf_contents);


	}
	
}