<?php if( ! defined('BASEPATH')) exit ('No direct script access allowed');

class Sales1 extends MY_Controller{

	public function __construct()
	{
		parent::__construct();

		$this->check_access_right();
		$this->companyID = $this->session->userdata('company_id');
        $this->branch_id = $this->session->userdata('under_id');
		#---------------- Checking Financial year is enabled / closed-----------------#
		$method_array = array('add','delete_temp','update_temp','update','delete','barcode');
		fiscal_status($this->uri->segment(2),$method_array,"booking/report");
		#---------------- Checking Financial year is enabled / closed-----------------#

		$this->load->model('booking/Booking_model','book_obj');
		$this->load->model('sales/Sales_model','sales_obj');
		$this->load->model('vouchers/Voucher_model','vouchers');
        $this->load->model('users/User_point_model','user_point');
		$this->load->library(array('Stock','Targets'));
        $this->load->model('products/Item_model','item');

		#-----------checking branch_type
		$this->branch_status = 0;
		if($this->dms->branch_type())
		{
			$this->branch_status = 1;
		}

		#----------voucher type
		$this->vtype = 15;
		$this->vtype1 = 6;
	}
	
	public function book_report()
	{
		#----------loading models
		$this->load->model('designations/Designation_master_model','desig');
        $this->load->model('products/Item_model','item');

		#----------voucher type
		$vtype_id = $this->vtype;
		$conditions = array('vtype_id' => $vtype_id,'status' => 1);
		$like_array = array();$vnos="";

		#----------voucher name
		$voucher_name = $this->vouchers->voucher_name($this->vtype);

		#----------voucher type array
		$voucher_types = $this->vouchers->voucher_types($this->vtype);

		#----------uri array
		$uri_array  = $this->uri->uri_to_assoc(3);

		#----------redirect
		$redirect = "";

		#----------pagination
		$this->load->library('Pagination');
		$config['per_page'] = $this->per_page();
		# Pagination Config Customizations
        $config['full_tag_open'] = '<ul class="pagination">';
        $config['full_tag_close'] = '</ul>';
        $config['first_link'] = 'First';
        $config['last_link'] = 'Last';
        $config['next_link'] = '&raquo;';
        $config['prev_link'] = '&laquo;';
        $config['cur_tag_open'] = '<li class="active"><a href="#">';
        $config['cur_tag_close'] = '</a></li>';
        $config['num_tag_open'] = '<li>';
        $config['num_tag_close'] = '</li>';
		//$config['base_url'] = base_url('booking/report');
		$config['base_url'] = base_url('sales1/book_report');
		$config['uri_segment'] = 3;

		#----------dates within financial year
		$cur_date = date('Y-m-d');
		$from_date = $cur_date;
		$to_date = $cur_date;
		$cur_fiscal_yr = $this->dms->get_fiscal_year();
		if($from_date < $cur_fiscal_yr['start_date'] || $from_date > $cur_fiscal_yr['end_date'] || $to_date < $cur_fiscal_yr['start_date'] || $to_date > $cur_fiscal_yr['end_date'])
		{
			$from_date = $cur_fiscal_yr['end_date'];
			$to_date = $cur_fiscal_yr['end_date'];
		}

		#----------validation
		$this->form_validation->set_rules('vtype_id','voucher-types','required|xss_clean');
		$this->form_validation->set_rules('from_date','From Date','required|xss_clean|valid_date');
		$this->form_validation->set_rules('to_date','To Date','required|xss_clean|valid_date');
		$this->form_validation->set_rules('bill_no','bill-no','xss_clean|trim');
		if($this->form_validation->run() === true)
		{
			$vtype_id = $this->input->post('vtype_id',true);
			$from_date = date('Y-m-d',strtotime($this->input->post('from_date',true)));
			$to_date = date('Y-m-d',strtotime($this->input->post('to_date',true)));
			$conditions['vtype_id'] = $vtype_id;
			$config['base_url'] .= '/vt/'.$vtype_id.'/fdate/'.$from_date.'/tdate/'.$to_date;
			$config['uri_segment'] += 6;
			$redirect .= '/vt/'.$vtype_id.'/fdate/'.$from_date.'/tdate/'.$to_date;
			if(!empty($this->input->post('bill_no',true)))
			{
				$vnos = $this->input->post('bill_no',true);
				$like_array['bill_no'] = $vnos;
				$config['base_url'] .= '/vn/'.$vnos;
				$config['uri_segment'] += 2;
				$redirect .= '/vn/'.$vnos;
			}
            if(!empty($this->input->post('customer_id',true)))
			{
                $cust_ids = $this->input->post('customer_id',true);                                                                                   
                $conditions['customer_id'] = $cust_ids;                        
            }
		}
		elseif(isset($uri_array['vt']))
		{
			$vtype_id = $uri_array['vt'];
			$conditions['vtype_id'] = $vtype_id;
			$config['base_url'] .= '/vt/'.$conditions['vtype_id'];
			$config['uri_segment'] += 2;
			$redirect .= '/vt/'.$vtype_id;
			if(isset($uri_array['fdate']) && isset($uri_array['tdate']))
			{
				$from_date = date('Y-m-d',strtotime($uri_array['fdate']));
				$to_date = date('Y-m-d',strtotime($uri_array['tdate']));
				$config['base_url'] .= '/fdate/'.$from_date.'/tdate/'.$to_date;
				$config['uri_segment'] += 4;
				$redirect .= '/fdate/'.$from_date.'/tdate/'.$to_date;
			}
			if(isset($uri_array['vn']))
			{
				$vnos = $uri_array['vn'];
				$like_array['bill_no'] = $vnos;
				$config['base_url'] .= '/vn/'.$vnos;
				$config['uri_segment'] += 2;
				$redirect .= '/vn/'.$vnos;
			}
		}

		#----------between condition
		$between = "bill_date between '$from_date' and '$to_date'";

		#----------total rows

		$config['total_rows'] = $this->book_obj->get_bills(array('columns' => array('id'),'conditions' => $conditions,'between' => $between,'like' => $like_array,'numrows'=>true));

		if($config['total_rows'] == 0)
		{
			$this->message->set($this->lang->line('no-voucher'),'i');
		}

		#----------pagination
		$offset = $this->uri->segment($config['uri_segment'],0);
		$this->pagination->initialize($config);
		$links = $this->pagination->create_links();
		$redirect .= '/'.$offset;

     /*   $this->load->model('customers/Customer_master_model','customer_master');
		$customers = $this->customer_master->listing();
        $customers['']= "Select";
        ksort($customers);*/

		#------------presumptive tax checking
		$presumptive_tax = $this->stock->get_tax_type();

		#----------sales report datas
		$sales_array=$this->book_obj->get_bills(array('conditions' => $conditions,'between' => $between,'like' => $like_array,'order_by'=>'bill_no','order'=>'DESC','limit'=>$config['per_page'],'offset'=>$offset));

		#----------template
		$this->template->title("Sales1");
		$this->template->main_heading($this->lang->line("$voucher_name")." ".$this->lang->line("booking")." ".$this->lang->line("report"));
		$this->template->breadcrumb(array($this->lang->line("booking")." ".$this->lang->line('report') => 'no_link',$this->lang->line('report') => 'sales1/report'));
		$this->template->slice('sales1/book_search',array('voucher_types' => $voucher_types,'vtype_id' => $vtype_id,'vnos' => $vnos,'from_date' => $from_date,'to_date' => $to_date,'rtype' => 'sales'));
		$this->template->slice('dms/message');
		$this->template->other_script('sales/sales_order');
		if(!empty($sales_array))
		{
			$this->template->slice('sales1/book_report',array('sales_array' => $sales_array,'presumptive_tax' => $presumptive_tax,'offset' => $offset,'links' => $links,'vtype_id' => $conditions['vtype_id'],'redirect' => $redirect));
			$this->template->slice('dms/modals/delete_confirm');
		} 
		$this->template->render();
	}
	
	public function report()
	{
		#----------loading models
		$this->load->model('designations/Designation_master_model','desig');
                $this->load->model('booking/Booking_model','book_obj');

		#----------voucher type
		$vtype_id = $this->vtype1;
		$conditions = array('vtype_id' => $vtype_id,'status' => 1);
		$like_array = array();$vnos="";

		#----------voucher name
		$voucher_name = $this->vouchers->voucher_name($this->vtype1);

		#----------voucher type array
		$voucher_types = $this->vouchers->voucher_types_virtual($this->vtype1);

		#----------uri array
		$uri_array  = $this->uri->uri_to_assoc(3);

		#----------redirect
		$redirect = "";

		#----------pagination
		$this->load->library('Pagination');
		$config['per_page'] = $this->per_page();
		# Pagination Config Customizations
        $config['full_tag_open'] = '<ul class="pagination">';
        $config['full_tag_close'] = '</ul>';
        $config['first_link'] = 'First';
        $config['last_link'] = 'Last';
        $config['next_link'] = '&raquo;';
        $config['prev_link'] = '&laquo;';
        $config['cur_tag_open'] = '<li class="active"><a href="#">';
        $config['cur_tag_close'] = '</a></li>';
        $config['num_tag_open'] = '<li>';
        $config['num_tag_close'] = '</li>';
		$config['base_url'] = base_url('sales/report');
		$config['uri_segment'] = 3;

		#----------dates within financial year
		$cur_date = date('Y-m-d');
		$from_date = $cur_date;
		$to_date = $cur_date;
		$cur_fiscal_yr = $this->dms->get_fiscal_year();
		if($from_date < $cur_fiscal_yr['start_date'] || $from_date > $cur_fiscal_yr['end_date'] || $to_date < $cur_fiscal_yr['start_date'] || $to_date > $cur_fiscal_yr['end_date'])
		{
			$from_date = $cur_fiscal_yr['end_date'];
			$to_date = $cur_fiscal_yr['end_date'];
		}

		#----------validation
		$this->form_validation->set_rules('vtype_id','voucher-types','required|xss_clean');
		$this->form_validation->set_rules('from_date','From Date','required|xss_clean|valid_date');
		$this->form_validation->set_rules('to_date','To Date','required|xss_clean|valid_date');
		$this->form_validation->set_rules('bill_no','bill-no','xss_clean|trim');
                $this->form_validation->set_rules('phone','phone','xss_clean|trim');
		if($this->form_validation->run() === true)
		{
			$vtype_id = $this->input->post('vtype_id',true);
			$from_date = date('Y-m-d',strtotime($this->input->post('from_date',true)));
			$to_date = date('Y-m-d',strtotime($this->input->post('to_date',true)));
			$conditions['vtype_id'] = $vtype_id;
			$config['base_url'] .= '/vt/'.$vtype_id.'/fdate/'.$from_date.'/tdate/'.$to_date;
			$config['uri_segment'] += 6;
			$redirect .= '/vt/'.$vtype_id.'/fdate/'.$from_date.'/tdate/'.$to_date;
			if(!empty($this->input->post('bill_no',true)))
			{
				$vnos = $this->input->post('bill_no',true);
				$like_array['bill_no'] = $vnos;
				$config['base_url'] .= '/vn/'.$vnos;
				$config['uri_segment'] += 2;
				$redirect .= '/vn/'.$vnos;
			}
                        if(!empty($this->input->post('phone',true)))
			{
                            $ph = $this->input->post('phone',true);  
                            $cust_qr=$this->db->select('id')->from('customer_master')->where('mobile_no',$ph)->get()->row_array();
                            $cust_ids= $cust_qr['id']; 
                            if(!empty($cust_ids))
                            {
                                   $conditions['customer_id'] = $cust_ids;
                            }
                        }
                        if(!empty($this->input->post('customer_id',true)))
			{
                            $cust_ids = $this->input->post('customer_id',true);                                                                                   
                            $conditions['customer_id'] = $cust_ids;                        
                        }
		}
		elseif(isset($uri_array['vt']))
		{
			$vtype_id = $uri_array['vt'];
			$conditions['vtype_id'] = $vtype_id;
			$config['base_url'] .= '/vt/'.$conditions['vtype_id'];
			$config['uri_segment'] += 2;
			$redirect .= '/vt/'.$vtype_id;
			if(isset($uri_array['fdate']) && isset($uri_array['tdate']))
			{
				$from_date = date('Y-m-d',strtotime($uri_array['fdate']));
				$to_date = date('Y-m-d',strtotime($uri_array['tdate']));
				$config['base_url'] .= '/fdate/'.$from_date.'/tdate/'.$to_date;
				$config['uri_segment'] += 4;
				$redirect .= '/fdate/'.$from_date.'/tdate/'.$to_date;
			}
			if(isset($uri_array['vn']))
			{
				$vnos = $uri_array['vn'];
				$like_array['bill_no'] = $vnos;
				$config['base_url'] .= '/vn/'.$vnos;
				$config['uri_segment'] += 2;
				$redirect .= '/vn/'.$vnos;
			}
		}

		#----------between condition
		$between = "bill_date between '$from_date' and '$to_date'";

		#----------total rows

		$config['total_rows'] = $this->sales_obj->get_bills(array('columns' => array('id'),'conditions' => $conditions,'between' => $between,'like' => $like_array,'numrows'=>true));

		if($config['total_rows'] == 0){
			$this->message->set($this->lang->line('no-voucher'),'i');
		}

		#----------pagination
		$offset = $this->uri->segment($config['uri_segment'],0);
		$this->pagination->initialize($config);
		$links = $this->pagination->create_links();
		$redirect .= '/'.$offset;

                $this->load->model('customers/Customer_master_model','customer_master');
		$customers = $this->customer_master->listing();
                $customers['']= "Select";
                ksort($customers);

		#------------presumptive tax checking
		$presumptive_tax = $this->stock->get_tax_type();

		#----------sales report datas
		$sales_array=$this->sales_obj->get_bills(array('conditions' => $conditions,'between' => $between,'like' => $like_array,'order_by'=>'bill_no','order'=>'DESC','limit'=>$config['per_page'],'offset'=>$offset));

		#----------template
		$this->template->title("Sales1 Report");
		$this->template->main_heading($this->lang->line("$voucher_name")." ".$this->lang->line("report"));
		$this->template->breadcrumb(array($this->lang->line("booking").' '.$this->lang->line("report") => 'sales1/book_report',$this->lang->line('report') => 'no_link'));
		$this->template->slice('sales1/search',array('voucher_types' => $voucher_types,'vtype_id' => $vtype_id,'vnos' => $vnos,'from_date' => $from_date,'to_date' => $to_date,'ph'=>$ph,'rtype' => 'sales1','customers'=>$customers,'cust'=>$cust_ids));
		$this->template->slice('dms/message');
		$this->template->other_script('sales/sales_order');
		if(!empty($sales_array))
		{
			$this->template->slice('sales1/report',array('sales_array' => $sales_array,'presumptive_tax' => $presumptive_tax,'offset' => $offset,'links' => $links,'vtype_id' => $conditions['vtype_id'],'redirect' => $redirect));
			$this->template->slice('dms/modals/delete_confirm');
		}
		$this->template->render();
	}
}
?>