<?php if( ! defined('BASEPATH')) exit ('No direct script access allowed');

class Sales_return extends MY_Controller{

	public function __construct()
	{
		parent::__construct();

		$this->check_access_right();

		$method_array = array('add','delete_temp','update_temp','update','delete');
		fiscal_status($this->uri->segment(2),$method_array,"sales_return/report");
		
		$this->load->model('sales/Sales_return_model','sales_obj');
        $this->load->model('sales/Sales_model','bill_obj');
		$this->load->model('vouchers/Voucher_model','vouchers');
		$this->load->library(array('Stock'));
		$this->createdBY = $this->session->userdata('id');
		$this->branchID = $this->session->userdata('under_id');
		
		$this->branch_status = 0;
		if($this->dms->branch_type())
		{
			$this->branch_status = 1;
		}

		$this->vtype = 8;
	}

	public function add()
	{
		$this->load->model('designations/Designation_master_model','desig');
		$this->load->model('customers/Customer_type_model','customer_type');

		$vtype_id = $this->vtype;

		$voucher_types = $this->vouchers->voucher_types($this->vtype);
		$bill_prefix = $this->stock->get_voucher_prefix($this->vtype);
		
		$voucher_name = $this->vouchers->voucher_name($this->vtype);

		$sales_cst = $this->stock->get_constant(array('sales_cst'));

		$presumptive_tax = $this->stock->get_tax_type();

		$cess = $this->stock->get_cess();
		$const = $this->stock->get_constant();

		$Ckargs = array();
		$Ckargs['columns'] = array('id','s_status');
		$Ckargs['conditions'] = array('created_by'=>$this->createdBY,'status'=>-1,'branch_id'=>$this->branchID);
		$sales_return_temp = $this->sales_obj->get_bills($Ckargs);

		if(!empty($sales_return_temp))
		{
			if($sales_return_temp[0]['s_status'] == 1)
			{
				$this->message->set($this->lang->line('pending-sales-return-exists'),'e');
				redirect('preturn_to_sreturn/sales_return/');
			}
		}

		$rules = "callback_bill_no_exists";
		$disabled = "";
		$result_array = $this->sales_obj->next_bill_no($this->vtype);
		$vtype_id = $result_array['vtype_id'];
		$voucher_no = $result_array['bill_no'];
		$voucher_date = $result_array['bill_date'];
		if($result_array['vstatus'])
		{
			$disabled = "readonly";
			$group_id = $result_array['group_id'];
			$rules = "callback_bill_no_exists[$vtype_id.$group_id]";

			$voucher_details = $this->dms->get_data(array('table' => 'dms_vouchers as a','join' => array('table' => 'dms_sales_returns as b','on' => 'a.table_group_id = b.group_id'),'columns' => 'b.id','conditions' => array('a.table_name' => 'dms_sales_returns','a.table_group_id' => $group_id)));
			if(!empty($voucher_details))
			{
				redirect("sales_return/update/id/".$voucher_details[0]['id']);
			}

			/*$cst_status = $this->sales_obj->get_cst($group_id);*/
			$cst_status = 0;
			if($cst_status)
			{
				$sales_cst = $cst_status;
			}
		}
		else
		{
			$group_id = $this->stock->get_group_id('dms_sales_return_items');
		}

		if(isset($_POST['btn_add']))
		{
			$this->form_validation->set_rules('vtype_id','lang:voucher-types','required|xss_clean');
			$this->form_validation->set_rules('bill_no','lang:bill-no',"required|xss_clean|is_natural_no_zero|".$rules);
			$this->form_validation->set_rules('bill_date','lang:bill-date','required|xss_clean|valid_date');
			$this->form_validation->set_rules('customer_type','lang:customer-type','required|xss_clean');
			$this->form_validation->set_rules('customer_id','lang:customer-name','required|xss_clean');
			$this->form_validation->set_rules('item_id','lang:item-name','required|xss_clean');
		    $this->form_validation->set_rules('qty','lang:quantity','required|xss_clean|greater_than[0]|less_than[100000000]');
			$this->form_validation->set_rules('unit_id','lang:unit','required|xss_clean');
			$this->form_validation->set_rules('rate','lang:rate','required|xss_clean|greater_or_equal[0]|less_than[100000000]');
			$this->form_validation->set_rules('amount','lang:amount','xss_clean|required|greater_or_equal[0]|less_than[100000000]');

			if($this->form_validation->run('btn_add') === true)
			{
				$item_array = $this->input->post(NULL,true);
                $ret_bill_id = $item_array['return_bill_no'];

				unset($item_array['vtype_id']);
				unset($item_array['bill_no']);
				unset($item_array['bill_date']);
				unset($item_array['return_bill_no']);
				unset($item_array['customer_type']);
				unset($item_array['customer_id']);
				unset($item_array['btn_add']);
				
				$item_array['godown_id'] = $this->stock->get_branch_godown($this->branchID);
				$item_array['group_id'] = $group_id;
				$item_array['status'] = -1;

                $cont1['id'] = $ret_bill_id;
                $cont1['status'] = 1;

                $ret_bill = $this->bill_obj->get_bills(array('conditions' => $cont1));                                
                $disc_amt = $ret_bill[0]['bill_discount_amt'];

                if($disc_amt ==''){ $disc_amt=0; }

				$item_array['rate'] = 0;
				if($item_array['qty'] != 0)
				{
					$item_array['rate'] = $item_array['amount'] / $item_array['qty'];
				}

				$sales_temp_item_result = $this->sales_obj->get_sales(array('columns' => array('b.id'),'conditions' => array('b.group_id' => $group_id,'item_id' => $item_array['item_id'],'godown_id' => $item_array['godown_id'],'unit_id' => $item_array['unit_id'],'a.status !=' => 0,'b.status !=' => 0),'numrows' => true));
				if($sales_temp_item_result == 0)
				{
					$vat = $this->stock->get_item_vat($item_array['item_id']);
					$item_array['vat'] = $vat;
					
				    if($const['vat_in_ex']=='1')
					{
				        $item_array['taxable_amt'] = (float)$item_array['amount']-(float)$item_array['discount_amt'];
					}
					else
					{
                        $item_array['taxable_amt'] = (((float)$item_array['amount']-(float)$item_array['discount_amt'])*100)/(100+(float)$vat+(float)$cess);
					}
					$item_array['vat_amt'] = ((float)$item_array['taxable_amt'] * (float)$vat) / 100;
					$item_array['cess_amt'] = ((float)$item_array['taxable_amt'] * (float)$cess) / 100;
					
					$this->db->trans_start();

					if($result_array['vstatus'] == 0)//data not in dms_sales_returns
					{
						$sales_temp_array['vtype_id'] = $this->input->post('vtype_id',true);
						$sales_temp_array['branch_id'] = $this->session->userdata('under_id');
						$sales_temp_array['group_id'] = $group_id;
						$sales_temp_array['bill_no'] = $this->input->post('bill_no',true);
						$sales_temp_array['bill_date'] = date('Y-m-d',strtotime($this->input->post('bill_date',true)));
						if($this->input->post('return_bill_no',true) && $this->input->post('return_bill_no',true) != "")
						{
							$sales_temp_array['return_bill_no'] = $this->input->post('return_bill_no',true);
						}
						$sales_temp_array['customer_type_id'] = $this->input->post('customer_type',true);
						$sales_temp_array['customer_id'] = $this->input->post('customer_id',true);
						$sales_temp_array['status'] = -1;
						$voucher_date = $sales_temp_array['bill_date'];
						$this->sales_obj->insert("dms_sales_returns",$sales_temp_array);
					}

					$sales_items_id = $this->sales_obj->insert("dms_sales_return_items",$item_array);
					if($sales_items_id)
					{
						$this->sales_obj->insert('dms_stocks',array('company_id' => $this->session->userdata('company_id'),'branch_id' => $this->session->userdata('under_id'),'godown_id' => $item_array['godown_id'],'item_id' => $item_array['item_id'],'qty' => $item_array['qty'],'unit_id' => $item_array['unit_id'],'rate' => $item_array['rate'],'amount' => $item_array['amount'],'stock_date' => $voucher_date,'stock_status' => 8,'table_group_id' => $group_id,'table_id' => $sales_items_id,'status' => -1));
						$this->message->set($this->lang->line('sales_return-add-success'));
					}
					else
					{
						$this->message->set($this->lang->line('sales_return-add-error'),'e');
					}

					$this->db->trans_complete();
				}
				else
				{
					$this->message->set($this->lang->line('sales_return-add-error'),'e');
				}
				redirect('sales_return/add');
			}
		}

		if(isset($_POST['btn_save']))
		{
			$this->form_validation->set_rules('area_id','lang:area','required|xss_clean');
			$this->form_validation->set_rules('payment_mode','lang:payment-mode','required|xss_clean');
			if($this->input->post('payment_mode',true) > 2)
			{
				$this->form_validation->set_rules('ccd','lang:transaction-type','required|xss_clean');
				$this->form_validation->set_rules('cd_no','lang:cd-no','required|xss_clean|max_length[64]');
				$this->form_validation->set_rules('cheque_date','lang:cheque-date',"required|xss_clean|is_date|check_date[$voucher_date.>=]");
			}
			$this->form_validation->set_rules('remarks','lang:remarks','xss_clean');
			$this->form_validation->set_rules('freight','lang:freight','xss_clean|greater_or_equal[0]|less_than[100000000]');
			$this->form_validation->set_rules('other_expense','lang:other-expense','xss_clean|greater_or_equal[0]|less_than[100000000]');
			
			if($this->form_validation->run('btn_save') === true)
			{
				$payment_mode = $this->input->post('payment_mode',true);
				$narration = $this->input->post('remarks',true);
				$freight = $this->input->post('freight',true);
				$other_expense = $this->input->post('other_expense',true);
				$bill_discount_amt = $this->input->post('bill_discount_amt',true);
				$sales_entry_array=array('area_id' => $this->input->post('area_id',true),'bill_discount_amt'=>$bill_discount_amt,'bill_freight' => $freight,'other_expense' => $other_expense,'cess' => $cess,'narration' => $narration,'payment_mode' => $payment_mode,'status' => 1);

				$sales_entry_check = $this->sales_obj->get_bills(array('columns' => array('vtype_id','bill_no','bill_date','return_bill_no','customer_type_id','customer_id'),'conditions' => array('group_id' => $group_id,'status !=' => 0)));
				if($sales_entry_check)
				{
					$bill_date = $sales_entry_check[0]['bill_date'];
					$vtype_id = $sales_entry_check[0]['vtype_id'];
					$bill_no = $sales_entry_check[0]['bill_no'];

					if($sales_entry_check[0]['customer_type_id'] == 2)//customer
					{
						$customer = $this->dms->get_data(array('table' => 'customer_master','columns' => 'ledger_id','conditions' => array('id' => $sales_entry_check[0]['customer_id'])));
					}
					elseif($sales_entry_check[0]['customer_type_id'] == 3)//AR
					{
						$customer = $this->dms->get_data(array('table' => 'retailer_master','columns' => 'ledger_id','conditions' => array('id' => $sales_entry_check[0]['customer_id'])));
					}
					else
					{
						$customer = $this->dms->get_data(array('table' => 'branch_master','columns' => 'ledger_id','conditions' => array('id' => $sales_entry_check[0]['customer_id'])));
					}

					$this->db->trans_start();

					if($this->sales_obj->update(array('table' => 'dms_sales_returns','data' => $sales_entry_array,'conditions' => array('group_id' => $group_id))))
					{
					    $voucher_amount=0;
					    if($bill_discount_amt>0)
                        {
                            $bill_total=0;
                            $sales_items_array1 = $this->sales_obj->get_sales_items(array('columns' => array('qty','rate'),'conditions' => array('group_id' => $group_id,'status!=' => 0)));
   						    
   						    foreach($sales_items_array1 as $key1 => $value1)
    						{
								(float)$bill_total += (float)$value1['qty']*(float)$value1['rate'];
    						}
   						
   						    $bill_discount_per = ((float)$bill_discount_amt/(float)$bill_total)*100;
   						
   						    $sales_items_array = $this->sales_obj->get_sales_items(array('columns' => array('id','item_id','qty','unit_id','rate','godown_id'),'conditions' => array('group_id' => $group_id,'status!=' => 0)));
   						    
    						foreach($sales_items_array as $key => $value)
    						{
    						    $it_up_id = $value['id'];
    						    $itid = $value['item_id']; 
    						    $itamt = $value['qty']*$value['rate'];
    						    $itdiscamt = ($itamt*$bill_discount_per)/100;
    						    $it_vat = $this->stock->get_item_vat($itid);
    						    
    						    if($const['vat_in_ex']=='1')
            					{
            				        $it_taxable = $itamt-$itdiscamt;
            					}
            					else
            					{
                                    $it_taxable = (((float)$itamt-(float)$itdiscamt)*100)/(100+(float)$it_vat+(float)$cess);
            					}
    						    
    						    $it_vat_amt = ((float)$it_taxable*(float)$it_vat)/100; 
    						    $it_cess_amt = ((float)$it_taxable*(float)$cess)/100; 
    						    
    						    (float)$voucher_amount += (float)$it_taxable+(float)$it_vat_amt+(float)$it_cess_amt;
    						    
    						    $it_up_array = array('discount_amt'=>$itdiscamt,'taxable_amt'=>$it_taxable,'vat'=>$it_vat,'vat_amt'=>$it_vat_amt,'cess_amt'=>$it_cess_amt);
    						
    						    $this->sales_obj->update(array('table' => 'dms_sales_return_items','data' => $it_up_array,'conditions' => array('id' => $it_up_id)));
    						}
    						$voucher_amount += $freight+$other_expense;
                        }
                        else
                        {
                            $voucher_amount = $this->input->post('grand_total',true);
    					}
					    
					    $this->sales_obj->update(array('table' => 'dms_sales_return_items','data' => array('status' => 1),'conditions' => array('group_id' => $group_id,'status !=' => 0)));

						$voucher_status = 1;
						if($payment_mode > 2)
						{
							$bill_date_time = strtotime($bill_date);
							$cheque_date = date('Y-m-d',strtotime($this->input->post('cheque_date',true)));
							$cheque_date_time = strtotime($cheque_date);
							if($this->input->post('ccd',true) == 1 && $cheque_date_time > $bill_date_time)
							{
								$voucher_status = 3;
							}
						}
						elseif($payment_mode == 2)
						{
							$payment_mode = $customer[0]['ledger_id'];//customer
						}
						
						$voucher_amount += $round_off_amount;
						
						$voucher_group_id = $this->stock->get_group_id('dms_vouchers');
						$voucher_array = array('company_id' => $this->session->userdata('company_id'),'branch_id' => $this->session->userdata('under_id'),'group_id' => $voucher_group_id,'vtype_id' => $vtype_id,'vno' => $bill_no,'vorder_no' => 1,'vdate' => $bill_date,'dr_ledger' => 6,'cr_ledger' => $payment_mode,'vamount' => $voucher_amount,'narration' => $narration,'table_name' => 'dms_sales_returns','table_group_id' => $group_id,'status' => $voucher_status);
						$voucher_data = $this->dms->get_data(array('table' =>'dms_vouchers','columns' => array('id'),'conditions' => array('table_name' => 'dms_sales_returns','table_group_id' => $group_id),'numrows' => true));
						if($voucher_data == 0)
						{
							$voucher_success = $this->sales_obj->insert('dms_vouchers',$voucher_array);
							if($voucher_success)
							{
								if($payment_mode > 2)
								{
									$this->sales_obj->insert('dms_voucher_banks',array('group_id' => $voucher_group_id,'cash_type' => $this->input->post('ccd',true),'cd_no' => $this->input->post('cd_no',true),'pdc' => $cheque_date,'vdate' => $bill_date));
								}
							}
						}

						if($sales_entry_check[0]['return_bill_no'] > 0)
						{
							$this->sales_obj->update_others(array('table' => 'dms_sales','data' => array('bill_status' => 3),'conditions' => array('id' => $sales_entry_check[0]['return_bill_no'])));
						}

						$branch_id = $this->session->userdata('under_id');
                        $godown_id = $this->stock->get_branch_godown($branch_id); 
						$sales_items_array = $this->sales_obj->get_sales_items(array('columns' => array('id','item_id'),'conditions' => array('group_id' => $group_id,'status' => 1)));
						foreach($sales_items_array as $key => $value)
						{
							$this->sales_obj->update_others(array('table' => 'dms_stocks','data' => array('status' => 1),'conditions' => array('stock_status' => 8,'table_id' => $value['id'])));
						}
						$this->message->set($this->lang->line('sales_return-save-success'));
					}
					else
					{
						$this->message->set($this->lang->line('sales_return-save-error'),'e');
					}
				}
				else
				{
					$this->message->set($this->lang->line('sales_return-save-error'),'e');
				}
				redirect('sales_return/add');
			}
		}

		$units = $goDowns = $customers = array();
		$units[''] = "Select";$custType = "";

		$sales_temp_data = array();
		$stock_count = $primary_unit['symbol'] = $cust_id = $return_bill = "";
		if($result_array['vstatus'])
		{
			$sales_temp_data = $this->sales_obj->get_sales(array('columns' => array('a.group_id','a.return_bill_no','a.customer_type_id','a.customer_id','a.bill_discount_amt','b.id','b.item_id','b.qty','b.unit_id','b.rate','b.amount','b.discount_amt','b.taxable_amt','b.godown_id','b.vat','b.vat_amt','b.cess_amt'),'conditions' => array('a.created_by' => $this->session->userdata('id'),'vtype_id' => $vtype_id,'bill_no' => $voucher_no,'a.status =' => -1,'b.status =' => -1)));	

			$custType = $sales_temp_data[0]['customer_type_id'];

			$cust_id = $sales_temp_data[0]['customer_id'];
            $disc_amt1 = $sales_temp_data[0]['bill_discount_amt']; 
            
			$item_id =  $sales_temp_data[0]['item_id'];

			if($result_array['return_bill_no'] > 0)
			{
				$return_bill = $result_array['return_bill_no'];
				$customerTypes = $this->sales_obj->get_customer_type($return_bill);
				$customers = $this->sales_obj->get_customer($return_bill);
				$return_bills[$return_bill] = $this->sales_obj->get_bill_no($return_bill);
				$items =  $this->sales_obj->get_bill_items($return_bill);
                                
                if(empty($items))
                {
                    $items = $this->sales_obj->get_bill_items($return_bill);   
                }    
			}
			else
			{
				$return_bills = $this->sales_obj->get_sales_bills();
				if($this->branch_status)
				{
					$customerTypes = $this->desig->listing(array('department_id'=>0,'utype_status >'=>1));
				}
				else
				{
					$customerTypes = $this->desig->listing(array('id'=>2));
				}
				if($custType == 2)
				{
					$this->load->model('customers/Customer_master_model','customer_master');
					$customers = $this->customer_master->listing(array('conditions'=>array('id'=>$cust_id)));
				}
				else if($custType == 1)
				{
					$this->load->model('branches/Branch_model','branches');
					$customers = $this->branches->listing(array('id ='=>$cust_id));
				}
				else
				{
					$this->load->model('retailers/Counter_model','retailer_master');
					$customers = $this->retailer_master->listing(array('id'=>$cust_id));
				}
				$args['select'] = array('id','item_code','item_name');
				$items = $this->stock->get_stock_items($args);
				if(empty($items))
				{
					$this->message->set($this->lang->line('no-items-found'),'i');
				}
				$customerTypes[''] = 'Select';ksort($customerTypes);
				$customers[''] = 'Select';ksort($customers);
				$return_bills[''] = 'Select';ksort($return_bills);
			}

			$this->load->model('areas/Area_model','area');
			$areas = $this->area->listing();
		}
		else
		{
			$sales_array = $this->input->post('sales',true);

			if($sales_array['customer_type'] != "")
			{
				$custType = $sales_array['customer_type'];
			}
			if($sales_array['customer_id'] != "")
			{
				$cust_id = $sales_array['customer_id'];
			}

			if($this->input->post('return_bill_no',true) && $this->input->post('return_bill_no',true) != "")
			{
				$return_bill = $this->input->post('return_bill_no',true);
				$customerTypes = $this->sales_obj->get_customer_type($return_bill);
				$customers = $this->sales_obj->get_customer($return_bill);
				$return_bills[$return_bill] = $this->sales_obj->get_bill_no($return_bill);
				$items = $this->sales_obj->get_bill_items($return_bill);
			}
			else
			{
				if($this->branch_status)
				{
					$customerTypes = $this->desig->listing(array('department_id'=>0,'utype_status >'=>1));
				}
				else
				{
					$customerTypes = $this->desig->listing(array('id'=>2));
				}
				$return_bills = $this->sales_obj->get_sales_bills();
				$args['select'] = array('id','item_code','item_name');
				$items = $this->stock->get_stock_items($args);
				if(empty($items))
				{
					$this->message->set($this->lang->line('no-items-found'),'i');
				}
				$customerTypes[''] = 'Select';ksort($customerTypes);
				$customers[''] = 'Select';ksort($customers);
				$return_bills[''] = 'Select';ksort($return_bills);
			}

			if($this->input->post('item_id',true) && $this->input->post('godown_id',true) && $sales_array['bill_date'] != "")
			{
				$stock_count = $this->stock->get_stock_count($this->input->post('godown_id',true),$this->input->post('item_id',true),$sales_array['bill_date']);
				$primary_unit = $this->stock->get_primary_unit($this->input->post('item_id',true));
			}
		}
		if($this->input->post('item_id',true))
		{
			$itemID = $this->input->post('item_id',true);
			$goDowns = $this->stock->get_item_godowns(array('item_id'=>$itemID,'listing'=>1));
			$units = $this->stock->get_units($itemID);
		}
		$areas[''] = 'Select'; ksort($areas);
		$items[''] = 'Select'; ksort($items);
		$goDowns[''] = 'Select'; ksort($goDowns);

		$payment_mode = $this->stock->payment_modes();

		$cd_status = 1;
		if($this->input->post('payment_mode',true) > 2)
		{
			$cd_status = 0;
		}

	    $this->template->title("New Sales Return Voucher");
		$this->template->main_heading($this->lang->line("$voucher_name"));
		$this->template->breadcrumb(array($this->lang->line("inventory-voucher") => 'no_link',$this->lang->line("$voucher_name") => 'no_link',$this->lang->line('report') => 'sales_return/report'));
		$this->template->slice('dms/message');
		$this->template->slice('sales/sales_return/add',array('voucher_types' => $voucher_types,'voucher_type' => $vtype_id,'voucher_name' => $voucher_name,'voucher_no' => $voucher_no,'voucher_date' => $voucher_date,'return_bills' => $return_bills,'return_bill' => $return_bill,'custType' => $custType,'customerTypes' => $customerTypes,'customers' => $customers,'cust_id' => $cust_id,'itm_id'=>$itm_id,'items' => $items,'units' => $units,'goDowns' => $goDowns,'sales_temp_status' =>$result_array['vstatus'],'sales_temp_data' => $sales_temp_data,'areas' => $areas,'sales_cst' => $sales_cst,'presumptive_tax' => $presumptive_tax,'cess' => $cess,'payment_mode' => $payment_mode,'disabled' => $disabled,'stock_count' => $stock_count,'primary_unit' => $primary_unit['symbol'],'cd_status' => $cd_status,'bill_prefix'=>$bill_prefix,'disc_amt'=>$disc_amt1));
		$this->template->other_script('sales/sales_return');
		$this->template->render();
	}

	public function delete_temp()
	{
		$uri_array = $this->uri->uri_to_assoc(3);
		if(isset($uri_array['idu']) || isset($uri_array['ida']))
		{
			if(isset($uri_array['idu']))
			{
				$id = $uri_array['idu'];
				unset($uri_array['idu']);

				$redirect_uri = "sales_return/update/".$this->uri->assoc_to_uri($uri_array);
			}
			else
			{
				$id = $uri_array['ida'];
				unset($uri_array['ida']);

				$redirect_uri = "sales_return/add/".$this->uri->assoc_to_uri($uri_array);
			}

            $result = $this->sales_obj->get_sales(array('columns' => array('a.group_id','a.return_bill_no','a.bill_date','a.sid','a.s_status','b.status','b.created_by'),'conditions' => array('b.id' => $id,'b.status !=' => 0)));
          
			if(!empty($result))
			{
				$row = $result[0];
                
                if($result[0]['s_status'] != 2)
                {
    				if($row['status'] == -1)
    				{
    					if($row['created_by'] == $this->session->userdata('id'))
    					{
    						$this->db->trans_start();
                   
    						if($this->sales_obj->delete(array('table' => 'dms_sales_return_items','conditions' => array('id' => $id))))
    						{
    							$this->sales_obj->delete(array('table' => 'dms_stocks','conditions' => array('table_id' => $id,'stock_status' => 8)));
    
    							$count = $this->sales_obj->get_sales_items(array('columns' => array('group_id'),'conditions' => array('group_id' => $row['group_id'],'status !=' => 0),'numrows' => true));
    							if($count == 0)
    							{
    								$this->sales_obj->delete(array('table' => 'dms_sales_returns','conditions' => array('group_id' => $row['group_id'])));
    							}
    							$this->message->set($this->lang->line('sales_return-item-delete-success'));
    						}
    						else
    						{
    							$this->message->set($this->lang->line('sales_return-item-delete-error'),'e');
    						}
    
    						$this->db->trans_complete();
                        }
    					else
    					{
    						redirect('users/logout');
    					}
    				}
    				else
    				{
    					$this->db->trans_start();
    
    					$this->sales_obj->update(array('table' => 'dms_sales_return_items','data' => array('status' => 0),'conditions' => array('id' => $id)));
    
    					$this->sales_obj->update(array('table' => 'dms_sales_returns','data' => array('status' => -1),'conditions' => array('group_id' => $row['group_id'])));
    
    					$this->sales_obj->update_others(array('table' => 'dms_stocks','data' => array('status' => 0),'conditions' => array('table_id' => $id,'stock_status' => 8)));
    
    					$count = $this->sales_obj->get_sales_items(array('columns' => array('group_id'),'conditions' => array('group_id' => $row['group_id'],'status !=' => 0),'numrows' => true));
    					if($count == 0)
    					{
    						$this->sales_obj->update(array('table' => 'dms_sales_returns','data' => array('status' => 0),'conditions' => array('group_id' => $row['group_id'])));
    
    						$this->sales_obj->update_others(array('table' => 'dms_vouchers','data' => array('status' => 0),'conditions' => array('table_name' => 'dms_sales_returns','table_group_id' => $row['group_id'])));
    
    						$cheque_details = $this->vouchers->cheque_data(array('columns' => 'b.id','conditions' => array('table_name' => 'dms_sales_returns','table_group_id' => $row['group_id'])));
    						if(!empty($cheque_details))
    						{
    							$this->sales_obj->update_others(array('table' => 'dms_voucher_banks','data' => array('status' => 0),'conditions' => array('id' => $cheque_details[0]['id'])));
    						}
    
    						if($row['return_bill_no'] > 0)
    						{
    							$this->sales_obj->update_others(array('table' => 'dms_sales','data' => array('bill_status' => 0),'conditions' => array('id' =>$row['return_bill_no'])));
    						}
    
    						$redirect_uri = "sales_return/report/".$this->uri->assoc_to_uri($uri_array);
    					}
    					$this->message->set($this->lang->line('sales_return-item-delete-success'));
    
    					$this->db->trans_complete();
    				}
    			}
    			else
    			{
    				$this->message->set($this->lang->line('delete-sr-ri-item'),'e');
    			}
			}
			redirect($redirect_uri);
		}
		redirect('users/logout');
	}

	public function update_temp()
	{
		$uri_array = $this->uri->uri_to_assoc(3);
		
		if(isset($uri_array['idu']) || isset($uri_array['ida']))
		{
			if(isset($uri_array['idu']))
			{
				$sales_temp_id = $uri_array['idu'];
				unset($uri_array['idu']);

				$redirect_uri = "sales_return/update/".$this->uri->assoc_to_uri($uri_array);
			}
			else
			{
				$sales_temp_id = $uri_array['ida'];
				unset($uri_array['ida']);

				$redirect_uri = "sales_return/add/".$this->uri->assoc_to_uri($uri_array);
			}

		    $row = $this->sales_obj->get_sales(array('columns' => array('a.group_id','a.bill_date','a.return_bill_no','a.sid','a.s_status','b.item_id','b.qty','b.unit_id','b.rate','b.amount','b.taxable_amt','b.vat_amt','b.cess_amt','b.godown_id','b.status','b.created_by'),'conditions' => array('b.id' => $sales_temp_id,'b.status !=' => 0)));
            if(!empty($row))
			{
				$sales_temp_data = $row[0]; $continue = 1;
				
				$cess = $this->stock->get_cess();
			    $const = $this->stock->get_constant();
			    
				if($sales_temp_data['status'] == -1)
				{
					if($sales_temp_data['created_by'] != $this->session->userdata('id'))
					{
						$continue = 0;
					}
				}
				if($continue == 1)
				{
					$rules = "callback_check_bill_qty";
					if($sales_temp_data['return_bill_no'] > 0)
					{
						$rules = "callback_check_bill_qty[$sales_temp_data[return_bill_no].$sales_temp_data[item_id].$sales_temp_id]";
					}

					$this->form_validation->set_rules('qty','lang:quantity','required|xss_clean|greater_than[0]|less_than[100000000]');
					$this->form_validation->set_rules('unit_id','lang:unit','required|xss_clean');
					$this->form_validation->set_rules('rate','lang:rate','required|xss_clean|greater_or_equal[0]|less_than[100000000]');
					$this->form_validation->set_rules('amount','lang:amount','xss_clean|required|greater_or_equal[0]|less_than[100000000]');
					
					if($this->form_validation->run() === true)
					{
						$item_temp_array = $this->input->post(NULL,true);
						$item_temp_array['status'] = -1;
                        $item_temp_array['godown_id'] = $this->stock->get_branch_godown($this->branchID);
						$item_temp_array['rate'] = 0;
						if($item_temp_array['qty'] != 0)
						{
							$item_temp_array['rate'] = (float)$item_temp_array['amount'] / (float)$item_temp_array['qty'];
						}
						
						$item_temp_array['discount_amt'] = 0;
						
						$vat = $this->stock->get_item_vat($sales_temp_data['item_id']);
    					$item_temp_array['vat'] = $vat;
    					
    				    if($const['vat_in_ex']=='1')
    					{
    				        $item_temp_array['taxable_amt'] = $item_temp_array['amount'];
    					}
    					else
    					{
                            $item_temp_array['taxable_amt'] = (((float)$item_temp_array['amount'])*100)/(100+(float)$vat+(float)$cess);
    					}
    					$item_temp_array['vat_amt'] = ((float)$item_temp_array['taxable_amt'] * (float)$vat) / 100;
    					$item_temp_array['cess_amt'] = ((float)$item_temp_array['taxable_amt'] * (float)$cess) / 100;
						
						$this->db->trans_start();

					    $this->sales_obj->update_others(array('table' => 'dms_sales_return_items','data' => $item_temp_array,'conditions' => array('id' => $sales_temp_id)));

						$this->sales_obj->update_others(array('table' => 'dms_sales_returns','data' => array('status' => -1),'conditions' => array('group_id' => $sales_temp_data['group_id'])));

						$this->message->set($this->lang->line('sales_return-edit-temp-success'));

						$stock_bal_temp = $this->stock->unit_conversion($sales_temp_data['item_id'],$item_temp_array['unit_id'],$item_temp_array['qty'],$item_temp_array['rate'],$item_temp_array['amount']);
						if($stock_bal_temp)
						{
							$this->sales_obj->update_others(array('table' => 'dms_stocks','data' => array('godown_id' => $item_temp_array['godown_id'],'qty' => $stock_bal_temp['qty'],'unit_id' => $stock_bal_temp['primary_unit'],'rate' => $stock_bal_temp['rate'],'amount' => $stock_bal_temp['amount'],'status' => $item_temp_array['status']),'conditions' => "(stock_status = 8 or stock_status = 7) and table_id = $sales_temp_id"));
						}

						$this->db->trans_complete();

						redirect($redirect_uri);
					}

					$voucher_name = $this->vouchers->voucher_name($this->vtype);

					$sales_cst = $this->stock->get_constant(array('sales_cst'));

					$presumptive_tax = $this->stock->get_tax_type();

				/*	$cst_status = $this->sales_obj->get_cst($sales_temp_data['group_id']);*/
				$cst_status = 0;
					if($cst_status)
					{
						$sales_cst = $cst_status;
					}

					$units = $goDowns = array();
					$item_details = $this->stock->get_item($sales_temp_data['item_id'],array('item_code','item_name'));
					$items[$sales_temp_data['item_id']] = $item_details['item_code']." / ".$item_details['item_name'];
					$goDowns = $this->stock->get_item_godowns(array('item_id'=>$sales_temp_data['item_id'],'listing'=>1));
					$goDowns[''] = 'Select';
					ksort($goDowns);
					$units = $this->stock->get_units($sales_temp_data['item_id']);

					$sale_date = $sales_temp_data['bill_date'];

					$stock_count = $this->stock->get_stock_count($sales_temp_data['godown_id'],$sales_temp_data['item_id'],$sale_date);

					$primary_unit = $this->stock->get_primary_unit($sales_temp_data['item_id']);

					$this->template->title("Update Sales Return Voucher");
					$this->template->main_heading($this->lang->line("$voucher_name"));
					$this->template->breadcrumb(array($this->lang->line("inventory-voucher") => 'no_link',$this->lang->line("$voucher_name") => 'sales_return/add',$this->lang->line("update") => 'no_link',$this->lang->line('report') => 'sales_return/report',$this->lang->line('go-back') => array($redirect_uri)));
					$this->template->slice('dms/message');
					$this->template->slice('sales/sales_return/edit_temp',array('voucher_name' => $voucher_name,'items' => $items,'units' => $units,'goDowns' => $goDowns,'sales_temp_data' => $sales_temp_data,'sales_cst' => $sales_cst,'presumptive_tax' => $presumptive_tax,'stock_count' => $stock_count,'unit_symbol' => $primary_unit['symbol'],'sale_date' => $sale_date));
					$this->template->other_script('sales/sales_return');
					$this->template->render();
				}
				else
				{
					redirect('users/logout');
				}
			}
			else
			{
				redirect('users/logout');
			}
		}
		else
		{
			redirect('users/logout');
		}
	}

	public function bill_no_exists($bill_no,$v_details = NULL)
	{
		if($v_details == NULL){
			$where = array('vtype_id' => $this->input->post('vtype_id',true),'bill_no' => $bill_no,'status !=' => 0);
		}
		else{
			$exp = explode('.', $v_details);
			$where = array('vtype_id' => $exp[0],'bill_no' => $bill_no,'group_id !=' => $exp[1],'status !=' => 0);
		}
		$row = $this->sales_obj->get_bills(array('columns' => array('id'),'conditions' => $where,'numrows' => true));
		if($row == 0){
			return true;
		}
		return false;
	}

	public function report()
	{
		$vtype_id = $this->vtype;
		$conditions = array('vtype_id' => $vtype_id,'status' => 1);
		$like_array = array();$vnos="";

		$voucher_name = $this->vouchers->voucher_name($this->vtype);

		$voucher_types = $this->vouchers->voucher_types($this->vtype);

		$uri_array  = $this->uri->uri_to_assoc(3);

		$redirect = "";

		$this->load->library('Pagination');
		$config['per_page'] = $this->per_page();
		# Pagination Config Customizations
        $config['full_tag_open'] = '<ul class="pagination">';
        $config['full_tag_close'] = '</ul>';
        $config['first_link'] = 'First';
        $config['last_link'] = 'Last';
        $config['next_link'] = '&raquo;';
        $config['prev_link'] = '&laquo;';
        $config['cur_tag_open'] = '<li class="active"><a href="#">';
        $config['cur_tag_close'] = '</a></li>';
        $config['num_tag_open'] = '<li>';
        $config['num_tag_close'] = '</li>';
		$config['base_url'] = base_url('sales_return/report');
		$config['uri_segment'] = 3;

		$cur_date = date('Y-m-d');
		$from_date = $cur_date;
		$to_date = $cur_date;
		$cur_fiscal_yr = $this->dms->get_fiscal_year();
		if($from_date < $cur_fiscal_yr['start_date'] || $from_date > $cur_fiscal_yr['end_date'] || $to_date < $cur_fiscal_yr['start_date'] || $to_date > $cur_fiscal_yr['end_date'])
		{
			$from_date = $cur_fiscal_yr['end_date'];
			$to_date = $cur_fiscal_yr['end_date'];
		}

		$this->form_validation->set_rules('vtype_id','voucher-types','required|xss_clean');
		$this->form_validation->set_rules('from_date','From Date','required|xss_clean|valid_date');
		$this->form_validation->set_rules('to_date','To Date','required|xss_clean|valid_date');
		$this->form_validation->set_rules('bill_no','bill-no','xss_clean|trim');
		if($this->form_validation->run() === true)
		{
			$vtype_id = $this->input->post('vtype_id',true);
			$from_date = date('Y-m-d',strtotime($this->input->post('from_date',true)));
			$to_date = date('Y-m-d',strtotime($this->input->post('to_date',true)));
			$conditions['vtype_id'] = $vtype_id;
			$config['base_url'] .= '/vt/'.$vtype_id.'/fdate/'.$from_date.'/tdate/'.$to_date;
			$config['uri_segment'] += 6;
			$redirect .= '/vt/'.$vtype_id.'/fdate/'.$from_date.'/tdate/'.$to_date;
			if(!empty($this->input->post('bill_no',true)))
			{
				$vnos = $this->input->post('bill_no',true);
				$like_array['bill_no'] = $vnos;
				$config['base_url'] .= '/vn/'.$vnos;
				$config['uri_segment'] += 2;
				$redirect .= '/vn/'.$vnos;
			}
		}
		elseif(isset($uri_array['vt']))
		{
			$vtype_id = $uri_array['vt'];
			$conditions['vtype_id'] = $vtype_id;
			$config['base_url'] .= '/vt/'.$conditions['vtype_id'];
			$config['uri_segment'] += 2;
			$redirect .= '/vt/'.$vtype_id;
			if(isset($uri_array['fdate']) && isset($uri_array['tdate']))
			{
				$from_date = date('Y-m-d',strtotime($uri_array['fdate']));
				$to_date = date('Y-m-d',strtotime($uri_array['tdate']));
				$config['base_url'] .= '/fdate/'.$from_date.'/tdate/'.$to_date;
				$config['uri_segment'] += 4;
				$redirect .= '/fdate/'.$from_date.'/tdate/'.$to_date;
			}
			if(isset($uri_array['vn']))
			{
				$vnos = $uri_array['vn'];
				$like_array['bill_no'] = $vnos;
				$config['base_url'] .= '/vn/'.$vnos;
				$config['uri_segment'] += 2;
				$redirect .= '/vn/'.$vnos;
			}
		}

		$between = "bill_date between '$from_date' and '$to_date'";

		$config['total_rows'] = $this->sales_obj->get_bills(array('columns' => array('id'),'conditions' => $conditions,'between' => $between,'like' => $like_array,'numrows'=>true));

		if($config['total_rows'] == 0)
		{
			$this->message->set($this->lang->line('no-voucher'),'i');
		}

		$offset = $this->uri->segment($config['uri_segment'],0);
		$this->pagination->initialize($config);
		$links = $this->pagination->create_links();
		$redirect .= '/'.$offset;

		$presumptive_tax = $this->stock->get_tax_type();

		$sales_array=$this->sales_obj->get_bills(array('conditions' => $conditions,'between' => $between,'like' => $like_array,'order_by'=>'bill_date','order'=>'DESC','limit'=>$config['per_page'],'offset'=>$offset));

		$this->template->title("Sales Return Report");
		$this->template->main_heading($this->lang->line("$voucher_name")." ".$this->lang->line("report"));
		$this->template->breadcrumb(array($this->lang->line("inventory-voucher") => 'no_link',$this->lang->line("$voucher_name") => 'sales_return/add',$this->lang->line('report') => 'no_link'));
		$this->template->slice('sales/sales_entry/search',array('voucher_types' => $voucher_types,'vtype_id' => $vtype_id,'vnos' => $vnos,'from_date' => $from_date,'to_date' => $to_date,'rtype' => 'sales_return'));
		$this->template->slice('dms/message');
		if(!empty($sales_array))
		{
			$this->template->slice('sales/sales_return/report',array('sales_array' => $sales_array,'presumptive_tax' => $presumptive_tax,'offset' => $offset,'links' => $links,'redirect' => $redirect));
			$this->template->slice('dms/modals/delete_confirm');
		}
		$this->template->other_script('sales/sales_return');
		$this->template->render();
	}

	public function view()
	{
		$vtype_id = $this->vtype;

		$uri_array = $this->uri->uri_to_assoc(3);
		if(isset($uri_array['id']) || isset($uri_array['group_id']))
		{
			$voucher_name = $this->vouchers->voucher_name($this->vtype);

			$breadcrumb = array($this->lang->line("inventory-voucher") => 'no_link',$this->lang->line("$voucher_name") => 'sales_return/add',$this->lang->line('report') => 'sales_return/report',$this->lang->line("view") => 'no_link');

			if($this->uri->segment(3) == 'group_id')
			{
				$conditions = array('a.group_id' => $this->uri->segment(4),'a.status !=' => 0,'b.status !=' => 0);
				if($this->uri->segment(5) && $this->uri->segment(5) == 'vt')
				{
					$breadcrumb_url = "daybooks/index/vt/".$this->uri->segment(6);
					$breadcrumb[$this->lang->line("go-back")] = $breadcrumb_url;
				}
				elseif($this->uri->segment(5) && ($this->uri->segment(5) == 'id' || $this->uri->segment(5) == 'mid' || $this->uri->segment(5) == 'sid'))
				{
					$breadcrumb_url = "stock_item_register/index/".$this->uri->segment(5)."/".$this->uri->segment(6);
					if($this->uri->segment(7) && $this->uri->segment(7) == 'rtype'){
						$breadcrumb_url .= "/rtype/".$this->uri->segment(8);
					}
					$breadcrumb[$this->lang->line("go-back")] = $breadcrumb_url;
				}
				elseif($this->uri->segment(5) && $this->uri->segment(5) == 'vp')
				{
					$breadcrumb[$this->lang->line("go-back")] = "vat_detailed_reports/index/ttyp/2/vp/".$this->uri->segment(6)."/fdate/".$this->uri->segment(8)."/tdate/".$this->uri->segment(10);
				}
				else
				{
					$breadcrumb_url = "ledger_reports/index/";
					if($this->uri->segment(5))
					{
						$breadcrumb_url .= $this->uri->segment(5);
					}
					if($this->uri->segment(6))
					{
						$breadcrumb_url .= "/sid/".$this->uri->segment(6);
					}
					if($this->uri->segment(7))
					{
						$breadcrumb_url .= "/tbp/".$this->uri->segment(7);
					}
					$breadcrumb[$this->lang->line("go-back")] = $breadcrumb_url;
				}
			}
			else
			{
				$sales_id = $uri_array['id'];
				unset($uri_array['id']);
				$conditions = array('a.id' => $sales_id,'a.status !=' => 0,'b.status !=' => 0);
				$breadcrumb[$this->lang->line("go-back")] = "sales_return/report/".$this->uri->assoc_to_uri($uri_array);
			}

			$sales_array = $this->sales_obj->get_sales(array('columns' => array('a.id as primary_id','a.vtype_id','a.group_id','a.bill_no','a.bill_date','a.return_bill_no','a.customer_type_id','a.customer_id','a.area_id','a.bill_discount_amt','a.bill_freight','a.other_expense','a.cess','a.narration','a.payment_mode','a.created_by','a.created_on','b.id','b.item_id','b.qty','b.unit_id','b.rate','b.amount','b.discount_amt','b.taxable_amt','b.godown_id','b.vat','b.vat_amt','b.cess_amt'),'conditions' => $conditions)); 
            
			$this->template->title("Sales Return Report");
			$this->template->main_heading($this->lang->line("$voucher_name")." ".$this->lang->line("view"));
			$this->template->breadcrumb($breadcrumb);
			$this->template->slice('dms/message');
			if(!empty($sales_array))
			{
				$this->load->model('customers/Customer_type_model','customer_type');

				$presumptive_tax = $this->stock->get_tax_type();

                /*$sales_cst = $this->sales_obj->get_cst($sales_array[0]['group_id']);*/
                $sales_cst = 0;
				$voucher_type = $this->vouchers->voucher_name($sales_array[0]['vtype_id']);
				$customer_name = $this->stock->get_customer($sales_array[0]['customer_type_id'],$sales_array[0]['customer_id']);
				$area_id = $this->dms->get_area($sales_array[0]['area_id']);
				$payment_mode = $this->stock->ledger_name($sales_array[0]['payment_mode']);

				$return_bill_no = "";
				if($sales_array[0]['return_bill_no'] > 0)
				{
					$return_bill_no = $this->sales_obj->get_bill_no($sales_array[0]['return_bill_no']);
				}

				$cd_status = 1;$ccd = $cd_no = $pdc = "";
				$cheque_dd_array = $this->vouchers->cheque_data(array('columns' => array('b.cash_type','b.cd_no','b.pdc'),'conditions' => array('a.table_name' => 'dms_sales_returns','a.table_group_id' => $sales_array[0]['group_id'])));
				if(!empty($cheque_dd_array))
				{
					$cd_status = 0;
					$ccd = $cheque_dd_array[0]['cash_type'];
					$cd_no = $cheque_dd_array[0]['cd_no'];
					$pdc = $cheque_dd_array[0]['pdc'];
				}

				$this->template->slice('sales/sales_return/view',array('sales_array' => $sales_array,'return_bill_no' => $return_bill_no,'presumptive_tax' => $presumptive_tax,'sales_cst' => $sales_cst,'voucher_type' => $voucher_type,'customer_name' => $customer_name,'area_id' => $area_id,'payment_mode' => $payment_mode,'cd_status' => $cd_status,'ccd' => $ccd,'cd_no' => $cd_no,'pdc' => $pdc));
			}
			$this->template->other_script('sales/sales_return');
			$this->template->render();
		}
		else
		{
			redirect('users/logout');
		}
	}

	public function update()
	{
		$vtype_id = $this->vtype;

		$uri_array = $this->uri->uri_to_assoc(3);
		if(isset($uri_array['id']))
		{
			$sales_id = $uri_array['id'];
			$redirect = "/".$this->uri->assoc_to_uri($uri_array);
			unset($uri_array['id']);

			$redirect_uri = "sales_return/report/".$this->uri->assoc_to_uri($uri_array);

			$update_uri = $this->uri->assoc_to_uri($this->uri->uri_to_assoc(1));

			$voucher_name = $this->vouchers->voucher_name($this->vtype);

		/*	$sales_cst = $this->stock->get_constant(array('sales_cst'));*/
		$sales_cst = 0;

			$presumptive_tax = $this->stock->get_tax_type();

			$cess = $this->stock->get_cess();
			$const = $this->stock->get_constant();

			$item_details = $this->sales_obj->get_group($sales_id);

			if(isset($_POST['btn_add']))
			{
				$rules = "callback_check_bill_qty";
				if($item_details['return_bill_no'] > 0)
				{
					$rules = "callback_check_bill_qty[$item_details[return_bill_no]]";
				}

				$this->form_validation->set_rules('item_id','lang:item-name','required|xss_clean|is_natural_no_zero');
				$this->form_validation->set_rules('qty','lang:quantity','required|xss_clean|greater_than[0]|less_than[100000000]');
				$this->form_validation->set_rules('unit_id','lang:unit','required|xss_clean');
				$this->form_validation->set_rules('rate','lang:rate','required|xss_clean|greater_or_equal[0]|less_than[100000000]');
				$this->form_validation->set_rules('amount','lang:amount','xss_clean|required|greater_or_equal[0]|less_than[100000000]');

				if($this->form_validation->run('btn_add') === true)
				{
					$item_array['group_id'] = $item_details['group_id'];
					$item_array['item_id'] = $this->input->post('item_id',true);
					$item_array['qty'] = $this->input->post('qty',true);
					$item_array['unit_id'] = $this->input->post('unit_id',true);
					$item_array['amount'] = $this->input->post('amount',true);
					
					$item_array['rate'] = 0;
					if($item_array['qty'] != 0)
					{
						$item_array['rate'] = (float)$item_array['amount'] / (float)$item_array['qty'];
					}

					$item_array['godown_id'] = $this->stock->get_branch_godown($this->branchID);
					$item_array['status'] = -1;
					
					$sales_temp_item_result = $this->sales_obj->get_sales(array('columns' => array('b.id'),'conditions' => array('b.group_id' => $item_array['group_id'],'item_id' => $item_array['item_id'],'godown_id' => $item_array['godown_id'],'unit_id' => $item_array['unit_id'],'a.status !=' => 0,'b.status !=' => 0),'numrows' => true));
					if($sales_temp_item_result == 0)
					{
						$vat = $this->stock->get_item_vat($item_array['item_id']);
    					$item_array['vat'] = $vat;
    					
    				    if($const['vat_in_ex']=='1')
    					{
    				        $item_array['taxable_amt'] = (float)$item_array['amount']-(float)$item_array['discount_amt'];
    					}
    					else
    					{
                            $item_array['taxable_amt'] = (((float)$item_array['amount']-(float)$item_array['discount_amt'])*100)/(100+(float)$vat+(float)$cess);
    					}
    					$item_array['vat_amt'] = ((float)$item_array['taxable_amt'] * (float)$vat) / 100;
    					$item_array['cess_amt'] = ((float)$item_array['taxable_amt'] * (float)$cess) / 100;
    					
						$this->db->trans_start();

						$sales_items_id = $this->sales_obj->insert("dms_sales_return_items",$item_array);
						if($sales_items_id)
						{
							$this->sales_obj->insert('dms_stocks',array('company_id' => $this->session->userdata('company_id'),'branch_id' => $this->session->userdata('under_id'),'godown_id' => $item_array['godown_id'],'item_id' => $item_array['item_id'],'qty' => $item_array['qty'],'unit_id' => $item_array['unit_id'],'rate' => $item_array['rate'],'amount' => $item_array['amount'],'stock_date' => $item_details['bill_date'],'stock_status' => 8,'table_group_id' => $item_array['group_id'],'table_id' => $sales_items_id));
							$this->message->set($this->lang->line('sales_return-add-success'));
						}
						else
						{
							$this->message->set($this->lang->line('sales_return-add-error'),'e');
						}

						$this->db->trans_complete();
					}
					else
					{
						$this->message->set($this->lang->line('sales_return-add-error'),'e');
					}
					redirect($update_uri);
				}
			}

			if(isset($_POST['btn_update']))
			{
				$this->form_validation->set_rules('bill_no','lang:bill-no',"required|xss_clean|is_natural_no_zero|callback_bill_no_exists[$item_details[vtype_id].$item_details[group_id]]");
				$this->form_validation->set_rules('bill_date','lang:bill-date','required|xss_clean|valid_date');
				$this->form_validation->set_rules('payment_mode','lang:payment-mode','required|xss_clean');
				if($this->input->post('payment_mode',true) > 2)
				{
					$this->form_validation->set_rules('ccd','lang:transaction-type','required|xss_clean');
					$this->form_validation->set_rules('cd_no','lang:cd-no','required|xss_clean|max_length[64]');
					$this->form_validation->set_rules('cheque_date','lang:cheque-date',"required|xss_clean|is_date|check_date[$item_details[bill_date].>=]");
				}
				$this->form_validation->set_rules('remarks','lang:remarks','xss_clean');
				$this->form_validation->set_rules('freight','lang:freight','xss_clean|greater_or_equal[0]|less_than[100000000]');
				$this->form_validation->set_rules('other_expense','lang:other-expense','xss_clean|greater_or_equal[0]|less_than[100000000]');
                $this->form_validation->set_rules('bill_discount_amt','lang:discount','xss_clean|greater_or_equal[0]|less_than[100000000]');

				if($this->form_validation->run('btn_update') === true)
				{
					$bill_date = date('Y-m-d',strtotime($this->input->post('bill_date',true)));
					$bill_no = $this->input->post('bill_no',true);
					$narration = $this->input->post('remarks',true);
					$payment_mode = $this->input->post('payment_mode',true);
					$freight = $this->input->post('freight',true);
					$other_expense = $this->input->post('other_expense',true);
                    $bill_discount_amt = $this->input->post('bill_discount_amt',true);
					$sales_entry_array=array('bill_no' => $bill_no,'bill_date' => $bill_date,'bill_discount_amt' => $bill_discount_amt,'bill_freight' => $freight,'other_expense' => $other_expense,'cess' => $cess,'narration' => $narration,'payment_mode' => $payment_mode,'status' => 1);

					$this->db->trans_start();

					if($this->sales_obj->update(array('table' => 'dms_sales_returns','data' => $sales_entry_array,'conditions' => array('id' => $sales_id))))
					{
						$voucher_amount=0;
					    if($bill_discount_amt>0)
                        {
                            $bill_total=0;
                            $sales_items_array1 = $this->sales_obj->get_sales_items(array('columns' => array('qty','rate'),'conditions' => array('group_id' => $item_details['group_id'],'status!=' => 0)));
   						    
   						    foreach($sales_items_array1 as $key1 => $value1)
    						{
								(float)$bill_total += (float)$value1['qty']*(float)$value1['rate'];
    						}
   						
   						    $bill_discount_per = ((float)$bill_discount_amt/(float)$bill_total)*100;
   						
   						    $sales_items_array = $this->sales_obj->get_sales_items(array('columns' => array('id','item_id','qty','unit_id','rate','godown_id'),'conditions' => array('group_id' => $item_details['group_id'],'status!=' => 0)));
   						    
    						foreach($sales_items_array as $key => $value)
    						{
    						    $it_up_id = $value['id'];
    						    $itid = $value['item_id']; 
    						    $itamt = $value['qty']*$value['rate'];
    						    $itdiscamt = ((float)$itamt*(float)$bill_discount_per)/100;
    						    $it_vat = $this->stock->get_item_vat($itid);
    						    
    						    if($const['vat_in_ex']=='1')
            					{
            				        $it_taxable = (float)$itamt-(float)$itdiscamt;
            					}
            					else
            					{
                                    $it_taxable = (((float)$itamt-(float)$itdiscamt)*100)/(100+(float)$it_vat+(float)$cess);
            					}
    						    
    						    $it_vat_amt = ((float)$it_taxable*(float)$it_vat)/100; 
    						    $it_cess_amt = ((float)$it_taxable*(float)$cess)/100; 
    						    
    						    (float)$voucher_amount += (float)$it_taxable+(float)$it_vat_amt+(float)$it_cess_amt;
    						    
    						    $it_up_array = array('discount_amt'=>$itdiscamt,'taxable_amt'=>$it_taxable,'vat'=>$it_vat,'vat_amt'=>$it_vat_amt,'cess_amt'=>$it_cess_amt);
    						
    						    $this->sales_obj->update(array('table' => 'dms_sales_return_items','data' => $it_up_array,'conditions' => array('id' => $it_up_id)));
    						}
    						(float)$voucher_amount += (float)$freight+(float)$other_expense;
                        }
                        else
                        {
                            $voucher_amount = $this->input->post('grand_total',true);
    					}
    					
						$this->sales_obj->update_others(array('table' => 'dms_sales_return_items','data' => array('status' => 1),'conditions' => array('group_id' => $item_details['group_id'],'status !=' => 0)));

						$this->sales_obj->update_others(array('table' => 'dms_stocks','data' => array('status' => 1),'conditions' => "table_group_id = ".$item_details['group_id']." and (stock_status = 7 or stock_status = 8)"));

						if($item_details['customer_type_id'] == 2)//customer
						{
							$customer = $this->dms->get_data(array('table' => 'customer_master','columns' => 'ledger_id','conditions' => array('id' => $item_details['customer_id'])));
						}
						elseif($item_details['customer_type_id'] == 3)//AR
						{
							$customer = $this->dms->get_data(array('table' => 'retailer_master','columns' => 'ledger_id','conditions' => array('id' => $item_details['customer_id'])));
						}
						else//branch
						{
							$customer = $this->dms->get_data(array('table' => 'branch_master','columns' => 'ledger_id','conditions' => array('id' => $item_details['customer_id'])));
						}

						$voucher_status = 1;
						if($payment_mode > 2)
						{
							$bill_date_time = strtotime($bill_date);
							$cheque_date = date('Y-m-d',strtotime($this->input->post('cheque_date',true)));
							$cheque_date_time = strtotime($cheque_date);
							if($this->input->post('ccd',true) == 1 && $cheque_date_time > $bill_date_time)
							{
								$voucher_status = 3;
							}
						}
						elseif($payment_mode == 2)
						{
							$payment_mode = $customer[0]['ledger_id'];
						}
                        
                        $voucher_data = $this->dms->get_data(array('table' => 'dms_vouchers','columns' => array('id','group_id'),'conditions' => array('table_name' => 'dms_sales_returns','table_group_id' => $item_details['group_id']),'order_by' => 'vorder_no','order' => 'asc','limit' => 1,'offset' => 0));
						if(empty($voucher_data))
						{
							$voucher_group_id = $this->stock->get_group_id('dms_vouchers');
							$voucher_array = array('company_id' => $this->session->userdata('company_id'),'branch_id' => $this->session->userdata('under_id'),'group_id' => $voucher_group_id,'vtype_id' => $item_details['vtype_id'],'vno' => $bill_no,'vorder_no' => 1,'vdate' => $bill_date,'dr_ledger' => 6,'cr_ledger' => $payment_mode,'vamount' => $voucher_amount,'narration' => $narration,'table_name' => 'dms_sales_returns','table_group_id' => $item_details['group_id'],'status' => $voucher_status);

							$voucher_success = $this->sales_obj->insert('dms_vouchers',$voucher_array);
							if($voucher_success)
							{
								if($payment_mode > 2)
								{
									$this->sales_obj->insert('dms_voucher_banks',array('group_id' => $voucher_group_id,'cash_type' => $this->input->post('ccd',true),'cd_no' => $this->input->post('cd_no',true),'pdc' => $cheque_date,'vdate' => $bill_date));
								}
							}
						}
						else
						{
							$voucher_array = array('vno' => $bill_no,'vdate' => $bill_date,'cr_ledger' => $payment_mode,'vamount' => $voucher_amount,'narration' => $narration,'status' => $voucher_status);
							$voucher_success = $this->sales_obj->update_others(array('table' => 'dms_vouchers','data' => $voucher_array,'conditions' => array('id' => $voucher_data[0]['id'])));
							if($voucher_success)
							{
								if($payment_mode > 2)
								{
									if($this->dms->get_data(array('table' => 'dms_voucher_banks','columns' => array('id'),'conditions' => array('group_id' => $voucher_data[0]['group_id']),'numrows' => true)) == 0)
									{
										$this->sales_obj->insert('dms_voucher_banks',array('group_id' => $voucher_data[0]['group_id'],'cash_type' => $this->input->post('ccd',true),'cd_no' => $this->input->post('cd_no',true),'pdc' => $cheque_date,'vdate' => $bill_date));
									}
									else
									{
										$this->sales_obj->update_others(array('table' => 'dms_voucher_banks','data' => array('cash_type' => $this->input->post('ccd',true),'cd_no' => $this->input->post('cd_no',true),'pdc' => $cheque_date,'vdate' => $bill_date),'conditions' => array('group_id' => $voucher_data[0]['group_id'])));
									}
								}
							}
						}
						$this->message->set($this->lang->line('sales_return-edit-success'));
					}
					else
					{
						$this->message->set($this->lang->line('sales_return-edit-error'),'e');
					}

					$this->db->trans_complete();

					redirect('sales_return/report');
				}
			}

			$sales_array = $this->sales_obj->get_sales(array('columns' => array('a.vtype_id','a.bill_no','a.bill_date','a.group_id','a.return_bill_no','a.customer_type_id','a.customer_id','a.area_id','a.bill_discount_amt','a.bill_freight','a.other_expense','a.cess','a.narration','a.payment_mode','a.status','a.sid','a.s_status','a.created_by','b.id','b.item_id','b.qty','b.unit_id','b.rate','b.amount','b.discount_amt','b.taxable_amt','b.godown_id','b.vat','b.vat_amt','b.cess_amt'),'conditions' => array('a.id' => $sales_id,'a.status !=' => 0,'b.status !=' => 0)));
			
			if(!empty($sales_array))
			{
				$continue = 1;
				if($sales_array[0]['status'] == -1){
					if($sales_array[0]['created_by'] != $this->session->userdata('id')){
						$continue = 0;
					}
				}
				if($continue == 1)
				{
					$stock_count = $primary_unit['symbol'] = "";

					$this->load->model('customers/Customer_type_model','customer_type');

				/*	$cst_status = $this->sales_obj->get_cst($sales_array[0]['group_id']);*/
				$cst_status = 0;
					if($cst_status)
					{
						$sales_cst = $cst_status;
					}

					$customer_name = $this->stock->get_customer($sales_array[0]['customer_type_id'],$sales_array[0]['customer_id']);

					$units = $goDowns = array();
					$units[''] = "Select";

					$return_bill_no = "";
					if($sales_array[0]['return_bill_no'] == 0)
					{
						$args['select'] = array('id','item_code','item_name');
						$items = $this->stock->get_stock_items($args);
					}
					else
					{
						$return_bill_no = $this->sales_obj->get_bill_no($sales_array[0]['return_bill_no']);
						$items = $this->sales_obj->get_bill_items($sales_array[0]['return_bill_no']);
					}

					$payment_modes = $this->stock->payment_modes();

					if(empty($items))
					{
						$this->message->set($this->lang->line('no-items-found'),'i');
					}

					if($this->input->post('item_id',true))
					{
						$itemID = $this->input->post('item_id',true);
						$goDowns = $this->stock->get_item_godowns(array('item_id'=>$itemID,'listing'=>1));
						$units = $this->stock->get_units($itemID);
					}

					if($this->input->post('item_id',true) && $this->input->post('godown_id',true) && $sales_array[0]['bill_date'] != "")
					{
						$stock_count = $this->stock->get_stock_count($this->input->post('godown_id',true),$this->input->post('item_id',true),$sales_array[0]['bill_date']);
						$primary_unit = $this->stock->get_primary_unit($this->input->post('item_id',true));
					}
					$voucher_type = $this->vouchers->voucher_name($sales_array[0]['vtype_id']);

					$this->load->model('areas/Area_model','area');
					$areas = $this->area->listing();

					$cd_status = 1;$ccd = $cd_no = $pdc = "";
					$cheque_dd_array = $this->vouchers->cheque_data(array('columns' => array('b.cash_type','b.cd_no','b.pdc'),'conditions' => array('a.table_name' => 'dms_sales_returns','a.table_group_id' => $sales_array[0]['group_id'])));
					if(!empty($cheque_dd_array))
					{
						$cd_status = 0;
						$ccd = $cheque_dd_array[0]['cash_type'];
						$cd_no = $cheque_dd_array[0]['cd_no'];
						$pdc = $cheque_dd_array[0]['pdc'];
					}

					$areas[''] = 'Select';ksort($areas);
					$items[''] = 'Select';ksort($items);
					
					$this->template->title("Edit Sales Return");
					$this->template->main_heading($this->lang->line("edit")." ".$this->lang->line("$voucher_name"));
					$this->template->breadcrumb(array($this->lang->line("inventory-voucher") => 'no_link',$this->lang->line("$voucher_name") => 'sales_return/add',$this->lang->line('report') => 'sales_return/report',$this->lang->line("update") => 'no_link',$this->lang->line("go-back") => array($redirect_uri)));
					$this->template->slice('dms/message');
					$this->template->slice('sales/sales_return/edit',array('sales_array' => $sales_array,'presumptive_tax' => $presumptive_tax,'sales_cst' => $sales_cst,'voucher_type' => $voucher_type,'customer_name' => $customer_name,'payment_mode' => $sales_array[0]['payment_mode'],'voucher_name' => $voucher_name,'payment_modes' => $payment_modes,'items' => $items,'goDowns' => $goDowns,'units' => $units,'stock_count' => $stock_count,'primary_unit' => $primary_unit['symbol'],'areas' => $areas,'return_bill_no' => $return_bill_no,'cd_status' => $cd_status,'ccd' => $ccd,'cd_no' => $cd_no,'pdc' => $pdc,'redirect' => $redirect));
					$this->template->other_script('sales/sales_return');
					$this->template->render();
				}
				else
				{
					redirect('users/logout');
				}
			}
			else
			{
				redirect('users/logout');
			}
		}
		else
		{
			redirect('users/logout');
		}
	}

	public function delete()
	{
		$uri_array = $this->uri->uri_to_assoc(3);
		if(isset($uri_array['id']))
		{
			$id = $uri_array['id'];
			unset($uri_array['id']);

			$redirect_uri = "sales_return/report/".$this->uri->assoc_to_uri($uri_array);

			$result = $this->sales_obj->get_sales(array('columns' => array('a.group_id','a.return_bill_no','a.status','a.sid','a.s_status','a.created_by','b.id'),'conditions' => array('a.id' => $id,'a.status !=' => 0)));

			if(!empty($result))
			{
				$row = $result[0];$continue = 1;
				if($row['status'] == -1)
				{
					if($row['created_by'] != $this->session->userdata('id'))
					{
						$continue = 0;
					}
				}
				if($continue == 1)
				{
					if($this->sales_obj->update_others(array('table' => 'dms_sales_returns','data' => array('status' => 0),'conditions' => array('id' => $id))))
					{
						$this->sales_obj->update_others(array('table' => 'dms_vouchers','data' => array('status' => 0),'conditions' => array('table_name' => 'dms_sales_returns','table_group_id' => $row['group_id'])));

						if($row['s_status'] != 2 || ($row['s_status'] == 2 && $row['status'] == -1))
						{
							$this->sales_obj->update_others(array('table' => 'dms_sales_return_items','data' => array('status' => 0),'conditions' => array('group_id' => $row['group_id'])));
						}
						else
						{
							$this->sales_obj->update_others(array('table' => 'dms_rejection_ins','data' => array('s_status' => 0),'conditions' => array('id' => $row['sid'])));
						}

						if($row['return_bill_no'] > 0)
						{
							$this->sales_obj->update_others(array('table' => 'dms_sales','data' => array('bill_status' => 0),'conditions' => array('id' => $row['return_bill_no'])));
						}

						foreach($result as $key => $value)
						{
							$this->sales_obj->update_others(array('table' => 'dms_stocks','data' => array('status' => 0),'conditions' => array('table_id' => $value['id'],'stock_status' => 8)));
						}
						$this->message->set($this->lang->line('sales_return-delete-success'));
					}
					else
					{
						$this->message->set($this->lang->line('sales_return-delete-error'),'e');
					}
				}
				else
				{
					redirect('users/logout');
				}
			}
			redirect($redirect_uri);
		}
		redirect('users/logout');
	}

	public function check_bill_qty($qty,$values = NULL)
	{
		if($this->input->post('return_bill_no',true) && $this->input->post('return_bill_no',true) != ""){
			$item_id = $this->input->post('item_id',true);
			$bill_id = $this->input->post('return_bill_no',true);
			$count = $this->sales_obj->get_item_count($bill_id,$item_id);
			$qty += $this->sales_obj->get_sales_return_item_count($bill_id,$item_id);
			if($qty > $count){
				return false;
			}
			return true;
		}
		elseif($values != NULL){
			$exp = explode(".",$values);
			$bill_id = $exp[0];
			if($this->input->post('item_id',true) && $this->input->post('item_id',true) != ""){
				$item_id = $this->input->post('item_id',true);
				$qty += $this->sales_obj->get_sales_return_item_count($bill_id,$item_id);
			}
			else{
				$item_id = $exp[1];
				$purchase_return_item_id = $exp[2];
				$qty += $this->sales_obj->get_sales_return_item_count($bill_id,$item_id,$purchase_return_item_id);
			}
			$count = $this->sales_obj->get_item_count($bill_id,$item_id);
			if($qty > $count){
				return false;
			}
			return true;
		}
	}

	public function pdf()
	{
		$pdf_name = 'sales_return';
		$pdf_contents = '';
		if(!$this->uri->segment(4))
		{
			echo "<script>alert('".$this->lang->line('invalid-sales-return-bill')."');window.close();</script>";
		}
		$sales_id = $this->uri->segment(4);
		if($this->if_exists('dms_sales_returns',array('id'=>$sales_id,'status'=>1)) === false)
		{
			echo "<script>alert('".$this->lang->line('invalid-sales-return-bill')."');window.close();</script>";
		}
		
		$vtype_id = $this->vtype;

		$voucher_name = $this->vouchers->voucher_name($this->vtype);

		$this->load->library('My_pdf');
		$this->load->library('To_words');
		$this->my_pdf->set_tin();
		$this->my_pdf->set_header();

		$sales_array = $this->sales_obj->get_sales(array('columns' => array('a.vtype_id','a.group_id','a.bill_no','a.bill_date','a.return_bill_no','a.customer_type_id','a.customer_id','a.area_id','a.bill_freight','a.other_expense','a.bill_discount_amt','a.cess','a.narration','a.payment_mode','a.created_by','a.created_on','b.id','b.item_id','b.qty','b.unit_id','b.rate','b.amount','b.discount_amt','b.taxable_amt','b.godown_id','b.vat','b.vat_amt','b.cess_amt'),'conditions' =>array('a.id' => $sales_id,'a.status !=' => 0,'b.status !=' => 0)));

		if(empty($sales_array))
		{
			echo "<script>alert('".$this->lang->line('invalid-sales-return-bill')."');window.close();</script>";
		}
		else
		{
			$this->load->model('customers/Customer_type_model','customer_type');
			
			$presumptive_tax = $this->stock->get_tax_type();
			
			/*$sales_cst = $this->sales_obj->get_cst($sales_array[0]['group_id']);*/
			$sales_cst = 0;
			$voucher_type = $this->vouchers->voucher_name($sales_array[0]['vtype_id']);
			$customer_name = $this->stock->get_customer($sales_array[0]['customer_type_id'],$sales_array[0]['customer_id']);
			$area_id = $this->dms->get_area($sales_array[0]['area_id']);
			$payment_mode = $this->stock->ledger_name($sales_array[0]['payment_mode']);

			$pdf_contents = $this->load->view('sales/sales_return/sales_return_pdf',array('sales_array' => $sales_array,'presumptive_tax' => $presumptive_tax,'sales_cst' => $sales_cst,'voucher_type' => $voucher_type,'customer_name' => $customer_name,'area_id' => $area_id,'payment_mode' => $payment_mode,'vehicle_details'=>$sales_return_vehicles),true);
		}
		
		$this->my_pdf->output($pdf_name,$pdf_contents);
	}
}
?>