<?php if( ! defined('BASEPATH')) exit ('No direct script access allowed');
	
	Class Sales_rpt extends MY_Controller{

		function __construct(){
			parent :: __construct();
			$this->check_access_right();
		}

		#----------------------------------------

		#date : 08-10-2014
		#purpose : AR-wise sales report
		function arwise(){

			$from = $to = $ar_id = ''; #dummy

			if($this->form_validation->run() == TRUE || $this->uri->segment(4)){

				$this->load->model('sales/Sales_model','sales');
				$this->load->model('sales/Sale_report_model','sr');
				$this->load->library('Pagination');

				$from = $this->input->post('from')?$this->input->post('from',TRUE):$this->uri->segment(3);
				$to = $this->input->post('to')?$this->input->post('to',TRUE):$this->uri->segment(4);
				$ar_id = $this->input->post('ar_id')?$this->input->post('ar_id',TRUE):$this->uri->segment(5);

				$config['total_rows'] = $this->sr->ar_approved_sales($ar_id,$from,$to,array('total'=>true));
				$config['per_page'] = $this->per_page();
				# Pagination Config Customizations
				$config['full_tag_open'] = '<ul class="pagination">';
				$config['full_tag_close'] = '</ul>';
				$config['first_link'] = 'First';
				$config['last_link'] = 'Last';
				$config['next_link'] = '&raquo;';
				$config['prev_link'] = '&laquo;';
				$config['cur_tag_open'] = '<li class="active"><a href="#">';
				$config['cur_tag_close'] = '</a></li>';
				$config['num_tag_open'] = '<li>';
				$config['num_tag_close'] = '</li>';
				$config['base_url'] = base_url().'sales_rpt/arwise/'.date('Y-m-d',strtotime($from)).'/'.date('Y-m-d',strtotime($to)).'/'.$ar_id;
				$config['uri_segment'] = 6;

				$this->pagination->initialize($config);
				$offset = $this->uri->segment(6,0);
				$links = $this->pagination->create_links();
				
				$sales = $this->sr->ar_approved_sales($ar_id,$from,$to,array('offset'=>$offset,'limit'=>$config['per_page']));
				#echo $this->db->last_query();die;

				if(empty($sales)){
					$this->message->set($this->lang->line('no-sales-found'),'i');
				}else{
					$this->template->append('sales/report/ar_wise_report_table',array('sales'=>$sales,'links'=>$links,'offset'=>$offset));
				}
			}

			#item listing
			$this->load->model('retailers/Counter_model','ar');
			$ars = $this->ar->listing();

			$this->template->title('AR wise sales report');
			$this->template->main_heading($this->lang->line('ar-wise-sales-report'));
			$this->template->breadcrumb(array($this->lang->line('sales-report')=>'sales_rpt/index',$this->lang->line('ar-wise-sales-report')=>'no_link'));
			$this->template->slice('sales/report/ar_wise',array('ars'=>$ars,'from'=>$from,'to'=>$to,'ar_id'=>$ar_id));
			$this->template->slice('dms/message');
			$this->template->render();
		}

		#----------------------------------------

		#date : 09-10-2014
		#purpose : Branch wise sales report
		function branchwise(){
			$from = $to = $branch_id = ''; #dummy

			if($this->form_validation->run() == TRUE || $this->uri->segment(4)){

				$this->load->model('sales/Sales_model','sales');
				$this->load->model('sales/Sale_report_model','sr');
				$this->load->library('Pagination');

				$from = $this->input->post('from')?$this->input->post('from',TRUE):$this->uri->segment(3);
				$to = $this->input->post('to')?$this->input->post('to',TRUE):$this->uri->segment(4);
				$branch_id = $this->input->post('branch_id')?$this->input->post('branch_id',TRUE):$this->uri->segment(5);

				$config['total_rows'] = $this->sr->branch_approved_sales($branch_id,$from,$to,array('total'=>true));
				$config['per_page'] = $this->per_page();
				# Pagination Config Customizations
				$config['full_tag_open'] = '<ul class="pagination">';
				$config['full_tag_close'] = '</ul>';
				$config['first_link'] = 'First';
				$config['last_link'] = 'Last';
				$config['next_link'] = '&raquo;';
				$config['prev_link'] = '&laquo;';
				$config['cur_tag_open'] = '<li class="active"><a href="#">';
				$config['cur_tag_close'] = '</a></li>';
				$config['num_tag_open'] = '<li>';
				$config['num_tag_close'] = '</li>';
				$config['base_url'] = base_url().'sales_rpt/branchwise/'.date('Y-m-d',strtotime($from)).'/'.date('Y-m-d',strtotime($to)).'/'.$branch_id;
				$config['uri_segment'] = 6;

				$this->pagination->initialize($config);
				$offset = $this->uri->segment(6,0);
				$links = $this->pagination->create_links();
				
				$sales = $this->sr->branch_approved_sales($branch_id,$from,$to,array('offset'=>$offset,'limit'=>$config['per_page']));
				#echo $this->db->last_query();die;

				if(empty($sales)){
					$this->message->set($this->lang->line('no-sales-found'),'i');
				}else{
					$this->template->append('sales/report/ar_wise_report_table',array('sales'=>$sales,'links'=>$links,'offset'=>$offset));
				}
			}

			#branches listing
			$this->load->model('branches/Branch_model','branch');
			$branches = $this->branch->listing();
			$this->template->title('Branch wise sales report');
			$this->template->main_heading($this->lang->line('branch-wise-sales-report'));
			$this->template->breadcrumb(array($this->lang->line('sales-report')=>'sales_rpt/index',$this->lang->line('branch-wise-sales-report')=>'no_link'));
			$this->template->slice('sales/report/branch_wise',array('branches'=>$branches,'from'=>$from,'to'=>$to,'branch_id'=>$branch_id));
			$this->template->slice('dms/message');
			$this->template->render();
		}

		#----------------------------------------
	}
?>