<?php if( ! defined('BASEPATH')) exit ('No direct script access allowed');
	
	class Staff extends MY_Controller{

		public function __construct(){
			parent :: __construct();
			$this->check_access_right();

			$this->load->model('designations/Designation_master_model','desig');
			$this->load->model('branches/Branch_model','branch');
			$this->load->model('employees/Staff_leave_model','leave');
			$this->load->library('Dms');
			$this->companyID = $this->session->userdata('company_id');
			$this->branchID = $this->session->userdata('under_id');
			$this->createdBY = $this->session->userdata('id');
			
			#---------------- Checking Financial year is enabled / closed -----------------#
			$method_array = array('employees','delete_e_target','update_e_target','e_set','emp_full','t_search','achievements','delete_achievements','view_achievements');
			fiscal_status($this->uri->segment(2),$method_array,"targets/t_search");
			#---------------- Checking Financial year is enabled / closed -----------------#
		
		}

		#----------------------------------------------------

		# date: 13-02-2015
		# purpose: to siplay staff settings
		public function index(){

			$this->template->title('Staff Settings');
			$this->template->main_heading($this->lang->line('employee-settings'));
			$this->template->sub_heading($this->lang->line('settings'));
			$this->template->breadcrumb(array($this->lang->line('settings')=>'preferences/',$this->lang->line('employee-settings')=>'no_link'));
			
			#get all general link assigned for this employee
			$this->db->select('mm.*');
			$this->db->from('menu_master mm');
			if($this->session->userdata('user_desig') != -1){
				$this->db->join('user_privileges up','up.menu_id=mm.id');
				$this->db->where('up.user_group','individual');
				$this->db->where('up.owner_id',$this->session->userdata('id'));
			}			
			$this->db->where_in('mm.menu_group',array('employee-settings'));
			$this->db->where('menu_status',1);
			$this->db->order_by('menu_order','ASC');
			$menus = $this->db->get()->result_array();

			$this->template->slice('employees/general/link_list',array('menus'=>$menus));
			$this->template->render();
			}

		#----------------------------------------------------
		# purpose: to create leave types
		public function leave_types(){

			$this->template->title($this->lang->line('leave-types'));
			$this->template->main_heading($this->lang->line('leave-types'));
			$this->template->breadcrumb(array($this->lang->line('settings')=>'preferences/',$this->lang->line('employee-settings')=>'staff/index',$this->lang->line('leave-types')=>'no_link'));

			#set validation rules
			$this->form_validation->set_rules('leave_type','leave-code','trim|xss_clean|required|is_unique[employee_leave_type.leave_type]');			
			$this->form_validation->set_rules('type_description','leave-name','trim|required');
			$this->form_validation->set_rules('type_color','color','required');			
			if($this->form_validation->run() === TRUE){

				$data = $this->input->post(NULL,true);
				$data['company_id'] = $this->session->userdata('company_id');
				$data['status'] = 1;
				if($this->leave->f_save('employee_leave_type',$data)){
					$this->message->set($this->lang->line('ltype_save_msg'));
				}else{
					$this->message->set($this->lang->line('ltype_save_err_msg'),'e');
				}
				redirect('staff/leave_types');
			}

			#fetch types from table and display
			$ltypes = $this->leave->get_all(array('company_id'=>$this->session->userdata('company_id'),'status'=>1),1);
			//echo $this->db->last_query();die;
			$this->template->append('employees/leaves/add_leave_types',array('ltypes'=>$ltypes));
			$this->template->slice('dms/message');
			$this->template->render();
			}


		#----------------------------------------------------

		#purpose: to update leave types
		public function update_leave_types(){

	 		if(!$this->uri->segment(3)){ 
				redirect('users/logout');
			}
			$type_id = $this->uri->segment(3);
			if($this->if_exists('employee_leave_type',array('id'=>$type_id,'status'=>1)) === false){
				redirect('staff/leave_types');
			}
						
			$this->template->title($this->lang->line('leave-types'));
			$this->template->main_heading($this->lang->line('leave-types'));
			$this->template->breadcrumb(array($this->lang->line('settings')=>'preferences/',$this->lang->line('employee-settings')=>'staff/index',$this->lang->line('leave-types')=>'staff/leave_types',$this->lang->line('edit-leave-type')=>'no_link'));
			
			#set validation rules
			$this->form_validation->set_rules('leave_type','leave-code','trim|xss_clean|required|is_edit_unique[employee_leave_type.leave_type]');
			$this->form_validation->set_rules('type_description','leave-name','trim|required');
			$this->form_validation->set_rules('type_color','color','required');			
			if($this->form_validation->run() === TRUE){
				
				$data = $this->input->post(NULL,true);	
				$data['company_id'] = $this->session->userdata('company_id');
				$data['status'] = 1;

				if($this->leave->my_update('employee_leave_type',$data,array('id'=>$type_id))){
					$this->message->set($this->lang->line('ltype_update_msg'));
				}else{
					$this->message->set($this->lang->line('ltype_up_err_msg'),'e');
				}
				redirect('staff/leave_types');
			}

			#fetch types from table and display
			$ltypes = $this->leave->get_all(array('id'=>$type_id))[0];
			if($ltypes['company_id'] == 0){
				$this->message->set($this->lang->line('def-data-not-changed'),'i');
				redirect('staff/leave_types');
			}
			$this->template->append('employees/leaves/edit_leave_types',array('ltypes'=>$ltypes));
			$this->template->slice('dms/message');
			$this->template->render();
		}

		#----------------------------------------------------
		#purpose: to delete leave types
		public function delete_leave_types(){

	 		if(!$this->uri->segment(3)){ 
				redirect('users/logout');
			}
			$type_id = $this->uri->segment(3);
			if($this->if_exists('employee_leave_type',array('id'=>$type_id,'status'=>1)) === false){
				redirect('staff/leave_types');
			}
			$ltypes = $this->leave->get_all(array('id'=>$type_id))[0];
			if($ltypes['company_id'] == 0){
				$this->message->set($this->lang->line('def-data-not-changed'),'i');
				redirect('staff/leave_types');
			}
			$total_desig_leaves = $this->db->select('id')->get_where('designation_leave_types',array('leave_type_id'=>$type_id,'status'=>1))->num_rows();
			
			if(empty($total_desig_leaves)){
				if($this->leave->delete_ltype($type_id)){
					$this->message->set($this->lang->line('ltype_delete_msg'));
				}else{
					$this->message->set($this->lang->line('ltype_delete_err_msg'),'e');
				}
			}else{
				$this->message->set($this->lang->line('can-not-delete-ltype'),'i');
			}
			redirect('staff/leave_types');	

			$this->template->slice('dms/message');
			$this->template->render();
		}

		#----------------------------------------------------
		# purpose: to assign leave types to employees
		public function assign_ltypes()
		{
			#--------------library
			$this->load->library('Leaves');			

			$user_type = "";

			#------------years
			$years = $this->dms->get_years();
			$year = date('Y');

			#------------leave types
			$ltypes = $this->leaves->leave_types(1,1);

			#--------------validation
			if(isset($_POST['btn_add']))
			{
				$user_type = $this->input->post('user_types',true);
				$year = $this->input->post('year',true);
				foreach($ltypes as $key => $value){
					$this->form_validation->set_rules('max_leave_type'.$value['id'],'max. leave type','trim|required|numeric|less_than[100]');
				}				
				if($this->form_validation->run('btn_add') === TRUE && !empty($user_type))
				{
					$from_date = $year."-01-01";
					$to_date = $year."-12-31";
					foreach($ltypes as $lkey => $lvalue)
					{						
						$carry_forward = 0;
						if($this->input->post('carry_forward'.$lvalue['id'],true)){
							$carry_forward = 1;
						}
						$max_leave = $this->input->post('max_leave_type'.$lvalue['id'],true);							
						if($max_leave > 0)
						{
							#-----------save
							$this->leave->f_save('designation_leave_types',array('designation' => $user_type,'leave_type_id' => $lvalue['id'],'max_permissible' => $max_leave,'carry_forward' => $carry_forward,'from_date' => $from_date,'to_date' => $to_date));
							$this->message->set($this->lang->line('dltype_save_msg'));
						}
					}					
					redirect('staff/assign_ltypes');
				}
			}

			#--------------validation			
			if(isset($_POST['btn_get']))
			{
				$this->form_validation->set_rules('user_types','designation','required');
				$this->form_validation->set_rules('year','year','required');
				if($this->form_validation->run('btn_get') === TRUE){
					$year = $this->input->post('year',true);
					$from_date = $year."-01-01";
					$to_date = $year."-12-31";
					if(!$this->leave->get_leaves($this->input->post('user_types',true),$from_date,$to_date))
					{
						$user_type = $this->input->post('user_types',true);
					}
					else
					{
						$this->message->set($this->lang->line('dleave_exist_msg'),'w');
					}
				}
			}

			#------------designations
			$utype = $this->desig->listing(array('utype_status >'=>0,'utype_status <'=>4,'department_id >'=>0));
			$utype[''] = "Select";
			ksort($utype);			

			#------------template
			$this->template->title($this->lang->line('assign-leave-types'));
			$this->template->main_heading($this->lang->line('assign-leave-types'));
			$this->template->breadcrumb(array($this->lang->line('settings')=>'preferences/',$this->lang->line('employee-settings')=>'staff/index',$this->lang->line('assign-leave-types')=>'no_link',$this->lang->line('assigned-ltypes-report')=>'staff/designation_ltypes_report'));
			$this->template->slice('dms/message');
			$this->template->append('employees/leaves/assign_ltypes',array('user_types'=>$utype,'user_type' => $user_type,'years' => $years,'year' => $year));
			if($user_type)
			{
				if($ltypes)
				{
					$this->template->append('employees/leaves/leave_types',array('ltypes'=>$ltypes,'user_type' => $user_type,'year' => $year));
				}
				else
				{
					$this->message->set($this->lang->line('no-leave-type-found'),'i');
				}
			}
			$this->template->render();
		}	

		#----------------------------------------------------
		# purpose: to assign leave types to employees
		public function designation_ltypes_report()
		{
			#--------------library
			$this->load->library('Leaves');
			
			#------------leave types
			$ltypes = $this->leaves->leave_types(1,1);

			#----------pagination
			$this->load->library('Pagination');
			$config['per_page'] = $this->per_page();
			# Pagination Config Customizations
			$config['full_tag_open'] = '<ul class="pagination">';
			$config['full_tag_close'] = '</ul>';
			$config['first_link'] = 'First';
			$config['last_link'] = 'Last';
			$config['next_link'] = '&raquo;';
			$config['prev_link'] = '&laquo;';
			$config['cur_tag_open'] = '<li class="active"><a href="#">';
			$config['cur_tag_close'] = '</a></li>';
			$config['num_tag_open'] = '<li>';
			$config['num_tag_close'] = '</li>';
			$config['base_url'] = base_url('staff/designation_ltypes_report');	
			$config['uri_segment'] = 3;

			#---------designations
			//$utype = $this->desig->listing(array('utype_status >'=>0,'utype_status <'=>4,'department_id >'=>0));			

			#----------total rows
			$config['total_rows'] = $this->leave->get_all_assigned();
			if($config['total_rows'] > 0)
			{
				#----------pagination
				$offset = $this->uri->segment($config['uri_segment'],0);
				$this->pagination->initialize($config);
				$links = $this->pagination->create_links();

				#---------assigned leaves
				$altypes = $this->leave->get_assigned_leaves($config['per_page'],$offset);

				$this->template->append('employees/leaves/assigned_ltypes_report',array('altypes'=>$altypes,'ltypes' => $ltypes,'links' => $links,'offset' => $offset));
			}
			else
			{
				$this->message->set($this->lang->line('no-result-found'),'i');
			}

			$this->template->title($this->lang->line('assigned-leave-types'));
			$this->template->main_heading($this->lang->line('assigned-leave-types'));
			$this->template->breadcrumb(array($this->lang->line('settings')=>'preferences/',$this->lang->line('employee-settings')=>'staff/index',$this->lang->line('assign-leave-types')=>'staff/assign_ltypes',$this->lang->line('assigned-ltypes-report')=>'no_link'));						
			$this->template->slice('dms/message');
			$this->template->render();
		}
		#----------------------------------------------------

		# date: 18-02-2015
		# purpose: to assign leave types to employees
		public function update_designation_ltypes()
		{
			#--------------library
			$this->load->library('Leaves');
			
			#--------------uri array
			$uri_array = $this->uri->uri_to_assoc(3);

			if(isset($uri_array['id']) && isset($uri_array['yr']))
			{
				$from_date = $uri_array['yr']."-01-01";
				$to_date = $uri_array['yr']."-12-31";
				if($this->form_validation->is_date($from_date) && $this->form_validation->is_date($to_date))
				{
					$desig_id = $uri_array['id'];

					if(!$this->leave->check_attendance($desig_id,$uri_array['yr']))
					{
						#----------assigned leave details
						$assign_leave_array = $this->leave->get_assigned_leave($desig_id,$from_date,$to_date);

						#----------validation
						foreach($assign_leave_array as $key => $value){
							$this->form_validation->set_rules('max_leave_type'.$value['id'],'max. leave type','trim|required|numeric|less_than[100]');
						}					
						if($this->form_validation->run() === TRUE)
						{						
							foreach($assign_leave_array as $dkey => $dvalue)
							{
								$max_leave = $this->input->post("max_leave_type".$dvalue['id'],true);
								$carry_forward = 0;
								if($this->input->post('carry_forward'.$dvalue['id'],true)){
									$carry_forward = 1;
								}
								if($this->leave->get_leaves($desig_id,$from_date,$to_date,$dvalue['id']))
								{
									$this->leave->my_update('designation_leave_types',array('max_permissible' => $max_leave,'carry_forward' => $carry_forward,'from_date' => $from_date,'to_date' => $to_date),array('id' => $dvalue['did']));
									$this->message->set($this->lang->line('dltype_update_msg'));
								}
								else
								{
									if($max_leave > 0)
									{
										$this->leave->f_save('designation_leave_types',array('designation' => $desig_id,'leave_type_id' => $dvalue['id'],'max_permissible' => $max_leave,'carry_forward' => $carry_forward,'from_date' => $from_date,'to_date' => $to_date));
										$this->message->set($this->lang->line('dltype_update_msg'));
									}
								}
							}
							redirect('staff/designation_ltypes_report');
						}
						#----------template
						$this->template->title($this->lang->line('assigned-leave-types'));
						$this->template->main_heading($this->lang->line('assigned-leave-types'));
						$this->template->breadcrumb(array($this->lang->line('settings')=>'preferences/',$this->lang->line('employee-settings')=>'staff/index',$this->lang->line('assign-leave-types')=>'staff/assign_ltypes',$this->lang->line('assigned-ltypes-report')=>'staff/designation_ltypes_report',$this->lang->line('update-assign-ltypes')=>'no_link'));					
						$this->template->append('employees/leaves/update_assigned_ltypes',array('assign_leave_array' => $assign_leave_array));
						$this->template->slice('dms/message');
						$this->template->render();
					}
					else
					{
						$this->message->set($this->lang->line('dltype-update-error-msg'),'e');
						redirect('staff/designation_ltypes_report');
					}
				}
				
				else{
					redirect('users/logout');
				}
			}
			else{
				redirect('users/logout');
			}
		}

		#----------------------------------------------------

		#purpose: to delete leave types
		public function delete_designation_ltypes()
		{
			#--------------uri array
			$uri_array = $this->uri->uri_to_assoc(3);

			if(isset($uri_array['id']) && isset($uri_array['yr']))
			{
				$from_date = $uri_array['yr']."-01-01";
				$to_date = $uri_array['yr']."-12-31";
				if($this->form_validation->is_date($from_date) && $this->form_validation->is_date($to_date))
				{
					if($this->leave->delete_ltype_assigned(array('designation' => $uri_array['id'],'from_date' => $from_date,'to_date' => $to_date)))
					{
						$this->message->set($this->lang->line('dltype_delete_msg'));
					}
					else
					{
						$this->message->set($this->lang->line('dltype_delete_err_msg'),'e');
					}
					redirect('staff/designation_ltypes_report');
				}
				else
				{
					redirect('users/logout');
				}
			}
			else
			{
				redirect('users/logout');
			}
		}		
}	
?>