<?php if( ! defined('BASEPATH')) exit ('No direct access allowed');
	
	class Stock_adjustment_types extends MY_Controller{

		public function __construct(){

			parent ::__construct();
			$this->check_access_right();
			$this->load->model('stocks/Stock_adjustment_model','stockadjust');
		}
	   #---------------------------------------
		public function add(){
			#validation
			$this->form_validation->set_rules('type_name','lang:adjustment-type','required|trim|callback_asjustment_type_exist');
			if($this->form_validation->run() == TRUE){
				//echo 'hai';die;
				$data = $this->input->post(NULL,TRUE);
				$data['company_id'] = $this->session->userdata('company_id');
				if($this->stockadjust->f_save('dms_stock_adjustment_types',$data)){
					$this->message->set($this->lang->line('stock-adjust-type-saved'));
				}
				else{
					$this->message->set($this->lang->line('stock-adjust-type-not-saved'));
				}
				redirect('stock_adjustment_types/add');

			}

			#-------------------------loading view report--------------------------------
			#pagination
   	 		$this->load->library('Pagination');
   	 		$config['total_rows'] = $this->stockadjust->get_all(array('numrows'=>TRUE));
   	 		//print_r($config['total_rows']);die;
   	 		$config['base_url'] = base_url('stock_adjustment_types/add');
   	 		$config['per_page'] = $this->per_page();
			# Pagination Config Customizations
			$config['full_tag_open'] = '<ul class="pagination">';
			$config['full_tag_close'] = '</ul>';
			$config['first_link'] = 'First';
			$config['last_link'] = 'Last';
			$config['next_link'] = '&raquo;';
			$config['prev_link'] = '&laquo;';
			$config['cur_tag_open'] = '<li class="active"><a href="#">';
			$config['cur_tag_close'] = '</a></li>';
			$config['num_tag_open'] = '<li>';
			$config['num_tag_close'] = '</li>';
   	 		$config['uri_segment'] = 3;

   	 		$this->pagination->initialize($config);
   	 		$links = $this->pagination->create_links();
   	 		$offset = $this->uri->segment($config['uri_segment'],0);

   	 		$types = $this->stockadjust->get_all(array('order_by'=>'created_on','order'=>'DESC','limit'=>$config['per_page'],'offset'=>$offset));
   	 		if(!empty($types)){
   	 			$this->template->append('products/stocks/types/report',array('links'=>$links,'offset'=>$offset,'types'=>$types));
   	 		}
			#--------------------------------End------------------------------------------
			#template
			$this->template->title('Stock Adjustment Types Settings');
			$this->template->main_heading($this->lang->line('stock-adjust-type'));
			$this->template->breadcrumb(array($this->lang->line('settings') =>'preferences/index',$this->lang->line('stock-adjust-type') =>'no_link'));
			$this->template->slice('dms/message');
			$this->template->slice('products/stocks/types/add');
			$this->template->render();
		}
	   #-------------------------------------------
		public function update($id){
			$type_id = $this->uri->segment(3);
			if(empty($type_id)){ redirect('stock_adjustment_types/add');}
			$types = $this->stockadjust->get_all(array('conditions'=>array('id'=>$type_id)))[0];
			//print_r($types);die;
			#validation
			$this->form_validation->set_rules('type_name','lang:adjustment-type',"required|trim|xss_clean|callback_is_edit_type_exist[$type_id]");
			if($this->form_validation->run() == TRUE){

				$data = $this->input->post(NULL,TRUE);
				if($this->stockadjust->my_update('dms_stock_adjustment_types',$data,array('id'=>$type_id))){
					$this->message->set($this->lang->line('stock-adjust-type-updated'));
				}
				else{
					$this->message->set($this->lang->line('stock-adjust-type-not-updated'),'e');
				}
				$call_ck_uri = $this->uri->uri_to_assoc(4);
				redirect($this->uri->assoc_to_uri($call_ck_uri));
			}

			$this->template->title('Stock Adjustment Types Settings');
			$this->template->main_heading($this->lang->line('stock-adjust-type'));
			$this->template->breadcrumb(array($this->lang->line('settings') =>'preferences/index',$this->lang->line('stock-adjust-type') =>'stock_adjustment_types/add',$this->lang->line('update')=>'no_link'));
			$this->template->slice('products/stocks/types/update',array('types'=>$types));
			$this->template->render();

		}
	   #-------------------------------------------
		public function delete($id){
			$type_id = $this->uri->segment(3);
			if(empty($type_id)){ redirect('stock_adjustment_types/add');}
			if($this->stockadjust->my_update('dms_stock_adjustment_types',array('status'=>0),array('id'=>$type_id))){
				$this->message->set($this->lang->line('stock-adjust-type-deleted'));
			}
			else{
				$this->message->set($this->lang->line('stock-adjust-type-not-deleted'),'e');
			}
			redirect('stock_adjustment_types/add');

		}
	   #--------------------------------------------
		public function adjustment_type_exist($type_name){
			$this->db->from('dms_stock_adjustment_types');
			$this->db->where(array('company_id'=>$this->session->userdata('company_id'),'type_name'=>$type_name,'status'=>1));
			$row = $this->db->get()->result_array();
			if(!empty($row)){
				$this->form_validation->set_message('adjustment_type_exist',$this->lang->line('stock-adjust-type-already-exists'));
				return FALSE;
			}else{
				return TRUE;
			}
		}
	   #--------------------------------------------
		public function is_edit_type_exist($type_name,$type_id){
			$this->db->select('type_name');
			$this->db->from('dms_stock_adjustment_types');
			$this->db->where(array('id !='=>$type_id,'type_name'=>$type_name,'company_id'=>$this->session->userdata('company_id')));
			$row = $this->db->get()->result_array();
			if(!empty($row)){
				$this->form_validation->set_message('is_edit_type_exist',$this->lang->line('stock-adjust-type-already-exists'));
				return FALSE;
			}else{
				return TRUE;
			}
		}
	   #--------------------------------------------                                                        
	}
?>