<?php if( ! defined('BASEPATH')) exit ('No direct script access allowed');
	
	class Stock_adjustments extends MY_Controller{

		var $company_Id;
		var $branch_Id;
		var $created_By;
		#------------------------------------------
		public function __construct(){

			parent ::__construct();
			$this->check_access_right();
			$this->load->model('stocks/Stock_adjustment_model','stockadjust');

			#---------------- Checking Financial year is enabled / closed-----------------#
			$method_array = array('add','update','delete');
			fiscal_status($this->uri->segment(2),$method_array,"stock_adjustments/report");	
			#---------------- Checking Financial year is enabled / closed-----------------#			

			$this->company_Id = $this->session->userdata('company_id');
			$this->branch_Id = $this->session->userdata('under_id');
			$this->created_By = $this->session->userdata('id');
		}
		#----------------------------------------
		public function add(){
			$this->load->library('Stock');
			#getting data saved in temp table
			$temp_stock_items = $this->stockadjust->get_temp_data(array('dstki_temp.created_by'=>$this->session->userdata('id')));
			$reference_no = NULL; $date = NULL;
			$godown_id = $this->stock->get_branch_godown($this->branch_Id);
			#repopulte value
			if($this->input->post('add_stock') || $this->input->post('save_stock')){
				$reference_no = $this->input->post('bill_no');
				$date = cdateFormat($this->input->post('bill_date'));
			}
			else{
				if($this->uri->segment(3) != ''){

					$re_pop = $this->uri->uri_to_assoc(3);
					if(!empty($re_pop)){
						if(isset($re_pop['bill_no'])){

							$reference_no = $re_pop['bill_no'];	
						}
						if(isset($re_pop['bill_date'])){
							$date = cdateFormat($re_pop['bill_date']);
						}
					}
				}
			}

			if($this->input->post('add_stock')){
				$this->form_validation->set_rules('bill_no','lang:referance-no','required|trim|xss_clean');
				$this->form_validation->set_rules('bill_date','lang:date','required|trim|valid_date|xss_clean');
				$this->form_validation->set_rules('item_id','lang:item-name','required|xss_clean');
				$this->form_validation->set_rules('qty','lang:quantity','required|greater_than[0]|xss_clean');
				$this->form_validation->set_rules('unit_id','lang:unit','required|xss_clean');
				$this->form_validation->set_rules('godown_id','lang:godown','required|xss_clean');
				$this->form_validation->set_rules('adjustment_type','lang:adjustment-type','required|xss_clean');
				$this->form_validation->set_rules('stock_affect','lang:stock-affect','required|xss_clean');
				//$this->form_validation->set_rules('rate','lang:rate','required|xss_clean');

				if($this->input->post('item_id')){
					$units = $this->stock->get_units($this->input->post('item_id'));
				}

				if($this->form_validation->run('add_stock') == TRUE){

					$data = $this->input->post(NULL,TRUE);
					$re_pop['bill_no'] = $data['bill_no'];
					$re_pop['bill_date'] = $data['bill_date'];

					#definig stock items for saving temp data;
					$stock_items['item_id'] = $data['item_id'];
					$stock_items['godown_id'] = $data['godown_id'];
					$stock_items['qty'] = $data['qty'];
					$stock_items['unit_id'] = $data['unit_id'];
					$stock_items['rate'] = 0;
					$stock_items['adjustment_type'] = $data['adjustment_type'];
					$stock_items['stock_affect'] = $data['stock_affect'];
					#checking tempdata saved in temptable
					$temp_check = $this->stockadjust->get_temp_data(array('dstki_temp.id'=>$this->session->userdata('id'),'item_id'=>$data['item_id']));
					if(empty($temp_check)){
						if($this->stockadjust->save_temp_data($stock_items)){
							redirect('stock_adjustments/add/'.$this->uri->assoc_to_uri(array_filter($re_pop)));
						}						
					}
				}
			}

			if($this->input->post('save_stock')){
				$this->form_validation->set_rules('bill_no','lang:referance-no','required|trim|xss_clean');
				$this->form_validation->set_rules('bill_date','lang:date','required|trim|valid_date|xss_clean');
				$this->form_validation->set_rules('remarks','lang:remarks','trim|xss_clean');

				if($this->form_validation->run('save_stock') == TRUE){
					$data  = $this->input->post(NULL,TRUE);
					$stckadj_data['bill_no'] = $data['bill_no'];
					$stckadj_data['bill_date'] = date('Y-m-d',strtotime($data['bill_date']));
					$stckadj_data['remarks'] = $data['remarks'];
					$stckadj_data['company_id'] = $this->company_Id;
					if($this->stockadjust->f_save('dms_stock_adjustments',$stckadj_data)){
	
						$adjustment_id = $this->db->insert_id();
						foreach($temp_stock_items as $key=>$temp){
							#defining stock adjustment items data
							$stck_adj_items['adjustment_id'] = $adjustment_id;
							$stck_adj_items['item_id'] = $temp['item_id'];
							$stck_adj_items['godown_id'] = $temp['godown_id'];
							$stck_adj_items['qty'] = $temp['qty'];
							$stck_adj_items['unit_id'] = $temp['unit_id'];
							$stck_adj_items['rate'] = $temp['rate'];
							$stck_adj_items['adjustment_type'] = $temp['adjustment_type'];
							$stck_adj_items['stock_affect'] = $temp['stock_affect'];
							if($this->stockadjust->f_save('dms_stock_adjustment_items',$stck_adj_items)){
							
								$stock_items_table_id = $this->db->insert_id();
								$stock['table_id'] = $stock_items_table_id;
								$stock['company_id'] = $this->company_Id;
								$stock['branch_id'] = $this->branch_Id;
								$stock['item_id'] = $stck_adj_items['item_id'];
								$stock['godown_id'] = $stck_adj_items['godown_id'];
								$stock['qty'] = $stck_adj_items['qty'];
								$stock['unit_id'] = $stck_adj_items['unit_id'];
								$stock['rate'] = $stck_adj_items['rate'];
								$stock['stock_date'] = $stckadj_data['bill_date'];
								$stock['stock_status'] = 9;
								$stock['table_group_id'] =  $adjustment_id;
								#save affecting dms_stocks and saving data
								if($stck_adj_items['stock_affect'] == '1'){
								
									#unit rate is converted in to unit primary id 
									$conversion = $this->stock->unit_conversion($stock['item_id'],$stock['unit_id'],$stock['qty'],$stock['rate']);
									$stock['qty'] = $conversion['qty'];
									$stock['unit_id'] = $conversion['primary_unit'];
									$stock['rate'] = $conversion['rate'];
									#saving stocks
									$this->stockadjust->f_save('dms_stocks',$stock);
									
								}
								else{
									
									#unit rate is converted in to unit primary id 
									$conversion = $this->stock->unit_conversion($stock['item_id'],$stock['unit_id'],$stock['qty'],$stock['rate']);
									$stock['qty'] = -$conversion['qty'];
									$stock['unit_id'] = $conversion['primary_unit'];
									$stock['rate'] = $conversion['rate'];
									$this->stockadjust->f_save('dms_stocks',$stock);
								}
								$this->stockadjust->delete_temp_data($temp['id']);	
							}				
						}
						$this->message->set($this->lang->line('stock-adjustment-saved'),'s');
						redirect('stock_adjustments/add');
					}
					else{
						$this->message->set($this->lang->line('stock-adjustment-not-saved'),'e');
						redirect('stock_adjustments/add');
					}					
				}
			}
			#loading models and listing functions
			$this->load->model('godown/Godown_model','godown');
			$godown = $this->godown->listing(array('conditions'=>array('branch_id'=>$this->session->userdata('under_id'))));
			$godown[''] = 'Select';
			ksort($godown);

			$this->load->model('products/Item_model','item');
			$items = $this->item->listing();
			$items[''] = 'Select';
			ksort($items);

			$units[''] = 'select';
			ksort($units);
			$adjust_types = $this->stockadjust->type_listing();
			$adjust_types[''] = 'Select';
			ksort($adjust_types);
			$stock_affects = array('1'=>'Add','-1'=>'Less');
			#template
			$this->template->title('Stock Adjustment Settings');
			$this->template->main_heading($this->lang->line('stock-adjust'));
			//$this->template->breadcrumb(array($this->lang->line('stock-adjust') =>'no_link',$this->lang->line('update') =>'stock_adjustments/report'));
			$this->template->breadcrumb(array($this->lang->line('stock-adjust')=>'no_link',$this->lang->line('report')=>'stock_adjustments/report'));
			$this->template->slice('dms/message');
			$this->template->slice('products/stocks/adjustment/add',array('godown'=>$godown,'items'=>$items,'units'=>$units,'adjust_types'=>$adjust_types,'stock_affects'=>$stock_affects,'temp_stock_items'=>$temp_stock_items,'reference_no'=>$reference_no,'date'=>$date));
			$this->template->other_script('stocks/stock_adjustment');
			$this->template->render();
		}
		#----------------------------------------
		public function remove_temp_item($id){
			
			if(!$this->uri->segment(3)){ 
				redirect('users/logout');
			}
			$temp_id= $this->uri->segment(3);
		
			if($this->if_exists('dms_stock_adjustment_temp_items',array('id'=>$temp_id,'created_by'=>$this->created_By)) === false){
				redirect('stock_adjustments/add');
			}
			if($this->stockadjust->delete_temp_data($temp_id)){
			}
			$call_ck_uri = $this->uri->uri_to_assoc(4);
			redirect($this->uri->assoc_to_uri($call_ck_uri));
		}
		#-----------------------------------------
		public function report(){
			$links = NULL;
			$offset = NULL;
			$stck_adjusts = NULL;
			$filter_data = array('from_date'=>'','to_date'=>'');
			$conditions =array();

			if(isset($_POST['search']) || $this->uri->segment(4) !=''){

				$filter_data = $this->input->post(NULL,TRUE);
				if(isset($_POST['search'])){

					$filter_data = $this->input->post(NULL,TRUE);
				}
				else{
						
					$filter_data = $this->uri->uri_to_assoc(3);
				}
				$filter_data = array_filter($filter_data);
				$count = count($filter_data);

				if($count==0){
					$this->message->set($this->lang->line('use-one-search'),'e');
				}
				else{

					if(isset($_POST['search'])){


						if(isset($filter_data['from_date']) && $filter_data['from_date'] != ''){
							$this->form_validation->set_rules('from_date','lang:date','is_date|required');
						}

						if(isset($filter_data['to_date']) && $filter_data['to_date'] != ''){
							$this->form_validation->set_rules('to_date','lang:date','is_date|required');
						}
									
					}

					if($this->form_validation->run() == TRUE || $this->uri->segment(3)){
				
						if(isset($filter_data['from_date']) && $filter_data['from_date']!=''){
							$from_date =date('Y-m-d',strtotime($filter_data['from_date']));
							$conditions['bill_date >='] = $from_date;
							$filter_data['from_date'] = $from_date;
						}

						if(isset($filter_data['to_date']) && $filter_data['to_date']!=''){
							$to_date =date('Y-m-d',strtotime($filter_data['to_date']));
							$conditions['bill_date <='] = $to_date;
							$filter_data['to_date'] = $to_date;
						}
						if(!empty($from_date)&& !empty($to_date)){

							$conditions['bill_date >='] = $from_date;
							$conditions['bill_date <='] = $to_date;
						}
					}
				}
				#set dummy filter data again for the unset values
				if(!isset($filter_data['from_date'])){ $filter_data['from_date'] = ''; }else{$filter_data['from_date'] = cdateFormat($filter_data['from_date']);}
				if(!isset($filter_data['to_date'])){ $filter_data['to_date'] = ''; }else{$filter_data['to_date'] = cdateFormat($filter_data['to_date']);}
			}
			
			if($this->created_By != '-1' && $this->created_By != '-2')
			{
			    $conditions['created_by'] = $this->created_By;
			}
			
			$this->load->library('Pagination');
   	 		$config['total_rows'] = $this->stockadjust->get_all_stock_adust_data(array('numrows'=>TRUE,'conditions'=>$conditions));
   	 		if($config['total_rows']==0){
   	 			$this->message->set($this->lang->line('no-result-found'),'i');
   	 		}
   	 		$config['base_url'] = base_url('stock_adjustments/report').'/'.$this->uri->assoc_to_uri(array_filter($filter_data));
   	 		$config['per_page'] = $this->per_page();
			# Pagination Config Customizations
			$config['full_tag_open'] = '<ul class="pagination">';
			$config['full_tag_close'] = '</ul>';
			$config['first_link'] = 'First';
			$config['last_link'] = 'Last';
			$config['next_link'] = '&raquo;';
			$config['prev_link'] = '&laquo;';
			$config['cur_tag_open'] = '<li class="active"><a href="#">';
			$config['cur_tag_close'] = '</a></li>';
			$config['num_tag_open'] = '<li>';
			$config['num_tag_close'] = '</li>';
   	 		$config['uri_segment'] = count(array_filter($filter_data))*2+3;

   	 		$this->pagination->initialize($config);
   	 		$links = $this->pagination->create_links();
   	 		$offset = $this->uri->segment($config['uri_segment'],0);

   	 		$stck_adjusts = $this->stockadjust->get_all_stock_adust_data(array('conditions'=>$conditions,'order_by'=>'created_on','order'=>'DESC','limit'=>$config['per_page'],'offset'=>$offset));

			$this->template->title('Stock Adjustment Report');
			$this->template->main_heading($this->lang->line('stock-adjust'));
	
			$this->template->breadcrumb(array($this->lang->line('stock-adjust')=>'stock_adjustments/add',$this->lang->line('report')=>'no_link'));
			$this->template->slice('dms/message');
			$this->template->slice('products/stocks/adjustment/select_search',array('offset'=>$offset,'links'=>$links,'stck_adjusts'=>$stck_adjusts,'data'=>$filter_data));
			$this->template->other_script('stocks/stock_adjustment');
			$this->template->slice('dms/modals/more_details');
			$this->template->render();
		}
		#--------------------------------------------------------------
		public function update(){

			$stock_adjust_id = $this->uri->segment(3);
			$call_ck_uri = $this->uri->uri_to_assoc(4);
			if(empty($stock_adjust_id)){ redirect('stock_adjustments/report');}
			if($this->if_exists('dms_stock_adjustments',array('id'=>$stock_adjust_id,'status'=>1)) === false){
				redirect('stock_adjustments/report');
			}
			
			$this->load->library('Stock');
            $godown_id = $this->stock->get_branch_godown($this->branch_Id);

			#get details of stock adjustemnts;
			$stock_adjust = $this->stockadjust->get_all_stock_adust_data(array('conditions'=>array('stk_adj.id'=>$stock_adjust_id)))[0];
			$reference_no = $stock_adjust['bill_no']; $date = cdateFormat($stock_adjust['bill_date']);
			#get details of stock adjust items for stock adjust id;
			$stock_items = $this->stockadjust->get_all_stock_adust_items(array('conditions'=>array('stk_adj_itm.adjustment_id'=>$stock_adjust_id)));
			#repopulte value
			if($this->input->post('add_stock') || $this->input->post('update_stock')){
				$reference_no = $this->input->post('bill_no');
				$date = cdateFormat($this->input->post('bill_date'));
			}
			else{

				if($this->uri->segment(3) != ''){

					$re_pop = $this->uri->uri_to_assoc(3);
					if(!empty($re_pop)){
						if(isset($re_pop['bill_no'])){

							$reference_no = $re_pop['bill_no'];	
						}
						if(isset($re_pop['bill_date'])){
							$date = cdateFormat($re_pop['bill_date']);
						}
						

					}
				}
			}

			if($this->input->post('add_stock')){
				$this->form_validation->set_rules('bill_no','lang:referance-no','required|trim|xss_clean');
				$this->form_validation->set_rules('bill_date','lang:date','required|trim|is_date|xss_clean');
				$this->form_validation->set_rules('item_id','lang:item-name','required|xss_clean');
				$this->form_validation->set_rules('qty','lang:quantity','required|greater_than[0]|xss_clean');
				$this->form_validation->set_rules('unit_id','lang:unit','required|xss_clean');
				$this->form_validation->set_rules('godown_id','lang:godown','required|xss_clean');
				$this->form_validation->set_rules('adjustment_type','lang:adjustment-type','required|xss_clean');
				$this->form_validation->set_rules('stock_affect','lang:stock-affect','required|xss_clean');
				//$this->form_validation->set_rules('rate','lang:rate','required|xss_clean');

				if($this->input->post('item_id')){
					$units = $this->stock->get_units($this->input->post('item_id'));
				}

				if($this->form_validation->run('add_stock') == TRUE){

					$data = $this->input->post(NULL,TRUE);
					//echo '<pre>';print_r($data);die;
					$re_pop['bill_no'] = $data['bill_no'];
					$re_pop['bill_date'] = $data['bill_date'];

					#definig stock items for saving temp data;
					$stock_new_items['item_id'] = $data['item_id'];
					$stock_new_items['godown_id'] = $data['godown_id'];
					$stock_new_items['qty'] = $data['qty'];
					$stock_new_items['unit_id'] = $data['unit_id'];
					$stock_new_items['rate'] = 0;
					$stock_new_items['adjustment_type'] = $data['adjustment_type'];
					$stock_new_items['stock_affect'] = $data['stock_affect'];
					$stock_new_items['adjustment_id'] = $stock_adjust_id;
					
					#add new item for stock adjustment items 
					if($this->stockadjust->f_save('dms_stock_adjustment_items',$stock_new_items)){
						
						#saving dms stock data
						$stock_items_table_id = $this->db->insert_id();
						$stock['table_id'] = $stock_items_table_id;
						$stock['company_id'] = $this->company_Id;
						$stock['branch_id'] = $this->branch_Id;
						$stock['item_id'] = $stock_new_items['item_id'];
						$stock['godown_id'] = $stock_new_items['godown_id'];
						$stock['qty'] = $stock_new_items['qty'];
						$stock['unit_id'] = $stock_new_items['unit_id'];
						$stock['rate'] = $stock_new_items['rate'];
						$stock['stock_date'] = $stock_adjust['bill_date'];
						$stock['stock_status'] = 9;
						$stock['table_group_id'] = $stock_adjust_id;
						#save affecting dms_stocks and saving data
						if($stock_new_items['stock_affect'] == '1'){
						
							#unit rate is converted in to unit primary id 
							$conversion = $this->stock->unit_conversion($stock['item_id'],$stock['unit_id'],$stock['qty'],$stock['rate']);
							$stock['qty'] = $conversion['qty'];
							$stock['unit_id'] = $conversion['primary_unit'];
							$stock['rate'] = $conversion['rate'];
							
							
						}
						else{
							#unit rate is converted in to unit primary id 
							$conversion = $this->stock->unit_conversion($stock['item_id'],$stock['unit_id'],$stock['qty'],$stock['rate']);
							$stock['qty'] = -$conversion['qty'];
							$stock['unit_id'] = $conversion['primary_unit'];
							$stock['rate'] = $conversion['rate'];
		
						}
						#saving stocks
						$this->stockadjust->f_save('dms_stocks',$stock);
						redirect('stock_adjustments/update/'.$stock_adjust_id.'/'.$this->uri->assoc_to_uri(array_filter($re_pop)));
					}
					
				}
			}
			if($this->input->post('update_stock')){
				
				$this->form_validation->set_rules('bill_no','lang:referance-no','required|trim|xss_clean');
				$this->form_validation->set_rules('bill_date','lang:date','required|trim|is_date|xss_clean');
				$this->form_validation->set_rules('remarks','lang:remarks','trim|xss_clean');

				if($this->form_validation->run('update_stock') == TRUE){
					
					$data  = $this->input->post(NULL,TRUE);
					$stckadj_data['bill_no'] = $data['bill_no'];
					$stckadj_data['bill_date'] = date('Y-m-d',strtotime($data['bill_date']));
					$stckadj_data['remarks'] = $data['remarks'];
					
					#update  stock adjustment
					if($this->stockadjust->my_update('dms_stock_adjustments',$stckadj_data,array('id'=>$stock_adjust_id))){
						#updata dms stocks stock_date field
						foreach($stock_items as $key=>$stock){
							$this->stockadjust->my_update('dms_stocks',array('stock_date'=>$stckadj_data['bill_date']),array('table_id'=>$stock['id']));
						}
						$this->message->set($this->lang->line('stock-adjustment-updated'),'s');
						redirect($this->uri->assoc_to_uri($call_ck_uri));
					}
					else{
						$this->message->set($this->lang->line('stock-adjustment-not-updated'),'');
						redirect('stock_adjustments/update/'.$stock_adjust_id);
					}
				}
			}
		
			

			$this->load->model('godown/Godown_model','godown');
			$godown = $this->godown->listing(array('conditions'=>array('branch_id'=>$this->session->userdata('under_id'))));
			$godown[''] = 'Select';
			ksort($godown);

			$this->load->model('products/Item_model','item');
			$items = $this->item->listing();
			$items[''] = 'Select';
			ksort($items);

			$this->load->model('products/Unit_model','unit');
			$units = $this->unit->listing();
			$units[''] = 'select';
			ksort($units);

			$adjust_types = $this->stockadjust->type_listing();
			$adjust_types[''] = 'Select';
			ksort($adjust_types);
			$stock_affects = array('1'=>'Add','-1'=>'Less');

			#template
			$this->template->title('Stock Adjustment Update');
			$this->template->main_heading($this->lang->line('stock-adjust'));
	
			$this->template->breadcrumb(array($this->lang->line('stock-adjust')=>'stock_adjustments/add',$this->lang->line('update')=>'no_link',$this->lang->line('report')=>'stock_adjustments/report'));
			$this->template->slice('dms/message');
			$this->template->slice('products/stocks/adjustment/update',array('godown'=>$godown,'items'=>$items,'units'=>$units,'adjust_types'=>$adjust_types,'stock_affects'=>$stock_affects,'stock_adjust'=>$stock_adjust,'stock_items'=>$stock_items,'reference_no'=>$reference_no,'date'=>$date));
			$this->template->other_script('stocks/stock_adjustment');
			$this->template->render();
		}
		#----------------------------------------------------------------
		#update stock adjustemnt item detials 
		public function edit_item(){
			$stock_item_id  = $this->uri->segment(3);
			if(empty($stock_item_id)) { redirect('users/logout');} 
			$this->load->library('Stock');
			$call_bck_uri = $this->uri->uri_to_assoc(4);
			$go_back = $this->uri->assoc_to_uri($call_bck_uri);
			#get details of stock adjust items for stock item id;
			$stock_item = $this->stockadjust->get_all_stock_adust_items(array('conditions'=>array('stk_adj_itm.id'=>$stock_item_id)))[0];
			
			#setting validation rules
			$this->form_validation->set_rules('item_id','lang:item-name','required|xss_clean');
			$this->form_validation->set_rules('qty','lang:quantity','required|greater_than[0]|xss_clean');
			$this->form_validation->set_rules('unit_id','lang:unit','required|xss_clean');
			$this->form_validation->set_rules('godown_id','lang:godown','required|xss_clean');
			$this->form_validation->set_rules('adjustment_type','lang:adjustment-type','required|xss_clean');
			$this->form_validation->set_rules('stock_affect','lang:stock-affect','required|xss_clean');
			//$this->form_validation->set_rules('rate','lang:rate','required|xss_clean');

			if($this->form_validation->run() == TRUE){

				$data = $this->input->post(NULL,TRUE);
				$data['rate'] = 0;
				#updating dms_stock_adjustment_items
				if($this->stockadjust->my_update('dms_stock_adjustment_items',$data,array('id'=>$stock_item_id))){
	
					if($data['stock_affect'] == '1'){
							
						#unit rate is converted in to unit primary id 
						$conversion = $this->stock->unit_conversion($data['item_id'],$data['unit_id'],$data['qty'],$data['rate']);
						$data['qty'] = $conversion['qty'];
						$data['unit_id'] = $conversion['primary_unit'];
						$data['rate'] = $conversion['rate'];
						
						
					}
					else{
						
						#unit rate is converted in to unit primary id 
						$conversion = $this->stock->unit_conversion($data['item_id'],$data['unit_id'],$data['qty'],$data['rate']);
						$data['qty'] = -$conversion['qty'];
						$data['unit_id'] = $conversion['primary_unit'];
						$data['rate'] = $conversion['rate'];
					
					}
					#update dms_stocks dara
					unset($data['adjustment_type']);
					unset($data['stock_affect']);
					if($this->stockadjust->my_update('dms_stocks',$data,array('table_id'=>$stock_item_id,'stock_status'=>9))){
						$this->message->set($this->lang->line('stock-adjust-item-updated'),'s');
					}
					else{
						$this->message->set($this->lang->line('stock-adjust-item-not-updated'),'e');
					}

				} 
				else{
					$this->message->set($this->lang->line('stock-adjust-item-not-updated'),'e');
				}
					$call_ck_uri = $this->uri->uri_to_assoc(4);
					redirect($this->uri->assoc_to_uri($call_ck_uri));
			}


			$this->load->model('godown/Godown_model','godown');
			$godown = $this->godown->listing(array('conditions'=>array('branch_id'=>$this->session->userdata('under_id'))));
			$godown[''] = 'Select';
			ksort($godown);
			

			$this->load->model('products/Item_model','item');
			$items = $this->item->listing();
			$items[''] = 'Select';
			ksort($items);
			
			$this->load->model('products/Unit_model','unit');
			$units = $this->unit->listing();

			if($this->input->post('item_id')){
				$units = $this->stock->get_units($this->input->post('item_id'));
			}
			$units[''] = 'select';
			ksort($units);
			
			$adjust_types = $this->stockadjust->type_listing();
			$adjust_types[''] = 'Select';
			ksort($adjust_types);
			$stock_affects = array('1'=>'Add','-1'=>'Less');
			#template
			$this->template->title('Stock Adjustment Item Update');
			$this->template->main_heading($this->lang->line('stock-adjustment-item'));
	
			$this->template->breadcrumb(array($this->lang->line('stock-adjust')=>'stock_adjustments/add',$this->lang->line('update')=>'no_link',$this->lang->line('report')=>'stock_adjustments/report',$this->lang->line('go-back')=>$go_back));
			$this->template->slice('dms/message');
			$this->template->slice('products/stocks/adjustment/edit_item',array('godown'=>$godown,'items'=>$items,'units'=>$units,'adjust_types'=>$adjust_types,'stock_affects'=>$stock_affects,'stock_item'=>$stock_item));
			$this->template->other_script('stocks/stock_adjustment');
			$this->template->render();

		}
		#--------------------------------------------------------------------------------
		#delete stock items form dms_stock adjustment items 
		public function remove_item(){
			
			if(!$this->uri->segment(3)){ 
				$call_ck_uri = $this->uri->uri_to_assoc(4);
				redirect($this->uri->assoc_to_uri($call_ck_uri));
			}
			$stock_item_id = $this->uri->segment(3);
			#update dms_stock_adjust_items status 
			if($this->stockadjust->my_update('dms_stock_adjustment_items',array('status'=>0),array('id'=>$stock_item_id))){

				#update  dms_stocks for 
				$this->stockadjust->my_update('dms_stocks',array('status'=>0),array('table_id'=>$stock_item_id,'stock_status'=>9));
				$this->message->set($this->lang->line('stock-adjust-item-deleted'));				
			}
			else{
				$this->message->set($this->lang->line('stock-adjust-item-not-deleted'));
			}
			$call_ck_uri = $this->uri->uri_to_assoc(4);
			redirect($this->uri->assoc_to_uri($call_ck_uri));
		}
		#--------------------------------------------------------------------------------
		#delete stock adjustement
		public function delete($id){
			$stock_adjust_id = $this->uri->segment(3);
			if(empty($stock_adjust_id)){ redirect('stock_adjustments/report');}
			if($this->if_exists('dms_stock_adjustments',array('id'=>$stock_adjust_id,'status'=>1)) === false){
				redirect('stock_adjustments/report');
			}

			#get stock item details;
			$stock_items = $this->stockadjust->get_all_stock_adust_items(array('conditions'=>array('stk_adj_itm.adjustment_id'=>$stock_adjust_id)));
			if($this->stockadjust->my_update('dms_stock_adjustments',array('status'=>0),array('id'=>$stock_adjust_id))){
				#update status in stock_items
				foreach($stock_items as $key=>$stock){

					$this->stockadjust->my_update('dms_stock_adjustment_items',array('status'=>0),array('id'=>$stock['id'],'adjustment_id'=>$stock_adjust_id));
					$this->stockadjust->my_update('dms_stocks',array('status'=>0),array('table_id'=>$stock['id'],'stock_status'=>9));
				}
				$this->message->set($this->lang->line('stock-adjustment-deleted'),'s');
			}
			else{
				$this->message->set($this->lang->line('stock-adjustment-not-deleted'),'e');
				
			}
			$call_ck_uri = $this->uri->uri_to_assoc(4);
				redirect($this->uri->assoc_to_uri($call_ck_uri));
		}
		#--------------------------------------------------------------------------------
		public function view()
		{
			#----------uri array
			$uri_array = $this->uri->uri_to_assoc(3);

			#----------breadcrumb
			$breadcrumb = array($this->lang->line('stock-adjust')=>'stock_adjustments/add',$this->lang->line('report')=>'stock_adjustments/report',$this->lang->line('view')=>'no_link');

			if(isset($uri_array['group_id']))
			{
				$stock_adjust_id = $uri_array['group_id'];
				if(isset($uri_array['id']) || isset($uri_array['mid']) || isset($uri_array['sid']))
				{
					if(isset($uri_array['id'])){
						$breadcrumb_url = "stock_item_register/index/id/".$uri_array['id'];
					}
					elseif(isset($uri_array['mid'])){
						$breadcrumb_url = "stock_item_register/index/mid/".$uri_array['mid'];
					}
					elseif(isset($uri_array['sid'])){
						$breadcrumb_url = "stock_item_register/index/sid/".$uri_array['sid'];
					}					
					if(isset($uri_array['rtype'])){
						$breadcrumb_url .= "/rtype/".$uri_array['rtype'];
					}
					$breadcrumb[$this->lang->line("go-back")] = $breadcrumb_url;
				}
			}
			else
			{
				$stock_adjust_id = $this->uri->segment(3);
				$call_back_uri = $this->uri->uri_to_assoc(4);				
				$breadcrumb[$this->lang->line("go-back")] = $this->uri->assoc_to_uri($call_back_uri);				
			}			
			if(empty($stock_adjust_id)){ redirect('stock_adjustments/report');}
			if($this->if_exists('dms_stock_adjustments',array('id'=>$stock_adjust_id,'status'=>1)) === false){
				redirect('stock_adjustments/report');
			}

			#get details of stock adjustemnts;
			$this->load->model('stocks/Stock_adjustment_model','stockadjust');
			$stock_adjust = $this->stockadjust->get_all_stock_adust_data(array('conditions'=>array('stk_adj.id'=>$stock_adjust_id)))[0];
			#get details of stock adjust items for stock adjust id;
			$stock_items = $this->stockadjust->get_all_stock_adust_items(array('conditions'=>array('stk_adj_itm.adjustment_id'=>$stock_adjust_id)));
			#template
			$this->template->title($this->lang->line('stock-adjust').' '.$this->lang->line('view'));
			$this->template->main_heading($this->lang->line('stock-adjust').' '.$this->lang->line('view'));	
			$this->template->breadcrumb($breadcrumb);
			$this->template->slice('products/stocks/adjustment/show_adjustment',array('stock_adjust'=>$stock_adjust,'stock_items'=>$stock_items));
			$this->template->render();
		}
		#--------------------------------------------------------------------------------
	}
?>