<?php if( ! defined('BASEPATH')) exit ('No direct script access allowed');
class Stock_count extends MY_Controller
{
	#-------------------------------------------------
	var $companyID,$branchID,$fiscal_start_date,$fiscal_end_date;
	
	public function __construct(){
		parent :: __construct();
		$this->check_access_right();
		
		#---------------- Checking Financial year is enabled / closed-----------------#
		$method_array = array('add');
		fiscal_status($this->uri->segment(2),$method_array,"stock_count/report");	
		#---------------- Checking Financial year is enabled / closed-----------------#	
		$this->branchID = $this->session->userdata('under_id');
		$this->companyID = $this->session->userdata('company_id');	
		$this->load->model('products/Opening_stock_model','opening_stock');
		$this->load->library(array('Stock'));
		$this->load->model('products/Item_model','item');
		$this->load->model('products/Stock_count_model','stockcountitem');
		$fiscals = $this->dms->get_fiscal_year();
		$this->fiscal_start_date = $fiscals['start_date'];
		$this->fiscal_end_date = $fiscals['end_date'];		
	}
	
	#-------------------------------------------------
	
	public function add_new()
	{ 
	    $this->template->title($this->lang->line('stock count'));
		$this->template->main_heading($this->lang->line('stock count'));
		$this->template->breadcrumb(array($this->lang->line('stock count') => 'stock_count/add',$this->lang->line('stock count') => 'no_link',$this->lang->line('report') => 'stock_count/report'));
		
	    $itemcodes = $this->item->itemcode(); 
	    $godowns = $this->stock->get_godowns(array('conditions'=>array('branch_id'=>$this->branchID)));
	    
		if(empty($godowns))
		{
			$this->message->set($this->lang->line('no-godown-found'),'i');
		}
		#---------save opening stock-----------------------------------
		$item_array = $this->input->post(NULL,true);
		foreach($godowns as $key=>$goDown)
		{
		    $goDownID = $goDown['id'];
		}
		$insertCount=0;
	    $fiscalStartDate = $this->fiscal_start_date;
	
	    $opening_amount = 0;
	    for($i=1;$i<=10;$i++)
        {
            $item_code = $item_array['code'.$i];
            $qty = $item_array['qty'.$i];
            $rate = $item_array['rate'.$i];
            $amount = $item_array['amt'.$i];
            
            if($item_code!=null )  
            { 
                $itemarray = array();
                
                $itemID = $this->stock->get_item_datas($item_code);
                $item_unit = $this->stock->get_unit_id($itemID); 
                         
                $args = array();
			    $args['select'] = array('id');
				$args['conditions'] = array('company_id'=>$this->companyID,'godown_id'=>$goDownID,'item_id'=>$itemID);
				$checkExists = $this->stockcountitem->get($args);
				if(empty($checkExists))
				{
				    $saveArray = array('company_id'=>$this->companyID,'branch_id'=>$this->branchID,'item_id'=>$itemID,'godown_id'=>$goDownID,'quantity'=>$qty,'unit_id'=>$item_unit,'rate'=>$rate,'amount'=>$amount,'status'=>1);
					if($this->stockcountitem->save($saveArray))
					{
					    $insertCount ++;
					}
					$this->message->set($this->lang->line('stock-saved'));
				}
				else
				{
				    $this->message->set($this->lang->line('stock-exists'));
                }
			}
        }

	    #---------save stock count-----------------------------------		
		$this->template->slice('dms/message');
		$this->template->slice('products/stock_count/add',array('items'=>$items,'itemcodes'=>$itemcodes,'godowns'=>$godowns,'checkedItems'=>$checkedArray,'symbol'=>$unit_symbol,'unit_symbol'=>$unit_symbol,'unit_name'=>$unit_name));
		$this->template->other_script(array('products/add_stock_count'));
		$this->template->render();
	}
	
	public function add()
	{ 
	    $this->template->title($this->lang->line('stock count'));
		$this->template->main_heading($this->lang->line('stock count'));
		$this->template->breadcrumb(array($this->lang->line('stock count') => 'stock_count/add',$this->lang->line('stock count') => 'no_link',$this->lang->line('report') => 'stock_count/report'));
		
	    $itemcodes = $this->item->itemcode(); 
	    $godowns = $this->stock->get_godowns(array('conditions'=>array('branch_id'=>$this->branchID)));
	    
		if(empty($godowns))
		{
			$this->message->set($this->lang->line('no-godown-found'),'i');
		}
		#---------save opening stock-----------------------------------
		$item_array = $this->input->post(NULL,true);
		foreach($godowns as $key=>$goDown)
		{
		    $goDownID = $goDown['id'];
		}
		$insertCount=0;
    	$fiscalStartDate = $this->fiscal_start_date;
    	$group_id = $this->stock->get_group_id('stock_count_new');
    	
	    #---------------------------------------------------------------------------------------------------
	
	    $this->form_validation->set_rules('bdaymonth','month','required|xss_clean|trim');
	    if(isset($_POST['save']))
		{  
	        if($this->form_validation->run() === true)
		    {
		        $company_id = $this->companyID;
		        $branch_id = $this->branchID;
		        
            	$bdaymonth=$this->input->post('bdaymonth',true);
            	$month = date('m', strtotime($bdaymonth));
            	$year = date('Y',strtotime($bdaymonth));
            	$cur_date = date('Y-m-d');
            	if(!empty($bdaymonth))
            	{
                	$new_rate = array();
                	$new_rate['month'] = $month;
                	$new_rate['year'] = $year;
                	$new_rate['group_id'] = $group_id;
                	$new_rate['date'] = $cur_date;
                	$new_rate['branch_id'] = $this->branchID;
	                $new_rate['status'] =-1;
	
	                $this->stockcountitem->newsave($new_rate);
	            }
	
	            $amount =0;
	            for($i=1;$i<=100;$i++)
                {
                    $item_code = $item_array['code'.$i];
                    $qty = $item_array['qty'.$i];
                    
                    if($item_code!=null )  
                    { 
                        $itemarray = array();
                        $itemID = $this->stock->get_item_datas($item_code);
                        $item_unit = $this->stock->get_unit_id($itemID); 
                        $rate = $this->stock->get_item_rate($itemID);
                        $lcost = $this->stock->get_item_landcost($itemID);
                        $amount = $qty*$rate;
                       
			        	$this->db->query("insert into stock_lmsb_backup values('','$company_id','$branch_id','$itemID','$goDownID','$qty','$item_unit','$lcost','$rate','$amount','$group_id','1')");
			        	
			        	$args = array();
			        	$args['columns'] = array('a.id','a.company_id','a.godown_id','a.item_id','a.quantity','a.unit_id','a.rate','a.amount','b.group_id');
			        	$args['conditions'] = array('a.company_id'=>$this->companyID,'a.godown_id'=>$goDownID,'a.item_id'=>$itemID,'b.month'=>$month,'b.year'=>$year,'b.group_id'=>$group_id);
			        	
				        $checkExists = $this->stockcountitem->get($args);
				        if(empty($checkExists))
				        {
				            $saveArray = array('company_id'=>$this->companyID,'branch_id'=>$this->branchID,'item_id'=>$itemID,'godown_id'=>$goDownID,'quantity'=>$qty,'unit_id'=>$item_unit,'landing_cost'=>$lcost,'rate'=>$rate,'amount'=>$amount,'group_id'=>$group_id,'status'=>1);
					        
					        if($this->stockcountitem->save($saveArray))
					        {
					            $insertCount ++;
                            }
					        
					        $new_save = array();
                        	$new_save['company_id'] = $this->companyID;
                        	$new_save['item_id'] = $itemID;
                        	$new_save['rate'] = $rate;
                        	$new_save['landing_cost'] = $lcost;
                        	$new_save['valid_from'] = $cur_date;
                        	$new_save['status'] =1;   
                        	$this->stockcountitem->itemsave($new_save);
					   
					        $this->stockcountitem->update(array('table' => 'stock_count_new','data' => array('status' => 1),'conditions' => array('status' =>-1,'month' =>$month,'year' =>$year,'branch_id' =>$this->session->userdata('under_id'),'group_id'=>$group_id)));
                            $this->message->set($this->lang->line('stock-saved'));
				        }
				        else
				        { 
				            $upid = $checkExists['id'];
				            $new_qty = $qty+$checkExists['quantity'];
				            $new_amt = $new_qty*$rate;
				            
				            $this->stockcountitem->update(array('table' => 'stock_lmsb','data' => array('quantity' => $new_qty,'amount' =>$new_amt),'conditions' => array('id' =>$upid)));
					        $this->message->set($this->lang->line('stock-saved'));
				        }
				    }
                }
		    }
        }
        
	    #---------save stock count-----------------------------------		
		$this->template->slice('dms/message');
		$this->template->slice('products/stock_count/add_new',array('items'=>$items,'itemcodes'=>$itemcodes,'godowns'=>$godowns,'checkedItems'=>$checkedArray,'symbol'=>$unit_symbol,'unit_symbol'=>$unit_symbol,'unit_name'=>$unit_name));
		$this->template->other_script(array('products/add_stock_count'));
		$this->template->render();
	}
	
	#-------------------------------------------------------------------------------------------------------------------------------------
	
	public function report()
	{  
	    #pagination
   	 	$this->load->library('Pagination');
   	 	$like_array = array(); $like_arr = array();
   	 	
   	 	$redirect ='/br/'.$brchname;
   	 	$cond="";
   	 	$cond = array('status'=>1);
   	 	$config['total_rows'] = $this->stockcountitem->get_all_mnth(array('conditions'=>$cond,'numrows'=>TRUE));
   	 	if($config['total_rows']==0)
   	 	{
   	 		$this->message->set($this->lang->line('stock-not-found'),'i');
   	 	}
   	 	$config['base_url'] = base_url('stock_count/report');
   	 	$config['per_page'] = $this->per_page();
		# Pagination Config Customizations
        $config['full_tag_open'] = '<ul class="pagination">';
        $config['full_tag_close'] = '</ul>';
        $config['first_link'] = 'First';
        $config['last_link'] = 'Last';
        $config['next_link'] = '&raquo;';
        $config['prev_link'] = '&laquo;';
        $config['cur_tag_open'] = '<li class="active"><a href="#">';
        $config['cur_tag_close'] = '</a></li>';
        $config['num_tag_open'] = '<li>';
        $config['num_tag_close'] = '</li>';
   	 	$config['uri_segment'] = 3;
   	 	
   	 	#----------validation
	    $this->pagination->initialize($config);
   	 	$links = $this->pagination->create_links();
   	 	$offset = $this->uri->segment($config['uri_segment'],0);

        $items = $this->stockcountitem->get_all_mnth(array('conditions'=>$cond,'like' => $like_array,'order_by'=>'cm.group_id','order'=>'ASC','limit'=>$config['per_page'],'offset'=>$offset));
        $this->template->title($this->lang->line('stock count'));
		$this->template->main_heading($this->lang->line('stock count'));
		$this->template->breadcrumb(array($this->lang->line('stock count') => 'stock_count/add',$this->lang->line('stock count') => 'no_link',$this->lang->line('report') => 'stock_count/report'));
  
	    #---------save stock count-----------------------------------		
		$this->template->slice('dms/message');
		$this->template->slice('products/stock_count/report',array('items'=>$items,'offset'=>$offset,'links'=>$links));
		$this->template->other_script(array('products/add_stock_count'));
		$this->template->render();
	}
	
	public function view()
	{ 
	    #pagination
	    #----------uri array
    	
    	$group_id = $this->uri->segment(3);
	    $this->load->library('Pagination');
   	 	$like_array = array();$like_arr = array();
   	 	#----------redirect
    	$redirect = "";
   	 	$redirect .='/gid/'.$group_id;
   	 	$cond="";
   	 	$cond = array('cm.group_id'=>$group_id,'cm.status'=>1);
   	 	$config['total_rows'] = $this->stockcountitem->get_all(array('conditions'=>$cond,'numrows'=>TRUE));
   	 	if($config['total_rows']==0)
   	 	{
   	 		$this->message->set($this->lang->line('stock-not-found'),'i');
   	 	}
   	 	
   	 	$config['base_url'] = base_url('stock_count/view/'.$group_id);
   	 	$config['per_page'] = $this->per_page();
		# Pagination Config Customizations
        $config['full_tag_open'] = '<ul class="pagination">';
        $config['full_tag_close'] = '</ul>';
        $config['first_link'] = 'First';
        $config['last_link'] = 'Last';
        $config['next_link'] = '&raquo;';
        $config['prev_link'] = '&laquo;';
        $config['cur_tag_open'] = '<li class="active"><a href="#">';
        $config['cur_tag_close'] = '</a></li>';
        $config['num_tag_open'] = '<li>';
        $config['num_tag_close'] = '</li>';
   	 	$config['uri_segment'] = 4;
   	 	
   	 	$cond1 = "";
   	 	$cond1 = array('cm.group_id'=>$group_id,'cm.status'=>1);
   	 	$stock = $this->stockcountitem->get_all_mnth(array('conditions'=>$cond1));
   	 	$up_status = $stock[0]['up_status'];
        
        #----------validation
	    $this->pagination->initialize($config);
   	 	$links = $this->pagination->create_links();
   	 	$offset = ($this->uri->segment(4))?$this->uri->segment(4):0;

        $items = $this->stockcountitem->get_all(array('conditions'=>$cond,'like' => $like_array,'limit'=>$config['per_page'],'offset'=>$offset));
        $this->template->title($this->lang->line('stock count'));
		$this->template->main_heading($this->lang->line('stock count'));
		$this->template->breadcrumb(array($this->lang->line('stock count') => 'stock_count/add',$this->lang->line('stock count') => 'no_link',$this->lang->line('report') => 'stock_count/report'));

	    #---------save stock count-----------------------------------		
		$this->template->slice('dms/message');
		$this->template->slice('products/stock_count/view',array('items'=>$items,'group_id'=>$group_id,'ustatus'=>$up_status,'count'=>$offset+1,'links'=>$links,'redirect'=>$redirect));
		$this->template->other_script(array('products/add_stock_count'));
		$this->template->render();
	}
	
	public function delete()
	{
		#----------sales primary key
		$group_id = $this->uri->segment(3);
		
		#----------redirect uri
		$redirect_uri = "stock_count/report";

        $cond = array('cm.group_id'=>$group_id,'cm.status'=>1);
		$result = $this->stockcountitem->get_all_mnth(array('conditions'=>$cond));
		if(!empty($result))
		{ 
			$row = $result[0];
			$continue = 1;
			
			if($row['status'] == -1)
			{
				if($row['created_by'] != $this->session->userdata('id'))
				{
					$continue = 0;
				}
			}
			
			if($continue == 1)
		    {
				if($this->stockcountitem->update(array('table' => 'stock_count_new','data' => array('status' => 0),'conditions' => array('group_id' => $group_id))))
				{
					$this->message->set($this->lang->line('stock-delete-success'));
				}
				else
				{
				    $this->message->set($this->lang->line('stock-delete-error'),'e');
				}
		    }	
			else
			{
				redirect('users/logout');
			}
			
			redirect($redirect_uri); 
		}
		redirect('users/logout');
	}
	
	public function update_item()
	{
		#----------sales primary key
		if($this->uri->segment(4) != 'gid')
		{
		    $id = $this->uri->segment(4);
		}
		$group_id = $this->uri->segment(6);
		
		#----------redirect uri
		$redirect_uri = "stock_count/view/$group_id";
		
		$itemcodes = $this->item->itemcode(); 
	    $godowns = $this->stock->get_godowns(array('conditions'=>array('branch_id'=>$this->branchID)));

        $cond = array('cm.id'=>$id,'cm.group_id'=>$group_id,'cm.status'=>1);
		$result = $this->stockcountitem->get_all(array('conditions'=>$cond));
		
		if(!empty($result))
		{
		    $this->form_validation->set_rules('code','lang:code','required|xss_clean');
		    $this->form_validation->set_rules('qty','lang:quantity','required|xss_clean|greater_than[0]|less_than[100000000]');
		    
		    if($this->form_validation->run() === true)
			{
		        $item_temp_array = $this->input->post(NULL,true);
		    
		        $upid = $item_temp_array['upid'];
		        $grpid = $item_temp_array['grpid'];
		        $item_code = $item_temp_array['code'];
		        
		        $itemID = $this->stock->get_item_datas($item_code);
                $item_unit = $this->stock->get_unit_id($itemID); 
                
                $item_array = array('item_id'=>$itemID,'quantity'=>$item_temp_array['qty'],'unit_id'=>$item_unit,'landing_cost'=>$item_temp_array['lcost'],'rate'=>$item_temp_array['rate'],'amount'=>$item_temp_array['amt']);
		    
    			if($this->stockcountitem->update(array('table' => 'stock_lmsb','data' => $item_array,'conditions' => array('id' => $upid,'group_id' => $grpid))))
    			{
    				$this->message->set($this->lang->line('stock-edit-success'));
    			}
    			else
    			{
    				$this->message->set($this->lang->line('stock-edit-error'),'e');
    			}
		    
			    redirect($redirect_uri);
			}
		}	
		$this->template->slice('dms/message');
		$this->template->breadcrumb(array($this->lang->line('stock count') => 'stock_count/add',$this->lang->line('stock count') => 'no_link',$this->lang->line('report') => 'stock_count/report'));
		$this->template->slice('products/stock_count/update_item',array('result'=>$result[0],'upid'=>$id,'group_id'=>$group_id,'itemcodes'=>$itemcodes,'godowns'=>$godowns));
		$this->template->other_script(array('products/stock_entry_item'));
		$this->template->render();
	}
	
	public function delete_item()
	{
		#----------sales primary key
		if($this->uri->segment(4) != 'gid')
		{
		    $id = $this->uri->segment(4);
		}
		$group_id = $this->uri->segment(6);
		
		#----------redirect uri
		$redirect_uri = "stock_count/view/$group_id";

        $cond = array('cm.id'=>$id,'cm.group_id'=>$group_id,'cm.status'=>1);
		$result = $this->stockcountitem->get_all(array('conditions'=>$cond));
		if(!empty($result))
		{ 
			if($this->stockcountitem->update(array('table' => 'stock_lmsb','data' => array('status' => 0),'conditions' => array('id' => $id,'group_id' => $group_id))))
			{
				$this->message->set($this->lang->line('stock-delete-success'));
			}
			else
			{
				$this->message->set($this->lang->line('stock-delete-error'),'e');
			}
		    
			redirect($redirect_uri); 
		}
		redirect('users/logout');
	}
	
	public function merge()
	{
	    $qry = $this->db->select(array('id','item_id','godown_id','quantity','unit_id','landing_cost','rate'))->get_where('stock_lmsb',array('group_id >' => 4))->result_array();
	    foreach($qry as $k => $v)
	    {
	        $qry1 = $this->db->select(array('id','quantity','unit_id','landing_cost','rate'))->get_where('stock_lmsb',array('item_id'=>$v['item_id'],'group_id' => 33))->row_array();
	        if(!empty($qry1))
	        {
	            $qty = $v['quantity']+$qry1['quantity'];
	            $amount = $qty * $v['rate'];
	            // $this->db->query("update stock_lmsb set quantity='$qty',amount='$amount' where id='$qry1[id]' and group_id='33'");
	        }
	        else
	        {
	            $amt = $v['quantity'] *$v['rate'];
	            //  $this->db->query("insert into stock_lmsb values('','1','18','$v[item_id]','19','$v[quantity]','$v[unit_id]','$v[landing_cost]','$v[rate]','$amt','33')");
	        }
	    }
	}
	
	#----------------------------------------------update stock---------------------------------------------------------	
	public function update_stock()
	{ 
	    #pagination
	    $group_id = $this->uri->segment(3);
   	 	$this->load->library('Pagination');
   	 	$like_array = array();$like_arr = array();
   	 	$company_id = $this->companyID;
   	 	$branch_id = $this->session->userdata('under_id');
        $godown_id = $this->stock->get_branch_godown($branch_id);
   	 	$cond="";
   	 	$cond = array('cm.group_id'=>$group_id);
   	 	$date = date('Y-m-d');
   	 	    
   	 	$config['total_rows'] = $this->stockcountitem->get_allstock(array('conditions'=>$cond,'numrows'=>TRUE));
   	 	if($config['total_rows']==0)
   	 	{
   	 		$this->message->set($this->lang->line('stock-not-found'),'i');
   	 	}
   	 	$config['base_url'] = base_url('stock_count/update_stock/'.$group_id);
   	 	$config['per_page'] = 50;
   	 	$config['uri_segment'] = 4;
        # Pagination Config Customizations
        $config['full_tag_open'] = '<ul class="pagination">';
        $config['full_tag_close'] = '</ul>';
        $config['first_link'] = 'First';
        $config['last_link'] = 'Last';
        $config['next_link'] = '&raquo;';
        $config['prev_link'] = '&laquo;';
        $config['cur_tag_open'] = '<li class="active"><a href="#">';
        $config['cur_tag_close'] = '</a></li>';
        $config['num_tag_open'] = '<li>';
        $config['num_tag_close'] = '</li>';
        #----------validation
	    $this->pagination->initialize($config);
   	 	$links = $this->pagination->create_links();
   	 	$offset = ($this->uri->segment(4))?$this->uri->segment(4):0;
   	 	
   	 	$stock_det = $this->db->query("select * from stock_count_new where group_id = '$group_id'")->result_array();
   	 	$sdate = $stock_det[0]['date'];

        $items = $this->stockcountitem->get_allstock(array('conditions'=>$cond,'like' => $like_array,'order_by'=>'created_on','order'=>'DESC','limit'=>$config['per_page'],'offset'=>$offset));
        $itemsnm = $this->stockcountitem->get_allstock(array('conditions'=>$cond,'like' => $like_array,'order_by'=>'created_on','order'=>'DESC'));
        if(empty($items))
        {
   	 	    $this->message->set($this->lang->line('stock-not-found'),'i');
   	 	}
   	 	
   	 	if(isset($_POST['btn_add']))
		{
   	 	    $k=0;
   	 	    
   	 	    foreach($itemsnm as $itm)
   	 	    {
   	 	        $item_id = $itm['item_id'];
   	 	        $qunty = $itm['quantity'];
   	 	        
   	 	        $stock_bal = $this->stock->get_stock_count($godown_id,$item_id,$date);
   	 	        
   	 	        $qty = $qunty-$stock_bal;
   	 	        
   	 	        
   	 	        
   	 	        
   	 	        
   	 	        
   	 	    //   $this->db->query("update dms_stocks set status=2 where branch_id='$branch_id' and stock_date <= '$sdate' and item_id='$item_id' and status=1");
   	 	    
   	 	        if($qty!=0)
			    {
   	 	            $this->db->query("insert into dms_stocks values('','$company_id','$branch_id','$godown_id','$item_id','$qty','1','0','0','$sdate','9','0','0','1','0','')");
   	 	            $k++;
			    }
   	 	        
   	 	     /*   $date=$itm['date'];
   	 	        $item_id=$itm['item_id'];
   	 	        $unit_id = $this->stock->get_unit_id($item_id);
   	 	        $qunty=$itm['quantity'];
   	 	        $stock_bal=$this->stock->get_stock_count($godown_id,$item_id,$date);
   	 	        $differ = $qunty-$stock_bal;
   	 	        $stock['table_id'] = 0;
   	 	        $stock['company_id'] = $this->companyID;
		        $stock['branch_id'] = $branch_id;
				$stock['item_id'] = $item_id;
				$stock['godown_id'] = $godown_id;
				$stock['qty'] = $differ;
				$stock['unit_id'] = $unit_id;
				$stock['rate'] = 0;
				$stock['stock_date'] = $date;
				$stock['stock_status'] = 9;
				$stock['table_group_id'] =  0;
				
				if($stock['qty'] !=0)
				{
				    $this->stockcountitem->savenew($stock);
					
					$k=1;
					$stock_count = $this->stock->get_stock_count($stock['godown_id'],$stock['item_id']);
					$this->stockcountitem->update(array('table' => 'item_stock','data' => array('qty' => $stock_count),'conditions' => array('branch_id' =>$this->session->userdata('under_id'),'item_id' =>$stock['item_id'])));
				}*/
			}
   	 	    if($k>1)
   	 	    {
   	 	        $this->stockcountitem->update(array('table' => 'stock_count_new','data' => array('up_status' => 1),'conditions' => array('status' =>1,'group_id'=>$group_id,'branch_id' =>$this->session->userdata('under_id'))));
                $this->message->set($this->lang->line('stock-updt'),'s');
   	 	    }
   	 	}
   	 		
        $this->template->title($this->lang->line('stock count'));
		$this->template->main_heading($this->lang->line('stock count'));
		$this->template->breadcrumb(array($this->lang->line('stock count') => 'stock_count/add',$this->lang->line('stock count') => 'no_link',$this->lang->line('report') => 'stock_count/update_stock'));
     
	    #---------save stock count-----------------------------------		
		$this->template->slice('dms/message');
		$this->template->slice('products/stock_count/update_stock',array('items'=>$items,'count'=>$offset+1,'links'=>$links,'godown_id'=>$godown_id));
		$this->template->other_script(array('products/add_stock_count'));
		$this->template->render();
	}
	
}