<?php if( ! defined('BASEPATH')) exit ('No direct script access allowed');

class Stock_monthly_reports extends MY_Controller{

	public function __construct()
	{
		parent :: __construct();
		$this->check_access_right();

		$this->load->library(array('Stock','Stock_summary','Accounts'));
	}

	public function index($id = NULL)
	{
		$fiscal_start_date = $this->dms->get_fiscal_year()['start_date'];
		$from_date = $to_date = date('Y-m-d'); //$fiscal_start_date;
		$item_id = $tbp = $redirect_uri = "";$stock_array = array();

		#------------uri array
		$uri_array = $this->uri->uri_to_assoc(3);

		#-------------breadcrumb
		$breadcrumb = array($this->lang->line('stock-summary') => 'no_link',$this->lang->line('monthly-stock') => 'no_link');

		if(isset($_POST['btn_search']))
		{
			#-------------validation
			$this->form_validation->set_rules('item_id','lang:item','xss_clean|required');
			$this->form_validation->set_rules('from_date','lang:from-date','xss_clean|required|valid_date');
			$from_date = $this->input->post('from_date',true);
			$this->form_validation->set_rules('to_date','lang:to-date',"xss_clean|required|valid_date|check_date[$from_date.>=]");
			if($this->form_validation->run() === true)
			{
				$item_id = $this->input->post('item_id',true);
				$redirect_uri = "/mid/".$item_id;
				$from_date = date('Y-m-d',strtotime($this->input->post('from_date',true)));
				$to_date = date('Y-m-d',strtotime($this->input->post('to_date',true)));
				$this->session->set_userdata(array('from_date' => $from_date,'to_date' => $to_date));
			}
		}
		else
		{
			if($this->session->userdata('from_date') && $this->session->userdata('to_date'))
			{
				$from_date = $this->session->userdata('from_date');
				$to_date = $this->session->userdata('to_date');

				#----------validating dates
				if(!$this->form_validation->valid_date($from_date) || !$this->form_validation->valid_date($to_date)){
					redirect('users/logout');
				}
				else{
					if(!$this->form_validation->check_date($from_date,$to_date.".<=")){
						redirect('users/logout');
					}
				}
			}
			if(isset($uri_array['id']))
			{
				$item_id = $uri_array['id'];

				$breadcrumb[$this->lang->line("go-back")] = "stock_register/index";
				$redirect_uri = "/id/".$item_id;
				if(isset($uri_array['rtype']))
				{
					$tbp = $uri_array['rtype'];
					$breadcrumb[$this->lang->line("go-back")] .= "/rtype/".$tbp;
					$redirect_uri .= "/rtype/".$tbp;
				}
			}
			elseif(isset($uri_array['mid']))
			{
				$item_id = $uri_array['mid'];
				$redirect_uri = "/mid/".$item_id;
			}
		}

		if(!empty($item_id) && !empty($from_date) && !empty($to_date))
		{
			$from_time = strtotime($from_date);
			$to_time = strtotime($to_date);
			$from_year = date('Y',$from_time);
			$to_year = date('Y',$to_time);
			$from_month = date('n',$from_time);
			$to_month = date('n',$to_time);
			$month_array = $this->dms->get_months($from_date,$to_date,1);
			$pre_from_date = date('Y-m-d',($from_time-86400));
			$pre_to_date = date('Y-m-d',($to_time-86400));

			#-----------starting fiscal year details
			$fiscal_details = $this->dms->get_default();

			#-------------opening stock calculation
			if($fiscal_start_date == $from_date)
			{
				$opening_item_qty = $this->accounts->item_bal_qty_new($item_id,$fiscal_details['start_date'],$pre_from_date);

				if($opening_item_qty > 0)
				{
					#-----------last closed year details
					$closed_details = $this->accounts->last_closed_yr($fiscal_start_date);

					#-----------stock value type(0 => avg.cost , 1 => last_purchase_cost)
					$stock_value_type = $this->dms->stock_value_type($closed_details['id']);

					$opening_item_rate = $this->accounts->item_rate($item_id,$closed_details['start_date'],$closed_details['end_date'],0,$stock_value_type);
				}
				else
				{
					#-----------stock value type(0 => avg.cost , 1 => last_purchase_cost)
					$stock_value_type = $this->dms->stock_value_type();

					$opening_item_qty = $this->stock_summary->item_opening_qty($item_id,$fiscal_start_date);
					$opening_item_rate = $this->stock_summary->item_opening_rate($item_id,$fiscal_start_date);
				}
			}
			else
			{
				#-----------stock value type(0 => avg.cost , 1 => last_purchase_cost)
				$stock_value_type = $this->dms->stock_value_type();

				$opening_item_qty = $this->accounts->item_bal_qty($item_id,$fiscal_details['start_date'],$pre_from_date);
				$opening_item_rate = $this->accounts->item_rate($item_id,$fiscal_start_date,$pre_to_date,0,$stock_value_type);
			}

			#----------opening value
			$opening_item_value = round_this($opening_item_qty * $opening_item_rate);

			#-----------stock value type(0 => avg.cost , 1 => last_purchase_cost)
			$stock_value_type = $this->dms->stock_value_type();

			$closing_qty = $opening_item_qty;
			foreach($month_array as $key => $value)
			{
				$item_inwards = $this->stock_summary->item_inwards_qty_rate($item_id,$value['from_date'],$value['to_date']);
				$item_outwards = $this->stock_summary->item_outwards_qty_rate($item_id,$value['from_date'],$value['to_date']);

				#-----------closing qty and value
				$closing_qty += ($item_inwards['qty'] - $item_outwards['qty']);
				$item_rate = $this->accounts->item_rate($item_id,$value['from_date'],$value['to_date'],0,$stock_value_type);
				$closing_value = round_this($closing_qty * $item_rate);

				$stock_array[$key] = array('month' => $value['month'],'item_inwards' => $item_inwards,'item_outwards' => $item_outwards,'closing_qty' => $closing_qty,'closing_value' => $closing_value,'from_date' => $value['from_date'],'to_date' => $value['to_date']);
			}
		}

		#-------------stock item details
		$item_array = $this->stock->get_stock_items();
		$item_array[''] = "Select";
		ksort($item_array);

		#-------------template
		$this->template->title('Stock Item Monthly Report');
		$this->template->main_heading('Stock Item Monthly Report');

		$this->template->breadcrumb($breadcrumb);
		$this->template->slice('stock_summary/stock_search',array('from_date' => $from_date,'to_date' => $to_date,'item_array' => $item_array,'item_id' => $item_id));
		if(!empty($stock_array) || !empty($opening_item_qty))
		{
			$access_rights = $this->have_access(447);

			#---------item unit name
			$unit = "";
			$unit_details = $this->stock_summary->getItemUnit($item_id);
			if($unit_details){
				$unit = $unit_details['symbol'];
			}

			$this->template->append('stock_summary/monthly_stock_items',array('opening_item_qty' => $opening_item_qty,'opening_item_value' => $opening_item_value,'unit' => $unit,'stock_array' => $stock_array,'access_rights' => $access_rights,'from_date' => $from_date,'to_date' => $to_date,'item_id' => $item_id,'redirect_uri' => $redirect_uri));
		}
		else{
			$this->message->set($this->lang->line('no-result-found'),'i');
		}
		$this->template->slice('dms/message');
		$this->template->render();
	}
}