<?php if( ! defined('BASEPATH')) exit ('No direct script access allowed');

class Stock_register extends MY_Controller{

	public function __construct()
	{
		parent :: __construct();
		$this->check_access_right();
		
        $this->load->model('booking/Booking_model','sales_obj');
        $this->load->model('branches/Branch_model','branch_obj');
        $this->load->model('products/Item_model','item_obj');
		$this->load->library(array('Stock','Stock_summary','Accounts'));
	}

	public function index1()
	{
		$fiscal_start_date = $this->dms->get_fiscal_year()['start_date'];
		$from_date = $to_date = date('Y-m-d'); //$fiscal_start_date;
		$stock_array = array();$tbp = "";

		#------------uri array
		$uri_array = $this->uri->uri_to_assoc(3);

		#------------breadcrumb
		$breadcrumb = array($this->lang->line('stock-summary') => 'no_link',$this->lang->line('stock-register') => 'no_link');

		if(isset($_POST['btn_search']))
		{
			#-------------validation
			$this->form_validation->set_rules('from_date','lang:from-date','required|xss_clean|valid_date');
			if($this->input->post('from_date',true))
			{
				$from_date = $this->input->post('from_date',true);
				$this->form_validation->set_rules('to_date','lang:to-date',"required|xss_clean|valid_date|check_date[$from_date.>=]");
			}
			if($this->form_validation->run() === true)
			{
				$from_date = date('Y-m-d',strtotime($this->input->post('from_date',true)));
				$to_date = date('Y-m-d',strtotime($this->input->post('to_date',true)));
				$this->session->set_userdata(array('from_date' => $from_date,'to_date' => $to_date));
			}
		}
		else
		{
			if($this->session->userdata('from_date') && $this->session->userdata('to_date'))
			{
				$from_date = date('Y-m-d',strtotime($this->session->userdata('from_date')));
				$to_date = date('Y-m-d',strtotime($this->session->userdata('to_date')));

				#----------validating dates
				if(!$this->form_validation->valid_date($from_date) || !$this->form_validation->valid_date($to_date)){
					redirect('users/logout');
				}
				else{
					if(!$this->form_validation->check_date($from_date,$to_date.".<=")){
						redirect('users/logout');
					}
				}
			}
			if(isset($uri_array['rtype']))
			{
				$tbp = $uri_array['rtype'];
				if($tbp == 't')
				{
					$breadcrumb[$this->lang->line("go-back")] = "trial_balance/index";
				}
				elseif($tbp == 'b')
				{
					$breadcrumb[$this->lang->line("go-back")] = "balance_sheet/index";
				}
				elseif($tbp == 'p')
				{
					$breadcrumb[$this->lang->line("go-back")] = "profit_loss/index";
					/*if($this->uri->segment(4))
					{
						$from_date = date('Y-m-d',strtotime($this->uri->segment(4)));
						$to_date = $from_date;

						#----------validating dates
						if(!$this->form_validation->valid_date($from_date)){
							redirect('users/logout');
						}
					}*/
				}
			}
		}
		if(!empty($from_date) && !empty($to_date))
		{
			#-----------stock items
			
			$items = $this->stock_summary->get_items();
            //print_r($items);
			#-----------starting fiscal year details
			$fiscal_details = $this->dms->get_default();
//print_r($fiscal_details);
			#-----------stock value type(0 => avg.cost , 1 => last_purchase_cost)
			$stock_value_type = $this->dms->stock_value_type();
			//print_r($stock_value_type);
			$branch_id = $this->session->userdata('under_id');
    		$godown_id = $this->stock->get_branch_godown($branch_id);     
    		 //print_r($godown_id);

			foreach($items as $ikey => $ivalue)
			{ 
			   //$item_rate = $this->accounts->item_rate($ivalue['id'],$from_date,$to_date,0,$stock_value_type);//print_r($item_rate);
					//$unit_name = $this->stock->get_unit_symbol($ivalue['unit_id']);//print_r($unit_name);
					//$qty=$this->stock_summary->get_qty($ivalue['id']);
					//$item_count = $this->accounts->item_bal_qty_new($ivalue['id'],$fiscal_details['start_date'],$to_date);//print_r($item_count);
			    //$stock_array[$ivalue['id']] = array('item_code' => $ivalue['item_code'],'item_name' => $ivalue['item_name'],'item_count' =>$qty,'unit' => $unit_name);
			$item_count = $this->accounts->item_bal_qty_new($ivalue['id'],$fiscal_details['start_date'],$to_date);//print_r($item_count);
			//$item_count = $this->stock->get_stock_count($godown_id,$ivalue['id'],$to_date);
				if($item_count > 0)
				{
					$item_rate = $this->accounts->item_rate($ivalue['id'],$from_date,$to_date,0,$stock_value_type);
					$unit_name = $this->stock->get_unit_symbol($ivalue['unit_id']);
					$stock_array[$ivalue['id']] = array('item_code' => $ivalue['item_code'],'item_name' => $ivalue['item_name'],'item_count' => $item_count,'item_rate' => $item_rate,'unit' => $unit_name);
				} 
			}
		}

		#-------------template
		$this->template->title('Stock Register');
		$this->template->main_heading('Stock Register');
		$this->template->breadcrumb($breadcrumb);
		$this->template->slice('stock_summary/stock_search',array('from_date' => $from_date,'to_date' => $to_date,'astatus' => 1));
		if(!empty($stock_array))
		{
			$access_rights = $this->have_access(535);
			$this->template->append('stock_summary/stock_register',array('stock_array' => $stock_array,'access_rights' => $access_rights,'from_date'=>$from_date,'to_date'=>$to_date,'tbp' => $tbp));
		}
		else
		{
			$this->message->set($this->lang->line('no-result-found'),'i');
		}
		$this->template->slice('dms/message');
		$this->template->render();
	}
	
	#-------------------------------------------------------------------------------------------------------------#
	
	public function index()
	{
		$fiscal_start_date = $this->dms->get_fiscal_year()['start_date'];
		$from_date = $to_date = date('Y-m-d'); //$fiscal_start_date;
		$stock_array = array();$tbp = "";

		#------------uri array
		$uri_array = $this->uri->uri_to_assoc(3);

		#------------breadcrumb
		
		$breadcrumb = array($this->lang->line('stock-summary') => 'no_link',$this->lang->line('stock-register') => 'no_link');

		if(isset($_POST['btn_search']))
		{
			#-------------validation
			$this->form_validation->set_rules('from_date','lang:from-date','required|xss_clean|valid_date');
			if($this->input->post('from_date',true))
			{
				$from_date = $this->input->post('from_date',true);
				$this->form_validation->set_rules('to_date','lang:to-date',"required|xss_clean|valid_date|check_date[$from_date.>=]");
			}
			if($this->form_validation->run() === true)
			{
				$from_date = date('Y-m-d',strtotime($this->input->post('from_date',true)));
				$to_date = date('Y-m-d',strtotime($this->input->post('to_date',true)));
				$this->session->set_userdata(array('from_date' => $from_date,'to_date' => $to_date));
			}
		}
		else
		{
			if($this->session->userdata('from_date') && $this->session->userdata('to_date'))
			{
				$from_date = date('Y-m-d',strtotime($this->session->userdata('from_date')));
				$to_date = date('Y-m-d',strtotime($this->session->userdata('to_date')));

				#----------validating dates
				if(!$this->form_validation->valid_date($from_date) || !$this->form_validation->valid_date($to_date)){
					redirect('users/logout');
				}
				else{
					if(!$this->form_validation->check_date($from_date,$to_date.".<=")){
						redirect('users/logout');
					}
				}
			}
			if(isset($uri_array['rtype']))
			{
				$tbp = $uri_array['rtype'];
				if($tbp == 't')
				{
					$breadcrumb[$this->lang->line("go-back")] = "trial_balance/index";
				}
				elseif($tbp == 'b')
				{
					$breadcrumb[$this->lang->line("go-back")] = "balance_sheet/index";
				}
				elseif($tbp == 'p')
				{
					$breadcrumb[$this->lang->line("go-back")] = "profit_loss/index";
				
				}
			}
		}
        if(!empty($from_date) && !empty($to_date))
		{
		    //$from_date = $fiscal_start_date;
			#-----------stock items
			$chunkSize = 1000;
			$items = $this->stock_summary->get_items_stock();
            
			#-----------starting fiscal year details
			
			$fiscal_details = $this->dms->get_default();
			
			#-----------stock value type(0 => avg.cost , 1 => last_purchase_cost)
			$stock_value_type = $this->dms->stock_value_type();
			
			$branch_id = $this->session->userdata('under_id');
    		$godown_id = $this->stock->get_branch_godown($branch_id);
    		
            $add = $this->db->query("CALL addstock('$branch_id','$fiscal_start_date','$to_date');")->result_array();
        	
    		$add_stock = array();
    		foreach($add as $v => $itm)
    		{
    		    $add_stock[$itm['item_id']] = array('item_code' => $itm['item_code'],'item_name' => $itm['item_name'], 'qty' => $itm['quantity']);
    		}
    		if ($this->db->conn_id->more_results()) 
    		{
                $this->db->conn_id->next_result();
            }
    		$min = $this->db->query("CALL minstock('$branch_id','$fiscal_start_date','$to_date');")->result_array();
    		 
    		$min_stock = array();
    		foreach($min as $v => $itm)
    		{
    		    $min_stock[$itm['item_id']] = array('item_code' => $itm['item_code'],'item_name' => $itm['item_name'], 'qty' => $itm['quantity']);
    		}
    		
            foreach($items as $ikey => $ivalue){ 
    		    
    		    
    		    $ad=0;
    			if(isset($add_stock[$ivalue['id']]))
    			{
    			    $ad=$add_stock[$ivalue['id']]['qty'];
    			}
    			
    			$mn=0;
    			if(isset($min_stock[$ivalue['id']])){
    			    $mn=$min_stock[$ivalue['id']]['qty'];
    			}
                $dif = $ad-$mn;
                if ($this->db->conn_id->more_results()) 
				{
					$this->db->conn_id->next_result();
				}
                $unit_name = $this->stock->get_unit_symbol($ivalue['unit_id']);
                $stock_array[$ivalue['id']] = array('item_code' => $ivalue['item_code'],'item_name' => $ivalue['item_name'],'model_no' => $ivalue['model_no'], 'qty' => $dif, 'rate'=>$ivalue['rate'],'lcost' =>$ivalue['landing_cost'],'unit' => $unit_name );
            }
        }
        
		#-------------template
		$this->template->title('Stock Register');
		$this->template->main_heading('Stock Register');
		$this->template->breadcrumb($breadcrumb);
		$this->template->slice('stock_summary/stock_search',array('from_date' => $from_date,'to_date' => $to_date,'astatus' => 1));
		if(!empty($stock_array))
		{
			$access_rights = $this->have_access(535);
			$this->template->append('stock_summary/stock_register',array('stock_array' => $stock_array,'access_rights' => $access_rights,'from_date'=>$from_date,'to_date'=>$to_date,'tbp' => $tbp));
		}
		else
		{
			$this->message->set($this->lang->line('no-result-found'),'i');
		}
		$this->template->slice('dms/message');
		$this->template->render();
	}
	
	public function branch()
	{
		$fiscal_start_date = $this->dms->get_fiscal_year()['start_date'];
		$from_date = $to_date = $cdate = date('Y-m-d');
		$stock_array = array();

		$uri_array = $this->uri->uri_to_assoc(3);
		
		$items = $this->item_obj->listing();

		$breadcrumb = array($this->lang->line('stock-summary') => 'no_link',$this->lang->line('branch-stock') => 'no_link');

		if(isset($_POST['btn_search']))
		{
		    $this->form_validation->set_rules('item_id','lang:item','required|xss_clean');
			$this->form_validation->set_rules('from_date','lang:from-date','required|xss_clean|valid_date');
			
			if($this->input->post('from_date',true))
			{
				$from_date = $this->input->post('from_date',true);
				$this->form_validation->set_rules('to_date','lang:to-date',"required|xss_clean|valid_date|check_date[$from_date.>=]");
			}
			if($this->form_validation->run() === true)
			{
			    $item_id = $this->input->post('item_id',true);
				$from_date = date('Y-m-d',strtotime($this->input->post('from_date',true)));
				$to_date = date('Y-m-d',strtotime($this->input->post('to_date',true)));
				
				$branches = $this->branch_obj->listing();
				$stock_array = array();
				foreach($branches as $bid => $bname)
				{
				    $godown_id = $this->stock->get_branch_godown($bid);
				    $cur_qty = $this->stock->get_stock_count($godown_id,$item_id,$cdate);
				    $sale_qty = $this->stock->get_sale_qty($godown_id,$item_id,$from_date,$to_date);
				    $purchase_qty = $this->stock->get_purchase_qty($godown_id,$item_id,$from_date,$to_date);
				    
				    $stock_array[] = array('branch'=>$bname,'cqty'=>$cur_qty,'sqty'=>$sale_qty,'pqty'=>$purchase_qty); 
				}
				
			}
		}
		
		$items[''] = 'Select';
		ksort($items);
		
		$this->template->title('Branch Stock');
		$this->template->main_heading('Branch Stock');
		$this->template->breadcrumb($breadcrumb);
		$this->template->slice('stock_summary/branch_search',array('items'=>$items,'item'=>$item_id,'from_date' => $from_date,'to_date' => $to_date,'astatus' => 1));
		if(!empty($stock_array))
		{
			$this->template->append('stock_summary/branch_stock',array('stock_array' => $stock_array,'from_date'=>$from_date,'to_date'=>$to_date));
		}
		else
		{
			$this->message->set($this->lang->line('no-result-found'),'i');
		}
		$this->template->slice('dms/message');
		$this->template->render();
	}
	
	#-------------------------------------------------------------------------------------------------------------#
	
	public function new_index()
	{
		$fiscal_start_date = $this->dms->get_fiscal_year()['start_date'];
		$from_date = $to_date = date('Y-m-d'); //$fiscal_start_date;
		$stock_array = array();$tbp = "";

		#------------uri array
		$uri_array = $this->uri->uri_to_assoc(3);

		#------------breadcrumb
		$breadcrumb = array($this->lang->line('stock-summary') => 'no_link',$this->lang->line('stock-register') => 'no_link');

		if(isset($_POST['btn_search']))
		{
			#-------------validation
			$this->form_validation->set_rules('from_date','lang:from-date','required|xss_clean|valid_date');
			if($this->input->post('from_date',true))
			{
				$from_date = $this->input->post('from_date',true);
				$this->form_validation->set_rules('to_date','lang:to-date',"required|xss_clean|valid_date|check_date[$from_date.>=]");
			}
			if($this->form_validation->run() === true)
			{
				$from_date = date('Y-m-d',strtotime($this->input->post('from_date',true)));
				$to_date = date('Y-m-d',strtotime($this->input->post('to_date',true)));
				$this->session->set_userdata(array('from_date' => $from_date,'to_date' => $to_date));
			}
		}
		else
		{
			if($this->session->userdata('from_date') && $this->session->userdata('to_date'))
			{
				$from_date = date('Y-m-d',strtotime($this->session->userdata('from_date')));
				$to_date = date('Y-m-d',strtotime($this->session->userdata('to_date')));

				#----------validating dates
				if(!$this->form_validation->valid_date($from_date) || !$this->form_validation->valid_date($to_date)){
					redirect('users/logout');
				}
				else{
					if(!$this->form_validation->check_date($from_date,$to_date.".<=")){
						redirect('users/logout');
					}
				}
			}
			if(isset($uri_array['rtype']))
			{
				$tbp = $uri_array['rtype'];
				if($tbp == 't')
				{
					$breadcrumb[$this->lang->line("go-back")] = "trial_balance/index";
				}
				elseif($tbp == 'b')
				{
					$breadcrumb[$this->lang->line("go-back")] = "balance_sheet/index";
				}
				elseif($tbp == 'p')
				{
					$breadcrumb[$this->lang->line("go-back")] = "profit_loss/index";
					/*if($this->uri->segment(4))
					{
						$from_date = date('Y-m-d',strtotime($this->uri->segment(4)));
						$to_date = $from_date;

						#----------validating dates
						if(!$this->form_validation->valid_date($from_date)){
							redirect('users/logout');
						}
					}*/
				}
			}
		}
		if(!empty($from_date) && !empty($to_date))
		{
			#-----------stock items
			$items = $this->stock_summary->get_items();

			#-----------starting fiscal year details
			$fiscal_details = $this->dms->get_default();

			#-----------stock value type(0 => avg.cost , 1 => last_purchase_cost)
			$stock_value_type = $this->dms->stock_value_type();
			
			$branch_id = $this->session->userdata('under_id');
    		$godown_id = $this->stock->get_branch_godown($branch_id);     
    		 

			foreach($items as $ikey => $ivalue)
			{ 
			/*	$item_count = $this->accounts->item_bal_qty($ivalue['id'],$fiscal_details['start_date'],$to_date);
				if($item_count > 0)
				{
					$item_rate = $this->accounts->item_rate($ivalue['id'],$from_date,$to_date,0,$stock_value_type);
					$unit_name = $this->stock->get_unit_symbol($ivalue['unit_id']);
					$stock_array[$ivalue['id']] = array('item_code' => $ivalue['item_code'],'item_name' => $ivalue['item_name'],'item_count' => $item_count,'item_rate' => $item_rate,'unit' => $unit_name);
				} */
			}
		}

		#-------------template
		$this->template->title('Stock Register');
		$this->template->main_heading('Stock Register');
		$this->template->breadcrumb($breadcrumb);
		$this->template->slice('stock_summary/stock_search',array('from_date' => $from_date,'to_date' => $to_date,'astatus' => 1));
		if(!empty($stock_array))
		{
			$access_rights = $this->have_access(535);
			$this->template->append('stock_summary/stock_register',array('stock_array' => $stock_array,'access_rights' => $access_rights,'from_date'=>$from_date,'to_date'=>$to_date,'tbp' => $tbp));
		}
		else
		{
			$this->message->set($this->lang->line('no-result-found'),'i');
		}
		$this->template->slice('dms/message');
		$this->template->render();
	}
	
	
	
	
	#-------------------------------------------------------------------------------------------------------------#
	public function view_stock()
	{
	    $this->load->model('products/Item_model','item_obj');
	    $company_id= $this->session->userdata('company_id');
	     $branch_id = $this->session->userdata('under_id');
    	 $godown_id = $this->stock->get_branch_godown($branch_id); 
    	 $items = $this->item_obj->get_vstok();
	//print_r($items);
	#-------------template
		$this->template->title('Stock Register');
		$this->template->main_heading('Stock Register');
		$this->template->breadcrumb($breadcrumb);
		$this->template->slice('stock_summary/stock_view',array('items' => $items,'to_date' => $to_date,'astatus' => 1));
		
		$this->template->slice('dms/message');
		$this->template->render();
	}
	
	
	
	
	#-------------------------------------------------------------------------------------------------------------#
	public function addstk()
	{
	    $company_id= $this->session->userdata('company_id');
	     $branch_id = $this->session->userdata('under_id');
    	 $godown_id = $this->stock->get_branch_godown($branch_id); 
	     $args['select'] = array('id','item_code','item_name');
		 $items = $this->stock->get_stock_items($args);
		 if(empty($items)){
			$this->message->set($this->lang->line('no-items-found'),'i');
		 }
		 $items[''] = 'Select';ksort($items);
		 if(isset($_POST['btn_add']))
		{
		 
		 if($this->input->post('item_id',true) && $godown_id != ""){
			$stock_count = $this->stock->get_stock_count($godown_id,$this->input->post('item_id',true));
					$primary_unit = $this->stock->get_primary_unit($this->input->post('item_id',true));
				$primary_unit['symbol'];
					if($primary_unit['symbol']=='Pcs.')
					{
					   $item_array['unit_id']= 1;
					}
					else if($primary_unit['symbol']=='nos.')
					{
					 $item_array['unit_id']= 2;   
					}
			}
			$itemid=$this->input->post('item_id',true);
			$item_array['item_id']=$itemid;
			$item_array['qty']=$stock_count;
			$item_array['branch_id']=$branch_id;
			$item_array['godown_id']=$godown_id;
			$item_array['company_id']=$company_id;
		//$new_it = $this->db->select(array('item_id'))->from('item_stock')->where('item_id',$itemid)->get()->row_array();
			//if(!empty($new_it))
			//{
			    $this->db->update('item_stock',array('qty'=>$stock_count),array('item_id'=>$itemid,'branch_id'=>$branch_id));
			//}
		//	else
		//	{
	//	$this->sales_obj->insert("item_stock",$item_array);
		//	}
		}
	    #-------------template
		$this->template->title('Stock Register');
		$this->template->main_heading('Stock Register');
		$this->template->breadcrumb($breadcrumb);
		$this->template->slice('stock_summary/stock_add',array('items' => $items,'to_date' => $to_date,'astatus' => 1));
		
		$this->template->slice('dms/message');
		$this->template->render();
	}
	
	

	
	
	#-------------------------------------------------------------------------------------------------------------#
/*	public function addstk()
	{
	     $company_id= $this->session->userdata('company_id');
	     $branch_id = $this->session->userdata('under_id');
    	 $godown_id = $this->stock->get_branch_godown($branch_id);
	if(isset($_POST['btn_add']))
		{
	        for($i=4001;$i<=4536;$i++)
	        {
	            $new_it = $this->db->select(array('id'))->from('item_master')->where('id',$i)->get()->row_array();
	           
	           if(!empty($new_it)){
	                $stock_count = $this->stock->get_stock_count($godown_id,$i);
					$primary_unit = $this->stock->get_primary_unit($i);
				    $primary_unit['symbol'];
					if($primary_unit['symbol']=='Pcs.')
					{
					   $item_array['unit_id']= 1;
					}
					else if($primary_unit['symbol']=='nos.')
					{
					 $item_array['unit_id']= 2;   
					}
	                $itemid=$i;
	                $item_array['item_id']=$itemid;
			        $item_array['qty']=$stock_count;
			        $item_array['branch_id']=$branch_id;
			        $item_array['godown_id']=$godown_id;
			        $item_array['company_id']=$company_id;
			        	//$new_item = $this->db->select(array('item_id'))->from('item_stock')->where('item_id',$itemid,'branch_id',$branch_id)->get()->row_array();
			//if(!empty($new_item))
			//{
			   // $this->db->update('item_stock',array('qty'=>$stock_count),array('item_id'=>$itemid,'branch_id'=>$branch_id));
		//	}
			//else
		//	{
		$this->sales_obj->insert("item_stock",$item_array);
		//	}
	                
	            }
	            
	        }
		}
	
	#-------------template
		$this->template->title('Stock Register');
		$this->template->main_heading('Stock Register');
		$this->template->breadcrumb($breadcrumb);
		$this->template->slice('stock_summary/stock_add',array('items' => $items,'to_date' => $to_date,'astatus' => 1));
		
		$this->template->slice('dms/message');
		$this->template->render();
		
	}
	*/
	#-------------------------------------------------------------------------------------------------------------#
	
}