<?php if( ! defined('BASEPATH')) exit ('No direct script access allowed');

class Stock_transfer_vehicles extends MY_Controller {

	public function __construct(){
		
		parent ::__construct();
		$this->check_access_right();
		$this->load->model('stocks/Stock_transfer_vehicle_model','stockvehicle');
		
	}

	#----------------------------------------------------------------

	public function assigned_vehicle(){

		if(!$this->uri->segment(3) || !is_numeric($this->uri->segment(3))){
			redirect('stock_transfer/report');
		}
		$uri_array = $this->uri->uri_to_assoc(4);
		$uri_string = $this->uri->assoc_to_uri($uri_array);			
		$this->load->model('stocks/Stock_transfer_model','stocktransfer');
		$stock_transfer_id = $this->uri->segment(3);
		$stock_transfer = $this->stocktransfer->get_all_stock_transfer(array('conditions'=>array('stk_trs.id'=>$stock_transfer_id)))[0];
		$stock_transfer_group_id = $stock_transfer['group_id'];

		if(empty($stock_transfer)){
			redirect('stock_transfer/report');
		}
		$stock_transfer_vehicle = $this->stockvehicle->get_all(array('conditions'=>array('dstv.group_id'=>$stock_transfer_group_id)));

		if(empty($stock_transfer_vehicle)){
			$this->message->set($this->lang->line('no-vehicle-assigned'),'e');
		}
		#template
		$this->template->title($this->lang->line('assigned-vehicles'));
		$this->template->main_heading($this->lang->line('assigned-vehicles'));
		$this->template->breadcrumb(array($this->lang->line('stock-transfer') =>'stock_transfer/add',$this->lang->line('report')=>'stock_transfer/report',$this->lang->line('assigned-vehicles')=>'no_link',$this->lang->line('assign-vehicles')=>'stock_transfer_vehicles/assign/'.$stock_transfer_id.'/'.$uri_string ));
		$this->template->slice('dms/message');
		$this->template->slice('stock_transfer/vehicles/assigned_vehicles',array('sales_vehicles'=>$stock_transfer_vehicle));
		
		$this->template->render();
		
	}

	#----------------------------------------------------------------

	public function assign(){

		$this->load->model('stocks/Stock_transfer_model','stocktransfer');
		$uri_array = $this->uri->uri_to_assoc(4);
		$uri_string = $this->uri->assoc_to_uri($uri_array);
		if(!$this->uri->segment(3) || !is_numeric($this->uri->segment(3))){
			redirect('stock_transfer/report');
		}
		$stock_transfer_id = $this->uri->segment(3);
		$stock_transfer = $this->stocktransfer->get_all_stock_transfer(array('conditions'=>array('stk_trs.id'=>$stock_transfer_id)))[0];

		if($this->input->post('vehicle_type')){
			$this->form_validation->set_rules('vehicle_id','lang:vehicle','xss_clean|required');
			$this->form_validation->set_rules('driver_id','lang:driver','xss_clean|required');
		}else{
			$this->form_validation->set_rules('vehicle_no','lang:vehicle','xss_clean|required');
			$this->form_validation->set_rules('driver_name','lang:driver','xss_clean');
		}
		$this->form_validation->set_rules('route_id','lang:route','xss_clean|required');
		$this->form_validation->set_rules('km','lang:km','xss_clean|is_numeric|greater_or_equal[0]');

		if($this->form_validation->run() === TRUE){

			$post_data = $this->input->post(NULL,TRUE);
			$post_data['group_id'] = $stock_transfer['group_id'];

			$vehicle_type = 1;
			if($this->input->post('vehicle_type')){
			
				$post_data['vehicle_type'] = 0;
				$sales_vehicle = $this->stockvehicle->get_all(array('conditions'=>array('dstv.group_id'=>$post_data['group_id'],'dstv.vehicle_id'=>$post_data['vehicle_id']),'numrows'=>true));
				$sales_driver = $this->stockvehicle->get_all(array('conditions'=>array('dstv.group_id'=>$post_data['group_id'],'dstv.driver_id'=>$post_data['driver_id']),'numrows'=>true));
			
			}else{
			
				$post_data['vehicle_type'] = 1;
				$post_data['vehicle_id'] = '';
				$post_data['driver_id'] = '';
			
			}

			if(empty($sales_vehicle) && empty($sales_driver)){
				if($this->stockvehicle->save($post_data)){
					$this->message->set($this->lang->line('vehicle-assigned'));
					redirect('stock_transfer_vehicles/assign/'.$stock_transfer_id.'/'.$uri_string);
				}else{
					$this->message->set($this->lang->line('vehicle-not-assigned'),'e');
				}
			}else{
				$this->message->set($this->lang->line('same-vehicle-exists'),'e');
			}

		}

		$this->load->library('Transport_lib');
		$vehicles = $this->transport_lib->vehicles();
		$vehicles[''] = 'Select';
		ksort($vehicles);
		$drivers = $this->transport_lib->drivers();
		$drivers[''] = 'Select';
		ksort($drivers);
		$routes = $this->transport_lib->routes();
		$routes[''] ='Select';
		ksort($routes);
		$this->template->title($this->lang->line('assign-vehicles'));
		$this->template->main_heading($this->lang->line('assign-vehicles'));
		$this->template->slice('dms/message');
		$this->template->breadcrumb(array($this->lang->line('stock-transfer') =>'stock_transfer/add',$this->lang->line('report')=>'stock_transfer/report',$this->lang->line('assigned-vehicles')=>'stock_transfer_vehicles/assigned_vehicle/'.$stock_transfer_id.'/'.$uri_string ,$this->lang->line('assign-vehicles')=>'no_link'));
		$this->template->slice('stock_transfer/vehicles/assign_vehicles',array('stock_transfer'=>$stock_transfer,'vehicles'=>$vehicles,'drivers'=>$drivers,'routes'=>$routes));
		$this->template->other_script('vehicles/assign_vehicle');
		$this->template->render();

	}

	#----------------------------------------------------------------

	public function update(){

		$this->load->model('stocks/Stock_transfer_model','stocktransfer');
		$uri_array = $this->uri->uri_to_assoc(5);
		$uri_string = $this->uri->assoc_to_uri($uri_array);
		if(!$this->uri->segment(3) || !is_numeric($this->uri->segment(3))){
			redirect('stock_transfer/report');
		}
		$stock_transfer_vehicle_id = $this->uri->segment(3);
		$stock_transfer_id = $this->uri->segment(4);
		$stock_transfer_vehicle = $this->stockvehicle->get_all(array('conditions'=>array('dstv.id'=>$stock_transfer_vehicle_id)))[0];

		$stock_transfer = $this->stocktransfer->get_all_stock_transfer(array('conditions'=>array('stk_trs.id'=>$stock_transfer_id,'stk_trs.group_id'=>$stock_transfer_vehicle['group_id'])))[0];

		if(empty($stock_transfer)){
			redirect('stock_transfer/report');
		}
		if($this->input->post('vehicle_type')){
			$this->form_validation->set_rules('vehicle_id','lang:vehicle','xss_clean|required');
			$this->form_validation->set_rules('driver_id','lang:driver','xss_clean|required');
		}else{
			$this->form_validation->set_rules('vehicle_no','lang:vehicle','xss_clean|required');
			$this->form_validation->set_rules('driver_name','lang:driver','xss_clean');
		}			
		$this->form_validation->set_rules('route_id','lang:route','xss_clean|required');
		$this->form_validation->set_rules('km','lang:km','xss_clean|is_numeric|greater_or_equal[0]');

		if($this->form_validation->run() == TRUE){

			$post_data = $this->input->post(NULL,TRUE);
			$transfer_vehicle_group_id = $stock_transfer_vehicle['group_id'];
			
			$vehicle_type = 1;
			if($this->input->post('vehicle_type')){

				$post_data['vehicle_type'] = 0;
				$post_data['vehicle_no'] = '';
				$post_data['driver_name'] = '';
								
				$sales_vehicle = $this->stockvehicle->get_all(array('conditions'=>array('dstv.id !='=>$stock_transfer_vehicle_id,'dstv.group_id'=>$transfer_vehicle_group_id,'dstv.vehicle_id'=>$post_data['vehicle_id']),'numrows'=>true));

				$sales_driver = $this->stockvehicle->get_all(array('conditions'=>array('dstv.id !='=>$stock_transfer_vehicle_id,'dstv.group_id'=>$transfer_vehicle_group_id,'dstv.driver_id'=>$post_data['driver_id']),'numrows'=>true));

			}else{

				$post_data['vehicle_type'] = 1;
				$post_data['vehicle_id'] = '';
				$post_data['driver_id'] = '';					
				
			}
			if(empty($sales_vehicle) && empty($sales_driver)){
			
				if($this->stockvehicle->update($post_data,array('id'=>$stock_transfer_vehicle_id))){
					$this->message->set($this->lang->line('vehicle-assigned'));
					redirect('stock_transfer_vehicles/assigned_vehicle/'.$stock_transfer_id.'/'.$uri_string);
				}else{
					$this->message->set($this->lang->line('vehicle-not-assigned'),'e');
				}
			}else{
				$this->message->set($this->lang->line('same-vehicle-exists'),'e');
			}			
		}

		$this->load->library('Transport_lib');
		$vehicles = $this->transport_lib->vehicles();
		$vehicles[''] = 'Select';
		ksort($vehicles);
		$drivers = $this->transport_lib->drivers();
		$drivers[''] = 'Select';
		ksort($drivers);
		$routes = $this->transport_lib->routes();
		$routes[''] ='Select';
		ksort($routes);
		#template-
		$this->template->title($this->lang->line('assigned-vehicles'));
		$this->template->slice('dms/message');
		$this->template->main_heading($this->lang->line('edit').' '.$this->lang->line('assigned-vehicles'));
		$this->template->breadcrumb(array($this->lang->line('assigned-vehicles')=>'stock_transfer_vehicles/assigned_vehicle/'.$stock_transfer_id.'/'.$uri_string ,$this->lang->line('update')=>'no_link',$this->lang->line('go-back') =>'stock_transfer_vehicles/assigned_vehicle/'.$stock_transfer_id.'/'.$uri_string));
		$this->template->slice('stock_transfer/vehicles/edit_assigned_vehicles',array('stock_transfer'=>$stock_transfer,'vehicles'=>$vehicles,'drivers'=>$drivers,'routes'=>$routes,'stock_transfer_vehicle'=>$stock_transfer_vehicle));
		$this->template->other_script('vehicles/assign_vehicle');
		$this->template->render();
		
	}

	#----------------------------------------------------------------

	public function delete(){

		$uri_array = $this->uri->uri_to_assoc(4);
		$uri_string = $this->uri->assoc_to_uri($uri_array);
		if(!$this->uri->segment(3) || !is_numeric($this->uri->segment(3))){
			redirect('stock_transfer/report');
		}
		$stock_transfer_vehicle_id= $this->uri->segment(3);
		$this->load->model('sales/Sales_vehicle_model','sales_vehicle');
		
		if($this->stockvehicle->update(array('status'=>0),array('id'=>$stock_transfer_vehicle_id))){
			$this->message->set($this->lang->line('sales-vehicle-removed'));
		}else{
			$this->message->set($this->lang->line('sales-vehicle-not-removed'));
		}
		redirect('stock_transfer_vehicles/assigned_vehicle/'.$uri_string);

	}

	#----------------------------------------------------------------	
}
?>