<?php if( ! defined('BASEPATH')) exit ('No direct script access allowed');

class Stock_updation extends MY_Controller{

	public function __construct()
	{
		parent :: __construct();
		$this->check_access_right();

		$this->load->library(array('Stock','Stock_summary','Accounts'));
	}

	public function index()
	{
		$fiscal_start_date = $this->dms->get_fiscal_year()['start_date'];
		$cdate = date('Y-m-d'); //$fiscal_start_date;
		$stock_array = array();$tbp = "";
		
		$uri_array = $this->uri->uri_to_assoc(3);

		#------------breadcrumb
		$breadcrumb = array($this->lang->line('stock-summary') => 'no_link',$this->lang->line('stock-register') => 'no_link');

		if(isset($_POST['btn_search']))
		{
			#-------------validation
			$this->form_validation->set_rules('cdate','lang:from-date','required|xss_clean|valid_date');
			if($this->input->post('cdate',true))
			{
				$cdate = $this->input->post('cdate',true);
				$this->form_validation->set_rules('to_date','lang:to-date',"required|xss_clean|valid_date|check_date[$from_date.>=]");
			}
			if($this->form_validation->run() === true)
			{
				$cdate = date('Y-m-d',strtotime($this->input->post('cdate',true)));
				$this->session->set_userdata(array('cdate' => $cdate));
			}
		}
		else
		{
			if($this->session->userdata('cdate'))
			{
				$cdate = date('Y-m-d',strtotime($this->session->userdata('cdate')));

				#----------validating dates
				if(!$this->form_validation->valid_date($cdate)){
					redirect('users/logout');
				}
				else
				{
					if(!$this->form_validation->check_date($cdate.".<="))
					{
						redirect('users/logout');
					}
				}
			}
			if(isset($uri_array['rtype']))
			{
				$tbp = $uri_array['rtype'];
				if($tbp == 't')
				{
					$breadcrumb[$this->lang->line("go-back")] = "trial_balance/index";
				}
				elseif($tbp == 'b')
				{
					$breadcrumb[$this->lang->line("go-back")] = "balance_sheet/index";
				}
				elseif($tbp == 'p')
				{
					$breadcrumb[$this->lang->line("go-back")] = "profit_loss/index";
					/*if($this->uri->segment(4))
					{
						$from_date = date('Y-m-d',strtotime($this->uri->segment(4)));
						$to_date = $from_date;

						#----------validating dates
						if(!$this->form_validation->valid_date($from_date)){
							redirect('users/logout');
						}
					}*/
				}
			}
		}
		if(!empty($cdate))
		{
			#-----------stock items
			$items = $this->stock_summary->get_items();

			#-----------starting fiscal year details
			$fiscal_details = $this->dms->get_default();

			#-----------stock value type(0 => avg.cost , 1 => last_purchase_cost)
			$stock_value_type = $this->dms->stock_value_type();
			
			$branch_id = $this->session->userdata('under_id');
    		$godown_id = $this->stock->get_branch_godown($branch_id);     
    		 
			foreach($items as $ikey => $ivalue)
			{ 
				$item_count = 0;//$this->accounts->item_bal_qty($ivalue['id'],$fiscal_details['start_date'],$cdate);
			/*	if($item_count > 0)
				{
					$item_rate = $this->accounts->item_rate($ivalue['id'],$from_date,$to_date,0,$stock_value_type);
					$unit_name = $this->stock->get_unit_symbol($ivalue['unit_id']);
					$stock_array[$ivalue['id']] = array('item_code' => $ivalue['item_code'],'item_name' => $ivalue['item_name'],'item_count' => $item_count,'item_rate' => $item_rate,'unit' => $unit_name);
				} */
				
				$stock_array[$ivalue['id']] = array('item_code' => $ivalue['item_code'],'item_name' => $ivalue['item_name'],'item_count' => $item_count,'model_no' => $ivalue['model_no']);
			}
		}
		
		if(isset($_POST['btn_add']))
		{
		    echo $_POST['total_items'];
		}

		#-------------template
		$this->template->title('Stock Register');
		$this->template->main_heading('Stock Register');
		$this->template->breadcrumb($breadcrumb);
		$this->template->slice('stock_summary/stock_date',array('cdate' => $cdate));
		if(!empty($stock_array))
		{
			$access_rights = $this->have_access(659);
			$this->template->append('stock_summary/stock_updation',array('stock_array' => $stock_array,'access_rights' => $access_rights,'cdate'=>$cdate,'tbp' => $tbp));
		}
		else
		{
			$this->message->set($this->lang->line('no-result-found'),'i');
		}
		$this->template->slice('dms/message');
		$this->template->render();
	}
}