<?php if( ! defined('BASEPATH')) exit ('No direct script access allowed');
class Stock_upload_excel extends MY_Controller
{
	public function __construct()
	{
		parent ::__construct();
		$this->check_access_right();
		$this->load->library('My_excel');
		$this->load->model('products/Stock_upload_model','stockupload');
	}

	public function upload_data()
	{
	    $this->load->library('Stock');
        $this->template->title($this->lang->line('stock-upload'));
		$this->template->main_heading($this->lang->line('stock-upload'));
		$this->template->breadcrumb(array($this->lang->line('stock-upload') => 'stock-upload/upload_data',$this->lang->line('stock-upload') => 'no_link',$this->lang->line('report') => 'stock_count/report'));
		
		if($this->input->post('upload',TRUE))
		{
			//$this->form_validation->set_rules('product_file','lang:product-file','callback_file_empty');
			//if($this->form_validation->run() == TRUE)
			//{
				if($_FILES['product_file']['name'] != '')
				{
				    $this->load->library('Image');
				    $file_name = $this->image->random_name($_FILES['product_file']['name']);
					$fpart1 ="data_".date('YmdHis');
					$ext = pathinfo($_FILES['product_file']['name'], PATHINFO_EXTENSION);
					$file_name = $fpart1.".".$ext;
					if($ext != 'xlsx' && $ext != 'xls')
					{
						$this->message->set($this->lang->line('product-invalid-filetype'),'e');
					}
					else
					{
						$config['upload_path'] =  FCPATH.'assets/files/stock_count/';
						$config['allowed_types'] = 'xlsx|xls';
						$config['max_size']	= '2048';
						$config['file_name'] = $file_name;
						$this->load->library('Upload');
						$this->upload->initialize($config); 
						if($this->upload->do_upload('product_file'))
						{
							$data['product_file'] = $file_name;
							$file = FCPATH."assets/files/stock_count/".$file_name;
							if (!empty($file) && file_exists($file))
							{ 
						        $this->my_excel->excelObj = $this->my_excel->excelRdr->load($file);
							    $last_row = $this->my_excel->excelObj->getActiveSheet()->getHighestDataRow();
								$i=2;

								//$invalid_dates = array('','0000-00-00','1970-01-01','0','');
								$opening_amount = 0; $k=0;
								$group_id = $this->stock->get_group_id('stock_count_new');

								$bdaymonth=$this->input->post('bdaymonth',true);
                                $month = date('m', strtotime($bdaymonth));
                                $year = date('Y',strtotime($bdaymonth));
                                $cur_date = date('Y-m-d');
                                if(!empty($bdaymonth))
                                {
                                    $new_rate = array();
                                    $new_rate['month'] = $month;
                                    $new_rate['year'] = $year;
                                    $new_rate['group_id'] = $group_id;
                                    $new_rate['date'] = $cur_date;
                                    $new_rate['branch_id'] = $this->session->userdata('under_id');
                                    $new_rate['status'] =-1;
	
	                                $this->stockupload->newsave($new_rate);
                                }
								
								for($i=2;$i<=$last_row;$i++)
								{  
									$error_rows = array();

									$item_code = Trim($this->my_excel->excelObj->getActiveSheet()->getCell('B'.$i)->getValue());
								    $item_name = Trim($this->my_excel->excelObj->getActiveSheet()->getCell('C'.$i)->getValue());
									$item_qty = Trim($this->my_excel->excelObj->getActiveSheet()->getCell('D'.$i)->getValue());
									$item_lcost = Trim($this->my_excel->excelObj->getActiveSheet()->getCell('E'.$i)->getValue());
									$item_rate = Trim($this->my_excel->excelObj->getActiveSheet()->getCell('F'.$i)->getValue());
                                    $item_type = Trim($this->my_excel->excelObj->getActiveSheet()->getCell('I'.$i)->getValue());

            						if(empty($item_code))
            						{
            						    $error_rows['item_code'] = $this->lang->line('invalid-item-code');
            						}
            						else
            						{
                                        $godowns = $this->stock->get_godowns(array('conditions'=>array('branch_id'=>$this->session->userdata('under_id'))));
                        				foreach($godowns as $key=>$goDown)
                                        {
                                            $goDownID = $goDown['id'];
                                        }
                                            		
                                        $itemID = $this->stockupload->get_item_id($item_code,$item_name,$item_type,$goDownID);
                                        if($itemID!='')
                                        {
                                            $itemID = $this->stock->get_item_datas($item_code);
                                            $item_unit = $this->stock->get_unit_id($itemID); 
                                            $rate   = $this->stock->get_item_rate($itemID);
                                            $lcost = $this->stock->get_item_landcost($itemID);
                                            if($lcost==0)
                                            {
                                                $lcost =  $item_lcost; 
                                            }
                                            if($rate==0)
                                            {
                                                $rate =  $item_rate;
                                            }
                                            $amount = $item_qty*$rate;
                                                    
                                            $args = array();
                            			    $args['select'] = array('id');
                            				$args['conditions'] = array('a.company_id'=>$this->session->userdata('company_id'),'a.godown_id'=>$goDownID,'a.item_id'=>$itemID,'b.month'=>$month,'b.year'=>$year,'a.status'=>1,'a.group_id'=>$group_id);
                            				$checkExists = $this->stockupload->get($args);
                            				
                            				if(empty($checkExists))
                            				{
                            				    $saveArray = array('company_id'=>$this->session->userdata('company_id'),'branch_id'=>$this->session->userdata('under_id'),'item_id'=>$itemID,'godown_id'=>$goDownID,'quantity'=>$item_qty,'unit_id'=>$item_unit,'landing_cost'=>$lcost,'rate'=>$rate,'amount'=>$amount,'group_id'=>$group_id,'status'=>1);
                            					
                            					if($this->stockupload->save($saveArray))
                            					{     
                            						$insertCount ++;
                            					}
                            					$itemsave = array();
                            					$itemsave['company_id'] = $this->session->userdata('company_id');
                            					$itemsave['item_id'] = $itemID;
                            					$itemsave['rate'] = $rate;
                            					$itemsave['landing_cost'] = $lcost;
                            					$itemsave['valid_from'] = $cur_date;
                            					$itemsave['status']=1;
                            					$this->stockupload->savedata($itemsave);
                            					        
                            					$this->stockupload->update(array('table' => 'stock_count_new','data' => array('status' => 1),'conditions' => array('status' =>-1,'month' =>$month,'year' =>$year,'branch_id' =>$this->session->userdata('under_id'))));
                                				$this->message->set($this->lang->line('stock-saved-upload'));
                                			}
                                			else
                                		    { 
                                				$this->stockupload->update(array('table' => 'stock_lmsb','data' => array('quantity' => $item_qty,'landing_cost'=>$lcost,'rate' =>$rate,'amount' =>$amount),'conditions' => array('item_id' =>$itemID,'branch_id' =>$this->session->userdata('under_id'))));
                                			    $this->message->set($this->lang->line('stock-saved-upload'));
                                			}         
            						    }
            						}
								}
							}
						}
					}
				}
			//}
		}
		
		$this->template->slice('dms/message');
		$this->template->slice('products/stock_upload/add',array('items'=>$items,'itemcodes'=>$itemcodes,'godowns'=>$godowns,'checkedItems'=>$checkedArray,'symbol'=>$unit_symbol,'unit_symbol'=>$unit_symbol,'unit_name'=>$unit_name));
		$this->template->other_script(array('products/add_stock_count'));
		$this->template->render();
	}
}