<?php if( !defined('BASEPATH'))exit('No direct script access allowed');

class Stocktransfer_upload_excel extends MY_Controller
{
    public function __construct()
	{
		parent ::__construct();
		$this->check_access_right();
		$this->load->library('My_excel');
		$this->company_Id = $this->session->userdata('company_id');
		$this->branch_Id = $this->session->userdata('under_id');
		$this->created_By = $this->session->userdata('id');
		$this->load->model('stocks/Stock_transfer_model','stocktransfer');
		$this->load->model('stocks/Stocktransfer_upload_model','stockupload');
		$this->load->model('vouchers/Voucher_model','voucher');
		
		$this->load->library(array('Stock','Image','Upload'));
	}
    
    public function upload_data()
	{
		$continue = 1;
		$error_bill_no =array(); 
		
		$transfer_Id = $this->stockupload->get_transfer_id(); 
		$t_date = cdateFormat(date('Y-m-d'));
		$group_id = $this->stock->get_group_id('dms_stock_transfers');
		$godown_id = $this->stock->get_branch_godown($this->branch_Id);
		
		if($this->input->post('upload',TRUE))
		{
			$this->form_validation->set_rules('product_file','lang:product','callback_file_empty');
			if($this->form_validation->run() == TRUE)
			{
			   if($_FILES['product_file']['name'] != '')
				{
					$data = $this->input->post(NULL,TRUE);
					
					$file_name = $this->image->random_name($_FILES['product_file']['name']);
					$fpart1 ="data_".date('YmdHis');
				    $ext = pathinfo($_FILES['product_file']['name'], PATHINFO_EXTENSION);
			     	$file_name = $fpart1.".".$ext;
					if($ext != 'xlsx' && $ext != 'xls')
					{
						$this->message->set($this->lang->line('product-invalid-filetype'),'e');
					}
					else
					{
						$config['upload_path'] =  FCPATH.'assets/files/stock_transfer/';
						$config['allowed_types'] = 'xlsx|xls';
						$config['max_size']	= '2048';
						$config['file_name'] = $file_name;
						
						$this->upload->initialize($config);
						
						if($this->upload->do_upload('product_file'))
						{ 
							$data['product_file'] = $file_name;
							$file = FCPATH."assets/files/stock_transfer/".$file_name;
							if (!empty($file) && file_exists($file))
							{ 
								$this->my_excel->excelObj = $this->my_excel->excelRdr->load($file);
							    $last_row = $this->my_excel->excelObj->getActiveSheet()->getHighestDataRow();
								$i=2;

								$invalid_dates = array('','0000-00-00','1970-01-01','0','');
							
							    $transfer_data['branch_id'] = $this->branch_Id;
							    $transfer_data['group_id'] = $group_id;
							    $transfer_data['transfer_no'] = $data['transfer_no'];
							    $transfer_data['transfer_date'] =  date('Y-m-d',strtotime($data['transfer_date']));
							    $transfer_data['godown_to_id'] = $data['godown_to_id'];
					            $transfer_data['freight'] = $data['freight'];
					            $transfer_data['other_expense'] = $data['other_expense'];
					            $transfer_data['narration'] = $data['narration'];
								$transfer_data['st_status'] = 0;
								
							    if($this->stockupload->f_save('dms_stock_transfers',$transfer_data))
						        {
						            for($i=2;$i<=$last_row;$i++)
								    {  
									    $error_rows = array();
    									#-----------------read from excel
    								    $item_code = Trim($this->my_excel->excelObj->getActiveSheet()->getCell('A'.$i)->getValue());
    									$item_qty = Trim($this->my_excel->excelObj->getActiveSheet()->getCell('B'.$i)->getValue());
    									$item_rate = Trim($this->my_excel->excelObj->getActiveSheet()->getCell('C'.$i)->getValue());
									
    									if(empty($item_code) || empty($item_qty))
    									{ 
    										if(empty($item_code))
    										{
        										$error_rows['item_code'] = $this->lang->line('invalid-item-code');
        									}
        									if(empty($item_qty))
        									{
        									    $error_rows['item_qty'] = $this->lang->line('invalid-item-quantity');
        									}
    									}
    									else
    									{ 
										        #----------------checking bill date is currnt finacual year/and closed financial year

                                            $unit_id = 1;
    										$item_id = $this->stock->get_item_datas($item_code);
    										if($item_id!='')
    										{ 
    										    $stock_data = array(); $transfer_items =array();
    										    
    										    $transfer_items['group_id'] = $group_id;
    										    $transfer_items['item_id'] = $item_id;
    										    $transfer_items['qty'] = $item_qty;
    										    $transfer_items['unit_id'] = $unit_id;
    										    $transfer_items['sale_rate'] = $item_rate;
    										    $transfer_items['godown_from_id'] = $godown_id;
    										    $transfer_items['status'] = 1;
    										    
    										    $insert_id = $this->stockupload->f_save('dms_stock_transfer_items',$transfer_items);
    										    
    										    if($insert_id)
    										    {
    										        #-------- from branch ----------
    										        $stock_data['company_id'] = $this->company_Id;
    										        $stock_data['branch_id'] = $this->branch_Id;
    										        $stock_data['godown_id'] = $godown_id;
    										        $stock_data['item_id'] = $item_id;
    										        $stock_data['qty'] = -$item_qty;
    										        $stock_data['unit_id'] = $unit_id;
    										        $stock_data['stock_date'] = $transfer_data['transfer_date'];
    										        $stock_data['stock_status'] = 10;
    										        $stock_data['table_group_id'] = $group_id;
    										        $stock_data['table_id'] = $insert_id;
    										        $stock_data['status'] = -1;
    									
    									            $this->stockupload->f_save('dms_stocks',$stock_data);
    									            #-------- to branch ----------
    									            
    									            $branch_to_id = $this->stock->get_godown_branch($transfer_data['godown_to_id']);
    									            
    									            $stock_data['branch_id'] = $branch_to_id;
    									            $stock_data['godown_id'] = $transfer_data['godown_to_id'];
    									            $stock_data['qty'] = $item_qty;
    									            
    									            $this->stockupload->f_save('dms_stocks',$stock_data);
    									            
    									            $rate_array = array();
                									$rate_array['branch_id'] = $branch_to_id;
                									$rate_array['item_id'] = $item_id;
                									$rate_array['rate'] = $item_rate;
                									$rate_array['valid_from'] = $transfer_data['transfer_date'] ;
                									$rate_array['status'] = 1; 
                									
                									$this->stockupload->f_save('dms_item_sales_rate',$rate_array);
    										    }
    										}    
        								}
    								}   
    								
    								if(!empty($error_rows))
    								{
    									if(empty($error_string))
    									{
    										$error_string = "Row $i [ ".implode(" ,",$error_rows)." ]<br>";
    									}
    									else
    									{
    										$error_string .= "Row $i [ ".implode(" ,",$error_rows)." ]<br>";
    									}
    								}
    									
                        			if(!empty($error_string))
    								{
?>
    									<script>localStorage.setItem('perrors',"<?php echo $error_string;?>");</script>
<?php
    								}
    							}
    							else
    							{
    								$continue = 0;
    								$this->message->set($this->lang->line('invalid-filetype'),'e');
    							}
    						}
    						else
    						{
    							$continue = 0;
    							$this->message->set($this->lang->line('invalid-filetype'),'e');
    						}
    						if($continue == 1)
    						{
    							$this->message->set($this->lang->line('stock-transfer-uploaded','s'));
    							//redirect('stocktransfer_upload_excel/upload_data');
    						}
					    }
				    }
			    }
		    }
		}
		
		$godowns = $this->stock->get_godowns1(array('conditions'=>array('bm.id!=' => $this->branch_Id),'listing'=>1));
		$godowns['']  = 'select';
		ksort($godowns);
		
		#--------------------template
		$this->template->title($this->lang->line('stock').' '.$this->lang->line('upload'));
		$this->template->main_heading($this->lang->line('stock').' '.$this->lang->line('upload'));
		$this->template->breadcrumb(array($this->lang->line('stock-transfer') => 'stock_transfer/add',$this->lang->line('report') => 'stock_transfer/report',$this->lang->line('upload')=>'no_link'));
		$this->template->slice('dms/message');
		$this->template->slice('stock_transfer/upload_data/upload',array('godowns'=>$godowns,'transfer_Id'=>$transfer_Id,'t_date'=>$t_date));
		$this->template->render();
	}
	
}