<?php if( ! defined('BASEPATH')) exit ('No direct script access allowed');

	class Targets extends MY_Controller{

		public function __construct(){

			parent :: __construct();
			$this->check_access_right();
			$this->load->model('targets/Target_model','target');
			$this->load->model('users/User_target_model','ut');
			$this->load->model('designations/Designation_master_model','desig');
			$this->load->model('branches/Branch_model','branch');
			$this->load->library('Dms');
			$this->companyID = $this->session->userdata('company_id');
			$this->branchID = $this->session->userdata('under_id');
			$this->createdBY = $this->session->userdata('id');
			
			#---------------- Checking Financial year is enabled / closed -----------------#
			$method_array = array('employees','delete_e_target','update_e_target','e_set','emp_full','t_search','achievements','delete_achievements','view_achievements');
			fiscal_status($this->uri->segment(2),$method_array,"targets/t_search");
			#---------------- Checking Financial year is enabled / closed -----------------#

		}

		#----------------------------------------------------

		# date: 03-01-2015
		# purpose: to check existing target data from table
		public function data_check($date_to){

			$date_from = $this->input->post('valid_from',true);
			$date_from = date('Y-m-d',strtotime($date_from));
			$date_to = date('Y-m-d',strtotime($date_to));
			$this->db->select(array('m.*','t.*'));
			$this->db->from('targets t');
			$this->db->join('target_items m','m.targets_id=t.id','inner');
			$where = "((`valid_from` <= '$date_from' && `valid_to` >= '$date_from') or (`valid_from` <= '$date_to' && `valid_to` >= '$date_to') or (`valid_from` > '$date_from' && `valid_to` < '$date_to'))";
			$this->db->where($where);
			$row = $this->db->get()->row_array();
			//echo $this->db->last_query();die;
			if(empty($row)){					
				return true;
			}
			return false;

		}

		#----------------------------------------------------

		#date : 23-7-2014
		#purpose : get complete employee target(means with pagination)
		public function emp_full(){

			#get employee name
			if($this->uri->segment(4) == 1){
				$emp_name = $this->branch->get_full_name($this->uri->segment(3));
			}else {
				$emp_name = $this->user->get_fname_lname($this->uri->segment(3));
			}
			$designation_id =$this->uri->segment(4);

			$this->template->title('User targets');
			if($this->uri->segment(4) == 1){
				$this->template->main_heading($this->lang->line('branch-targets').'&ensp;-&ensp;<span class="text-danger">'.$emp_name.'</span>');
			}else{
				$this->template->main_heading($this->lang->line('user-targets').'&ensp;-&ensp;<span class="text-danger">'.$emp_name.'</span>');
			}
			$this->template->breadcrumb(array($this->lang->line('targets')=>'targets/e_set',$this->lang->line('report')=>'no_link',$this->lang->line('search')=>'targets/t_search'));

			#pagination
			$this->load->library('Pagination');
			$config['per_page'] = $this->per_page();
			# Pagination Config Customizations
			$config['full_tag_open'] = '<ul class="pagination">';
			$config['full_tag_close'] = '</ul>';
			$config['first_link'] = 'First';
			$config['last_link'] = 'Last';
			$config['next_link'] = '&raquo;';
			$config['prev_link'] = '&laquo;';
			$config['cur_tag_open'] = '<li class="active"><a href="#">';
			$config['cur_tag_close'] = '</a></li>';
			$config['num_tag_open'] = '<li>';
			$config['num_tag_close'] = '</li>';
			$config['base_url'] = base_url('targets/emp_full/'.$this->uri->segment(3));
			$config['uri_segment'] = 5;
			$config['total_rows'] = $this->target->get_all(array('t.designation_id'=>$designation_id,'t.user_id'=>$this->uri->segment(3),'total'=>1));

			$this->pagination->initialize($config);
			$links = $this->pagination->create_links();
			$offset = (null !== $this->uri->segment(5))?$this->uri->segment(5):0;
			$offset = $this->uri->segment(5,0);

			$this->load->library('Order_lib');
			$targets = $this->target->get_all(array('t.designation_id'=>$designation_id,'t.user_id'=>$this->uri->segment(3),'limit'=>$config['per_page'],'offset'=>$offset));
			$this->template->slice('dms/message');
			$this->template->slice('employees/targets/show_existing',array('targets'=>$targets,'links'=>$links,'user_id'=>$this->uri->segment(3),'designation_id'=>$designation_id,'offset'=>$offset));
			$this->template->slice('dms/modals/more_details');
			$this->template->other_script('employees/employee_target');
			$this->template->render();

		}

		#-----------------------------------------------------
		#date: 03-02-2015
		#purpose : edit employee target

		public function update_e_target(){

			$valid = TRUE;
			$target_id = $this->uri->segment(3);
			$target_status = $this->uri->segment(4);

			if(empty($target_id)){
				redirect('access/');
			}

			#get employee target details
			if($target_status=='-1'){
				$employee_target = $this->target->get_all_temp(array('t.id'=>$target_id,'t.created_by'=>$this->session->userdata('id')));
			}else{
				$employee_target = $this->target->get_all(array('t.id'=>$target_id));
			}

			#get user name & designation
			$userID = $employee_target[0]['user_id'];
			$jobrole_id = $employee_target[0]['designation_id'];
			$jobrole = $this->desig->get_name($jobrole_id);

			if(isset($_POST['submit_two'])){
				$this->form_validation->set_rules('target[item_group_id]','lang:item-type','required');
				$this->form_validation->set_rules('target_type','lang:target_type','required');
				$this->form_validation->set_rules('comments','lang:comments','trim|xss_clean');
				$this->form_validation->set_rules('point','lang:points','required|xss_clean|numeric');
				$this->form_validation->set_rules('valid_from','lang:date','is_date|required|valid_date');
				$this->form_validation->set_rules('valid_to','lang:date','is_date|required');
				$valid = FALSE;
			}
			if(isset($_POST['submit_two']) && $_POST['target_type']==0){
				$this->form_validation->set_rules('target[qty]','lang:qty','required');
				$this->form_validation->set_rules('target[unit_id]','lang:unit','required');
				$valid = FALSE;
			}
                                
            if(isset($_POST['submit_two']) && $_POST['target_type']==1){
				$this->form_validation->set_rules('amount','lang:amount','required|xss_clean|numeric');
				$valid = FALSE;
			}

			if(($this->form_validation->run() == TRUE) && ($valid = TRUE)){
				if(isset($_POST['submit_two'])){

					$data = $this->input->post(NULL,TRUE);
					$targets = $this->input->post('target',TRUE);

					if($this->input->post('target_type',TRUE)==1){
						$targets2['amount'] = $data['amount'];
						$targets2['qty'] = $targets['qty'] = 0;
						$targets2['unit_id'] = $targets['unit_id'] = 0;
					}
					if($this->input->post('target_type',TRUE)==0){
						$targets2['amount'] = 0;
						$targets2['qty'] = $targets['qty'];
						$targets2['unit_id'] = $targets['unit_id'] ;
					}

					$targets2['item_group_id'] = $targets['item_group_id'];
					$targets2['unit_id'] = $targets['unit_id'];
					$targets2['points'] = $data['point'];
                    $targets1['target_type'] = $data['target_type'];
                    $targets1['comments'] = $data['comments'];
                    $targets1['valid_from'] = $data['valid_from'];
                    $targets1['valid_to'] = $data['valid_to'];

					$result=$this->target->update_targets('targets',$targets1,$target_id);
					if($result){
						$this->target->update_targets('target_items',$targets2,$target_id);
						$this->message->set($this->lang->line('target-updated'));
					}else{
						$this->message->set($this->lang->line('target-not-updated'));
					}

                	#chk whether edit request came form t_search or e_set and redirect
					if($target_status=='1') { 
						redirect('targets/t_search/'.$jobrole_id.'/'.$userID);
					}else{
						redirect('targets/e_set/');
					}
				}
			}

			if($employee_target[0]['target_type'] == 1){
				$amt_class = '';
				$qty_class = 'hide';
			}else{
				$amt_class = 'hide';
				$qty_class = '';
			}

			#items
			$this->load->model('products/Item_model','item');
			$items = $this->item->item_group_listing();
			$items[''] = 'Select an item group';
			ksort($items);

			#units
			if(isset($_POST['target']['item_group_id'])){
				$this->load->model('products/Unit_model','unit');
				$units = $this->unit->listing('');
			}
			$this->load->model('products/Unit_model','unit');
			$units = $this->unit->listing('');

			#checking user type to display name
			if($jobrole_id == 1){
				$user_name = $this->branch->get_full_name($userID);
			}else{
				$user_name = $this->user->get_fname_lname($userID);
			}

			$this->template->title($this->lang->line('update-target'));
			$this->template->main_heading($this->lang->line('update-target'));
			$this->template->breadcrumb(array($this->lang->line('targets')=>'targets/e_set',$this->lang->line('update')=>'no_link',$this->lang->line('search')=>'targets/t_search'));
			$this->template->slice('dms/message');
			$this->template->slice('users/targets/update',array('employee_target'=>$employee_target,'items'=>$items,'units'=>$units,'desig_id'=>$jobrole_id,'user_name'=>$user_name,'jobrole'=>$jobrole,'amt_class'=>$amt_class,'qty_class'=>$qty_class));
			$this->template->other_script('employees/employee_target');
			$this->template->other_script('targets/target');
			$this->template->render();
		}
	
		#-----------------------------------------------------

		#date : 02-01-2015
		#purpose : set user targets
		function e_set(){

			#loading models 
			$this->load->model('products/Item_model','item');
			$this->load->model('products/Unit_model','unit');
			$this->load->model('retailers/Counter_model','ar');
			$this->load->model('users/User_model','muser');
			$this->template->slice('dms/message');

            #get user types
			$utype =$utype = $this->desig->desig_listing(1);
			$utype[''] = 'Select Type';
			ksort($utype);
			$valid = FALSE;

			#user list
            $users[''] = 'Select User';
            asort($users);

			#items groups
			$items = $this->item->item_group_listing();
	        $items[''] = 'Select an item group';
	        ksort($items);

	        #amount or quantity
	        $amt_class = 'hide';
			$qty_class = '';

			#units after add button ------------------------------
			if($this->input->post('item_group_id')!= NULL){
	            $this->load->library('Stock');
	            $item_group_id = $this->input->post('item_group_id');
	            $units = $this->stock->get_item_group_units($item_group_id);
			}else{
				$units[''] = 'select a unit';
			}

			#fetch temporary data ---------------------------------
			$targets = $this->target->get_all_temp(array('t.created_by'=>$this->session->userdata('id')));
			if(isset($_POST['add'])){
				if(empty($targets)){
					$this->form_validation->set_rules('user_type','lang:user-type','required');
					$this->form_validation->set_rules('user_id','lang:user','required');
				}
                $this->form_validation->set_rules('target_type','lang:target_type','required');
				$this->form_validation->set_rules('item_group_id','lang:item-type','required');
				$this->form_validation->set_rules('comments','lang:comments','trim|xss_clean');
				$this->form_validation->set_rules('valid_from','lang:date','is_date|valid_date');
				$this->form_validation->set_rules('valid_to','lang:date','is_date');
				$this->form_validation->set_rules('point','lang:points','required|xss_clean|numeric');
				$valid = FALSE;
			}
                
			if(isset($_POST['add']) && $_POST['target_type'] == 0){
				$this->form_validation->set_rules('qty','lang:qty','required');
				$this->form_validation->set_rules('unit_id','lang:unit','required');
				$valid = FALSE;
				$amt_class = 'hide';
				$qty_class = '';
			}
                        
			if(isset($_POST['add']) && $_POST['target_type'] == 1){
				$this->form_validation->set_rules('amount','lang:amount','required|xss_clean|numeric');
				$valid = FALSE;
				$amt_class = '';
				$qty_class = 'hide';
			}

			#load inputs after add if no temporary data --------------------------
			if(isset($_POST['add']) && empty($targets)){

				if($this->input->post('user_type') == 1)	{
					$users = $this->branch->listing(array('id !='=>$this->session->userdata('under_id')));
					$users[0] = "Select";
					asort($users);
				}else if($this->input->post('user_type') == 3){
					$users = $this->target->listing_ar($this->input->post('user_type'));
					$users[0] = "Select";
					asort($users);
				}else{
					$users = $this->muser->listing(array('designation_id'=>$this->input->post('user_type'),'branch_id'=>$this->session->userdata('under_id')));
					$users[0] = "Select";
					asort($users);
				}
			}

			if($this->form_validation->run() == TRUE){
				$valid = TRUE;
				if(isset($_POST['add'])){

					if(!empty($targets)){
						$data['designation_id'] = $targets[0]['designation_id'];
						$data['user_id'] = $targets[0]['user_id'];
					}else{
						$data['designation_id'] = $this->input->post('user_type');
	                    $data['user_id'] = $this->input->post('user_id');
                	}
                    $data['target_type'] = $this->input->post('target_type');
                    $data['valid_from'] = $this->input->post('valid_from');
                    $data['valid_to'] = $this->input->post('valid_to');
                    $data['comments'] = $this->input->post('comments');
                    $data['status'] = '-1';
                    $data2['item_group_id'] = $this->input->post('item_group_id');
                    $data2['qty'] = $this->input->post('qty');
                    $data2['unit_id'] = $this->input->post('unit_id');
                    $data2['amount'] = $this->input->post('amount');
                    $data2['points'] = $this->input->post('point');
                    $data2['status'] = '-1';

                    if($this->input->post('target_type',TRUE)==1){
						$data2['amount'] = $this->input->post('amount');
						$data2['qty'] = '';
						$data2['unit_id'] = '';
					}
					if($this->input->post('target_type',TRUE)==0){
						$data2['amount'] = '';
					}

					#chk whether target setting exist for the same user.
					$exist = $this->target->chk_all_temp($data['user_id'],$data['designation_id'],$data['target_type'],$data2['item_group_id']);
					if(empty($exist)){
	                    if($result = $this->target->save($data)){
                    		$data2['targets_id'] = $result;
                    		$this->target->save_bonus($data2);
                            $this->message->set($this->lang->line('target-added'));
                            redirect('targets/e_set');
						}else{
                            $this->message->set($this->lang->line('target-not-saved'),'e');
		                }
                	}else{
                	 	$this->message->set($this->lang->line('target-exist'),'e');
                	}
				}
			}

			if(isset($_POST['save'])){

				$ins = 0;
				foreach($targets as $key=>$tg){
					$tid = $tg['targets_id'];
					$utypes = $tg['designation_id'];
					$user = $tg['user_id'];
					$condition = array('status' => '1');
					$this->target->save_target($condition,$user);
					$this->target->save_target_items($condition,$tid);
					$ins++;
				}
				if($ins>0){

					$this->message->set($this->lang->line('target-saved'));
					redirect('targets/e_set');
				}else{
                    $this->message->set($this->lang->line('target-not-saved'));
                    redirect('targets/e_set');
                }
			}

			$tstatus = '-1';
			#after fetching temporary data
			if(!empty($targets)){
				$target_type = $targets[0]['target_type'];
				$utypes = $targets[0]['designation_id'];
				$user = $targets[0]['user_id'];
				if($target_type == 1) {
					$amt_class = '';
					$qty_class = 'hide';
				}

				if($utypes == 1){
					$users = $this->branch->listing(array('id !='=>$this->session->userdata('under_id')));
					$users[0] = "Select";
					asort($users);
				}else if($utypes == 3){
					$users = $this->target->listing_ar($utypes);
					$users[0] = "Select";
					asort($users);
				}else{
					$users = $this->muser->listing(array('designation_id'=>$utypes,'branch_id'=>$this->session->userdata('under_id')));
					$users[0] = "Select";
					asort($users);
				}

        		$this->template->slice('users/targets/enter_target',array('items'=>$items,'units'=>$units,'amt_class'=>$amt_class,'users'=>$users,'user_types'=>$utype,'target_type'=>$target_type,'qty_class'=>$qty_class,'user'=>$user,'utypes'=>$utypes));
        		#show temporary data
        		$this->template->slice('users/targets/show_existing',array('targets'=>$targets,'user_id'=>$this->input->post('user_id'),'designation_id'=>$this->input->post('user_type'),'limit'=>10,'offset'=>0,'status'=>$tstatus));
        	}else{
    			#target entry form	
				$this->template->slice('users/targets/enter_target',array('items'=>$items,'units'=>$units,'amt_class'=>$amt_class,'users'=>$users,'user_types'=>$utype,'qty_class'=>$qty_class));
			}

			$this->template->title($this->lang->line('user-targets'));
			$this->template->main_heading($this->lang->line('user-targets'));
			$this->template->breadcrumb(array($this->lang->line('targets')=>'no_link',$this->lang->line('search')=>'targets/t_search'));
			$this->template->slice('dms/message');
			$this->template->slice('dms/modals/more_details');
            $this->template->other_script('employees/employee_target');
			$this->template->other_script('progressbar/bootstrap-progressbar');
            $this->template->render();

		}

		#-----------------------------------------------------	

		#date : 13-01-2015
		#purpose : target general search
		function t_search(){

			$data = array('t.designation_id'=>'','t.user_id'=>'');
			$designation_id = '';
			$user_id = '';

			#get user list
            $users[''] = 'Select User';
            asort($users);

            #get user types
			$utype = $this->desig->desig_listing(1);
			$utype[''] = 'Select Type';
			asort($utype);

			$this->form_validation->set_rules('user_type','lang:user-type','required|xss_clean');
			$this->form_validation->set_rules('user_id','lang:user','required|xss_clean');
			$this->load->model('users/User_model','muser');

			if($this->form_validation->run() == TRUE || $this->uri->segment(3) != NULL || isset($_POST['search'])){

				$designation_id = $conditions['t.designation_id'] = $this->uri->segment(3);
				if(isset($_POST['search'])){
					$designation_id = $this->input->post('user_type'); 
				}
				$user_id = $this->uri->segment(4);	
				if($designation_id == 1){
					$users = $this->branch->listing(array('id !='=>$this->session->userdata('under_id')));
					$users[0] = "Select";
					asort($users); 
				}else if($designation_id == 3){
					$users = $this->target->listing_ar($designation_id);
					$users[0] = "Select";
					asort($users);
				}else{
					$users = $this->muser->listing(array('designation_id'=>$designation_id,'branch_id'=>$this->session->userdata('under_id')));
					$users[0] = "Select";
					asort($users);
				}

				if($this->input->post('user_id') != ''){ 
					$user_id = $this->input->post('user_id');
					$conditions['t.designation_id'] = $this->input->post('user_type');
				}
				#pagination
				$this->load->library('Pagination');
				$config['per_page'] = $this->per_page();
				# Pagination Config Customizations
				$config['full_tag_open'] = '<ul class="pagination">';
				$config['full_tag_close'] = '</ul>';
				$config['first_link'] = 'First';
				$config['last_link'] = 'Last';
				$config['next_link'] = '&raquo;';
				$config['prev_link'] = '&laquo;';
				$config['cur_tag_open'] = '<li class="active"><a href="#">';
				$config['cur_tag_close'] = '</a></li>';
				$config['num_tag_open'] = '<li>';
				$config['num_tag_close'] = '</li>';
				$config['base_url'] = base_url('targets/t_search/'.$designation_id.'/'.$user_id);
				$config['uri_segment'] = 5;
				$config['total_rows'] = $this->target->get_all(array('t.designation_id'=>$designation_id,'t.user_id'=>$user_id,'total'=>1));

				$this->pagination->initialize($config);
				$links = $this->pagination->create_links();
				$offset = $this->uri->segment(5,0);
				$targets = $this->target->get_all(array('t.designation_id'=>$designation_id,'t.user_id'=>$user_id,'limit'=>$config['per_page'],'offset'=>$offset));

				if($targets){
					if($this->uri->segment(3) == NULL) {
						$this->message->set(count($targets)."&ensp;".$this->lang->line('active-records'),'i');
					}
					$this->template->append('users/targets/show_existing',array('targets'=>$targets,'user_id'=>$user_id,'designation_id'=>$this->input->post('user_type'),'offset'=>$this->uri->segment($config['uri_segment'],0),'links'=>$this->pagination->create_links()));

				}else{
					if($user_id !=NULL){
						$this->message->set($this->lang->line('no-targets-found'),'e');
					}
					if($this->dms->have_access('156')){
						$this->message->append_msg('<a href="'.base_url('targets/e_set').'" class="ul">'.$this->lang->line('click-to-add-target').'</a>','i');
					}
				}
			}
			$this->template->title($this->lang->line('search-targets'));
			$this->template->main_heading($this->lang->line('search-targets'));
			$this->template->breadcrumb(array($this->lang->line('targets')=>'targets/e_set',$this->lang->line('search')=>'no_link'));
			$this->template->slice('users/targets/t_search',array('users'=>$users,'data'=>$data,'user_types'=>$utype,'sutype'=>$designation_id,'suser'=>$user_id)); 
			$this->template->slice('dms/message');
			$this->template->slice('dms/modals/more_details');
			$this->template->other_script('employees/employee_target');
			$this->template->render();
		}
	#------------------------------------------------------
	
	public function achievements(){
		
		$this->template->title('targets');
		$this->template->main_heading($this->lang->line('achievements'));
		$this->template->breadcrumb(array($this->lang->line('targets')=>'targets/e_set',$this->lang->line('achievements') => 'no_link',$this->lang->line('view achievements')=>'targets/view_achievements'));	
		
		$this->load->model('targets/Target_achievement_model','achievement');
		
		$this->form_validation->set_rules('ach_code','lang:code','required');
		$this->form_validation->set_rules('point','lang:point','required|is_natural|greater_than[0]');
		$this->form_validation->set_rules('ach_name','lang:achievement-name','trim|xss_clean');
		$this->form_validation->set_rules('gift_name','lang:gift','required|');
		$this->form_validation->set_rules('description','lang:description','trim|xss_clean');
		
		if($this->form_validation->run() === true){
			
			if($this->achievement->save($this->input->post(NULL,true))){
				$this->message->set($this->lang->line('achivement-saved'));
				redirect(base_url('targets/achievements'));
			}
			
		}
		
		$args = array();
		$args['order_by'] = 'point';
		$targetAchievements = $this->achievement->get($args);
		
		# view starts here--------------------------------
		$this->template->slice('dms/message');
		$this->template->slice('targets/achievements',array('achievements'=>$targetAchievements));
		$this->template->render();					
	}
	
	#------------------------------------------------------
	
	public function delete_achievements(){

		if(!$this->uri->segment(3)){ 
			redirect('users/logout');
		}
		$achievementID = $this->uri->segment(3);
		
		if($this->if_exists('target_achievements',array('id'=>$achievementID)) === false){
			redirect('targets/achievements');
		}
		$this->load->model('targets/Target_achievement_model','achievement');
		if($this->achievement->delete($achievementID)){
			$this->message->set($this->lang->line('achievement-deleted'));
		}
		redirect('targets/achievements');
	}
	#------------------------------------------------------	
	
	public function view_achievements(){
		
		$this->template->title('targets');
		$this->template->main_heading($this->lang->line('view achievements'));
		$this->template->breadcrumb(array($this->lang->line('targets')=>'targets/e_set',$this->lang->line('achievements') => 'targets/achievements',$this->lang->line('view achievements')=>'no_link'));	
		
		$this->load->model('targets/Target_achievement_model','achievement');
		
		$args = array();
		$args['order_by'] = 'point';
		$targetAchievements = $this->achievement->get($args);
		if(empty($targetAchievements)){
			$this->message->set($this->lang->line('no-result-found'),'i');
		}
		
		# view starts here--------------------------------
		$this->template->slice('dms/message');
		$this->template->slice('targets/view_achievements',array('achievements'=>$targetAchievements));
		$this->template->render();	
				
	}

	#------------------------------------------------------
	
		#date : 06-02-2015
		#purpose : delete the user target
		public function delete_e_target(){
			$target_id = $this->uri->segment(3);
			$reverse_id = $this->uri->segment(5);
			$get_target = $this->target->get_all(array('t.id'=>$target_id));

			#get user name & designation
			$userID = $get_target[0]['user_id'];
			$jobrole_id = $get_target[0]['designation_id'];
			
			if(empty($target_id)){
				redirect('access/');
			}
				#delete query is same for both temp & perma
				$result=$this->target->delete_temp('targets',$target_id);
				if($result){
					$result=$this->target->delete_temp('target_items',$target_id);
					$this->message->set($this->lang->line('target-deleted'),'s');
				}
				else{
					$this->message->set($this->lang->line('target-not-deleted'),'e');
				}
				$row=$this->target->get_user($target_id);
				if($reverse_id=='t_search')
				{
					 redirect('targets/t_search/'.$jobrole_id.'/'.$userID);
				}
					 redirect('targets/e_set');
		}

                function ec_set(){

		#loading models
				
			$this->load->model('products/Item_model','item');
			$this->load->model('products/Unit_model','unit');
			$this->load->model('retailers/Counter_model','ar');
			//$this->load->model('users/User_model','muser');
			$this->template->slice('dms/message');

              

		#items groups
			$items = $this->item->item_group_listing();
	                $items[''] = 'Select an item group';
	                ksort($items);

	        #amount or quantity
	                $amt_class = 'hide';
			$qty_class = '';

		#units after add button ------------------------------
			if($this->input->post('item_group_id')!= NULL){
	                $this->load->library('Stock');
	                $item_group_id = $this->input->post('item_group_id');
	                $units = $this->stock->get_item_group_units($item_group_id);
			}else{
				$units[''] = 'select a unit';
			}

			#fetch temporary data ---------------------------------
			$targets = $this->target->get_all_ctemp(array('t.created_by'=>$this->session->userdata('id')));
			if(isset($_POST['add'])){
		
                                $this->form_validation->set_rules('target_type','lang:target_type','required');
				$this->form_validation->set_rules('item_group_id','lang:item-type','required');
				$this->form_validation->set_rules('comments','lang:comments','trim|xss_clean');
				$this->form_validation->set_rules('valid_from','lang:date','is_date|valid_date');
				$this->form_validation->set_rules('valid_to','lang:date','is_date');
				$this->form_validation->set_rules('point','lang:points','required|xss_clean|numeric');
				$valid = FALSE;
			}

			if(isset($_POST['add']) && $_POST['target_type'] == 0){
				$this->form_validation->set_rules('qty','lang:qty','required');
				$this->form_validation->set_rules('unit_id','lang:unit','required');
				$valid = FALSE;
				$amt_class = 'hide';
				$qty_class = '';
			}

			if(isset($_POST['add']) && $_POST['target_type'] == 1){
				$this->form_validation->set_rules('amount','lang:amount','required|xss_clean|numeric');
				$valid = FALSE;
				$amt_class = '';
				$qty_class = 'hide';
			}

		

		if($this->form_validation->run() == TRUE)
		{
		    $valid = TRUE;
		    if(isset($_POST['add']))
		    {
			if(!empty($targets)){
				$data['designation_id'] = 0;
				$data['user_id'] = 0;
			}else{
			        $data['designation_id'] = 0;
	                        $data['user_id'] = 0;
                	}
		                $data['target_type'] = $this->input->post('target_type');
		                $data['valid_from'] = $this->input->post('valid_from');
		                $data['valid_to'] = $this->input->post('valid_to');
		                $data['comments'] = $this->input->post('comments');
		                $data['status'] = '-1';
		                $data2['item_group_id'] = $this->input->post('item_group_id');
		                $data2['qty'] = $this->input->post('qty');
		                $data2['unit_id'] = $this->input->post('unit_id');
		                $data2['amount'] = $this->input->post('amount');
		                $data2['points'] = $this->input->post('point');
		                $data2['status'] = '-1';

                    if($this->input->post('target_type',TRUE)==1){
				$data2['amount'] = $this->input->post('amount');
				$data2['qty'] = '';
				$data2['unit_id'] = '';
		    }
		    if($this->input->post('target_type',TRUE)==0){
				$data2['amount'] = '';
		    }

		#chk whether target setting exist for the same user.
		$exist = $this->target->chk_all_ctemp($data['user_id'],$data['designation_id'],$data['target_type'],$data2['item_group_id']);
		    if(empty($exist)){
	                if($result = $this->target->save($data)){
                    		$data2['targets_id'] = $result;
                    		$this->target->save_bonus($data2);
                                $this->message->set($this->lang->line('target-added'));
                                redirect('targets/ec_set');
			    }else{
                                $this->message->set($this->lang->line('target-not-saved'),'e');
		            }
                    }else{
                	 $this->message->set($this->lang->line('target-exist'),'e');
                    }
		  }
		}

		if(isset($_POST['save']))
		{
			$ins = 0;
			foreach($targets as $key=>$tg){
				$tid = $tg['targets_id'];
				$utypes = $tg['designation_id'];
				$user = $tg['user_id'];
				$condition = array('status' => '1');
				$this->target->save_target($condition,$user);
				$this->target->save_target_items($condition,$tid);
				$ins++;
			}
			if($ins>0)
			{
				$this->message->set($this->lang->line('target-saved'));
				redirect('targets/ec_set');
			}else{
                                $this->message->set($this->lang->line('target-not-saved'));
                               redirect('targets/ec_set');
                        }
		}

		$tstatus = '-1';
		#after fetching temporary data
		if(!empty($targets)){
			$target_type = $targets[0]['target_type'];
		
			if($target_type == 1) {
				$amt_class = '';
				$qty_class = 'hide';
			}

		

        		$this->template->slice('customers/target/enter_target',array('items'=>$items,'units'=>$units,'amt_class'=>$amt_class,'users'=>$users,'user_types'=>$utype,'target_type'=>$target_type,'qty_class'=>$qty_class,'user'=>$user,'utypes'=>$utypes));
        		#show temporary data
        		$this->template->slice('customers/target/show_existing',array('targets'=>$targets,'user_id'=>$this->input->post('user_id'),'designation_id'=>$this->input->post('user_type'),'limit'=>10,'offset'=>0,'status'=>$tstatus));
        	}else{
    			#target entry form
				$this->template->slice('customers/target/enter_target',array('items'=>$items,'units'=>$units,'amt_class'=>$amt_class,'users'=>$users,'user_types'=>$utype,'qty_class'=>$qty_class));
			}

			$this->template->title($this->lang->line('customer-points'));
			$this->template->main_heading($this->lang->line('customer-points'));
			$this->template->breadcrumb(array($this->lang->line('targets')=>'no_link'));
			$this->template->slice('dms/message');
			$this->template->slice('dms/modals/more_details');
                        $this->template->other_script('employees/employee_target');
			$this->template->other_script('progressbar/bootstrap-progressbar');
                        $this->template->render();

		}

		#-----------------------------------------------------
		
		
		#date: 25-11-2017
		#purpose : edit customer target

		public function update_ec_target(){

			$valid = TRUE;
			$target_id = $this->uri->segment(3);
			$target_status = $this->uri->segment(4);

			if(empty($target_id)){
				redirect('access/');
			}

			#get employee target details
			if($target_status=='-1'){
				$employee_target = $this->target->get_all_ctemp(array('t.id'=>$target_id,'t.created_by'=>$this->session->userdata('id')));
			}else{
				$employee_target = $this->target->get_call(array('t.id'=>$target_id));
			}

			#get user name & designation
			//$userID = $employee_target[0]['user_id'];
			//$jobrole_id = $employee_target[0]['designation_id'];
			//$jobrole = $this->desig->get_name($jobrole_id);

			if(isset($_POST['submit_two'])){
				$this->form_validation->set_rules('target[item_group_id]','lang:item-type','required');
				$this->form_validation->set_rules('target_type','lang:target_type','required');
				$this->form_validation->set_rules('comments','lang:comments','trim|xss_clean');
				$this->form_validation->set_rules('point','lang:points','required|xss_clean|numeric');
				$this->form_validation->set_rules('valid_from','lang:date','is_date|required|valid_date');
				$this->form_validation->set_rules('valid_to','lang:date','is_date|required');
				$valid = FALSE;
			}
			if(isset($_POST['submit_two']) && $_POST['target_type']==0){
				$this->form_validation->set_rules('target[qty]','lang:qty','required');
				$this->form_validation->set_rules('target[unit_id]','lang:unit','required');
				$valid = FALSE;
			}

                        if(isset($_POST['submit_two']) && $_POST['target_type']==1){
				$this->form_validation->set_rules('amount','lang:amount','required|xss_clean|numeric');
				$valid = FALSE;
			}

			if(($this->form_validation->run() == TRUE) && ($valid = TRUE)){
				if(isset($_POST['submit_two'])){

					$data = $this->input->post(NULL,TRUE);
					$targets = $this->input->post('target',TRUE);

					if($this->input->post('target_type',TRUE)==1){
						$targets2['amount'] = $data['amount'];
						$targets2['qty'] = $targets['qty'] = 0;
						$targets2['unit_id'] = $targets['unit_id'] = 0;
					}
					if($this->input->post('target_type',TRUE)==0){
						$targets2['amount'] = 0;
						$targets2['qty'] = $targets['qty'];
						$targets2['unit_id'] = $targets['unit_id'] ;
					}

					        $targets2['item_group_id'] = $targets['item_group_id'];
						$targets2['unit_id'] = $targets['unit_id'];
						$targets2['points'] = $data['point'];
				                $targets1['target_type'] = $data['target_type'];
				                $targets1['comments'] = $data['comments'];
				                $targets1['valid_from'] = $data['valid_from'];
				                $targets1['valid_to'] = $data['valid_to'];

					$result=$this->target->update_targets('targets',$targets1,$target_id);
					if($result){
						$this->target->update_targets('target_items',$targets2,$target_id);
						$this->message->set($this->lang->line('target-updated'));
					}else{
						$this->message->set($this->lang->line('target-not-updated'));
					}

                	#chk whether edit request came form t_search or e_set and redirect
					if($target_status=='1') {
						redirect('targets/t_search/'.$jobrole_id.'/'.$userID);
					}else{
						redirect('targets/ec_set/');
					}
				}
			}

			if($employee_target[0]['target_type'] == 1){
				$amt_class = '';
				$qty_class = 'hide';
			}else{
				$amt_class = 'hide';
				$qty_class = '';
			}

			#items
			$this->load->model('products/Item_model','item');
			$items = $this->item->item_group_listing();
			$items[''] = 'Select an item group';
			ksort($items);

			#units
			if(isset($_POST['target']['item_group_id'])){
				$this->load->model('products/Unit_model','unit');
				$units = $this->unit->listing('');
			}
			$this->load->model('products/Unit_model','unit');
			$units = $this->unit->listing('');

			#checking user type to display name
			if($jobrole_id == 1){
				$user_name = $this->branch->get_full_name($userID);
			}else{
				$user_name = $this->user->get_fname_lname($userID);
			}

			$this->template->title($this->lang->line('update-target'));
			$this->template->main_heading($this->lang->line('update-target'));
			$this->template->breadcrumb(array($this->lang->line('targets')=>'targets/ec_set',$this->lang->line('update')=>'no_link'));
			$this->template->slice('dms/message');
			$this->template->slice('customers/target/update',array('employee_target'=>$employee_target,'items'=>$items,'units'=>$units,'desig_id'=>$jobrole_id,'user_name'=>$user_name,'jobrole'=>$jobrole,'amt_class'=>$amt_class,'qty_class'=>$qty_class));
			$this->template->other_script('employees/employee_target');
			$this->template->other_script('targets/target');
			$this->template->render();
		}

		#-----------------------------------------------------


		#date : 25-11-2017
		#purpose : delete the customer target
		public function delete_ec_target(){
			$target_id = $this->uri->segment(3);
			$reverse_id = $this->uri->segment(5);
			$get_target = $this->target->get_all(array('t.id'=>$target_id));

			#get user name & designation
			$userID = $get_target[0]['user_id'];
			$jobrole_id = $get_target[0]['designation_id'];

			if(empty($target_id)){
				redirect('access/');
			}
				#delete query is same for both temp & perma
				$result=$this->target->delete_temp('targets',$target_id);
				if($result){
					$result=$this->target->delete_temp('target_items',$target_id);
					$this->message->set($this->lang->line('target-deleted'),'s');
				}
				else{
					$this->message->set($this->lang->line('target-not-deleted'),'e');
				}
				$row=$this->target->get_user($target_id);
				//if($reverse_id=='t_search')
				//{
				//	 redirect('targets/t_search/'.$jobrole_id.'/'.$userID);
				//}
					 redirect('targets/ec_set');
		}

                function ecust_set()
                {

		        #loading models
				
			$this->load->model('products/Item_model','item');
			$this->load->model('products/Unit_model','unit');
			$this->load->model('retailers/Counter_model','ar');
			//$this->load->model('users/User_model','muser');
			$this->template->slice('dms/message');
		
			#fetch temporary data ---------------------------------
			
			if(isset($_POST['add']))
                        {
                                $this->form_validation->set_rules('amount','lang:points','required|xss_clean|numeric');
				$this->form_validation->set_rules('point','lang:points','required|xss_clean|numeric');				
			}

		        if($this->form_validation->run() == TRUE)
		        {
		                
		                if(isset($_POST['add']))
		                {
		                       $amount = $this->input->post('amount',true);
		                       $point = $this->input->post('point',true);
		
                                       $qr1 = "update customer_target set amount='$amount',point='$point' where id='1'";
                                       
	                               if($this->db->query($qr1))
                                       {
                    		            
                                            $this->message->set($this->lang->line('target-updated'));
                                            redirect('targets/ecust_set');
			               }
                                       else
                                       {
                                            $this->message->set($this->lang->line('target-not-saved'),'e');
		                       }                                                  
		                  }
		         }

		        $targ = $this->db->select('*')->from('customer_target')->where('id',1)->get()->row_array();
			$am = $targ['amount'];
		        $pts = $targ['point'];

        		$this->template->slice('customers/target/show_existing',array('amount'=>$am,'point'=>$pts));      
			$this->template->slice('customers/target/enter_targets');

			$this->template->title($this->lang->line('customer-points'));
			$this->template->main_heading($this->lang->line('customer-points'));
			$this->template->breadcrumb(array($this->lang->line('targets')=>'no_link'));
			$this->template->slice('dms/message');
			$this->template->slice('dms/modals/more_details');
                        $this->template->other_script('employees/employee_target');
			$this->template->other_script('progressbar/bootstrap-progressbar');
                        $this->template->render();

		}



	#-------------------------------------------------------
	}
?>