<?php if( ! defined('BASEPATH')) exit ('No direct script access allowed');

class Trial_balance extends MY_Controller{

	public function __construct()
	{
		parent :: __construct();		
		$this->check_access_right();

		$this->load->library('Accounts');
	}
	
	public function index()
	{
		$fiscal_start_date = $this->dms->get_fiscal_year()['start_date'];
		$from_date = $to_date = date('Y-m-d'); //$fiscal_start_date;
		$vouchers_array = array();$dc = "";$diff_open_bal_dr = $diff_open_bal_cr = $opening_bal = $total_dr = $total_cr = $profit_loss_dr = $profit_loss_cr = 0;
		
		if(isset($_POST['btn_search']))
		{
			#-------------validation
			$this->form_validation->set_rules('from_date','lang:from-date','required|xss_clean|valid_date');
			if($this->input->post('from_date',true))
			{
				$from_date = $this->input->post('from_date',true);
				$this->form_validation->set_rules('to_date','lang:to-date',"required|xss_clean|valid_date|check_date[$from_date.>=]");
			}
			if($this->form_validation->run() === true)
			{
				$from_date = date('Y-m-d',strtotime($this->input->post('from_date',true)));
				$to_date = date('Y-m-d',strtotime($this->input->post('to_date',true)));
				$this->session->set_userdata(array('from_date' => $from_date,'to_date' => $to_date));
			}
		}
		elseif($this->session->userdata('from_date') && $this->session->userdata('to_date'))
		{
			$from_date = $this->session->userdata('from_date');
			$to_date = $this->session->userdata('to_date');

			#----------validating dates
			if(!$this->form_validation->valid_date($from_date) || !$this->form_validation->valid_date($to_date)){
				redirect('users/logout');
			}
			else{
				if(!$this->form_validation->check_date($from_date,$to_date.".<=")){
					redirect('users/logout');
				}
			}
		}
		if(!empty($from_date) && !empty($to_date))
		{
			$gross_expense = $gross_income = $opening_stock = 0;
			$next_date = date('Y-m-d',(strtotime($to_date)+86400));
			$pre_date = date('Y-m-d',(strtotime($from_date)-86400));
			
			#----------closed details
			$closed = $this->accounts->last_closed_yr($from_date);
			if($closed)
			{
				$open_date = date('Y-m-d',(strtotime($closed['end_date'])+86400));
			}
			else
			{
				$open_date  = $this->accounts->stock_open_date();
			}
			
			$data_array = array('columns' => array('id','sub_group','dc'));
			$account_groups = $this->accounts->get_account_groups(array('columns' => array('id','sub_group','dc'),'or' => "(primary_group_id=7 or primary_group_id=8 or primary_group_id=9 or primary_group_id=11 or primary_group_id=12 or primary_group_id=1 or primary_group_id=2)"));
			foreach($account_groups as $key => $value)
			{
				$dr_amount = $cr_amount = $opening_bal = 0;	
				$opening_bal = $this->accounts->opening_bal($value['id'],$from_date,1);			
				$voucher_bal = $this->accounts->voucher_bal($value['id'],$next_date,1);
				if($value['id'] == 16)//stock in hand
				{
					$dr_amount = $this->accounts->stock_bal_amt($from_date);
				}				
				if($value['dc'] == 'dr')
				{
					$dr_amount += ($voucher_bal['dr_amount'] - $voucher_bal['cr_amount']) + $opening_bal;
					if($dr_amount < 0)
					{
						$cr_amount = -$dr_amount;
						$dr_amount = 0;
					}
				}
				else
				{
					$cr_amount += ($voucher_bal['cr_amount'] - $voucher_bal['dr_amount']) + $opening_bal;
					if($cr_amount < 0)
					{
						$dr_amount = -$cr_amount;
						$cr_amount = 0;
					}
				}					
				if($dr_amount > 0 || $cr_amount > 0)
				{					
					$vouchers_array[$value['id']] = array('group_name' => $value['sub_group'],'dr_amount' => $dr_amount,'cr_amount' => $cr_amount);
				}
				$total_dr += $dr_amount;
				$total_cr += $cr_amount;
			}

			#-----------expense		
			$account_groups_expense = $this->accounts->get_account_groups(array('columns' => array('id','sub_group','dc'),'or' => "(primary_group_id=3 or primary_group_id=4 or primary_group_id=5 or primary_group_id=6)"));
			foreach($account_groups_expense as $key => $value)
			{
				$dr_amount = $cr_amount = $opening_bal = 0;
				$opening_bal = $this->accounts->opening_bal($value['id'],$to_date,1,$from_date);
				$voucher_bal = $this->accounts->voucher_bal($value['id'],$to_date,1,$from_date);
				$dr_amount = ($voucher_bal['dr_amount'] - $voucher_bal['cr_amount']) + $opening_bal;
				if($dr_amount < 0)
				{
					$cr_amount = -$dr_amount;
					$dr_amount = 0;
				}	
				if($dr_amount > 0 || $cr_amount > 0)
				{					
					$vouchers_array[$value['id']] = array('group_name' => $value['sub_group'],'dr_amount' => $dr_amount,'cr_amount' => $cr_amount);
				}
				$total_dr += $dr_amount;
				$total_cr += $cr_amount;		
			}
			
			#-----------income
			$account_groups_income = $this->accounts->get_account_groups(array('columns' => array('id','sub_group','dc'),'or' => "(primary_group_id=10 or primary_group_id=13)"));
			foreach($account_groups_income as $key => $value)
			{
				$dr_amount = $cr_amount = $opening_bal = 0;
				$opening_bal = $this->accounts->opening_bal($value['id'],$to_date,1,$from_date);
				$voucher_bal = $this->accounts->voucher_bal($value['id'],$to_date,1,$from_date);
				$cr_amount = ($voucher_bal['cr_amount'] - $voucher_bal['dr_amount']) + $opening_bal;	
				if($cr_amount < 0)
				{
					$dr_amount = -$cr_amount;
					$cr_amount = 0;
				}	
				if($dr_amount > 0 || $cr_amount > 0)
				{					
					$vouchers_array[$value['id']] = array('group_name' => $value['sub_group'],'dr_amount' => $dr_amount,'cr_amount' => $cr_amount);
				}
				$total_dr += $dr_amount;
				$total_cr += $cr_amount;				
			}

			#-------------profit & loss A/c
			$profit_loss = $this->accounts->opening_bal(7,$from_date);//Profit & Loss A/c								

			#-----------expense		
			$account_groups = $this->accounts->get_account_groups(array('columns' => array('id','sub_group','dc'),'or' => "(primary_group_id=3 or primary_group_id=4 or primary_group_id=5 or primary_group_id=6)"));
			foreach($account_groups as $key => $value)
			{
				$opening_bal = 0;
				$opening_bal = $this->accounts->opening_bal($value['id'],$from_date,1);	
				$voucher_bal = $this->accounts->voucher_bal($value['id'],$from_date,1);
				$vamount = ($voucher_bal['dr_amount'] - $voucher_bal['cr_amount']) + $opening_bal;
				$gross_expense += $vamount;				
			}
			
			#-----------income
			$account_groups = $this->accounts->get_account_groups(array('columns' => array('id','sub_group','dc'),'or' => "(primary_group_id=10 or primary_group_id=13)"));
			foreach($account_groups as $key => $value)
			{
				$opening_bal = 0;	
				$opening_bal = $this->accounts->opening_bal($value['id'],$from_date,1);	
				$voucher_bal = $this->accounts->voucher_bal($value['id'],$from_date,1);
				$vamount = ($voucher_bal['cr_amount'] - $voucher_bal['dr_amount']) + $opening_bal;
				$gross_income += $vamount;			
			}
			
			if($gross_expense != 0 || $gross_income != 0)
			{
				#-----------opening stock
				$gross_expense += $this->accounts->stock_bal_amt($open_date);
											
				#-----------closed stock
				$closed_voucher_stock_bal = $this->accounts->voucher_bal(16,$pre_date,1,$open_date);//stock in hand voucher
				$closed_stock_bal = $this->accounts->stock_bal_amt($pre_date,0,1);//stock in hand stock		
				$closed_stock = ($closed_voucher_stock_bal['dr_amount'] - $closed_voucher_stock_bal['cr_amount']) + $closed_stock_bal;			
				$gross_income += $closed_stock;
			}
			
			#------------profit & loss calculation
			$profit_loss += ($gross_income - $gross_expense);
			if($profit_loss > 0)
			{
				$profit_loss_cr = $profit_loss;
				$total_cr += $profit_loss_cr;
			}
			elseif($profit_loss < 0)
			{
				$profit_loss_dr = -$profit_loss;
				$total_dr += $profit_loss_dr;
			}
			
			#------------Total calculation
			if($total_dr > $total_cr)
			{
				$diff_open_bal_cr = $total_dr - $total_cr;
				$total_cr += $diff_open_bal_cr;
			}
			elseif($total_cr > $total_dr)
			{
				$diff_open_bal_dr = $total_cr - $total_dr;
				$total_dr += $diff_open_bal_dr;
			}
		}
		
		#-------------template
		$this->template->title('Trial Balance');
		$this->template->main_heading('Trial Balance');
		$this->template->breadcrumb(array($this->lang->line('account-reports') => 'no_link',$this->lang->line('trial-balance') => 'no_link'));
		$this->template->slice('account_reports/account_group_search',array('from_date' => $from_date,'to_date' => $to_date,'astatus' => 1));		
		if(!empty($vouchers_array) || !empty($profit_loss))
		{
			$access_rights = $this->have_access(433);
			$stock_access_rights = $this->have_access(426);
			$this->template->append('account_reports/trial_balance',array('voucher_array' => $vouchers_array,'open_bal_dr' => $diff_open_bal_dr,'open_bal_cr' => $diff_open_bal_cr,'total_dr' => $total_dr,'total_cr' => $total_cr,'profit_loss_dr' => $profit_loss_dr,'profit_loss_cr' => $profit_loss_cr,'access_rights' => $access_rights,'from_date' => $from_date,'to_date' => $to_date,'stock_access_rights' => $stock_access_rights));
		}
		else{
			$this->message->set($this->lang->line('no-result-found'),'i');
		}
		$this->template->slice('dms/message');
		$this->template->render();
	}
}