<?php if ( ! defined('BASEPATH')) exit('No direct script access allowed');
	
	class Users extends MY_Controller{

	#---------------------------------------------------
		
		public function __construct(){

			parent :: __construct();

			if(!in_array($this->uri->segment(2),array('show','profile','login','logout','login_action'))){
				$this->check_access_right();
				
				#---------------- Checking Financial year is enabled / closed-----------------#
				$method_array = array('add','update');
				fiscal_status($this->uri->segment(2),$method_array,"users/home");	
				#---------------- Checking Financial year is enabled / closed-----------------#
			
			}
		}
                 
	#---------------------------------------------------

		public function login(){
			
			if($this->session->userdata('id')){
				redirect('users/home');
			}
			#get cookies if set
			$c_user = array();
			$blocked = 0;
			if(isset($_COOKIE['dms110rlnt14'])){

				$c_user = $this->db->select(array('fname','lname','gender','photo'))->get_where('users',array('username'=>$_COOKIE['dms110rlnt14'],'status'=>1))->row_array();
				
				if(empty($c_user)){ 
					$blocked = 1;
				}else{
					if($c_user['photo'] == ''){ $c_user['photo'] = (!empty($c_user['gender']))?$c_user['gender'].'.jpg':'Malse.jpg'; }
				}	
			}

			$this->template->other_script('users/login');
			$this->template->render('users/login',array('user'=>$c_user,'blocked'=>$blocked));
		}

	#-----------------------------------------------------

		public function login_action()
		{
			
			if(!isset($_COOKIE['dms110rlnt14']))
			{
				$username = $this->input->post('username',true);
			}
			else
			{
				$username = $_COOKIE['dms110rlnt14'];
			}	
			$password = $this->input->post('password',true);

			if(empty($username))
			{
				echo '<div class="alert alert-danger">Please type your username</div>';
			}
			else if(empty($password))
			{
				echo '<div class="alert alert-danger">Please type in your password</div>';
			}
			else
			{
				#validation success
				$user = $this->user->login($username,$password);
				if(!empty($user) && count($user) > 1)
				{
					$new_data = array('id'=>$user['id'],'loggedIn'=>true,'user_desig'=>$user['designation_id'],'company_id'=>$user['company_id'],'fiscal_yr_id'=>$user['fiscal_yr_id'],'under_id'=>$user['branch_id']);

					$this->session->set_userdata($new_data);
					#update online status
					$this->db->update('users',array('online_status'=>1),array('id'=>$user['id']));

					#cookie settings
					if($this->input->post('remember_me'))
					{
						#set cookies
						setcookie('dms110rlnt14',$username,time()+31536000);
					}
					else
					{
						if(isset($_COOKIE['dms110rlnt14']))
						{
							#clear cookie
							setcookie('dms110rlnt14',$username,time()-10);
						}
					}
					echo "loggedIn";
				}
				else
				{

					$this->db->insert('login_attempts',array('username'=>$username,'date'=>date('Y-m-d')));
					$total = $this->db->get_where('login_attempts',array('username'=>$username,'date'=>date('Y-m-d')))->num_rows();
				/*	if($total >= 3)
					{
						$this->db->update('users',array('status'=>-1),array('username'=>$username));
						echo 'locked';die;
					} */
					if(!empty($user))
					{
						echo '<div class="alert alert-danger">'.$user[0].'</div>';
					}
					else
					{
						echo '<div class="alert alert-danger">Invalid username or password</div>';
					}
				}
			}	
		}

	#------------------------------------------------------	

		public function home(){

			$date =  date('Y-m-d');
			#insurance remainder
			$this->load->model('vehicles/Vehicle_model','vehicle');
			$insurances = $this->vehicle->insurance_payment_remainder($date);

			#enquiry follow up remainder
			$this->load->model('enquiries/Enquiry_model','enquiry');
			$enquiries = $this->enquiry->follow_up_remainder($date);
			
			#to fetch saved targets for the employee
			$this->load->model('targets/Target_model','target');
			$targets=$this->target->get_all(array('user_id'=>$this->session->userdata('id')));
			
			#to notify target deadline
			$result = $this->target->notify_timely_targets();
			$timeTarget = $this->get_target();
			$today = date('Y-m-d');

			#calculating notify range of date from constant master
	    	$NewDate = date('Y-m-d', strtotime("+".$timeTarget." days"));

	    	foreach($result as $res) {
	    		
				#splitting timestamp to get last saved date of created_on
    			$dbdate = date('Y-m-d',strtotime($res['created_on']));
   			
	    		#checking to show notification only once in day
	    		if($dbdate!= $today){
	    		
	    			#notify at time for targets
		    		if(($NewDate) == $res['valid_to'])
			    	{
						$this->target->update_target(array('seen_status'=>0,'created_on'=>date('Y-m-d h:i:s a', time())),$res['id']);
			    	}
				    	#notify at deadline
				    	if(($today) == $res['valid_to'])
				    	{
				    		$this->target->update_target(array('seen_status'=>0,'created_on'=>date('Y-m-d h:i:s a', time())),$res['id']);
				    	}
	    		}
			}


			$this->template->title(APP_NAME.' Home');
			$this->template->main_heading($this->lang->line('welcome'));
			$this->template->slice('users/home_menu',array('insurances'=>$insurances,'enquiries'=>$enquiries));
			$this->template->render();
		}

	#--------------------------------------------------------	

		public function logout(){

			#update online status
			$this->db->update('users',array('online_status'=>0),array('id'=>$this->session->userdata('id')));
			$this->session->sess_destroy();
			redirect('users/login');
		}

	#---------------------------------------------------------	

		#date : 19-5-2014
		#use : to manage user privileges
		public function privilege(){

			$this->template->title('User privileges');
			$this->template->breadcrumb(array($this->lang->line('users')=>'users/report',$this->lang->line('privilege')=>'no_link'));
	
			#get all users
			$users = $this->user->list_it();
			$users[0] = 'select employee';
			$this->template->slice('users/listing/select_user_name',array('users'=>$users));
			$this->template->slice('dms/modals/message_modal');
			$this->template->render();
		}


	#----------------------------------------------------------	

		#date : 03-06-2014
		#purpose : add new users
		public function add(){
			if($this->form_validation->run() == true){

				$file_upload_error = true;
				#upload the photo if one is selected.
				if($_FILES['photo']['name'] != ''){

					$ext = pathinfo($_FILES['photo']['name'], PATHINFO_EXTENSION);
					#file name initialization
					$max_id = $this->user->get_max_id();
					$f_part1 = $max_id+1;
					$f_part2 = $f_part1."user".date('YmdHis');
					$fileName = $f_part2.".".$ext;

					#file uploading 
					$config['upload_path'] =  FCPATH.'assets/images/photos/';
					$config['allowed_types'] = 'jpeg|jpg|png';
					$config['max_size']	= '600';
					$config['max_width']  = '2560';
					$config['max_height']  = '1600';
					$config['file_name'] = $fileName;
					$this->load->library('Upload');
					$this->upload->initialize($config);

					if($this->upload->do_upload('photo')){

							$file_upload_error = false;
							$config['image_library'] = 'gd2';
							$config['source_image']	= $config['upload_path'].$fileName;
							$config['create_thumb'] = TRUE;
							$config['maintain_ratio'] = false;
							$config['width']	= 150;
							$config['height']	= 120;

							$this->load->library('Image_lib', $config); 
                            $this->image_lib->resize();

							#unlink original file & rename thumb
							unlink($config['upload_path'].$fileName);
							//$var = $this->image->get_parts($file_name);

							$thumb = $config['upload_path'].$f_part2.'_thumb'.'.'.$ext;

							$original = $config['upload_path'].$fileName;

							rename($thumb,$original);
					}
					else{
						$file_upload_error = true;
					}
					
				
				}else{
					$fileName = $this->input->post('gender').'.jpg'; #dummy image in case no image uploaded
					$file_upload_error = false;
				}

				if($file_upload_error){
					$this->message->set($this->lang->line('invalid-photo'),'e');
				}else{
		
					$data = $this->input->post(NULL,true);
					$data['photo'] = $fileName;
					$data['fiscal_yr_id'] = $this->dms->get_default_fiscal_id();
					if($user_id = $this->user->save($data)){
						//echo $this->db->last_query();die;
						$this->message->set($this->lang->line('user-saved'));
					}else{
						//echo $this->db->last_query();die;
						$this->message->set($this->lang->line('user-not-saved'),'e');	
					}
					redirect('users/report');
				}

			} #end form-validation	
			
			#get all department listing
			$this->load->model('departments/Department_master_model','dept');
			$depts = $this->dept->listing(); 
			$depts[''] = 'Select a department';
			ksort($depts);

			#dummy designations
			if($this->input->post()){
				$this->load->model('designations/Designation_master_model','desg');
				$desgs = $this->desg->get_desg_for_dept($this->input->post('department_id'));
			}else{
				$desgs = array(''=>'Select a department first');
			}	

			#branches
			$this->load->model('branches/Branch_model','branch');
			$branches = $this->branch->listing(array('company_id'=>$this->session->userdata('company_id')));
			$branches[''] = 'Select a branch';
			ksort($branches);


			$this->template->title($this->lang->line('add-new-employee'));
			$this->template->main_heading($this->lang->line('add-new-employee'));
			$this->template->breadcrumb(array($this->lang->line('employees')=>'no_link',$this->lang->line('report')=>'users/report'));
			$this->template->slice('dms/message');
			$this->template->slice('users/manage/new',array('depts'=>$depts,'desgs'=>$desgs,'branches'=>$branches));
			$this->template->other_script(array('user_add','users/user_name_check'));
			$this->template->render();
		}

	#-----------------------------------------------------------	

		public function report(){	
			$this->load->library(array('Pagination','Stock'));	
			$conditions = array();//
			$branch_ID= '';
			$this->form_validation->set_rules('branch_id','lang:branch','trim|xss_clean');
			if($this->form_validation->run() == true || $this->uri->segment(3) == 'branch'){

				$branch_ID = ($this->input->post('branch_id'))?$this->input->post('branch_id',true):$this->uri->segment(4);
				if(!empty($branch_ID)){	
					$conditions['users.branch_id'] =$branch_ID; 
					$conditions['users.company_id'] = $this->session->userdata('company_id');
				}else{

					$branch_ID ='';
					$conditions['users.company_id'] = $this->session->userdata('company_id');
				}
			}
			$config['total_rows'] = $this->user->get_all($conditions,1);
			//echo $this->db->last_query();die;
			$config['per_page'] = $this->per_page();
			# Pagination Config Customizations
			$config['full_tag_open'] = '<ul class="pagination">';
			$config['full_tag_close'] = '</ul>';
			$config['first_link'] = 'First';
			$config['last_link'] = 'Last';
			$config['next_link'] = '&raquo;';
			$config['prev_link'] = '&laquo;';
			$config['cur_tag_open'] = '<li class="active"><a href="#">';
			$config['cur_tag_close'] = '</a></li>';
			$config['num_tag_open'] = '<li>';
			$config['num_tag_close'] = '</li>';
			if($this->uri->segment(3) == 'branch' || $this->input->post('branch_id')){
				$config['base_url'] = base_url('users/report/branch/'.$branch_ID);
				$config['uri_segment'] = 5;
				$offset = ($this->uri->segment(5))?$this->uri->segment(5):0;
			}else{
				$config['base_url'] = base_url('users/report');
				$config['uri_segment'] = 3;
				$offset = ($this->uri->segment(3))?$this->uri->segment(3):0;
			}
			$this->pagination->initialize($config);	
		
			$employees = $this->user->get_all($conditions,0,$offset,$config['per_page']);
			if(empty($employees)){
				$this->message->set($this->lang->line('no-result-found'),'i');
			}
			$links = $this->pagination->create_links();

			$branches = $this->dms->get_branches();
			$branches[''] = 'All';
			ksort($branches);
			$this->template->title($this->lang->line('employee-report'));
			$this->template->main_heading($this->lang->line('employee-report'));
			$this->template->breadcrumb(array($this->lang->line('employees')=>'users/add',$this->lang->line('report')=>'no_link'));
			
			$this->template->slice('dms/message');
			$this->template->slice('users/manage/report',array('employees'=>$employees,'links'=>$links,'count'=>$offset,'branches'=>$branches,'sel_branch'=>$branch_ID));
			$this->template->slice('dms/modals/more_details');
			$this->template->other_script('users/user_show');
			$this->template->render();
		}
	#-----------------------------------------------------------	

		#date : 06-06-2014
		#purpose : update user data
		public function update($user_id = NULL){
			//echo $this->session->userdata('user_desig');die;
			#get user data
			if(!$user_id){redirect('users/report');}
			$user = $this->db->get_where('users',array('id'=>$user_id))->row_array();
			if(!$user){redirect('users/report');}
			$this->form_validation->set_rules('fname','lang:first name','required|trim|xss_clean');
			$this->form_validation->set_rules('lname','lang:last name','trim|xss_clean');
			$this->form_validation->set_rules('landline','lang:land line','trim|xss_clean');
			$this->form_validation->set_rules('mobile','lang:mobile','required|trim|xss_clean|is_natural|exact_length[10]|is_edit_unique[users.mobile]');
			$this->form_validation->set_rules('address','lang:address','trim|xss_clean');
			$this->form_validation->set_rules('dob','lang:date of borth','trim|is_date|xss_clean');
			$this->form_validation->set_rules('email','lang:email','valid_email|trim|xss_clean');
			$this->form_validation->set_rules('username','lang:username','alpha_numeric|min_length[6]|trim|max_length[64]|xss_clean|is_edit_unique[users.username]');
			$this->form_validation->set_rules('password','lang:password','special_char|min_length[6]|max_length[16]|trim|xss_clean');
			$this->form_validation->set_rules('gender','lang:gender','trim');
			$this->form_validation->set_rules('age','lang:age','trim|xss_clean|is_natural');
			$this->form_validation->set_rules('religion','lang:religion','trim|xss_clean');
			$this->form_validation->set_rules('family_details','lang:family-details','trim|xss_clean');		
			$this->form_validation->set_rules('qualification','lang:qualification','trim|xss_clean');
			$this->form_validation->set_rules('experience','lang:experience','trim|xss_clean');
			$this->form_validation->set_rules('marital_status','lang:marital_status','required');
			$this->form_validation->set_rules('date_of_marriage','lang:date-of-marriage','is_date|trim|xss_clean');
			$this->form_validation->set_rules('target','lang:target','xss_clean|trim');
			if($user_id >0){
				$this->form_validation->set_rules('branch_id','lang:branch-name','required');
				$this->form_validation->set_rules('department_id','lang:department','trim|required');
				$this->form_validation->set_rules('designation_id','lang:designation','trim|required');
				$this->form_validation->set_rules('date_of_join','lang:date-of-join','required|is_date');
			}

			if($this->form_validation->run('users/update') == true){

				$file_upload_error = true; #dummy set

				if($_FILES['photo']['name'] != ''){

					
					$ext = pathinfo($_FILES['photo']['name'], PATHINFO_EXTENSION);

					#file name initialization
					$max_id = $this->user->get_max_id();
					$f_part1 = $max_id+1;
					$f_part2 = $f_part1."user".date('YmdHis');
					$fileName = $f_part2.".".$ext;

					#file uploading 
					$config['upload_path'] =  FCPATH.'assets/images/photos/';
					$config['allowed_types'] = 'jpeg|jpg|png';
					$config['max_size']	= '600';
					$config['max_width']  = '2560';
					$config['max_height']  = '1600';
					$config['file_name'] = $fileName;
					$this->load->library('Upload');
					$this->upload->initialize($config);

					if($this->upload->do_upload('photo')){

							$file_upload_error = TRUE;
							$config['image_library'] = 'gd2';
							$config['source_image']	= $config['upload_path'].$fileName;
							$config['create_thumb'] = TRUE;
							$config['maintain_ratio'] = false;
							$config['width']	= 150;
							$config['height']	= 120;

							$this->load->library('Image_lib', $config); 

							$this->image_lib->resize();

							#unlink original file & rename thumb
							unlink($config['upload_path'].$fileName);
							//$var = $this->image->get_parts($file_name);

							$thumb = $config['upload_path'].$f_part2.'_thumb'.'.'.$ext;

							$original = $config['upload_path'].$fileName;

							rename($thumb,$original);
					}
					else{
						$file_upload_error = false;
					}

				}

				if(!$file_upload_error){
					$this->message->set($this->lang->line('invalid-photo'),'e');
				}else{
					$data = $this->input->post(NULL,TRUE);
					if(!empty($fileName)){
						$data['photo'] = $fileName;

						 if((strtolower($user['photo']) !='male.jpg') && (strtolower($user['photo']) != 'female.jpg')){

						 	unlink(FCPATH.'assets/images/photos/'.$user['photo']);
						 }
					}
					//echo '<pre>';print_r($data);die;
					//echo '<hr>';

					//$data['dob'] = date('Y-m-d',strtotime($data['dob']));
					$data['date_of_join'] = date('Y-m-d',strtotime($data['date_of_join']));
					$data['dob'] = ($data['dob'] != '')?date('Y-m-d',strtotime($data['dob'])):'';
					$data['date_of_marriage'] = ($data['date_of_marriage'] != '')?date('Y-m-d',strtotime($data['date_of_marriage'])):'';
					if($data['password'] != ''){
						
						$data['password'] = password_hash($data['password'],PASSWORD_DEFAULT);
					}
					else{
						unset($data['password']);
					}

					#user details update
					if($this->db->update('users',$data,array('id'=>$user_id))){
						//echo $this->db->last_query();die;

						$this->message->set($this->lang->line('user-updated'));
					}
					else{
						$this->message->set($this->lang->line('user-not-updated'));
					}
					redirect('users/report');

				}

			}
			
			#date formats
			//$user['dob'] = date(CAL_FORMAT,strtotime($user['dob']));
			if($user['dob'] == "0000-00-00" || $user['dob'] == "1970-01-01"){
				$user['dob'] = '';
			}else{
				$user['dob'] = date(CAL_FORMAT,strtotime($user['dob']));
			}
			$user['date_of_join'] = date(CAL_FORMAT,strtotime($user['date_of_join']));
			if($user['date_of_marriage'] == "0000-00-00" || $user['date_of_marriage'] == "1970-01-01"){
				$user['date_of_marriage'] = '';
			}else{
				$user['date_of_marriage'] = date(CAL_FORMAT,strtotime($user['date_of_marriage']));
			}
			$data['date_of_marriage'] = date(CAL_FORMAT,strtotime($user['date_of_marriage']));
			$data['dob'] = date(CAL_FORMAT,strtotime($user['dob']));


			#get all department listing
			$this->load->model('departments/Department_master_model','dept');
			$depts = $this->dept->listing(); 
			$depts[''] = 'Select a department';
			ksort($depts);

			#dummy designations
			$this->load->model('designations/Designation_master_model','desg');
			if($this->input->post('department_id')){

				$desgs = $this->desg->get_desg_for_dept($this->input->post('department_id'));
			}else{
				$desgs = $this->desg->get_desg_for_dept($user['department_id']);


			}
			$desgs[''] = 'Select a designation';
			ksort($desgs);
			#branches listing
			$this->load->model('branches/Branch_model','branch');
			$branches = $this->branch->listing(array('company_id'=>$this->session->userdata('company_id')));
			$branches[''] = 'Select a branch';
			ksort($branches);

			$this->template->title($this->lang->line('update-employee'));
			$this->template->main_heading($this->lang->line('update-employee'));
			$this->template->breadcrumb(array($this->lang->line('employees')=>'users/add',$this->lang->line('update')=>'no_link',$this->lang->line('report')=>'users/report'));

			$this->template->slice('dms/message');
			$this->template->slice('users/update/update',array('user'=>$user,'depts'=>$depts,'branches'=>$branches,'desgs'=>$desgs,'user_id'=>$user_id));
			$this->template->render();
		}

	#-----------------------------------------------------------	
	

		#date : 14-6-2014
		#use : user view profile
		public function profile()	{
		    
			$this->template->title($this->lang->line('profile-view'));
			$this->template->main_heading($this->lang->line('profile-view'));

			$this->template->breadcrumb(array($this->lang->line('profile-view')=>'no_link',$this->lang->line('update')=>'users/update_profile'));

			
			
			$user_id = $this->session->userdata('id');
			
			$user = $this->db->get_where('users',array('id'=>$user_id))->row_array();
			//$user['dob'] = date(DATE_FORMAT,strtotime($user['dob']));

			#------superadmin/admin dept and designation----------------

			if($this->session->userdata('id') == '-1' || $this->session->userdata('id') == '-2'){
				if($this->session->userdata('id') == '-1'){
					$desg['designation_name'] = 'Super Admin';
					$dept['department_name'] = 'Super Administration';
				}
				else{
					$desg['designation_name'] = 'Admin';
					$dept['department_name'] = 'Adminisitrator';
				} 
			}
			#------------------------------------------------------
			else{

				$desg = $this->db->select(array('id','department_id','designation_name'))->get_where('designation_master',array('id'=>$user['designation_id']))->row_array();			

				#get department details
				$dept = $this->db->select(array('id','department_name'))->get_where('department_master',array('id'=>$desg['department_id']))->row_array();

			}
			#get designation details			

			#date of join
			$user['date_of_join'] = cdateFormat($user['date_of_join']);
			if($user['dob'] == "0000-00-00" || $user['dob'] == "1970-01-01"){
				$user['dob'] = '';
			}else{
				$user['dob'] = dateFormat($user['dob']);
			}
			$user['date_of_join'] = dateFormat($user['date_of_join']);
			if($user['date_of_marriage'] == "0000-00-00" || $user['date_of_marriage'] == "1970-01-01"){
				$user['date_of_marriage'] = '';
			}else{
				$user['date_of_marriage'] = dateFormat($user['date_of_marriage']);
			}
			if($user['age'] == 0){
				$user['age'] = '';
			}
			$this->template->slice('dms/message');
			$this->template->slice('users/profile/profile',array('user'=>$user,'desg'=>$desg,'dept'=>$dept));
			$this->template->render();						
		}
	#-----------------------------------------------------------	

		#date : 21-7-2014
		#purpose : remove username cookie
		public function login_as_new(){
			setcookie("dms110rlnt14", "", time()-3600);
			#unset($_COOKIE['dms110rlnt14']);
			redirect('users/login');
		}

	#-----------------------------------------------------------
		public function update_profile(){
			#get user details 
			$user_id = $this->session->userdata('id');
			$user = $this->db->select()->get_where('users',array('id'=>$user_id))->row_array();
			$user['date_of_join'] = cdateFormat($user['date_of_join']);
			if($user['dob'] == "0000-00-00" || $user['dob'] == "1970-01-01"){
				$user['dob'] = '';
			}else{
				$user['dob'] = dateFormat($user['dob']);
			}
			$user['date_of_join'] = dateFormat($user['date_of_join']);
			if($user['date_of_marriage'] == "0000-00-00" || $user['date_of_marriage'] == "1970-01-01"){
				$user['date_of_marriage'] = '';
			}else{
				$user['date_of_marriage'] = dateFormat($user['date_of_marriage']);
			}
			if($user['age'] == 0){
				$user['age'] = '';
			}
			
			#validation rules
			$this->form_validation->set_rules('fname','lang:first name','required|trim|xss_clean');
			$this->form_validation->set_rules('lname','lang:last name','trim|xss_clean');
			$this->form_validation->set_rules('gender','lang:gender','trim');
			$this->form_validation->set_rules('age','lang:age','trim|xss_clean');
			$this->form_validation->set_rules('religion','lang:religion','trim');
			$this->form_validation->set_rules('dob','lang:date of borth','is_date|xss_clean');
			$this->form_validation->set_rules('marital_status','lang:marital_status','required');
			$this->form_validation->set_rules('date_of_marriage','lang:date-of-marriage','is_date|trim|xss_clean');
			$this->form_validation->set_rules('landline','lang:land line','trim|xss_clean');
			$this->form_validation->set_rules('mobile','lang:mobile','trim|xss_clean');
			$this->form_validation->set_rules('family_details','lang:family-details','trim|xss_clean');
			$this->form_validation->set_rules('address','lang:address','trim|xss_clean');
			$this->form_validation->set_rules('email','lang:email','valid_email|trim|xss_clean');

			if($this->form_validation->run()==TRUE){

				$file_upload_error = true; #dummy set

				if($_FILES['photo']['name'] != ''){

					
					$ext = pathinfo($_FILES['photo']['name'], PATHINFO_EXTENSION);

					#file name initialization
					$max_id = $this->user->get_max_id();
					$f_part1 = $max_id+1;
					$f_part2 = $f_part1."user".date('YmdHis');
					$fileName = $f_part2.".".$ext;

					#file uploading 
					$config['upload_path'] =  FCPATH.'assets/images/photos/';
					$config['allowed_types'] = 'jpeg|jpg|png';
					$config['max_size']	= '600';
					$config['max_width']  = '2560';
					$config['max_height']  = '1600';
					$config['file_name'] = $fileName;
					$this->load->library('Upload');
					$this->upload->initialize($config);

					if($this->upload->do_upload('photo')){

							$file_upload_error = TRUE;
							$config['image_library'] = 'gd2';
							$config['source_image']	= $config['upload_path'].$fileName;
							$config['create_thumb'] = TRUE;
							$config['maintain_ratio'] = false;
							$config['width']	= 150;
							$config['height']	= 120;

							$this->load->library('Image_lib', $config); 

							$this->image_lib->resize();

							#unlink original file & rename thumb
							unlink($config['upload_path'].$fileName);
							//$var = $this->image->get_parts($file_name);

							$thumb = $config['upload_path'].$f_part2.'_thumb'.'.'.$ext;

							$original = $config['upload_path'].$fileName;

							rename($thumb,$original);
					}
					else{
						$file_upload_error = false;
					}
				}
				if(!$file_upload_error){
					$this->message->set($this->lang->line('invalid-photo'),'e');
				}else{
					
					$data = $this->input->post(NULL,TRUE);
					if(!empty($fileName)){
						$data['photo'] = $fileName;
						if(!empty($user['photo'])){

							 if((strtolower($user['photo']) !='male.jpg') && (strtolower($user['photo']) != 'female.jpg')){

							 	unlink(FCPATH.'assets/images/photos/'.$user['photo']);
							 }	
						}	
					}
					$data['dob'] = date('Y-m-d',strtotime($data['dob']));
					$data['date_of_marriage'] = date('Y-m-d',strtotime($data['date_of_marriage']));

					#user details update
					if($this->user->my_update('users',$data,array('id'=>$user_id))){
						$this->message->set($this->lang->line('user-profile-updated'),'s');
					}
					else{
						$this->message->set($this->lang->line('user-profile-not-updated'),'e');
					}
					redirect('users/profile');
				}

			}
			$this->template->title('Update Profile');
			$this->template->main_heading($this->lang->line('profile-update'));
			$this->template->breadcrumb(array($this->lang->line('profile-view')=>'users/profile',$this->lang->line('update')=>'no_link'));
			$this->template->slice('dms/message');
			$this->template->slice('users/profile/update_profile',array('user'=>$user));
			$this->template->render();
		}

	#---------------------------------------------------------	

		#date    : 20-02-2015
		#purpose : to add user attendance
		public function add_attendance()
		{
			#----------loading library
			$this->load->library('Leaves');

			#----------loading models
			$this->load->model('employees/Staff_leave_model','leave');
			$this->load->model('designations/Designation_master_model','desig');

			$date = "";$users = array();

			if($this->uri->segment(3) && $this->uri->segment(3) == 'date')
			{
				$date = date('Y-m-d',strtotime($this->uri->segment(4)));
				if(!$this->form_validation->valid_date($date))
				{
					redirect('users/logout');
				}
			}

			#-------------searching by date
			if(isset($_POST['btn_get']))
			{
				#----------validation
				$this->form_validation->set_rules('date','lang:date','trim|xss_clean|valid_date|required');
				if($this->form_validation->run('btn_get') === TRUE)
				{
					$date = date('Y-m-d',strtotime($this->input->post('date',true)));							
				}
			}

			#-------------adding attendance of all staffs
			if(isset($_POST['btn_add']))
			{				
				$date = date('Y-m-d',strtotime($this->input->post('date',true)));							
				$employee_ids = $this->input->post('cname',true);
				if(!empty($employee_ids))
				{
					$i = 0;
					foreach($employee_ids as $key => $user_id)
					{
						if($this->if_exists('employee_attendance',array('user_id'=>$user_id,'date' => $date,'status'=>1)) === false)
						{
							$i++;
							$this->leave->f_save('employee_attendance',array('user_id' => $user_id,'date' => $date,'attend' => 3));
						}
					}
					if($i > 0){
						$this->message->set($this->lang->line('attendance_save_msg'));						
					}
					else{
						$this->message->set($this->lang->line('attendance_not_save_msg'),'i');
					}
				}
				redirect('users/add_attendance/date/'.$date);
			}

			#-------------adding leave
			if(isset($_POST['btn_leave']))
			{
				if(!$this->input->post('lp',true))//leave
				{
					#----------validation
					$this->form_validation->set_rules('leave_type','lang:leave-type','trim|xss_clean|required');
					$this->form_validation->set_rules('daytime','lang:leave-type','trim|xss_clean|required');
					if($this->form_validation->run('btn_get') === TRUE)
					{
						$date = date('Y-m-d',strtotime($this->input->post('date',true)));

						$data['leave_type'] = $this->input->post('leave_type',true);
						$data['attend'] = $this->input->post('daytime',true);
						$data['leave_reason'] = $this->input->post('reason',true);
						$data['user_id'] = $this->input->post('user',true);
						$data['date'] = $date;
						$designation = $this->input->post('design',true);
						$pre_ltype = $this->input->post('pre_ltype',true);

						$pre_attend = 0;
						if($pre_ltype == $data['leave_type']){
							$pre_attend = $this->input->post('pre_attend',true);
						}

						#--------------default leave types
						$altypes1 = $this->leave->get_default_ltypes();

						#--------------leave balance checking
						$continue = 1;
						if($data['attend'] == 0 && !array_key_exists($data['leave_type'], $altypes1))
						{
							$leave_bal = $this->leaves->total_assigned_leaves($data['user_id'],$date,$data['leave_type']);										
							$leave_bal[$data['leave_type']]['leave_bal'] += $pre_attend;
							if($leave_bal[$data['leave_type']]['leave_bal'] < 1){
								$continue = 0;
							}
						}
						if($continue == 1)
						{
							#----------checking attendance marked/not
							$uattend = $this->leave->get_attended(array('date' => $date,'user_id' => $data['user_id'],'status' => 1));
							if(empty($uattend))
							{  						
								$this->leave->f_save('employee_attendance',$data);
							}
							else
							{						
								$this->leave->my_update('employee_attendance',array('attend'=>$data['attend'],'leave_type'=>$data['leave_type'],'leave_reason'=>$data['leave_reason']),array('id'=>$uattend[0]['id']));
							}
							$this->message->set($this->lang->line('attendance_save_msg'));
						}
						else
						{
							$this->message->set($this->lang->line('attendance-leave-bal-error-msg'),'e');
						}
					}
				}
				else//present
				{
					$date = date('Y-m-d',strtotime($this->input->post('date',true)));
					$user_id = $this->input->post('user',true);

					#----------checking attendance marked/not
					$uattend = $this->leave->get_attended(array('date' => $date,'user_id' => $user_id,'status' => 1));
					if(empty($uattend))
					{  						
						$this->leave->f_save('employee_attendance',array('user_id' => $user_id,'date' => $date,'attend' => 3));
					}
					else
					{						
						$this->leave->my_update('employee_attendance',array('attend' => 3,'leave_type' => '','leave_reason' => ''),array('id' => $uattend[0]['id']));
					}
				}
			}		

			if(!empty($date))
			{
				$users = $this->leave->get_attendance($date);
				if(empty($users))
				{
					$this->message->set($this->lang->line('no-employee-found'),'i');			
				}				
			}

			#----------template
			$this->template->title('Add Employee Attendance');
			$this->template->main_heading($this->lang->line('add attendance'));
			$this->template->breadcrumb(array($this->lang->line('employees')=>'users/report',$this->lang->line('add_attendance')=>'no_link',$this->lang->line('monthly-attendance-report')=>'users/attendance_report',$this->lang->line('leave-taken-report')=>'users/leave_taken'));
			$this->template->slice('dms/message');
			$this->template->append('users/attendance/add_attendance',array('users' => $users,'date' => $date));	
			$this->template->slice('dms/modals/forms/leave_type_modal',array('date' => $date));
			$this->template->slice('dms/modals/message_modal');
			$this->template->other_script('users/user_attendance');
			$this->template->render();
		}		

	#-----------------------------------------------------------

		#date    : 10-03-2015
		#purpose : monthly user attendance report

		public function attendance_report()
		{
			$this->load->library('Leaves');

			$user_array = array();$month = "";
			$year = date('Y');//current year

			#--------------branch details
			$branch_array = array();$branch_status = 0;	
			$branch_id = $this->session->userdata('under_id');		
			if($this->dms->branch_type())
			{
				$branch_status = 1;
				$branch_array = $this->dms->get_branches();
			}

			#--------------validation
			if($branch_status){
				$this->form_validation->set_rules('branch_id','lang:branch','xss_clean|required');
			}
			$this->form_validation->set_rules('year','lang:year','xss_clean|required');
			$this->form_validation->set_rules('month','lang:month','xss_clean|required');
			if($this->form_validation->run() === true)
			{
				if($branch_status){
					$branch_id = $this->input->post('branch_id',true);
				}
				$year = $this->input->post('year',true);
				$month = $this->input->post('month',true);
				$from_date = $year."-".$month."-01";
				$to_date = $year."-".$month."-".cal_days_in_month(CAL_GREGORIAN, $month, $year);

				#-----------users of corresponding branch
				$users = $this->dms->get_data(array('table' => 'users as a','join' => array('table' => 'designation_master as b','on' => 'a.designation_id=b.id'),'columns' => array('a.id',"concat(fname,' ',lname) as sname",'b.designation_name'),'conditions' => array('a.id >' => 0,'a.department_id >' => 0,'a.branch_id' => $branch_id,'a.status' => 1,'b.status' => 1,'a.date_of_join <=' => $to_date)));				
				if(!empty($users))
				{
					foreach($users as $ukey => $uvalue)
					{
						#-------------attendance calculation
						$attendance_array = $this->leaves->attendance_marked($uvalue['id'],$from_date,$to_date);
						$attendance_array['desig'] = $uvalue['designation_name'];
						$attendance_array['sname'] = $uvalue['sname'];
						$user_array[$uvalue['id']] = $attendance_array;
					}					
				}
				else
				{
					$this->message->set($this->lang->line('no-staff-found'),'i');
				}
			}

			#--------------month details
			$years = $this->dms->get_years();
			$years[''] = "Select";
			ksort($years);			

			#--------------month details
			$months = $this->dms->get_default_months();
			$months[''] = "Select";
			ksort($months);

			#------------template
			$this->template->title('Monthly Attendance Report');
			$this->template->main_heading($this->lang->line('monthly-attendance-report'));
			$this->template->breadcrumb(array($this->lang->line('employees')=>'users/report',$this->lang->line('add_attendance')=>'users/add_attendance',$this->lang->line('monthly-attendance-report')=>'no_link',$this->lang->line('leave-taken-report')=>'users/leave_taken'));
			$this->template->slice('dms/message');
			$this->template->slice('users/attendance/attendance_report',array('branch_array' => $branch_array,'branch_status' => $branch_status,'branch_id' => $branch_id,'months' => $months,'years' => $years,'year' => $year,'month' => $month,'user_array' => $user_array));
			$this->template->slice('dms/modals/medium_modal');
			$this->template->other_script('users/attendance_monthly');
			$this->template->render();
		}

	#-----------------------------------------------------------

		#date    : 11-03-2015
		#purpose : yearly attendance report of user - future modification : not needed now...

		public function yearly_attendance_report()
		{
			$this->template->title('Employees attendance report');
			$this->template->main_heading($this->lang->line('yearly-attendance-report'));
			$this->template->breadcrumb(array($this->lang->line('users')=>'users/add',$this->lang->line('monthly-attendance-report')=>'users/attendance_report',$this->lang->line('yearly-attendance-report')=>'no_link'));
			$this->load->model('employees/Staff_leave_model','leave');
			$this->load->model('fiscals/Fiscal_model','fiscal');
			$users = ''; $userType = ''; $attended = ''; $years = ''; $totalmarked = '';

			#set validation rules
			$this->form_validation->set_rules('user_type','users','required');
			$this->form_validation->set_rules('yearselect','year','required');

			$this->template->slice('dms/message');
			$this->template->slice('users/attendance/attendance_report',array('users'=>$users,'usertypes'=>$userType,'attended'=>$attended,'totalm'=>$totalmarked,'years'=>$years));
			$this->template->slice('dms/modals/more_details');
			$this->template->other_script('users/attendance_monthly');
			$this->template->render();
		}

	#-----------------------------------------------------------

		#date    : 12-03-2015
		#purpose : leave taken report

		public function leave_taken()
		{
			#--------------loading library
			$this->load->library('Leaves');

			#--------------loading models
			$this->load->model('employees/Staff_leave_model','leave');

			$user_array = $leave_types = array();
			$year = date('Y');//current year

			#--------------branch details
			$branch_array = array();$branch_status = 0;	
			$branch_id = $this->session->userdata('under_id');		
			if($this->dms->branch_type())
			{
				$branch_status = 1;
				$branch_array = $this->dms->get_branches();
			}

			#--------------validation
			if($branch_status){
				$this->form_validation->set_rules('branch_id','lang:branch','xss_clean|required');
			}
			$this->form_validation->set_rules('year','lang:year','xss_clean|required');			
			if($this->form_validation->run() === true)
			{
				if($branch_status){
					$branch_id = $this->input->post('branch_id',true);
				}
				$year = $this->input->post('year',true);				
			}

			#---------year start and end date
			$from_date = $year."-01-01";
			$to_date = $year."-12-31";

			#-----------users of corresponding branch
			$users = $this->dms->get_data(array('table' => 'users as a','join' => array('table' => 'designation_master as b','on' => 'a.designation_id=b.id'),'columns' => array('a.id',"concat(fname,' ',lname) as sname",'b.designation_name'),'conditions' => array('a.id >' => 0,'a.department_id >' => 0,'a.branch_id' => $branch_id,'a.status' => 1,'b.status' => 1)));
			if(!empty($users))
			{
				$leave_types = $this->leaves->leave_types(0,1);
				$default_leave_types = $this->leave->get_default_ltypes();//default leave types			
				foreach($users as $ukey => $uvalue)
				{
					#-------------leave calculation of non default leave types
					$leave_array = $this->leaves->leave_bal($uvalue['id'],$year);
					$user_array[$uvalue['id']] = array('sname' => $uvalue['sname'],'desig' => $uvalue['designation_name'],'leave_details' => $leave_array);

					#-------------leave calculation of default leave types
					foreach($default_leave_types as $dkey => $dvalue)
					{						
						$leave_taken = $this->leaves->total_leaves_taken($uvalue['id'],$from_date,$to_date,$dkey);	
						$user_array[$uvalue['id']]['leave_details'][$dkey] = array('leave_bal' => "NA",'leaves_taken' => $leave_taken);
					}
				}
			}
			else
			{
				$this->message->set($this->lang->line('no-staff-found'),'i');
			}

			#--------------month details
			$years = $this->dms->get_years();
			$years[''] = "Select";
			ksort($years);			

			#------------template
			$this->template->title('Employee Leave Report');
			$this->template->main_heading($this->lang->line('employee-leave-report'));
			$this->template->breadcrumb(array($this->lang->line('employees')=>'users/report',$this->lang->line('add_attendance')=>'users/add_attendance',$this->lang->line('monthly-attendance-report')=>'users/attendance_report',$this->lang->line('leave-report')=>'no_link'));
			$this->template->slice('dms/message');
			$this->template->slice('users/leave/leave_taken_report',array('branch_array' => $branch_array,'branch_status' => $branch_status,'branch_id' => $branch_id,'years' => $years,'year' => $year,'user_array' => $user_array,'leave_types' => $leave_types));
			$this->template->slice('dms/modals/medium_modal');
			$this->template->other_script('users/attendance_monthly');
			$this->template->render();
		}

	   #-------------------------------------------------------------------------
		public function delete($id){
			$user_id = $id;
			if(empty($user_id)){ redirect('users/report');}
			$user = $this->db->get_where('users',array('id'=>$user_id))->row_array();
			if(!$user){redirect('users/report');}
			$this->load->model('users/User_model','user');
			if($this->user->check_in_delete($id) === true){

				if($this->user->my_update('users',array('status'=>0),array('id'=>$user_id))){
					$this->message->set($this->lang->line('user-deleted'));
	 			}
	 			else{
	 				$this->message->set($this->lang->line('user-not-deleted'));
	 			}
	 		}else{
	 			$this->message->set($this->lang->line('can-not-delete-user'),'w');
	 		}
 			redirect('users/report');
		}
	   #-------------------------------------------------------------------------
	
	}

?>