<?php if( ! defined('BASEPATH')) exit('No direct script access allowed');

class Vat extends MY_Controller
{
	public function __construct()
	{
		parent :: __construct();
		
		#---------------- Checking Financial year is enabled / closed-----------------#
		$method_array = array('update');
		fiscal_status($this->uri->segment(2),$method_array,"vat/index");	
		#---------------- Checking Financial year is enabled / closed-----------------#
		
		$this->template->title('VAT');
		$this->template->main_heading('VAT Settings');	
		$this->load->model('accounts/Vat_model','vat');	
	}
	
	public function index()
	{
		$this->template->breadcrumb(array($this->lang->line('settings') => 'preferences/index',$this->lang->line('accounts') => 'accounts/index',$this->lang->line('vat-settings') => 'no_link',$this->lang->line('set') => 'vat/update'));
		
		$data = $this->vat->get();
		
		$this->template->slice('dms/message');
		$this->template->slice('preferences/vat/report',array('vat_array' => $data));
		$this->template->render();
	}
	
	public function update()
	{
		$data = $this->vat->get();
		foreach($data as $id => $value)
		{
			$this->form_validation->set_rules("vat_percent$value[id]",'lang:vat-settings','xss_clean|numeric|less_or_equal[100]');
		}
		if($this->form_validation->run() == true)
		{
			$i = $count = count($vat_data);			
			$vat_data = $this->input->post(NULL,true);;
			foreach($vat_data as $vat_id => $vat_value)
			{
				$vat_id = substr($vat_id,11);
                               
				$item_vat = $this->vat->get_item_vat($vat_id);
				if($item_vat != $vat_value)
				{
					if(!$this->vat->check_vat($vat_id,$vat_value))
					{			
						if($this->vat->update(array('item_grp_id' => $vat_id,'vat' => $vat_value)))
						{
							$this->message->set($this->lang->line('vat-edit-success'));
							$i--;
						}
					}					
				}
			}
			if($i == $count)
			{
				$this->message->set($this->lang->line('vat-edit-error'),'w');
			}
			redirect('vat/index');
		}
		$vat_array = $this->vat->get();

		#----------template
		$this->template->breadcrumb(array($this->lang->line('settings') => 'preferences/index',$this->lang->line('accounts') => 'accounts/index',$this->lang->line('vat-settings') => 'vat/index',$this->lang->line('set') => 'no_link'));
		$this->template->slice('dms/message');
		$this->template->slice('preferences/vat/report',array('vat_array' => $vat_array,'vat_status' => 1));
		$this->template->render();		
	}
}