<?php if( ! defined('BASEPATH')) exit ('No direct script access allowed');

class Credit_limit_ajax extends MY_Controller{

	var $companyID,$branchID,$createdBY,$fiscal_start_date,$fiscal_end_date;
	#---------------------------------------------------------------------------------------
	
		public function __construct(){
		parent :: __construct();

		$this->companyID = $this->session->userdata('company_id');
		$this->branchID = $this->session->userdata('under_id');
		$this->createdBY = $this->session->userdata('id');
		
		$fiscals = $this->dms->get_fiscal_year();
		$this->fiscal_start_date = $fiscals['start_date'];
		$this->fiscal_end_date = $fiscals['end_date'];
	}

	#---------------------------------------------------------------------------------------
	
	public function get_credit_status(){
		
		$credit_amount = 10;$bgcolor = 'green';$cr_heading = '';
		$user_credits = $this->get_user_ledger();
		$ledgerID = $user_credits['ledger_id'];
		$credit_limit = $user_credits['credit_limit'];
		$credit_balance = ($this->get_credit_amount($ledgerID));

		if($credit_limit > 0 ||(empty($credit_limit) && $credit_balance <0)){
			if(abs($credit_balance) >= $credit_limit ){
				$credit_limit = $credit_balance;
				$bgcolor = 'red';
				$cr_heading = 'Credit Balance';
			}else if($credit_balance > ((abs($credit_limit)/4)*3)){
				$bgcolor='orange';
			}
		}else{
			$credit_limit = $credit_balance;
			$cr_heading = 'Credit Balance';
		}
		echo json_encode(array('credit_amount'=>$credit_limit,'bgcolor'=>$bgcolor,'cr_head'=>$cr_heading));

	}
	
	#---------------------------------------------------------------------------------------	
	
	public function credit_limit(){

		$user_credits = $this->get_user_ledger();
		$ledgerID = $user_credits['ledger_id'];
		$credit_limit = $user_credits['credit_limit'];
		$credit_details = $this->get_credit_amount($ledgerID,1);
		$credit_amount = $credit_details['cr_amount'];
		$credit_balance = $credit_details['balance'];
		if($credit_balance <= $credit_limit){
			$credit_limit_balance = $credit_limit-$credit_balance;
		}
		if($credit_details['opening_amount'] < 0){
			$opening = $credit_details['opening_amount'].' ( Cr )';
		}else{
			$opening = $credit_details['opening_amount'].' ( Dr )';
		}

		echo json_encode(array('cr_limit'=>$credit_limit,'cr_amount'=>($credit_amount),'cr_balance'=>($credit_balance),'opening'=>$opening));
	}
	
	#---------------------------------------------------------------------------------------

	public function get_credit_amount($ledgerID=NULL,$return=NULL){
		
		$user_credits = $this->get_user_ledger();
		$credit_limit = $user_credits['credit_limit'];
		$opening_amount = $this->get_ledger_opening($ledgerID);
		$credit_amount = 0;
		$debit_amount = 0;
		$credit_balance=0;
		$day = date('d')+1;
		$date = date('Y-m-'.$day);
		$this->load->library('Accounts');
		$vouchers = $this->accounts->voucher_bal($ledgerID,$date,2);

		$credit_amount = $vouchers['cr_amount'];
		$debit_amount = $vouchers['dr_amount'];
		$ledgers = $this->db->select(array('sgroup_id','dc'))->get_where('dms_ledgers',array('id'=>$ledgerID))->row_array();

		$this->db->select();
		$this->db->from('dms_vouchers as dv');
		$this->db->join('dms_voucher_against_bills as dvab','dv.table_group_id=dvab.id');
		$this->db->where(array('dv.table_name'=>''));

		if($ledgers['dc'] == 'cr'){
			if($opening_amount < 0){
				$credit_balance = (($debit_amount+abs($opening_amount))-$credit_amount);
			}else{
				$credit_balance = ($debit_amount-($credit_amount+abs($opening_amount)));
			}

		

		}else{
			if($opening_amount < 0){
				$credit_balance = (($credit_amount+abs($opening_amount))-$debit_amount);
			}else { 
				$credit_balance = ($credit_amount-($debit_amount+abs($opening_amount)));
			}
		}


		if($return == NULL){
			return $credit_balance;
		}else{
			return array('opening_amount'=>$opening_amount,'cr_amount'=>$credit_amount,'dr_amount'=>$debit_amount,'balance'=>$credit_balance);
		}
	}

	#---------------------------------------------------------------------------------------
	
	public function get_user_ledger(){
		
		$desigID = $this->dms->get_desig($this->createdBY);
		$ledgerID = 0;$credit_limit=0;
		if($desigID == 3){# AR
			$this->db->select(array('ledger_id','credit_limit'))->from('users as u');
			$this->db->join('retailer_master as rm','u.branch_id=rm.id');
			$this->db->where(array('u.id'=>$this->createdBY));
			$rows = $this->db->get()->row_array();

		}else{# BRANCH
			$this->db->select(array('ledger_id','credit_limit'))->from('users as u');
			$this->db->join('branch_master as bm','u.branch_id=bm.id');
			$this->db->where(array('u.id'=>$this->createdBY));
			$rows = $this->db->get()->row_array();
		}
		if(!empty($rows)){
			$ledgerID = $rows['ledger_id'];
			$credit_limit = $rows['credit_limit'];
		}
		return array('ledger_id'=>$ledgerID,'credit_limit'=>$credit_limit);
	}
	
	#---------------------------------------------------------------------------------------

	public function get_ledger_opening($ledgerID){
		
		$opening_amount=0;
		$rows = $this->db->select('open_amount')->get_where('dms_ledger_open_bals',array('ledger_id'=>$ledgerID))->row_array();
		if(!empty($rows)){
			$opening_amount = $rows['open_amount'];
		}
		return $opening_amount;
	}

	#---------------------------------------------------------------------------------------
}
?>