<?php if ( ! defined('BASEPATH')) exit('No direct script access allowed');
	
	class Json_ajax extends MY_Controller{


	#----------------------------------------------	
		public function __construct(){
			parent :: __construct();
		}

	#---------------------------------------------

		#date : 1-8-2014
		#purpose : get user data by designation
		public function get_user_by_designation(){
			$desg_id = $this->input->get('desg');
			$this->db->select(array('id','fname','lname'))->from('users');
			$rows = $this->db->where(array('designation_id'=>$desg_id,'status'=>1))->get()->result_array();
			echo json_encode($rows);
		}

	#---------------------------------------------	
		
		public function get_user_data(){

			$user_id = $this->input->get('user_id');
			$this->db->select(array('u.*','desg.designation_name','dept.department_name'));
			$this->db->from('users u');
			$this->db->join('designation_master desg','desg.id=u.designation_id','left');
			$this->db->join('department_master dept','dept.id=desg.department_id','left');
			$this->db->where('u.id',$user_id);
			$user = $this->db->get()->row_array();
			$user['date_of_join'] = date(DATE_FORMAT,strtotime($user['date_of_join']));
			echo json_encode($user);
		}

	#------------------------------------------------
		
		#input : department ID
		#output : designations json array
		public function get_designation(){

			$dept = $_GET['dept'];

			$rows = $this->db->get_where('designation_master',array('department_id'=>$dept))->result_array();

			foreach($rows as $row){
				$desgs[$row['id']] = $row['designation_name'];
			}

			if(empty($desgs)){
				$desgs[''] = 'No designation found';
			}
			ksort($desig);
			echo json_encode($desgs);
		}

	#------------------------------------------------	

		public function get_desg_for_dept(){

			$dept = $this->input->get('dept');

			$this->load->model('designations/Designation_master_model','desg');
			$desgs = $this->desg->get_desg_for_dept($dept);
			echo json_encode($desgs);

		}
	#-------------------------------------------------	

		#list all item types - item_type_master - for autocomplete
		public function list_item_types(){

			$conditions = array('company_id'=>$this->dms->company_id());
			$rows = $this->db->get_where('item_type_master',$conditions)->result_array();
			$types = array();
			foreach($rows as $row){
				$types[] = $row['item_type'];
			}
			echo json_encode($types);
		}

	#-------------------------------------------------	

		#list all manufacturer - item_manufacturer_master - for autocomplete
		public function list_manu_name(){

			$conditions = array('company_id'=>$this->dms->company_id());
			$rows = $this->db->get_where('item_manufacturer_master',$conditions)->result_array();
			$manus = array();
                        $manus[]="Select";
			foreach($rows as $row){
				$manus[] = $row['manufacturer_name'];
			}
			echo json_encode($manus);
		}

	#-------------------------------------------------
		public function list_pump_name(){
			$conditions = array('shop_id'=>$this->get_shop_id());
			$rows = $this->db->get_where('fuel_fillings',$conditions)->result_array();
			$pumps = array();
			foreach($rows as $row){
				$pumps[] = $row['pump_name'];
			}
			echo json_encode($manus);

		}
	#-------------------------------------------------	

		#date : 23-6-2014
		#purpose : get all unit list
		public function list_unit_symbol(){

			$this->load->model('products/Unit_model','unit');
			$units = $this->unit->listing();

			echo json_encode($units);
		}
	#--------------------------------------------------	

		#date : 02-07-2014
		#purpose : get unit symbol(not formal name) by ID
		public function get_unit_symbol(){

			$unit_id = $this->input->get('unit');
			$unit = $this->db->get_where('unit_master',array('id'=>$unit_id))->row_array();
			echo json_encode($unit);
		}		
		
		public function get_item_prefix(){

			$type = $this->input->get('type');

			$max = $this->db->select_max('code_id')->from('item_master')->where(array('item_types' => $type))->get()->row_array();
			$it = $max['code_id']+1;
			if($type=='contact' || $type=='solution' || $type=='oframe' || $type=='olens' || $type=='essilor' || $type=='eupgrade')
			{
			    $num_padded = sprintf("%03d", $it);
			}
			else
			{
			    $num_padded = sprintf("%04d", $it);
			}
			
			$pref = $this->db->get_where('item_code_prefix',array('item_type'=>$type))->row_array();
			$prefix = $pref['prefix'];
			
			$newcode = $prefix.$num_padded;
			
			$data['type'] = $type;
			$data['code'] = $newcode;
			
			echo json_encode($data);
		}	
		
		public function get_item_details(){

			$item_id = $this->input->get('item');
			
			$data = $this->db->get_where('item_master',array('id'=>$item_id))->row_array();
            $item_group_id = $data['item_group_id'];
            
			$max = $this->db->select_max('code_id')->from('item_master')->where(array('item_group_id' => $item_group_id))->get()->row_array();
			$it = (int)$max['code_id']+1;
			if($type=='contact' || $type=='solution')
			{
			    $num_padded = sprintf("%03d", $it);
			}
			else
			{
			    $num_padded = sprintf("%04d", $it);
			}
			
			$pref = $this->db->get_where('item_code_prefix',array('item_type'=>$type))->row_array();
			$prefix = $pref['prefix'];
			$newcode = $prefix.$num_padded;
			
			$data['code'] = $newcode;
	
			echo json_encode($data);
		}	
		

		#-------------------------------------------------------
		#date:16-12-2014
		#purpose:get alternate  unit;
		public function get_alternate_unit(){

			$unit_id = $this->input->get('unit_id');
			$this->load->library('Stock');
			$alt_units = $this->stock->get_units($unit_id,1);
			$alt_units[0] = 'Select';
			krsort($alt_units);
			echo json_encode($alt_units);
		}
		#------------------------------------------------------demo
		public function get_icode(){

			$item = $this->input->get('item_code'); 
		    $this->load->model('products/Item_model','item');
			$ars = $this->item->check($item);
			if(!empty($ars))
			{
	            echo json_encode($ars);
			}
			    
		}
		#------------------------------------------------------demo

		#-------------------------------------------------------

		public function get_ar_branch(){

			$under = $_GET['branch'];
			if($under == 'Branch'){			
				
				$this->load->model('branches/Branch_model','branch');
				$branches = $this->branch->listing();
				echo json_encode($branches);
			}
			else{

				$this->load->model('retailers/Counter_model','retailer');
				$ars = $this->retailer->listing();
				echo json_encode($ars);
			}
		}

	#---------------------------------------------------
		public function get_user_type_list(){
			$user_type = $_GET['type'];
			$user_id = $this->session->userdata('id');			
			$this->load->library('Dms');
			if($user_type != 3){
				if($user_id == -1 || $user_id == -2){
					$conditions = array('designation_id' =>$user_type,'users.company_id'=>$this->session->userdata('company_id'));
				}else{
					$branchID = $this->session->userdata('under_id');
					$conditions = array('designation_id' =>$user_type,'branch_id'=>$branchID,'users.company_id'=>$this->session->userdata('company_id'));
				}
				$users = $this->dms->get_users(array('conditions' =>$conditions));
			}
			else{
				$this->db->select(array('rt.id as r_id','rt.retailer_name','u.id'));
				$this->db->from('retailer_master rt');
				$this->db->join('users u','u.branch_id = rt.id');
				$this->db->where(array('u.status'=>1,'u.designation_id'=>$user_type,'u.company_id'=>$this->session->userdata('company_id'),'rt.status'=>1));
				$rows = $this->db->get()->result_array();
				$users = array();
				if(!empty($rows)){
					foreach($rows as $row){				
						$users[$row['id']] = $row['retailer_name'];
					}
				}
				
			}
			echo json_encode($users);
		}
	#---------------------------------------------------
		#date : 26-7-2014
		#purpose : get area json
		public function areas(){
			$areas = $this->db->select('area')->order('area')->get_where('area_master')->result_array();
			echo json_encode($areas);
		}

	#---------------------------------------------------	
		#date : 19-8-2014
		#purpose : get last added area as dropdown option
		function last_added_area_option(){
			$row = $this->db->select()->from('area_master')->order_by('id','DESC')->limit(1,0)->get()->row_array();
			$area[$row['id']] = $row['area'];
			echo json_encode($area);
		}	

	#---------------------------------------------------
		public function area_list(){
			$this->load->model('areas/Area_model','area');
			$areas = $this->area->listing;
			$areas[0] ='Select';
			ksort($areas);
			echo json_encode($areas);


		}	

    #--------------------------------------------------------
		#date:14_08_2014
		#purpose:vehicle
      public function get_under_type_list(){

            $under_type = $_GET['type'];
			$this->load->model('vehicles/Vehicle_model','vehicle');
			$types = $this->vehicle->vehicle_maintenance($under_type);
			echo json_encode($types);
		}
    #-----------------------------------------------------
		#date : 16-9-2014
		#purpose : get area id based area co-ordinates
		function area_cordinates(){
			$row = $this->db->select(array('area','cordinate_x','cordinate_y'))->get_where('area_master',array('id'=>$this->input->get('area_id')))->row_array();
			$this->load->model('graphs/Graph_model','graph');
			$sales = $this->graph->get_area_wise_sales(array('conditions'=>array('sls.branch_id'=>$this->session->userdata('under_id'),'sls.area_id'=>$this->input->get('area_id'))));
			//$sales = $this->db->where(array('area_id'=>$this->input->get('area_id')))->from('sales')->count_all_results();
			$sum = 0;
			if(!empty($sales)){
					foreach ($sales as $key => $sale) {
						$sum = $sum+$sale['vamount'];
					}					
			}
			$row['sales'] = $sum;
			echo json_encode($row);
		}

	#------------------------------------------------------
		#date:6-10-2014
		#purpose:get vehicles insurance basic details
		function get_vehicle_insurance_details(){
		
			$vehicles = $this->db->select(array('insurance_no','insurance_company','insurance_amount'))->get_where('vehicle_master',array('id'=>$this->input->get('vehicle_id')))->row_array();
			echo json_encode($vehicles);
		}
			
	#-------------------------------------------------------
		#date : 1-10-2014
		#purpose : get chat message
		function get_msgs(){

			$user = $this->input->get('user');
			$prev_total = $this->input->get('total')?$this->input->get('total'):0;
			set_time_limit(0);

			$this->db->update('chat_msgs',array('seen_status'=>1),array('m_from'=>$user));
			while( true ){ 
				$sql = "SELECT m.*,uf.photo f_photo,uf.gender,ut.photo m_photo FROM chat_msgs m ";
				$sql .= "INNER JOIN users uf ON m.m_from=uf.id ";
				$sql .= "INNER JOIN users ut ON m.m_to=ut.id ";
				$sql .= "WHERE (m.m_from=".$this->session->userdata('id')." AND m.m_to=".$user.") ";
				$sql .= "OR (m.m_to=".$this->session->userdata('id')." AND m.m_from=".$user.")";
				$total = $this->db->query($sql)->num_rows();
				
				if($total != $prev_total){
					#get user data
					$row = $this->db->select('UPPER(concat(fname," ",lname)) as user')->get_where('users',array('id'=>$user))->row_array();
					$sql = "SELECT m.*,uf.photo f_photo,uf.gender,ut.photo m_photo FROM chat_msgs m ";
					$sql .= "INNER JOIN users uf ON m.m_from=uf.id ";
					$sql .= "INNER JOIN users ut ON m.m_to=ut.id ";
					$sql .= "WHERE (m.m_from=".$this->session->userdata('id')." AND m.m_to=".$user.") ";
					$sql .= "OR (m.m_to=".$this->session->userdata('id')." AND m.m_from=".$user.")";
					$msgs['result'] = $this->db->query($sql)->result_array();
					$msgs['me'] = $this->session->userdata('id');
					$msgs['chat_user'] = $row['user'];
					$this->db->close();
					echo json_encode($msgs);
					break;
				}else{
					sleep(1);
					continue;
				}
			}
		}

	#------------------------------------------------------	

		#date : 1-10-2014
		#purpose : get online users
		function get_online_users(){
			$rows = $this->db->select(array('id','fname','lname'))->get_where('users',array('online_status'=>1,'id!='=>$this->session->userdata('id')))->result_array();
			foreach($rows as $key=>$row){
				$rows[$key]['msg'] = $this->db->where(array('m_from'=>$row['id'],'seen_status'=>0))->from('chat_msgs')->count_all_results();
			}
			echo json_encode($rows);
		}
	#------------------------------------------------------	

		#date : 3-10-2014
		#purpose : get new message counts
		function new_msg_counts(){

			$prev_array = ($this->input->get('counts'))?$this->input->get('counts'):array(0=>0);
			$prev_array = array_sum($prev_array);
			set_time_limit(0);
			$this->db->select(array('count(id) total','m_from'));
			$this->db->from('chat_msgs');
			$this->db->where('m_to',$this->session->userdata('id'));
			$this->db->where('seen_status',0);
			$this->db->group_by('m_from');
			$rows = $this->db->get()->result_array();

			$c_count = array();
			foreach($rows as $row){
				$c_count[$row['m_from']] = $row['total'];
			}

			$latest_count = array_sum($c_count);
			if($latest_count != $prev_array){
				$this->db->close();
				echo json_encode($c_count);
			    return; 
			}else{
				sleep( 1 );
				
			}
		}

	#-------------------------------------------------------
		public function get_unit_for_item(){

			$item_id = $this->input->get('item');
	        $this->load->library('Stock');
	        $units = $this->stock->get_units($item_id);
	        echo json_encode($units);
		}
	#--------------------------------------------------------
		public function get_godown_list(){

			$branch_id = $this->input->get('branch');
			#load godown model and 
			$this->load->model('godown/Godown_model','godown');
			$godowns = $this->godown->listing(array('conditions'=>array('branch_id'=>$branch_id)));
			echo json_encode($godowns);

		}
    #--------------------------------------------------------	
	}
?>