<?php if(!defined('BASEPATH')) exit ('No direct script access allowed');

class Purchase_order_ajax extends MY_Controller{

	#----------------------------------------------------------

	function get_amount(){
		$qty = $this->input->get('qty');
		$rate = $this->input->get('rate');
		$amount = round_this($qty*$rate);
		echo json_encode(array($amount));

	}

	#----------------------------------------------------------

	public function get_item_rate(){

		$itemID = $this->uri->segment(4);
		$this->load->library('Stock');
		$rate = round_this($this->stock->get_purchase_rate($itemID));
		echo $rate;
	}
	
	public function get_item_price(){

		$itemID = $this->input->get('item_id');
		$this->load->library('Stock');
		$price = $this->stock->get_item_price($itemID);
		$mrp = get_rounded($price['rate']);
		$rate = get_rounded($price['rate2']);
		$lcost = $price['landing_cost'];
		echo json_encode(array(0=>$mrp,1=>$rate,2=>$lcost));
	}

	#----------------------------------------------------------

	function get_bill_dis_amt(){

		$discPer = $this->input->get('disc_per');
		$totalNetAmount = $this->input->get('total');

		if($discPer <= 100){
			$discAmount = ($totalNetAmount*$discPer)/100;
		}else{
			$discAmount = ($totalNetAmount*100)/100;
		}
		$discAmount = round_this($discAmount);
		if($discAmount <= $totalNetAmount){
			$gnTotalAmount = $totalNetAmount-$discAmount;
		}else{
			$gnTotalAmount = 0;
		}
		$round_off = numberFormat(round_off($gnTotalAmount));
		$gnTotalAmount = numberFormat(get_rounded($gnTotalAmount));
		echo json_encode(array(0=>$discAmount,1=>$gnTotalAmount,2=>$round_off));
	}

	/*---------------------------------------------------------*/

	function get_bill_dis_per(){

		$discAmt = $this->input->get('disc_amt');
		$totalNetAmount = $this->input->get('total');
		$discPer = 0;
		if($discAmt <= $totalNetAmount){
			$discPer = round_this(($discAmt*100)/$totalNetAmount);
		}
		$gnTotalAmount = $totalNetAmount-$discAmt;
		$round_off = numberFormat(round_off($gnTotalAmount));
		$gnTotalAmount = numberFormat(get_rounded($gnTotalAmount));
		echo json_encode(array(0=>$discPer,1=>$gnTotalAmount,2=>$round_off));
	}

	/*---------------------------------------------------------*/

	public function get_item_unit_rate(){

		$itemID = $this->input->get('item_id');
		$unitID = $this->input->get('unit_id');
		$this->load->library('Stock');
		$primaryUnit = $this->stock->get_primary_unit($itemID)['id'];
		$primaryUnitRate = $this->stock->get_purchase_rate($itemID);
		$rate = $this->stock->convert_unit_rate($itemID,$primaryUnit,$unitID,$primaryUnitRate)['rate'];
		echo json_encode(array($rate));
	}

	/*---------------------------------------------------------*/

}

?>