<?php

class User_attendance_ajax extends MY_Controller {
	
	function get_leave_types(){
		
		$desig_id = $this->input->get('desig');
		$userid = $this->input->get('uid');
		$date = $this->input->get('das');
		$year = date('Y',strtotime($date));
		$this->load->model('employees/Staff_leave_model','leave');
		$this->load->library('Leaves');

		$altypes1 = $this->leave->get_default_ltypes();
		$altypes2 = $this->leaves->leave_bal($userid,$year,1);		
		if(!empty($altypes2)) { $altypes = $altypes1+$altypes2; } else { $altypes = $altypes1; }

		$uattend = $this->leave->get_attended(array('date' => $date,'user_id' => $userid,'status' => 1));
		reset($altypes1);
		$ltype = key($altypes1);
		$half_day_am = $half_day_pm = $present = $hide = $reason = "";$full_day = "true";$leave = "checked='checked'";$attend = 0;
		if(!empty($uattend)){
			$ltype = $uattend[0]['leave_type'];

			if(!empty($ltype) && !array_key_exists($ltype, $altypes))
			{
				$altypes[$ltype] = $this->leaves->ltype_name($ltype);
			}

			$reason = $uattend[0]['leave_reason'];			
			if($uattend[0]['attend'] == 1)
			{
				$half_day_am = "true";
				$full_day = "";
				$attend = 0.5;
			}
			elseif($uattend[0]['attend'] == 2)
			{
				$half_day_pm = "true";
				$full_day = "";
				$attend = 0.5;
			}
			elseif($uattend[0]['attend'] == 3)
			{
				$present = "checked='checked'";
				$leave = "";
				$hide = "hide";				
			}
		}		

		$this->load->view('employees/leaves/new_leave_type_form',array('ltypes'=>$altypes,'desig'=>$desig_id,'user'=>$userid,'da_te'=>$date,'ltype' => $ltype,'full_day' => $full_day,'half_day_am' => $half_day_am,'half_day_pm' => $half_day_pm,'leave' => $leave,'present' => $present,'hide' => $hide,'reason' => $reason,'attend' => $attend));
	}	

	#----------------------------------------------------------------------------------------
	function getAttendedById()
	{	
		#-----------loading model
		$this->load->model('employees/Staff_leave_model','leave');

		$userid = $this->input->get('user');
		$year = $this->input->get('year');
		$month = $this->input->get('month');
		$days = cal_days_in_month(CAL_GREGORIAN, $month, $year);
		$start_date = $year."-".$month."-01";
		?>
		<div class="form-group">
			<div class="row">
				<div class="col-md-12">
				    <h1 class="text-bold"><?= date('F',strtotime($start_date)).' '.$year;?></h1>
				    <div class="table-responsive block vr-mincroll">
						<table class="table table-striped table-condensed table-bordered tbl-brdr">	
							<tr>						
							<?php for($i = 1;$i <= $days;$i++)
							{
								$date = $year."-".$month."-".$i;
								$day = date('D',strtotime($date));
								$attend_details = $this->leave->get_attended(array('user_id' => $userid,'date' => $date,'status' => 1));
								if(!empty($attend_details))
								{
									if($attend_details[0]['attend'] == 3)
									{
										?><td><h5><?=$i;?></h5>&nbsp;<?=$day;?>&nbsp;<i class="icon-checkmark3 green" title="Present"></i></td>
										<?php 
									}
									elseif($attend_details[0]['attend'] == 1 || $attend_details[0]['attend'] == 2)
									{
										$leave_type = $this->leave->get_color($attend_details[0]['id']);
										?><td title="<?=$leave_type['type_description'];if($attend_details[0]['attend'] == 1){echo " (AM)";}else{echo " (PM)";}?>"><h5><?=$i;?></h5>&nbsp;<?=$day;?>&nbsp;<i class="icon-checkmark2 green"></i></td>
										<?php 
									}
									else
									{
										$leave_type = $this->leave->get_color($attend_details[0]['id']);
										?>
										<td title="<?=$leave_type['type_description'];?>"><h5><?=$i;?></h5>&nbsp;<?=$day;?>&nbsp;<i class="icon-close red" title="Absent"></i></td>
										<?php
									}
								}
								else
								{
									?><td><h5><?=$i;?></h5>&nbsp;<?=$day;?></td><?php
								}								
								if(in_array($i,array(7,14,21,28))){ echo "</tr><tr>"; }
							}?>
							</tr>
						</table>
					</div>
				</div>
			</div>
		</div>
		<div class="row with-padding">
		<div class="col-md-2">
				<i class="icon-checkmark3 green"></i> <strong>Present</strong>
		</div>
		<div class="col-md-4">
				<i class="icon-checkmark2 green"></i> <strong>Half Day Present</strong>
		</div>
		<div class="col-md-2">
				<i class="icon-close red"></i> <strong>Absent</strong>
		</div>
		</div>				
		<?php

	}
	#----------------------------------------------------------------------------------------
 }
?>