<?php if( ! defined('BASEPATH')) exit('No direct script access allowed');

	class Balance_sheet_excel extends MY_Controller{

		public function __construct(){

			parent ::__construct();
		}
	   #---------------------------------------------------------------------
		public function report(){

			$this->load->library('My_excel');
			$this->load->library('Accounts');
			$from_date = $this->uri->segment(4);
			$to_date = $this->uri->segment(5);
			$liability_array = $asset_array = array();$dc = "";$open_bal_dr = $open_bal_cr = $opening_bal = $total_dr = $total_cr = $profit_loss_dr = $profit_loss_cr = 0;
			if(!empty($from_date) && !empty($to_date))
			{
				$gross_expense = $gross_income = 0;$closed_stock = 0;
				$next_date = date('Y-m-d',(strtotime($to_date)+86400));
				$pre_date = date('Y-m-d',(strtotime($from_date)-86400));
				
				#----------closed details
				$closed = $this->accounts->last_closed_yr($from_date);
				if($closed)
				{
					$open_date = date('Y-m-d',(strtotime($closed['end_date'])+86400));
				}
				else
				{
					$open_date  = $this->accounts->stock_open_date();
				}				

				#-----------liability			
				$account_groups = $this->accounts->get_account_groups(array('columns' => array('id','sub_group','dc'),'or' => "(primary_group_id=7 or primary_group_id=8 or primary_group_id=9 or primary_group_id=11 or primary_group_id=12)"));
				foreach($account_groups as $key => $value)
				{				
					$opening_bal = $this->accounts->opening_bal($value['id'],$from_date,1);												
					$voucher_bal = $this->accounts->voucher_bal($value['id'],$next_date,1);												
					$vamount = ($voucher_bal['cr_amount'] - $voucher_bal['dr_amount']) + $opening_bal;
					if($vamount > 0)
					{					
						$liability_array[$value['id']] = array('group_name' => $value['sub_group'],'vamount' => $vamount);
						$total_cr += $vamount;
					}
					elseif($vamount < 0)					
					{					
						$vamount = -$vamount;
						$total_dr += $vamount;
						$asset_array[$value['id']] = array('group_name' => $value['sub_group'],'vamount' => $vamount);					
					}
				}	
				
				#-----------asset			
				$account_groups = $this->accounts->get_account_groups(array('columns' => array('id','sub_group','dc'),'or' => "(primary_group_id=1 or primary_group_id=2)"));
				foreach($account_groups as $key => $value)
				{									
					if($value['id'] == 16)
					{
						#-----------closed stock
						$closed_voucher_stock_bal = $this->accounts->voucher_bal($value['id'],$to_date,1,$from_date);//stock in hand voucher				
						$closed_stock_bal = $this->accounts->stock_bal_amt($to_date,0,1);//stock in hand stock
						$closed_stock = ($closed_voucher_stock_bal['dr_amount'] - $closed_voucher_stock_bal['cr_amount']) + $closed_stock_bal;
						if($closed_stock > 0)								
						{
							$asset_array[$value['id']] = array('group_name' => $this->lang->line('closings'),'vamount' => $closed_stock);
							$total_dr += $closed_stock;
						}
						elseif($closed_stock < 0)
						{
							$liability_array[$value['id']] = array('group_name' => $this->lang->line('closings'),'vamount' => -$closed_stock);
							$total_cr += (-$closed_stock);
						}
					}
					else
					{
						$opening_bal = $this->accounts->opening_bal($value['id'],$from_date,1);
						$voucher_bal = $this->accounts->voucher_bal($value['id'],$next_date,1);
						$vamount = ($voucher_bal['dr_amount'] - $voucher_bal['cr_amount']) + $opening_bal;
						if($vamount > 0)
						{					
							$asset_array[$value['id']] = array('group_name' => $value['sub_group'],'vamount' => $vamount);
							$total_dr += $vamount;
						}
						elseif($vamount < 0)					
						{					
							$vamount = -$vamount;
							$total_cr += $vamount;
							$liability_array[$value['id']] = array('group_name' => $value['sub_group'],'vamount' => $vamount);					
						}
					}
				}

				#-------------profit & loss A/c			
				$profit_loss = $this->accounts->opening_bal(7,$from_date);//Profit & Loss A/c

				#-----------expense		
				$account_groups = $this->accounts->get_account_groups(array('columns' => array('id','sub_group','dc'),'or' => "(primary_group_id=3 or primary_group_id=4 or primary_group_id=5 or primary_group_id=6)"));
				foreach($account_groups as $key => $value)
				{		
					$opening_bal = $this->accounts->opening_bal($value['id'],$from_date,1);												
					$voucher_bal = $this->accounts->voucher_bal($value['id'],$next_date,1);
					$vamount = ($voucher_bal['dr_amount'] - $voucher_bal['cr_amount']) + $opening_bal;
					$gross_expense += $vamount;							
				}	
				
				#-----------income
				$account_groups = $this->accounts->get_account_groups(array('columns' => array('id','sub_group','dc'),'or' => "(primary_group_id=10 or primary_group_id=13)"));
				foreach($account_groups as $key => $value)
				{	
					$opening_bal = $this->accounts->opening_bal($value['id'],$from_date,1);											
					$voucher_bal = $this->accounts->voucher_bal($value['id'],$next_date,1);
					$vamount = ($voucher_bal['cr_amount'] - $voucher_bal['dr_amount']) + $opening_bal;
					$gross_income += $vamount;							
				}
				
				if($gross_expense != 0 || $gross_income != 0)
				{
					#-----------opening stock
					$gross_expense += $this->accounts->stock_bal_amt($open_date);
					
					#-----------closed stock
					$closed_voucher_stock_bal = $this->accounts->voucher_bal(16,$to_date,1,$open_date);//stock in hand voucher
					$closed_stock_bal = $this->accounts->stock_bal_amt($to_date,0,1);//stock in hand stock		
					$closed_stock = ($closed_voucher_stock_bal['dr_amount'] - $closed_voucher_stock_bal['cr_amount']) + $closed_stock_bal;			
					$gross_income += $closed_stock;
				}
				
				#------------profit & loss calculation
				$profit_loss += ($gross_income - $gross_expense);
				if($profit_loss > 0)
				{
					$profit_loss_cr = $profit_loss;
					$total_cr += $profit_loss_cr;
				}
				elseif($profit_loss < 0)
				{
					$profit_loss_dr = -$profit_loss;
					$total_dr += $profit_loss_dr;
				}

				#-----------total calculation					
				if($total_dr > $total_cr)
				{
					$open_bal_cr = $total_dr - $total_cr;
					$total_cr += $open_bal_cr;
				}
				elseif($total_cr > $total_dr)
				{
					$open_bal_dr = $total_cr - $total_dr;
					$total_dr += $open_bal_dr;
				}
				#------------------------excelpart------------------------------------------------------
				$head = "Balance Sheet From : ".dateFormat($from_date). ' To : '.dateFormat($to_date);
				$this->my_excel->set_title($head);
				$this->my_excel->set_headline($head);

				#report head
				$a_start_line = $d_start_line = $this->my_excel->report_head_line();
				//$this->my_excel->merge_cell('C'.$line.':D'.$line);
				$headings = array('A'=>'#','B'=>'Liabilities','C'=>'Amount','D'=>'Assets','E'=>'Amount');
				$head_width = array('B'=>40,'C'=>30,'D'=>40,'E'=>30);
				$this->my_excel->set_report_head($headings,array(),$a_start_line,NULL);
				$this->my_excel->set_cell_width($head_width);
				$this->my_excel->set_bg_color_range(5, 'A' . $a_start_line);
				$a_start_line = $a_start_line +1;
				#----liabilty and amount genaeration
				if(!empty($liability_array))
				{
					foreach($liability_array as $lkey => $lvalue)
					{
						$this->my_excel->set_cell_value('B'.$a_start_line,stringFormat($lvalue['group_name']));
						$this->my_excel->set_cell_value('C'.$a_start_line,$lvalue['vamount']);
						$this->my_excel->number_format('C'.$a_start_line);
						$a_start_line++;
					}
					$a_end_line = $a_start_line;
					if($open_bal_cr > 0)
					{
						$this->my_excel->set_cell_value('B'.$a_start_line,'Diff. in Opening Balances');
						$this->my_excel->set_cell_value('C'.$a_start_line,$open_bal_cr);
						$this->my_excel->number_format('C'.$a_start_line);
						$a_start_line = $a_start_line+1;
						$a_end_line =$a_end_line+1;
					}
					if($profit_loss_cr > 0)
					{
						$this->my_excel->set_cell_value('B'.$a_start_line,'Profit & Loss A/c');
						$this->my_excel->set_cell_value('C'.$a_start_line,$profit_loss_cr);
						$this->my_excel->number_format('C'.$a_start_line);
						$a_end_line =$a_end_line+1;
					}
				}
				#-------assets and amount excel geneartion
				$d_start_line =  $d_start_line+1;
				if(!empty($asset_array))
				{
					foreach($asset_array as $akey => $avalue)
					{
						$this->my_excel->set_cell_value('D'.$d_start_line,stringFormat($avalue['group_name']));
						$this->my_excel->set_cell_value('E'.$d_start_line,$avalue['vamount']);
						$this->my_excel->number_format('E'.$d_start_line);
						$d_start_line++;
					}
					$d_end_line = $d_start_line;
				}
				if($open_bal_dr > 0)
				{
					$this->my_excel->set_cell_value('D'.$d_start_line,'Diff. in Opening Balances');
					$this->my_excel->set_cell_value('E'.$d_start_line,$open_bal_dr);
					$this->my_excel->number_format('E'.$d_start_line);
					$d_start_line = $d_start_line+1;
					$d_end_line =$d_end_line+1;
				}
				if($profit_loss_dr > 0)
				{
					$this->my_excel->set_cell_value('D'.$d_start_line,'Profit & Loss A/c');
					$this->my_excel->set_cell_value('E'.$d_start_line,$profit_loss_dr);
					$this->my_excel->number_format('E'.$d_start_line);
					$d_end_line =$d_end_line+1;
				}
				//echo $a_end_line.'&&'.$d_end_line;die;
				if($a_end_line >= $d_end_line){
					$next_line = $a_end_line;
				}
				else{
					$next_line = $d_end_line;
				}
				#------total---------
				$this->my_excel->set_cell_value('B'.$next_line,'Total');
				$this->my_excel->set_cell_value('C'.$next_line,$total_cr);
				$this->my_excel->set_cell_value('D'.$next_line,'Total');
				$this->my_excel->set_cell_value('E'.$next_line,$total_dr);
				$this->my_excel->number_format('C'.$next_line);
				$this->my_excel->number_format('E'.$next_line);
				$this->my_excel->set_bold('A'.$next_line.':E'.$next_line);
				$this->my_excel->set_border('A4:E'.$next_line);
				$this->my_excel->output_excel();
			}
			else{
				echo "<script>alert('".$this->lang->line('invalid-balance-sheet')."');window.close();</script>";
			}
		}
	   #---------------------------------------------------------------------
	}
?>