<?php if(!defined('BASEPATH')) exit ('No direct script access allowed');

class Booking_excel extends MY_Controller{

	public function __construct(){

		parent ::__construct();
		$this->load->library('My_excel');
    }

	public function sales()
	{
		$this->load->model('booking/Booking_model','sales_obj');
		$this->load->library(array('Stock'));
		$vtype_id = 28;
		$like_array = array();

		#----------dates within financial year
		$cur_date = date('Y-m-d');
		$from_date = $cur_date;
		$to_date = $cur_date;
		$cur_fiscal_yr = $this->dms->get_fiscal_year();
		if($from_date < $cur_fiscal_yr['start_date'] || $from_date > $cur_fiscal_yr['end_date'] || $to_date < $cur_fiscal_yr['start_date'] || $to_date > $cur_fiscal_yr['end_date'])
		{
			$from_date = $cur_fiscal_yr['end_date'];
			$to_date = $cur_fiscal_yr['end_date'];
		}
		$presumptive_tax = $this->stock->get_tax_type();
		#----------uri array
		$uri_array = $this->uri->uri_to_assoc(4);

		if(isset($uri_array['vt']))
		{
			$vtype_id = $uri_array['vt'];
		}
		$conditions['vtype_id'] = $vtype_id;
		$conditions['status'] = 1;
		if(isset($uri_array['fdate']) && isset($uri_array['tdate']))
		{
			$from_date = date('Y-m-d',strtotime($uri_array['fdate']));
			$to_date = date('Y-m-d',strtotime($uri_array['tdate']));
		}

		#----------between condition
		$between = "bill_date between '$from_date' and '$to_date'";

		$sales_array = $this->sales_obj->get_bills(array('conditions'=>$conditions,'between' => $between,'order_by'=>'bill_date','order'=>'ASC'));
		if(!empty($sales_array))
		{
			#---------------------------------
			$head = "Booking Report From ".dateFormat($from_date)." To ".dateFormat($to_date);
			$this->my_excel->set_title($head);
			$this->my_excel->set_headline($head,'A','J');
			$line = $this->my_excel->report_head_line();
			$this->my_excel->set_font_size('A'.$line.':J'.$line,12);
			$this->my_excel->set_bold('A'.$line.':J'.$line);
			$this->my_excel->set_column_width('A',10);
			$this->my_excel->set_cell_value('A'.$line,'#');
			$this->my_excel->set_column_width('B',15);
			$this->my_excel->set_cell_value('B'.$line,'Date');
			$this->my_excel->set_column_width('C',15);
			$this->my_excel->set_cell_value('C'.$line,'Order No.');			
			$this->my_excel->set_column_width('D',35);
			$this->my_excel->set_cell_value('D'.$line,'Customer');			
			$this->my_excel->set_column_width('E',15);
			$this->my_excel->set_cell_value('E'.$line,'Delivery Date');
			$this->my_excel->set_column_width('F',20);
			$this->my_excel->set_cell_value('F'.$line,'Payment Mode');
			$this->my_excel->set_column_width('G',20);			
			$this->my_excel->set_cell_value('G'.$line,'Net Amt.');
			$this->my_excel->set_column_width('H',20);			
			$this->my_excel->set_cell_value('H'.$line,'Paid Amt.');
			$this->my_excel->set_column_width('I',20);			
			$this->my_excel->set_cell_value('I'.$line,'Balance Amt.');
			$this->my_excel->set_column_width('J',20);			
			$this->my_excel->set_cell_value('J'.$line,'SalesMan Name');
			//$this->my_excel->set_bg_color_range('A'.$line,9);
			$this->my_excel->set_bg_color_range(9, 'A' . $line);
			$this->my_excel->set_font_size('A'.$line.':'.'J'.$line,12);
			$this->my_excel->set_bold('A'.$line.':'.'J'.$line);
			$this->my_excel->set_data_align('A'.$line.':'.'J'.$line,NULL);
			#------------------------------------------------------
			$line = $line+1;
			$i=0;$total_value =0; $total_paid=0;$total_balance=0;
			foreach($sales_array as $key => $value)
			{
				#--------------- finding total------------------------
				$bill_prefix = $this->stock->get_voucher_prefix($value['vtype_id']);
				$total_amount = 0; $total_tax_amount = 0; $presum_amount = 0; $total_cess_amount=0;

   				$item_details = $this->sales_obj->get_sales_items(array('columns' => array('item_id','qty','rate','amount','taxable_amt','discount_amt','vat','vat_amt','cess_amt'),'conditions' => array('group_id' => $value['group_id'],'status' => 1,'item_status >' => 0)));

				foreach($item_details as $item_key => $item_value):
					$tax_amount = 0;
					$net_value = ($item_value['amount']-$item_value['discount_amt']);
					$taxable = $item_value['taxable_amt'];
					
   					$vat = $item_value['vat'];
				   	$vatAmt = $item_value['vat_amt'];
				   	$cessAmt = $item_value['cess_amt'];
				   	
				   	$tax_amount = $vatAmt;
					$total_tax_amount += $tax_amount;
					$total_cess_amount += $cessAmt;
					$total_amount += $taxable;
				endforeach;
				$total_amount += $total_tax_amount+$total_cess_amount;
				$total_amount += (($value['bill_freight']+$value['other_expense']));
				$total_paid += $value['paid_amount'];
				$total_balance += $value['balance_amount'];
				
				#------------------------------------------

				$this->my_excel->set_border('A'.$line.':'.'I'.$line);
				$i++;
				$this->my_excel->set_data_align('A'.$line,NULL);
				$this->my_excel->set_cell_value('A'.$line,$i);
				$this->my_excel->set_data_align('B'.$line,NULL);
				$date = dateFormat($value['bill_date']);
				$this->my_excel->set_cell_value('B'.$line,$date);
				$this->my_excel->set_data_align('C'.$line,'L');
				$this->my_excel->set_cell_value('C'.$line,$bill_prefix.' '.$value['bill_no']);				
				$customer_name=$this->stock->get_customer($value['customer_type_id'],$value['customer_id']);
				$this->my_excel->set_cell_value('D'.$line,$customer_name);
				$delivery_date = dateFormat($value['delivery_date']); 
				$this->my_excel->set_cell_value('E'.$line,$delivery_date);
				$payment_mode=$this->stock->ledger_name($value['payment_mode']);
				$this->my_excel->set_cell_value('F'.$line,$payment_mode);
				$total_amount = get_rounded($total_amount);
				$total_value += $total_amount;
				$this->my_excel->number_format('G'.$line);
				$this->my_excel->set_cell_value('G'.$line,$total_amount);
				$this->my_excel->number_format('H'.$line);
				$this->my_excel->set_cell_value('H'.$line,$value['paid_amount']);
				$this->my_excel->number_format('I'.$line);
				$this->my_excel->set_cell_value('I'.$line,$value['balance_amount']);
				$sales_man=$this->sales_obj->get_user($value['user_id']);
				$this->my_excel->set_cell_value('J'.$line,$sales_man);
				$line++;
			}

			$this->my_excel->set_bold('A'.$line.':J'.$line);
			$this->my_excel->set_border('A'.$line.':'.'J'.$line);
			$this->my_excel->merge_cell('A'.$line.':'.'F'.$line);
			$this->my_excel->set_cell_value('A'.$line,'Total');
			$this->my_excel->set_data_align('A'.$line,'R');
			$this->my_excel->set_cell_value('G'.$line,$total_value);
			$this->my_excel->number_format('G'.$line);
			$this->my_excel->set_cell_value('H'.$line,$total_paid);
			$this->my_excel->number_format('H'.$line);
			$this->my_excel->set_cell_value('I'.$line,$total_balance);
			$this->my_excel->number_format('I'.$line);
			$this->my_excel->output_excel();
		}
	}
	#---------------------------------------------sales1-----------------------------------------------------------------------
	#---------------------------------------------not deliverd ----------------------------------------------------------------not_deliverd
	public function not_deliverd()
	{
		$this->load->model('booking/Booking_model','sales_obj');
		$this->load->library(array('Stock'));
		$vtype_id = 28;
		$like_array = array();

		#----------dates within financial year
		$cur_date = date('Y-m-d');
		$from_date = $cur_date;
		$to_date = $cur_date;
		$cur_fiscal_yr = $this->dms->get_fiscal_year();
		if($from_date < $cur_fiscal_yr['start_date'] || $from_date > $cur_fiscal_yr['end_date'] || $to_date < $cur_fiscal_yr['start_date'] || $to_date > $cur_fiscal_yr['end_date'])
		{
			$from_date = $cur_fiscal_yr['end_date'];
			$to_date = $cur_fiscal_yr['end_date'];
		}
		$presumptive_tax = $this->stock->get_tax_type();
		#----------uri array
		$uri_array = $this->uri->uri_to_assoc(4);

		if(isset($uri_array['vt']))
		{
			$vtype_id = $uri_array['vt'];
		}
		$conditions['vtype_id'] = $vtype_id;
		$conditions['status'] = 1;
		$conditions['book_status'] = '0';
		if(isset($uri_array['fdate']) && isset($uri_array['tdate']))
		{
			$from_date = date('Y-m-d',strtotime($uri_array['fdate']));
			$to_date = date('Y-m-d',strtotime($uri_array['tdate']));
		}

		#----------between condition
		$between = "bill_date between '$from_date' and '$to_date'";

		$sales_array = $this->sales_obj->get_bills(array('conditions'=>$conditions,'between' => $between,'order_by'=>'bill_date','order'=>'ASC'));
		if(!empty($sales_array))
		{
			#---------------------------------
			$head = "Booking Report From ".dateFormat($from_date)." To ".dateFormat($to_date);
			$this->my_excel->set_title($head);
			$this->my_excel->set_headline($head,'A','J');
			$line = $this->my_excel->report_head_line();
			$this->my_excel->set_font_size('A'.$line.':J'.$line,12);
			$this->my_excel->set_bold('A'.$line.':J'.$line);
			$this->my_excel->set_column_width('A',10);
			$this->my_excel->set_cell_value('A'.$line,'#');
			$this->my_excel->set_column_width('B',15);
			$this->my_excel->set_cell_value('B'.$line,'Date');
			$this->my_excel->set_column_width('C',15);
			$this->my_excel->set_cell_value('C'.$line,'Order No.');			
			$this->my_excel->set_column_width('D',35);
			$this->my_excel->set_cell_value('D'.$line,'Customer');			
			$this->my_excel->set_column_width('E',15);
			$this->my_excel->set_cell_value('E'.$line,'Delivery Date');
			$this->my_excel->set_column_width('F',20);
			$this->my_excel->set_cell_value('F'.$line,'Payment Mode');
			$this->my_excel->set_column_width('G',20);			
			$this->my_excel->set_cell_value('G'.$line,'Net Amt.');
			$this->my_excel->set_column_width('H',20);			
			$this->my_excel->set_cell_value('H'.$line,'Paid Amt.');
			$this->my_excel->set_column_width('I',20);			
			$this->my_excel->set_cell_value('I'.$line,'Balance Amt.');
			$this->my_excel->set_column_width('J',20);			
			$this->my_excel->set_cell_value('J'.$line,'SalesMan Name');
			//$this->my_excel->set_bg_color_range('A'.$line,9);
			$this->my_excel->set_bg_color_range(9, 'A' . $line);
			$this->my_excel->set_font_size('A'.$line.':'.'J'.$line,12);
			$this->my_excel->set_bold('A'.$line.':'.'J'.$line);
			$this->my_excel->set_data_align('A'.$line.':'.'J'.$line,NULL);
			#------------------------------------------------------
			$line = $line+1;
			$i=0;$total_value =0; $total_paid=0;$total_balance=0;
			foreach($sales_array as $key => $value)
			{
				#--------------- finding total------------------------
				$bill_prefix = $this->stock->get_voucher_prefix($value['vtype_id']);
				$total_amount = 0; $total_tax_amount = 0; $presum_amount = 0; $total_cess_amount=0;

   				$item_details = $this->sales_obj->get_sales_items(array('columns' => array('item_id','qty','rate','amount','taxable_amt','discount_amt','vat','vat_amt','cess_amt'),'conditions' => array('group_id' => $value['group_id'],'status' => 1,'item_status >' => 0)));

				foreach($item_details as $item_key => $item_value):
					$tax_amount = 0;
					$net_value = ($item_value['amount']-$item_value['discount_amt']);
					$taxable = $item_value['taxable_amt'];
					
   					$vat = $item_value['vat'];
				   	$vaAmt = $item_value['vat_amt'];
				   	$cessAmt = $item_value['cess_amt'];
				   	
				   	$tax_amount = $vaAmt;
					$total_tax_amount += $tax_amount;
					$total_cess_amount += $cessAmt;
					$total_amount += $taxable;
				endforeach;
				$total_amount += $total_tax_amount+$total_cess_amount;
				$total_amount += (($value['bill_freight']+$value['other_expense']));
				$total_paid += $value['paid_amount'];
				$total_balance += $value['balance_amount'];
				
				#------------------------------------------

				$this->my_excel->set_border('A'.$line.':'.'I'.$line);
				$i++;
				$this->my_excel->set_data_align('A'.$line,NULL);
				$this->my_excel->set_cell_value('A'.$line,$i);
				$this->my_excel->set_data_align('B'.$line,NULL);
				$date = dateFormat($value['bill_date']);
				$this->my_excel->set_cell_value('B'.$line,$date);
				$this->my_excel->set_data_align('C'.$line,'L');
				$this->my_excel->set_cell_value('C'.$line,$bill_prefix.' '.$value['bill_no']);				
				$customer_name=$this->stock->get_customer($value['customer_type_id'],$value['customer_id']);
				$this->my_excel->set_cell_value('D'.$line,$customer_name);
				$delivery_date = dateFormat($value['delivery_date']); 
				$this->my_excel->set_cell_value('E'.$line,$delivery_date);
				$payment_mode=$this->stock->ledger_name($value['payment_mode']);
				$this->my_excel->set_cell_value('F'.$line,$payment_mode);
				$total_amount = get_rounded($total_amount);
				$total_value += $total_amount;
				$this->my_excel->number_format('G'.$line);
				$this->my_excel->set_cell_value('G'.$line,$total_amount);
				$this->my_excel->number_format('H'.$line);
				$this->my_excel->set_cell_value('H'.$line,$value['paid_amount']);
				$this->my_excel->number_format('I'.$line);
				$this->my_excel->set_cell_value('I'.$line,$value['balance_amount']);
				$sales_man=$this->sales_obj->get_user($value['user_id']);
				$this->my_excel->set_cell_value('J'.$line,$sales_man);
				$line++;
			}

			$this->my_excel->set_bold('A'.$line.':J'.$line);
			$this->my_excel->set_border('A'.$line.':'.'J'.$line);
			$this->my_excel->merge_cell('A'.$line.':'.'F'.$line);
			$this->my_excel->set_cell_value('A'.$line,'Total');
			$this->my_excel->set_data_align('A'.$line,'R');
			$this->my_excel->set_cell_value('G'.$line,$total_value);
			$this->my_excel->number_format('G'.$line);
			$this->my_excel->set_cell_value('H'.$line,$total_paid);
			$this->my_excel->number_format('H'.$line);
			$this->my_excel->set_cell_value('I'.$line,$total_balance);
			$this->my_excel->number_format('I'.$line);
			$this->my_excel->output_excel();
		}
	}
	#----------------------------------------------------------------------------------------------------------------------------
			public function cancelled_deliverd()

		{
		$this->load->model('booking/Booking_model','sales_obj');
		$this->load->library(array('Stock'));
		$vtype_id = 28;
		$like_array = array();

		#----------dates within financial year
		$cur_date = date('Y-m-d');
		$from_date = $cur_date;
		$to_date = $cur_date;
		$cur_fiscal_yr = $this->dms->get_fiscal_year();
		if($from_date < $cur_fiscal_yr['start_date'] || $from_date > $cur_fiscal_yr['end_date'] || $to_date < $cur_fiscal_yr['start_date'] || $to_date > $cur_fiscal_yr['end_date'])
		{
			$from_date = $cur_fiscal_yr['end_date'];
			$to_date = $cur_fiscal_yr['end_date'];
		}
		$presumptive_tax = $this->stock->get_tax_type();
		#----------uri array
		$uri_array = $this->uri->uri_to_assoc(4);

		if(isset($uri_array['vt']))
		{
			$vtype_id = $uri_array['vt'];
		}
		$conditions['vtype_id'] = $vtype_id;
		$conditions['status'] = 2;
		$conditions['book_status'] = '0';
		if(isset($uri_array['fdate']) && isset($uri_array['tdate']))
		{
			$from_date = date('Y-m-d',strtotime($uri_array['fdate']));
			$to_date = date('Y-m-d',strtotime($uri_array['tdate']));
		}

		#----------between condition
		$between = "bill_date between '$from_date' and '$to_date'";

		$sales_array = $this->sales_obj->get_bills(array('conditions'=>$conditions,'between' => $between,'order_by'=>'bill_date','order'=>'ASC'));
		if(!empty($sales_array))
		{
			#---------------------------------
			$head = "Booking Report From ".dateFormat($from_date)." To ".dateFormat($to_date);
			$this->my_excel->set_title($head);
			$this->my_excel->set_headline($head,'A','J');
			$line = $this->my_excel->report_head_line();
			$this->my_excel->set_font_size('A'.$line.':J'.$line,12);
			$this->my_excel->set_bold('A'.$line.':J'.$line);
			$this->my_excel->set_column_width('A',10);
			$this->my_excel->set_cell_value('A'.$line,'#');
			$this->my_excel->set_column_width('B',15);
			$this->my_excel->set_cell_value('B'.$line,'Date');
			$this->my_excel->set_column_width('C',15);
			$this->my_excel->set_cell_value('C'.$line,'Order No.');			
			$this->my_excel->set_column_width('D',35);
			$this->my_excel->set_cell_value('D'.$line,'Customer');			
			$this->my_excel->set_column_width('E',15);
			$this->my_excel->set_cell_value('E'.$line,'Delivery Date');
			$this->my_excel->set_column_width('F',20);
			$this->my_excel->set_cell_value('F'.$line,'Payment Mode');
			$this->my_excel->set_column_width('G',20);			
			$this->my_excel->set_cell_value('G'.$line,'Net Amt.');
			$this->my_excel->set_column_width('H',20);			
			$this->my_excel->set_cell_value('H'.$line,'Paid Amt.');
			$this->my_excel->set_column_width('I',20);			
			$this->my_excel->set_cell_value('I'.$line,'Balance Amt.');
			$this->my_excel->set_column_width('J',20);			
			$this->my_excel->set_cell_value('J'.$line,'SalesMan Name');
			//$this->my_excel->set_bg_color_range('A'.$line,9);
			$this->my_excel->set_bg_color_range(9, 'A' . $line);
			$this->my_excel->set_font_size('A'.$line.':'.'J'.$line,12);
			$this->my_excel->set_bold('A'.$line.':'.'J'.$line);
			$this->my_excel->set_data_align('A'.$line.':'.'J'.$line,NULL);
			#------------------------------------------------------
			$line = $line+1;
			$i=0;$total_value =0; $total_paid=0;$total_balance=0;
			foreach($sales_array as $key => $value)
			{
				#--------------- finding total------------------------
				$bill_prefix = $this->stock->get_voucher_prefix($value['vtype_id']);
				$total_amount = 0; $total_tax_amount = 0; $presum_amount = 0; $total_cess_amount=0;

   				$item_details = $this->sales_obj->get_sales_items(array('columns' => array('item_id','qty','rate','amount','taxable_amt','discount_amt','vat','vat_amt','cess_amt'),'conditions' => array('group_id' => $value['group_id'],'status' => 2,'item_status >' => 0)));

				foreach($item_details as $item_key => $item_value):
					$tax_amount = 0;
					$net_value = ($item_value['amount']-$item_value['discount_amt']);
					$taxable = $item_value['taxable_amt'];
					
   					$vat = $item_value['vat'];
				   	$vatAmt = $item_value['vat_amt'];
				   	$cessAmt = $item_value['cess_amt'];
				   	
				   	$tax_amount = $vatAmt;
					$total_tax_amount += $tax_amount;
					$total_cess_amount += $cessAmt;
					$total_amount += $taxable;
				endforeach;
				$total_amount += $total_tax_amount+$total_cess_amount;
				$total_amount += (($value['bill_freight']+$value['other_expense']));
				$total_paid += $value['paid_amount'];
				$total_balance += $value['balance_amount'];
				
				#------------------------------------------

				$this->my_excel->set_border('A'.$line.':'.'I'.$line);
				$i++;
				$this->my_excel->set_data_align('A'.$line,NULL);
				$this->my_excel->set_cell_value('A'.$line,$i);
				$this->my_excel->set_data_align('B'.$line,NULL);
				$date = dateFormat($value['bill_date']);
				$this->my_excel->set_cell_value('B'.$line,$date);
				$this->my_excel->set_data_align('C'.$line,'L');
				$this->my_excel->set_cell_value('C'.$line,$bill_prefix.' '.$value['bill_no']);				
				$customer_name=$this->stock->get_customer($value['customer_type_id'],$value['customer_id']);
				$this->my_excel->set_cell_value('D'.$line,$customer_name);
				$delivery_date = dateFormat($value['delivery_date']); 
				$this->my_excel->set_cell_value('E'.$line,$delivery_date);
				$payment_mode=$this->stock->ledger_name($value['payment_mode']);
				$this->my_excel->set_cell_value('F'.$line,$payment_mode);
				$total_amount = get_rounded($total_amount);
				$total_value += $total_amount;
				$this->my_excel->number_format('G'.$line);
				$this->my_excel->set_cell_value('G'.$line,$total_amount);
				$this->my_excel->number_format('H'.$line);
				$this->my_excel->set_cell_value('H'.$line,$value['paid_amount']);
				$this->my_excel->number_format('I'.$line);
				$this->my_excel->set_cell_value('I'.$line,$value['balance_amount']);
				$sales_man=$this->sales_obj->get_user($value['user_id']);
				$this->my_excel->set_cell_value('J'.$line,$sales_man);
				$line++;
			}

			$this->my_excel->set_bold('A'.$line.':J'.$line);
			$this->my_excel->set_border('A'.$line.':'.'J'.$line);
			$this->my_excel->merge_cell('A'.$line.':'.'F'.$line);
			$this->my_excel->set_cell_value('A'.$line,'Total');
			$this->my_excel->set_data_align('A'.$line,'R');
			$this->my_excel->set_cell_value('G'.$line,$total_value);
			$this->my_excel->number_format('G'.$line);
			$this->my_excel->set_cell_value('H'.$line,$total_paid);
			$this->my_excel->number_format('H'.$line);
			$this->my_excel->set_cell_value('I'.$line,$total_balance);
			$this->my_excel->number_format('I'.$line);
			$this->my_excel->output_excel();
		}
	}

	#---------------------------------------------------------------------------------------------------------------------------
	public function sales1()
	{
		$this->load->model('booking/Booking_model','sales_obj');
		$this->load->library(array('Stock'));
		$this->load->model('products/Item_model','item');
		$vtype_id = 28;
		$like_array = array();

		#----------dates within financial year
		$cur_date = date('Y-m-d');
		$from_date = $cur_date;
		$to_date = $cur_date;
		$cur_fiscal_yr = $this->dms->get_fiscal_year();
		if($from_date < $cur_fiscal_yr['start_date'] || $from_date > $cur_fiscal_yr['end_date'] || $to_date < $cur_fiscal_yr['start_date'] || $to_date > $cur_fiscal_yr['end_date'])
		{
			$from_date = $cur_fiscal_yr['end_date'];
			$to_date = $cur_fiscal_yr['end_date'];
		}
		$presumptive_tax = $this->stock->get_tax_type();
		#----------uri array
		$uri_array = $this->uri->uri_to_assoc(4);

		if(isset($uri_array['vt']))
		{
			$vtype_id = $uri_array['vt'];
		}
		//$conditions['vtype_id'] = $vtype_id;
		$conditions['status'] = 1;
		if(isset($uri_array['fdate']) && isset($uri_array['tdate']))
		{
			$from_date = date('Y-m-d',strtotime($uri_array['fdate']));
			$to_date = date('Y-m-d',strtotime($uri_array['tdate']));
		}

		#----------between condition
		$between = "bill_date between '$from_date' and '$to_date'";

		$sales_array = $this->sales_obj->get_bills(array('conditions'=>$conditions,'between' => $between,'order_by'=>'bill_date','order'=>'ASC'));
		if(!empty($sales_array))
		{
			#---------------------------------
			$head = "Booking Report From ".dateFormat($from_date)." To ".dateFormat($to_date);
			$this->my_excel->set_title($head);
			$this->my_excel->set_headline($head,'A','H');
			$line = $this->my_excel->report_head_line();
			$this->my_excel->set_font_size('A'.$line.':H'.$line,12);
			$this->my_excel->set_bold('A'.$line.':H'.$line);
			$this->my_excel->set_column_width('A',10);
			$this->my_excel->set_cell_value('A'.$line,'#');
			$this->my_excel->set_column_width('B',15);
			$this->my_excel->set_cell_value('B'.$line,'Date');
			$this->my_excel->set_column_width('C',15);
			$this->my_excel->set_cell_value('C'.$line,'Order No.');			
			$this->my_excel->set_column_width('D',35);
			$this->my_excel->set_cell_value('D'.$line,'Customer');			
			$this->my_excel->set_column_width('E',15);
			
			$this->my_excel->set_cell_value('E'.$line,'item-name');
			$this->my_excel->set_column_width('F',20);
			$this->my_excel->set_cell_value('F'.$line,'vendor');
			$this->my_excel->set_column_width('G',20);			
			$this->my_excel->set_cell_value('G'.$line,'lence-refno');
			$this->my_excel->set_column_width('H',20);			
			$this->my_excel->set_cell_value('H'.$line,'lence-qty');
			/*$this->my_excel->set_column_width('I',20);			
			$this->my_excel->set_cell_value('I'.$line,'Balance Amt.');*/
			//$this->my_excel->set_bg_color_range('A'.$line,9);
			$this->my_excel->set_bg_color_range(9, 'A' . $line);
			$this->my_excel->set_font_size('A'.$line.':'.'H'.$line,12);
			$this->my_excel->set_bold('A'.$line.':'.'H'.$line);
			$this->my_excel->set_data_align('A'.$line.':'.'H'.$line,NULL);
			#------------------------------------------------------
			$line = $line+1;
			$i=0;$total_value =0; $total_paid=0;$total_balance=0;
			foreach($sales_array as $key => $value)
			{
				#--------------- finding total------------------------
				$bill_prefix = $this->stock->get_voucher_prefix($value['vtype_id']);
				$total_amount = 0; $total_tax_amount = 0; $presum_amount = 0; $total_cess_amount=0;

   				$item_details = $this->sales_obj->get_sales_items(array('columns' => array('item_id','qty','rate','amount','taxable_amt','discount_amt','vat','vat_amt','cess_amt','vendor_id','lens_quantity','lens_refno'),'conditions' => array('group_id' => $value['group_id'],'status' => 1,'item_status >' => 0)));

				foreach($item_details as $item_key => $item_value):
					$tax_amount = 0;
					$net_value = ($item_value['amount']-$item_value['discount_amt']);
					$taxable = $item_value['taxable_amt'];
					$item_types = $this->item->get_types($item_value['item_id']);
					$item_type = $item_types['item_types'];
   					$vat = $item_value['vat'];
				   	$vatAmt = $item_value['vat_amt'];
				   	$cessAmt = $item_value['cess_amt'];
				   	
				   	$tax_amount = $vatAmt;
					$total_tax_amount += $tax_amount;
					$total_cess_amount += $cessAmt;
					$total_amount += $taxable;
			
				$total_amount += $total_tax_amount+$total_cess_amount;
				$total_amount += (($value['bill_freight']+$value['other_expense']));
				$total_paid += $value['paid_amount'];
				$total_balance += $value['balance_amount'];
				
				#------------------------------------------
               // if($item_type == 'lens')
               // {
				$this->my_excel->set_border('A'.$line.':'.'H'.$line);
				$i++;
				$this->my_excel->set_data_align('A'.$line,NULL);
				$this->my_excel->set_cell_value('A'.$line,$i);
				$this->my_excel->set_data_align('B'.$line,NULL);
				$date = dateFormat($value['bill_date']);
				$this->my_excel->set_cell_value('B'.$line,$date);
				$this->my_excel->set_data_align('C'.$line,'L');
				$this->my_excel->set_cell_value('C'.$line,$bill_prefix.' '.$value['bill_no']);				
				$customer_name=$this->stock->get_customer($value['customer_type_id'],$value['customer_id']);
				$this->my_excel->set_cell_value('D'.$line,$customer_name);
				$delivery_date = dateFormat($value['delivery_date']); 
				$item_name = $this->item->get_name($item_value['item_id']);
                $item_name = $item_name['item_name'];
                
                $model_no = $this->item->get_model($item_value['item_id']);
                $model_no = $model_no['model_no'];
                
				$this->my_excel->set_cell_value('E'.$line,$item_name.'/'.$model_no);
				$vendor_id = $item_value['vendor_id'];
				$vendor_name = $this->stock->vendor_name($vendor_id);
				if(empty($vendor_name))
				{
				  $vendor_name='';  
				}
				$payment_mode=$this->stock->ledger_name($value['payment_mode']);
				$this->my_excel->set_cell_value('F'.$line,$vendor_name);
				$total_amount = get_rounded($total_amount);
				$total_value += $total_amount;
				$this->my_excel->set_cell_value('G'.$line,$item_value['lens_refno']);
				$this->my_excel->set_cell_value('H'.$line,$item_value['lens_quantity']);
				$line++;
               
				endforeach;
			}

			$this->my_excel->set_bold('A'.$line.':H'.$line);
			$this->my_excel->set_border('A'.$line.':'.'H'.$line);
			$this->my_excel->output_excel();
		}
	}
	
	public function salesbr()
	{
		$this->load->model('booking/Booking_model','sales_obj');
		$this->load->model('branches/Branch_model','branchmod');

		$this->load->library(array('Stock'));
		$vtype_id = 28;
		$like_array = array();

		#----------dates within financial year
		$cur_date = date('Y-m-d');
		$from_date = $cur_date;
		$to_date = $cur_date;
		$cur_fiscal_yr = $this->dms->get_fiscal_year();
		if($from_date < $cur_fiscal_yr['start_date'] || $from_date > $cur_fiscal_yr['end_date'] || $to_date < $cur_fiscal_yr['start_date'] || $to_date > $cur_fiscal_yr['end_date'])
		{
			$from_date = $cur_fiscal_yr['end_date'];
			$to_date = $cur_fiscal_yr['end_date'];
		}
		$presumptive_tax = $this->stock->get_tax_type();
		#----------uri array
		$uri_array = $this->uri->uri_to_assoc(4);
        if(isset($uri_array['br']))
		{
			$branch_id = $uri_array['br'];
		}
		if(isset($uri_array['vt']))
		{
			$vtype_id = $uri_array['vt'];
		}
		if($branch_id!=0)
		{
		$conditions['branch_id'] = $branch_id;
		}
		$conditions['vtype_id'] = $vtype_id;
		$conditions['status'] = 1;
		if(isset($uri_array['fdate']) && isset($uri_array['tdate']))
		{
			$from_date = date('Y-m-d',strtotime($uri_array['fdate']));
			$to_date = date('Y-m-d',strtotime($uri_array['tdate']));
		}

		#----------between condition
		$between = "bill_date between '$from_date' and '$to_date'";

		$sales_array = $this->sales_obj->get_bills_brnch(array('conditions'=>$conditions,'between' => $between,'order_by'=>'bill_date','order'=>'ASC'));
		if(!empty($sales_array))
		{
			#---------------------------------
			if($branch_id!=0)
			{
			$brname=$this->branchmod->get_full_name($branch_id);

			$head = $brname.":"."Booking Report From ".dateFormat($from_date)." To ".dateFormat($to_date);
			}
			else
			{
			   $head = "Booking Report From ".dateFormat($from_date)." To ".dateFormat($to_date);
 
			}
			$this->my_excel->set_title($head);
			$this->my_excel->set_headline($head,'A','I');
			$line = $this->my_excel->report_head_line();
			$this->my_excel->set_font_size('A'.$line.':I'.$line,12);
			$this->my_excel->set_bold('A'.$line.':I'.$line);
			$this->my_excel->set_column_width('A',10);
			$this->my_excel->set_cell_value('A'.$line,'#');
			$this->my_excel->set_column_width('B',15);
			$this->my_excel->set_cell_value('B'.$line,'Date');
			$this->my_excel->set_column_width('C',15);
			$this->my_excel->set_cell_value('C'.$line,'Order No.');			
			$this->my_excel->set_column_width('D',35);
			$this->my_excel->set_cell_value('D'.$line,'Customer');			
			$this->my_excel->set_column_width('E',15);
			$this->my_excel->set_cell_value('E'.$line,'Delivery Date');
			$this->my_excel->set_column_width('F',20);
			$this->my_excel->set_cell_value('F'.$line,'Payment Mode');
			$this->my_excel->set_column_width('G',20);			
			$this->my_excel->set_cell_value('G'.$line,'Net Amt.');
			$this->my_excel->set_column_width('H',20);			
			$this->my_excel->set_cell_value('H'.$line,'Paid Amt.');
			$this->my_excel->set_column_width('I',20);			
			$this->my_excel->set_cell_value('I'.$line,'Balance Amt.');
			//$this->my_excel->set_bg_color_range('A'.$line,9);
			$this->my_excel->set_bg_color_range(9, 'A' . $line);
			$this->my_excel->set_font_size('A'.$line.':'.'I'.$line,12);
			$this->my_excel->set_bold('A'.$line.':'.'I'.$line);
			$this->my_excel->set_data_align('A'.$line.':'.'I'.$line,NULL);
			#------------------------------------------------------
			$line = $line+1;
			$i=0;$total_value =0; $total_paid=0;$total_balance=0;
			foreach($sales_array as $key => $value)
			{
				#--------------- finding total------------------------
				$bill_prefix = $this->stock->get_voucher_prefix($value['vtype_id']);
				$total_amount = 0; $total_tax_amount = 0; $presum_amount = 0; $total_cess_amount=0;

   				$item_details = $this->sales_obj->get_sales_items(array('columns' => array('item_id','qty','rate','amount','taxable_amt','discount_amt','vat','vat_amt','cess_amt'),'conditions' => array('group_id' => $value['group_id'],'status' => 1,'item_status >' => 0)));

				foreach($item_details as $item_key => $item_value):
					$tax_amount = 0;
					$net_value = ($item_value['amount']-$item_value['discount_amt']);
					$taxable = $item_value['taxable_amt'];
					
   					$vat = $item_value['vat'];
				   	$vatAmt = $item_value['vat_amt'];
				   	$cessAmt = $item_value['cess_amt'];
				   	
				   	$tax_amount = $vatAmt;
					$total_tax_amount += $tax_amount;
					$total_cess_amount += $cessAmt;
					$total_amount += $taxable;
				endforeach;
				$total_amount += $total_tax_amount+$total_cess_amount;
				$total_amount += (($value['bill_freight']+$value['other_expense']));
				$total_paid += $value['paid_amount'];
				$total_balance += $value['balance_amount'];
				
				#------------------------------------------

				$this->my_excel->set_border('A'.$line.':'.'I'.$line);
				$i++;
				$this->my_excel->set_data_align('A'.$line,NULL);
				$this->my_excel->set_cell_value('A'.$line,$i);
				$this->my_excel->set_data_align('B'.$line,NULL);
				$date = dateFormat($value['bill_date']);
				$this->my_excel->set_cell_value('B'.$line,$date);
				$this->my_excel->set_data_align('C'.$line,'L');
				$this->my_excel->set_cell_value('C'.$line,$bill_prefix.' '.$value['bill_no']);				
				$customer_name=$this->stock->get_customer($value['customer_type_id'],$value['customer_id']);
				$this->my_excel->set_cell_value('D'.$line,$customer_name);
				$delivery_date = dateFormat($value['delivery_date']); 
				$this->my_excel->set_cell_value('E'.$line,$delivery_date);
				$payment_mode=$this->stock->ledger_name($value['payment_mode']);
				$this->my_excel->set_cell_value('F'.$line,$payment_mode);
				$total_amount = get_rounded($total_amount);
				$total_value += $total_amount;
				$this->my_excel->number_format('G'.$line);
				$this->my_excel->set_cell_value('G'.$line,$total_amount);
				$this->my_excel->number_format('H'.$line);
				$this->my_excel->set_cell_value('H'.$line,$value['paid_amount']);
				$this->my_excel->number_format('I'.$line);
				$this->my_excel->set_cell_value('I'.$line,$value['balance_amount']);
				$line++;
			}

			$this->my_excel->set_bold('A'.$line.':I'.$line);
			$this->my_excel->set_border('A'.$line.':'.'I'.$line);
			$this->my_excel->merge_cell('A'.$line.':'.'F'.$line);
			$this->my_excel->set_cell_value('A'.$line,'Total');
			$this->my_excel->set_data_align('A'.$line,'R');
			$this->my_excel->set_cell_value('G'.$line,$total_value);
			$this->my_excel->number_format('G'.$line);
			$this->my_excel->set_cell_value('H'.$line,$total_paid);
			$this->my_excel->number_format('H'.$line);
			$this->my_excel->set_cell_value('I'.$line,$total_balance);
			$this->my_excel->number_format('I'.$line);
			$this->my_excel->output_excel();
		}
	}
	#----------------------------
}
?>