<?php if(!defined('BASEPATH')) exit ('No direct script access allowed');

class Customer_excel extends MY_Controller{

	public function __construct(){

		parent ::__construct();
		$this->load->library('My_excel');   

	}

	public function customer_data()
	{
		$this->load->model('customers/Customer_master_model','customer');
		$this->load->library(array('Stock'));
		
		$from_date = $to_date = $cur_date = date('Y-m-d');
   	 	$cond = "";
   	 	
		$uri_array = $this->uri->uri_to_assoc(4);
		if(isset($uri_array['bid']))
		{
			$bid = $uri_array['bid'];
			$cond .= " and a.branch_id='$bid'";
		}
		if(isset($uri_array['fdate']))
		{
		    $from_date = $uri_array['fdate'];
		}
		if(isset($uri_array['tdate']))
		{
		    $to_date = $uri_array['tdate'];
		}
		
		$cond .= " and a.bill_date between '$from_date' and '$to_date'";
		
		$customers = $this->db->query("select distinct a.customer_id,a.bill_no,a.bill_date,a.branch_id,b.branch_name,c.fname,c.lname,c.mobile_no,c.address from dms_sales as a join branch_master as b on a.branch_id=b.id join customer_master as c on a.customer_id=c.id where a.status=1 $cond order by a.id desc")->result_array();
   	 	
   	 	if(!empty($customers))
		{
			#---------------------------------
			$head = "Customer Report";
			$this->my_excel->set_title($head);
			$this->my_excel->set_headline($head,'A','G');
			$line = $this->my_excel->report_head_line();
			$this->my_excel->set_font_size('A'.$line.':G'.$line,12);
			$this->my_excel->set_bold('A'.$line.':G'.$line);
			$this->my_excel->set_column_width('A',10);
			$this->my_excel->set_cell_value('A'.$line,'#');
			$this->my_excel->set_column_width('B',30);
			$this->my_excel->set_cell_value('B'.$line,'Customer Name');
			$this->my_excel->set_column_width('C',40);
			$this->my_excel->set_cell_value('C'.$line,'Branch Name');
			$this->my_excel->set_column_width('D',20);
			$this->my_excel->set_cell_value('D'.$line,'Mobile');
			$this->my_excel->set_column_width('E',35);
			$this->my_excel->set_cell_value('E'.$line,'Address');
			$this->my_excel->set_column_width('F',20);
			$this->my_excel->set_cell_value('F'.$line,'Bill No.');
			$this->my_excel->set_column_width('G',25);
			$this->my_excel->set_cell_value('G'.$line,'Bill Date');
			//$this->my_excel->set_bg_color_range('A'.$line,6);
				$this->my_excel->set_bg_color_range(6, 'A' . $line);
			$this->my_excel->set_font_size('A'.$line.':'.'G'.$line,12);
			$this->my_excel->set_bold('A'.$line.':'.'G'.$line);
			$this->my_excel->set_data_align('A'.$line.':'.'G'.$line,NULL);
			#------------------------------------------------------
			$line = $line+1;
			$i=0;
            foreach($customers as $key => $customer)
            {
				$this->my_excel->set_border('A'.$line.':'.'G'.$line);
				$i++;
				$this->my_excel->set_cell_value('A'.$line,$i);
				$this->my_excel->set_cell_value('B'.$line,$customer['fname'].' '.$customer['lname']);
				$this->my_excel->set_cell_value('C'.$line,$customer['branch_name']);
				$this->my_excel->set_cell_value('D'.$line,$customer['mobile_no']);
				$this->my_excel->set_cell_value('E'.$line,$customer['address']);
				$this->my_excel->set_cell_value('F'.$line,$customer['bill_no']);
				$date = dateFormat($customer['bill_date']);
				$this->my_excel->set_cell_value('G'.$line,$date);
				$line++;
			}

			$this->my_excel->output_excel();
		} 
	}
}	