<?php if( ! defined('BASEPATH')) exit('No direct script access allowed');
	
	class Daybook_excel extends MY_Controller{

		public function __construct(){

			parent ::__construct();

		}
	  #---------------------------------------------------
		public function excel_report(){
			$this->load->library('My_excel');
			$this->load->library('Accounts');
			$vtype_id = $this->uri->segment(4);
			$from_date = $this->uri->segment(5);
			$to_date = $this->uri->segment(6);

			if(!empty($from_date) && !empty($to_date) && ($vtype_id >=0)){

				$data_array = array('table' => 'dms_vouchers','columns' => array('group_id','vtype_id','vdate','dr_ledger','cr_ledger','vtype_id','vno','vamount','table_name','table_group_id'),'conditions' => array('branch_id' => $this->session->userdata('under_id'),'status' => 1),'between' => "vdate between '$from_date' and '$to_date'",'order_by' => 'vdate','order' => 'asc');
				if($vtype_id > 0){
					$data_array['conditions']['vtype_id'] = $vtype_id;
				}
				$voucher_array = $this->dms->get_data($data_array);

				//echo '<pre>';print_r($vouchers_array);die;

				#---------------Excel-------------------------------
				$head = "Day Book From : ".dateFormat($from_date). ' To : '.dateFormat($to_date);
				$this->my_excel->set_title($head);
				$this->my_excel->set_headline($head);
				if($vtype_id >0){
					$voucher_name = $this->accounts->voucher_name($vtype_id);
				}
				else{
					$voucher_name = 'All';
				}
				
				$subhead = " Voucher Type : ".$voucher_name;
				$line = $this->my_excel->get_line();
				$line = $line+1;
				$this->my_excel->merge_cell('A'.$line.':G'.$line);
				$this->my_excel->set_cell_value('A'.$line,$subhead);
				$this->my_excel->set_font_size('A'.$line);
				$this->my_excel->set_bold('A'.$line);

				#get start line  line
				$line = $this->my_excel->report_head_line();

				#merging and styling for head
				$next_line = $line+1;
				$this->my_excel->merge_cell('A'.$line.':A'.$next_line);
				$this->my_excel->merge_cell('B'.$line.':B'.$next_line);
				$this->my_excel->merge_cell('C'.$line.':C'.$next_line);
				$this->my_excel->merge_cell('D'.$line.':D'.$next_line);
				$this->my_excel->merge_cell('E'.$line.':E'.$next_line);
				$this->my_excel->set_data_align('A'.$line.':A'.$next_line,"M");
				$this->my_excel->set_data_align('B'.$line.':B'.$next_line,"M");
				$this->my_excel->set_data_align('C'.$line.':C'.$next_line,"M");
				$this->my_excel->set_data_align('D'.$line.':D'.$next_line,"M");
				$this->my_excel->set_data_align('E'.$line.':E'.$next_line,"M");

				#first row head
				$headings = array('A'=>'#','B'=>'Date','C'=>'Particulers','D'=>'Voucher Types','E'=>'Voucher No','F'=>'Debit Amount','G'=>'Credit Amount');
				$head_width = array('B'=>12,'C'=>30,'D'=>30,'E'=>15,'F'=>20,'G'=>20);
				$this->my_excel->set_report_head($headings,array(),$line,NULL);
				$this->my_excel->set_cell_width($head_width);
					$this->my_excel->set_bg_color_range(7, 'A' . $line);

				$line = $line+1;
				#second row width
				$headings = array('F'=>'Inwards Qty','G'=>'Outwards Qty');
				$head_width = array('F'=>20,'G'=>20);
				$this->my_excel->set_report_head($headings,array(),$line,6);
				$this->my_excel->set_cell_width($head_width);
				$this->my_excel->set_bg_color_range(7, 'A' . $line);

				$i=1;
	            $line = $line+1;

	            foreach($voucher_array as $key => $value){
					$dr_amount = $cr_amount = 0;
					
					#-----------total amount of particular vno
					$vamount = $value['vamount'];
					//$vamount = $this->accounts->get_voucher_sum(array('conditions' => array('branch_id' => $this->session->userdata('under_id'),'vtype_id' => $value['vtype_id'],'vno' => $value['vno'],'vdate' => $value['vdate'])));
					
					if($value['vtype_id'] == 2 || $value['vtype_id'] == 3 || $value['vtype_id'] == 5 || $value['vtype_id'] == 8)
					{
						$cr_amount = $vamount;
					}
					else
					{
						$dr_amount = $vamount;		
					}
					$particulars = stringFormat($this->accounts->get_ledger_name($value['dr_ledger']))." To ".stringFormat($this->accounts->get_ledger_name($value['cr_ledger']));

					$this->my_excel->set_cell_value('A'.$line,$i);
					$this->my_excel->set_cell_value('B'.$line,dateFormat($value['vdate']));
					$this->my_excel->set_cell_value('C'.$line,$particulars);
					$this->my_excel->set_cell_value('D'.$line,stringFormat($this->accounts->voucher_name($value['vtype_id'])));
					$this->my_excel->set_cell_value('E'.$line,$value['vno']);
					$this->my_excel->number_format('F'.$line);
					$this->my_excel->number_format('G'.$line);
					$this->my_excel->set_cell_value('F'.$line,$dr_amount);
					$this->my_excel->set_cell_value('G'.$line,$cr_amount);

					#excel styles
					$this->my_excel->set_data_align('A'.$line);
					$this->my_excel->set_data_align('B'.$line);
					$this->my_excel->set_data_align('E'.$line,'L');
					$this->my_excel->set_wrap_text('C'.$line);

					$line++;
					$i++;

				}
				$this->my_excel->set_border('A4:G'.$line);
				$this->my_excel->output_excel();
				
			}else{
				
				echo "<script>alert('".$this->lang->line('invalid-daybook')."');window.close();</script>";
			}
			
		}
	  #---------------------------------------------------
	}
?>