<?php if(!defined('BASEPATH')) exit ('No direct script access allowed');
	
class Leave_taken_excel extends MY_Controller{

	public function __construct(){

		parent ::__construct();
		$this->load->library('My_excel');
	}

	public function leave_taken()
	{
		#--------------loading library
		$this->load->library('Leaves');

		#-----------loading model
		$this->load->model('employees/Staff_leave_model','leave');
		$this->load->model('branches/Branch_model','branch');

		$year = $this->uri->segment(4);
		$branch_id = $this->uri->segment(5);

		#-----------branch name
		$branch_name = $this->branch->get_full_name($branch_id);

		#---------year start and end date
		$from_date = $year."-01-01";
		$to_date = $year."-12-31";

		#-----------users of corresponding branch
		$users = $this->dms->get_data(array('table' => 'users as a','join' => array('table' => 'designation_master as b','on' => 'a.designation_id=b.id'),'columns' => array('a.id',"concat(fname,' ',lname) as sname",'b.designation_name'),'conditions' => array('a.id >' => 0,'a.department_id >' => 0,'a.branch_id' => $branch_id,'a.status' => 1,'b.status' => 1)));
		if(!empty($users))
		{
			$leave_types = $this->leaves->leave_types(0,1);			
			$default_leave_types = $this->leave->get_default_ltypes();//default leave types

			#--------------excel columns
			$head = "Leave Taken Report Of ".$branch_name." for the year ".$year;
			$this->my_excel->set_title($head);
			$this->my_excel->set_headline($head,'A','G');
			$line = $this->my_excel->report_head_line();
			$this->my_excel->set_font_size('A'.$line.':Z'.$line,12);
			$this->my_excel->set_bold('A'.$line.':Z'.$line);
			$this->my_excel->set_data_align('A'.$line.':'.'Z'.$line,NULL);
			$this->my_excel->set_column_width('A',8);
			$this->my_excel->set_cell_value('A'.$line,'#');
			$this->my_excel->set_column_width('B',20);
			$this->my_excel->set_cell_value('B'.$line,'Employees');
			$this->my_excel->set_column_width('C',20);
			$this->my_excel->set_cell_value('C'.$line,'Designation');
			//$this->my_excel->set_bg_color_range('A'.$line,2);
			$this->my_excel->set_bg_color_range(2, 'A' . $line);
			$new_line = $line+1; 
			$this->my_excel->set_bg_color_range(2, 'A' . $new_line);
			//$this->my_excel->set_bg_color_range('A'.$new_line,2);
			$this->my_excel->merge_cell('A'.$line.':A'.$new_line);
			$this->my_excel->set_data_align('A'.$line,"M");
			$this->my_excel->merge_cell('B'.$line.':B'.$new_line);
			$this->my_excel->set_data_align('B'.$line,"M");
			$this->my_excel->merge_cell('C'.$line.':C'.$new_line);
			$this->my_excel->set_data_align('C'.$line,"M");
			$column = "D";$next_column = "F";
			foreach($leave_types as $lkey => $lvalue)
			{				
				$this->my_excel->merge_cell($column.$line.':'.$next_column.$line);
				$this->my_excel->set_column_width($column,10);
				$this->my_excel->set_cell_value($column.$line,$lvalue['leave_type']);
				$this->my_excel->set_bg_color_range($column.$line,0);				
				$line1 = $line+1;
				$this->my_excel->set_data_align($column.$line1,NULL);
				$this->my_excel->set_cell_value($column.$line1,'Max.');
				$this->my_excel->set_bg_color_range($column.$line1,0);
				$this->my_excel->set_bold($column.$line1);
				$column++;
				$this->my_excel->set_data_align($column.$line1,NULL);
				$this->my_excel->set_cell_value($column.$line1,'Taken');
				$this->my_excel->set_bg_color_range($column.$line1,0);
				$this->my_excel->set_bold($column.$line1);
				$column++;
				$this->my_excel->set_data_align($column.$line1,NULL);
				$this->my_excel->set_cell_value($column.$line1,'Bal.');
				$this->my_excel->set_bg_color_range($column.$line1,0);
				$this->my_excel->set_bold($column.$line1);

				$column = $next_column;
				$column++;
				$next_column = $column;
				$next_column++;$next_column++;
			}
			$line++;$i = 0;
			$new_line = $new_line -1;
			foreach($users as $ukey => $uvalue)
			{
				$column = "A";$line++;

				#--------------excel columns
				$this->my_excel->set_cell_value($column.$line,++$i);
				$this->my_excel->set_border('A'.$new_line.':'.$column.$line);
				$column++;
				$this->my_excel->set_cell_value($column.$line,$uvalue['sname']);
				$this->my_excel->set_border('A'.$new_line.':'.$column.$line);
				$column++;
				$this->my_excel->set_cell_value($column.$line,$uvalue['designation_name']);
				$this->my_excel->set_border('A'.$new_line.':'.$column.$line);
				$column++;

				#-------------leave calculation of non default leave types
				$leave_array = $this->leaves->leave_bal($uvalue['id'],$year);

				#-------------leave calculation of default leave types
				foreach($default_leave_types as $dkey => $dvalue)
				{						
					$leave_taken = $this->leaves->total_leaves_taken($uvalue['id'],$from_date,$to_date,$dkey);
					$leave_array[$dkey] = array('leave_bal' => "NA",'leaves_taken' => $leave_taken);
				}

				foreach($leave_types as $lkey => $lvalue)
				{
					if(array_key_exists($lvalue['id'], $leave_array))
					{
						if(is_numeric($leave_array[$lvalue['id']]['leave_bal'])){
							$max_leave = $leave_array[$lvalue['id']]['leaves_taken'] + $leave_array[$lvalue['id']]['leave_bal'];
						}
						else{
							$max_leave = $leave_array[$lvalue['id']]['leave_bal'];
						}

						#--------------excel columns
						$this->my_excel->set_data_align($column.$line,NULL);
						$this->my_excel->set_cell_value($column.$line,$max_leave);
						$this->my_excel->set_border('A'.$new_line.':'.$column.$line);
						$column++;
						$this->my_excel->set_data_align($column.$line,NULL);
						$this->my_excel->set_cell_value($column.$line,$leave_array[$lvalue['id']]['leaves_taken']);
						$this->my_excel->set_border('A'.$new_line.':'.$column.$line);
						$column++;
						$this->my_excel->set_data_align($column.$line,NULL);
						$this->my_excel->set_cell_value($column.$line,$leave_array[$lvalue['id']]['leave_bal']);
						$this->my_excel->set_border('A'.$new_line.':'.$column.$line);
						$column++;
					}
					else
					{
						$column++;
						$column++;
						$column++;
					}
				}				
			}
	
			$this->my_excel->set_data_align('A'.$line,NULL);
			$this->my_excel->output_excel();
		}
	}
}