<?php if( ! defined('BASEPATH')) exit('No direct script access allowed');

	class Ledger_monthly_report_excel extends MY_Controller{
		var $excelObj=NULL;
		public function __construct(){
			parent ::__construct();
		}
	   #---------------------------------------------------------------
		public function report(){
			$this->load->library('My_excel');
			$this->load->library('Accounts');
			$ledger_id = $this->uri->segment(4);
			$from_date = $this->uri->segment(5);
			$to_date = $this->uri->segment(6);

			if(!empty($ledger_id) && !empty($from_date) && !empty($to_date)){
				$from_time = strtotime($from_date);
				$to_time = strtotime($to_date);
				$from_year = date('Y',$from_time);
				$to_year = date('Y',$to_time);
				$from_month = date('n',$from_time);
				$to_month = date('n',$to_time);
				$month_array = $this->dms->get_months($from_date,$to_date,1);
				$dc = $this->accounts->get_dc($ledger_id);
				$opening_bal = $this->accounts->opening_bal($ledger_id,$from_date);
				$month_start_date = $from_year."-".$from_month."-01";
				$open_voucher_bal = $this->accounts->voucher_bal($ledger_id,$month_start_date);
				if($dc == 'dr')
				{
					$opening_bal += ($open_voucher_bal['dr_amount'] - $open_voucher_bal['cr_amount']);
				}
				else
				{
					$opening_bal += ($open_voucher_bal['cr_amount'] - $open_voucher_bal['dr_amount']);
				}
				foreach($month_array as $key => $value)
				{											
					$voucher_bal = $this->accounts->voucher_bal($ledger_id,$value['month_to_date'],0,$value['month_from_date']);
					$voucher_array[$key] = array('month' => $value['month'],'dr_amount' => $voucher_bal['dr_amount'],'cr_amount' => $voucher_bal['cr_amount'],'from_date' => $value['from_date'],'to_date' => $value['to_date']);
				}

				#-----------------------excel---------------------------------------
				$head = "Monthly Ledger Wise Report From : ".dateFormat($from_date). ' To : '.dateFormat($to_date);
				$ledger_name = $this->accounts->get_ledger_name($ledger_id);
				$this->my_excel->set_title($head);
				$this->my_excel->set_headline($head);
				$subhead = "Ledger : ".$ledger_name;

				$line = $this->my_excel->get_line();
				$line = $line+1;
				$this->my_excel->merge_cell('A'.$line.':D'.$line);
				$this->my_excel->set_cell_value('A'.$line,$subhead);
				$this->my_excel->set_font_size('A'.$line);
				$this->my_excel->set_bold('A'.$line);

				#get start line  line
				$line = $this->my_excel->report_head_line();
				$this->my_excel->merge_cell('C'.$line.':D'.$line);
				$l = $line+1 ;

				$this->my_excel->merge_cell('E'.$line.':F'.$l);
				//$this->my_excel->merge_cell('E'.$line.':F'.$l);
				$this->my_excel->set_data_align('E'.$line.':E'.$line,"M");
				$this->my_excel->merge_cell('A'.$line.':A'.$l); 
				$this->my_excel->merge_cell('B'.$line.':B'.$l);
	
				//$this->my_excel->merge_cell('F'.$line.':F'.$l);
				$this->my_excel->set_data_align('A'.$line.':A'.$l,"M");
				$this->my_excel->set_data_align('B'.$line.':B'.$l,"M");				

				#first row head
				$headings = array('A'=>'#','B'=>'Particulars','C'=>'Transactions','E'=>'Closing Balance');

				$head_width = array('B'=>50,'C'=>50,'E'=>30,'F'=>5);
				$this->my_excel->set_report_head($headings,array(),$line,4);
				$this->my_excel->set_cell_width($head_width);
				$this->my_excel->set_bg_color_range(5, 'A' . $line);
				#styling heads 
				$line = $line+1;
				#second row width
				$headings = array('C'=>'Debit','D'=>'Credit');
				$head_width = array('C'=>25,'D'=>25,'E'=>30,'F'=>5);
				$this->my_excel->set_report_head($headings,array(),$line,5);
				$this->my_excel->set_cell_width($head_width);
				$this->my_excel->set_bg_color_range(5, 'A' . $line);
				#opening balance row 
				$line = $line+1;
				$i=1;
				#opening balenace row 
				//$this->my_excel->set_cell_value('A'.$line,$i);
				$this->my_excel->set_cell_value('B'.$line,'Opening Balance');
				$this->my_excel->set_data_align('B'.$line,"R");
				if($opening_bal > 0){
					//$opening_bal." ".ucwords($dc);
					$this->my_excel->set_cell_value('E'.$line,$opening_bal);
					$this->my_excel->set_cell_value('F'.$line,ucwords($dc));
					
					//$this->my_excel->set_cell_value('E'.$line,$opening_bal);
					//echo numberFormat($opening_bal)." ".ucwords($dc);
				}elseif($opening_bal < 0){
					if($dc == 'dr'){$dr_cr = "Cr";}else{$dr_cr = "Dr";}
					$this->my_excel->set_cell_value('E'.$line,-$opening_bal);
					$this->my_excel->set_cell_value('F'.$line,$dr_cr);
					//echo numberFormat(-$opening_bal)." ".$dr_cr;
				}
				$this->my_excel->number_format('E'.$line);
				//$this->my_excel->set_data_align('A'.$line);
				$this->my_excel->set_data_align('F'.$line,"L");
				$this->my_excel->set_bold('E'.$line.':F'.$line);
				$line = $line+1;
				$total_dr = $total_cr = 0;
				foreach($voucher_array as $key => $value){
					$this->my_excel->set_cell_value('A'.$line,$i);
					$this->my_excel->set_cell_value('B'.$line,stringFormat($value['month']));
					$this->my_excel->set_cell_value('C'.$line,$value['dr_amount']);
					$this->my_excel->set_cell_value('D'.$line,$value['cr_amount']);
					#calculating closing amount
					$closing_amount = "";
					if($value['dr_amount'] != 0 || $value['cr_amount'] != 0)
					{
						$total_dr += $value['dr_amount'];
						$total_cr += $value['cr_amount'];
						if($dc == 'dr')
						{
							$closing_bal = $value['dr_amount'] - $value['cr_amount'];
							if($closing_bal > 0)
							{
								$closing_amount = $closing_bal;
								$this->my_excel->set_cell_value('E'.$line,$closing_amount);
								$this->my_excel->set_cell_value('F'.$line,"Dr");

							}
							elseif($closing_bal < 0)
							{
								$closing_amount = -$closing_bal;
								$this->my_excel->set_cell_value('E'.$line,$closing_amount);
								$this->my_excel->set_cell_value('F'.$line,"Cr");
							}
						}
						else
						{
							$closing_bal = $value['cr_amount'] - $value['dr_amount'];
							if($closing_bal > 0)
							{
								$closing_amount = $closing_bal;
								$this->my_excel->set_cell_value('E'.$line,$closing_amount);
								$this->my_excel->set_cell_value('F'.$line,"Cr");
							}
							elseif($closing_bal < 0)
							{
								$closing_amount = -$closing_bal;
								$this->my_excel->set_cell_value('E'.$line,$closing_amount);
								$this->my_excel->set_cell_value('F'.$line,"Dr");
							}
						}
					}
					$this->my_excel->number_format('C'.$line.':E'.$line);
					$this->my_excel->set_data_align('A'.$line);
					$this->my_excel->set_data_align('F'.$line,"L");
					$line++;
					$i++;
				}
				#grand total row 
				$this->my_excel->set_cell_value('B'.$line,'Grand Total');
				$this->my_excel->set_data_align('B'.$line,"R");
				$this->my_excel->set_cell_value('C'.$line,$total_dr);
				$this->my_excel->set_cell_value('D'.$line,$total_cr);
				if($dc == 'dr')
				{
					$total_closing = $total_dr - $total_cr;	
					$total_closing += $opening_bal;	
					if($total_closing > 0)
					{
						$total_closing = $total_closing;
						$this->my_excel->set_cell_value('E'.$line,$total_closing);
						$this->my_excel->set_cell_value('F'.$line,"Dr");
					}
					elseif($total_closing < 0)
					{
						$total_closing = -$total_closing;
						$this->my_excel->set_cell_value('E'.$line,$total_closing);
						$this->my_excel->set_cell_value('F'.$line,"Cr");
					}
				}
				else
				{
					$total_closing = $total_cr - $total_dr;
					$total_closing += $opening_bal;
					if($total_closing > 0)
					{
						$total_closing = $total_closing;
						$this->my_excel->set_cell_value('E'.$line,$total_closing);
						$this->my_excel->set_cell_value('F'.$line,"Cr");
					}
					elseif($total_closing < 0)
					{
						$total_closing = -$total_closing;
						$this->my_excel->set_cell_value('E'.$line,$total_closing);
						$this->my_excel->set_cell_value('F'.$line,"Dr");
					}
				}
				$this->my_excel->set_data_align('F'.$line,"L");
				$this->my_excel->number_format('C'.$line.':E'.$line);
				$this->my_excel->set_bold('B'.$line.':F'.$line);
				
				$this->my_excel->set_border('A4:F'.$line);
				$this->my_excel->output_excel();
			}
			else{
				echo "<script>alert('".$this->lang->line('invalid-monthly-ledger-report')."');window.close();</script>";
			}

		}
	   #---------------------------------------------------------------
	} 
?>