<?php if( ! defined('BASEPATH')) exit('No direct script access allowed');

	class Postdated_cheque_excel extends MY_Controller{

		public function __construct(){
			parent ::__construct();
			$this->load->model('postdated_cheque/Postdated_cheque_model','postcheque');
		}
	   #------------------------------------------------------------
		public function report(){
			$this->load->library('My_excel');
			$this->load->library('Accounts');
			$conditions = array('vs.status'=>1,'vbs.cq_status'=>3);
			$like =array();
			if(!empty($this->uri->segment(4))){
				$data = $this->uri->uri_to_assoc(4);

				if(isset($data['from_date']) && $data['from_date']!=''){
					$from_date =date('Y-m-d',strtotime($data['from_date']));
					$conditions['vbs.vdate >='] = $from_date;
					$data['from_date'] = $from_date;
				}

				if(isset($data['to_date']) && $data['to_date']!=''){
					$to_date =date('Y-m-d',strtotime($data['to_date']));
					$conditions['vbs.vdate <='] = $to_date;
					$data['to_date'] = $to_date;
				}
				if(!empty($from_date)&& !empty($to_date)){

					$conditions['vbs.vdate >='] = $from_date;
					$conditions['vbs.vdate <='] = $to_date;
				}

				if(isset($data['vno']) && $data['vno']!=''){
						$like['vs.vno'] =  $data['vno'];
				}
			}
			$p_cheques = $this->postcheque->get_all(array('conditions'=>$conditions,'like'=>$like,'group_by'=>'vs.group_id','order_by'=>'vs.created_on','order'=>'DESC'));
			if(!empty($p_cheques)){
				$head = "Post Dated Cheque Approved Report";
				$this->my_excel->set_title($head);
				$this->my_excel->set_headline($head);
				#get start line  line
				$line = $this->my_excel->report_head_line();

				#first row head
				$headings = array('A'=>'#','B'=>'Voucher Types','C'=>'Voucher No','D'=>'Voucher Date','E'=>'Cheque No','F'=>'Posted Date','G'=>'Approved 0n');
				$head_width = array('B'=>40,'C'=>15,'D'=>30,'E'=>30,'F'=>30,'G'=>30);
				$this->my_excel->set_report_head($headings,array(),$line,NULL);
				$this->my_excel->set_cell_width($head_width);
					$this->my_excel->set_bg_color_range(7, 'A' . $line);
				$i=1;
	            $line = $line+1;
	            foreach ($p_cheques as $key=>$cheque) {
	             	# code...
	             	$this->my_excel->set_cell_value('A'.$line,$i);
	             	$this->my_excel->set_cell_value('B'.$line,stringFormat($this->accounts->voucher_name($cheque['vtype_id'])));
	             	$this->my_excel->set_cell_value('C'.$line,$cheque['vno']);
	             	$this->my_excel->set_cell_value('D'.$line,dateFormat($cheque['vdate']));
	             	$this->my_excel->set_cell_value('E'.$line,$cheque['cd_no']);
	             	$this->my_excel->set_cell_value('F'.$line,dateFormat($cheque['pdc']));
	             	$this->my_excel->set_cell_value('G'.$line,dateFormat($cheque['pdc']));

	             	$this->my_excel->set_data_align('A'.$line);
					$this->my_excel->set_wrap_text('B'.$line);
					$this->my_excel->set_data_align('D'.$line);
					$this->my_excel->set_data_align('F'.$line);
					$this->my_excel->set_data_align('G'.$line);
	             	$i++;
	             	$line++;
	             }
	             $line =$line-1; 
	             $this->my_excel->set_border('A4:G'.$line);
				 $this->my_excel->output_excel();

			}else{
				echo "<script>alert('".$this->lang->line('invalid-postdated-cheque')."');window.close();</script>";
			}

		}
	   #------------------------------------------------------------
	}
?>