<?php if(!defined('BASEPATH')) exit ('No direct script access allowed');

class Purchase_return_excel extends MY_Controller{

	public function __construct(){

		parent ::__construct();
		$this->load->library('My_excel');
	}
	public function purchase_return(){

		$this->load->model('purchase/Purchase_return_model','purchase_obj');
		$this->load->library(array('Stock'));

		$vtype_id = 7;
		$like_array = array();

		#----------dates within financial year
		$cur_date = date('Y-m-d');
		$from_date = $cur_date;
		$to_date = $cur_date;
		$cur_fiscal_yr = $this->dms->get_fiscal_year();
		$presumptive_tax = $this->stock->get_tax_type();
		if($from_date < $cur_fiscal_yr['start_date'] || $from_date > $cur_fiscal_yr['end_date'] || $to_date < $cur_fiscal_yr['start_date'] || $to_date > $cur_fiscal_yr['end_date'])
		{
			$from_date = $cur_fiscal_yr['end_date'];
			$to_date = $cur_fiscal_yr['end_date'];
		}

		#----------uri array
		$uri_array = $this->uri->uri_to_assoc(4);

		if(isset($uri_array['vt']))
		{
			$vtype_id = $uri_array['vt'];
		}
		$conditions['vtype_id'] = $vtype_id;
		$conditions['status'] = 1;
		if(isset($uri_array['fdate']) && isset($uri_array['tdate']))
		{
			$from_date = date('Y-m-d',strtotime($uri_array['fdate']));
			$to_date = date('Y-m-d',strtotime($uri_array['tdate']));
		}

		#----------between condition
		$between = "bill_date between '$from_date' and '$to_date'";

		#----------purchase_return report datas
		$purchase_array=$this->purchase_obj->get_bills(array('conditions' => $conditions,'between' => $between,'order_by'=>'bill_date','order'=>'ASC'));
		if(!empty($purchase_array)){

			$head = "Purchase  Return Report From ".dateFormat($from_date)." To ".dateFormat($to_date);
			$this->my_excel->set_title($head);
			$this->my_excel->set_headline($head,'A','G');
			$line = $this->my_excel->report_head_line();
			$this->my_excel->set_font_size('A'.$line.':G'.$line,12);
			$this->my_excel->set_bold('A'.$line.':G'.$line);
			$this->my_excel->set_column_width('E',35);
			$this->my_excel->set_column_width('A',10);
			$this->my_excel->set_cell_value('A'.$line,'#');
			$this->my_excel->set_column_width('B',15);
			$this->my_excel->set_cell_value('B'.$line,'Date');
			$this->my_excel->set_column_width('C',15);
			$this->my_excel->set_cell_value('C'.$line,'Bill No.');
			$this->my_excel->set_column_width('D',20);
			$this->my_excel->set_cell_value('D'.$line,'Invoice No');
			$this->my_excel->set_column_width('E',35);
			$this->my_excel->set_cell_value('E'.$line,'Vendor');
			$this->my_excel->set_column_width('F',20);
			$this->my_excel->set_cell_value('F'.$line,'Payment Mode');
			$this->my_excel->set_column_width('G',15);
			$this->my_excel->set_cell_value('G'.$line,'Net. Amt.');
			//$this->my_excel->set_bg_color_range('A'.$line,6);
				$this->my_excel->set_bg_color_range(6, 'A' . $line);
			$this->my_excel->set_font_size('A'.$line.':'.'G'.$line,12);
			$this->my_excel->set_bold('A'.$line.':'.'G'.$line);
			$this->my_excel->set_data_align('A'.$line.':'.'G'.$line,NULL);
			#------------------------------------------------------
			$line = $line+1;
			$i=0; $gross_total=0;
			foreach($purchase_array as $key => $value){

				$bill_prefix = $this->stock->get_voucher_prefix($value['vtype_id']);
				$total_amount = 0;  $presum_amount = 0;
				
				$item_details = $this->purchase_obj->get_purchase_items(array('columns' => array('item_id','qty','rate','amount','taxable_amt','vat_amt','cess_amt','discount_per','discount_amt'),'conditions' => array('group_id' => $value['group_id'],'status' => 1)));
				foreach($item_details as $item_key => $item_value):
					$tax_amount = 0;
					$disc_amt = $item_value['discount_amt'];
					$net_value = $item_value['amount']-$disc_amt;
					$taxable = $item_value['taxable_amt'];
					$vat_amt = $item_value['vat_amt'];
					$cess_amt = $item_value['cess_amt'];
					
					$total += $taxable+$vat_amt+$cess_amt;
                    $total_amount += $total;
				endforeach;
				
				$total_amount += ($value['bill_freight']+$value['other_expense']-$value['bill_discount_amt']);
                $gross_total += $total_amount;
                
				$this->my_excel->set_border('A'.$line.':'.'G'.$line);
				$i++;
				$this->my_excel->set_data_align('A'.$line,NULL);
				$this->my_excel->set_cell_value('A'.$line,$i);
				$this->my_excel->set_data_align('B'.$line,NULL);
				$date = dateFormat($value['bill_date']);
				$this->my_excel->set_cell_value('B'.$line,$date);
				$this->my_excel->set_data_align('C'.$line,'L');
				$this->my_excel->set_cell_value('C'.$line,$bill_prefix.' '.$value['bill_no']);
				$this->my_excel->set_data_align('D'.$line,NULL);
				$return_bill_no=$this->purchase_obj->get_bill_no($value['return_bill_no']);
				$this->my_excel->set_cell_value('D'.$line,$return_bill_no);
				$vendor_name=$this->stock->vendor_name($value['vendor_id']);
				$this->my_excel->set_cell_value('E'.$line,$vendor_name);
				$payment_mode=$this->stock->ledger_name($value['payment_mode']);
				$this->my_excel->set_cell_value('F'.$line,$payment_mode);
				$total_amount = get_rounded($total_amount);
				$total_value = $total_value + $total_amount;
				$this->my_excel->number_format('G'.$line);
				$this->my_excel->set_cell_value('G'.$line,$total_amount);
				$line++;
			}
			$this->my_excel->set_bold('A'.$line.':G'.$line);
			$this->my_excel->set_border('A'.$line.':'.'G'.$line);
			$this->my_excel->merge_cell('A'.$line.':'.'F'.$line);
			$this->my_excel->set_cell_value('A'.$line,'Total');
			$this->my_excel->set_data_align('A'.$line,'R');
			$this->my_excel->set_cell_value('G'.$line,$gross_total);
			$this->my_excel->number_format('G'.$line);
			$this->my_excel->output_excel();
		}
	}
}