<?php if(!defined('BASEPATH')) exit ('No direct script access allowed');

class Sales_excel extends MY_Controller{

	public function __construct(){

		parent ::__construct();
		$this->load->library('My_excel');
	}

	public function sales()
	{
		$this->load->model('sales/Sales_model','sales_obj');
		$this->load->model('booking/Booking_model','book_obj');
		$this->load->library(array('Stock'));
		$vtype_id = 6;
		$like_array = array();

		#----------dates within financial year
		$cur_date = date('Y-m-d');
		$from_date = $cur_date;
		$to_date = $cur_date;
		$cur_fiscal_yr = $this->dms->get_fiscal_year();
		if($from_date < $cur_fiscal_yr['start_date'] || $from_date > $cur_fiscal_yr['end_date'] || $to_date < $cur_fiscal_yr['start_date'] || $to_date > $cur_fiscal_yr['end_date'])
		{
			$from_date = $cur_fiscal_yr['end_date'];
			$to_date = $cur_fiscal_yr['end_date'];
		}
		$presumptive_tax = $this->stock->get_tax_type();
		#----------uri array
		$uri_array = $this->uri->uri_to_assoc(4);

		if(isset($uri_array['vt']))
		{
			$vtype_id = $uri_array['vt'];
		}
		$conditions['vtype_id'] = $vtype_id;
		$conditions['status'] = 1;
		if(isset($uri_array['fdate']) && isset($uri_array['tdate']))
		{
			$from_date = date('Y-m-d',strtotime($uri_array['fdate']));
			$to_date = date('Y-m-d',strtotime($uri_array['tdate']));
		}

		#----------between condition
		$between = "bill_date between '$from_date' and '$to_date'";

		$sales_array = $this->sales_obj->get_bills(array('conditions'=>$conditions,'between' => $between,'order_by'=>'bill_date','order'=>'ASC'));
		if(!empty($sales_array))
		{
			#---------------------------------
			$head = "Sales Report From ".dateFormat($from_date)." To ".dateFormat($to_date);
			$this->my_excel->set_title($head);
			$this->my_excel->set_headline($head,'A','I');
			$line = $this->my_excel->report_head_line();
			$this->my_excel->set_font_size('A'.$line.':I'.$line,12);
			$this->my_excel->set_bold('A'.$line.':I'.$line);
			$this->my_excel->set_column_width('E',35);
			$this->my_excel->set_column_width('A',10);
			$this->my_excel->set_cell_value('A'.$line,'#');
			$this->my_excel->set_column_width('B',15);
			$this->my_excel->set_cell_value('B'.$line,'Date');
			$this->my_excel->set_column_width('C',15);
			$this->my_excel->set_cell_value('C'.$line,'Bill No.');
			$this->my_excel->set_column_width('D',35);
			$this->my_excel->set_cell_value('D'.$line,'Customer');
			$this->my_excel->set_column_width('E',15);
			$this->my_excel->set_cell_value('E'.$line,'Net. Amt.');
			$this->my_excel->set_column_width('F',15);
			$this->my_excel->set_cell_value('F'.$line,'Advance Amt.');
			$this->my_excel->set_column_width('G',15);
			$this->my_excel->set_cell_value('G'.$line,'Paid Amt.');
			$this->my_excel->set_column_width('H',20);
			$this->my_excel->set_cell_value('H'.$line,'Payment Mode');
			$this->my_excel->set_column_width('I',20);
			$this->my_excel->set_cell_value('I'.$line,'Salesman Name');
			//$this->my_excel->set_bg_color_range('A'.$line,8);
				$this->my_excel->set_bg_color_range(8, 'A' . $line);
			$this->my_excel->set_font_size('A'.$line.':'.'I'.$line,12);
			$this->my_excel->set_bold('A'.$line.':'.'I'.$line);
			$this->my_excel->set_data_align('A'.$line.':'.'I'.$line,NULL);
			#------------------------------------------------------
			$line = $line+1;
			$i=0; $grand_net=0; $grand_advance=0; $grand_paid=0;
			foreach($sales_array as $key => $value)
			{
				$bill_prefix = $this->stock->get_voucher_prefix($value['vtype_id']);
    		    $total_amount = 0;$total_tax = 0;$presum_amount = 0; $total_taxable = 0; $total_cess = 0; $advance_amt=0; $paid_amt=0;
    
                $item_details = $this->sales_obj->get_sales_items(array('columns' => array('item_id','qty','rate','amount','taxable_amt','discount_amt','vat','vat_amt','cess_amt'),'conditions' => array('group_id' => $value['group_id'],'status' => 1,'item_status >' => 0)));
    
    		    foreach($item_details as $item_key => $item_value):
    			    
    			    $net_value = ($item_value['amount']-$item_value['discount_amt']);                     
                    $taxable = $item_value['taxable_amt'];
                    $vat = $item_value['vat'];
                    $tax_amount = $item_value['vat_amt'];
                    $cess_amount = $item_value['cess_amt'];
                    
                    $total_taxable += $taxable;
                    $total_tax += $tax_amount;
                    $total_cess += $cess_amount;
    			    $total_amount += $taxable+$tax_amount+$cess_amount;
    		    endforeach;
    		                 
                $total_amount += (($value['bill_freight']+$value['other_expense']));
                $paid_amt = $total_amount;
                    
                $conditions1 = array('a.group_id' => $value['group_id'],'a.book_status'=>1);
                $book_array = $this->book_obj->get_sales(array('columns' => array('a.id as primary_id','a.vtype_id','a.branch_id','a.bill_no','a.bill_date','a.group_id','a.customer_type_id','a.customer_id','a.area_id','a.bill_discount_per','a.bill_discount_amt','a.bill_freight','a.other_expense','a.cess','a.narration','a.pricelist_id','a.payment_mode','a.cr_period','a.created_by','a.created_on','a.paid_amount','a.balance_amount','a.doctor','a.delivery_date','b.id','b.item_id','b.qty','b.unit_id','b.rate','b.amount','b.discount_per','b.discount_amt','b.godown_id','b.vat','b.vat_amt'),'conditions' => $conditions1)); 
                if(!empty($book_array))
                {
                    $flag=1;
                    $advance_amt = $book_array[0]['paid_amount'];
                    $paid_amt = $book_array[0]['balance_amount'];
                }
                
                $grand_net += $total_amount;
                $grand_advance += $advance_amt;
                $grand_paid += $paid_amt;

				$this->my_excel->set_border('A'.$line.':'.'I'.$line);
				$i++;
				$this->my_excel->set_data_align('A'.$line,NULL);
				$this->my_excel->set_cell_value('A'.$line,$i);
				$this->my_excel->set_data_align('B'.$line,'C');
				$date = dateFormat($value['bill_date']);
				$this->my_excel->set_cell_value('B'.$line,$date);
				$this->my_excel->set_data_align('C'.$line,'C');
				$this->my_excel->set_cell_value('C'.$line,$bill_prefix.' '.$value['bill_no']);
				$customer_name=$this->stock->get_customer($value['customer_type_id'],$value['customer_id']);
				$this->my_excel->set_cell_value('D'.$line,$customer_name);
				$this->my_excel->set_data_align('E'.$line,'R');
				$this->my_excel->number_format('E'.$line);
				$this->my_excel->set_cell_value('E'.$line,get_rounded($total_amount));
				$this->my_excel->set_data_align('F'.$line,'R');
				$this->my_excel->number_format('F'.$line);
				$this->my_excel->set_cell_value('F'.$line,get_rounded($advance_amt));
				$this->my_excel->set_data_align('G'.$line,'R');
				$this->my_excel->number_format('G'.$line);
				$this->my_excel->set_cell_value('G'.$line,get_rounded($paid_amt));
				$payment_mode="";
				if($value['payment_mode']!='0'){ $payment_mode = $this->stock->ledger_name($value['payment_mode']); }
				$this->my_excel->set_data_align('H'.$line,'C');
				$this->my_excel->set_cell_value('H'.$line,$payment_mode);
				$salesman_name=$this->sales_obj->get_user($value['user_id']);
				$this->my_excel->set_cell_value('I'.$line,$salesman_name);
				$line++;
			} 

			$this->my_excel->set_bold('A'.$line.':I'.$line);
			$this->my_excel->set_border('A'.$line.':'.'I'.$line);
			$this->my_excel->merge_cell('A'.$line.':'.'D'.$line);
			$this->my_excel->set_cell_value('A'.$line,'Grand Total');
			$this->my_excel->set_data_align('A'.$line,'C');
			$this->my_excel->set_cell_value('E'.$line,$grand_net);
			$this->my_excel->number_format('E'.$line);
			$this->my_excel->set_cell_value('F'.$line,$grand_advance);
			$this->my_excel->number_format('F'.$line);
			$this->my_excel->set_cell_value('G'.$line,$grand_paid);
			$this->my_excel->number_format('G'.$line);
			$this->my_excel->output_excel();
		}
	}
	#--------------------------------------------------------------------------------------------------------------------
	public function sales_registry()
	{
		$this->load->model('sales/Sales_model','sales_obj');
		$this->load->library(array('Stock'));

		$vtype_id = 6;
		$like_array = array();

		#----------dates within financial year
		$cur_date = date('Y-m-d');
		$from_date = $cur_date;
		$to_date = $cur_date;
		$cur_fiscal_yr = $this->dms->get_fiscal_year();
		if($from_date < $cur_fiscal_yr['start_date'] || $from_date > $cur_fiscal_yr['end_date'] || $to_date < $cur_fiscal_yr['start_date'] || $to_date > $cur_fiscal_yr['end_date'])
		{
			$from_date = $cur_fiscal_yr['end_date'];
			$to_date = $cur_fiscal_yr['end_date'];
		}
		$presumptive_tax = $this->stock->get_tax_type();
		#----------uri array
		$uri_array = $this->uri->uri_to_assoc(4);

		if(isset($uri_array['vt']))
		{
			$vtype_id = $uri_array['vt'];
		}
		//$conditions['vtype_id'] = $vtype_id;
		$conditions['a.status'] = 1;
		if(isset($uri_array['fdate']) && isset($uri_array['tdate']))
		{
			$from_date = date('Y-m-d',strtotime($uri_array['fdate']));
			$to_date = date('Y-m-d',strtotime($uri_array['tdate']));
		}
		
		if(isset($uri_array['item_group']))
		{
			$item_group = $uri_array['item_group'];
			$conditions['d.item_group_id'] = $item_group;
		}
		
		if(isset($uri_array['vendor_id']))
		{
			$vendor_id = $uri_array['vendor_id'];
			$conditions['c.vendor_id'] = $vendor_id;
		}
		
		if(isset($uri_array['salesman']))
		{
			$salesman = $uri_array['salesman'];
			$conditions['a.user_id'] = $salesman;
		}
		
		if(isset($uri_array['item_id']))
		{
			$item_id = $uri_array['item_id'];
			$conditions['c.item_id'] = $item_id;
		}

		#----------between condition
		$between = "a.bill_date between '$from_date' and '$to_date'";

        $sales_array = $this->sales_obj->get_registry_billss1(array('conditions'=>$conditions,'between' => $between,'order_by'=>'a.bill_date','order'=>'ASC'));
		if(!empty($sales_array))
		{
			#---------------------------------
			$head = "Sales Report From ".dateFormat($from_date)." To ".dateFormat($to_date);
			$this->my_excel->set_title($head);
			$this->my_excel->set_headline($head,'A','G');
			$line = $this->my_excel->report_head_line();
			$this->my_excel->set_font_size('A'.$line.':G'.$line,12);
			$this->my_excel->set_bold('A'.$line.':G'.$line);

			$this->my_excel->set_column_width('A',10);
			$this->my_excel->set_cell_value('A'.$line,'Sl.No.');
			$this->my_excel->set_column_width('B',15);
			$this->my_excel->set_cell_value('B'.$line,'Date');
			$this->my_excel->set_column_width('C',25);
			$this->my_excel->set_cell_value('C'.$line,'Particulars');
			$this->my_excel->set_column_width('D',15);
			$this->my_excel->set_cell_value('D'.$line,'Voucher Type');
			$this->my_excel->set_column_width('E',15);
			$this->my_excel->set_cell_value('E'.$line,'Bill No.');
			$this->my_excel->set_column_width('F',40);
			$this->my_excel->set_cell_value('F'.$line,'Item');
			$this->my_excel->set_column_width('G',15);
			$this->my_excel->set_cell_value('G'.$line,'Quantity');
            $this->my_excel->set_column_width('H',15);
            $this->my_excel->set_cell_value('H'.$line,'Rate');
			$this->my_excel->set_column_width('I',15);
			$this->my_excel->set_cell_value('I'.$line,'Value');
			$this->my_excel->set_column_width('J',15);
			$this->my_excel->set_cell_value('J'.$line,'Discount');
			$this->my_excel->set_column_width('K',15);
			$this->my_excel->set_cell_value('K'.$line,'Taxable Amount');
			$this->my_excel->set_column_width('L',15);
			$this->my_excel->set_cell_value('L'.$line,'CGST Amount');
			$this->my_excel->set_column_width('M',15);
			$this->my_excel->set_cell_value('M'.$line,'SGST Amount');
			$this->my_excel->set_column_width('N',15);
			$this->my_excel->set_cell_value('N'.$line,'CESS Amount');
			$this->my_excel->set_column_width('O',15);
			$this->my_excel->set_cell_value('O'.$line,'Grand Total');
			//$this->my_excel->set_bg_color_range('A'.$line,14);
				$this->my_excel->set_bg_color_range(14, 'A' . $line);
			$this->my_excel->set_font_size('A'.$line.':'.'O'.$line,12);
			$this->my_excel->set_bold('A'.$line.':'.'O'.$line);
			$this->my_excel->set_data_align('A'.$line.':'.'O'.$line,NULL);

			$i=0; $TOTAL_VALUE=0; $TOTAL_DISCOUNT=0; $TOTAL_TAXABLE=0; $TOTAL_CGST=0; $TOTAL_SGST=0; $TOTAL_CESS=0; $TOTAL_AMOUNT=0;
			
			foreach($sales_array as $key => $value)
			{
                $tax =0; $amount=0;
                
                $i++; $line++;

				$bill_prefix = $this->stock->get_voucher_prefix($value['vtype_id']);
				$bill_no = $bill_prefix.' '.$value['bill_no'];
                $item_details = $this->stock->get_item($value['item_id'],array('item_code','item_name'));
    		    $tax = $value['cgst_amt']+$value['sgst_amt'];
    		    $amount = $value['taxable_amt']+$tax+$value['bill_freight']+$value['other_expense'];
    		    
    		    $date = dateFormat($value['bill_date']);
    		    $customer_name=$this->stock->get_customer($value['customer_type_id'],$value['customer_id']);
    		    $item_name = $item_details['item_code']." / ".$item_details['item_name'];
    		    
    		    $TOTAL_VALUE += $value['amount'];
    		    $TOTAL_DISCOUNT += $value['discount_amt'];
    		    $TOTAL_TAXABLE += $value['taxable_amt'];
    		    $TOTAL_CGST += $value['cgst_amt'];
    		    $TOTAL_SGST += $value['sgst_amt'];
    		    $TOTAL_CESS += $value['cess_amt'];
    		    $TOTAL_AMOUNT += $amount;

                $this->my_excel->set_border('A'.$line.':'.'O'.$line);
				$this->my_excel->set_data_align('A'.$line,NULL);
				$this->my_excel->set_cell_value('A'.$line,$i);
				$this->my_excel->set_data_align('B'.$line,NULL);
				$this->my_excel->set_cell_value('B'.$line,$date);
                $this->my_excel->set_data_align('C'.$line,'L');
				$this->my_excel->set_cell_value('C'.$line,$customer_name);
				$this->my_excel->set_data_align('D'.$line,NULL);
				$this->my_excel->set_cell_value('D'.$line,$value['vtype']);
				$this->my_excel->set_data_align('E'.$line,NULL);
				$this->my_excel->set_cell_value('E'.$line,$bill_no);
				$this->my_excel->set_cell_value('F'.$line,$item_name);
				$this->my_excel->set_cell_value('G'.$line,$value['qty']);
                $this->my_excel->number_format('H'.$line.':O'.$line);              
				$this->my_excel->set_cell_value('H'.$line,$value['rate']);
				$this->my_excel->set_cell_value('I'.$line,$value['amount']);
				$this->my_excel->set_cell_value('J'.$line,$value['discount_amt']);
                $this->my_excel->set_cell_value('K'.$line,$value['taxable_amt']);
                $this->my_excel->set_cell_value('L'.$line,$value['cgst_amt']);
                $this->my_excel->set_cell_value('M'.$line,$value['sgst_amt']);
				$this->my_excel->set_cell_value('N'.$line,$value['cess_amt']);
				$this->my_excel->set_cell_value('O'.$line,$amount);
			}
			
			$line++;

            $this->my_excel->set_bold('A'.$line.':O'.$line);
			$this->my_excel->set_border('A'.$line.':'.'O'.$line);
			$this->my_excel->merge_cell('A'.$line.':'.'H'.$line);
			$this->my_excel->set_cell_value('A'.$line,'Total');
			$this->my_excel->set_data_align('A'.$line.':O'.$line,'R');
			
			$this->my_excel->number_format('I'.$line.':O'.$line);      
			$this->my_excel->set_cell_value('I'.$line,$TOTAL_VALUE);
			$this->my_excel->set_cell_value('J'.$line,$TOTAL_DISCOUNT);
            $this->my_excel->set_cell_value('K'.$line,$TOTAL_TAXABLE);
            $this->my_excel->set_cell_value('L'.$line,$TOTAL_CGST);
            $this->my_excel->set_cell_value('M'.$line,$TOTAL_SGST);
			$this->my_excel->set_cell_value('N'.$line,$TOTAL_CESS);
			$this->my_excel->set_cell_value('O'.$line,$TOTAL_AMOUNT);

			$this->my_excel->output_excel();
		}
	}
/*------------------------------------------------------------------------------------------------------------*/	
	public function salesbr()
	{
		$this->load->model('sales/Sales_model','sales_obj');
		$this->load->model('branches/Branch_model','branchmod');
		$this->load->library(array('Stock'));
		$vtype_id = 6;
		$like_array = array();

		#----------dates within financial year
		$cur_date = date('Y-m-d');
		$from_date = $cur_date;
		$to_date = $cur_date;
		$cur_fiscal_yr = $this->dms->get_fiscal_year();
		if($from_date < $cur_fiscal_yr['start_date'] || $from_date > $cur_fiscal_yr['end_date'] || $to_date < $cur_fiscal_yr['start_date'] || $to_date > $cur_fiscal_yr['end_date'])
		{
			$from_date = $cur_fiscal_yr['end_date'];
			$to_date = $cur_fiscal_yr['end_date'];
		}
		$presumptive_tax = $this->stock->get_tax_type();
		#----------uri array
		$uri_array = $this->uri->uri_to_assoc(4);
        if(isset($uri_array['br']))
		{
			$branch_id = $uri_array['br'];
		}
		if(isset($uri_array['vt']))
		{
			$vtype_id = $uri_array['vt'];
		}
		if($branch_id!=0)
		{
		$conditions['branch_id'] = $branch_id;
		}
		$conditions['vtype_id'] = $vtype_id;
		$conditions['status'] = 1;
		if(isset($uri_array['fdate']) && isset($uri_array['tdate']))
		{
			$from_date = date('Y-m-d',strtotime($uri_array['fdate']));
			$to_date = date('Y-m-d',strtotime($uri_array['tdate']));
		}

		#----------between condition
		$between = "bill_date between '$from_date' and '$to_date'";

		$sales_array = $this->sales_obj->get_bills_brnch(array('conditions'=>$conditions,'between' => $between,'order_by'=>'bill_date','order'=>'ASC'));
		if(!empty($sales_array))
		{
			#---------------------------------
			if($branch_id!=0)
			{
			$brname=$this->branchmod->get_full_name($branch_id);
			$head = $brname.":" ."Sales Report From ".dateFormat($from_date)." To ".dateFormat($to_date);
			}
			else
			{
			  
			  $head = "Sales Report From ".dateFormat($from_date)." To ".dateFormat($to_date);
  
			}
			$this->my_excel->set_title($head);
			$this->my_excel->set_headline($head,'A','G');
			$line = $this->my_excel->report_head_line();
			$this->my_excel->set_font_size('A'.$line.':G'.$line,12);
			$this->my_excel->set_bold('A'.$line.':G'.$line);
			$this->my_excel->set_column_width('E',35);
			$this->my_excel->set_column_width('A',10);
			$this->my_excel->set_cell_value('A'.$line,'#');
			$this->my_excel->set_column_width('B',15);
			$this->my_excel->set_cell_value('B'.$line,'Date');
			$this->my_excel->set_column_width('C',15);
			$this->my_excel->set_cell_value('C'.$line,'Bill No.');
			$this->my_excel->set_column_width('D',20);
			$this->my_excel->set_cell_value('D'.$line,'Customer Type');
			$this->my_excel->set_column_width('E',35);
			$this->my_excel->set_cell_value('E'.$line,'Customer');
			$this->my_excel->set_column_width('F',20);
			$this->my_excel->set_cell_value('F'.$line,'Payment Mode');
			$this->my_excel->set_column_width('G',15);
			$this->my_excel->set_cell_value('G'.$line,'Net. Amt.');
			//$this->my_excel->set_bg_color_range('A'.$line,6);
				$this->my_excel->set_bg_color_range(6, 'A' . $line);
			$this->my_excel->set_font_size('A'.$line.':'.'G'.$line,12);
			$this->my_excel->set_bold('A'.$line.':'.'G'.$line);
			$this->my_excel->set_data_align('A'.$line.':'.'G'.$line,NULL);
			#------------------------------------------------------
			$line = $line+1;
			$i=0;$total_value =0;
			foreach($sales_array as $key => $value){

				#--------------- finding total------------------------
				$bill_prefix = $this->stock->get_voucher_prefix($value['vtype_id']);
				$total_amount = 0;$total_tax_amount = 0;$presum_amount = 0; $total_cess_amount=0;

   				$item_details = $this->sales_obj->get_sales_items(array('columns' => array('item_id','qty','rate','amount','taxable_amt','discount_amt','vat','vat_amt','cess_amt'),'conditions' => array('group_id' => $value['group_id'],'status' => 1,'item_status >' => 0)));

				foreach($item_details as $item_key => $item_value):
					$tax_amount = 0;
					$net_value = ($item_value['amount']-$item_value['discount_amt']);
					$taxable = $item_value['taxable_amt'];
					
   					$cgst = $item_value['vat'];
				
				   	$cgstAmt = $item_value['vat_amt'];
				   
				   	$cessAmt = $item_value['cess_amt'];
				   	
				   	$tax_amount = $cgstAmt;
					$total_tax_amount += $tax_amount;
					$total_cess_amount += $cessAmt;
					$total_amount += $taxable;
				endforeach;
				$total_amount += $total_tax_amount+$total_cess_amount;
				$total_amount += (($value['bill_freight']+$value['other_expense']));

				#------------------------------------------

				$this->my_excel->set_border('A'.$line.':'.'G'.$line);
				$i++;
				$this->my_excel->set_data_align('A'.$line,NULL);
				$this->my_excel->set_cell_value('A'.$line,$i);
				$this->my_excel->set_data_align('B'.$line,NULL);
				$date = dateFormat($value['bill_date']);
				$this->my_excel->set_cell_value('B'.$line,$date);
				$this->my_excel->set_data_align('c'.$line,'L');
				$this->my_excel->set_cell_value('C'.$line,$bill_prefix.' '.$value['bill_no']);
				$customer_type=$this->dms->desig_name($value['customer_type_id']);
				$this->my_excel->set_cell_value('D'.$line,$customer_type);
				$customer_name=$this->stock->get_customer($value['customer_type_id'],$value['customer_id']);
				$this->my_excel->set_cell_value('E'.$line,$customer_name);
				$payment_mode=$this->stock->ledger_name($value['payment_mode']);
				$this->my_excel->set_cell_value('F'.$line,$payment_mode);
				$total_amount = get_rounded($total_amount);
				$total_value += $total_amount;
				$this->my_excel->number_format('G'.$line);
				$this->my_excel->set_cell_value('G'.$line,$total_amount);
				$line++;
			}

			$this->my_excel->set_bold('A'.$line.':G'.$line);
			$this->my_excel->set_border('A'.$line.':'.'G'.$line);
			$this->my_excel->merge_cell('A'.$line.':'.'F'.$line);
			$this->my_excel->set_cell_value('A'.$line,'Total');
			$this->my_excel->set_data_align('A'.$line,'R');
			$this->my_excel->set_cell_value('G'.$line,$total_value);
			$this->my_excel->number_format('G'.$line);
			$this->my_excel->output_excel();
		}
	}
	#--------------------------------------------------------------------------------------------------------------------
	
	public function salesbrnmb()
	{
		$this->load->model('booking/Booking_model','book_obj');
        $this->load->model('sales/Sales_model','sales_obj');
		$this->load->model('branches/Branch_model','branchmod');
		$this->load->model('vouchers/Voucher_model','vouchers');
        $this->load->model('users/User_point_model','user_point');
    	$this->load->library(array('Stock','Targets'));
        $this->load->model('products/Item_model','item');
        $this->load->model('purchase/Purchase_model','purchase_obj');
    	//$this->load->library(array('Stock'));
		//$vtype_id = 6;
			echo	$company_id = $this->session->userdata('company_id');

		$like_array = array();

		#----------dates within financial year
		$cur_date = date('Y-m-d');
		$from_date = $cur_date;
		$to_date = $cur_date;
		$cur_fiscal_yr = $this->dms->get_fiscal_year();
		if($from_date < $cur_fiscal_yr['start_date'] || $from_date > $cur_fiscal_yr['end_date'] || $to_date < $cur_fiscal_yr['start_date'] || $to_date > $cur_fiscal_yr['end_date'])
		{
			$from_date = $cur_fiscal_yr['end_date'];
			$to_date = $cur_fiscal_yr['end_date'];
		}
		#----------uri array
		$uri_array = $this->uri->uri_to_assoc(4);
        if(isset($uri_array['br']))
		{
			$branch_id = $uri_array['br'];
		}
		
		
		if(isset($uri_array['fdate']) && isset($uri_array['tdate']))
		{
			$from_date = date('Y-m-d',strtotime($uri_array['fdate']));
			$to_date = date('Y-m-d',strtotime($uri_array['tdate']));
		}

		#----------between condition
		
		for ($i = $from_date; $i <= $to_date; $i += (86400)) 
    		{ 
    		    $idate = date('Y-m-d', $i); 
    		    
    		    #---------------- Booking ----------------
    		    
    		    $book_amount = 0;
				if($branch_id!=0)
			{
			//$brname=$this->branchmod->get_full_name($branch_id);
			//$head = $brname.":" ."Sales Report From ".dateFormat($from_date)." To ".dateFormat($to_date);
			$book_array = $this->db->query("select sum(paid_amount) as collection from dms_booking where bill_date='$idate' and branch_id='$branch_id' and status='1'")->row_array();

			}
			else
			{
			  
			  //$head = "Sales Report From ".dateFormat($from_date)." To ".dateFormat($to_date);
			  $book_array = $this->db->query("select sum(paid_amount) as collection from dms_booking where bill_date='$idate' and status='1'")->row_array();

  
			}
			if($book_array['collection']!='')
                {
                    $book_amount = $book_array['collection'];
                }
                $collection_array[$idate]['book'] = $book_amount;
                $sales_amount = 0;
                if($branch_id!=0)
                {
               // $sales_array = $this->db->query("select sum(vamount) as collection from dms_vouchers where vdate='$idate' and company_id='$this->companyID' and branch_id='$brchname' and table_name='dms_sales' and status='1'")->row_array();
                
                    $sales_array = $this->db->query("select sum(vamount) as collection from dms_vouchers where vdate='$idate' and company_id='$company_id' and branch_id='$branch_id' and vtype_id='6' and status='1'")->row_array();
         
                }
                else
                {
                
                $sales_array = $this->db->query("select sum(vamount) as collection from dms_vouchers where vdate='$idate' and company_id='$company_id'  and vtype_id='6' and status='1'")->row_array();
  
                }
                if($sales_array['collection']!='')
                {
                    $sales_amount = $sales_array['collection'];
                }
                $collection_array[$idate]['sale'] = $sales_amount;
                
                #--------------- purchase ----------------------
                //$purchase_array=$this->purchase_obj->get_bills_brnch(array('conditions' => $conditions,'between' => $between,'order_by'=>'bill_date','order'=>'ASC','item_condition' => $item_id));

                $purchase_amount = 0;
                if($branch_id!=0)
                {
                $purchase_array = $this->db->query("select sum(vamount) as collection from dms_vouchers where vdate='$idate' and company_id='$company_id' and branch_id='$branch_id' and table_name='dms_purchases' and status='1'")->row_array();
                }
                else
                {
                
                $purchase_array = $this->db->query("select sum(vamount) as collection from dms_vouchers where vdate='$idate' and company_id='$company_id'  and table_name='dms_purchases' and status='1'")->row_array();
  
                }
                if($purchase_array['collection']!='')
                {
                    $purchase_amount = $purchase_array['collection'];
                }
                $collection_array[$idate]['purchase'] = $purchase_amount;
				
		}

		//if(!empty($collection_array))
		//{
			#---------------------------------
			if($branch_id!=0)
			{
			$brname=$this->branchmod->get_full_name($branch_id);
			$head = $brname.":" ."Collection Report From ".dateFormat($from_date)." To ".dateFormat($to_date);
			}
			else
			{
			  
			  $head = "Collection Report From ".dateFormat($from_date)." To ".dateFormat($to_date);
  
			}
			$this->my_excel->set_title($head);
			$this->my_excel->set_headline($head,'A','G');
			$line = $this->my_excel->report_head_line();
			$this->my_excel->set_font_size('A'.$line.':G'.$line,12);
			$this->my_excel->set_bold('A'.$line.':G'.$line);
			$this->my_excel->set_column_width('E',35);
			$this->my_excel->set_column_width('A',10);
			$this->my_excel->set_cell_value('A'.$line,'#');
			$this->my_excel->set_column_width('B',15);
			$this->my_excel->set_cell_value('B'.$line,'Date');
			$this->my_excel->set_column_width('C',15);
			$this->my_excel->set_cell_value('C'.$line,'Booking.');
			$this->my_excel->set_column_width('D',20);
			$this->my_excel->set_cell_value('D'.$line,'Sales');
			$this->my_excel->set_column_width('E',35);
			$this->my_excel->set_cell_value('E'.$line,'Purchase');
			$this->my_excel->set_column_width('F',20);
			$this->my_excel->set_cell_value('F'.$line,'Total amt');
			$this->my_excel->set_column_width('G',15);
			$this->my_excel->set_cell_value('G'.$line,'Net. Amt.');
		//	$this->my_excel->set_bg_color_range('A'.$line,6);
			$this->my_excel->set_bg_color_range(6, 'A' . $line);
			$this->my_excel->set_font_size('A'.$line.':'.'G'.$line,12);
			$this->my_excel->set_bold('A'.$line.':'.'G'.$line);
			$this->my_excel->set_data_align('A'.$line.':'.'G'.$line,NULL);
			#------------------------------------------------------
			$line = $line+1;
			$i=0; $total_book_amount = 0; $total_sale_amount = 0; $grand_total_amt =0;$total_purchase_amount =0;

			


				/*foreach($collection_array as $item_key => $value):
					
					$total_amount = 0;
					$i++;
		            $book_amt = $value['book'];
		            $sale_amt = $value['sale'];
		            $pur_amt = $value['purchase'];
		            $total_amt = $book_amt+$sale_amt+$pur_amt;
		            $total_book_amount += $book_amt;
		            $total_sale_amount += $sale_amt;
		            $total_purchase_amount += $pur_amt;
		            $grand_total_amt += $total_amt;
   					
				*/

				#------------------------------------------

				$this->my_excel->set_border('A'.$line.':'.'G'.$line);
				$i++;
				$this->my_excel->set_data_align('A'.$line,NULL);
				$this->my_excel->set_cell_value('A'.$line,$i);
				$this->my_excel->set_data_align('B'.$line,NULL);
				$date = dateFormat($item_key);
				$this->my_excel->set_cell_value('B'.$line,$date);
				$this->my_excel->set_data_align('C'.$line,NULL);

				$this->my_excel->set_cell_value('C'.$line,$book_amt);
				$this->my_excel->set_data_align('D'.$line,NULL);

				$this->my_excel->set_cell_value('D'.$line,$sale_amt);
				$this->my_excel->set_data_align('E'.$line,NULL);

				$this->my_excel->set_cell_value('E'.$line,$pur_amt);
				$this->my_excel->set_data_align('F'.$line,NULL);

				$this->my_excel->set_cell_value('F'.$line,$total_amt);
				
				$line++;
				//endforeach;
			//}

			$this->my_excel->set_bold('A'.$line.':G'.$line);
			$this->my_excel->set_border('A'.$line.':'.'G'.$line);
			$this->my_excel->merge_cell('A'.$line.':'.'F'.$line);
			$this->my_excel->set_cell_value('A'.$line,'Total');
			$this->my_excel->set_data_align('A'.$line,'R');
			$this->my_excel->set_cell_value('G'.$line,$grand_total_amt);
			$this->my_excel->number_format('G'.$line);
			$this->my_excel->output_excel();
		}
	
	
	
	#--------------------------------------------------------------------------------------------------------------------------
}
?>