<?php if(!defined('BASEPATH')) exit ('No direct script access allowed');

class Sales_return_excel extends MY_Controller{

	public function __construct(){

		parent ::__construct();
		$this->load->library('My_excel');
	}

	public function sales_return()
	{
		$this->load->model('sales/Sales_return_model','sales_obj');
		$this->load->library(array('Stock'));

		$vtype_id = 8;
		$like_array = array();

		#----------dates within financial year
		$cur_date = date('Y-m-d');
		$from_date = $cur_date;
		$to_date = $cur_date;
		$cur_fiscal_yr = $this->dms->get_fiscal_year();
		$presumptive_tax = $this->stock->get_tax_type();
		if($from_date < $cur_fiscal_yr['start_date'] || $from_date > $cur_fiscal_yr['end_date'] || $to_date < $cur_fiscal_yr['start_date'] || $to_date > $cur_fiscal_yr['end_date'])
		{
			$from_date = $cur_fiscal_yr['end_date'];
			$to_date = $cur_fiscal_yr['end_date'];
		}

		#----------uri array
		$uri_array = $this->uri->uri_to_assoc(4);

		if(isset($uri_array['vt']))
		{
			$vtype_id = $uri_array['vt'];
		}
		$conditions['vtype_id'] = $vtype_id;
		$conditions['status'] = 1;
		if(isset($uri_array['fdate']) && isset($uri_array['tdate']))
		{
			$from_date = date('Y-m-d',strtotime($uri_array['fdate']));
			$to_date = date('Y-m-d',strtotime($uri_array['tdate']));
		}

		#----------between condition
		$between = "bill_date between '$from_date' and '$to_date'";

		#----------sales_return report datas
		$sales_array=$this->sales_obj->get_bills(array('conditions' => $conditions,'between' => $between,'order_by'=>'bill_date','order'=>'ASC'));
		if(!empty($sales_array))
		{
			#---------------------------------
			$head = "Sales Return Report From ".dateFormat($from_date)." To ".dateFormat($to_date);
			$this->my_excel->set_title($head);
			$this->my_excel->set_headline($head,'A','H');
			$line = $this->my_excel->report_head_line();
			$this->my_excel->set_font_size('A'.$line.':H'.$line,12);
			$this->my_excel->set_bold('A'.$line.':H'.$line);

			$this->my_excel->set_column_width('A',10);
			$this->my_excel->set_cell_value('A'.$line,'#');
			$this->my_excel->set_column_width('B',15);
			$this->my_excel->set_cell_value('B'.$line,'Date');
			$this->my_excel->set_column_width('C',15);
			$this->my_excel->set_cell_value('C'.$line,'Bill No.');
			$this->my_excel->set_column_width('D',15);
			$this->my_excel->set_cell_value('D'.$line,'Invoice No');
			$this->my_excel->set_column_width('E',20);
			$this->my_excel->set_cell_value('E'.$line,'Customer Type');
			$this->my_excel->set_column_width('F',35);
			$this->my_excel->set_cell_value('F'.$line,'Customer');
			$this->my_excel->set_column_width('G',20);
			$this->my_excel->set_cell_value('G'.$line,'Payment Mode');
			$this->my_excel->set_column_width('H',15);
			$this->my_excel->set_cell_value('H'.$line,'Net. Amt.');
			//$this->my_excel->set_bg_color_range('A'.$line,7);
				$this->my_excel->set_bg_color_range(7, 'A' . $line);
			$this->my_excel->set_font_size('A'.$line.':'.'H'.$line,12);
			$this->my_excel->set_bold('A'.$line.':'.'H'.$line);
			$this->my_excel->set_data_align('A'.$line.':'.'H'.$line,NULL);
			$line = $line+1;
			$i=0; $total_grand=0;
			#-----------------------------------------------------
			foreach($sales_array as $key => $value){

				$bill_prefix = $this->stock->get_voucher_prefix($value['vtype_id']);
				$total_amount=0;
				$item_details = $this->sales_obj->get_sales_items(array('columns' => array('item_id','qty','rate','amount','taxable_amt','vat_amt','cess_amt'),'conditions' => array('group_id' => $value['group_id'],'status' => 1)));
				foreach($item_details as $item_key => $item_value):
					$taxable=0; $vatAmt=0; $cessAmt=0;
        			$taxable = $item_value['taxable_amt'];
        			$vatAmt = $item_value['vat_amt'];
        			$cessAmt = $item_value['cess_amt'];
        			
        			$amount = $taxable+$vatAmt+$cessAmt;
    		        $total_amount += $amount;
				endforeach;
				
				$total_amount += ($cess_amount+$value['bill_freight']+$value['other_expense']);
				$total_grand += $total_amount;
				
				$this->my_excel->set_border('A'.$line.':'.'H'.$line);
				$i++;
				$this->my_excel->set_data_align('A'.$line,NULL);
				$this->my_excel->set_cell_value('A'.$line,$i);
				$this->my_excel->set_data_align('B'.$line,NULL);
				$date = dateFormat($value['bill_date']);
				$this->my_excel->set_cell_value('B'.$line,$date);
				$this->my_excel->set_data_align('C'.$line,'L');
				$this->my_excel->set_cell_value('C'.$line,$bill_prefix.' '.$value['bill_no']);
				$this->my_excel->set_data_align('D'.$line,NULL);
				$return_bill_no=$this->sales_obj->get_bill_no($value['return_bill_no']);
				$this->my_excel->set_cell_value('D'.$line,$return_bill_no);
				$customer_type=$this->dms->desig_name($value['customer_type_id']);
				$this->my_excel->set_cell_value('E'.$line,$customer_type);
				$customer_name=$this->stock->get_customer($value['customer_type_id'],$value['customer_id']);
				$this->my_excel->set_cell_value('F'.$line,$customer_name);
				$payment_mode=$this->stock->ledger_name($value['payment_mode']);
				$this->my_excel->set_cell_value('G'.$line,$payment_mode);
				$total_amount = get_rounded($total_amount);
				$total_value = $total_value + $total_amount;
				$this->my_excel->number_format('H'.$line);
				$this->my_excel->set_cell_value('H'.$line,$total_amount);
				$line++;
			}
			$this->my_excel->set_bold('A'.$line.':H'.$line);
			$this->my_excel->set_border('A'.$line.':'.'H'.$line);
			$this->my_excel->merge_cell('A'.$line.':'.'G'.$line);
			$this->my_excel->set_cell_value('A'.$line,'Total');
			$this->my_excel->set_data_align('A'.$line,'R');
			$this->my_excel->set_cell_value('H'.$line,$total_grand);
			$this->my_excel->number_format('H'.$line);
			$this->my_excel->output_excel();
		}
	}
}