<?php if( ! defined('BASEPATH')) exit('No direct script access allowed');

class Vat_detailed_excel extends MY_Controller{

	public function __construct(){

		parent ::__construct();

		$this->load->library(array('My_excel','Tax','Stock'));
	}

	public function index()
	{
		$tax_type = $this->uri->segment(4,0);
		$vat_percent = $this->uri->segment(5,0);
		$from_date = date('Y-m-d',strtotime($this->uri->segment(6)));
		$to_date = date('Y-m-d',strtotime($this->uri->segment(7)));
		
		$vat_per = $vat_percent*2;
		
		if(!empty($from_date) && !empty($to_date) && !empty($tax_type))
		{ 
			$report_name = "GST Classification : ";
			if($tax_type == 1){
				$report_name .= lang('output-vat')." @ ".$vat_per." %";
			}
			elseif($tax_type == 2){
				$report_name .= lang('output-vat')." @ ".$vat_per." % ".lang('transfer-right-use');
			}
			elseif($tax_type == 3){
				$report_name .= lang('input-vat')." @ ".$vat_per." %";
			}
			elseif($tax_type == 4){
				$report_name .= lang('input-vat')." @ ".$vat_per." % ".lang('transfer-right-use');
			}
			elseif($tax_type == 5){
				$report_name .= lang('output-vat')." @ ".$vat_per." %";
			}
			elseif($tax_type == 6){
				$report_name .= lang('output-vat')." @ ".$vat_per." % ".lang('transfer-right-use');
			}
			elseif($tax_type == 7){
				$report_name .= lang('output-vat')." @ ".$vat_per." % ";
			}
			
			$head = $report_name." From : ".dateFormat($from_date). ' To : '.dateFormat($to_date);
			$this->my_excel->set_title($head);
			$this->my_excel->set_headline($head);
			$line = $this->my_excel->get_line();
			$line = $line+1;
			$this->my_excel->merge_cell('A'.$line.':I'.$line);

			#get start line  line
			$line = $this->my_excel->report_head_line();

			#merging and styling for head
			$next_line = $line+1;
			$this->my_excel->merge_cell('A'.$line.':A'.$next_line);
			$this->my_excel->merge_cell('B'.$line.':B'.$next_line);
			$this->my_excel->merge_cell('C'.$line.':C'.$next_line);
			$this->my_excel->merge_cell('D'.$line.':D'.$next_line);
			$this->my_excel->merge_cell('E'.$line.':E'.$next_line);
			$this->my_excel->merge_cell('F'.$line.':F'.$next_line);
			$this->my_excel->merge_cell('G'.$line.':G'.$next_line);
			$this->my_excel->merge_cell('H'.$line.':H'.$next_line);
			$this->my_excel->merge_cell('I'.$line.':I'.$next_line);
			
			$this->my_excel->set_data_align('A'.$line.':A'.$next_line,"M");
			$this->my_excel->set_data_align('B'.$line.':B'.$next_line,"M");
			$this->my_excel->set_data_align('C'.$line.':C'.$next_line,"M");
			$this->my_excel->set_data_align('D'.$line.':D'.$next_line,"M");
			$this->my_excel->set_data_align('E'.$line.':E'.$next_line,"M");
			$this->my_excel->set_data_align('F'.$line.':F'.$next_line,"M");
			$this->my_excel->set_data_align('G'.$line.':G'.$next_line,"M");
			$this->my_excel->set_data_align('H'.$line.':H'.$next_line,"M");
			$this->my_excel->set_data_align('I'.$line.':I'.$next_line,"M");

			#first row head
			$headings = array('A' => '#','B' => lang('voucher-date'),'C' => lang('particulars'),'D' => lang('voucher-type'),'E' => lang('vch-no'),'F' => lang('supplier-invoice-no')." / ".lang('date'),'G' => lang('customer'),'H' => lang('assessable-value'),'I' => lang('tax-amt'));
			$head_width = array('B' => 15,'C' => 40,'D' => 15,'E' => 10,'F' => 20,'G' => 20,'H' => 20,'I' => 20);
			$this->my_excel->set_report_head($headings,array(),$line,NULL);
			$this->my_excel->set_cell_width($head_width);
			$this->my_excel->set_bg_color_range(9, 'A' . $line);

			$i=0;
            $line = 10;

            #-------------voucher details
         
			$voucher_array = $this->tax->getVouchers($tax_type,$vat_percent,$from_date,$to_date);

			if(!empty($voucher_array))
			{
				$total_amount = $total_vat = 0;
				foreach($voucher_array as $vkey => $vvalue)
				{
				    $i++;
					$column = "A";
					$this->my_excel->set_cell_value($column.$line,$i);
					$column++;
					$this->my_excel->set_cell_value($column.$line,dateFormat($vvalue['bill_date']));
					$column++;
					$this->my_excel->set_cell_value($column.$line,$vvalue['ledger_name']);
					$column++;
					$this->my_excel->set_cell_value($column.$line,$vvalue['vtype']);
					$column++;
					$this->my_excel->set_cell_value($column.$line,$vvalue['bill_no']);
					$column++;
					if(isset($vvalue['invoice_no'])){
						$this->my_excel->set_cell_value($column.$line,$vvalue['invoice_no']." / ".dateFormat($vvalue['invoice_date']));
					}
					$column++;
					$this->my_excel->set_cell_value($column.$line,$vvalue['customer']);
					$column++;
					$this->my_excel->set_cell_value($column.$line,$vvalue['amount']);
					$column++;
					$this->my_excel->set_cell_value($column.$line,$vvalue['vat']);
					$line++;
					$total_amount += $vvalue['amount'];
					$total_vat += $vvalue['vat'];
				}

				$this->my_excel->set_data_align('B'.$line,"M");
				$this->my_excel->merge_cell('B'.$line.':G'.$line);
				$this->my_excel->set_bold('B'.$line.":"."I".$line);
				$this->my_excel->set_cell_value('B'.$line,lang('grand-total'));
				$this->my_excel->set_cell_value('H'.$line,$total_amount);
				$this->my_excel->set_cell_value('I'.$line,$total_vat);

				$this->my_excel->set_border('A8:I'.$line);
				$this->my_excel->number_format("G10:I".$line);
				$this->my_excel->set_wrap_text("B8:I".$line);
			}
			$this->my_excel->output_excel(); 
		}else{
			echo "<script>alert('".$this->lang->line('invalid-vat-report')."');window.close();</script>";
		}
	}
}
?>