<?php if( ! defined('BASEPATH')) exit('No direct script access allowed');

class Vat_excel extends MY_Controller{

	public function __construct(){

		parent ::__construct();

		$this->load->library(array('My_excel','Tax','Stock'));
	}

	public function index()
	{
		$from_date = date('Y-m-d',strtotime($this->uri->segment(4)));
		$to_date = date('Y-m-d',strtotime($this->uri->segment(5)));
		$cess = $this->stock->get_cess();

		if(!empty($from_date) && !empty($to_date))
		{
			$head = "GST Computation From : ".dateFormat($from_date). ' To : '.dateFormat($to_date);
			$this->my_excel->set_title($head);
			$this->my_excel->set_headline($head);
			$line = $this->my_excel->get_line();
			$line = $line+1;
			$this->my_excel->merge_cell('A'.$line.':C'.$line);

			#get start line  line
			$line = $this->my_excel->report_head_line();

			#merging and styling for head
			$next_line = $line+1;
			$this->my_excel->merge_cell('A'.$line.':A'.$next_line);
			$this->my_excel->merge_cell('B'.$line.':B'.$next_line);
			$this->my_excel->merge_cell('C'.$line.':C'.$next_line);
			$this->my_excel->merge_cell('D'.$line.':D'.$next_line);
			$this->my_excel->set_data_align('A'.$line.':A'.$next_line,"M");
			$this->my_excel->set_data_align('B'.$line.':B'.$next_line,"M");
			$this->my_excel->set_data_align('C'.$line.':C'.$next_line,"M");
			$this->my_excel->set_data_align('D'.$line.':D'.$next_line,"M");

			#first row head
			$headings = array('A' => '#','B' => lang('particulars'),'C' => lang('assessable-value'),'D' => lang('tax-amt'));
			$head_width = array('B' => 50,'C' => 20,'D' => 20);
			$this->my_excel->set_report_head($headings,array(),$line,NULL);
			$this->my_excel->set_cell_width($head_width);
			$this->my_excel->set_bg_color_range(4, 'A' . $line);

			$i=1;
            $line = 10;
            
            if($taxes = $this->tax->getAllTaxes())
			{
				$total_assessable_sales_val = $total_sales_vat = $total_assessable_purchase_val = $total_purchase_vat = 0;
				$sstatus = $wstatus = $pstatus = 0;
				foreach($taxes as $tkey => $tvalue)
				{
					$sales = $this->tax->getTotalSalesVat($tvalue['vat'],$from_date,$to_date);
					if($sales)
					{
						$column = "B";
						if($sstatus == 0)
						{
							$this->my_excel->set_bold($column.$line);
							$this->my_excel->set_cell_value($column.$line,lang('sales'));
							$line+=2;
							$sstatus = 1;
						}
						$this->my_excel->set_cell_value($column.$line,lang('output-gst')." @ ".($sales['vat']*2)." %");
						$column++;
						$this->my_excel->set_cell_value($column.$line,$sales['amount']);
						$column++;
						$this->my_excel->set_cell_value($column.$line,$sales['vat_amt']);
						$line++;
	
						$total_assessable_sales_val += $sales['amount'];
						$total_sales_vat += $sales['vat_amt'];
					}
					$sales_return = $this->tax->getTotalSalesReturnVat($tvalue['vat'],$from_date,$to_date);
					if($sales_return)
					{
						$column = "B";
						$this->my_excel->set_cell_value($column.$line,lang('output-gst')." @ ".($sales_return['vat']*2)." % ".lang('transfer-right-use'));
						$column++;
						$this->my_excel->set_cell_value($column.$line,$sales_return['amount']);
						$column++;
						$this->my_excel->set_cell_value($column.$line,$sales_return['vat_amt']);
						$line++;
	
						$total_assessable_sales_val += $sales_return['amount'];
					    $total_sales_vat += $sales_return['vat_amt'];
					}
					
				}
				$sales_cess = $this->tax->getTotalSalesCess($cess,$from_date,$to_date);
				if($sales_cess)
				{
					$column = "B";
					if($sstatus == 0)
					{
						$this->my_excel->set_bold($column.$line);
						$this->my_excel->set_cell_value($column.$line,lang('sales'));
						$line+=2;
						$sstatus = 1;
					}
					$this->my_excel->set_cell_value($column.$line,lang('output-cess')." @ ".$cess." %");
					$column++;
					$this->my_excel->set_cell_value($column.$line,$sales_cess['amount']);
					$column++;
					$this->my_excel->set_cell_value($column.$line,$sales_cess['cess_amt']);
					$line++;
					
					$total_sales_vat += $sales_cess['cess_amt'];
				}
					
				if($total_assessable_sales_val != 0)
				{
					$line++;
					$column = "B";
					$this->my_excel->set_bold($column.$line.":"."D".$line);
					$this->my_excel->set_cell_value($column.$line,lang('total-output-tax'));
					$column++;
					$this->my_excel->set_cell_value($column.$line,$total_assessable_sales_val);
					$column++;
					$this->my_excel->set_cell_value($column.$line,$total_sales_vat);
					$line+=2;
				}
				
				foreach($taxes as $tkey => $tvalue)
				{
					$wholesales = $this->tax->getTotalWholesalesVat($tvalue['vat'],$from_date,$to_date);
					if($wholesales)
					{
						$column = "B";
						if($wstatus == 0)
						{
							$this->my_excel->set_bold($column.$line);
							$this->my_excel->set_cell_value($column.$line,lang('whole-sale'));
							$line+=2;
							$wstatus = 1;
						}
						$this->my_excel->set_cell_value($column.$line,lang('output-gst')." @ ".($sales['vat']*2)." %");
						$column++;
						$this->my_excel->set_cell_value($column.$line,$wholesales['amount']);
						$column++;
						$this->my_excel->set_cell_value($column.$line,$wholesales['vat_amt']);
						$line++;
	
						$total_assessable_wholesales_val += $wholesales['amount'];
					    $total_wholesales_vat += $wholesales['vat_amt'];
					}
				}
				if($total_assessable_wholesales_val != 0)
				{
					$line++;
					$column = "B";
					$this->my_excel->set_bold($column.$line.":"."D".$line);
					$this->my_excel->set_cell_value($column.$line,lang('total-output-tax'));
					$column++;
					$this->my_excel->set_cell_value($column.$line,$total_assessable_wholesales_val);
					$column++;
					$this->my_excel->set_cell_value($column.$line,$total_wholesales_vat);
					$line+=2;
				}

				foreach($taxes as $tkey => $tvalue)
				{
					$purchase = $this->tax->getTotalPurchaseVat($tvalue['vat'],$from_date,$to_date);
					if($purchase)
					{
						$column = "B";
						if($pstatus == 0)
						{
							$this->my_excel->set_bold($column.$line);
							$this->my_excel->set_cell_value($column.$line,lang('purchases'));
							$line+=2;
							$pstatus = 1;
						}
						$this->my_excel->set_cell_value($column.$line,lang('input-gst')." @ ".($purchase['vat']*2));
						$column++;
						$this->my_excel->set_cell_value($column.$line,$purchase['amount']);
						$column++;
						$this->my_excel->set_cell_value($column.$line,$purchase['vat_amt']);
						$line++;
	
						$total_assessable_purchase_val += $purchase['amount'];
						$total_purchase_vat += $purchase['vat_amt'];
	                }
	                
					$purchase_return = $this->tax->getTotalPurchaseReturnVat($tvalue['vat'],$from_date,$to_date);
					if($purchase_return)
					{
						$column = "B";
						$this->my_excel->set_cell_value($column.$line,lang('input-vat')." @ ".($purchase_return['vat']*2)." % ".lang('transfer-right-use'));
						$column++;
						$this->my_excel->set_cell_value($column.$line,$purchase_return['amount']);
						$column++;
						$this->my_excel->set_cell_value($column.$line,$purchase_return['vat_amt']);
						$line++;
	
						$total_assessable_purchase_val += $purchase_return['amount'];
						$total_purchase_vat += $purchase_return['vat_amt'];
					}
				}         
				if($total_assessable_purchase_val != 0)
				{
					$line++;
					$column = "B";
					$this->my_excel->set_bold($column.$line.":"."D".$line);
					$this->my_excel->set_cell_value($column.$line,lang('total-input-credit'));
					$column++;
					$this->my_excel->set_cell_value($column.$line,$total_assessable_purchase_val);
					$column++;
					$this->my_excel->set_cell_value($column.$line,$total_purchase_vat);
					$line++;
				}
		
				if($total_assessable_sales_val != 0 || $total_assessable_wholesales_val != 0 || $total_assessable_purchase_val != 0)
				{
					$line++;
					$vat_refund_carry_fwd = abs($total_sales_vat+$total_wholesales_vat-$total_purchase_vat);
					$column = "B";
					$this->my_excel->set_bold($column.$line.":"."D".$line);
					$this->my_excel->set_cell_value($column.$line,lang('vat-refund-carry-forward'));
					$column++;
					$column++;
					$this->my_excel->set_cell_value($column.$line,$vat_refund_carry_fwd);
				}
			} 
			
			$this->my_excel->set_border('A8:D'.$line);
			$this->my_excel->number_format("C10:D".$line);
			$this->my_excel->output_excel();
		}
		else
		{
			echo "<script>alert('".$this->lang->line('invalid-vat-report')."');window.close();</script>";
		}
	}
}
?>