<?php if(!defined('BASEPATH')) exit ('No direct script access allowed');
	
	class Stock_register_excel extends MY_Controller{

		public function __construct(){

			parent ::__construct();

		}
	#-----------------------------------------------------
		public function report(){
			$this->load->library(array('stock','stock_summary','accounts','my_excel'));

			if(!empty($this->uri->segment(4))){

				$data = $this->uri->uri_to_assoc(4);

				if(!empty($data['from_date']) && !empty($data['to_date'])){
					$from_date = $data['from_date'];
					$to_date = $data['to_date'];
					$items = $this->stock_summary->get_items();

					#-----------starting fiscal year details
					$fiscal_details = $this->dms->get_default();

					#-----------stock value type(0 => avg.cost , 1 => last_purchase_cost)
					$stock_value_type = $this->dms->stock_value_type();

					foreach($items as $ikey => $ivalue)
					{
						$item_count = $this->accounts->item_bal_qty_new($ivalue['id'],$fiscal_details['start_date'],$to_date);				
						if($item_count > 0)
						{
							$item_rate = $this->accounts->item_rate($ivalue['id'],$from_date,$to_date,$stock_value_type);
							$unit_name = $this->stock->get_unit_symbol($ivalue['unit_id']);
							$stock_array[$ivalue['id']] = array('item_code' => $ivalue['item_code'],'item_name' => $ivalue['item_name'],'item_count' => $item_count,'item_rate' => $item_rate,'unit' => $unit_name);
						}
					}
					#--------------------------------------------------------------------------------------------------------------------
					$head = "Stock Register: From".dateFormat($data['from_date']). ' To : '.dateFormat($data['to_date']);
					$this->my_excel->set_title($head);
					$this->my_excel->set_headline($head);

					#get start line  line
					$line = $this->my_excel->report_head_line();
					$this->my_excel->merge_cell('C'.$line.':F'.$line);
						#merging and styling for head
					$next_line = $line+1;
					$this->my_excel->merge_cell('C'.$next_line.':D'.$next_line);
					$this->my_excel->merge_cell('A'.$line.':A'.$next_line);
					$this->my_excel->merge_cell('B'.$line.':B'.$next_line);
					$this->my_excel->set_data_align('A'.$line.':A'.$next_line,"M");
					$this->my_excel->set_data_align('B'.$line.':B'.$next_line,"M");

					#first row head
					$headings = array('A'=>'#','B'=>'Particulars','C'=>'Closing Balance');
					$head_width = array('B'=>40,'C'=>50,);
					$this->my_excel->set_report_head($headings,array(),$line,NULL);
					$this->my_excel->set_cell_width($head_width);

					$line = $line+1;
					#second row width
					$headings = array('C'=>'Quantity','D'=>'','E'=>'Rate','F'=>'Value');
					$head_width = array('C'=>25,'D'=>5,'E'=>25,'F'=>25);
					$this->my_excel->set_report_head($headings,array(),$line,5);
					$this->my_excel->set_cell_width($head_width);
					$i=1;
					$line = $line+1;
					$total_qty = 0;$total_value = 0;$unit_status = 1;$unit_temp = "";
					foreach($stock_array as $key => $value){
						$item_value = round_this($value['item_count']*$value['item_rate']);
						$total_qty += $value['item_count'];
						$total_value += $item_value;
						$this->my_excel->set_cell_value('A'.$line,$i);
						$this->my_excel->set_cell_value('B'.$line, stringFormat($value['item_name'])."(".stringFormat($value['item_code']).")");
						$this->my_excel->set_cell_value('C'.$line,$value['item_count']);
						$this->my_excel->set_cell_value('D'.$line,$value['unit']);
						$this->my_excel->set_cell_value('E'.$line,$value['item_rate']);
						$this->my_excel->set_cell_value('F'.$line,$item_value);
						#excel styles
						$this->my_excel->set_data_align('A'.$line);
						$this->my_excel->set_wrap_text('B'.$line);
						$this->my_excel->set_data_align('C'.$line,"R");	
						$this->my_excel->number_format('C'.$line);
						$this->my_excel->number_format('E'.$line);
						$this->my_excel->number_format('F'.$line);
						
						if($unit_temp == ""){
							$unit_temp = $value['unit'];
						}
						if($unit_temp != $value['unit']){
							$unit_status = 0;
						}
						$i++;
						$line++;
					}
					#total value calcularion
					$this->my_excel->merge_cell('A'.$line.':B'.$line);
					$this->my_excel->set_cell_value('A'.$line,'Grand Total');
					$this->my_excel->set_data_align('A'.$line,"R");
					if($unit_status){
						$this->my_excel->set_cell_value('C'.$line,$total_qty);
						$this->my_excel->set_cell_value('D'.$line,$unit_temp);
					}
					$this->my_excel->set_cell_value('F'.$line,$total_value);
					$this->my_excel->number_format('C'.$line);
					$this->my_excel->number_format('F'.$line);
					$this->my_excel->set_bold('A'.$line.':F'.$line);
					$this->my_excel->set_border('A4:F'.$line);
					$this->my_excel->output_excel();	
					//$this->my_excel->output_excel();
					#--------------------------------------------------------------------------------------------------------------------
				}
				else{
					echo "<script>alert('".$this->lang->line('invalid-stock-register')."');window.close();</script>";
				}
			}
			else{
				echo "<script>alert('".$this->lang->line('invalid-stock-register')."');window.close();</script>";
			}
		}
	#-----------------------------------------------------
	}
	?>