<?php if( ! defined('BASEPATH')) exit('No direct script access allowed');
	
	class Products_rate extends MY_Controller{

		public function __construct(){
			parent :: __construct();
			$this->check_access_right();
			$this->load->model('products/product_rate_model','rate');
			
			#---------------- Checking Financial year is enabled / closed-----------------#
			$method_array = array('add','update','delete',);
			fiscal_status($this->uri->segment(2),$method_array,"products_rate/report");	
			#---------------- Checking Financial year is enabled / closed-----------------#	
			
		}
	 	#------------------------------------------------------------------
		public function add(){

			$this->load->model('products/item_model','item');                       
			$item_group_id = NULL;
			$checked = array();
                        $conditions = array();
                        $valid = FALSE;
			if(isset($_POST['submit_one']))
                        { 
				$this->form_validation->set_rules('item_group_id','lang:item-type','required|trim|xss_clean');
                                if($this->form_validation->run() === TRUE)
                                {	                                                                   
                                    $item_group_id = $this->input->post('item_group_id',TRUE);                                 
                                    $conditions['item_group_id'] = $item_group_id;                                    
                                }
                                 $items = $this->item->get_all($conditions); 
                                 $it_rate = array();
                                 foreach($items as $item)
                                 {    
                                      $it_id = $item['id'];                                  
                                      $item_rates=$this->rate->get_item_rate($it_id);                                      
                                      $it_rate["$it_id"] = $item_rates;
                                 }   
//print_r($it_rate);	
			}
                        if(isset($_POST['submit_two']))
                        { 
                                $this->form_validation->set_rules('valid_from','lang:valid-from','required|valid_date|trim|xss_clean');
                                if($this->form_validation->run() === TRUE)
                                {
                                       $valid_from = date('Y_m_d',strtotime($this->input->post('valid_from',TRUE)));
                                       $items1 = $this->item->get_all();
                                       foreach($items1 as $item1)
                                       {
                                             $rate='';
                                                   $item_id = $item1['id'];
                                                   $rate = $_POST["$item1[id]"];
                                                   $data =array();
                                                   $data['item_id'] = $item_id;
                                                   $data['rate']=$rate;
					           $data['valid_from'] = $valid_from;
					           $data['company_id'] = $this->session->userdata('company_id');
                                                   $data['status']=1;
                                                   $data['created_by']=$this->session->userdata('id');

if($rate != '')
{
					           $this->db->insert('dms_item_rates',$data);				 										  
 }                                            
                                      }
                                      $flag = 1;
                                }
                                if($flag == 1)
                                {
				      $this->message->set($this->lang->line('pricelist-saved'),'s');
			        }else{
				      $this->message->set($this->lang->line('pricelist-not-saved'),'e');
		                } 
                         }                       
										  				                                            
			$item_groups = $this->item->item_group_listing();
			$item_groups['']  = 'select';
			ksort($item_groups);

			#template
			$this->template->title($this->lang->line('product-rate-settings'));
			$this->template->main_heading($this->lang->line('product-rate-settings'));
			$this->template->breadcrumb(array($this->lang->line('products')=>'products/add',$this->lang->line('rate')=>'no_link',$this->lang->line('report')=>'products_rate/report'));
			$this->template->slice('dms/message');
			$this->template->slice('products/rate/select_item_type',array('groups'=>$item_groups,'item_group_id'=>$item_group_id,'items'=>$items,'rates'=>$it_rate));
			$this->template->render();
		}

		#------------------------------------------------------------------

		public function report(){

			$conditions=array();
			$this->form_validation->set_rules('item_group_id','lang:item-type','required|trim|xss_clean');
			if($this->form_validation->run() === true || $this->uri->segment(3) == 'group'){
				$group = ($this->input->post('item_group_id'))?$this->input->post('item_group_id',true):$this->uri->segment(4);
				$conditions['im.item_group_id'] = $group;
			}else{
				$group = '';
			}
			$this->load->library('pagination');
			if($this->input->post('item_group_id') ||  $this->uri->segment(3) == 'group' ){
  	 			$config['total_rows'] = $this->rate->get_all(array('order_by'=>'i_rate.id','order'=>'ASC','numrows'=>TRUE,'conditions'=>$conditions));
   	 		}else{
   	 			$config['total_rows'] = $this->rate->get_all(array('order_by'=>'i_rate.id','order'=>'ASC','numrows'=>TRUE));
   	 		} 
	 		
   	 		if($config['total_rows']==0){
   	 			$this->message->set($this->lang->line('no-result-found'),'i');
   	 		}
   	 		$config['per_page'] = $this->per_page();

   	 		if($this->uri->segment(3) == 'group' || $this->input->post('item_group_id')){
				$config['base_url'] = base_url('products_rate/report/group/'.$group);
				$config['uri_segment'] = 5;
				$offset = $this->uri->segment($config['uri_segment'],0);
			}else{
				$config['base_url'] = base_url('products_rate/report');
	   	 		$config['uri_segment'] = 3;
	   	 		$offset = $this->uri->segment($config['uri_segment'],0);
			}
   	 		
   	 		$this->pagination->initialize($config);
   	 		$links = $this->pagination->create_links();
   	 		
   	 		if($this->input->post('item_group_id') ||  $this->uri->segment(3) == 'group' ){
   	 			$rates = $this->rate->get_all(array('group_by'=>'i_rate.item_id','order_by'=>'i_rate.id','order'=>'DESC','limit'=>$config['per_page'],'offset'=>$offset,'conditions'=>$conditions));
   	 		}else{
   	 			$rates = $this->rate->get_all(array('group_by'=>'i_rate.item_id','order_by'=>'i_rate.id','order'=>'DESC','limit'=>$config['per_page'],'offset'=>$offset));
   	 		}

   	 		$this->load->model('products/item_model','item');
			$item_groups = $this->item->item_group_listing();
			$item_groups[' ']  = 'select';
			ksort($item_groups);
			$this->template->title($this->lang->line('product-rate-settings'));
			$this->template->main_heading($this->lang->line('product-rate-settings'));
			$this->template->slice('dms/message');
			$this->template->breadcrumb(array($this->lang->line('products')=>'products/add',$this->lang->line('rate')=>'products_rate/add',$this->lang->line('report')=>'no_link'));
			$this->template->slice('products/rate/report',array('rates'=>$rates,'links'=>$links,'offset'=>$offset,'groups'=>$item_groups,'group'=>$group));
			$this->template->slice('dms/modals/medium_modal');
			$this->template->other_script('products/product_rate');
			$this->template->render();
		}
	 #------------------------------------------------------------------
		public function update($id){

			if(!$this->uri->segment(3)){
				redirect('products_rate/report');
			}
			$rate_id = $this->uri->segment(3);
			if(empty($rate_id)){ redirect('products_rate/report');}
			if($this->if_exists('dms_item_rates',array('id'=>$rate_id,'status'=>1)) === false){
				redirect('products_rate/report');
			}
			#get rate_id details
			$rate = $this->rate->get_all(array('conditions'=>array('i_rate.id'=>$rate_id)))[0];
			#validation 
			$this->form_validation->set_rules('valid_from','lang:valid-from','required|is_date|trim|xss_clean');
			$this->form_validation->set_rules('rate','lang:rate','required');

			if($this->form_validation->run() === TRUE){
				
				$data = $this->input->post(NULL,TRUE);
				$data['valid_from'] = date('Y-m-d',strtotime($data['valid_from']));
				if($this->rate->my_update('dms_item_rates',$data,array('id'=>$rate_id))){
						$this->message->set($this->lang->line('product-rate-updated'));
				}else{
					$this->message->set($this->lang->line('product-rate-not-updated'),'e');
				}
				$call_ck_uri = $this->uri->uri_to_assoc(4);
				redirect($this->uri->assoc_to_uri($call_ck_uri));
			}
			#template
			$this->template->title($this->lang->line('product-rate-settings'));
			$this->template->main_heading($this->lang->line('product-rate-settings'));
			$this->template->slice('dms/message');
			$this->template->breadcrumb(array($this->lang->line('products')=>'products/add',$this->lang->line('rate')=>'products_rate/add',$this->lang->line('update')=>'no_link',$this->lang->line('report')=>'products_rate/report'));
			$this->template->slice('products/rate/update',array('rate'=>$rate));
			$this->template->render();

		}

		#------------------------------------------------------------------

		public function delete(){

			if(!$this->uri->segment(3)){
				redirect('products_rate/report');
			}
			$rate_id  = $this->uri->segment(3);
			if($this->if_exists('dms_item_rates',array('id'=>$rate_id,'status'=>1)) === false){
				redirect('products_rate/report');
			}			
			if(empty($rate_id)){ redirect('products_rate/report');}
			$data['status'] = 0;
			if($this->rate->my_update('dms_item_rates',$data,array('id'=>$rate_id))){
				$this->message->set($this->lang->line('product-rate-deleted'));
 			}else{
 				$this->message->set($this->lang->line('product-rate-not-deleted'));
 			}
 			redirect('products_rate/report');
		}
	
		#------------------------------------------------------------------

		public function check_rate($rate,$item_id){

			if($this->input->post('valid_from',TRUE)){
				$valid_from = date('Y-m-d',strtotime($this->input->post('valid_from',TRUE)));
				$rows = $this->rate->get_all(array('conditions'=>array('i_rate.item_id'=>$item_id,'i_rate.valid_from'=>$valid_from),'numrows'=>TRUE));
				if($rows > 0){
					return false;
				}
				return true;
			}else{
				return $rate;
			}
		}

		#-------------------------------------------------------------------
	}
?>