<?php if(!defined('BASEPATH')) exit ('No direct script access allowed');
	
class Attendance_word extends MY_Controller{

	public function __construct(){

		parent ::__construct();

	}
#-----------------------------------------------------
	public function attendance()
	{
		#----------loading libraries
		$this->load->library(array('My_doc','Leaves'));

		#----------loading models
		$this->load->model('employees/Staff_leave_model','leave');		

		$branch_id = $this->uri->segment(4);
		$year = $this->uri->segment(5);
		$month = $this->uri->segment(6);		
		$from_date = $year."-".$month."-01";
		$to_date = $year."-".$month."-".cal_days_in_month(CAL_GREGORIAN, $month, $year);

		#-----------users of corresponding branch
		$users = $this->dms->get_data(array('table' => 'users as a','join' => array('table' => 'designation_master as b','on' => 'a.designation_id=b.id'),'columns' => array('a.id',"concat(fname,' ',lname) as sname",'b.designation_name'),'conditions' => array('a.id >' => 0,'a.department_id >' => 0,'a.branch_id' => $branch_id,'a.status' => 1,'b.status' => 1)));				
		if(!empty($users))
		{
			foreach($users as $ukey => $uvalue)
			{
				#-------------attendance calculation
				$attendance_array = $this->leaves->attendance_marked($uvalue['id'],$from_date,$to_date);
				$attendance_array['desig'] = $uvalue['designation_name'];
				$attendance_array['sname'] = $uvalue['sname'];
				$user_array[$uvalue['id']] = $attendance_array;
			}

			#Word datas
			$head = "Attendance Report On ".date('F',strtotime($from_date))." ".$year;
			$title = "Attendance_Report_On_".date('F',strtotime($from_date))."_".$year;
			$this->my_doc->set_width(700);
			$table_style = $this->my_doc->table_style();
			$table_tr_style = $this->my_doc->table_tr_style();
			$this->my_doc->set_company_head();
			$this->my_doc->set_headline($head);

			$this->load->view('users/attendance/attendance_word',array('user_array' => $user_array,'table_style'=>$table_style,'table_tr_style'=>$table_tr_style,'title'=>$title));
			$this->my_doc->output_doc($title);				
		}		
	}
}