<?php if(!defined('BASEPATH')) exit ('No direct script access allowed');

	class Sales_return_requests_word extends MY_Controller{

		public function __construct(){

			parent ::__construct();

		}
	#-----------------------------------------------------
	#-----------------------------------------------------
		public function sales_return_requests(){

			$this->load->library('My_doc');
			$this->load->model('purchase/Purchase_return_model','purchase_return');
			$this->load->model('vouchers/Voucher_model','vouchers');
			$this->load->library('Stock');
			$this->branchID = $this->session->userdata('under_id');
			$args = array();
			$args['columns'] = array('id','vtype_id','bill_no','bill_date','return_bill_no','group_id','vendor_id','bill_freight','other_expense','cess','payment_mode','p_status');
			$args['conditions'] = array('vendor_id'=>$this->branchID,'branch_id !='=>$this->branchID,'p_status'=>0,'status'=>1);
			$purchase_returns = $this->purchase_return->get_bills($args);
			$presumptive_tax = $this->stock->get_tax_type();
			$sales_return_requests = array();
			foreach($purchase_returns as $key=>$preturn){
				$total_amount = 0;$total_tax_amount = 0;$presum_amount = 0;
				$args = array();
				$args['columns'] = array('item_id','qty','rate','amount','vat_amt','cst');
				$args['conditions'] = array('group_id' => $preturn['group_id'],'status' => 1);
				$preturn_items = $this->purchase_return->get_purchase_items($args);
				foreach($preturn_items as $priKey => $pitem){
					$tax_amount = 0;
					$net_value = $pitem['amount'];

					if(empty($presumptive_tax)){
						if($pitem['cst'] == 0){
							$vat = $this->stock->get_item_vat($pitem['item_id']);
							$tax_amount = $pitem['vat_amt'];//($vat*$net_value)/100;
						}else{
							$tax_amount = ($pitem['cst']*$net_value)/100;
						}
					}
					$total_tax_amount += $tax_amount;
					$total_amount += $net_value;
				}
				$total_amount += $total_tax_amount;
				if(!empty($presumptive_tax)){
					$presum_amount = ($presumptive_tax[0]*$total_amount)/100;
					$total_amount += $presum_amount;
				}
				$cess_amount = (($total_tax_amount+$presum_amount)*$preturn['cess'])/100;
				$total_amount += ($cess_amount+$preturn['bill_freight']+$preturn['other_expense']);
				$paymentMode = $this->stock->ledger_name($preturn['payment_mode']);
				$sales_return_requests[$preturn['id']] = array('id'=>$preturn['id'],'bill_no'=>$preturn['bill_no'],'bill_date'=>$preturn['bill_date'],'payment_mode'=>$paymentMode,'bill_status'=>$preturn['p_status'],'amount'=>$total_amount);
			}
			if(!empty($sales_return_requests)){
				#Word data datas
				$head = "Sales Return Requests upto ".dateFormat(date('Y-m-d'));
				$title ="Sales_return_requests_upto_".dateFormat(date('Y-m-d'));
				$this->my_doc->set_width(700);
				$table_style = $this->my_doc->table_style();
				$table_tr_style = $this->my_doc->table_tr_style();
				$this->my_doc->set_company_head();
				$this->my_doc->set_headline($head);
				$this->load->view('sales/sales_return/pending_requests_word',array('sales_return_requests'=>$sales_return_requests,'table_style'=>$table_style,'table_tr_style'=>$table_tr_style,'title'=>$title));
				$this->my_doc->output_doc($title);
			}
		}
	}




