<?php if ( ! defined('BASEPATH')) exit('No direct script access allowed');

	class MY_Controller extends CI_Controller{

	#-----------------------------------------------------------------------

		public function __construct(){

			parent :: __construct();
			$this->load->database();
			date_default_timezone_set('Asia/Dubai');
			$this->load->library(array('template','js','session','message','form_validation','dms'));
			$this->load->helper(array('url','template','form','js','html','security','language'));

			#user model & login check
			$this->load->model('users/user_model','user');

			$this->login_check();
			if($this->session->userdata('id') == '-1')
			{
				if($this->session->userdata('company_id'))
				{
					$this->company_check();
				}
			}
			else
			{
				$this->company_check();
			}    
			define('js_path',base_url().'assets/londinium/scripts/');
			define('CAL_FORMAT','d-m-Y');
			define('END_DATE',"-03-31");

			#get app info
			$this->get_app_info();
			$this->get_constants();

			$this->config->load('allowed_access');
			if($this->dms->have_access(315) || $this->dms->have_access(317)){
				$this->template->other_script('notifications/stock_request');
			}
			if($this->dms->have_access(521)){
				$this->template->other_script('notifications/stock_transfer');
			}
			if($this->dms->have_access(475)){
				$this->template->other_script('notifications/my_delivery_notes');
			}
			if($this->dms->have_access(463)){
				$this->template->other_script('notifications/my_purchases');
			}
			if($this->dms->have_access(478)){
				$this->template->other_script('notifications/sales_return_requests');
			}
			if($this->dms->have_access(487)){
				$this->template->other_script('notifications/receipt_ab_requests');
			}
			if($this->dms->have_access(173)){
				$this->template->other_script('notifications/chat_msg_count');
			}
			if($this->dms->have_access(520)){
				$this->template->other_script('notifications/rejection_in_requests');
			}
			if($this->dms->have_access(170)){
			$this->template->other_script('notifications/new_task');
			}

			#for instant notifications
			if($this->dms->branch_type() === false || $this->dms->get_desig($this->session->userdata('id')) == 3){
				$this->template->other_script('credit_limit/credit_limit');
			}
			$this->template->other_script('notifications/new_target');

			#if(in_array($this->session->userdata('user_type'),$this->config->item('notify_task'))){
					//$this->template->other_script('notifications/new_task');
			#}
		}

	#-----------------------------------------------------------------------

		public function login_check(){

			$this->config->load('allowed_access');
			if($this->uri->segment(1) != "android"){
				if(!in_array($this->uri->segment(2),$this->config->item('login'))){
					$loggedIn = $this->user->isLoggedin();
					if(!$loggedIn){
						$this->session->set_flashdata('msg','<div class="alert alert-danger">Please sign in to access the app</div>');
						redirect(base_url().'users/logout');
					}else{
						#load language
						$this->load_language();
					}
				}
			}
			return true;
		}

		#-----------------------------------------------------------------------

		public function get_app_info(){

			$app = $this->db->get('app_info')->row_array();
			define('APP_NAME',$app['app_name']);
			define('APP_VER',$app['app_version']);
			$this->config->load('allowed_access');
			if(!in_array($this->uri->segment(2),$this->config->item('login'))){

				$site = $this->db->select('branch_name')->get_where('branch_master',array('id' => $this->session->userdata('under_id'),'status' => 1))->row_array();
				if(count($site) > 0)
				{
					define('SITE_NAME',substr($site['branch_name'],0,50));
				}else{
					define('SITE_NAME','COMPANY NAME');
				}

			}else{
				define('SITE_NAME',$app['site_name']);
			}
		}

		#-------------------------------------------------------------------------

		public function check_access_right(){

			$controller = $this->uri->segment(1);
			if($this->uri->segment(3) == "v-type" && !empty($this->uri->segment(4))){
				$uri = $this->uri->segment(2)."/".$this->uri->segment(3)."/".$this->uri->segment(4);
			}
			else{
				$uri = $this->uri->segment(2);
			}
			if($controller != 'android' and !in_array($uri,$this->config->item('access'))){
				if(!$this->user->does_user_have_rights($controller,$uri)){
					redirect('access/');
				}
			}
		}

		#--------------------------------------------------------------------------

		public function get_company_id(){

			if($this->uri->segment(1) != 'shops' && $this->uri->segment(2) != ''){
				$row = $this->db->get_where('users',array('id'=>$this->session->userdata('id'),'status'=>1))->row_array();
				if(empty($row)){
					$this->message->set($this->lang->line('set-branch'),'i');
					redirect(base_url('shops/'));
				}else{
					return $row['company_id'];
				}
			}
		}

	#--------------------------------------------------------------------------

		#check whether uri segment is a valid number
		public function check_id($id){

			if(empty($id) || !is_numeric($id)){
				redirect(base_url('access/'));
			}
		}

	#---------------------------------------------------------------------------

		public function load_language(){

			$row = $this->db->select('user_language')->get_where('users',array('id'=>$this->session->userdata('id')))->row_array();
			$language = $row['user_language'];
			$this->lang->load($language,$language);
			$this->config->set_item('language',$language);
		}

	#----------------------------------------------------------------------------

		public function get_constants($columns = NULL){

			if($this->session->userdata('company_id'))
			{
				if($columns == NULL){
					$columns = array('date_format','decimal_place','currency_symbol','rows_per_page','time_for_targets','vat_in_ex','sales_cst','purchase_cst');
				}
				$row = $this->db->select($columns)->get_where('constant_master',array('company_id' => $this->session->userdata('company_id')))->row_array();
				if(!empty($row))
				{
					if(!defined('DATE_FORMAT'))
					{
						define('DATE_FORMAT',$row['date_format']);
						define('CUR_SYMBOL',$row['currency_symbol']);
					}
					return $row;
				}
				return false;
			}
			return false;
		}

	#----------------------------------------------------------------------------

		public function have_access($menu_id){

			if($this->session->userdata('id') != '-1'){
			$total = $this->db->select('id')->get_where('user_privileges',array('owner_id'=>$this->session->userdata('id'),'menu_id'=>$menu_id,'user_group'=>'individual'))->num_rows();
			if($total == 0){
				return false;
			}else{
				return true;
			}
			}else{
				return true;
			}
		}

	#----------------------------------------------------------------------------

		public function per_page(){
			$this->db->cache_on();
			$query = $this->db->select('rows_per_page')->from('constant_master')->get();
			$this->db->cache_off();
			$row = $query->result()[0];
			return $row->rows_per_page;
		}

	#-----------------------------------------------------------------------------

	## Done by	: Ragesh
	## Date		: 2014-10-21
	## purpose	: after deletion ,get last pagination page
	#----------------------------------------------------------------------------

		public function get_next_page($args = array())
		{
			$redirect_url=$args['redirect'];
			if(isset($args['count']) && $args['count'] > 0 && $args['count'] > $this->per_page())
			{
				$next_uri=$args['next_uri'];
				$total_segments=$this->uri->total_segments();
				$last_page=$this->uri->segment($total_segments);
				if(is_numeric($last_page))
				{
					if($next_page >= $args['count'])
					{
						$new_page=$last_page-1;
						if($new_page > 1)
						{
							$uri_string=$this->uri->assoc_to_uri($next_uri);
							if(!empty($uri_string))
							{
								$uri_string=substr($uri_string,0,-(strlen($last_page)));
							}
							else
							{
								$uri_string="/";
							}
							$redirect_url=$redirect_url.$uri_string.$new_page;
							redirect($redirect_url);
						}
						redirect($redirect_url);
					}
					else
					{
						redirect($redirect_url);
					}
				}
				redirect($redirect_url);
			}
			redirect($redirect_url);
		}

	#-----------------------------------------------------------------------------
		#date:28-08-2014
		#purpose:avoid to many connection in database
		function __destruct(){
			$this->db->close();
		}
	#-----------------------------------------------------------------------------

		public function company_check(){
			$this->config->load('allowed_access');
			$this->load->model('companies/company_model','company');

			if($this->uri->segment(1) != 'android'){
			if(!in_array($this->uri->segment(2),$this->config->item('login'))){

				$ary1 = array('company','fiscal');
				$ary2 = array('info','manage','set_default','report','set_default_company');
				if(!in_array($this->uri->segment(1),$ary1) or !in_array($this->uri->segment(2),$ary2)){
					if($this->session->userdata('id')== -1){
						if(empty($this->session->userdata('company_id'))){
							if($this->company->company_count()){
								redirect('company/report');
							}
							else{
								redirect('company/info');
							}
						}
					}
					else{
						if(empty($this->session->userdata('company_id'))){
							if($this->company->company_count()){
								redirect('company/report');
							}
							else{
								redirect('company/info');
							}
						}else if(empty($this->session->userdata('fiscal_yr_id'))){
							$this->message->set($this->lang->line('set-fiscal-year'),'i');
							redirect('fiscal/manage');
						}
					}
				}
			}
		}
		}

#----------------------- Checking Fiscal is enabled or not ----------------------------#
	public function fiscal_check($id = NULL){
		if($this->uri->segment(1) != 'android'){
		if($this->session->userdata('company_id'))
		{
			$this->db->select('id')->from('fiscal_year_master');
			if(empty($id)){
				$this->db->where('status',1);
			}
			else{
				$this->db->where(array('id' => $id,'close_status' => 1));
			}
			return $this->db->get()->num_rows();
		}
		}
		return true;
	}
#----------------------- Checking Fiscal is enabled or not ----------------------------#

#---------------------------Checking row exists or not --------------------------------#
	public function if_exists($table,$conditions){
		$ExistsRow = $this->db->select(array('id'))->get_where($table,$conditions)->row_array();
		if(empty($ExistsRow)){
			return false;
		}else{
			return true;
		}
	}

#------------------------------------------------------------------------------------------------
	#target getting
	public function get_target(){

			if($this->session->userdata('company_id'))
			{
				$row = $this->db->select('time_for_targets')->get_where('constant_master',array('company_id' => $this->session->userdata('company_id')))->row_array();
				return $row['time_for_targets'];
			}
			return false;
		}

	#--------------------------------------------------------------------------------------------

	public function check_access_breadcrumb($accessLink=NULL){

		if($accessLink == 'no_link'){
			return true;
		}else{

			$uriArray = explode('/',$accessLink);
			$totalKeys = count($uriArray);
			if($totalKeys >1){
				$controller = $uriArray[0];
				if($controller != "vat_detailed_reports")
				{
					$uri = $uriArray[1];
					unset($uriArray[0]);
					if(isset($uriArray[2]) && $uriArray[2] =='v-type'){
						$model = $uriArray[1].'/'.$uriArray[2].'/'.$uriArray[3];#implode('/',$uriArray);
					}else{
						$model = $uriArray[1];
					}
					if(!in_array($model,$this->config->item('access'))){
						if(!$this->user->does_user_have_rights($controller,$model)){
							return false;
						}
					}
				}
				else
				{
					return true;
				}
			}
		}
		return true;
	}

	#--------------------------------------------------------------------------------------------
}
?>