<?php if ( ! defined('BASEPATH')) exit('No direct script access allowed');

class MY_Model extends CI_Model{

#----------------------------------------------
 	#date : 18-6-2014
 	#purpose : save data with created-on
 	public function f_save($table,$data){

 		$data['created_on'] = date('Y-m-d H:i:s');
 		$data['created_by'] = $this->session->userdata('id');
 		$this->db->insert($table,$data);
 		return $this->db->insert_id();
 	}

 	#----------------------------------------------

 	#date : 09-07-2014
 	#purpose : save data with financial years
 	public function save_a($table,$data){

 		#get fiscal years
 		$fiscal_yr_id = $this->session->userdata('fiscal_yr_id');
 		$data['fiscal_yr_id'] = $fiscal_yr_id;
 		$data['created_on'] = date('Y-m-d H:i:s');
 		$data['created_by'] = $this->session->userdata('id');
 		$this->db->insert($table,$data);
 		return $this->db->insert_id();
 	}

 	#-----------------------------------------------

 	#date :18-8-2014
 	#purpose : table data updation with created_by & created_on
 	function update_a($args){
 		$args['data']['created_by'] = $this->session->userdata('id');
 		$args['data']['created_on'] = date('Y-m-d H:i:s');
 		return $this->db->update($args['table'],$args['data'],$args['conditions']);
 	}

	#-----------------------------------------------

 	#date :13-12-2014
 	#purpose : table data updation with created_by & created_on
 	function my_update($table,$data,$conditions){
 		$data['created_by'] = $this->session->userdata('id');
 		$data['created_on'] = date('Y-m-d H:i:s');
 		return $this->db->update($table,$data,$conditions);
 	}

 	#-----------------------------------------------
 	public function delete_a($args){
 		$args['data']['created_by'] = $this->session->userdata('id');
 		$args['data']['created_on'] = date('Y-m-d H:i:s');
 		return $this->db->update($args['table'],$args['data'],$args['conditions']);
 	}
 	#-----------------------------------------------

	#date : 06-02-2015
 	#purpose : save  array of data with created-on
 	public function save_batch($table,$data)
 	{
		$array_count = count($data);
		for($i = 0;$i< $array_count;$i++){
			$data[$i]['created_on'] = date('Y-m-d H:i:s');
			$data[$i]['created_by'] = $this->session->userdata('id');
		}
		$this->db->trans_start();
 		$result = $this->db->insert_batch($table,$data);
		$this->db->trans_complete();
		if($result){
			return true;
		}
		return false;
 	}

 	#date : 18-09-2015
 	#purpose : update array of data with created-on
 	public function update_batch($table,$data,$condition)
 	{
		$array_count = count($data);
		for($i = 0;$i< $array_count;$i++){
			$data[$i]['created_on'] = date('Y-m-d H:i:s');
			$data[$i]['created_by'] = $this->session->userdata('id');
		}
		$this->db->trans_start();
 		$result = $this->db->update_batch($table,$data,$condition);
		$this->db->trans_complete();
		if($result){
			return true;
		}
		return false;
 	}
}